unit Setbmap;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, shared, global, sysutils, maths ;

type
  TSetBitmapFrm = class(TForm)
    GroupBox1: TGroupBox;
    edWidth: TEdit;
    Label1: TLabel;
    edHeight: TEdit;
    Label2: TLabel;
    bOK: TButton;
    bCancel: TButton;
    procedure FormShow(Sender: TObject);
    procedure bOKClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  SetBitmapFrm: TSetBitmapFrm;

implementation

{$R *.DFM}

procedure TSetBitmapFrm.FormShow(Sender: TObject);
begin
     edWidth.text := format( '%d pixels', [Settings.BitmapWidth]) ;
     edHeight.text := format( '%d pixels', [Settings.BitmapHeight]) ;
     end;

procedure TSetBitmapFrm.bOKClick(Sender: TObject);
begin
     Settings.BitmapWidth := IntLimitTo( ExtractInt(edWidth.text),
                                         BitMapsMinSize,BitmapsMaxSize);
     Settings.BitmapHeight := IntLimitTo( ExtractInt(edHeight.text),
                                          BitmapsMinSize, BitmapsMaxSize );
     end;

end.
