unit Log;
{ ====================================================
  WinWCP - Display log file text (c) J. Dempster 1996
  ====================================================}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Global, FileIo ;

type
  TLogFrm = class(TForm)
    mmText: TMemo;
    bClose: TButton;
    procedure bCloseClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  LogFrm: TLogFrm;

implementation

{$R *.DFM}
uses MdiForm ;


procedure TLogFrm.bCloseClick(Sender: TObject);
begin
     close ;
     end;

procedure TLogFrm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     { Enable "Inspect Log File" option of "File" menu}
     Main.InspectLogFile.enabled := true ;
     Action := caFree ;
     end;

procedure TLogFrm.FormActivate(Sender: TObject);
begin
     Caption := 'Log File ' + LogFileName ;
     CloseLogFile ;
     mmText.Lines.LoadFromFile( LogFileName ) ;
     OpenLogFile ;
     end;
procedure TLogFrm.FormDeactivate(Sender: TObject);
begin
     CloseLogFile ;
     mmText.Lines.SaveToFile( LogFileName ) ;
     OpenLogFile ;
     end;


procedure TLogFrm.FormCreate(Sender: TObject);
begin
     { Disable "Inspect Log File" option of "File" menu}
     Main.InspectLogFile.enabled := false ;
     end;

end.
