{ $include$="pascal.cfg"
@name@
DriverLINX(tm) Message and Result Codes
@paths@
modules\DriverLINX(tm) Message and Result Codes
modules\all
modules\@./MDL@
@1@
@skip start@}
{****************************************************************************}
{*                                                                          *}
{*     D L C O D E S . P A S - DriverLINX(tm) Message and Result Codes     *}
{*                                                                          *}
{****************************************************************************}

{****************************************************************************}
{*                                                                          *}
{*            (C) Copyright 1991 Scientific Software Tools, Inc.            *}
{*                           All Rights Reserved.                           *}
{*                                                                          *}
{*                      Scientific Software Tools, Inc.                     *}
{*                 Penn State Technology Development Center                 *}
{*                          30 East Swedesford Road                         *}
{*                             Malvern, PA 19355                            *}
{*                    (215) 889-1354  FAX (215) 889-1630                    *}
{*                              DriverLINX(tm)                             *}
{*                                                                          *}
{****************************************************************************}
{@skip end@}
{****************************************************************************
 *      D L C O D E S . P A S    R E V I S I O N   H I S T O R Y
 * @/F1@
 * $Revision:   1.1  $
 * $Log:   G:/SCM/DRVLINX/INCLUDE/DLCODES.PAV  $
 * 
 *    Rev 1.1   08 Sep 1992 13:33:06   Furman
 *    Added following messages
 *      IOValueErr
 *      erTaskAlloc
 *      erBufAlloc
 *      erTimeout              
 *      erInternalTimer
 *      erNoFIFO          
 *      erNoDASRam
 *      erDACLinearity
 *      erADCalibration
 *      erDACalibration
 * 
 * 
 *    Rev 1.0   27 Feb 1992 14:59:54   Furman
 * Initial revision.
 *
 ****************************************************************************}
{@/F2@}
{****************************************************************************
 *                                                            +-------------+
 *  Author: Roy Furman                                        | M O D U L E |
 *  Date:   November, 1991                                    +-------------+
 *
 **************@0@
 * SYNOPSIS:    Definition of Symbolic Messages and Result Code Constants
 *
 * DESCRIPTION: Codes for use with all boards.
 *
 *   Most result codes are standardized for all data acquisition boards
 * supported by the DriverLINX line of Windows DLLs so that an application
 * can respond automatically to various situations.  All DriverLINX functions
 * return 0 (NoErr) on success or a result code in case of error.  Codes are
 * returned both in the result field of the Service Request and as a function
 * value.
 *
 *   The result encodes the error severity and one of the following codes.
 * The status can be returned to DriverLINX for display as a message box, or
 * the application can decode the status using the macros defined below.
 *
 * Error severity levels:
 *      Warning  - errors that do not result in failure of function, such
 *                 as data overruns.
 *      Abort    - Requested function was not performed.  No ongoing functions
 *                 were disturbed.  Request may be repeated after correcting
 *                 the error.
 *      Fatal    - Request was terminated with an unrecoverable error and/or
 *                 data loss.
 *      Internal - Unexpected errors resulting from corruption of device driver
 *                 data or device driver programming errors.
 *
 ****************************************************************************}
{@end@}

unit DLCodes;

interface

const
  { Table of result codes }
  { Following result codes are standardized for all device drivers }

  { General }

NoErr =                     0;  { No error }
InternalErr =               1;  { Internal driver error }
InvalidErrErr =             2;  { Invalid error number }

  { Service Request }

InvalidSRHandleErr =        5;  { Invalid service request handle }
OutOfBoundsErr =           10;  { Invalid service request }
InvalidWinHandleErr =      15;  { Invalid window handle }
ServiceNotSupportedErr =   20;  { Service not supported by driver }
InvalidDeviceNumErr =      25;  { Invalid logical device number }
InvalidSubsystemErr =      30;  { Invalid subsystem requested }
InvalidModeErr =           35;  { Invalid operation mode requested }
InvalidOpErr =             40;  { Invalid operation requested }
InvalidOpFlagsErr =        45;  { Invalid operation flags }
InvalidExtErr =            50;  { Invalid OEM extension handle }
erTaskAlloc =              51;  { Cannot allocate task memory }
NotTaskErr =               55;  { Service request not found }
SystemNotInit =            60;  { Subsystem not initialized }
WindowCreateErr =          65;  { Window creation error }
EditCanceled =             70;  { Edit cancelled }
ConfigureCanceled =        75;  { Configure canceled }

  { Logical Device Descriptors }

UnpairedLDDLockErr =       80;  { Lock/UnlockLDD calls cannot be nested }

  { Messages }

MsgQOverflow =             85;  { Message queue overflowed }

  { Driver and Device }

NOTINIT =                  90;  { Driver not initialized }
DriverBusyErr =            95;  { Driver busy }
NoHardwareErr =           100;  { No hardware detected }
INVADDRESS =              105;  { Invalid hardware base address }
HardwareMismatch =        110;  { Mismatch between hardware and LDD }
HardwareTestErr =         111;  { Hardware failed testing }
DeviceNotInitErr =        115;  { Device not initialized }
DeviceBusyErr =           120;  { Device busy }
DeviceInUse =             125;  { Device in use by another application }

  { Channels }

IllegalStartChan =        130;  { Start Channel is invalid }
IllegalEndChan =          135;  { End Channel is invalid }
StartAboveEnd =           140;  { Start > End not supported }
GAINCODE =                145;  { Illegal gain requested }
NoGainErr =               150;  { Programmable gain not supported }
ChanGainNotSup =          155;  { Channel/Gain List is not supported }
ChanConflict =            160;  { Start/Stop and Channel/Gain list specified }
ChanGainListOvr =         165;  { Channel/Gain list has too few/many entries }
BadChanInList =           170;  { Invalid channel in Channel/Gain list }
BadGainInList =           175;  { Invalid gain in Channel/Gain list }
CyclicConvIllegal =       180;  { Circular conversions not supported }
PermErr =                 185;  { Requested options not supported }
SimulErr =                190;  { Simultaneous I/O not supported }

  { Buffers }

BufNotReqdErr =           195;  { I/O buffers not used }
IOValueErr =              196;  { I/O value not specified }
InvalidBLHandleErr =      200;  { Invalid buffer list handle }
InvalidNBuffer =          205;  { Number of buffers 0 or exceeds limit }
erBufAlloc =              206;  { Cannot allocate memory for buffers }
IncompleteScanErr =       210;  { Buffer does not hold integral # of scans }
InvNConv =                215;  { Invalid # of conversions }
BufAllocErr =             220;  { Memory buffer allocation failed }
BufFreeErr =              225;  { Memory buffer deallocation failed }
NullHandleErr =           230;  { Memory handle is null }
NullPointerErr =          235;  { Memory pointer is null }
NilPointerErr =           240;  { Nil memory pointer }
NoObjForHandleErr =       245;  { Handle does not refer to valid memory object }
NumFormatNotSupported =   250;  { Requested number format not supported }
InvalidNumFormat =        255;  { Unrecognized number format }

  { Critical Section Flags }

NoCritSectErr =           260;  { Multiple critical sections are not supported }
NoCritSectOpt =           265;  { Unrecognized critical section option }
NoCritSectWarn =          270;  { Critical section may cause deadlock }
NoCritSectAllowd =        275;  { Critical section not allowed }
NoCritSectBegin =         280;  { Not in critical section }
NoCritSectNoOp =          285;  { Critical section options will block task }

  { Interrupts }

IntNotSupported =         290;  { Interrupts not supported }
INVIRQ =                  295;  { Invalid interrupt level }
IntInUseErr =             300;  { Interrupt(s) are in use }
IntOvrErr =               305;  { Interrupt overrun }

  { DMA }

DMANotSupported =         310;  { DMA not supported }
INVDMA =                  315;  { Invalid DMA level }
DMAInUseErr =             320;  { DMA channel(s) are in use }
DMAIntActiveErr =         325;  { DMA/Interrupt already active }
DMABufferErr =            330;  { DMA buffer straddles physical page }
VDS_NotContig =           335;  { DMA region not in contiguous memory }
VDS_NotLocked =           340;  { Unable to lock memory pages for DMA }
VDS_NoBuffer =            345;  { No DMA buffer available }
VDS_RegionTooLarge =      350;  { DMA region too large for buffer }
VDS_BufferBusy =          355;  { DMA buffer currently in use }
VDS_RegionInvalid =       360;  { Invalid DMA memory region }
VDS_RegionNotLocked =     365;  { DMA region was not locked }
VDS_TooManyPages =        370;  { Number of physical pages was greater than table length }
VDS_InvalidBufferId =     375;  { Invalid DMA buffer ID }
VDS_CopyOutOfRange =      380;  { Copy out of DMA buffer range }
VDS_InvalidDMAChannel =   385;  { Invalid DMA channel number }
VDS_CountOverflow =       390;  { Disable count overflow }
VDS_CountUnderflow =      395;  { Disable count underflow }
DMANoIntErr =             400;  { Interrupt required for multiple DMA buffering }

  { Events }

EventNotSupErr =          405;  { Requested event not supported for operation }
BadEventErr =             410;  { Invalid event type specified }
TimingEventNotSupErr =    415;  { Requested timing event not supported }
StartEventNotSupErr =     420;  { Requested start event not supported }
StopEventNotSupErr =      425;  { Requested stop event not supported }
EventComboNotSupErr =     430;  { Requested combination of events not supported }

  { Analog Events }

AEvtChnErr =              435;  { Invalid analog event channel }
AEvtGainErr =             440;  { Invalid analog event gain }
AEvtLvlErr =              445;  { Invalid analog event thresholds }

  { Digital Events }

DEvtChnErr =              450;  { Invalid digital event channel }
DigMaskErr =              455;  { Digital mask bits outside hardware range }
DigPatErr =               460;  { Digital pattern bits outside mask range }

  { Time Events }

TEvtChnErr =              465;  { Invalid time event channel }

  { Rate Events }

REvtChnErr =              470;  { Invalid rate event channel }
TimerFuncErr =            475;  { Function not supported by requested timer }
NoConvDelay =             480;  { Conversion delay not specified }
BadTimerChan =            485;  { Counter/timer channel is invalid }
BadTimerDelay =           490;  { Counter value is invalid }
RolloverErr =             495;  { Counter overflow }
InversionWarn =           500;  { Pulse output is inverted }
IntervalNotSupErr =       505;  { Time interval on 1 timer is not supported }
HardwareLimWarn =         510;  { Consult manual for hardware limitations }
OnCountInvalid =          515;  { Pulse on-count > specified period }
BadGateValue =            520;  { Gate value is invalid }
BadClockValue =           525;  { Clock value is invalid }
BadCTModeErr =            530;  { Counter/timer mode is not supported }
GateNotAllowed =          535;  { Counter/timer gate mode not allowed }
NoPulsesErr =             540;  { Requested number of pulses not supported }
NoExtClkErr =             545;  { External clocking required }
NoIntClkErr =             550;  { Internal clocking required }

  { Errors detected during tasks }

ClockingErr =             555;  { Clock rate too fast to process }
SettlingErr =             560;  { Multiplexer settling error }
DataLost =                565;  { Data lost }

  { Errors detected with hardware resources }

erTimeout =               570;  { Hardware timeout }
erInternalTimer =         575;  { Internal timer request failed }
erNoFIFO =                580;  { FIFO not detected }
erNoDASRam =              585;  { On-board RAM not detected }
erDACLinearity =          590;  { DAC linearity test failed }
erADCalibration =         595;  { A/D calibration error }
erDACalibration =         600;  { D/A calibration error }


DRIVERNAME =             $3fff; { Name of DriverLINX }
COPYRIGHT =              $3ffe; { Copyright notice }
DRIVERLINXVERSION =      $3ffd; { Specific version of DriverLINX }

  { Following are vendor codes }

ADVANTECH_LTD =          $2ff0;  { Advantech }
COMPUTER_BOARDS =        $2fe0;  { Computer Boards }
INDUSTRIAL_COMPUTER =    $2fd0;  { Industrial Computer Source }
KEITHLEY_METRABYTE =     $2fc0;  { Keithley MetraByte }
SCIENTIFIC_SOLUTIONS =   $2fb0;  { Scientific Solutions }
SOLTEC =                 $2fa0;  { Soltec }
DATA_TRANSLATION =       $2f90;  { Data Translation }
ADAC_CORPORATION =       $2f80;  { ADAC Corporation }
ANALOGIC =               $2f70;  { Analogic Corporation }

  { Following result codes are OEM specific }

{$I oemcodes.pas}

type
  ErrSeverity = ( Warning, Abort, Fatal, Internal ) ;

  { Create encoded error }
  function Error (severity : ErrSeverity; code : Word) : Word;

  { Return error severity }
  function getErrSeverity (error : Word) : ErrSeverity;

  { Return error code }
  function getErrCode (error : Word) : Word;

implementation

  { Create encoded error }
  function Error (severity : ErrSeverity; code : Word) : Word;
  begin
    Error := ((Word(severity) and 3) shl 14) or (code and $3fff);
  end { Error } ;

  { Return error severity }
  function getErrSeverity (error : Word) : ErrSeverity;
  begin
    getErrSeverity := ErrSeverity(error shr 14);
  end { getErrSeverity } ;

  { Return error code }
  function getErrCode (error : Word) : Word;
  begin
    getErrCode := error and $3fff;
  end { getErrCode } ;

end.

