unit Zero;
{ -----------------------------------------------------------
  WinCDR (c) J.Dempster, University of Strathclyde 1996-97
  ViewWCP channel zero level setup module
  -----------------------------------------------------------}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Global, Mask, Shared, fileio;

type
  TZeroFrm = class(TForm)
    TypeGrp: TGroupBox;
    rbFromRecord: TRadioButton;
    Label1: TLabel;
    Label2: TLabel;
    rbFixed: TRadioButton;
    Label3: TLabel;
    edChannel: TEdit;
    bOK: TButton;
    bCancel: TButton;
    edAtSample: TEdit;
    edNumAveraged: TEdit;
    edLevel: TEdit;
    procedure FormActivate(Sender: TObject);
    procedure bOKClick(Sender: TObject);
    procedure rbFixedClick(Sender: TObject);
    procedure rbFromRecordClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    ChSel : LongInt ;
    NewZeroAt : LongInt ;
  end;

var
  ZeroFrm: TZeroFrm;

implementation

{$R *.DFM}

uses maths ;

procedure TZeroFrm.FormActivate(Sender: TObject);
begin
     edChannel.text := format('Ch.%d %s',[ChSel,Channel[ChSel].ADCName]) ;
     edAtSample.text := IntToStr( NewZeroAt ) ;
     edNumAveraged.text := InttoStr( fH.NumZeroAvg ) ;
     edLevel.text := IntToStr( Channel[ChSel].ADCZero ) ;

     if Channel[ChSel].ADCZeroAt >= 0 then begin
        rbFromRecord.checked := True ;
        edAtSample.enabled := True ;
        edNumAveraged.enabled := True ;
        edLevel.enabled := False ;
        end
     else begin
        rbFixed.checked := True ;
        edLevel.enabled := True ;
        edAtSample.enabled := False ;
        edNumAveraged.enabled := False ;
        end ;
     end ;

procedure TZeroFrm.bOKClick(Sender: TObject);
begin
     if rbFromRecord.checked then begin
          Channel[ChSel].ADCZeroAt := ExtractInt( edAtSample.text ) ;
          Channel[ChSel].ADCZeroAt := MaxInt( [ 0, Channel[ChSel].ADCZeroAt ] ) ;
          Channel[ChSel].ADCZeroAt := MinInt( [fH.NumSamples-1,Channel[ChSel].ADCZeroAt] ) ;
          fH.NumZeroAvg := MaxInt( [1,ExtractInt(edNumAveraged.text)] ) ;
          end
     else begin
          Channel[ChSel].ADCZero := ExtractInt( edLevel.text ) ;
          Channel[ChSel].ADCZero := MaxInt([MinADCValue,Channel[ChSel].ADCZero]) ;
          Channel[ChSel].ADCZero := MinInt([MaxADCValue,Channel[ChSel].ADCZero]) ;
          Channel[ChSel].ADCZeroAt := -1 ;
          end ;
     SaveWCPHeader( fH ) ;
     end;


procedure TZeroFrm.rbFixedClick(Sender: TObject);
begin
        edLevel.enabled := True ;
        edAtSample.enabled := False ;
        edNumAveraged.enabled := False ;
        end;

procedure TZeroFrm.rbFromRecordClick(Sender: TObject);
begin
        edAtSample.enabled := True ;
        edNumAveraged.enabled := True ;
        edLevel.enabled := False ;
        end;

end.
