unit Setaxes;
{ --------------------------------------
  Set plot axes range, labels, and style
  --------------------------------------}

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, Spin, Global, sysutils, shared ;

type
  TSetAxesFrm = class(TForm)
    XAxisGrp: TGroupBox;
    edXlo: TEdit;
    lbXMin: TLabel;
    edXHi: TEdit;
    lbxMax: TLabel;
    edXTic: TEdit;
    Label1: TLabel;
    cbXAxisType: TComboBox;
    YAxisGrp: TGroupBox;
    lbYMin: TLabel;
    lbYMax: TLabel;
    Label4: TLabel;
    edYLo: TEdit;
    edYHi: TEdit;
    EdYTic: TEdit;
    cbYAxisType: TComboBox;
    TraceGrp: TGroupBox;
    ckMarkers: TCheckBox;
    ckLines: TCheckBox;
    bOK: TButton;
    bCancel: TButton;
    LabelsGrp: TGroupBox;
    EdXLab: TEdit;
    Label5: TLabel;
    edYLab: TEdit;
    Label6: TLabel;
    edTitle: TEdit;
    Label7: TLabel;
    edMarkerSize: TEdit;
    EdLineThickness: TEdit;
    procedure bOKClick(Sender: TObject);
    procedure bCancelClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure edXloKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
        procedure UpdateSettings ;
  public
    { Public declarations }
    SetPlot : TPlot ;

  end;

var
  SetAxesFrm: TSetAxesFrm;

implementation

{$R *.DFM}

var
   KeepPageSettings : TPageSettings ;

procedure TSetAxesFrm.FormShow(Sender: TObject);
{ -------------------
  Initialise controls
  -------------------}
begin

     KeepPageSettings := Settings.Plot ;

     edxLo.text :=  format( '%8.3g', [SetPlot.XAxis.Lo] );
     edxHi.text :=  format( '%8.3g', [SetPlot.XAxis.Hi] );
     edxTic.text := format( '%8.3g', [SetPlot.XAxis.Tic] );
     if SetPlot.XAxis.log then cbXAxisType.itemindex := 1
                          else cbXAxisType.itemindex := 0 ;

     edyLo.text :=  format( '%8.3g', [SetPlot.yAxis.Lo] );
     edyHi.text :=  format( '%8.3g', [SetPlot.yAxis.Hi] );
     edyTic.text := format( '%8.3g', [SetPlot.yAxis.Tic] );
     if SetPlot.YAxis.log then cbYAxisType.itemindex := 1
                       else cbYAxisType.itemindex := 0 ;

     EdXLab.text := SetPlot.XAxis.lab ;
     EdYLab.text := SetPlot.YAxis.lab ;
     EdTitle.text := SetPlot.title ;

     edMarkerSize.text := format( ' %d pts', [Settings.Plot.MarkerSize] ) ;
     edLineThickness.text := format( ' %d pts', [Settings.Plot.LineThickness] ) ;

     ckLines.checked := Settings.Plot.ShowLines ;
     ckMarkers.checked := Settings.Plot.ShowMarkers ;

end;


procedure TSetAxesFrm.UpdateSettings ;
{ --------------------
  Update plot settings
  --------------------}
begin
     { X Axis }
     SetPlot.XAxis.Lo := ExtractFloat( edXlo.text, SetPlot.XAxis.Lo ) ;
     edXlo.text := format(' %.3g ',[SetPlot.XAxis.Lo]) ;
     SetPlot.XAxis.Hi := ExtractFloat( edXHi.text, SetPlot.XAxis.Hi ) ;
     edXHi.text := format(' %.3g ',[SetPlot.XAxis.Hi]) ;
     SetPlot.XAxis.Tic := ExtractFloat( edXTic.text, SetPlot.XAxis.Tic ) ;
     edXTic.text := format(' %.3g ',[SetPlot.XAxis.Tic]) ;
     if cbXAxisType.itemIndex = 0 then SetPlot.XAxis.log := false
                                  else SetPlot.XAxis.log := True ;
     { Y Axis }
     SetPlot.YAxis.Lo := ExtractFloat( edYlo.text, SetPlot.YAxis.Lo ) ;
     edYlo.text := format(' %.3g ',[SetPlot.YAxis.Lo]) ;
     SetPlot.YAxis.Hi := ExtractFloat( edYHi.text, SetPlot.YAxis.Hi ) ;
     edYhi.text := format(' %.3g ',[SetPlot.YAxis.Hi]) ;
     SetPlot.YAxis.Tic := ExtractFloat( edYTic.text, SetPlot.YAxis.Tic ) ;
     edYTic.text := format(' %.3g ',[SetPlot.YAxis.Tic]) ;
     if cbYAxisType.itemIndex = 0 then SetPlot.YAxis.log := false
                                  else SetPlot.YAxis.log := True ;
     { Labels }
     SetPlot.XAxis.Lab := edXLab.text ;
     SetPlot.YAxis.Lab := edYLab.text ;
     SetPlot.Title := edTitle.text ;

     { Markers and lines }
     Settings.Plot.MarkerSize := ExtractInt(edMarkerSize.text) ;
     edMarkerSize.text := format(' %d pts',[Settings.Plot.MarkerSize]) ;

     Settings.Plot.LineThickness := ExtractInt(edLineThickness.text) ;
     edLineThickness.text := format(' %d pts',[Settings.Plot.LineThickness]);

     Settings.Plot.ShowLines :=  ckLines.checked ;
     Settings.Plot.ShowMarkers := ckMarkers.checked ;

     end ;


procedure TSetAxesFrm.bOKClick(Sender: TObject);
begin
     UpdateSettings ;
     end;

procedure TSetAxesFrm.bCancelClick(Sender: TObject);
begin
     Settings.Plot := KeepPageSettings ;
     end;




procedure TSetAxesFrm.edXloKeyPress(Sender: TObject; var Key: Char);
begin
     if key = chr(13) then UpdateSettings ;
     end;

end.
