unit PrintRec;
{ =================================================================
  WinCDR - Printer page/font setup form for printing signal records
  2/5/97 ... Calibration bar values only shown for enabled channels
  26/6/98 ... Text boxes updates now grouped together in UpdateSettings
  =================================================================}
interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls,Printers,Global,Shared, Grids, SysUtils, Spin, fileio,
  PlotLib ;

type
  TPrintRecFrm = class(TForm)
    GroupBox1: TGroupBox;
    edLeftMargin: TEdit;
    Label1: TLabel;
    edTopMargin: TEdit;
    Label2: TLabel;
    edRightMargin: TEdit;
    Label3: TLabel;
    edBottomMargin: TEdit;
    Label4: TLabel;
    GroupBox2: TGroupBox;
    CalibrationBarTable: TStringGrid;
    GroupBox3: TGroupBox;
    Label5: TLabel;
    GroupBox5: TGroupBox;
    ckShowZeroLevels: TCheckBox;
    ckShowLabels: TCheckBox;
    bPrint: TButton;
    bCancel: TButton;
    ckUseColor: TCheckBox;
    FontGrp: TGroupBox;
    Label7: TLabel;
    cbFontName: TComboBox;
    edFontSize: TEdit;
    edLineThickness: TEdit;
    procedure bPrintClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure edFontSizeKeyPress(Sender: TObject; var Key: Char);
    procedure cbFontNameChange(Sender: TObject);
    procedure ckShowLabelsClick(Sender: TObject);
    procedure CalibrationBarTableKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
    procedure UpdateSettings ;
  public
    { Public declarations }
  end;



var
  PrintRecFrm: TPrintRecFrm;

implementation

{$R *.DFM}
uses MDIform ;
var
   Initialised : Boolean ;

procedure TPrintRecFrm.FormShow(Sender: TObject);
{ --------------------------------
  Initialise Print Record(s) form
  -------------------------------}
var
   n,ch,Row : Integer ;
begin

     { Fill Fonts list with typefaces available to printer }
     cbFontName.items := printer.fonts ;

     { Set Column widths }
     CalibrationBarTable.colwidths[0] := Canvas.TextWidth('XXXXX') ;
     CalibrationBarTable.colwidths[1] := Canvas.TextWidth('XXXXXXXXX') ;

     CalibrationBarTable.options := [goEditing,goHorzLine,goVertLine] ;
     CalibrationBarTable.RowCount := CdrfH.NumChannels + 1 ;
     CalibrationBarTable.cells[0,0] := 'Time ';

     { Adjust number of rows to number of enabled channels }
      n := 1 ;
      for ch := 0 to CdrfH.NumChannels-1 do if Channel[ch].InUse then Inc(n) ;
      CalibrationBarTable.RowCount := n ;

      { Update text box settings }
      Initialised := False ;
      UpdateSettings ;

     { Ensure calibration bars have focus when dialog box opens }
     CalibrationBarTable.SetFocus ;

     end;


procedure TPrintRecFrm.UpdateSettings ;
{ -----------------------------------
  Update text box/Settings parameters
  -----------------------------------}
var
   Row,ch : Integer ;
begin
     { Set printer typeface and size }
     { Top margin }
     if Initialised then Settings.Plot.TopMargin := ExtractFloat(edTopMargin.text,
                                                    Settings.Plot.TopMargin) ;
     edTopMargin.text := format( ' %.1f cm',[Settings.Plot.TopMargin]);

     { Bottom margin }
     if Initialised then Settings.Plot.BottomMargin := ExtractFloat(edBottomMargin.text,
                                                       Settings.Plot.BottomMargin) ;
     edBottomMargin.text := format( ' %.1f cm',[Settings.Plot.BottomMargin]);

     { Left margin }
     if Initialised then Settings.Plot.LeftMargin := ExtractFloat(edLeftMargin.text,
                                                     Settings.Plot.LeftMargin) ;
     edLeftMargin.text := format( ' %.1f cm',[Settings.Plot.LeftMargin]);

     { Right margin }
     if Initialised then Settings.Plot.RightMargin := ExtractFloat(edRightMargin.text,
                                                      Settings.Plot.RightMargin) ;
     edRightMargin.text := format( ' %.1f cm',[Settings.Plot.RightMargin]);

     { Line thickness }
     if Initialised then Settings.Plot.LineThickness := ExtractInt(edLineThickness.text) ;
     edLineThickness.text := format( ' %d pts',[Settings.Plot.LineThickness]);

     { Font name }
     if Initialised then Settings.Plot.FontName := cbFontName.text ;
     cbFontName.itemindex := cbFontName.items.indexof(Settings.Plot.FontName) ;
     if cbFontName.itemindex < 0 then  cbFontName.itemindex := 0 ;

     { Font size (points) }
     if Initialised then Settings.Plot.FontSize := ExtractInt(edFontSize.text) ;
     edFontSize.text := format( ' %d pts',[Settings.Plot.FontSize]);

     { Show label on plot }
     if Initialised then Settings.ShowLabels := ckShowLabels.checked ;
     ckShowLabels.checked := Settings.ShowLabels ;

     { Show zero levels }
     if Initialised then Settings.ShowZeroLevels := ckShowZeroLevels.checked ;
     ckShowZeroLevels.checked := Settings.ShowZeroLevels ;

     { Use colour }
     if Initialised then Settings.Plot.UseColor := ckUseColor.checked ;
     ckUseColor.checked := Settings.Plot.UseColor ;

     { Time calibration bar }
     if Initialised then Settings.TimeBarValue := ExtractFloat(
                                               CalibrationBarTable.cells[1,0], 1. )
                                               * Settings.TUnscale ;
     CalibrationBarTable.cells[1,0] := Format( '%.4g %s',
                                       [Settings.TimeBarValue*Settings.TScale,
                                        Settings.TUnits])  ;

     { Channel calibration bars }
     Row := 1 ;
     for ch := 0 to CdrfH.NumChannels-1 do if Channel[ch].InUse then begin
         if Initialised then Settings.BarValue[ch] := ExtractFloat(
                                            CalibrationBarTable.Cells[1,Row],10. ) ;
         CalibrationBarTable.cells[0,Row] := Channel[ch].ADCName ;
         CalibrationBarTable.cells[1,Row] := Format( '%.4g %s',
                                              [Settings.BarValue[ch],
                                               Channel[ch].ADCUnits]) ;
         Inc(Row) ;
         end ;

     Initialised := True ;

     end ;


procedure TPrintRecFrm.bPrintClick(Sender: TObject);
{ -----------------------
  Update global settings
  ----------------------}
begin
     UpdateSettings ;
     end ;


procedure TPrintRecFrm.edFontSizeKeyPress(Sender: TObject; var Key: Char);
begin
     if key = chr(13) then UpdateSettings ;
     end;

procedure TPrintRecFrm.cbFontNameChange(Sender: TObject);
begin
     UpdateSettings ;
     end;

procedure TPrintRecFrm.ckShowLabelsClick(Sender: TObject);
begin
     UpdateSettings ;
     end;

procedure TPrintRecFrm.CalibrationBarTableKeyPress(Sender: TObject;
  var Key: Char);
begin
     if key = chr(13) then UpdateSettings ;
     end;

end.
