unit Printgra;
{ =======================================================
  Updates printer page settings in Settings.Plot
  =======================================================}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, Buttons, Global, Printers, Shared ;

type
  TPrintGraphFrm = class(TForm)
    GroupBox1: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    edLeftMargin: TEdit;
    edTopMargin: TEdit;
    edRightMargin: TEdit;
    edBottomMargin: TEdit;
    bOK: TButton;
    bCancel: TButton;
    procedure FormShow(Sender: TObject);
    procedure bOKClick(Sender: TObject);
    procedure edRightMarginKeyPress(Sender: TObject; var Key: Char);
    procedure edTopMarginKeyPress(Sender: TObject; var Key: Char);
    procedure edBottomMarginKeyPress(Sender: TObject; var Key: Char);
    procedure edLeftMarginKeyPress(Sender: TObject; var Key: Char);
    procedure bCancelClick(Sender: TObject);
  private
    { Private declarations }
    KeepSettings : TPageSettings ;
  public
    { Public declarations }

  end;

var
  PrintGraphFrm: TPrintGraphFrm;

implementation

{$R *.DFM}


procedure TPrintGraphFrm.FormShow(Sender: TObject);
begin
     KeepSettings := Settings.Plot ;
     edTopMargin.text := format( '%.1f cm',[Settings.Plot.TopMargin]);
     edBottomMargin.text := format( '%.1f cm',[Settings.Plot.BottomMargin]);
     edLeftMargin.text := format( '%.1f cm',[Settings.Plot.LeftMargin]);
     edRightMargin.text := format( '%.1f cm',[Settings.Plot.RightMargin]);
     UpdateSettings ;
     end;


procedure TPrintGraphFrm.UpdateSettings ;
{ ---------------------------
  Update page margin settings
  ---------------------------}
begin
     { Top of page margin }
     Settings.Plot.TopMargin := ExtractFloat(edTopMargin.text,
                                Settings.Plot.TopMargin) ;
     edTopMargin.text := format( '%.1f cm',[Settings.Plot.TopMargin]);

     { Bottom of page margin }
     Settings.Plot.BottomMargin := ExtractFloat(edBottomMargin.text,
                                   Settings.Plot.BottomMargin) ;
     edBottomMargin.text := format( '%.1f cm',[Settings.Plot.BottomMargin]);

     { Left page margin }
     Settings.Plot.LeftMargin := ExtractFloat(edLeftMargin.text,
                                 Settings.Plot.LeftMargin) ;
     edLeftMargin.text := format( '%.1f cm',[Settings.Plot.LeftMargin]);

     { Right page margin }
     Settings.Plot.RightMargin := ExtractFloat(edRightMargin.text,
                                  Settings.Plot.RightMargin) ;
     edRightMargin.text := format( '%.1f cm',[Settings.Plot.RightMargin]);
     end ;


procedure TPrintGraphFrm.bOKClick(Sender: TObject);
begin
     UpdateSettings ;
     end;


procedure TPrintGraphFrm.edRightMarginKeyPress(Sender: TObject;
  var Key: Char);
begin
     if key = chr(13) then UpdateSettings ;
     end;


procedure TPrintGraphFrm.edTopMarginKeyPress(Sender: TObject;
  var Key: Char);
begin
     if key = chr(13) then UpdateSettings ;
     end;


procedure TPrintGraphFrm.edBottomMarginKeyPress(Sender: TObject;
  var Key: Char);
begin
     if key = chr(13) then UpdateSettings ;
     end;


procedure TPrintGraphFrm.edLeftMarginKeyPress(Sender: TObject;
  var Key: Char);
begin
     if key = chr(13) then UpdateSettings ;
     end;

procedure TPrintGraphFrm.bCancelClick(Sender: TObject);
begin
     { If operation has been cancelled, restore old settings }
     Settings.Plot := KeepSettings ;
     end;

end.
