unit Mepcfreq;
{ =======================================================
  WinCDR (c) J. Dempster, University of Strathclyde, 1998
  MEPC Frequency computation module

  Computes MEPC frequency from skew and variance of a
  fluctuating current signal.

  =======================================================}


interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, global, shared ;

type
  TMEPCFreqFrm = class(TForm)
    GroupBox1: TGroupBox;
    edTauRise: TEdit;
    edTauDecay: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    bOK: TButton;
    bCancel: TButton;
    procedure FormShow(Sender: TObject);
    procedure edTauRiseKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
    procedure UpdateParameters ;
  public
    { Public declarations }
  end;

var
  MEPCFreqFrm: TMEPCFreqFrm;

implementation

{$R *.DFM}


procedure TMEPCFreqFrm.FormShow(Sender: TObject);
{ ---------------------------
  Initialise controls on form
  ---------------------------}
begin
     if Settings.Variance.TauRise <= 0.0 then Settings.Variance.TauRise := cdrFH.dt ;
     edTauRise.text := format(' %.2f ms', [Settings.Variance.TauRise*SecsToMs] ) ;
     if Settings.Variance.TauDecay <= 0.0 then Settings.Variance.TauDecay := cdrFH.dt*50.0 ;
     edTauDecay.text := format(' %.2f ms', [Settings.Variance.TauDecay*SecsToMs] ) ;
     UpdateParameters ;
     end;


procedure TMEPCFreqFrm.UpdateParameters ;
{ --------------------------------
  Update parameters and text boxes
  --------------------------------}
begin
     { MEPC Rise time constant }
     Settings.Variance.TauRise := MsToSecs*ExtractFloat(edTauRise.text,
                                  Settings.Variance.TauRise*SecsToMs) ;
     edTauRise.text := format(' %.2f ms', [Settings.Variance.TauRise*SecsToMs] ) ;

     { MEPC Rise time constant }
     Settings.Variance.TauDecay := MsToSecs*ExtractFloat(edTauDecay.text,
                                  Settings.Variance.TauDecay*SecsToMs) ;
     edTauDecay.text := format(' %.2f ms', [Settings.Variance.TauDecay*SecsToMs] ) ;

     end ;


procedure TMEPCFreqFrm.edTauRiseKeyPress(Sender: TObject; var Key: Char);
begin
     if key = chr(13) then UpdateParameters ;
     end;

end.
