unit Mdiform;
{ =======================================================================
  WinCDR Master MDI form (c) John Dempster, 1996-97 All Rights Reserved
  V1.0
  V1.2 15/6/98 Variance/Power spectrum now usable Print and Copy Data work
  V1.2a 23/6/98 ASCII data file import option added
  V1.2b 25/6/98 Binary file import added
                ASCII text import now imports data correctly
                Clipboard buffer limit reduced to 31000
  =======================================================================}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, Global, FileIo, Shared, viewwcp, Zoomwcp, Setup,
  PrintRec, Rec, SealTest, Viewcdr, ZoomCDR, wavgen, wavrun,
  About, Log, Convert,  labio, defset, ced1902, detsigs, simmepc, pwrspec,
  simnoise  ;

type
  TMain = class(TForm)
    MainMenu: TMainMenu;
    File1: TMenuItem;
    Edit: TMenuItem;
    View: TMenuItem;
    Help1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    mnPrint: TMenuItem;
    PrintSetup1: TMenuItem;
    Exit1: TMenuItem;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    ZoomIn: TMenuItem;
    ZoomOut: TMenuItem;
    Setup: TMenuItem;
    mnCED1902: TMenuItem;
    Recording1: TMenuItem;
    Analysis: TMenuItem;
    mnDetectSignals: TMenuItem;
    Close1: TMenuItem;
    PrinterSetupDialog1: TPrinterSetupDialog;
    mnStimulusGenerator: TMenuItem;
    CopyData: TMenuItem;
    CopyImage: TMenuItem;
    Record1: TMenuItem;
    RecordToDisk: TMenuItem;
    SealTest: TMenuItem;
    Simulations1: TMenuItem;
    mnMEPCSim: TMenuItem;
    Import1: TMenuItem;
    Export1: TMenuItem;
    N2: TMenuItem;
    Contents: TMenuItem;
    SearchforHelpon1: TMenuItem;
    HowtouseHelp1: TMenuItem;
    About: TMenuItem;
    InspectLogFile: TMenuItem;
    Windows: TMenuItem;
    mnDefaultSettings: TMenuItem;
    Append: TMenuItem;
    mnViewCDR: TMenuItem;
    mnViewWCP: TMenuItem;
    mNDummy: TMenuItem;
    mnPwrSpec: TMenuItem;
    mnSimNoise: TMenuItem;
    procedure Open1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ZoomInClick(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Recording1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ZoomOutClick(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure mnPrintClick(Sender: TObject);
    procedure PrintSetup1Click(Sender: TObject);
    procedure RecordToDiskClick(Sender: TObject);
    procedure New1Click(Sender: TObject);
    procedure mnStimulusGeneratorClick(Sender: TObject);
    procedure CopyDataClick(Sender: TObject);
    procedure SealTestClick(Sender: TObject);
    procedure AboutClick(Sender: TObject);
    procedure InspectLogFileClick(Sender: TObject);
    procedure Import1Click(Sender: TObject);
    procedure CopyImageClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure mnShowViewCDRClick(Sender: TObject);
    procedure ShowRecordClick(Sender: TObject);
    procedure ShowSealTestClick(Sender: TObject);
    procedure mnDefaultSettingsClick(Sender: TObject);
    procedure mnCED1902Click(Sender: TObject);
    procedure ContentsClick(Sender: TObject);
    procedure SearchforHelpon1Click(Sender: TObject);
    procedure HowtouseHelp1Click(Sender: TObject);
    procedure AppendClick(Sender: TObject);
    procedure Export1Click(Sender: TObject);
    procedure mnViewCDRClick(Sender: TObject);
    procedure mnDetectSignalsClick(Sender: TObject);
    procedure mnViewWCPClick(Sender: TObject);
    procedure mnMEPCSimClick(Sender: TObject);
    procedure mnPwrSpecClick(Sender: TObject);
    procedure mnSimNoiseClick(Sender: TObject);
  private
    { Private declarations }
    procedure LoadDataFiles( FileName : string ) ;
    function OpenAssociateFile( var FileHeader : TWCPFileHeader ;
                                const FileName : string ) : boolean ;
  public
    { Public declarations }
    ViewWCPChild : TViewWCPFrm ;
    ViewWCPChildExists : Boolean ;
    ViewCDRChild : TViewCDRFrm ;
    ViewCDRChildExists : Boolean ;
    RecordChild : TRecordFrm ;
    RecordExists : Boolean ;
    SealTestChild : TSealTestFrm ;
    SealTestExists : Boolean ;
    LogChild : TLogFrm ;
    DetSignalsChild : TDetSignalsFrm ;
    MEPCSimChild : TMEPCSimFrm ;
    PwrSpecChild : TPwrSpecFrm ;
    SimNoiseChild : TSimNoiseFrm ;

    procedure SetCopyMenu( EnableCopyData, EnableCopyImage : boolean ) ;
    procedure UpdateWindows ;
    procedure SetMenus ;
    procedure ClearTicksInViewMenu ;
    procedure CopyAndPrintMenus( CopyEnabled,PrintEnabled : Boolean ) ;
    end;

var
  Main: TMain;


implementation

{$R *.DFM}

procedure TMain.FormCreate(Sender: TObject);
{ ---------------------------------------------------------------
  Initialize global program settings and load last data file used
  ---------------------------------------------------------------}
const
     ClipboardFormatName : PChar = 'Strathclyde WCP Record' ;
var
   ch : Integer ;
begin
      { Get directory which contains WinWCP program }
      Settings.ProgDirectory := ExtractFilePath(ParamStr(0)) ;
      Settings.VProtDirectory := Settings.ProgDirectory + 'vprot\' ;

      { Create channel names list }
      ChannelNames := TStringList.Create ;

      { Create default set of record types }
      RecordTypes := TStringList.Create ;
      RecordTypes.Add( 'ALL' ) ;
      RecordTypes.Add( 'EVOK' ) ;
      RecordTypes.Add( 'MINI' ) ;
      RecordTypes.Add( 'FAIL' ) ;
      RecordTypes.Add( 'TEST' ) ;
      RecordTypes.Add( 'LEAK' ) ;


     { Default values for channels }

     CdrFH.NumChannels := 1 ;
     CdrFH.NumSamplesInFile := 0 ;
     CdrFH.NumBytesInHeader := 512 ;
     CdrFH.ADCVoltageRange := 5. ;
     CdrFH.dt := 0.001 ;
     CdrFH.Version := 6.1 ;
     for ch := 0 to ChannelLimit do begin
         Channel[ch].TimeZero := 1. ;
         Channel[ch].ADCScale := 1. ;
         Channel[ch].CursorIndex := 128 ;
         Channel[ch].ZeroIndex := 0 ;
         Channel[ch].Cursor0 := 0 ;
         Channel[ch].Cursor1 := CdrFH.NumSamples div 2 ;
         { Zero levels fixed at hardware zero }
         Channel[ch].ADCZero := 0 ;
         Channel[ch].ADCZeroAt := -1 ;
         Channel[ch].ADCCalibrationFactor := 0.001 ;
         Channel[ch].ADCAmplifierGain := 1. ;
         Channel[ch].ADCUnits := 'mV' ;
         Channel[ch].ADCName := format('Ch.%d',[ch]);
         Channel[ch].ChannelOffset := ch ;
         Channel[ch].color := clBlue ;
         Channel[ch].xMin := 0. ;
         Channel[ch].xMax := CdrFH.NumSamples-1 ;
         Channel[ch].yMin := MinADCValue ;
         Channel[ch].yMax := MaxADCValue ;
         Channel[ch].InUse := True ;
         end ;

     CdrFH.WCPFileName := '' ;

     { Initialise to no laboratory interface }
     Settings.LaboratoryInterface := 0 ;

     { Initial Digidata 1200 I/O port settings }
     Settings.DD1200IOPort := $320 ;
     Settings.DD1200IRQ := 10 ;
     Settings.DD1200DMA := 5 ;
     Settings.NIDisableDMA := False ;

     Settings.TriggerMode := 'F' ;
     Settings.EventDetector.Channel := 0 ;
     Settings.EventDetector.yThreshold := 0. ;
     Settings.EventDetector.tThreshold := CdrFH.dt*10.0 ;
     Settings.EventDetector.BaselineAverage := 100 ;
     Settings.EventDetector.PreTriggerPercentage := 10.0 ;
     Settings.EventDetector.RecordSize := 512 ;
     Settings.EventDetector.DeadTime := CdrFH.dt*Settings.EventDetector.RecordSize ;
     Settings.AutoErase := True ;

     Settings.NumRecordsRequired := 1 ;
     Settings.RecordDuration := 10. ;
     Settings.NumBytesRequired := 2048*6 ;
     Settings.DisplayDuration := 10.0 ;
     Settings.CutOffFrequency := 0. ;
     { Minimum interval for updating D/A converters when
       generating command voltage waveforms }
     Settings.MinDACInterval := 0.001 ;

     Settings.TUnits := 's' ;
     Settings.TScale := 1.0 ;
     Settings.TUnScale := 1.0 ;

     { Name of command voltage protocol file in current use }
     Settings.VProgramFileName := '' ;

     { Divide factor that the patch/voltage clamp applies to its
       command voltage input. The D/A output voltage is thus scaled up
       by this factor }
     Settings.VCommand.DivideFactor := 1. ;
     Settings.VCommand.HoldingVoltage := 0. ;
     Settings.VCommand.HoldingVoltageAlt := 0. ;
     Settings.DigitalPort.Value := 0 ;
     Settings.UpdateOutputs := True ;

     { Default settings for seal test pulse }
     Settings.SealTest.Use := 1 ;
     Settings.SealTest.PulseHeight1 := 0.01 ;
     Settings.SealTest.HoldingVoltage1 := 0. ;
     Settings.SealTest.PulseHeight2 := 0.01 ;
     Settings.SealTest.HoldingVoltage2 := 0. ;
     Settings.SealTest.PulseHeight3 := 0.0 ;
     Settings.SealTest.HoldingVoltage3 := 0. ;

     Settings.SealTest.PulseWidth:= 0.05 ;
     Settings.SealTest.CurrentChannel := 0 ;
     Settings.SealTest.VoltageChannel := 1 ;
     Settings.SealTest.AutoScale := True ;
     Settings.SealTest.DisplayScale := 1 ;
     { Set flag indicating this is the first sweep, to force an autoscale }
     Settings.SealTest.FirstSweep := True ;
     { Set seal test Display limits }
     for ch := 0 to ChannelLimit do begin
         Settings.SealTest.yMin[ch] := MinADCValue ;
         Settings.SealTest.yMax[ch] := MaxADCValue ;
         end ;


     Settings.Plot.TopMargin := 5. ;
     Settings.Plot.LeftMargin := 5. ;
     Settings.Plot.BottomMargin := 5. ;
     Settings.Plot.RightMargin := 2.5 ;
     Settings.Plot.FontName := 'Arial' ;
     Settings.Plot.FontSize := 12 ;
     Settings.Plot.LineThickness := 2 ;
     Settings.Plot.MarkerSize := 5 ;
     Settings.Plot.ShowLines := True ;
     Settings.Plot.ShowMarkers := True ;


     { Bitmap size for images copied to clipboard }
     Settings.BitmapWidth := 600 ;
     Settings.BitmapHeight := 500 ;

     { Time taken to write one sector to hard disk }
     { Zero forces a write test to be made within wavgen module }
     Settings.SectorWriteTime := 0. ;

     Settings.DataDirectory := '' ;

     { Settings for record hard copy plots }
     Settings.TimeBarValue := -1. ;
     for ch := 0 to ChannelLimit do Settings.BarValue[ch] := -1. ;
     Settings.ShowLabels := True ;
     Settings.ShowZeroLevels := True ;

     Settings.CED1902.Input := 1 ;
     Settings.CED1902.Gain := 1 ;
     Settings.CED1902.GainValue := 1. ;
     Settings.CED1902.LPFilter := 0 ;
     Settings.CED1902.HPFilter := 0 ;
     Settings.CED1902.ACCoupled := 0 ;
     Settings.CED1902.NotchFilter := 0 ;
     Settings.CED1902.ComPort := 1 ;
     Settings.CED1902.DCOffset := 0 ;
     Settings.CED1902.InUse := False ;

     Settings.WavGenNoDisplay := False ; {Display waveform check box settings
                                          for Waveform Generator }

     { Set the file names and handles for all header blocks to null }
     CdrFH.FileHandle := -1 ;
     CdrFH.FileName := '' ;
     WCPfH.FileHandle := -1 ;
     WCPfH.FileName := '' ;

     { Clear child form flags }
     ViewWCPChildExists := False ;
     ViewCDRChildExists := False ;
     RecordExists := False ;
     SealTestExists := False ;
     MEPCSimChild := Nil ;

     { Register clipboard format }
     CF_WCPFormat := RegisterClipBoardFormat( ClipBoardFormatName ) ;

     SetMenus ;

     { Load initialization file to get name of last data file used }

     LoadInitializationFile( Settings.ProgDirectory + 'WinCDR.ini' ) ;
     for ch := 0 to CdrFH.NumChannels-1 do begin
         Channel[ch].xMin := 0. ;
         Channel[ch].xMax := CdrFH.NumSamples-1 ;
         Channel[ch].Cursor1 := CdrFH.NumSamples div 2 ;
         end ;

     { Open log file (contains log of program activity) }
     OpenLogFile ;
     WriteToLogFile( 'WinCDR Started' ) ;

     { Name of last used data file returned in fH.FileName }

     WindowMenu := Windows ;

     end;


procedure TMain.Open1Click(Sender: TObject);
{ -Menu item --------------------
  Open an existing .wcd data file
  -------------------------------}
begin
     { Get the name of a CDR file from user }
     OpenDialog.options := [ofPathMustExist] ;
     OpenDialog.DefaultExt := 'CDR' ;
     if Settings.DataDirectory <> '' then
        OpenDialog.InitialDir := Settings.DataDirectory ;
     OpenDialog.Filter := ' CDR Files (*.wcd)|*.wcd';
     OpenDialog.Title := 'Open File ' ;

     if OpenDialog.execute then begin

        LoadDataFiles( OpenDialog.FileName ) ;
        WriteToLogFile( CdrFH.FileName + ' opened' ) ;

        { Save data directory }
        Settings.DataDirectory := ExtractFilePath( CdrFH.FileName ) ;

        if not RecordToDisk.enabled then begin
           RecordChild.caption := 'Record ' + CdrFH.FileName ;
           RecordChild.edStatus.Text := '' ;
           end ;

        SetMenus ;
        end ;
     end;


procedure TMain.LoadDataFiles( FileName : string ) ;
{ -------------------------------------------
  Load CDR data file and any associated files
  -------------------------------------------}
var
   OldCdrFH : TCDRFileHeader ;
   ch : Integer ;
begin

     if FileExists( FileName ) then begin

        { Keep old file details ... just in case }
        OldCdrFH := CdrFH ;

        { Close all existing data files and their display windows }
        if CdrFH.FileHandle >= 0 then begin
           if ViewCDRChildExists then ViewCDRChild.Close ;
           FileClose( CdrFH.FileHandle ) ;
           CDRfH.FileHandle := -1 ;
           end ;
        if WCPfH.FileHandle >= 0 then begin
           if ViewWCPChildExists then ViewWCPChild.Close ;
           FileClose( WCPfH.FileHandle ) ;
           WCPfH.FileHandle := -1 ;
           end ;

        { Open CDR data file }
        CdrFH.Filename := FileName ;
        CdrFH.FileHandle := FileOpen( CdrFH.FileName, fmOpenReadWrite ) ;
        if CdrFH.Filehandle >= 0 then begin
            { Load the raw file details }
            GetCDRHeader( CdrFH ) ;
            { Make sure all channels are visible }
            for ch := 0 to CdrFH.NumChannels-1 do Channel[ch].InUse := True ;
            { Open display window if there are signals in file }
            if (CdrFH.NumSamplesInFile > 0) and (not ViewCDRChildExists) then
               ViewCDRChild := TViewCDRFrm.Create(Self) ;

            { Open any associated analysis files }
            OpenAssociateFile( WCPfH, CdrFH.WCPFileName ) ;
            end
        else begin
             MessageDlg( ' File Error ='+IntToStr(CdrFH.Filehandle),
                           mtWarning, [mbOK], 0 ) ;
             { Restore original file }
             CdrFH := OldCdrFH ;
             CdrFH.FileHandle := FileOpen( CdrFH.FileName, fmOpenReadWrite ) ;
             end ;

        end ;

     SetMenus ;
     end ;

function TMain.OpenAssociateFile( var FileHeader : TWCPFileHeader ;
                                  const FileName : string ) : boolean ;
{ -------------------------------------
  Open an associated file (if it exists)
  -------------------------------------}
begin
     WCPfH.FileName := FileName ;
     if FileExists( FileHeader.FileName ) then begin
        if FileHeader.FileHandle >= 0 then FileClose( FileHeader.FileHandle ) ;
        FileHeader.FileHandle := FileOpen( FileHeader.FileName, fmOpenReadWrite ) ;
        if FileHeader.Filehandle >= 0 then begin
           GetWCPHeader( FileHeader ) ;
           { Open display window if there are detected signals in file }
           if (WCPfH.NumRecords > 0) and (not ViewWCPChildExists) then
              ViewWCPChild := TViewWCPFrm.Create(Self) ;
           Result := True ;
           end
        else begin
             MessageDlg( format('%s Error=%d',[FileHeader.FileName,
                         FileHeader.Filehandle]), mtWarning, [mbOK], 0 ) ;
             FileHeader.FileHandle := -1 ;
             Result := False ;
             end ;
        end
     else Result := False ;
     end ;


procedure TMain.ZoomInClick(Sender: TObject);
var
   i : Integer ;
begin
     {ZoomFrm.ShowModal ;}
     end;


procedure TMain.Exit1Click(Sender: TObject);
{ --------------------------------
  Save state and terminate program
  -------------------------------- }
begin
     close ;
     end;


procedure TMain.Recording1Click(Sender: TObject);
{ - Menu Item -------------------------------
  Record parameters set-up dialog (setup.pas)
  -------------------------------------------}
begin
     SetUpDlg.ShowModal ;
     if SetupDlg.ModalResult = mrOK then begin
        if RecordExists then RecordChild.RestartADC := True ;
       { ZoomCDRFrm.ZoomOut ;}
        end ;
     end;


procedure TMain.FormDestroy(Sender: TObject);
begin
     RecordTypes.Free ;
     ChannelNames.Free ;
     end;


procedure TMain.ZoomOutClick(Sender: TObject);
{ - Menu Item ---------------------------------
  Set display channels to minimum magnification
  ---------------------------------------------}
begin
     if ViewCDRChildExists then ZoomCDRFrm.ZoomOut ;
     end;


procedure TMain.Close1Click(Sender: TObject);
{ -------------------------
  Close all forms and files
  -------------------------}
var
   i : Integer ;
begin
     { Close all child windows }
     with Main do
          for i := 0 to MDIChildCount-1 do MDICHildren[i].Close ;

     { Close files }
     if  CdrFH.FileHandle >= 0 then begin
         FileClose(CdrFH.FileHandle) ;
         CdrFH.FileHandle := - 1 ;
         end ;
     end ;


procedure TMain.mnPrintClick(Sender: TObject);
{ - Menu Item ----------------------------------------------------
  Print the record or graph displayed in the currently active form
  ----------------------------------------------------------------}
begin
     if ViewCDRChildExists then
          if ViewCDRChild.Active then ViewCDRChild.PrintRecord ;
     if ViewWCPChildExists then
          if ViewWCPChild.Active then ViewWCPChild.PrintRecord ;
     if not mnPwrSpec.Enabled then
          if PwrSpecChild.Active then PwrSpecChild.PrintGraph ;

     end;


procedure TMain.PrintSetup1Click(Sender: TObject);
{ - Menu Item ------------------
  Standard printer setup dialog
  ------------------------------}
begin
     PrinterSetupDialog1.Execute ;
     end;


procedure TMain.RecordToDiskClick(Sender: TObject);
{ - Menu Item --------------
  Open record to disk module
  --------------------------}
begin
     if IsLabInterfaceAvailable(Settings.LaboratoryInterface) = true then begin
        if not RecordExists then RecordChild := TRecordFrm.Create(Self)
                            else RecordChild.Show ;
        end ;
     end;


procedure TMain.New1Click(Sender: TObject);
{ - Menu Item --------
  Create new data file
  --------------------}
var
   ch : Integer ;
   TempFile : string ;
   ok : boolean ;
begin
     { Present user with standard Save File dialog box }
     SaveDialog.options := [ofOverwritePrompt,ofHideReadOnly,ofPathMustExist] ;
     SaveDialog.DefaultExt := 'wcd' ;
     SaveDialog.FileName := ExtractFileName( CdrFH.FileName ) ;
     SaveDialog.Filter := ' WCD Files (*.wcd)|*.wcd' ;
     SaveDialog.Title := 'New Data File' ;

     if Settings.DataDirectory <> '' then
        SaveDialog.InitialDir := Settings.DataDirectory ;

     if SaveDialog.execute then begin

        { Save data directory }
        Settings.DataDirectory := ExtractFilePath( SaveDialog.FileName ) ;
        { Close Measurements, Replay & fitting modules }
        if ViewWCPChildExists then ViewWCPChild.Close ;

             { Close files }
        if  CdrFH.FileHandle >= 0 then begin
            FileClose(CdrFH.FileHandle) ;
            CdrFH.FileHandle := - 1 ;
            end ;

        if  WCPFH.FileHandle >= 0 then begin
            FileClose(WCPFH.FileHandle) ;
            WCPFH.FileHandle := - 1 ;
            end ;

        { Open new and empty data file }
        CdrFH.FileName := SaveDialog.FileName ;
        CdrFH.FileName := ReplaceFileEnding( CdrFH.FileName, '.wcd' ) ;
        CdrFH.FileHandle := FileCreate( CdrFH.FileName ) ;
        CdrFH.NumSamplesInFile := 0 ;
        CdrFH.WCPFileName := '' ;
        for ch := 0 to CdrFH.NumChannels-1 do Channel[ch].InUse := True ;
        SaveCDRHeader( CdrFH ) ;
        { Update record window's caption }
        if RecordExists then begin
           RecordChild.caption := 'Record ' + CdrFH.FileName ;
           RecordChild.edStatus.Text := '' ;
           end ;


        { Re-load empty data file }
        LoadDataFiles( CdrFH.FileName ) ;

        WriteToLogFile( 'New file ' + CdrFH.FileName ) ;
        end ;
     end ;


procedure TMain.mnStimulusGeneratorClick(Sender: TObject);
{ - Menu Item ------------
  Edit a stimulus waveform
  ------------------------}
begin
     WavGenFrm := TWavGenFrm.Create(Self) ;
     end;


procedure TMain.SetMenus ;
{ ---------------------------
  Activate usable menu items
  --------------------------}
var
   ClipHandle : THandle ;
   OK : boolean ;
begin
     View.Enabled := False ;
     Analysis.Enabled := False ;
     mnPrint.Enabled := False ;
     Edit.Enabled := True ;
     Setup.Enabled := False ;
     Record1.Enabled := False ;
     Close1.Enabled := False ;
     Export1.Enabled := False ;
     Simulations1.Enabled := False ;

     { Enable setup, recording and simulation ... if a data file is open }
     if CdrFH.FileHandle >= 0 then begin
           { Allow these functions when a data file is open }
           Setup.Enabled := True ;
           Record1.Enabled := True ;
           Close1.Enabled := True ;

           Simulations1.Enabled := True ;
           View.Enabled := True ;

           mnViewCDR.Enabled := False ;
           mnViewWCP.Enabled := False ;

           { Enable these functions when a data record is in the clipboard }
            OK := OpenClipboard( Handle ) ;
            ClipHandle := GetClipboardData( CF_WCPFormat ) ;
            OK := CloseClipboard ;

           { Enable these functions when file contains data records }
           if CdrFH.NumSamplesInFile > 0 then begin
              Analysis.Enabled := True ;
              mnPrint.Enabled := True ;
              Export1.Enabled := True ;
              Edit.Enabled := True ;
              mnViewCDR.Enabled := True ;
              end ;

           if (WCPfH.FileHandle >= 0) and (WCPfH.NumRecords > 0) then
              mnViewWCP.Enabled := True ;

           end ;

     end ;

procedure TMain.SetCopyMenu( EnableCopyData, EnableCopyImage : boolean ) ;
{ --------------------------------------------------
  Enable/disable copy data and copy image menu items
  --------------------------------------------------}
begin
     CopyData.enabled := EnableCopyData ;
     CopyImage.enabled := EnableCopyImage ;
     end ;


procedure TMain.CopyDataClick(Sender: TObject);
begin
     { Copy the data on display in the ViewCDR module in ASCII format }
     if ViewCDRChildExists then
        if ViewCDRChild.Active then ViewCDRChild.CopyDataToClipBoard ;

     if ViewWCPChildExists then
        if ViewWCPChild.Active then ViewWCPChild.CopyDataToClipBoard ;

     if not mnPwrSpec.Enabled then PwrSpecChild.CopyDataToClipboard ;
     end ;



procedure TMain.SealTestClick(Sender: TObject);
{ ----------------------------
  Menu - Open seal test module
  ----------------------------}
begin
     if IsLabInterfaceAvailable(Settings.LaboratoryInterface) = true then begin
        if not SealTestExists then SealTestChild := TSealTestFrm.Create(Self)
                              else SealTestChild.Show ;
        end ;
     end;


procedure TMain.AboutClick(Sender: TObject);
begin
     AboutDlg := TAboutDlg.Create(Self) ;
     AboutDlg.ShowModal ;
     end;


procedure TMain.UpdateWindows ;
begin
     if not ViewWCPChildExists then begin
        SetMenus ;
        ViewWCPChild := TViewWCPFrm.Create(Self) ;
        end ;
     ViewWCPChild.NewFile := True ;
     end ;


procedure TMain.InspectLogFileClick(Sender: TObject);
begin
     LogChild := TLogFrm.Create(Self) ;
     end;


procedure TMain.Import1Click(Sender: TObject);
{ - Menu Item --------------------------------
  Import records from a foreign data file type
  --------------------------------------------}
begin
     OpenDialog.options := [ofPathMustExist] ;
     OpenDialog.DefaultExt := 'DAT' ;
     OpenDialog.Filter := ' pClamp Files (*.DAT)|*.DAT|' ;
     OpenDialog.Filter := OpenDialog.Filter + 'pClamp Files (*.DAT)|*.DAT|' ;
     OpenDialog.Filter := OpenDialog.Filter + 'CED Files (*.DAT,*.CFS)|*.DAT;*.CFS|' ;
     OpenDialog.Filter := OpenDialog.Filter + 'CDR Files (*.CDR)|*.CDR|' ;
     OpenDialog.Filter := OpenDialog.Filter + 'ASCII Text (*.TXT)|*.TXT|' ;
     OpenDialog.Filter := OpenDialog.Filter + 'Binary (*.*)|*.*|' ;

     OpenDialog.Title := 'Import File ' ;
     if Settings.DataDirectory <> '' then
        OpenDialog.InitialDir := Settings.DataDirectory ;

     if OpenDialog.execute then begin

        Settings.DataDirectory := ExtractFilePath( OpenDialog.FileName ) ;

        ImportFromDataFile( OpenDialog.FileName ) ;
        WriteToLogFile( CdrFH.FileName + ' opened' ) ;

        if ViewCDRChildExists then ViewCDRChild.NewFile := True ;

        { Set display magnification to minimum }
        if CdrFH.NumSamplesInFile > 0 then begin
           if not ViewCDRChildExists then ViewCDRChild := TViewCDRFrm.Create(Self) ;
           ZoomOut.Click ;
           end ;

        SetMenus ; ;
        end ;
     end;


procedure TMain.CopyImageClick(Sender: TObject);
begin
     { Copy displayed image from ViewCDR module }
     if ViewCDRChildExists then
          if ViewCDRChild.Active then ViewCDRChild.CopyRecordsImageToClipboard ;

     { Copy displayed image from ViewWCP module }
     if ViewWCPChildExists then
        if ViewWCPChild.Active then ViewWCPChild.CopyRecordImageToClipboard ;
     end ;


procedure TMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
     if MessageDlg( 'Exit Program! Are you Sure? ', mtConfirmation,
        [mbYes,mbNo], 0 ) = mrYes then CanClose := True
                                  else CanClose := False ;
     end;

procedure TMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
        { Close log file }
        CloseLogFile ;
        { Save initialization file }
        SaveInitializationFile( Settings.ProgDirectory + 'WinCDR.ini' ) ;
        { If the recording module is running, stop A/D and D/A conversion }
        if RecordExists then RecordChild.Close ;
        { If the seal test module is running, stop A/D and D/A conversion }
        if SealTestExists then SealTestChild.Close ;

        CloseLaboratoryInterface ;
             { Close files }
        if  CdrFH.FileHandle >= 0 then begin
             FileClose(CdrFH.FileHandle) ;
             CdrFH.FileHandle := -1 ;
             end ;
        if  WCPfH.FileHandle >= 0 then begin
             FileClose(WCPFH.FileHandle) ;
             WCPfH.FileHandle := -1 ;
         end ;

        end;



procedure TMain.mnShowViewCDRClick(Sender: TObject);
{ -- Menu item -------------------------
  Bring View Record module to the front
  -------------------------------------}
begin
     { If window is minimised restore to normal }
     if ViewCDRChild.WindowState = wsMinimized then ViewCDRChild.WindowState := wsNormal ;
     { Bring it to the front }
     ViewCDRChild.BringToFront ;
     end;


procedure TMain.ShowRecordClick(Sender: TObject);
{ -- Menu item -------------------------
  Bring Recording module to the front
  -------------------------------------}
begin
     { If window is minimised restore to normal }
     if RecordChild.WindowState = wsMinimized then RecordChild.WindowState := wsNormal ;
     { Bring it to the front }
     RecordChild.BringToFront ;
     end;


procedure TMain.ShowSealTestClick(Sender: TObject);
{ -- Menu item -------------------------
  Bring Seal testing module to the front
  -------------------------------------}
begin
     { If window is minimised restore to normal }
     if SealTestChild.WindowState = wsMinimized then SealTestChild.WindowState := wsNormal ;
     { Bring it to the front }
     SealTestChild.BringToFront ;
     end;


procedure TMain.ClearTicksInViewMenu ;
begin
     mnViewWCP.checked := false ;
     end ;


procedure TMain.mnDefaultSettingsClick(Sender: TObject);
begin
     DefSetFrm := TDefSetFrm.Create(Self) ;
     end;

procedure TMain.mnCED1902Click(Sender: TObject);
begin
     CED1902Frm := TCED1902Frm.Create(Self) ;
     end;

procedure TMain.ContentsClick(Sender: TObject);
begin
     application.helpcommand( HELP_CONTENTS, 0 ) ;
     end;


procedure TMain.SearchforHelpon1Click(Sender: TObject);
begin
     application.helpcommand( HELP_PARTIALKEY, 0 ) ;

     end;


procedure TMain.HowtouseHelp1Click(Sender: TObject);
begin
     application.helpcommand( HELP_HELPONHELP, 0 ) ;
     end;


procedure TMain.AppendClick(Sender: TObject);
{ - Menu Item -------------------------------------------
  Append records from another WCP data file (convert.pas)
  -------------------------------------------------------}
begin
     OpenDialog.options := [ofPathMustExist] ;
     OpenDialog.DefaultExt := 'DAT' ;
     OpenDialog.Filter := ' WCP Files (*.WCP)|*.WCP';
     OpenDialog.Title := 'Append File ' ;
     if Settings.DataDirectory <> '' then
        OpenDialog.InitialDir := Settings.DataDirectory ;

     if OpenDialog.execute then begin

        Settings.DataDirectory := ExtractFilePath( OpenDialog.FileName ) ;

        {AppendWCPFile( OpenDialog.FileName ) ;}

        if ViewCDRChildExists then ViewCDRChild.NewFile := True ;

        { Set display magnification to minimum }
        if CdrFH.NumSamplesInFile > 0 then begin
           if not ViewCDRChildExists then ViewCDRChild := TViewCDRFrm.Create(Self) ;
           if ViewCDRChildExists then ViewCDRChild.NewFile := True ;
           ZoomOut.Click ;
           end ;
        SetMenus ; ;
        end ;
     end;



procedure TMain.Export1Click(Sender: TObject);
{ - Menu Item --------------------------------
  Export records to a foreign data file type
  --------------------------------------------}
begin
     SaveDialog.DefaultExt := 'DAT' ;
     SaveDialog.options := [ofOverwritePrompt,ofHideReadOnly,ofPathMustExist] ;
     SaveDialog.Filter := ' pClamp Files (*.DAT)|*.DAT|CED Files(*.DAT)|*.DAT|';
     SaveDialog.FileName := ReplaceFileEnding( CdrFH.FileName, '.dat' ) ;
     SaveDialog.Title := 'Export File ' ;
     if Settings.DataDirectory <> '' then
        SaveDialog.InitialDir := Settings.DataDirectory ;

     if SaveDialog.execute then begin
        ConvertWCDTopClamp( SaveDialog.FileName ) ;
        end ;
     end ;


procedure TMain.mnViewCDRClick(Sender: TObject);
begin
     if not ViewCDRChildExists then
        ViewCDRChild := TViewCDRFrm.Create(Self)
     else
        ViewCDRChild.Show ;
     end;

procedure TMain.mnDetectSignalsClick(Sender: TObject);
begin
     DetSignalsChild := TDetSignalsFrm.Create(Self) ;
     end;

procedure TMain.mnViewWCPClick(Sender: TObject);
{ ----------------------------
  Show WCP file display module
  ----------------------------}
begin
     if not ViewWCPChildExists then
        ViewWCPChild := TViewWCPFrm.Create(Self)
     else ViewWCPChild.Show ;
     end;

procedure TMain.mnMEPCSimClick(Sender: TObject);
begin
     MEPCSimChild := TMEPCSimFrm.Create(Self) ;
     end;

procedure TMain.mnPwrSpecClick(Sender: TObject);
begin
     PwrSpecChild := TPwrSpecFrm.Create(Self) ;
     end;

procedure TMain.mnSimNoiseClick(Sender: TObject);
begin
     SimNoiseChild := TSimNoiseFrm.Create(Self) ;
     end;

procedure TMain.CopyAndPrintMenus( CopyEnabled,PrintEnabled : Boolean ) ;
{ -------------------------------------------
  Enable/disable copying and printingf menus
  -------------------------------------------}
begin
     CopyData.Enabled := CopyEnabled ;
     CopyImage.Enabled := {CopyEnabled} False ;
     mnPrint.Enabled := PrintEnabled ;
     end ;



end.


