	subroutine plot_results(ifile,title,nv,selected_type,ichan,xy)
$INCLUDE:'wcpcom.for'
c
c	Plot analysis results as X/Y graphs or histograms and
c	produce average/sd summaries.
c
	integer*2 ifile 	! Unit No. of data file
	character*(*) title	! Name of data file
	character*(*) selected_type    ! Type of records being analysed
	integer*2 ichan 	! Channel being analysed
	real*4 xy(1)		! Plotting work array


	CHARACTER*18 YLABEL,xlabel
	CHARACTER KEY
	LOGICAL plot_available,new_menu,histogram,quit

	character*52 report(4)

	parameter(nmenu=10,istatus_left=59,istatus_top=19)

	character*20 menu(nmenu) /
     &	' Plot X/Y graph   F1',
     &	' Plot histogram   F2',
     &	' Set record range F3',
     &	' Set axes range   F4',
     &	' Plot hard copy   F5',
     &	' List graph       F6',
     &	' Edit comment     F7',
     &	' Summary          F8',
     &	' Trend Analysis   F9',
     &	' Exit            ESC'/


	integer*2 ir_s /0/,ir_e /0/

C
C	CODE
C	----
C

	plot_available = .false.
	iop = 1

	ir_s = max(1,ir_s)
	if( ir_e .eq. 0 ) ir_e = n_records
	ir_e = min(ir_e,n_records)

C
	quit = .false.
	iright = 78
	do while ( .not. quit )

	    call erase_box(2,2,iright,24)
	    call display_box(2,2,iright,24)
	    call move_cursor(3,2)
	    call display_string(' Plot Results ')

	    report(1) = file_name
	    write(report(2)
     &	    ,'('' Records '',i4,''-'',i4)') ir_s,ir_e
	    report(3) = id
	    nlines = 0
c

C
C	    Plot graph on screen
C
	    if( plot_available ) then
		if( .not. histogram ) then
		     call plot_graph('S',xy,np,xlo,ylo,xhi,yhi
     &		     ,xtic,ytic,xlabel,ylabel,report,nlines)
		else
		     call plot_histogram('S',xy,np,xlo,ylo,xhi,yhi
     &		     ,xtic,ytic,xlabel,ylabel,report,nlines)
		endif
	    endif
c
c	    Wait for user to select an option from menu
c
	    new_menu = .true.
	    iop = Iwait_MENU_VERTICAL1(menu,'123456789$',nmenu
     &	    ,iright-len(menu(1))-2,
     &	    3,new_menu,iop,' Options ',key)

	    select case(iop)

	    case (1)
c
c --	    X/Y plot of a selected pair of variables
c

	    call create_graph(ifile,nv,
     &	    selected_type,ir_s,ir_e,ichan,
     &	    xy,np,xmin,ymin,xmax,ymax,xlabel,ylabel)

	    xlo = xmin
	    ylo = ymin
	    xhi = xmax
	    yhi = ymax
	    if(xlo .eq. xhi ) xhi = xlo + 1.
	    if(ylo .eq. yhi ) yhi = ylo + 1.
	    xtic = (xhi-xlo)/5.
	    ytic = (yhi-ylo)/5.
	    if( np .gt. 0 ) plot_available = .true.
	    histogram = .false.

	    case (2)
c
c --	    Create frequency histogram for selected variable
c
	    call create_histogram(ifile,nv,
     &	    selected_type,ir_s,ir_e,ichan,
     &	    xy,np,xmin,ymin,xmax,ymax,xlabel,ylabel)

	    xlo = xmin
	    ylo = ymin
	    xhi = xmax
	    yhi = ymax
	    if(xlo .eq. xhi ) xhi = xlo + 1.
	    if(ylo .eq. yhi ) yhi = ylo + 1.
	    xtic = (xhi-xlo)/5.
	    ytic = (yhi-ylo)/5.
	    plot_available = .true.
	    histogram = .true.

	    case( 3 )
c
c --		Set analysis range
c
		call set_record_range(ir_s,ir_e,3,3,' Set range range ')

	    case (4)
C
C --	    Set plot axes range and tic spacing
C
	    if( plot_available ) call set_axes_form(3,3,xmin,ymin,
     &	    xmax,ymax,xlo,ylo,xhi,yhi,xtic,ytic)

	    case (5)
C
C --	    Plot hard copy of currently displayed graph
C
	    if( plot_available ) then
		if( .not. histogram ) then
		     call plot_graph('H',xy,np,xlo,ylo,xhi,yhi
     &		     ,xtic,ytic,xlabel,ylabel,report,nlines)
		else
		     call plot_histogram('H',xy,np,xlo,ylo,xhi,yhi
     &		     ,xtic,ytic,xlabel,ylabel,report,nlines)
		endif
	    endif

	    case (6)
C
C --	    Display table of current graph values
C
	    if( plot_available ) then
		call list_table(xy,2,np,15,3,3,xlabel(1:12)//
     &		 ylabel(1:12))
	    endif

	    case (7)
c
c --	    Edit comment line
c
	    call erase_box(3,3,57,5)
	    call display_box(3,3,57,5)
	    call move_cursor(4,3)
	    call display_string(' Edit Comment line ')
	    call move_cursor(4,4)
	    call get_string( id(1:52), nc, key )
	    call write_to_log( id )

	    case( 8 )
c
c	    Display/print summary report on a channel
c
	    call summary(ifile,title,ir_s,ir_e,selected_type,ichan,nv)

	    case( 9 )
c
c	    Test X/Y plot for linear trend
c
	    if( plot_available .and. .not. histogram
     &		.and. np.gt.2 ) then
		call trend_analysis( 3, 19, xy, np )
	    end if

	    case (10)
c
c --	    Exit
c
	    quit = .true.

	    end select
	end do

	call set_margins(2,1,80,25)
	return
	end

	SUBROUTINE CREATE_GRAPH(ifile,nv,
     &	selected_type,ir_s,ir_e,ichan,
     &	XY,NP,XMIN,YMIN,XMAX,YMAX,xlabel,ylabel)
$INCLUDE:'wcpcom.for'
C
c	Create aN X/Y plot of variables IX_VAR and IY_VAR
c	from record analysis array (see ANALYSIS in wcpcom.for)
c	using records between IR_S and IR_E in file IFILE_NO
c	of type RECORD_TYPE (EVOKED,SPONT., or ALL records excepted REJECTED)
c
c	Return histogram in array XY of length NP points.
c	Data range is returned in XMIN,YMIN,XMAX,YMAX
c	YLABEL is returned as blank or as % if percentage
C	------------------------------------------------
C
C
	REAL XY(1)
	character*(*) xlabel,ylabel,selected_type

	logical new_menu
	character key
c
c	Max. no. of points inr xy graph
c
	parameter( maxp = (max_points*(max_channels*2-1))/2 )
C
C	CODE
C	----
C

	new_menu = .true.
	ix_var = Iwait_MENU_VERTICAL1(var_name,'1234567890123456',nv
     &	,3,3,new_menu,ix_var,' X Variable ',key)

	if( ix_var .gt. 2 ) then
	    new_menu = .true.
	    ix_chan = ichan
	    call select_channel( 5,6, ' X Channel ', ix_chan )
	else
	    ix_chan = 1
	end if

	call variable_units( ix_chan )
	xlabel = y_name(ix_chan)//' '//var_name(ix_var)
	xlabel = xlabel(1:len_trim(xlabel)+1)//v_units(ix_var)

	new_menu = .true.
	iy_var = Iwait_MENU_VERTICAL1(var_name,'1234567890123456',nv
     &	,4,5,new_menu,iy_var,' Y Variable ',key)

	if( iy_var .gt. 2 ) then
	    iy_chan = ichan
	    call select_channel( 5,6, ' Y Channel ', iy_chan )
	else
	    iy_chan = 1
	end if

	call variable_units( iy_chan )
	ylabel = y_name(iy_chan)//' '//var_name(iy_var)
	ylabel = ylabel(1:len_trim(ylabel)+1)//v_units(iy_var)

	call display_message(5,7,30,' WAIT ... Creating graph ',1)

	J = 0
	XMIN = 1E30
	YMIN = 1E30
	XMAX = -1E30
	YMAX = -1E30
	DO IRECORD = IR_S,IR_E
C
	    call get_analysis_block( ifile, irecord, rec.buf )
c
	    if( rec.status .eq. 'ACCEPTED' .and.
     &	    (rec.type .eq. selected_type .or.
     &	     selected_type .eq. 'ALL') ) then

		J = J + 1

		rec.results(ix_chan,ixnum) = rec.number
		x = rec.results(ix_chan,ix_var)

		IF(X.LT.XMIN) XMIN = X
		IF(X.GT.XMAX) XMAX = X
		XY(J) = X
		J = J + 1
		rec.results(iy_chan,ixnum) = rec.number
		y = rec.results(iy_chan,iy_var)

		IF(Y.LT.YMIN) YMIN = Y
		IF(Y.GT.YMAX) YMAX = Y
		XY(J) = Y
	    ENDIF
	    IF(J.GT.maxp) GOTO 101
	end do
101	CONTINUE
	NP = J/2
	RETURN
	END


	SUBROUTINE CREATE_HISTOGRAM(ifile,nv,
     &	selected_type,ir_s,ir_e,ichan,
     &	xy,np,xmin,ymin,xmax,ymax,xlabel,YLABEL)
$include: 'wcpcom.for'
C
c	Create a frequency histogram of variable No. IH_VAR
c	from record analysis array (see ANALYSIS in wcpcom.for)
c	using records between IR_S and IR_E in file IFILE_NO
c	of type RECORD_TYPE (EVOKED,SPONT., or ALL records excepted REJECTED)
c
c	Return histogram in array XY of length NP points.
c	Data range is returned in XMIN,YMIN,XMAX,YMAX
c	YLABEL is returned as blank or as % if percentage
C	------------------------------------------------
C
	REAL XY(1),xmin,xmax,ymin,ymax
	character*(*) xlabel,ylabel,selected_type

	parameter(nmenu=5)
	character*30 menu(nmenu) /
     &	' No. of bins (<=100)',
     &	' Bin Range (Lower Limit)',
     &	' Bin Range (Upper Limit)',
     &	' Y axis as Percentage (Y/N)',
     &	' Cumulative histogram (Y/N)'/
	character*12 list(nmenu)
	character*36 title

	parameter(bigneg=-1E30,bigpos=1E30)
	parameter(maxbins=100)
	integer*2 nbins /100/
	character percent / 'N' /
	logical new_menu
	character key
	character Cumulative / 'N' /

C
C	CODE
C
	new_menu = .true.

	ih_var = Iwait_MENU_VERTICAL1(var_name,'1234567890123456',nv
     &	,3,3,new_menu,ih_var,' Histogram of ',key)
	xlabel = var_name(ih_var)//' '//v_units(ih_var)

	if( ih_var .gt. 2 ) then
	    ih_chan = ichan
	    call select_channel( 4,4, ' Channel No. ', ih_chan )
	    xlabel = y_name(ichan)//' '//var_name(ih_var)
	    xlabel = xlabel(1:len_trim(xlabel)+1)//v_units(ih_var)
	else
	    ih_chan = 1
	end if

C
C --	Find Min./Max. range of data (used as initial setting
c	of histogram range)
C
	iskip = max((ir_e-ir_s)/100,1)
	binlo = 1E30
	binhi = -1E30

	if( (ir_e .le. ir_s) .or. (ir_s.eq.0) ) then
	   np = 0
	   return
	endif

	DO IRECORD = IR_S,IR_E,iskip

	    call get_analysis_block( ifile, irecord, rec.buf )
	    if( rec.status .eq. 'ACCEPTED' .and.
     &	    (rec.type .eq. selected_type .or.
     &	     selected_type .eq. 'ALL') ) then
		rec.results(ih_chan,ixnum) = rec.number
		x = rec.results(ih_chan,ih_var)
		if( binlo .gt. x ) binlo = x
		if( binhi .lt. x ) binhi = x
	    endif
	end do
c
c	Let user set histogram range
c
	i = 1
	write(list(i),'(i3)') nbins
	i = 1 + i
	write(list(i),'(f11.3)') binlo
	i = 1 + i
	write(list(i),'(f11.3)') binhi
	i = 1 + i
	list(i) = percent
	i = 1 + i
	list(i) = Cumulative

	title = ' '
10	if( title .eq. ' ' ) title = ' Set Histogram Range '
	call text_window(menu,list,nmenu,5,7,title)

	i = 1
	nbins = int(check_limits(list,2.,float(maxbins),i,title))
	if( title .ne. ' ' ) goto 10
	i = 1 + i
	binlo = check_limits(list,bigneg,bigpos,i,title)
	if( title .ne. ' ' ) goto 10
	i = 1 + i
	binhi = check_limits(list,binlo+1E-30,bigpos,i,title)
	if( title .ne. ' ' ) goto 10
	i = i + 1
	call upper_case(list(i))
	if( index(list(i),'Y') .ne. 0 ) then
	    percent = 'Y'
	else
	    percent = 'N'
	endif
	i = i + 1
	Cumulative = check_letter(list,'NY',i,title)
	if( title .ne. ' ' ) goto 10

	call display_message(5,7,30,' WAIT ... Creating histogram ',1)
C
	bin_width = (binhi - binlo ) / float(nbins)
C
C -- Initialize histogram
C
	x = binlo + bin_width/2.
	do i = 1,nbins
	    xy(2*i-1) = x
	    xy(2*i) = 0.
	    x = x + bin_width
	end do
C
C -- Generate bins
C
	DO IRECORD = IR_S,IR_E
C
	    call get_analysis_block( ifile, irecord, rec.buf )

	    if( rec.status .eq. 'ACCEPTED' .and.
     &	    (rec.type .eq. selected_type .or.
     &	     selected_type .eq. 'ALL') ) then
		x = rec.results(ih_chan,ih_var)
		idx = int( (x - binlo)/bin_width ) + 1
		idx = min(max(idx,1),nbins)
		xy(2*idx) = xy(2*idx) + 1.
	    ENDIF
	end do
c
c	Calculate total contents of bins
c
	ymax = 0.
	sum = 0.
	do i = 1,nbins
	    sum = sum + xy(2*i)
	    if( ymax .lt. xy(2*i) ) ymax = xy(2*i)
	end do
c
c	Turn into a cumulative histogram
c
	if( Cumulative .eq. 'Y' ) then
	    do i = 2,nbins
		xy(2*i) = xy(2*(i-1)) + xy(2*i)
	    end do
	    ymax = xy(2*nbins)
	end if
c
c	Scale into % (if required)
c
	if( percent .eq. 'Y' ) then
	    ylabel = '%'
	    do i = 1,nbins
		xy(2*i) = xy(2*i)*100./sum
	    end do
	    ymax = ymax*100./sum
	else
	    scale = 1.
	    ylabel = ' '
	endif

C
C -- Axes data range
C
	xmin = binlo
	xmax = binhi
	ymin = 0.
	np = nbins
	return
	end

	subroutine set_axes_form(ix,iy,xmin,ymin,xmax,ymax
     &	,xlo,ylo,xhi,yhi,xtic,ytic)

	parameter(naxes_menu=6)
	parameter(bigneg=-1E30,bigpos=1E30)
	character*36 axes_menu(naxes_menu)
	character*12 list(naxes_menu)
	character*46 err

c	 automatic list,err,axes_menu
c
c	code
c
	WRITE(axes_menu(1)
     &	,'('' X axis range: minimum ('',G10.4,'')'')') XMIN
	WRITE(axes_menu(2)
     &	,'('' X axis range: maximum ('',G10.4,'')'')') XMAX
	axes_menu(3) = ' X axis tic spacing '
	WRITE(axes_menu(4)
     &	,'('' Y axis range: minimum ('',G10.4,'')'')') YMIN
	WRITE(axes_menu(5)
     &	,'('' Y axis range: maximum ('',G10.4,'')'')') YMAX
	axes_menu(6) = ' Y axis tic spacing '

	write(list(1),'(F12.3)') xlo
	write(list(2),'(F12.3)') xhi
	write(list(3),'(F12.3)') xtic
	write(list(4),'(F12.3)') ylo
	write(list(5),'(F12.3)') yhi
	write(list(6),'(F12.3)') ytic

	err = ' '
2100	if( err .eq. ' ' ) err = ' Set axes range '

	CALL text_window(axes_menu,list,naxes_menu,ix,iy,err)

	xlo  = check_limits(list,bigneg,bigpos,1,err)
	if( err .ne. ' ' ) goto 2100
	xhi  = check_limits(list,bigneg,bigpos,2,err)
	if( err .ne. ' ' ) goto 2100
	xtic = check_limits(list,bigneg,bigpos,3,err)
	if( err .ne. ' ' ) goto 2100
	ylo  = check_limits(list,bigneg,bigpos,4,err)
	if( err .ne. ' ' ) goto 2100
	yhi  = check_limits(list,bigneg,bigpos,5,err)
	if( err .ne. ' ' ) goto 2100
	ytic = check_limits(list,bigneg,bigpos,6,err)
	if( err .ne. ' ' ) goto 2100

	return
	end


	subroutine plot_graph(output,xy,np
     &	,xlo,ylo,xhi,yhi,xtic,ytic,xlabel,ylabel,report,nlines)
$include: 'wcpcom.for'
C
C	Plot X/Y graph on screen, printer, plotter, or file.
C	----------------------------------------------------
C	Enter with "output='S'" for screen display, "output='H' for
C	hard copy. Graph points is array "xy" "np" = No. of points
C	"xlo,ylo,xhi,yhi" are limits of X and Y axes
C	"xtic,ytic" spacing of calibration tics on axes
C	"ylabel" and "xlabel" =  axes labels
c	"report" contains "nlines" of text ro be displayed with plot
C
	character*(*) output,report(nlines)
	REAL XY(1)
	INTEGER*2 IXY(2)
	integer*1 ieof
	CHARACTER*(*) ylabel,xlabel
	CHARACTER*30 device

C
C	CODE
c
	call get_screen_device( iscreen )

	if( output .ne. 'S' ) then
c
c	    Let user select O/P device
c
	    call select_plot_device(3,5,idev,ihandle,device)
	    if( (idev.eq. 0) .and. (ihandle.eq.0) ) return

	    if( (idev.eq.0) .and. (ihandle.ne.0) ) then
c
c		Write X/Y graph to ASCII text file in format
c		X <TAB> Y <CR> <LF>
c		Terminate with ASCII end-of-file marker ctrl-z
c
		call write_ascii_list(ihandle,xy,2,np)
		ieof = 26
		call write_bytes(ihandle,ierr,ieof,1)
		call close_file( ihandle, ierr )
		return
	    endif
c
c	    Set size of plot on page
c
	    CALL SET_SIZE(7000,10000,25000,22000)
c	    call set_polyline_width( idev, (iline_thickness-1)*50+3 )
	else
	    idev = iscreen
	    CALL SET_SIZE(7500,7000,20000,22000)
c	    call set_polyline_width( idev, 3 )
	endif

	call get_text_attributes( idev, i,i,i,i,i,
     &	ichar_width,ichar_height)

	call draw_axes_manual(idev,xlo,ylo,xhi,yhi,xlabel,ylabel
     &	,'N','N','N',xtic,ytic )

	CALL SET_POLYMARKER_TYPE(IDEV,2)
	CALL SET_POLYMARKER_HEIGHT(IDEV,ICHAR_HEIGHT/4)
	CALL DRAW_marker(IDEV,XY,NP)
C
c	Display report list
c
	if( idev .eq. iscreen ) then
	    do i = 1,nlines
		call move_cursor(3,i+2)
		call display_string( report(i) )
	    end do
	else
	    IXY(1) = ICHAR_WIDTH
	    IXY(2) = max_ndc - ICHAR_HEIGHT*2
	    do i = 1,nlines
		ixy(2) = ixy(2) - ichar_height
		call graphics_text( idev, ixy, report(i) )
	    end do
	endif

C
C	Close hard copy workstation
C
	CALL GET_SCREEN_DEVICE(ISCREEN)
	IF( IDEV.NE.ISCREEN ) THEN
	    CALL UPDATE_WORKSTATION(IDEV)
	    CALL CLEAR_WORKSTATION(IDEV)
	    CALL UNLOAD_FONTS(IDEV)
	    CALL CLOSE_WORKSTATION(IDEV)
c
c	    If output has been to an HPGL file
c	    fix it to make it compatible with Microsoft Word
c	    and other programs
c
	    if( device(1:1) .eq. 'H' )
     &	     call fix_hpgl( device(2:len(device)) )
	ENDIF
	RETURN
	END


	subroutine plot_histogram(output,xy,np
     &	,xlo,ylo,xhi,yhi,xtic,ytic,xlabel,ylabel,report,nlines)
$include: 'wcpcom.for'
C
C	Plot histogram on screen, printer, plotter, or file.
C	----------------------------------------------------
C	Enter with "output='S'" for screen display, "output='H' for
C	hard copy. Graph points is array "xy" "np" = No. of points
C	"xlo,ylo,xhi,yhi" are limits of X and Y axes
C	"xtic,ytic" spacing of calibration tics on axes
C	"ylabel" and "xlabel" =  axes labels
c	"report" contains "nlines" of text ro be displayed with plot

	character*(*) output,report(nlines)
	real xy(1)
	integer*2 np,nlines
	real xlo,ylo,xhi,yhi
	INTEGER*2 IXY(2)
	integer*1 ieof
	CHARACTER*(*) YLABEL,xlabel
	CHARACTER*30 device
	parameter(max_bins=100)
	real*4 work(4*max_bins+4)
C
C	CODE
C

	call get_screen_device( iscreen )

	if( output .ne. 'S' ) then
c
c	    Let user select O/P device
c
	    call select_plot_device(3,5,idev,ihandle,device)
	    if( (idev.eq. 0) .and. (ihandle.eq.0) ) return

	    if( (idev.eq.0) .and. (ihandle.ne.0) ) then
c
c		Write X/Y graph to ASCII text file in format
c		X <TAB> Y <CR> <LF>
c		Terminate with ASCII end-of-file marker ctrl-z
c
		call write_ascii_list(ihandle,xy,2,np)
		ieof = 26
		call write_bytes(ihandle,ierr,ieof,1)
		call close_file( ihandle, ierr )
		return
	    endif
	    CALL SET_SIZE(7000,10000,25000,22000)
c	    call set_polyline_width( idev, (iline_thickness-1)*50+3 )
	else
	    idev = iscreen
	    CALL SET_SIZE(7500,7000,20000,22000)
c	    call set_polyline_width( idev, 3 )
	endif

	call get_text_attributes( idev, i,i,i,i,i,
     &	ichar_width,ichar_height)
C
C	Draw histogram by joining up edges of bins
C
	bin_half = (xy(3) - xy(1))/2.
	work(1) = xy(1) - bin_half
	work(2) = 0.
	J = 2
	DO I = 1,np*2,2
	    J = J + 1
	    work(J) = xy(i) - bin_half
	    J = J + 1
	    work(J) = xy(I+1)
	    J = J + 1
	    work(J) = xy(i) + bin_half
	    J = J + 1
	    work(J) = xy(i+1)
	end do
	J = J + 1
	work(J) = work(j-2)
	J = J + 1
	work(J) = 0.
	NPLOT = J/2
C
	YMIN = 0.

	call draw_axes_manual(idev,xlo,ylo,xhi,yhi,xlabel,ylabel
     &	,'N','N','N',xtic,ytic )
	CALL DRAW_LINE(IDEV,work,NPLOT)

C
c	Display report list
c
	if( idev .eq. iscreen ) then
	    do i = 1,nlines
		call move_cursor(2,i+1)
		call display_string( report(i) )
	    end do
	else
	    IXY(1) = ICHAR_WIDTH
	    IXY(2) = max_ndc - ICHAR_HEIGHT*2
	    do i = 1,nlines
		ixy(2) = ixy(2) - ichar_height
		call graphics_text( idev, ixy, report(i) )
	    end do
	endif

C
C	Close hard copy workstation
C
	CALL GET_SCREEN_DEVICE(ISCREEN)
	IF( IDEV.NE.ISCREEN ) THEN
	    CALL UPDATE_WORKSTATION(IDEV)
	    CALL CLEAR_WORKSTATION(IDEV)
	    CALL UNLOAD_FONTS(IDEV)
	    CALL CLOSE_WORKSTATION(IDEV)
c
c	    If output has been to an HPGL file
c	    fix it to make it compatible with Microsoft Word
c	    and other programs
c
	    if( device(1:1) .eq. 'H' )
     &	     call fix_hpgl( device(2:len(device)) )
	ENDIF
	RETURN
	END

	subroutine summary(ifile,title,ir_s,ir_e,selected_type,
     &	ichan_in,nv)
$include:'wcpcom.for'
	integer*2 ifile 	! Unit No. of data file be analysed
	character*(*) title	! Name of file
	integer*2 ir_s,ir_e	! Start, End of record range
	character*(*) selected_type ! Type of record to be analysed
	integer*2 ichan_in	! Channel being worked on
	integer*2 nv		! No. of variables

	real*4 avg(nvars),sd(nvars)
	real*8 sum(nvars),db,dn
	character*51 text(nvars+3)
	equivalence( text, iwork(max_points*max_channels+1) )
	parameter( ileft=3, itop=3 )


	logical new_menu

	call erase_box( ileft,itop,ileft+len(text(1))+1,itop+nv+3)
	call display_box( ileft,itop,ileft+len(text(1))+1,itop+nv+3)
	call move_cursor( ileft+1, itop )
	call display_string( ' Summary ' )

	new_menu = .true.
	ichan = ichan_in
	call select_channel( ileft+1,itop+1, ' Channel ', ichan )

	call move_cursor( ileft+2, itop+1+ichan )
	call display_string( ' .. Wait .. ' )

c
c	Calculate averages
c
	do ivar = 1,nv
	    sum(ivar) = 0.
	end do
	dn = 0.
	do irecord = ir_s,ir_e
c
c	    Read analysis block of record from file
c
	    call get_analysis_block( ifile, irecord, rec.buf )

	    if( rec.status .eq. 'ACCEPTED' .and.
     &	    (rec.type .eq. selected_type .or.
     &	     selected_type .eq. 'ALL') ) then
c
c		If appropriate type and status add to summations
c
		do ivar = 1,nv
		    db = dble(rec.results(ichan,ivar))
		    sum(ivar) = sum(ivar) + db
		end do
		dn = dn + 1.

	    end if
	end do

	do ivar = 1,nv
	    avg(ivar) = sngl( sum(ivar)/dn )
	end do
c
c	Calculate standard deviation
c
	do ivar = 1,nv
	    sum(ivar) = 0.
	end do
	do irecord = ir_s,ir_e
	    call get_analysis_block( ifile, irecord, rec.buf )
	    if( rec.status .eq. 'ACCEPTED' .and.
     &	    (rec.type .eq. selected_type .or.
     &	     selected_type .eq. 'ALL') ) then
		do ivar = 1,nv
		    db = dble(rec.results(ichan,ivar) - avg(ivar) )
		    sum(ivar) = sum(ivar) + db*db
		end do
	    end if
	end do

	do ivar = 1,nv
	    sd(ivar) = sngl( sum(ivar)/dn )
	    if( sd(ivar) .gt. 0. ) sd(ivar) = sqrt( sd(ivar) )
	end do
c
c	Display results
c
	nl = 1
	text(nl) = title
	nl = nl + 1
	write(text(nl),
     &	'(''Ch.'',i1,1x,a,'' Records '',i5,''-'',i5,
     &	'' ('',i5,'') '',a)')
     &	ichan-1,y_name(ichan),ir_s,ir_e,int(dn),selected_type

	do ivar = 3,nv
	    nl = nl + 1
	    write( text(nl),
     &	    '(a,''='',1pg10.3,'' +/- '',1pg9.3,1x,a)' )
     &	    var_name(ivar),avg(ivar),sd(ivar),v_units(ivar)
	end do

	do il = 1,nl
	    call move_cursor( ileft+1, itop+il )
	    call display_string( text(il) )
	end do
c
c	Give user the option of sending results to printer or file
c
	call print_results( ileft+len(text(1)), itop+2, text, nl )
	return
	end

	subroutine trend_analysis( ileft, itop, xy, np )
c
c	Provide a statistical index of whether a trend exists
c	in an X/Y data set
c
	integer*2 ileft,itop ! Position of box on screen (IN)
	real*4 xy(1)	     ! Data points X,Y,... (IN)
	integer*2 np	     ! No. of pairs in xy (IN)

	character*50 string
	character key
	logical special
c
c	code
c

	call erase_box( ileft,itop,ileft+52,itop+4)
	call display_box( ileft,itop,ileft+52,itop+4)
	call move_cursor( ileft+1, itop )
	call display_string( ' Trend Analysis ' )

	call move_cursor( ileft+1, itop+1 )
	call display_string( ' ... WAIT ... ' )
c
c	Calculate slope and y-intercept of best-fit
c	straight line
c
        xavg = 0.                   ! Find mean values
        yavg = 0.                   ! of X and Y data
	do i = 1,np
	    j = 2*i
	    xavg = xavg + xy(j-1)
	    yavg = yavg + xy(j)
        end do
	xavg = xavg / float(np)
	yavg = yavg / float(np)
 
	xdiff = 0.
	xdiff2 = 0.
        ydiff = 0.
	do i = 1,np
	    j = 2*i
	    r = (xy(j-1) - xavg)*(xy(j-1) - xavg)
	    xdiff = xdiff + r
	    xdiff2 = xdiff2 + r*r
	    ydiff = (xy(j) - yavg)*(xy(j) - xavg) + ydiff
        end do
        slope = ydiff / xdiff
	y_intercept = yavg - slope*xavg
c
c	Standard deviation of data points from fitted line
c
	sd = 0.
	do i = 1,np
	    j = 2*i
	    r = xy(j) - xy(j-1)*slope - y_intercept
	    sd = sd + r*r
	end do
	sd = sqrt( sd / float(np-2) )

	if( xdiff2 .gt. 0. ) se_slope = sd / sqrt( xdiff2 )

	write(string,
     &	'('' Slope = '',1pg12.3,'' n= '',i5)') slope,np
	call move_cursor(ileft+1,itop+1)
	call display_string(string)
	write(string,
     &	'('' s.e. = '',1pg12.3)') se_slope
	call move_cursor(ileft+1,itop+2)
	call display_string(string)

	t_slope = abs( slope / se_slope )
	prob = 0.
	write(string,
     &	'(''    t = '',1pg12.3,'' p(>=t)='',f6.4)') t_slope,prob
	call move_cursor(ileft+1,itop+3)
	call display_string(string)

	call move_cursor(ileft+1,itop+4)
	call display_string(' Press any key to continue ')
	call wait_for_key( key, special )

        return
	end


