	subroutine simulations
$INCLUDE:'wcpcom.for'

	parameter(nmenu=4)
	character*30 menu(nmenu) /
     &	' Endplate Currents  F1',
     &	' Na currents        F2',
     &	' Single channels    F3',
     &	' Exit              ESC' /

	character key
	logical new_menu

	iop = Iwait_MENU_VERTICAL1(menu,'123$',nmenu,2,2,
     &	new_menu,iop,' Simulations ',key)

	select case( iop )
	case( 1 )
	    call epc_simulation
	case( 2 )
	    call na_simulation
	case( 3 )
	    call single_channel_simulation
	end select
	return
	end

	subroutine epc_simulation
$INCLUDE:'wcpcom.for'
c
c	Create simulated endplate currents
c	==================================
c
	parameter(nmenu=11)
	character*36 menu(nmenu) /
     &	' No. of records ',
     &	' MEPC amplitude (nA)',
     &	' MEPC amplitude s.d. (nA)',
     &	' Releasable pool (n)',
     &	' Release Probability (p)',
     &	' Fast time constant (ms)',
     &	' Slow time constant (ms)',
     &	' Amp. ratio (fast/fast+slow) ',
     &	' Background noise s.d. (nA)',
     &	' Backg. noise correlation (Hz)',
     &	' Detection jitter (samples)' /


	character*10 list(nmenu)
	character*34 title
	character key
	logical not_set / .true. /

	real*4 tau(2),amp(2),jitter
	external convert_gain
	character*70 new_file_name /' '/

c
c	code
c
	version = 5.

C -- Get parameters for exponential decay
C
	if( not_set ) then
	    gain(1) = 20.
	    y_units(1) = 'nA'
	    y_scale(1) = convert_gain( gain(1) )
	    exp_ratio = 1.
	    amp_mepc = 2.
	    background_sd = amp_mepc/40.
	    amp_mepc_sd = amp_mepc/10.
	    rn = 1.
	    rp = 1.

	    tau(1) = 20.*dt
	    tau(2) = 0.
	    not_set = .false.
	    jitter = 0.
	    n_requested = 20
	    correlation = 0.

	endif

	nc = len_trim( default_path )
	if( file_name(1:nc) .ne. default_path(1:nc) ) then
	    new_file_name = default_path
	else
	    new_file_name = file_name
	end if

	call get_file_name(3,4,new_file_name,'.wcp','NEW'
     &	,' File name ',iflag)

	if( iflag .ge. 0 ) then

	    file_name = new_file_name

	    open(unit=idata_file,
     &	    file=file_name,
     &	    form='binary',
     &	    access='direct',
     &	    recl=512,
     &	    iostat=istat)

	    if( iflag .eq. 1 ) then
		call get_header( idata_file )
	    else
		n_records = 0
		n_channels = 1
		gain(1) = 0.
	   end if

	   call write_to_log('Data File (simulation): '//file_name)

	else
	    return
	end if

C
	i = 1
	write(list(i),'(i5)') n_requested
	i = i + 1
	write(list(i),'(F8.2)') amp_mepc
	i = i + 1
	write(list(i),'(F8.2)') amp_mepc_sd
	i = i + 1
	write(list(i),'(F6.0)') rn
	i = i + 1
	write(list(i),'(F6.3)') rp

	if( t_units .eq. 's' ) then
	    tscale = 1000.
	else
	    tscale = 1.
	end if
	i = i + 1
	write(list(i),'(F8.2)') tau(1)
	i = i + 1
	write(list(i),'(F8.2)') tau(2)
	i = i + 1
	write(list(i),'(F8.2)') exp_ratio
	i = i + 1
	write(list(i),'(F8.2)') background_sd
	i = i + 1
	write(list(i),'(F8.2)') correlation
	i = i + 1
	write(list(i),'(F8.2)') jitter

	title = ' Simulation parameters '
	do while( title .ne. ' ' )

	    call text_window(menu,list,nmenu,3,8,title)

	    i = 1
	    n_requested = int(check_limits(list,1.,1E5,i,title))
	    if( title .ne. ' ' ) cycle

	    i = i + 1
	    amp_mepc = check_limits(list,-1E30,1E30,i,title)
	    if( title .ne. ' ' ) cycle

	    i = i + 1
	    amp_mepc_sd = check_limits(list,0.,1E30,i,title)
	    if( title .ne. ' ' ) cycle

	    i = i + 1
	    rn = check_limits(list,1.,1000.,i,title)
	    if( title .ne. ' ' ) cycle

	    i = i + 1
	    rp = check_limits(list,0.,1.,i,title)
	    if( title .ne. ' ' ) cycle

	    i = i + 1
	    tau(1) = check_limits(list,dt,1E30,i,title)
	    if( title .ne. ' ' ) cycle

	    i = i + 1
	    tau(2) = check_limits(list,0.,1E30,i,title)
	    if( title .ne. ' ' ) cycle

	    i = i + 1
	    exp_ratio = check_limits(list,0.,1.,i,title)
	    if( title .ne. ' ' ) cycle

	    i = i + 1
	    background_sd = check_limits(list,0.,1E30,i,title)
	    if( title .ne. ' ' ) cycle

	    i = i + 1
	    correlation = check_limits(list,0.,1E30,i,title)
	    if( title .ne. ' ' ) cycle

	    i = i + 1
	    jitter = check_limits(list,0.,float(n_points),i,title)
	    if( title .ne. ' ' ) cycle

	end do

c
c	Ensure that gain is set so that the digitised signals
c	are contained within the amplitude range of the record
c
	epc_max = rn*amp_mepc
	if( gain(1) .eq. 0. ) then
c
c	    This is a new file, so set gain(1) appropriately
c
	    adc_range = 5.
	    rec.ad_range = adc_range
	    y_scale(1) = abs(epc_max*1.5)/float(max_adc/2)
	    gain(1) = convert_gain( y_scale(1) )
	else
c
c	    Records are being appended to the end of an existing
c	    file, so gain(1) cannot be changed. Use rec.ad_range instead
c
	    rec.ad_range = adc_range
	    y_scale(1) = convert_gain( gain(1) )
	    rmax = y_scale(1)*float(max_adc/2)
	    rec.ad_range = adc_range*abs(epc_max*1.5)/rmax
	    y_scale(1) = convert_gain( gain(1) )
	end if
C
C	Set up random number generator with 3 randomly
C	chosen integers
C
	CALL SET_RANDOM(19,25831,1987)
C
C	Write to file
C
	irecord = 0
	amp(2) = 1. - exp_ratio
	amp(1) = 1. - amp(2)
	if( tau(2) .le. 0. ) then
	    npar = 3
	else
	    npar = 5
	end if


	n_end = n_records + n_requested
	do ir = 1,n_requested
C
C	    Create test signal
C
	    do i = 1,n_points
		j = (i-1)*n_channels + 1
		iwork(j) = 2048 +
     &		int(background_sd*gaussian_random()/y_scale(1))
	    end do

	    if( correlation .gt. 0. ) then

		var_unfiltered = calc_var( iwork, n_points )

		 fc = (correlation*1E-3)*dt
		 call move_cursor(1,1)
		 call display_flt(correlation)
		 call display_flt(fc)
		 call gaussian_filter(1,ibuffer,iwork,n_points,fc)

		var_filtered = calc_var( iwork, n_points )

		if( var_filtered .gt. 0. .and.
     &		    var_unfiltered .gt. 0. ) then
		    scale = sqrt( var_unfiltered/var_filtered )
		else
		    scale = 1.
		end if

		do i = 1,n_points
		    j = (i-1)*n_channels + 1
		    iwork(j) = int(float(iwork(j)-2048)*scale)+2048
		end do
	    end if

	    is = int( random()*jitter ) + n_points/8

	    rm = binomial( rp, rn )

	    amp_epc = amp_mepc*rm +
     &	    gaussian_random()*amp_mepc_sd/sqrt(max(rm,1.))

	    DO I=IS,n_points
		X = FLOAT(I-IS)*DT
		y = fexp( amp, tau, 0., npar, x )* amp_epc
		j = (i-1)*n_channels + 1
		iwork(j) = iwork(j) + int(y/y_scale(1))
	    end do

c
c	    Write record to file
c
	    n_records = n_records + 1
	    rec.time = FLOAT(n_records)
	    rec.status = 'ACCEPTED'
	    rec.type = 'TEST'
	    rec.number = float(n_records)
	    rec.dt = dt
	    rec.iequation = 0
            rec.is = 0
            rec.ie = 0
            rec.iz = 0

	    nb_data = (n_points*n_channels) / npoints_per_block
	    call put_record( idata_file, n_records, rec.buf, iwork )

	    call display_progress( 3, 21,
     &	    ' Records done (ESC to abort) ', n_records, n_end, key )

	    if( key .eq. '$' ) goto 201

	end do
201	continue
C
C	Update header block
C
	CALL SAVE_HEADER(idata_file)
	close(unit=idata_file)

	return
	end

	real function calc_var( ibuf, np )
	integer*2 ibuf(np)
c
c	Calculate variance of samples within buffer <ibuf)
c	of length <np> points

	sum = 0.
	do i = 1,np
	    sum = sum + float(ibuf(i))
	end do
	avg = sum / float(np)

	sum = 0.
	do i = 1,np
	    y = float(ibuf(i)) - avg
	    sum = sum + y*y
	end do
	calc_var = sum / float(np-1)
	return
	end


	subroutine na_simulation
$include:'wcpcom.for'
C
C	Create a .wcp file containing simulated Na currents
c	===================================================
C

	parameter(nmenu=9)
	character*30 menu(nmenu) /
     &	' No. of groups ',
     &	' Test pulses per group ',
     &	' Leak pulses per group ',
     &	' Gmax  (    )',
     &	' ^n ',
     &	' Tau.m (ms)',
     &	' Tau.h (ms)',
     &	' h.inf (0-1)',
     &	' Noise (     )' /
	character*12 list(nmenu)
	character*34 title
	character*70 new_file_name /' '/

	character key

	CHARACTER*4 G_UNITS

	parameter( vtest0 = 10., vincrement=5.)
	integer*2 i_m /3/
	real rh_inf /0.1/
	real gmax /0./
	real t_m /0./
	real t_h /0./
	real rnoise /0./
	integer*2 n_groups / 10 /
	integer*2 n_test / 1 /
	integer*2 n_leak / 4 /

C
C -- CODE ------------------------------------------------------
C
	new_file_name = file_name
	call get_file_name(3,5,new_file_name,'.wcp','NEW'
     &	,' File name ',iflag)

	if( iflag .ge. 0 ) then

	    file_name = new_file_name

	    open(unit=idata_file,
     &	    file=file_name,
     &	    form='binary',
     &	    access='direct',
     &	    recl=512,
     &	    iostat=istat)

	    if( iflag .eq. 1 ) then
		call get_header( idata_file )
	    else
		n_records = 0
		n_channels = 2
	   end if

	   call write_to_log('Data File (simulation): '//file_name)

	else
	    return
	end if

	gain(2) = 10.
	y_scale(2) = convert_gain( gain(2) )


C	Create appropriate conductance units for chosen current units
C
	IF(y_units(1)(1:1).EQ.'u') THEN
	    G_UNITS = 'uS'
	ELSEIF(y_units(1)(1:1).EQ.'n') THEN
	    G_UNITS = 'nS'
	ELSE
	    G_UNITS = 'pS'
	ENDIF

C
C -- Get parameters for H-H equation
c
	i = 1
	write( list(i), '(i3)' ) n_groups
	i = i + 1
	write( list(i), '(i3)' ) n_test
	i = i + 1
	write( list(i), '(i3)' ) n_leak
	i = i + 1
	ix = index( menu(i), '(') + 1
	menu(i)(ix:ix+3) = g_units
	if( gmax .eq. 0. ) gmax = (y_scale(1)*200.)/vtest0
	write(list(i),'(F12.3)') gmax
	gleak = gmax / 4.

	i = i + 1
	write(list(i),'(i2)') i_m

	i = i + 1
	if( t_m .eq. 0. ) t_m = dt*float(n_points/20)
	write(list(i),'(f12.3)') t_m

	i = i + 1
	if( t_h .eq. 0. ) t_h = dt*float(n_points/5)
	write(list(i),'(f12.3)') t_h

	i = i + 1
	write(list(i),'(f12.3)') rh_inf

	i = i + 1
	ix = index( menu(i), '(') + 1
	menu(i)(ix:ix+3) = y_units(1)
	if( rnoise .eq. 0. ) rnoise = 10.*y_scale(1)
	write(list(i),'(f12.3)') rnoise

	title = ' Simulation parameters '
	do while( title .ne. ' ' )
	    call text_window(menu,list,nmenu,3,8,title)

	    i = 1
	    n_groups = int( check_limits(list,1.,1E4,i,title) )
	    if( title .ne. ' ' ) cycle
	    i = i + 1
	    n_test = int( check_limits(list,1.,1E4,i,title) )
	    if( title .ne. ' ' ) cycle
	    i = i + 1
	    n_leak = int( check_limits(list,1.,1E4,i,title) )
	    if( title .ne. ' ' ) cycle
	    i = i + 1
	    gmax = check_limits(list,0.,1E30,i,title)
	    if( title .ne. ' ' ) cycle
	    i = i + 1
	    i_m = int( check_limits(list,1.,1E30,i,title) )
	    if( title .ne. ' ' ) cycle
	    i = i + 1
	    t_m = check_limits(list,dt,1E30,i,title)
	    if( title .ne. ' ' ) cycle
	    i = i + 1
	    t_h = check_limits(list,dt,1.E30,i,title)
	    if( title .ne. ' ' ) cycle
	    i = i + 1
	    rh_inf = check_limits(list,0.,1.,i,title)
	    if( title .ne. ' ' ) cycle
	    i = i + 1
	    rnoise = check_limits(list,0.,1E30,i,title)
	    if( title .ne. ' ' ) cycle
	end do
C
C	Set up random number generator with 3 randomly chosen integers
C
	CALL SET_RANDOM(19,25831,1987)
C
C	Write to file
C
	I_START = n_points/8
	I_END = n_points - i_start
	vleak = vtest0
	n_end = n_records + n_groups*(n_test+n_leak)
	do igroup = 1,n_groups

	    vtest = vtest0 + float(igroup-1)*vincrement
C
C	    Create leak current records
C
	    icleak = int(gleak*vleak/y_scale(1))
	    ivleak = int(vleak/y_scale(2))
	    TAU_C = FLOAT(i_end-i_start+1)/30.
	    C_PEAK = FLOAT(IVLEAK)*3.
	    j = 1
	    do i = 1,n_points
		ibuffer(i) = 2000
		iwork(j+1) = 3000
		if( i.ge.i_start .and. i.le.i_end ) then
		    ibuffer(i) = ibuffer(i) - icleak
     &		    - int( c_peak*exp(-float(i-i_start)/tau_c) )
		    iwork(j+1) = iwork(j+1) - ivleak
		end if
		j = j + n_channels
	    end do

	    rec.ad_range = adc_range
	    rec.type = 'LEAK'
	    rec.status = 'ACCEPTED'
	    rec.time = n_records
	    rec.dt = dt
	    rec.number = float(igroup)
            rec.is = 0
            rec.ie = 0
            rec.iz = 0


	    do ir = 1,n_leak
C
C		Add background noise
C
		rn = rnoise/y_scale(1)
		j = 1
		do i = 1,n_points
		    iwork(j) = ibuffer(i)
     &		    + int(gaussian_random()*rn)
		    j = j + n_channels
		end do

		n_records = n_records + 1
		nb_data = (n_points*n_channels)/npoints_per_block
		call put_record( idata_file, n_records, rec.buf, iwork )

		call display_progress( 3, 21,
     &		' Records done ', n_records, n_end, key )

	    end do
C
C	    Create test current records
C
	    icleak = int(gleak*vtest/y_scale(1))
	    ivtest = int(vtest/y_scale(2))
	    TAU_C = FLOAT(i_end-i_start+1)/30.
	    C_PEAK = FLOAT(ivtest)*3.
	    j = 1
	    do i = 1,n_points
		ibuffer(i) = 2000
		iwork(j+1) = 3000
		if( i.ge.i_start .and. i.le.i_end ) then
		    x = float(i-i_start)*dt
		    g = gmax*( (1. - exp(-x/t_m))**i_m )
     &		    *(rh_inf - (rh_inf-1.)*exp(-x/t_h) )
		    ibuffer(i) = ibuffer(i) + icleak
     &		    + int( g*vtest/y_scale(1) )
     &		    + int( c_peak*exp(-float(i-i_start)/tau_c) )
		    iwork(j+1) = iwork(j+1) + ivtest
		end if
		j = j + n_channels
	    end do

	    rec.ad_range = adc_range
	    rec.type = 'TEST'
	    rec.status = 'ACCEPTED'
	    rec.time = n_records
	    rec.dt = dt
	    rec.number = float(igroup)
            rec.is = 0
            rec.ie = 0
            rec.iz = 0


	    do ir = 1,n_test
C
C		Add background noise
C
		rn = rnoise/y_scale(1)
		j = 1
		do i = 1,n_points
		    iwork(j) = ibuffer(i) + int(gaussian_random()*rn)
		    j = j + n_channels
		end do

		n_records = n_records + 1
		nb_data = (n_points*n_channels) / npoints_per_block
		call put_record( idata_file, n_records, rec.buf, iwork )
	    end do

	    call display_progress( 3, 21,
     &	    ' Records done ', n_records, n_end, key )

	    if( key .eq. '$' ) goto 200

	end do
200	continue

	call save_header( idata_file )

	return
	end

	subroutine single_channel_simulation
$include:'wcpcom.for'
C
C	Create a .wcp file containing simulated single channel currents
c	===============================================================
C

	parameter(nmenu=7)
	character*30 menu(nmenu) /
     &	' No. of records ',
     &	' Unitary current amplitude (pA)',
     &	' Mean latency till first opening (ms)',
     &	' Mean open time (ms)',
     &	' Mean closed time within burst (ms)',
     &	' No. of openings per burst',
     &	' Random noise (pA)' /

	character*12 list(nmenu)
	character*34 title
	character*70 new_file_name /' '/

	character key

	parameter( iOpen=2,iClosed_long=0,iClosed_short=1 )
	parameter( vStep = 100. )
	logical first / .true. /

C
C -- CODE ------------------------------------------------------
C
	tMax = dt*float(n_points)
	if( first ) then
	    tLatency = tMax * 0.1
	    tClosed = tMax * 0.03
	    tOpen = tMax * 0.2
	    nOpenings = 3
	    UnitaryCurrent = 2.
	    rNoise = UnitaryCurrent * 0.05
	    n_records_required = 100
	    first = .false.
	end if

	new_file_name = file_name
	call get_file_name(3,5,new_file_name,'.wcp','NEW'
     &	,' File name ',iflag)

	if( iflag .ge. 0 ) then

	    file_name = new_file_name

	    open(unit=idata_file,
     &	    file=file_name,
     &	    form='binary',
     &	    access='direct',
     &	    recl=512,
     &	    iostat=istat)

	    if( iflag .eq. 1 ) then
		call get_header( idata_file )
	    else
		n_records = 0
		n_channels = 2
	   end if

	   call write_to_log('Data File (simulation): '//file_name)

	else
	    return
	end if

	y_units(1) = 'pA'
	gain(1) = 500.
	y_scale(1) = convert_gain(gain(1))

	y_units(2) = 'mV'
	gain(2) = 10.
	y_scale(2) = convert_gain( gain(2) )

C
C -- Get simulation parameters
c
	i = 1
	write( list(i), '(i3)' ) n_records_required
	i = i + 1
	write(list(i),'(f12.3)') UnitaryCurrent
	i = i + 1
	write(list(i),'(f12.3)') tLatency
	i = i + 1
	write(list(i),'(f12.3)') tOpen
	i = i + 1
	write(list(i),'(f12.3)') tClosed
	i = i + 1
	write( list(i), '(i3)' ) nOpenings
	i = i + 1
	write(list(i),'(f12.3)') rnoise

	title = ' Simulation parameters '
	do while( title .ne. ' ' )

	    call text_window(menu,list,nmenu,3,8,title)

	    i = 1
	    n_records_required =
     &	    int(check_limits(list,1.,1E4,i,title))
	    if( title .ne. ' ' ) cycle
	    i = i + 1
	    UnitaryCurrent = check_limits(list,-1000.,1000.,i,title)
	    if( title .ne. ' ' ) cycle
	    i = i + 1
	    tLatency = check_limits(list,0.,tMax,i,title)
	    if( title .ne. ' ' ) cycle
	    i = i + 1
	    tOpen = check_limits(list,0.,tMax,i,title)
	    if( title .ne. ' ' ) cycle
	    i = i + 1
	    tClosed = check_limits(list,0.,tMax,i,title)
	    if( title .ne. ' ' ) cycle
	    i = i + 1
	    nOpenings = int(check_limits(list,1.,1E4,i,title))
	    if( title .ne. ' ' ) cycle
	    i = i + 1
	    rnoise = check_limits(list,0.,1E30,i,title)
	    if( title .ne. ' ' ) cycle
	end do
C
C	Set up random number generator with 3 randomly chosen integers
C
	CALL SET_RANDOM(19,25831,1987)

	rOpen = dt /  tOpen
	rClosed_Long = dt / tLatency
	rClosed_Short = dt / tClosed
	rClosures_Per_Burst = rOpen / float( nOpenings )
	iClosedLevel = 0
	iOpenLevel = int ( UnitaryCurrent / y_scale(1) )
C
C	Write to file
C
	iStart = n_points/10
	do ir = 1,n_records_required
c
c	    Create voltage channel
c
	    iVstep = int( vStep / y_scale(2) )
	    iState = iClosed_Long
	    iLevel = iClosedLevel
	    do i = 1,n_points
		j = 2*i
		if( i .lt. iStart ) then
		    iWork(j) = 2048
		else
		    iWork(j) = 2048 + iVstep
		end if
	    end do
c
c	    Create single channel current signal
c	    ====================================
c

c
c	    Create a record with zero current background noise
c
	    rn = rnoise/y_scale(1)
	    do i = 1,n_points
		j = 2*i - 1
		iWork(j) = int(gaussian_random()*rn) + 2048
	    end do

	    X = random()
	    if( x .lt. 0.9 ) then
c
c		Add single channel currents for 9 out of 10
c		records (remainder left for leak subtraction)
c
		do i = iStart,n_points

		    X = random()
		    IF((ISTATE.EQ.ICLOSED_LONG)
     &		    .AND. (X.LE.RCLOSED_LONG)) THEN
			iState = iOpen
			iLEVEL = iOpenLevel
		    ELSEIF((ISTATE.EQ.ICLOSED_SHORT)
     &		    .AND. (X.LE.RCLOSED_SHORT)) THEN
			iState = iOpen
			iLEVEL = iOpenLevel
		    ELSEIF((ISTATE.EQ.IOPEN).AND. (X.LE.ROPEN)) THEN
			IF(X.LE.RCLOSURES_PER_BURST) THEN
			    ISTATE = ICLOSED_LONG
			    iLEVEL = iClosedLevel
			ELSE
			    ISTATE = ICLOSED_SHORT
			    iLevel = IClosedLevel
			ENDIF
		    ENDIF
		    j = 2*i - 1
		    iWork(j) = iWork(j) + iLEVEL
		end do

		rec.type = 'TEST'
	    else
		rec.type = 'LEAK'
	    end if
c
c	    Add capacity and leak current to single channel record
c
	    Tau_leak = float( n_points ) / 15.
	    Peak_leak = UnitaryCurrent*3.
	    Steady_leak = UnitaryCurrent
	    do i = iStart,n_points
		y_leak = Peak_leak*exp(-float(i-iStart)/Tau_leak) +
     &			 Steady_leak
		j = i*2 - 1
		iWork(j) = iWork(j) + int(y_leak/y_scale(1))
	    end do

	    rec.ad_range = adc_range
	    rec.status = 'ACCEPTED'
	    rec.time = n_records
	    rec.dt = dt
	    rec.number = float(ir)
            rec.is = 0
            rec.ie = 0
            rec.iz = 0

	    n_records = n_records + 1
	    call put_record( idata_file, n_records, rec.buf, iwork )

	    call display_progress( 3, 21,
     &	    ' Records done ', n_records, n_records_required, key )
	    if( key .eq. '$' ) goto 200

	end do
200	continue

	call save_header( idata_file )

	return
	end



	REAL FUNCTION RANDOM()
C
C	Algorithm AS183 - Random No. generator
C
	COMMON /RAND/ IX,IY,IZ
C
	IX = 171*MOD(IX,177) - 2*(IX/177)
	IY = 172*MOD(IY,176) - 35*(IY/176)
	IZ = 170*MOD(IZ,178) - 63*(IZ/178)
C
	IF(IX.LT.0) IX = IX + 30269
	IF(IY.LT.0) IY = IY + 30307
	IF(IZ.LT.0) IZ = IZ + 30323
C
	RANDOM = AMOD(FLOAT(IX)/30269. + FLOAT(IY)/30307. +
     &	FLOAT(IZ)/30323. ,1.)
	RETURN
	END
	SUBROUTINE SET_RANDOM(IX_IN,IY_IN,IZ_IN)
	COMMON /RAND/ IX,IY,IZ
	IX = IX_IN
	IY = IY_IN
	IZ = IZ_IN
	RETURN
	END

	subroutine check_file_name(ix,iy,
     &	file_name,extension,file_type,title)

	character*(*) file_name,extension,file_type,title
	character key

	parameter( nmenu=3 )
	character*16 menu(nmenu) /
     &	'Change Name F1',
     &	'Overwrite   F2',
     &	'Append      F3' /

	logical file_exists,new_menu

c	code
c
c
c	Add extension to file name
c
	nc = len_trim( file_name )
	if( extension .ne. ' ' ) then
	    i = index( file_name, '.' )
	    if( i .eq. 0 ) i = nc+1
	    file_name(i:i+3) = extension
	endif
c
c	Does a file of this name exist already?
c
	inquire( file=file_name, exist = file_exists )

	call upper_case( file_type )
	if( file_type .eq. 'NEW' ) then
c
c	    NEW file tests
c
	    if( file_exists ) then
		new_menu = .true.
		iop = 1
		iop = Iwait_MENU_VERTICAL1(menu,'123',nmenu,
     &		ix,iy,new_menu,iop,' File Exists! ',key)
		title = menu(max(iop,1))
	    else
		title = 'Overwrite'
	    end if
	else
c
c	    Open an OLD file
c
	    if( .not. file_exists ) then
		title = 'File not found!'
	    else
		title = ' '
	    endif
	endif

	return
	end

	real function gaussian_random()
	integer*2 iset/0/
	real v1,v2,r
c
	if( iset .eq. 0 ) then
1	    v1 = 2.*random()-1.
	    v2 = 2.*random()-1.
	    r = v1*v1 + v2*v2
	    if( r .ge. 1 ) goto 1
	    fac = sqrt( -2.*log(r)/r)
	    gset = v1*fac
	    gaussian_random = v2*fac
	    iset = 1
	else
	    gaussian_random = gset
	    iset = 0
	endif
	return
	end

	real*4 function binomial( p_in, n )
	real*4 p_in,n
	parameter(PI=3.141592654)
	real*4 p,mean,r,i,em,g,t,oldg,pc,pclog,y,plog,sq,zz
	logical quit

	if( p_in .le. 0.5 ) then
	    p = p_in
	else
	    p = 1. - p_in
	end if

	mean = n*p
	if( n .le. 25. ) then
	    r = 0.
	    do i = 1,n
		if( random() .lt. p ) r = r + 1.
	    end do
	else if( mean .lt. 1. ) then
	    g = exp(-mean)
	    t = 1.
	    r = 0.

	    do while( (r.lt.n) .and. (t .lt. g ) )
		t = t*random()
		r = r + 1
	    end do
	else
	   oldg = gammln(n+1.)
	   pc = 1. - p
	   plog = log(p)
	   pclog = log(pc)
	   sq = sqrt(2.*mean*pc)

	   quit = .FALSE.
	   do while( .not. quit )
	       zz = random()
	       y = tan(zz*PI)
	       em = sq*y + mean
	       if( em .ge. 0. .and. em .lt. n+1. ) then
		   em = float(int(em))
		   t = 1.2*sq*(1.+y*y)*exp(oldg-gammln(em+1.) -
     &		   gammln(n-em+1.) +
     &		   em*plog + (n-em)*pclog)
		   if( random() .le. t ) quit = .TRUE.
		end if
	    end do
	    r = em
	end if
	if( p .ne. p_in ) r = n - r
	binomial = r
	return
	end

	real*4 function gammln( xx )
	real*4 xx
	real*8 cof(7),stp,x,tmp,ser
	integer*2 i

	cof(1) = 76.18009173
	cof(2) = -86.50532033
	cof(3) = 24.01409822
	cof(4) = -1.231739516
	cof(5) = 0.120858003D-2
	cof(6) = -0.536382D-5
	stp = 2.50662827465

	x = dble(xx - 1.)
	tmp = x + 5.5
	tmp = ( x + 0.5)*log(tmp) - tmp
	ser = 1.
	do i = 1,6
	    x = x + 1.
	    ser = ser + cof(i)/x
	end do
	tmp = tmp + log(stp*ser)

	gammln = sngl(tmp)

	return
	end

	REAL FUNCTION FEXP(AMP,TAU,SS,NPAR,X)
C
C	SINGLE OR DOUBLE EXPONENTIAL FUNCTION
C	Enter with AMP = array of exponential amplitudes
C	TAU = times constants, SS = steady state
C	NPAR = 2 indicates single exp. decaying to zero
C	NPAR = 3 single exp. decaying to fitted steady-state
C	NPAR = 4 double exp. decaying to zero
C	NPAR = 5 double exp. decaying to fitted s-s
C

	REAL AMP(2),TAU(2)
	INTEGER*2 NPAR
C
	FEXP = 0.
	IF(NPAR .EQ. 2 ) THEN
		IF(TAU(1) .EQ. 0. ) RETURN
		FEXP = AMP(1)*EXP( -ABS(X/TAU(1)) )
	ELSEIF( NPAR .EQ. 3 ) THEN
		IF(TAU(1) .EQ. 0. ) RETURN
		FEXP = AMP(1)*EXP( -ABS(X/TAU(1)) ) + SS
	ELSEIF( NPAR .EQ. 4 ) THEN
		IF((TAU(1).EQ.0.).OR.(TAU(2).EQ.0.) ) RETURN
		FEXP = AMP(1)*EXP( -ABS(X/TAU(1)) )
     &		    +  AMP(2)*EXP( -ABS(X/TAU(2)) )
	ELSE
		IF((TAU(1).EQ.0.).OR.(TAU(2).EQ.0.) ) RETURN
		FEXP = AMP(1)*EXP( -ABS(X/TAU(1)) )
     &		    +  AMP(2)*EXP( -ABS(X/TAU(2)) ) + SS
	ENDIF
	RETURN
	END
