c	WCPSHA.FOR
c	This file contains routines which are shared between modules
c
	subroutine disc_full_warning()

	character*30 msg(2) /
     &	' WARNING ... Disc Full.',
     &	' Record not saved. ' /

	call display_message(3,3,28,msg,2)
	return
	end

	subroutine check_status( status, record_type, ok )
	character*(*) status,record_type
	logical ok

	if( status .eq. 'FAILURE' ) status = 'EVOKED'

	if( (status .ne. 'REJECTED') .and.
     &	((status.eq.record_type) .or. (record_type.eq.'ALL')) ) then
	    ok = .true.
	else
	    ok = .false.
	endif
	return
	end

c     Gaussian digital filter. (based on Sigworth, 1983)
      subroutine gaussian_filter(ichan,ix,iy,np,fc)
$include:'wcpcom.for'
      integer*2 ichan			    ! Channel in <iy> to be  filtered
      integer*2 ix(1)			   ! Signal working array (length=np)
      integer*2 iy(1)			   ! Data record with channels interleaved
      integer*2 np			    ! (In) No. of sample points
      real*4 fc 			    ! (In) Filter cut-off frequency (samples-1)
      parameter(max_nc=54)
      real*4 a(max_nc)			    ! Filter coefficients array

      sigma = .132505/fc
      if( sigma .ge. .62 ) then
c
c	   Generate positive half of filter coefficients
c		     1		   j2
c	   a(j) = ------- exp( - ------ )    j=0,nc
c		  +2p s 	  2 s2
c
	  b = -1./(2.*sigma*sigma)		      ! Create coefficients until
	  nc = 1				      ! limits of numerical precision
	  a(nc) = 1.				      ! is reached.
	  sum = .5
	  temp = 1.
	  do while( (temp.ge.2.*epsilon(temp)) .and. (nc.lt.max_nc) )
	      nc = nc + 1
	      temp = exp( float(nc-1)*float(nc-1)*b  )
	      a(nc) = temp
	      sum = sum + temp
	  end do

	  sum = sum*2.				       ! Normalise coefficients
	  do i = 1,nc				       ! so that they summate to 1.
	      a(i) = a(i)/sum
	  end do
	  nc = nc - 1
      else
c
c	 Special case for very light filtering (See Colquhoun & Sigworth, 1983)
c
	  a(2) = (sigma*sigma)/2.
	  a(1) = 1. - 2.*a(2)
	  nc = 1
      end if
c
c     Copy input channel into work array
c
      j = ichan
      do i = 1,np
	    ix(i) = iy(j)
	    j = j + n_channels
      end do

      iout = ichan
      do i = 1,np				       ! Apply filter
	  sum = 0.				       ! Note how filter
	  do j = i-nc,i+nc			       ! summation is truncated
	      l = max(min(j,np),1)
	      k = iabs(j-i)+1			       ! at each end of the array
	      sum = sum + float(ix(l))*a(k)
	  end do
	  iy(iout) = int(sum)
	  iout = iout + n_channels
      end do
      return
      end

      subroutine set_zero_level1(ibuf,icursor,ich)
$INCLUDE: 'wcpcom.for'
c
c	Set zero level for a channel.
c	(Called from WCPANA.FOR and WCPFIT.FOR)
c
	integer*2 ibuf(1)	! Buffer containing channel trace from record
	integer*2 icursor	! Current read-out cursor position
	integer*2 ich		! Channel No.

	character*28 menu(max_channels+1)
	character*38 title
	character*12 list(2)
	character key
	logical new_menu

c	Select zero mode
c	Relative to a sample within each record OR
c	relative to a fixed signal level
c
	menu(1) = ' Relative zero level '
	menu(2) = ' Fixed zero level '

	itype = Iwait_MENU_VERTICAL1(menu,'12'
     &	,2,3,3+ich,new_menu,iop,' Zero level ',key)

	if( itype .eq. 1 ) then
c
c	    Relative zero level
c
	    menu(1) = ' Zero level from sample '
	    write(list(1),'(i4)') icursor
	    menu(2) = ' No of samples averaged '
	    write(list(2),'(i4)') nzero

	    title = ' '
100	    if( title .eq. ' ' ) title = ' Relative zero level '
	    call text_window(menu,list,2,5,5+ich+itype,title)

	    izero_sample(ich) = int(check_limits(list,1.,
     &	    float(n_points),1,title))
	    if( title .ne. ' ' ) goto 100
	    nzero = int(check_limits(list,1.,
     &	    float(n_points),2,title))
	    if( title .ne. ' ' ) goto 100

	else
c
c	    Fixed zero level

	    izero_sample(ich) = 0

	    menu(1) = ' Set current level ('//y_units(ich)//')'
	    write(list(1),'(f8.2)')
     &	    float(ibuf(icursor)-iy_zero(ich))*y_scale(ich)

	    title = ' '
200	    if( title .eq. ' ' ) title = ' Fixed zero level '
	    call text_window(menu,list,1,5,5+itype,title)

	    r = check_limits(list,-1E30,1E30,1,title)
	    if( title .ne. ' ' ) goto 200
	    iy_zero(ich) = ibuf(icursor) - int(r/y_scale(ich))
	end if

	return
	end

	subroutine get_file_name(ix,iy,
     &	file_name,extension,file_type,title,iflag)

	character*(*) file_name,extension,file_type,title
	character key

	parameter( nnew=4 )
	character*16 new_menu(nnew) /
     &	' Change Name F1',
     &	' Overwrite   F2',
     &	' Append      F3',
     &	' Abort      ESC' /

	parameter( nold=2 )
	character*16 old_menu(nold) /
     &	' Change Name F1',
     &	' Abort      ESC' /

	logical file_exists,new_m,quit

	integer*2 overwrite,append,abort
	parameter( overwrite=0, append=1, abort=-1 )

c	code
c
	quit = .false.
	iflag = abort
	do while ( .not. quit )

	    lwidth = max(max(len(title)+2,len(file_name)+2),40)
	    call erase_box(ix,iy,ix+lwidth,iy+3)
	    call display_box(ix,iy,ix+lwidth,iy+3)
	    call move_cursor(ix+1,iy)
	    call display_string(title)
	    call move_cursor(ix+1,iy+3)
	    call display_string(' Press RETURN to continue, ESC=cancel ')

	    call move_cursor(ix+2,iy+1)
	    call get_string( file_name, nc, key )

	    if( key .ne. '$' ) then

		nc = len_trim( file_name )
		if( extension .ne. ' ' ) then
		    i = index( file_name, '.' )
		    if( i .eq. 0 ) i = nc+1
		    file_name(i:i+3) = extension
		endif
c
c		Does a file of this name exist already?
c
		inquire( file=file_name, exist = file_exists )

		call upper_case( file_type )

		if( file_type .eq. 'NEW' ) then
c
c		    NEW file tests
c
		    if( file_exists ) then
			new_m = .true.
			iop = 1
			iop = Iwait_MENU_VERTICAL1(new_menu,'123$',nnew,
     &			ix+1,iy+2,new_m,iop,' File Exists! ',key)

			if( iop.gt.1 ) quit = .true.
			if( iop.eq.2 ) iflag = overwrite
			if( iop.eq.3 ) iflag = append
			if( iop.eq.4 ) iflag = abort

		    else
c
c			If file does not exist
c			check to see if the file can be opened
c
			open(unit=9,file=file_name,iostat=istat )
			if( istat .ne. 0 ) then
			    call erase_box(ix+1,iy+4,ix+34,iy+6)
			    call display_box(ix+1,iy+4,ix+34,iy+6)
			    call move_cursor(ix+2,iy+5)
			    call display_string(
     &			    ' ERROR! Cannot create this file ')
			    quit = .false.
			    iflag = abort
			else
			    quit = .true.
			    iflag = overwrite
			end if
			close(unit=9,iostat=istat)

		    end if
		else
c
c		    Open an OLD file
c
		    if( .not. file_exists ) then
			new_m = .true.
			iop = 1
			iop = Iwait_MENU_VERTICAL1(old_menu,'1$',nold,
     &			ix+1,iy+2,new_m,iop,' File not found! ',key)
			if( iop .eq. 2 ) then
			    quit = .true.
			    iflag = abort
			end if
		    else
			quit = .true.
			iflag = overwrite
		    endif
		endif
	    else
		quit = .true.
		iflag = abort
	    end if
	end do

	return
	end

	subroutine variable_units( ich )
$include:'wcpcom.for'

	v_units(1) = ' '
	v_units(2) = 's'
	v_units(3) = y_units(ich)
	v_units(4) = y_units(ich)//'.'//t_units
	v_units(5) = y_units(ich)
	v_units(6) = t_units
	v_units(7) = y_units(ich)//'/'//t_units
	v_units(8) = t_units
	v_units(9) = t_units
	v_units(10) = y_units(ich)//'^2'
	v_units(11) = 's'

c
c	Curve fitting parameter units
c	(See routine define_equation in WCPFIT.FOR for details)
c
	ieq = mod(rec.iequation,100)
	select case( ieq )
	case( 1 )
	    v_units(12) = y_units(ich)
	    v_units(13) = t_units
	case( 2 )
	    v_units(12) = y_units(ich)
	    v_units(13) = t_units
	    v_units(14) = y_units(ich)
	case( 3 )
	    v_units(12) = y_units(ich)
	    v_units(13) = t_units
	    v_units(14) = y_units(ich)
	    v_units(15) = t_units
	case( 4 )
	    v_units(12) = y_units(ich)
	    v_units(13) = t_units
	    v_units(14) = y_units(ich)
	    v_units(15) = t_units
	    v_units(16) = y_units(ich)
	case( 5 )
	    v_units(12) = y_units(ich)
	    v_units(13) = t_units
	    v_units(14) = y_units(ich)
	    v_units(15) = t_units
	    v_units(16) = y_units(ich)
	    v_units(17) = t_units
	case( 6 )
	    v_units(12) = y_units(ich)
	    v_units(13) = t_units
	    v_units(14) = t_units
	case( 7 )
	    v_units(12) = y_units(ich)
	    v_units(13) = t_units
	    v_units(14) = t_units
	    v_units(15) = y_units(ich)
	case( 8 )
	    v_units(12) = y_units(ich)
	    v_units(13) = ' '
	    v_units(14) = t_units
	case( 9 )
	    v_units(12) = y_units(ich)
	    v_units(13) = t_units
	    v_units(14) = ' '
	    v_units(15) = t_units
	end select

	return
	end

	subroutine select_data_file( ix, iy, itype, ifile, title )
	character*(*) title
$include:'wcpcom.for'

	character key
	logical new_menu,file_exists

	parameter(nmenu=2)
	character*76 menu(nmenu)
	character*70 fname

c
c	code
c
	fname = file_name
	ic = index( fname, '.' )
	fname(ic:ic+3) = '.avg'
	inquire(file=fname,exist=file_exists)
	menu(1) = 'File: '//file_name
	menu(2) = 'Avgs: '//fname

	if( itype .eq. 0 ) then
	    if( file_exists ) then
		itype = Iwait_MENU_VERTICAL1(menu,'12'
     &		,nmenu,ix,iy,new_menu,itype,' File type ',key)
	    else
		itype = 1
	    end if
	end if

	if( itype .eq. 1 ) then
	    ifile = idata_file	    ! Data file selected
	    fname = file_name
	else
	    ifile = iavg_file	    ! Averages file selected
	end if

	open(unit=ifile,file=fname,form='binary',
     &	access='direct', recl=512, iostat=istat )
	call check_io_error( istat, 0 )

	call get_header( ifile )

	title = menu(itype)

	return
	end

	subroutine select_record_type( ix, iy, selected_type )
	character*(*) selected_type
$include:'wcpcom.for'

	character key
	logical new_menu
	character*16 menu(ntypes)

c
c	code
c
	itype = ntypes
	do i = 1,ntypes
	    menu(i) = record_type(i)
	    if( selected_type .eq. record_type(i) ) itype = i
	end do

	itype = Iwait_MENU_VERTICAL1(menu,'123456789'
     &	,ntypes,ix,iy,new_menu,itype,' Record type ',key)
	selected_type = record_type(itype)
	return
	end

	subroutine set_record_type( ix, iy, selected_type )
	character*(*) selected_type
$include:'wcpcom.for'

	character key
	logical new_menu
	character*16 menu(ntypes)

c
c	code
c
	itype = ntypes
	do i = 1,ntypes
	    menu(i) = record_type(i)
	    if( selected_type .eq. record_type(i) ) itype = i
	end do

	itype = Iwait_MENU_VERTICAL1(menu,'123456789'
     &	,ntypes-1,ix,iy,new_menu,itype,' Record type ',key)
	selected_type = record_type(itype)
	return
	end

	subroutine select_channel( ix, iy, title, ichan)
$include:'wcpcom.for'
	character*(*) title

	character key
	logical new_menu
	character*16 menu(ntypes)

c
c	code
c
	if( n_channels .gt. 1 ) then
	    do i = 1,n_channels
		write( menu(i), '('' Ch.'',i1,2x,a)') i-1,y_name(i)
	    end do

	    ichan = Iwait_MENU_VERTICAL1(menu,'123456789'
     &	    ,n_channels,ix,iy,new_menu,ichan,title,key)
	else
	    ichan = 1
	end if
	return
	end

	SUBROUTINE PUT_ANALYSIS_BLOCK(ifile,irecord,ianalysis)
$INCLUDE:'wcpcom.for'
	integer*2 ianalysis(1)

	nb_data = (n_points*n_channels)/npoints_per_block
	NB_record = NB_ANALYSIS + NB_DATA
	isector = (irecord - 1)*NB_record + 2
	write(unit=ifile,rec=isector,iostat=istat)
     &	(ianalysis(i),i=1,256*nb_analysis)
	call check_io_error( istat, irecord )
	return
	end

	SUBROUTINE put_record(ifile,irecord,ianalysis,ibuf)
	integer*2 ibuf(1)
	integer*2 ianalysis(1)
C
C	RECORDS ARE STORED AS COLLECTIONS OF recordS, EACH record
C	CONSISTING OF 'NB_ANALYSIS' BLOCKS AND 'NB_DATA' DATA BLOCKS.
C	A BLOCK CONTAINS 256 WORDS. THE FIRST BLOCK ON THE FILE
C	CONTAINS THE FILE HEADER DATA, AND THE RECORDS FOLLOW THEREAFTER.
C
$INCLUDE:'wcpcom.for'
C
C	ENSURE THAT record # REMAINS WITHIN LEGAL LIMITS FOR FILE
C
	nb_data = (n_points*n_channels)/npoints_per_block
	NB_record = NB_ANALYSIS + NB_DATA
	isector = (irecord - 1)*NB_record + 2
	write(unit=ifile,rec=isector,iostat=istat)
     &	(ianalysis(i),i=1,256*nb_analysis)
	call check_io_error( istat, irecord )
	write(unit=ifile,rec=isector+nb_analysis,iostat=istat)
     &	(ibuf(i),i=1,256*nb_data)
	call check_io_error( istat, irecord )
	n_records = max(n_records,irecord)
	return
	end

	SUBROUTINE get_record(ifile,irecord,ianalysis,ibuf)
	integer*2 ibuf(1)
	integer*2 ianalysis(1)
C
C	RECORDS ARE STORED AS COLLECTIONS OF recordS, EACH record
C	CONSISTING OF 'NB_ANALYSIS' BLOCKS AND 'NB_DATA' DATA BLOCKS.
C	A BLOCK CONTAINS 256 WORDS. THE FIRST BLOCK ON THE FILE
C	CONTAINS THE FILE HEADER DATA, AND THE RECORDS FOLLOW THEREAFTER.
C
$INCLUDE:'wcpcom.for'
C
C	ENSURE THAT record # REMAINS WITHIN LEGAL LIMITS FOR FILE
C
	irecord = min(max(1,irecord),n_records)
C
	nb_data = (n_points*n_channels)/npoints_per_block
	NB_record = NB_ANALYSIS + NB_DATA
	isector = (irecord - 1)*NB_record + 2
	read(unit=ifile,rec=isector,iostat=istat)
     &	(ianalysis(i),i=1,256*nb_analysis)
	call check_io_error( istat, irecord )
	read(unit=ifile,rec=isector+nb_analysis,iostat=istat)
     &	(ibuf(i),i=1,256*nb_data)
	call check_io_error( istat, irecord )

c
c	Calculate channel scaling factors
c
	do i = 1,n_channels
	    y_scale(i) = convert_gain( gain(i) )
	end do
c
c	Filter signals (if filter cut-off is non-zero)
c
	if( filter_cutoff .gt. 0. ) then
	    fc = filter_cutoff*dt
	    do ichan = 1,n_channels
		call gaussian_filter(ichan,ibuffer,ibuf,n_points,fc)
	    end do
	end if
c
c	Calculate channel zero levels
c
	do ich = 1,n_channels
	    if( izero_sample(ich) .gt. 0 ) then
		sum = 0.
		i0 = izero_sample(ich)
		i1 = min(izero_sample(ich)+nzero-1,n_points)
		do i = i0,i1
		    j = (i-1)*n_channels + ich
		    sum = sum + float(ibuf(j))
		end do
		iy_zero(ich) = int( sum/float(i1-i0+1) )
	    end if
	end do

	return
	end

	SUBROUTINE GET_ANALYSIS_BLOCK(ifile,irecord,ianalysis)
$INCLUDE:'wcpcom.for'
	integer*2 ianalysis(1)

	irecord = min(max(1,irecord),n_records)
	nb_data = (n_points*n_channels)/npoints_per_block
	NB_record = NB_ANALYSIS + NB_DATA
	isector = (irecord - 1)*NB_record + 2
	read(unit=ifile,rec=isector,iostat=istat)
     &	(ianalysis(i),i=1,256*nb_analysis)
	call check_io_error( istat, irecord )
	return
	end

	SUBROUTINE change_record(ifile,irecord,istep,ianalysis,ibuf)
	integer*2 ibuf(1)
	integer*2 ianalysis(1)
C
C	Save current record's analysis block
c	and read next record (irecord+istep)
C
$INCLUDE:'wcpcom.for'

	CALL put_analysis_block(ifile,irecord,ianalysis)
	irecord = irecord + ISTEP
	irecord = min(max(1,irecord),n_records)
	CALL get_record(ifile,irecord,ianalysis,ibuf)
	return
	end

	subroutine find_next_record(ifile,irecord,ibuf,
     &	selected_type,istep_in,ich,out_of_range)
$include:'wcpcom.for'
	character*(*) selected_type
	integer*2 ibuf(1)
	logical done,out_of_range


	iold = irecord
	done = .false.
	out_of_range = .false.
	istep = istep_in
	do while( .not. done .and. .not. out_of_range )

	    irecord = irecord + istep
	    if( istep .ge. 0 ) then
		istep = 1
	    else
		istep = -1
	    end if
	    if( irecord .gt. n_records .or. irecord.lt.1 ) then
		irecord = iold
		out_of_range = .true.
	    end if

	    call get_record( ifile, irecord, rec.buf, ibuf )

	    if( rec.status .eq. 'ACCEPTED' .and.
     &	    (rec.type .eq. selected_type .or.
     &	     selected_type .eq. 'ALL') ) done = .true.

	end do

	j = ich
	do i = 1,n_points
	    ibuf(i) = ibuf(j)
	    j = j + n_channels
	end do

	return
	end

	subroutine display_results( text, istart, iend )
	character*(*) text(1)

	parameter(ileft=1,nheight=10,nwidth=60)

	iright = ileft + nwidth + 1
	itop = nheight + 3
	call erase_box(ileft,itop,iright,25)
	call display_box(ileft,itop,iright,25)

	do i = istart,iend
	    call move_cursor(ileft+1,itop+i-istart+1)
	    call display_string( text(i) )
	end do

	return
	end

	subroutine set_record_range(ir_s,ir_e,ix,iy,title_in)
$include:'wcpcom.for'
c
c	Set range of records to be analysed
c
	character*(*) title_in
	parameter(nmenu=2)
	character*34 menu(nmenu) /
     &	' Start at record ',
     &	' End at record '/
	character*6 list(nmenu)
	character*36 title / ' ' /
	integer*2 n_records_old /0/


	if( ir_s .le. 0 ) ir_s = 1
	if(ir_e.le.0 .or. n_records_old.ne.n_records) ir_e = n_records
	n_records_old = n_records

	i = 1
	write( menu(i), '('' Start at record (1-'',i4,'')'')') n_records
	write( list(i), '(i4)' ) ir_s
	i = i + 1
	write( list(i), '(i4)' ) ir_e

10	if( title .eq. ' ' ) title = title_in
	call text_window(menu,list,nmenu,ix,iy,title)

	i = 1
	ir_s = int(check_limits(list,1.,float(n_records),i,title))
	if( title .ne. ' ' ) goto 10
	i = 1 + i
	ir_e = int(check_limits(list,1.,float(n_records),i,title))
	if( title .ne. ' ' ) goto 10
	ir_e = max(ir_e,ir_s)

	return
	end

	subroutine display_cursor( idevice, iarea, ix_in, np )
	integer*2 iarea(4)
C
C	Draw a vertical cursor within the display area "iarea(1..4)"
C
$INCLUDE:'GEMCOM.FOR'
C
C
	ix_spacing = (iarea(3) - iarea(1) ) / np
	IPTSIN(1) = iarea(1) + (IX_IN-1)*IX_SPACING
	IPTSIN(2) = iarea(2)
	IPTSIN(3) = IPTSIN(1)
	IPTSIN(4) = iarea(4)
	CALL POLYLINE( IDEVICE, IPTSIN, 2 )
	RETURN
	END

	real*4 function convert_gain( g )
$include:'wcpcom.for'

	if( rec.ad_range .le. 0. ) rec.ad_range = adc_range
	r = (2000.*rec.ad_range)/(g*float(max_adc))
	convert_gain = r
	return
	end

	subroutine select_plot_device(ix,iy,idev,ihandle,device)
$include: 'wcpcom.for'
c
c	Let user select plotter output device
c
c	IX,IY = top left of entry form
c	Workstation No. returned in IDEV
c	Output file handle returned in IHANDLE (with IDEV=0)
c	IDEV and IHANDLE = 0 indicates abort
c	DEVICE is returned with letter pressed by user
c
	character*(*) device

	parameter(nmenu=6,iprinter=2,iplotter=3,ifile=4,idisplay=1
     &	,ihpgl=5)
	character*20 menu(nmenu) /
     &	' Screen       S',
     &	' Printer      R',
     &	' Plotter      P',
     &	' ASCII file   F',
     &	' HPGL file    H',
     &	' Cancel     ESC'/

	character*70 list_file / ' ' /
	character*6 keys /'SRPFH$'/
	logical new_menu
	character key

	if( list_file .eq. ' ' ) list_file = default_path

	new_menu = .true.
	itype = Iwait_MENU_VERTICAL1(menu,keys,nmenu,ix,iy,new_menu
     &	,itype,' Output to: ',key)

	select case ( itype )
	case ( idisplay )
c
c	    Write to screen
c
	    call get_screen_device(idev)

	case (iplotter)
c
c	    Open plotter
c
	    call display_message(ix+1,iy+1,22,' WAIT ... Plotting ',1)
	    CALL OPEN_WORKSTATION(IDEV,11)
	    CALL LOAD_FONTS(IDEV)
	    CALL SET_TEXT_FACE(IDEV,1)

	    iheight = int( (32767./12.)*(14. / 72.) )
	    call set_character_height( idev, iheight )

	case ( iprinter )
c
c	    Open printer
c
	    call display_message(ix+1,iy+1,22,' WAIT ... Plotting ',1)
	    CALL OPEN_WORKSTATION(IDEV,21)
	    CALL LOAD_FONTS(IDEV)
	    CALL SET_TEXT_FACE(IDEV,max(ifont,1))
	    call set_point_size( idev, max(ipoint_size,10) )

	case ( ifile )
c
c	    Open ASCII file
c
	    call get_file_name(ix+1,iy+itype+1,
     &	    list_file,' ','NEW',
     &	    ' ASCII file ',iflag)
	    if( iflag .ge. 0 ) then
		ihandle = itemp_file
		if( iflag .eq. 0 ) then
		    open(unit=ihandle,
     &		    file=list_file,
     &		    form='binary',
     &		    err=100)
		else
		    open(unit=ihandle,file=list_file,form='binary',
     &		    access='APPEND',err=100)
		end if
		idev = 0
		call display_message(ix+2,iy+2,28
     &		,' WAIT ... Writing to file ',1)
100		continue
	    else
		idev = 0
		ihandle = 0
	    endif

	case  (ihpgl )
c
c	    Output to an HPGL file
c
	    call get_file_name(ix,iy+itype+1,
     &	    list_file,' ','NEW',
     &	    ' HPGL file ',iflag)
	    if( iflag .ge. 0 ) then
		call display_message(ix+1,iy+1,22,' WAIT ... Plotting ',1)
		CALL OPEN_WORKSTATION_to_file(IDEV,11,list_file)
		CALL LOAD_FONTS(IDEV)
		CALL SET_TEXT_FACE(IDEV,1)
		iheight = int( (32767./12.)*(14. / 72.) )
		call set_character_height( idev, iheight )

	    endif

	case default
c
c	    ESC = abort plot
c
	    idev = 0
	    ihandle = 0

	end select

	if( itype .ne. 0 ) then
	    device = keys(itype:itype)
	    if( device(1:1) .eq. 'H')
     &	    device(2:len(device)) = list_file
	else
	    device = ' '
	endif
	return
	end

	subroutine write_ascii_list(ihandle,rlist,ncols,nrows)
c
c	Write contents of REAL array RLIST(NCOLS,NROWS) to file
c	as NROWS rows of ASCII text (NCOLS per row) to file
c	attached to IHANDLE

	character tab,cr,lf
	real rlist(ncols,nrows)

	character*200 string
	integer*1 istring(200)
	equivalence(string,istring)

c
c	code
c
	tab = char(9)
	cr = char(13)
	lf = char(10)
	do irow = 1,nrows
	    string = ' '
	    j = 1
	    do icol = 1,ncols
		write(string(j:j+12),'(1pg12.5,a)') rlist(icol,irow),tab
		j = j + 13
	    end do
	    string(j-1:j+1) = cr//lf
	    nc = len_trim( string )
	    call write_bytes(ihandle,ierr,istring,nc)
	end do
	return
	end

	subroutine print_results( ix, iy, text, nlines )
$include:'wcpcom.for'
c
c	Print results to printer or file
c
	character*(*) text(nlines)

	parameter(nmenu=4)
	character*22 menu(nmenu) /
     &	' To printer (LPT1)  F1',
     &	' To ASCII text file F2',
     &  '                    F3',
     &	' Exit              ESC' /

	logical new_menu,quit
	character*2 crlf
	integer*2 ixy(2)
	character*70 list_file / ' ' /
	character key
	integer*2 iop /4/
c
c	code
c
	quit = .false.
	do while( .not. quit )

	    new_menu = .true.
	    iop = Iwait_MENU_VERTICAL1(menu,'123$',nmenu,ix,iy,
     &	    new_menu,iop,' Print results ',key)

	    crlf = char(13)//char(10)
	    select case (iop)
	    case( 1 )
c
c		Print summary on printer LPT1
c
		call open_workstation( idev, 21 )
		call load_fonts( idev )
		call set_text_face( idev, 2 )
		call set_point_size( idev, 10 )
		call get_text_attributes( idev, i,i,i,i,i,ncw,nch)

		ixy(1) = 10*ncw
		ixy(2) = max_ndc - 5*nch
		do il = 1,nlines
		    call graphics_text( idev, ixy, text(il) )
		    ixy(2) = ixy(2) - nch
		end do

		CALL UPDATE_WORKSTATION(Idev)
		CALL CLEAR_WORKSTATION(Idev)
		CALL UnlOAD_FONTS(Idev)
		CALL CLOSE_WORKSTATION(Idev)

	    case( 2 )
c
c		Write summary to an ASCII text file
c
		if( list_file .eq. ' ' ) list_file = default_path
		ix1 = ix + 1
		nw = max( len(list_file) + 2,40)
		if( ix1 + nw .gt. 78 ) ix1 = 78 - nw
		call get_file_name(ix1,iy+iop+1,list_file,' ','NEW'
     &		,' Text file name ',iflag)

		if( iflag .ge. 0 ) then

		    if( iflag .eq. 0 ) then
			open(unit=itemp_file,file=list_file,
     &			form='binary',iostat=istat)
		    else
			open(unit=itemp_file,file=list_file,
     &			form='binary',access='APPEND',iostat=istat)
		    end if

		    do il = 1,nlines
			write(unit=itemp_file,iostat=istat) text(il)
			write(unit=itemp_file,iostat=istat) crlf
		    end do
		    write(unit=itemp_file,iostat=istat) char(26)
		    close(unit=itemp_file)
		end if

	    case( 3 )
c
c               Write summary to log file (disabled)
c
c                do il = 1,nlines
c                    write(unit=ilog_file) text(il)
c                    write(unit=ilog_file) char(13)//char(10)
c                end do

	    case( 4 )
		quit = .true.
	    end select
	end do

	return
	end


	subroutine time_of_day( string )
	character*(*) string

	call gettim( ihr, imin, isec, icsec )
	write( string, '(i2,'':'',i2,''.'',i2)') ihr,imin,isec
	if( string(4:4) .eq. ' ' ) string(4:4) = '0'
	if( string(7:7) .eq. ' ' ) string(7:7) = '0'
	return
	end

	subroutine write_to_log( string )
$include:'wcpcom.for'
	character*(*) string
	character*12 tod

c	 call time_of_day( tod )
c	 write(unit=ilog_file,iostat=istat) tod
c	 write(unit=ilog_file,iostat=istat) string(1:len_trim(string))
c	 write(unit=ilog_file,iostat=istat) char(13)//char(10)

	return
	end

	subroutine display_progress( ix,iy, title, i,n, key )
	character*(*) title,key

	character*60 string
	logical special

	nc = len_trim(title) + 14
	call erase_box(ix,iy,ix+nc+2,iy+2)
	call display_box(ix,iy,ix+nc+2,iy+2)
	call move_cursor(ix+1,iy+1)
	write(string,'(a,1x,i5,''/'',i5)') title,i,n
	call display_string( string(1:nc) )
	call get_key( key, special )
	return
	end

	subroutine fix_hpgl( fname )
$include:'wcpcom.for'

	character*(*) fname
	character*30 temp_name / ' ' /
	parameter(iout_file=10)
	character ch

	open( unit=itemp_file,
     &	file=fname,
     &	form='binary' )

	temp_name = fname
	ix = index(temp_name,'.')
	if( ix .le. 0 ) ix = len_trim(temp_name)+1
	temp_name(ix:ix+3) = '.tzz'

	open( unit=iout_file,
     &	file=temp_name,
     &	form='binary' )

	do while( .not. eof(itemp_file) )
	    read( unit=itemp_file ) ch
	    write( unit=iout_file ) ch
	    if(ch.eq.';') write(unit=iout_file) char(13)//char(10)
	end do

	close(unit=itemp_file)
	close(unit=iout_file)

	call delete_file( ierr, fname )
	call rename_file( ierr, temp_name, fname )
	return
	end

	subroutine check_io_error( istat, irecord )
c
c	If a file I/O error has occurred, display error #
c	at bottom of screen

	character*38 string

	if( istat .ne. 0 ) then
	    call move_cursor(1,25)
	    write( string,
     &	    '(''File I/O error'',i5,'' at record '',i5)')
     &	    istat,irecord
	    call display_reversed( string )
	end if

	return
	end

	subroutine error_msg( ix, iy, msg )


	character*(*) msg

	character*70 string

	string = msg
	nc = len_trim( string )
	call move_cursor(ix,iy)
	call get_screen_device( iscreen )
	call set_text_colour( iscreen, 2 )
	call display_string( string(1:nc+1) )
	call wait(1.)
	call set_text_colour( iscreen, 1 )
	string = ' '
	call display_string( string(1:nc+1) )
	return
	end

	subroutine create_path( path, dir_path, fname, fext )
	character*(*) path, dir_path, fname, fext
c
c	Create a complete file path (In path) by assembling the
c	directory path (dir_path), file name (fname) and
c	file extension) (fext components

	nc = len(path)
	if( dir_path .ne. ' ' ) then
	    path = dir_path
	    ix = len_trim(path)+1
	else
	    path = ' '
	    ix = 1
	end if

	path(ix:nc) = fname

	if( fext .ne. ' ' ) then
	    ix = index( path, '.' )
	    if( ix .le. 0 ) ix = len_trim(path)+1
	    path(ix:nc) = fext
	end if
	return
	end


