	subroutine setup
c       11/4/96 ... WCP V1.6 New file routines removed
$INCLUDE: 'wcpcom.for'

	PARAMETER(IMENU_LEFT=63,IMENU_TOP=1,NROW=13,NCOL=1)
	CHARACTER*32 MENU(NROW) /
     &	' Record size                 F1',
     &	' No. of input channels       F2',
     &	' Input voltage range         F3',
     &	' Digital sampling interval   F4',
     &	' Channel names               F5',
     &	' Channel units               F6',
     &	' Channel scale factors       F7',
     &	' Event detector              F8',
     &	' Record types                F9',
     &	' Printer typeface             F',
     &	' Printer line width           W',
     &	' Channel display colours      C',
     &	' Exit                       ESC' /

	logical quit,new_menu
	character key
c
c	code
c
	call get_header( idata_file )

	n_points_old = n_points
	n_channels_old = n_channels

	quit = .false.
	do while( .not. quit )
C
C	    Erase and re-display screen
C
	    call erase_box(2,2,56,23)
C
C	    Wait for user to select an option from the menu
C
	    new_menu = .true.
	    iop = iwait_menu_vertical1(menu,'123456789FWC$',nrow,
     &	    2,2,new_menu,iop,' Setup ',key)

	    select case( iop )
	    case( 1 )
		if (n_records .eq. 0) then
		    call set_record_size( 5,4 )
		else
		    call error_msg(5,3,'Not Allowed! File must be empty.')
		end if
	    case( 2 )
		if (n_records .eq. 0) then
		    call set_channels( 5,5 )
		else
		    call error_msg(5,4,'Not Allowed! File must be empty.')
		end if
	    case( 3 )
		call set_adc_range( 5,6, adc_range )
	    case( 4 )
		call set_sampling_interval( 5,7 )
	    case( 5 )
		call set_channel_name( 5,8 )
	    case( 6 )
		call set_channel_units( 5,9 )
	    case( 7 )
		call set_channel_scale_factor( 5,10 )
	    case( 8 )
		call set_detector( 5, 11 )
	    case( 9 )
		call set_record_types( 5, 12 )
	    case( 10 )
		call select_font( 5,13, ifont, ipoint_size )
	    case( 11 )
		call set_line_thickness( 5, 14 )
	    case( 12 )
		call set_channel_colours( 5, 15 )
	    case( 13 )
		quit = .true.
	    end select
	end do
c
c	Save new parameters to data file header block
c
	call save_header( idata_file )

	return
	end

	subroutine set_record_size(ix,iy)
$INCLUDE: 'wcpcom.for'
c
c	Select analogue sampling interval.
c	dt returned in units of seconds

	parameter(nmenu=4)
	character*20 menu(nmenu) /
     &	'  256 ',
     &	'  512 ',
     &	' 1024 ',
     &	' 2048 ' /

	logical new_menu
	character key
	integer*2 isize(nmenu) / 256,512,1024,2048 /
c
c       code
c
	n_old = n_points

	iop = 1
	do while( (isize(iop) .lt. n_points) .and. iop.lt.4 )
	    iop = iop + 1
	end do
	new_menu = .true.
	iop = Iwait_MENU_vERTICAL1(menu,'1234'
     &	,nmenu,ix,iy,new_menu,iop,' Record Size ',key)

	n_points = isize(iop)
	nb_data = (n_channels*n_points)/npoints_per_block

	return
	end

	subroutine set_channels( ix, iy )
$INCLUDE: 'wcpcom.for'
c
c	Select analogue sampling interval.
c	dt returned in units of seconds

	character*20 menu(max_channels) /
     &	' 1 ',
     &	' 2 ',
     &	' 3 ',
     &	' 4 ',
     &	' 5 ',
     &	' 6 ' /

	logical new_menu
	character key
c
c	code
c

	n_old = n_channels
	new_menu = .true.
	n_channels = Iwait_MENU_vERTICAL1(menu,'123456'
     &	,max_channels,ix,iy,new_menu,n_channels,' No. channels ',key)

	n_channels = max(n_channels,1)
	nb_data = (n_channels*n_points)/npoints_per_block

	return
	end

	subroutine set_adc_range( ix, iy, ad_range )
$INCLUDE: 'wcpcom.for'
c
c	Select analogue input voltage range (unit = Volts )

	character*22 menu(10)
	real*4 adc(10)

	logical new_menu
	character key


	call get_adc_ranges( interface_card, adc, nmenu )

	do i = 1,nmenu
	    write( menu(i), '('' +/-'',f8.2,''V'')') adc(i)
	end do

	iop = 1
	do while( (adc(iop) .gt. ad_range) .and. iop.lt.nmenu )
	    iop = iop + 1
	end do

	new_menu = .true.
	iop = Iwait_MENU_vERTICAL1(menu,'123456789'
     &	,nmenu,ix,iy,new_menu,iop,' Input voltage range ',key)

	ad_range = adc(max(iop,1))
	return
	end

	SUBROUTINE set_sampling_interval( ix, iy )
$INCLUDE: 'wcpcom.for'
C
C	Set digital sampling interval
C
	PARAMETER(NROWS=1)
	character*30 menu(nrows)
	CHARACTER*12 LIST(NROWS)
	character*38 title
C
C	CODE
C	----

c
c	Get allowed interval limits for the interface unit
c
	CALL LAB_LIMITS(INTERFACE_CARD,DT_MIN,DT_MAX,AD_MIN,AD_MAX,DAC)
	dmin = dt_min*float(n_channels)     ! Time in ms
	dmax = dt_max*float(n_channels)

	write( menu(1),
     &	'(''('',1pg10.2,''-'',1pg10.0,'') ms'')') dmin,dmax
	write(list(1),'(f9.3)') dt
	title = ' '
100	if( title .eq. ' ' ) title = ' Set sampling interval '
C
	CALL TEXT_WINDOW(MENU,LIST,NROWS,ix,iy,title)
C
	i = 1
	dt = check_limits(list,dmin,dmax,i,title)
	if( title .ne. ' ' ) goto 100

	if( dt .gt. 5. ) then
	    tscale = 0.001
	    t_units = 's'
	else
	    tscale = 1.
	    t_units = 'ms'
	end if


	return
	end

	SUBROUTINE set_channel_name( ix, iy )
$INCLUDE: 'wcpcom.for'
C
C	Set or change a/d input channels
C
	PARAMETER(NROWS=max_channels)
	character*36 menu(nrows)
	CHARACTER*2 LIST(NROWS)
	character*36 title
C
C	CODE
C	----

	do i = 1,n_channels
	    write( menu(i), '('' Ch.'',i1,'' Name '')') i-1
	    list(i) = y_name(i)
	end do

	title = ' '
100	if( title .eq. ' ' ) title = ' Set channel names '
C
	CALL TEXT_WINDOW(MENU,LIST,n_channels,ix,iy,title)
C
	do i = 1,n_channels
	    call extract_string( list(i), y_name(i) )
	end do
	return
	end

	SUBROUTINE set_channel_units( ix, iy )
$INCLUDE: 'wcpcom.for'
C
C	Set channel units
C
	PARAMETER(NROWS=max_channels)
	character*30 menu(nrows)
	CHARACTER*2 LIST(NROWS)
	character*36 title
C
C	CODE
C	----

	do i = 1,n_channels
	    write( menu(i), '('' Ch.'',i1,'' Units '')') i-1
	    list(i) = y_units(i)
	end do

	title = ' '
100	if( title .eq. ' ' ) title = ' Set channel units '
C
	CALL TEXT_WINDOW(MENU,LIST,n_channels,ix,iy,title)
C
	do i = 1,n_channels
	    call extract_string( list(i), y_units(i) )
	end do
	return
	end

	SUBROUTINE set_channel_scale_factor( ix, iy )
$INCLUDE: 'wcpcom.for'
C
C	Set channel units
C
	PARAMETER(NROWS=max_channels)
	character*30 menu(nrows)
	CHARACTER*12 LIST(NROWS)
	character*36 title
C
C	CODE
C	----

	do i = 1,n_channels
	    write( menu(i),
     &	    '('' Ch.'',i1,'' Scale factor mV/'',a)') i-1,y_units(i)
	    write(list(i),'(f10.3)') gain(i)
	end do

	title = ' '
100	if( title .eq. ' ' ) title = ' Set channel scale factor '
C
	CALL TEXT_WINDOW(MENU,LIST,n_channels,ix,iy,title)
C
	do i = 1,n_channels
	    gain(i) = check_limits(list,0.,1E30,i,title)
	    if( title .ne. ' ' ) goto 100
	    y_scale(i) = convert_gain( gain(i) )
	end do
	return
	end

	SUBROUTINE set_detector( ix, iy )
$INCLUDE: 'wcpcom.for'
C
C	Set or change a/d input channels
C
	PARAMETER(NROWS=2)
	character*32 menu(nrows) /
     &	' Trigger level (% full scale)',
     &	' Pre-trigger points (%)' /
	CHARACTER*12 LIST(NROWS)
	character*44 title
C
C	CODE
C	----

C
C	Insert current values into reponse field of form
C
	i = 1
	write( list(i), '(f6.1)' ) trigger_level
	i = i + 1
	write( list(i), '(f6.1)' ) pre_trigger
C
	title = ' '
100	if( title .eq. ' ' ) title = ' Set event detector '
C
	CALL TEXT_WINDOW(MENU,LIST,NROWS,ix,iy,title)
C
	i = 1
	trigger_level = check_limits(list,-100.,100.,i,title)
	i = i + 1
	pre_trigger = check_limits(list,0.,100.,i,title)
	return
	end

	SUBROUTINE set_record_types( ix, iy )
$INCLUDE: 'wcpcom.for'
C
C	Set record types
C
	character*20 menu(ntypes)
	character*20 title
C
C	CODE
C	----

	do i = 1,ntypes-1
	    write( menu(i), '('' Type '',i1)') i
	end do

	title = ' '
100	if( title .eq. ' ' ) title = ' Record types '
	CALL TEXT_WINDOW(MENU,record_type,ntypes-1,ix,iy,title)
	record_type(ntypes) = 'ALL'
	return
	end

	subroutine extract_string( list, string )
	character*(*) list, string

	ix = ileading_space( list )
	ns = len( string )
	nl = len( list )
	string = list(ix:min(ix+ns-1,nl))
	return
	end

	subroutine set_line_thickness( ix, iy )
$INCLUDE: 'wcpcom.for'

	call display_message(ix,iy,40,' Line Thickness (1-6) ',1)
	r = float( iline_thickness )
	call get_number(r,1.,10.,r)
	iline_thickness = int(r)
	return
	end

	SUBROUTINE set_channel_colours( ix, iy )
$INCLUDE: 'wcpcom.for'
C
C	Set channel units
C
	PARAMETER(NROWS=max_channels)
	character*26 menu(nrows)
	CHARACTER*10 LIST(NROWS)
	character*32 title
C
C	CODE
C	----

	do i = 1,n_channels
	    write( menu(i),
     &	    '('' Ch.'',i1,'' Colour (1-16)'')') i-1
	    write(list(i),'(i2)') icolour(i)
	end do

	title = ' '
100	if( title .eq. ' ' ) title = ' Set channel display colours '
C
	CALL TEXT_WINDOW(MENU,LIST,n_channels,ix,iy,title)
C
	do i = 1,n_channels
	    icolour(i) = int(check_limits(list,1.,16.,i,title))
	    if( title .ne. ' ' ) goto 100
	end do
	return
	end

	subroutine ced_1902
$INCLUDE: 'wcpcom.for'

c
c	Set CED 1902 amplifier via COM1
c
	parameter(nrow=9)
	CHARACTER*24 MENU(NROW) /
     &	' Input              F1',
     &	' Gain               F2',
     &	' Low pass filter    F3',
     &	' High pass filter   F4',
     &	' 50 Hz notch filter F5',
     &	' AC/DC Coupling     F6',
     &	' DC Offset          F7',
     &	' Set COM port       F8',
     &	' Exit              ESC' /

	logical quit,new_menu
	character key
	integer*2 ipnum /1/
c
c	code
c
	call set_com1

	quit = .false.
	do while( .not. quit )
C
C	    Erase and re-display screen
C
	    call erase_box(2,2,56,19)
	    call Status1902(30,2)
C
C	    Wait for user to select an option from the menu
C
	    new_menu = .true.
	    iop = iwait_menu_vertical1(menu,'12345678$',nrow,
     &	    2,2,new_menu,iop,' CED 1902 ',key)


	    select case( iop )
	    case( 1 )
		call set_1902_input( 3,4, ipnum )
	    case( 2 )
		call set_1902_gain( 3,5, ipnum )
	    case( 3 )
		call set_1902_LP_Filter( 3,6 )
	    case( 4 )
		call set_1902_HP_Filter( 3,7 )
	    case( 5 )
		call set_1902_notch_Filter( 3,8 )
	    case( 6 )
		call set_1902_AC_Coupling( 3,9 )
	    case( 7 )
		call set_1902_DC_Offset( 3,10 )
	    case( 8 )
		call set_com_port(3,11)
	    case( 9 )
		quit = .true.
	    end select
	end do
	return
	end

	subroutine set_1902_input( ix, iy, iop )
$INCLUDE: 'wcpcom.for'

c
c	Set CED 1902 amplifier input
c
	parameter(nrow=6)
	CHARACTER*24 MENU(NROW) /
     &	' Grounded',
     &	' Single Ended ',
     &	' Differential ',
     &	' Inverted Diff. ',
     &	' Isolated Input ',
     &	' Grounded Isolated ' /

	logical new_menu
	character key
	character*6 buf
c
c	code
c
C
	new_menu = .true.
	iop = iwait_menu_vertical1(menu,'123456',nrow,
     &	ix,iy,new_menu,iop,' Input ',key)

	write( buf, '(''IP'',i1,'';'')') iop
	call to_1902( buf )
	Input1902 = 'I/P:'//menu(iop)
	return
	end

	subroutine set_1902_gain( ix, iy, ipnum )
$INCLUDE: 'wcpcom.for'

c
c	Set CED 1902 amplifier via COM1
c
	parameter(nrow=11)
	CHARACTER*24 MENU(NROW) /
     &	' X1 ',
     &	' X3 ',
     &	' X10 ',
     &	' X30 ',
     &	' X100 ',
     &	' X300 ',
     &	' X1000 ',
     &	' X3000 ',
     &	' X10000 ',
     &	' X30000 ',
     &	' X100000' /

	logical new_menu
	character key
	character*6 buf
c
c	code
c
C
	if( ipnum .lt. 5 ) then
	    i0 = 1
	else
	    i0 = 3
	end if
	new_menu = .true.
	iop = iwait_menu_vertical1(menu(i0),'123456789AB',nrow-i0+1,
     &	ix,iy,new_menu,iop,' Gain ',key)

	write( buf, '(''GN'',i1,'';'')') iop
	call to_1902( buf )
	Gain1902 = 'Gain='//menu(iop)
	call write_to_log( Gain1902 )
	return
	end

	subroutine set_1902_LP_Filter( ix, iy )
$INCLUDE: 'wcpcom.for'

c
c	Set CED 1902 low pass filter
c
	parameter(nrow=4)
	CHARACTER*24 MENU(NROW) /
     &	' No filter',
     &	' 1000 Hz ',
     &	' 500 Hz ',
     &	' 100 Hz ' /

	logical new_menu
	character key
	character*6 buf
c
c	code
c
C
	new_menu = .true.
	iop = iwait_menu_vertical1(menu,'0123',nrow,
     &	ix,iy,new_menu,iop,' Low Pass Filter ',key)

	write( buf, '(''LP'',i1,'';'')') iop-1
	call to_1902( buf )
	LP1902 = 'LP Filter:'//menu(iop)
	call write_to_log( LP1902 )
	return
	end

	subroutine set_1902_HP_Filter( ix, iy )
$INCLUDE: 'wcpcom.for'

c
c	Set CED 1902 high pass filter
c
	parameter(nrow=4)
	CHARACTER*24 MENU(NROW) /
     &	' No filter',
     &	' 200 Hz ',
     &	' 100 Hz ',
     &	' 50 Hz ' /

	logical new_menu
	character key
	character*6 buf
c
c	code
c
C
	new_menu = .true.
	iop = iwait_menu_vertical1(menu,'0123',nrow,
     &	ix,iy,new_menu,iop,' High Pass Filter ',key)

	write( buf, '(''HP'',i1,'';'')') iop-1
	call to_1902( buf )
	HP1902 = 'HP Filter:'//menu(iop)
	call write_to_log( HP1902 )
	return
	end

	subroutine set_1902_Notch_Filter( ix, iy )
$INCLUDE: 'wcpcom.for'

c
c	Set CED 1902 50Hz notch filter
c
	parameter(nrow=2)
	CHARACTER*24 MENU(NROW) /
     &	' Off',
     &	' On ' /

	logical new_menu
	character key
	character*6 buf
c
c	code
c
C
	new_menu = .true.
	iop = iwait_menu_vertical1(menu,'01',nrow,
     &	ix,iy,new_menu,iop,' 50Hz Notch Filter ',key)

	write( buf, '(''NF'',i1,'';'')') iop-1
	call to_1902( buf )
	NF1902 = 'Notch (50Hz):'//menu(iop)
	call write_to_log( NF1902 )
	return
	end

	subroutine set_1902_AC_Coupling( ix, iy )
$INCLUDE: 'wcpcom.for'

c
c	Set CED 1902 AC/DC coupling
c
	parameter(nrow=2)
	CHARACTER*24 MENU(NROW) /
     &	' DC Coupled',
     &	' AC Coupled ' /

	logical new_menu
	character key
	character*6 buf
c
c	code
c
C
	new_menu = .true.
	iop = iwait_menu_vertical1(menu,'01',nrow,
     &	ix,iy,new_menu,iop,' AC/DC Coupling ',key)

	write( buf, '(''AC'',i1,'';'')') iop-1
	call to_1902( buf )
	Coupling1902 = 'AC/DC Coupling:'//menu(iop)(1:3)
	call write_to_log( Coupling1902 )
	end

	subroutine set_1902_DC_Offset( ix, iy )
$INCLUDE: 'wcpcom.for'

c
c	Set CED 1902 DC Offset
c
	parameter(nrows=1)
	character*26 menu(nrows) / ' Offset (mV) ' /
	character* 30 title
	character*10 list(nrows)

	character*10 buf

	real*4 DC_Offset_mv / 0. /
c
c	code
c
C
C
C	Insert current values into reponse field of form
C
	i = 1
	write( list(i), '(f8.1)' ) DC_offset_mv
C
	title = ' '
100	if( title .eq. ' ' ) title = ' Set DC Offset '
C
	CALL TEXT_WINDOW(MENU,LIST,NROWS,ix,iy,title)
C
	i = 1
	DC_offset_mv = check_limits(list,-5000.,5000.,i,title)

	write( buf, '(''OR2;'')')
	call to_1902( buf )

	write( buf, '(''OF'',i5,'';'')')
     &	 int( (DC_offset_mv/5000.)*32767. )
	call to_1902( buf )

	write(OFF1902,'(''Offset='',f8.1,'' mV'')') DC_offset_mv
	call write_to_log( OFF1902 )

	return
	end

	subroutine set_com_port( ix, iy )
$INCLUDE: 'wcpcom.for'

c
c	Set com port (COM1 or COM2) used to talk to CED 1902
c
	parameter(nrow=2)
	CHARACTER*24 MENU(NROW) /
     &	' COM1',
     &	' COM2 ' /

	logical new_menu
	character key
	character*6 buf
	integer*1 ibuf
	equivalence( buf,ibuf )
c
c	code
c
C
	new_menu = .true.
	iop = iwait_menu_vertical1(menu,'01',nrow,
     &	ix,iy,new_menu,iop,' COM Port ',key)

	iComPort = iop
	Com1902 = 'Port:'//menu(iop)
	call write_to_log( Com1902 )
	return

	end

	subroutine Status1902(ileft,itop)
$include:'wcpcom.for'
c
c	Display status of CED 1902
c
	call erase_box(ileft,itop,ileft+28,itop+9)
	call display_box(ileft,itop,ileft+28,itop+9)
	call move_cursor(ileft+2,itop)
	call display_string(' Amplifier settings ')
	call move_cursor(ileft+1,itop+1)
	call display_string(Input1902)
	call move_cursor(ileft+1,itop+2)
	call display_string(Gain1902)
	call move_cursor(ileft+1,itop+3)
	call display_string(LP1902)
	call move_cursor(ileft+1,itop+4)
	call display_string(HP1902)
	call move_cursor(ileft+1,itop+5)
	call display_string(NF1902)
	call move_cursor(ileft+1,itop+6)
	call display_string(Coupling1902)
	call move_cursor(ileft+1,itop+7)
	call display_string(Off1902)

	if( iComPort .ne. 2 ) Com1902 = 'Port: COM1'
	call move_cursor(ileft+1,itop+8)
	call display_string(Com1902)

	return
	end

	subroutine to_1902( string )
$include:'wcpcom.for'

	character*(*) string
c
c	Write command to CED 1901 via COM1
c
c	code
c
	nc = len_trim( string )
	do i = 1,nc
	    ibyte = ichar( string(i:i) )
	    if( icomPort .ne. 2 ) then
		call to_com1( ibyte )
	    else
	    end if
	    call wait(0.05)
	end do
	if( icomPort .ne. 2 ) then
	    call to_com1( 13 )
	else
	end if

	return
	end

	subroutine from_com1( string )
$include:'wcpcom.for'
	character*(*) string
	integer*1 istring(50)
c
c	Read a line from the CED 1902 via COM1
c
	string = ' '

	call get_line( istring )
	i = 1
	do while( istring(i) .ne. 13 )
	    string(i:i) = char( istring(i) )
	    i = i + 1
	end do

	return
	end
