	SUBROUTINE DUMP_RECORDS
$INCLUDE: 'wcpcom.for'
C
C	Dump a series of signal records on to printer/plotter
C	=====================================================
C
	CHARACTER DEVICE,KEY
	CHARACTER*40 STRING,err
	LOGICAL SPECIAL

	parameter(nmenu=4,lwidth=53)
	character*40 menu(nmenu) /
     &	' Current calibration bar (    )',
     &	' Time calibration bar    (    ) ',
     &	' Start at record (1-     )',
     &	' End at record ' /
	character*8 list(nmenu)

	real c_bar /0. /
	real x_bar /0./

	parameter( n_records_per_line = 4, n_lines_per_page = 4,
     &	irecord_height = 5120, irecord_width = 6144, n_plot = 128,
     &	ileft = 7000, itop = 28762, n_records_per_page = 16 )

	character*30 msg(3)

	parameter( np2=2*n_plot )
	integer*2 ixy(np2)
	equivalence (iwork,ixy)

C
C	CODE
C
c	Let user set calibration bars
c
	ix = index( menu(1), '(' ) + 1
	menu(1)(ix:ix+3) = y_units(1)
	if( c_bar.eq.0. ) c_bar = float(max_adc)*y_scale(1)/10.
	write(list(1),'(f8.3)') c_bar

	ix = index( menu(2), '(' ) + 1
	menu(2)(ix:ix+3) = t_units
	if( x_bar .eq.0. ) x_bar = float(n_points)*dt/10.
	write(list(2),'(f8.3)') x_bar

	ix = index( menu(3), '-' ) + 1
	write(menu(3)(ix:ix+4),'(i5)') n_records
	write(list(3),'(i5)') max(min(ir_start,n_records),1)
	if( ir_end .eq. 0 ) ir_end = n_records
	write(list(4),'(i5)') max(min(ir_end,n_records),ir_start)

	err = ' '
10	if( err .eq. ' ' )  err = 'Plot Records '
	call text_window(menu,list,nmenu,3,6,err )

c
c	Unpack values from table & check for validity
c
	c_bar = check_limits(list,0.,1E30,1,err)
	if( err .ne. ' ' ) goto 10
	x_bar = check_limits(list,0.,1E30,2,err)
	if( err .ne. ' ' ) goto 10
	ir_start = int(check_limits(list,1.,float(n_records),3,err))
	if( err .ne. ' ' ) goto 10
	ir_end = int(check_limits(list,float(ir_start),
     &	float(n_records),4,err))
	if( err .ne. ' ' ) goto 10


c
c	Let user select O/P device
c
	call get_screen_device( iscreen )
	call select_plot_device(4,7,idev,ihandle,device)
	if( idev.eq. 0 ) then
	    if( ihandle .ne. 0 ) then
		call close_file( ihandle, ierr )
		call display_message(5,7,36
     &		,' Sorry! File option not available',1)
	    endif
	    return
	elseif( idev .eq. iscreen ) then
	    call erase_all
	endif

	call get_text_attributes( idev, i,i,i,i,i,
     &	ichar_width,ichar_height)
C
C	Plot signal records

	DO 100 IR = IR_START,IR_END
C
C	    Abort plotting if ESC key pressed

	    CALL GET_KEY( KEY, SPECIAL )
	    IF( KEY .EQ. '$' ) GOTO 200

	    if( idev .ne. iscreen ) then
		msg(1) = ' WAIT ... Plotting'
		msg(2) = ' Press ESC to abort'
		write(msg(3),'('' Record '',i5)') ir
		call display_message(5,8,30,msg,3)
	    endif

C	    Read record from file

	    CALL GET_record( ir, rec.buf, iwork )
	    call calculate_zero_levels( iwork )

c
c	    calculate plotting area on page
c
	    n_skip = n_points/n_plot
	    nr_done = ir - ir_start
	    ix0 = mod( nr_done, n_records_per_line )*irecord_width
     &	    + ileft
	    idx = ((irecord_width/6)*5)/n_plot
	    line = mod(nr_done/n_records_per_line,n_lines_per_page)
	    ibottom = itop - line*irecord_height - max_adc

	    np = 0
	    ix = ix0
	    DO 115 I = 1,N_points,n_skip
		NP = NP + 1
		ixy(2*NP-1) = IX
		ixy(2*NP) = ibuffer(I) + ibottom
		IX = IX + IDX
115	    CONTINUE

C
C	    Plot signal record line
C
	    CALL POLYLINE(IDEV,ixy,NP)
c
c	    Plot zero level
c
	    ixy(1) = ix0
	    ixy(2) = izero_c + ibottom
	    ixy(3) = ix0 + idx*n_plot
	    ixy(4) = ixy(2)
	    call set_writing_mode( idev, 2 )
	    call set_polyline_type( idev, 3 )
	    call polyline( idev, ixy, 2 )
	    call set_polyline_type( idev, 1 )
	    call set_writing_mode( idev, 1 )

	    if( mod( nr_done, n_records_per_line ) .eq. 0 ) then
C
C	       Record no. at start of line
C
	       WRITE(STRING,'(''Recs.'',i4,''-'',i4)')
     &	       IR,min(IR+n_records_per_line-1,ir_end)
	       ixy(1) = ileft
	       ixy(2) = ibottom - ichar_height*2
	       CALL GRAPHICS_TEXT(IDEV,IXY,STRING(1:14))
C
C --	       Plot calibration bar
C
	       IBAR_Y = int(C_BAR/y_scale(1))
	       IX = 2*ICHAR_WIDTH
	       IY = ibottom
	       CALL YT_CALIBRATION(IDEV,IX,IY,
     &	       IBAR_Y,ICHAR_WIDTH,ICHAR_HEIGHT,C_BAR,y_units(1),'V')

	    endif

c
c	    When a page is full - output it to plotter
c

	    if( (mod(nr_done+1,n_records_per_page) .eq. 0) .or.
     &	    ( ir .ge. ir_end ) ) then
C
C --		Title
C
		IXY(1) = ILEFT
		IXY(2) = max_ndc - 2*ICHAR_HEIGHT
		CALL GRAPHICS_TEXT(IDEV,IXY,'File ... '//FILE_NAME)
		IXY(2) = max_ndc - 3*ICHAR_HEIGHT
		CALL GRAPHICS_TEXT(IDEV,IXY,ID)

C
C --		Plot horizontal bar
C
		IBAR_T = int( FLOAT(IDX)*X_BAR/(DT*float(n_skip)) )
		ix = ileft
		iy = ibottom - ibar_t - 2*ichar_height
		CALL YT_CALIBRATION(IDEV,IX,IY,
     &		IBAR_T,ICHAR_WIDTH,ICHAR_HEIGHT,X_BAR,T_UNITS,'H')
C
		if( idev .eq. iscreen) then
		    call move_cursor(2,25)
		    call display_string(' Press a key to continue ')
		    call wait_for_key( key, special )
		else
		    CALL UPDATE_WORKSTATION(IDEV)
		endif
		CALL CLEAR_WORKSTATION(IDEV)

		IF( DEVICE .EQ. 'P' ) THEN

C		    If plotting on a digital plotter, stop
C		    to let user change paper

		    msg(1) = ' Change paper in plotter '
		    msg(2) = ' Press a key to continue '
		    msg(3) = ' '
		    call display_message(5,8,30,msg,2)
		    CALL WAIT_FOR_KEY(KEY,SPECIAL)
		    IF( KEY .EQ. '$' ) GOTO 200

		ENDIF

		CALL GET_KEY(KEY,SPECIAL)
		iF( KEY .EQ. '$' ) GOTO 200
	    ENDIF
C
100	CONTINUE
C
C	Plot last page and close workstation
C
200	if( idev .ne. iscreen ) then
	    CALL UNLOAD_FONTS(IDEV)
	    CALL CLOSE_WORKSTATION(IDEV)
	else
	    call erase_all
	endif
	CALL SET_MARGINS(2,1,80,25)

	RETURN
	END


