	subroutine leak_subtraction( abort )
$INCLUDE: 'wcpcom.for'
	logical abort	    ! Returned .TRUE. if no leaks created
c
c	Digital leak current subtraction module
c	=======================================
c
c	Records designated as 'LEAK', containing small linear
c	leak and capacity currents, can be averaged, scaled, and
c	subtracted from the average of other records. Records are
c	collected together into "groups" with the same rec.number
c	value, associated with a particular voltage pulse value.
C	24/1/96 ... Loss of last group fixed
c
	LOGICAL CHANGE_BORDER,SPECIAL,new_menu,quit
	logical new_start / .true. /
	INTEGER*2 IDISPLAY_AREA(4)

	character string*60, key, stat*14

	parameter(nmenu= 10,istatus_left=64,istatus_top=19)
	character*15 menu(nmenu) /
     &	'Select Chs.  F1',
     &	'Magnify       +',
     &	'Next  rec. PgDn',
     &	'Prev. rec. PgUp',
     &	'Goto  rec. Home',
     &	'Mark Zero    F2',
     &	'Mark Pulse   F3',
     &	'Do subtract  F4',
     &	'Set Group    F5',
     &	'Exit        ESC'/

c
c	Display magnification, offsets & colour
c
	integer*2 iy_magn(max_channels) / 6*6 /
	integer*2 min_y_scale(max_channels) / 6*6 /
	integer*2 max_y_scale(max_channels) / 6*32 /
	integer*2 iy_offset(max_channels) / 6*0 /
	character*1 display_channel(max_channels) / 6*'Y' /

C
C -- CODE -------------------------------------------------------
c
	abort = .true.
c
c	Open digitised signal data file
c
	ifile = idata_file
	open(unit=idata_file,file=file_name,form='binary',
     &	access='direct', recl=512)
	call get_header( ifile )

	if( new_start ) then
	    ic_chan = 1
	    iv_chan = 2
	    i_pulse = n_points/2
	    i_zero = 1
	    new_start = .false.
	    navg = 20
	end if

C
C -- Set size of display area
C 
	CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	CALL GET_CHARACTER_SIZE(IW,IH)
	IDISPLAY_AREA(1) = IW
	IDISPLAY_AREA(2) = MAX_ndc - 24576 - IH
	IDISPLAY_AREA(3) = IDISPLAY_AREA(1) + ((60*IW)/512)*512
	IDISPLAY_AREA(4) = IDISPLAY_AREA(2) + 24576
	CALL SET_SIZE(IDISPLAY_AREA(1),IDISPLAY_AREA(2)
     &	,IDISPLAY_AREA(3),IDISPLAY_AREA(4))
C
C	Set display size to whole of buffer , cursor in middle
C
	N_DISP = N_POINTS
	ICURSOR = N_DISP/2
	IOLD_CURSOR = ICURSOR
	I0 = 1
	I1 = N_DISP
C
C	Read first frame then do a change frame
C	to get frame number on display
c
	irecord = 1
	call get_record(ifile,irecord,rec.buf,iwork)
	istep = 0
	call change_record(ifile,irecord,istep,rec.buf,iwork)

	CHANGE_BORDER = .TRUE.
	new_menu = .true.
	call erase_all

C -- Begin display loop --------------------------------------------
C
	quit = .false.
	do while ( .not. quit )
c
c	    Refresh options menu
c
	    if( new_menu ) then
		key = ' '
		iop = IMENU_VERTICAL1(menu,'1+QPH2345$'
     &		,nmenu,istatus_left-1,1,new_menu,iop,' Options ',key)
	    endif


	    IF( CHANGE_BORDER ) THEN
C
C	    -- Draw display border and help information -------------------
C
		T_MIN = FLOAT(I0 -1)*DT
		T_MAX = FLOAT(I0 + N_DISP - 1)*DT
		call set_writing_mode( iscreen, overwrite )
c		 call set_fill_interior( iscreen, 1, 1, 5 )
		CALL ERASE_BOX(1,1,62,21)
		CALL DISPLAY_BOX(1,1,62,21)
		CALL MOVE_CURSOR(2,21)
		WRITE(STRING,'(f7.2,1x,a)') T_MIN,T_UNITS
		CALL DISPLAY_STRING(STRING(1:13))
		WRITE(STRING,'(f7.2,1x,a)') T_MAX,T_UNITS
		CALL MOVE_CURSOR(48,21)
		CALL DISPLAY_STRING(STRING(1:13))
		CALL MOVE_CURSOR(2,1)
		CALL DISPLAY_STRING(' Leak Subtraction ')
		call move_cursor(21,1)
		call display_stringt(' File: '//file_name )

c		 call set_fill_interior( iscreen, 0, 0, 1 )
		call set_writing_mode( iscreen, 2 )

		call display_box(1,22,istatus_left-2,25)

c
c		Display start/end of analysis area
c
		CALL SET_WRITING_MODE(ISCREEN,2)
		call set_polyline_type(iscreen,3)

		if( (i_zero .ge. i0) .and. (i_zero.le.i0+n_disp))
     &		call display_cursor(
     &		iscreen,idisplay_area,i_zero-i0+1,n_disp)

		if( (i_pulse.ge.i0) .and. (i_pulse.le.i0+n_disp))
     &		call display_cursor(
     &		ISCREEN,idisplay_area,i_pulse-I0+1,N_DISP)

c
c		Display zero level
c
		do ich = 1,n_channels
		    if( display_channel(ich) .eq. 'Y' ) then
			call set_polyline_type(iscreen,3)
			call set_polyline_colour(iscreen,icolour(ich))
			call display_horizontal_cursor(iscreen,
     &			idisplay_area,iy_zero(ich),iy_magn(1),
     &			iy_offset(1))
		    end if
		end do
		call set_polyline_colour( iscreen, 1 )
		call set_polyline_type(iscreen,1)
		call set_writing_mode( iscreen, overwrite )
c
c		Put readout cursor on-screen
c
		icursor = max(min(icursor,i0+n_disp-1),i0)
		iold_cursor = icursor
		call set_writing_mode( iscreen, exor )
		call display_cursor(
     &		iscreen,idisplay_area,iold_cursor-i0,n_disp)
		CALL SET_WRITING_MODE(	ISCREEN, overwrite )

C
C --		Display signal on screen
C
		do ich = 1,n_channels
		    if( display_channel(ich) .eq. 'Y' ) then
			call plot_channel(iscreen,idisplay_area,iwork,
     &			ich,n_channels,i0, n_disp, iy_magn(ich),
     &			iy_offset(ich),icolour(ich))
		    end if
		end do

		CHANGE_BORDER = .FALSE.
	    ENDIF
C
C --	   Draw vertical readout cursor -------------------------------
C
	    call set_polyline_colour( iscreen, 1 )
	    call set_writing_mode( iscreen, exor )
	    call display_cursor(iscreen,idisplay_area,iold_cursor-i0,
     &	    n_disp)
	    call display_cursor(iscreen,idisplay_area,icursor-i0,n_disp)
	    call set_writing_mode( iscreen, overwrite )
	    IOLD_CURSOR = ICURSOR

c
c --	    Display status information
c
	    call move_cursor(3,23)
	    stat = rec.status//' '//rec.type
	    tm = rec.time
	    group = rec.number
	    write(string,
     &	    '(''Rec. '',i5,''/'',i5,'' Group'',i5,'' at'',f9.2,1x,a)')
     &	    irecord,n_records,int(group),tm,stat
	    call display_stringt(string)

	    iy = 25 - n_channels - 2
	    call display_box(istatus_left-1,iy,79,25)
	    TIME = FLOAT(ICURSOR-1)*DT*tscale
	    write(string,'(''T:'',F10.2,a)') time,t_units
	    call move_cursor(istatus_left,iy+1)
	    call display_stringt(string)

	    do ich = 1,n_channels
		if( display_channel(ich) .eq. 'Y' ) then
		    i = (icursor-1)*n_channels + ich
		    y = float(iwork(i) - iy_zero(ich))*y_scale(ich)
		    write( string,'(a2,f10.2,a2)') y_name(ich),y,
     &		    y_units(ich)
		    call move_cursor(istatus_left,iy+ich+1)
		    call display_stringt(string)
		end if
	    end do

	    call set_margins(2,1,80,25)

c
c	    Wait for user to press a key
c
	    call wait_for_key( key, special )

	    ibig_step = max(n_disp/10,2)
	    if( special .and. (key .eq. 'L') ) then
C		<- = move cursor left 1 point
		ICURSOR = max( ICURSOR - 1, 1 )
		IF(ICURSOR .LT. I0) THEN
		    I0 = max(I0 - ibig_step,1)
		    I1 = I0 + N_DISP - 1
		    change_border = .TRUE.
		ENDIF
		iop = 0
	    elseif( special .and. (key .eq. 'R') ) then
C		-> = move cursor right 1 point
		ICURSOR = min0(ICURSOR + 1,n_points)
		i1 = i0 + n_disp - 1
		IF(ICURSOR .GT. I1) THEN
		    I1 = min0(I1 + ibig_step,n_points)
		    I0 = I1 - N_DISP + 1
		    change_border = .TRUE.
		ENDIF
		iop = 0
	    elseif( special .and. (key .eq. 'B') ) then
C		CTRL <- = B Move cursor left (big step)
		ICURSOR = max(ICURSOR - ibig_step,1)
		IF(ICURSOR .LT. I0) THEN
		    I0 = max(I0 - ibig_step*2,1)
		    I1 = I0 + N_DISP - 1
		    change_border = .TRUE.
		ENDIF
		iop = 0
	    elseif( special .and. (key .eq. 'F') ) then
C		CTRL -> = Move cursor right (big steps)
		ICURSOR = min0( ICURSOR + 20, n_points )
		i1 = i0 + n_disp - 1
		IF(ICURSOR .GT. I1) THEN
		    I1 = min0( I1 + ibig_step*2, n_points )
		    I0 = I1 - N_DISP + 1
		    change_border = .TRUE.
		ENDIF
		iop = 0
	    else
C
c		Present options menu and return "iop=1..8" if
c		an option has been selected. "iop=0" if no selection
c
		iop = IMENU_VERTICAL1(menu,'1+QPH2345$'
     &		,nmenu,istatus_left-1,1,new_menu,iop,' Options ',key)

	    endif

	    select case (iop)
	    case( 1 )
c
c		Select current and voltage channels
c
		if( n_channels .gt. 1 ) then
		    new_menu = .true.
		    call select_channel( 2,2, ' Current Ch. ',ic_chan)
		    call select_channel( 3,3+ic_chan,' Voltage Ch. ',
     &		    iv_chan)
		end if
		CHANGE_BORDER = .TRUE.
		new_menu = .true.

	    case (2)
C
C	    Expand display
C
	    call change_display_magnification( iwork,
     &	    i0,n_disp,iy_magn,iy_offset,min_y_scale,max_y_scale,
     &	    idisplay_area )
	    icursor = max(min(icursor,i0+n_disp-1),i0)
	    CHANGE_BORDER = .TRUE.
	    new_menu = .true.

	    case (3)
C
C	    PgDn - Read next frame
C
	    istep = 1
	    call change_record(ifile,irecord,istep,rec.buf,iwork)
	    CHANGE_BORDER = .TRUE.

	    case (4)
C
C	    PgUp - Read last frame stored
C
	    istep = -1
	    call change_record(ifile,irecord,istep,rec.buf,iwork)
	    CHANGE_BORDER = .TRUE.

	    case (5)
C
C	    Goto selected record
C
	    write(string,'('' Go to record (1-'',i5,'') ? '')')
     &	    n_records
	    call display_message(2,23,46,string(1:30),1)
	    call get_number(r,1.,float(n_records),float(irecord))
	    call erase_box(2,23,istatus_left-1,25)
	    istep = int(r) - irecord
	    call change_record(ifile,irecord,istep,rec.buf,iwork)
	    CHANGE_BORDER = .TRUE.

	    case( 6 )
c
c		Indicate averaging point for the zero level of the
c		voltage trace
c
		i_zero = icursor
		change_border = .true.

	    case( 7 )
c
c		Indicate averaging point within the voltage pulse
c
		i_pulse = icursor
		change_border = .true.

	    case( 8 )
c
c		Do leak subtraction
c
		 call do_subtraction(ifile,ic_chan,iv_chan,
     &		 i_zero,i_pulse,navg )
		 quit = .true.
		 abort = .false.

	    case (9)
c
c		Set group number
c
	    write(string,'('' New Group No. ? '')')
	    call display_message(2,23,46,string(1:30),1)
	    call get_number(r,1.,32767.,rec.number)
	    call erase_box(2,23,istatus_left-1,25)
	    rec.number = r
	    call change_record(ifile,irecord,0,rec.buf,iwork)
	    CHANGE_BORDER = .TRUE.

	    case (10)
c
c		Cancel
c
		quit = .true.

	    end select
	end do

	close(unit=ifile)
	return
	end

	subroutine do_subtraction(ifile,ic_chan,iv_chan,
     &	i_zero,i_pulse,navg )
C
C
$INCLUDE:'wcpcom.for'
C
	CHARACTER KEY
	LOGICAL initialise,quit,special
	real*4 cleak(max_points)
	EQUIVALENCE (IWORK(max_points*max_channels+1),cleak)
	real*4 ctest(max_points)
	EQUIVALENCE (IWORK(max_points*(max_channels+2)+1),ctest)

	parameter(nmenu=4)
	character*46 menu(nmenu)
	character*8 list(nmenu)
	character*46 msg(3)
	character*40 title
	character*70 avg_name
	character*56 string

	integer*2 ir_s /0/, ir_e /0/
	character group_mode / 'Y' /
c
c	code
c
c
c	Start/end points of regions used to calculate voltage channel
c	zero level and pulse amplitude
c
	iz0 = max(1,i_zero-navg/2)
	iz1 = min(n_points,iz0+navg-1)
	ip0 = max(1,i_pulse-navg/2)
	ip1 = min(n_points,ip0+navg-1)

c
c	Open average data file (.avg extension)
c
	avg_name = file_name
	ix = index( avg_name, '.' )
	avg_name(ix:ix+3) = '.avg'
	open(unit=iavg_file,file=avg_name,form='binary',
     &	access='direct', recl=512)


c	Let user set range of records to be averaged
c
	i = 1
	write(menu(i),'('' Start at record (1-'',I5,'')'')') n_records
	write(list(i),'(i5)') max(min(ir_s,n_records),1)
	if( ir_e .eq. 0 ) ir_e = n_records
	i = i + 1
	menu(i) = ' End at record '
	write(list(i),'(i5)') min(ir_e,n_records)
	i = i + 1
	menu(i) = ' Leak records available for each group (Y/N) '
	list(i) = group_mode

	if( n_channels .eq. 1 ) then
	    i = i + 1
	    menu(i) = ' Leak subtraction scaling factor '
	    list(i) = ' 1.'
	    list(i-1) = 'N'
	    nlist = nmenu
	    ic_chan = 1
	else
	    nlist = nmenu-1
	end if

	title = ' '
10     if(title.eq.' ') title = ' Records to be leak subtracted '
	call text_window(menu,list,nlist,2,2,title)

	i = 1
	ir_s = int(check_limits(list,1.,float(n_records),i,title))
	if( title .ne. ' ' ) goto 10

	i = i + 1
	ir_e = int(check_limits(list,1.,float(n_records),i,title))
	if( title .ne. ' ' ) goto 10

	i = i + 1
	group_mode = check_letter(list,'YN',i,title)
	if( title .ne. ' ' ) goto 10

	if( n_channels .eq. 1 ) then
	    i = i + 1
	    vscale = check_limits(list,-1E30,1E30,i,title)
	end if
	if( title .ne. ' ' ) goto 10

	msg(1) = 'WAIT ... Subtraction in Progress '
	msg(2) = 'Press ESC to abort'
	msg(3) = ' '
	call display_message(4,7,46,msg,3)
	ix = 5
	iy = 10
c
c	If group-mode subtraction has not been selected,
c	compute a single average leak current for the whole file
c
	v_leak = 1E30
	if( group_mode .ne. 'Y' ) then

	    n_leak = 0
	    do i = 1,n_points	    ! Initialise leak current average
		cleak(i) = 0.
	    end do

	    do irecord = ir_s,ir_e

		call get_record(ifile,irecord,rec.buf,iwork)
		if( (rec.type .eq. 'LEAK' ) .and.
     &		(rec.status .eq. 'ACCEPTED') ) then
c
c		    Add current channel to average array
c
		    j = ic_chan
		    do i = 1,n_points
			cleak(i) = float(iwork(j) - iy_zero(ic_chan))
     &			*y_scale(ic_chan) + cleak(i)
			j = j + n_channels
		    end do
c
c		    Calculate leak voltage pulse
c
		    if( n_channels .gt. 1 ) then
			sum = 0.
			do i = ip0,ip1
			    sum = sum + float(iwork((i-1)*n_channels+
     &			    iv_chan))
			end do
			v_leak = sum/float(ip1-ip0+1)
			sum = 0.
			do i = iz0,iz1
			    sum = sum + float(iwork((i-1)*n_channels+
     &			    iv_chan))
			end do

			v_leak = (v_leak - sum/float(iz1-iz0+1))*
     &			 y_scale(iv_chan)
		    end if

		    n_leak = n_leak + 1

		end if

		write(string,
     &		'(''Leak records: Rec '',i4,'' Vlk='',f8.1,''mV n='',i4)')
     &		irecord,v_leak,n_leak
		call move_cursor(ix,iy)
		call display_stringt( string )

	    end do
	end if

	quit = .false.
	initialise = .true.
	irecord = ir_s
	n_groups = 0
	do while( .not. quit )

	    call get_key( key, special )
	    if( key .eq. '$' ) then
		quit = .true.
		cycle
	    end if
c
c	    Get next signal record
c
	    if( irecord .le. ir_e ) then
		call get_record(ifile,irecord,rec.buf,iwork)
		if( irecord .eq. ir_s ) group = rec.number
	    end if
c
c	    If the latest record has a new group number
c	    process and store the old group
c
	    if( irecord .gt. ir_e ) quit = .true.

	    if( (rec.number .ne. group) .or. quit ) then

		group_new = rec.number

		if( n_test .gt. 0 ) then

c		    Scale and subtract leak pulse
c
		    if( n_channels .gt. 1 ) then
			if( abs(v_leak) .gt. 1E-3 ) then
			    vscale = v_test / v_leak
			else
			    vscale = 0.
			end if
		    end if

		    do i = 1,n_points
			ctest(i) = (ctest(i)/float(max(n_test,1))) -
     &			vscale*(cleak(i)/float(max(n_leak,1)))
		    end do
c
c		    Get the last test record added to the average
c		    and use its voltage channel for the leak-subtracted record
c
		    call get_record(ifile,ilast_test,rec.buf,iwork)

		    j = ic_chan
		    do i = 1,n_points
			iwork(j) = int( ctest(i)/y_scale(ic_chan) )
			j = j + n_channels
		    end do

		    n_groups = n_groups + 1
		    rec.number = group
		    rec.type = 'TEST'
c
c		    Set the time zero pointer in the record
c		    to the start of the voltage pulse
c
		    if( n_channels .eq. 1 ) then
			rec.iz = i_pulse
		    else
			iVz = iWork((iz0-1)*n_channels+iv_chan)
			iThreshold = iabs(
     &			(iWork((ip0-1)*n_channels+iv_chan) - iVz)/2 )

			i = ip0
			j = (i-1)*n_channels + iv_chan
			do while( i .gt. 1 .and.
     &			   iabs(iWork(j) - iVz) .gt. iThreshold )
			   i = i - 1
			   j = j - n_channels
			end do
			rec.iz = i
		    end if

		    call put_record(iavg_file,n_groups,rec.buf,iwork)

		end if

		group = group_new
		initialise = .true.

		call get_record(ifile,irecord,rec.buf,iwork)

	    end if
c
c	    Initialise averaging arrays if required
c
	    if( initialise ) then
		do i = 1,n_points
		    ctest(i) = 0.
		end do
		n_test = 0
		if( group_mode .eq. 'Y' ) then	    ! Keep leak current
		    do i = 1,n_points		    ! average if in
			cleak(i) = 0.		    ! 'file-mode' subtraction
		    end do
		    n_leak = 0
		    v_leak = 1E30
		end if
		initialise = .false.
	    end if
c
c	    Add LEAK record to average
c
	    if( rec.status .eq. 'ACCEPTED' .and.
     &		rec.type .eq. 'LEAK' .and.
     &		group_mode.eq.'Y' ) then

		n_leak = n_leak + 1
c
c		Add current to leak current average
c
		j = ic_chan
		do i = 1,n_points
		    cleak(i) = float(iwork(j) - iy_zero(ic_chan))
     &		    *y_scale(ic_chan) + cleak(i)
		    j = j + n_channels
		end do
c
c		Calculate leak voltage pulse
c
		if( n_channels .gt. 1 ) then
		    sum = 0.
		    do i = ip0,ip1
			sum = sum +
     &			float(iwork((i-1)*n_channels+iv_chan))
		    end do
		    v_leak = sum/float(ip1-ip0+1)
		    sum = 0.
		    do i = iz0,iz1
			sum = sum +
     &			float(iwork((i-1)*n_channels+iv_chan))
		    end do

		    v_leak = (v_leak - sum/float(iz1-iz0+1))*
     &		     y_scale(iv_chan)
		end if

		write(string,
     &		'(''Group '',i4,'' Vlk='',f8.1,''mV n='',i4)')
     &		int(group),v_leak,n_leak
		call move_cursor(ix,iy)
		call display_stringt( string )

	    end if
c
c	    Add non-LEAK record to average
c
	    if( rec.status .eq. 'ACCEPTED' .and.
     &		rec.type .ne. 'LEAK' ) then

		n_test = n_test + 1
c
c		Add current to test current average
c
		j = ic_chan
		do i = 1,n_points
		    ctest(i) = float(iwork(j))*y_scale(ic_chan)
     &		    + ctest(i)
		    j = j + n_channels
		end do
c
c		Calculate test voltage pulse
c
		if( n_channels .gt. 1 ) then
		    sum = 0.
		    do i = ip0,ip1
			sum = sum +
     &			float(iwork((i-1)*n_channels+iv_chan))
		    end do
		    v_test = sum/float(ip1-ip0+1)
		    sum = 0.
		    do i = iz0,iz1
			sum = sum +
     &			float(iwork((i-1)*n_channels+iv_chan))
		    end do
		    v_test = (v_test - sum/float(ip1-ip0+1))*
     &		    y_scale(iv_chan)
		end if

		write(string,
     &		'(''Group '',i4,''  Vt='',f8.1,''mV n='',i4)')
     &		int(group),v_test,n_test
		call move_cursor(ix,iy)
		call display_stringt( string )

		ilast_test = irecord

	    end if

	    irecord = irecord + 1

	end do

	itemp = n_records
	n_records = n_groups
	call save_header( iavg_file )
	n_records = itemp
	close( unit= iavg_file )

	return
	end

