	subroutine fit_curves
$INCLUDE:'wcpcom.for'
c
C	-------------------------------------------------------------------
c	Fit mathematical curves to recorded signals
C	-------------------------------------------------------------------
C	V1.2 ... 7/4/94 Data points as dots or lines option added

	parameter(neq=10)

	LOGICAL CHANGE_display,SPECIAL,new_menu,quit,out_of_range
	CHARACTER*1 KEY
	CHARACTER*80 STRING
	CHARACTER*60 TEXT(14)
	integer*2 iarea(4)

	parameter(nmenu=15,istatus_left=64,istatus_top=21)
	character*15 menu(nmenu) /
     &	'Sel. channel F1',
     &	'Magnify       +',
     &	'Next  rec. PgDn',
     &	'Prev. rec. PgUp',
     &	'Goto  rec. Home',
     &	'Mark T.zero  F2',
     &	'Mark Start   F3',
     &	'Mark End     F4',
     &	'Do fit       F5',
     &	'Plot record  F6',
     &	'Plot results F7',
     &	'Zero level   F8',
     &	'LP Filter    F9',
     &	'Dots/Lines  F10',
     &	'Exit        ESC'/

	parameter(ileft=1,itop=1,nheight=10,nwidth=60)
	parameter(nv=16)

c	Display magnification, offsets & colour
c
	integer*2 iy_scale(max_channels) / 6*3 /
	integer*2 min_y_scale(max_channels) / 6*3 /
	integer*2 max_y_scale(max_channels) / 6*512 /
	integer*2 iy_offset(max_channels) / 6*0 /

	integer*2 ich /1/
	character*4 selected_type / 'ALL' /
	character*56 title

	logical new_start / .true. /

	real*4 xy(max_points*2)
	equivalence( iwork(2*max_points+1), xy )

	integer*2 iline_or_dots /1/
C
C
C -- CODE -------------------------------------------------------
C
c
c	Select data file to be analysed (.SCA or .AVG)
c
	itype = 0
	call select_data_file( 2,2, itype, ifile, title )

	CALL GET_SCREEN_DEVICE(ISCREEN)
C
C -- Set size and location of display area
C 
	CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	CALL GET_CHARACTER_SIZE(IW,IH)
	call erase_all
	iright = ileft + nwidth + 1
	ibottom = itop + nheight + 1
	iarea(1) = ileft*iw
	iarea(2) = max_ndc - (itop+nheight)*ih
	iarea(3) = iarea(1) + nwidth*iw
	iarea(4) = iarea(2) + nheight*ih
C
C	Set display range to whole of buffer , cursor in middle
C
	if( new_start ) then
	    i0 = 1
	    i_start = 1
	    i_zero = 1
	    n_disp = n_points
	    i_end = n_points
	    icursor = n_points/2
	    IOLD_CURSOR = ICURSOR
	    new_start = .false.
	end if

	i1 = i0 + n_disp - 1
C
C	Read first frame then do a change frame
C	to get frame number on display
C
	irecord = 1
	call find_next_record(ifile,irecord,iwork,
     &	selected_type, 0, ich, out_of_range )

	if( rec.is .gt. 0 ) i_start = rec.is
	if( rec.ie .gt. 0 ) i_end = rec.ie
	if( rec.iz .gt. 0 ) i_zero = rec.iz

	change_display = .true.
	new_menu = .true.
	nlines = 0
C
C -- Begin display loop --------------------------------------------
C
	quit = .false.
	do while( .not. quit )
c
c	    Refresh options menu
c
	    if( new_menu ) then
		key = ' '
		iop = IMENU_VERTICAL1(menu,'1+QPH234567890$',
     &		nmenu,
     &		istatus_left-1,1,new_menu,iop,' Fit Options ',key)
	    endif

	    IF( CHANGE_display ) THEN

C
C	    -- Draw display border and help information -------------------
C
		call erase_box(ileft,itop,iright,ibottom)
		call display_box(ileft,itop,iright,ibottom)

		call move_cursor(ileft+1,itop)
		call display_stringt(title)

		call move_cursor(ileft+1,ibottom)
		t =  rec.dt*float(i0-1)*tscale
		write(string,'(1x,f6.1,a)') t,t_units
		call display_stringt( string )

		call move_cursor(iright-10,ibottom)
		t = rec.dt*float(i0+n_disp-1)*tscale
		write(string,'(1x,f6.1,a)') t,t_units
		call display_stringt( string )

c
c		Display analysis area cursors
c
		call set_writing_mode( iscreen, transparent )
		call set_polyline_type( iscreen, dotted )
		if( i_start.ge.i0 .and. i_start.le.(i0+n_disp)	)
     &		 call display_cursor(iscreen,iarea,i_start-i0+1,n_disp)
		if( i_end.ge.i0 .and. i_end.le.(i0+n_disp)  )
     &		 call display_cursor(iscreen,iarea,i_end-i0+1,n_disp)
		call set_polyline_type( iscreen, dot_dash )
		if( i_zero.ge.i0 .and. i_zero.le.(i0+n_disp)  )
     &		 call display_cursor(iscreen,iarea,i_zero-i0+1,n_disp)
c
c		Add cursor
c
		call set_polyline_type( iscreen, solid )
		call set_writing_mode( iscreen, exor )
		call display_cursor(iscreen,iarea,icursor-i0+1,n_disp)
		iold_cursor = icursor
		call set_writing_mode( iscreen, overwrite )
c
c		Plot channel being fitted
c
		call plot_channel( iscreen, iarea, iwork,1,1
     &		,i0, n_disp, iy_scale(ich),iy_offset(ich),
     &		 icolour(ich)*iline_or_dots )

		call set_writing_mode( iscreen, transparent )
		call set_polyline_type(iscreen,dotted)
		call set_polyline_colour( iscreen, icolour(ich))
		call display_horizontal_cursor(iscreen,
     &		iarea,iy_zero(ich),iy_scale(ich),iy_offset(ich))
		call set_polyline_type(iscreen,solid)
		call set_writing_mode( iscreen, overwrite )
		call set_polyline_colour( iscreen, black )
c
c		Plot best fit
c
		ieq = mod(rec.iequation,100)
		ich_fit = rec.iequation/100
		if( ieq.ne.0 .and. ich_fit.eq.ich ) then
		    ifit = n_points + 1
		    x = 0.
		    j = ifit
		    do i = 1,n_points
			iwork(j) = iy_zero(ich)
			if( i.ge.rec.iz ) then
			    y = func( rec.par, ieq, x )
			    iwork(j) = int(y/y_scale(ich)) + iwork(j)
			    x = x + rec.dt*tscale
			end if
			j = j + 1
		    end do

		    call plot_channel(iscreen,iarea,iwork(ifit),1,1
     &		    ,i0,n_disp,iy_scale(ich),iy_offset(ich),1)

		    call set_polyline_colour( iscreen, 1 )
c
c		    Plot residuals
c
		    ires_zero = 512
		    ires = n_points*2 + 1
		    k = ires
		    j = ifit
		    do i = 1,n_points
			iwork(k) = ires_zero
			if( i.ge.rec.iz ) then
			    iwork(k) = iwork(i) - iwork(j) + iwork(k)
			end if
			j = j + 1
			k = k + 1
		    end do

		    call plot_channel(iscreen,iarea,iwork(ires),1,1
     &		    ,i0,n_disp,iy_scale(ich),0,
     &		     icolour(ich)*iline_or_dots )

		    call set_writing_mode( iscreen, transparent )
		    call set_polyline_type(iscreen,dotted)
		    call set_polyline_colour( iscreen, icolour(ich))
		    call display_horizontal_cursor(iscreen,
     &		    iarea,ires_zero,iy_scale(ich),0)
		    call set_polyline_type(iscreen,solid)
		    call set_polyline_colour( iscreen, 1 )
		    call set_writing_mode( iscreen, overwrite )

		else
		    iwork(ifit) = -1
		    iwork(ires) = -1
		end if

		change_display = .FALSE.

		call make_report(irecord,title,text,nlines)
		call display_results( text, 2, nlines )

	    end if

C
C -----     Draw vertical readout cursor -------------------------------
C
	    call set_writing_mode( iscreen, exor )
	    call display_cursor( iscreen, iarea, iold_cursor-i0+1,
     &	    n_disp)
	    call display_cursor( iscreen, iarea, icursor-i0+1,n_disp)
	    call set_writing_mode( iscreen, overwrite )
	    iold_cursor = icursor
C
c
c --	    Display status box ----------------------------------
c
	    call display_box(istatus_left-1,istatus_top-1,79,25)

c
c	    Display current cursor values
c
	    write( string, '(''Channel '',i1)') ich-1
	    call move_cursor(istatus_left,istatus_top)
	    call display_stringt(string)

	    t = fLOAT(icursor-i_zero)*rec.dt*tscale
	    write(string,'(''T:'',F8.3,a)') t,t_units
	    call move_cursor(istatus_left,istatus_top+1)
	    call display_stringt(string)

	    call set_text_colour( iscreen, icolour(ich) )
	    y = float(iwork(icursor) - iy_zero(ich) )*y_scale(ich)
	    write(string,'(a,f8.1,a)') y_name(ich),y,y_units(ich)
	    call move_cursor(istatus_left,istatus_top+2)
	    call display_stringt( string )
	    call set_text_colour( iscreen, 1 )

c
c	    Wait for user to press a key
c
	    call wait_for_key( key, special )

	    ibig_step = max(n_disp/10,2)
	    if( special .and. (key .eq. 'L') ) then
C		<- = move cursor left 1 point
		ICURSOR = max( ICURSOR - 1, 1 )
		IF( ICURSOR .LT. i0 ) THEN
		    i0 = max(i0 - ibig_step,1)
		    i1 = i0 + n_disp - 1
		    CHANGE_DISPLAY = .TRUE.
		ENDIF
		iop = 0
	    elseif( special .and. (key .eq. 'R') ) then
C		-> = move cursor right 1 point
		ICURSOR = min(ICURSOR + 1,n_points)
		IF (ICURSOR .GT. i1 ) THEN
		    i1 = min(i1 + ibig_step,n_points)
		    i0 = i1 - n_disp + 1
		    CHANGE_DISPLAY = .TRUE.
		ENDIF
		iop = 0
	    elseif( special .and. (key .eq. 'B') ) then
C		CTRL <- = B Move cursor left (big step)
		ICURSOR = max(ICURSOR - ibig_step,1)
		IF(ICURSOR .LT. i0) THEN
		    i0 = max(i0 - ibig_step,1)
		    i1 = i0 + n_disp - 1
		    CHANGE_DISPLAY = .TRUE.
		ENDIF
		iop = 0
	    elseif( special .and. (key .eq. 'F') ) then
C		CTRL -> = Move cursor right (big step)
		ICURSOR = min( ICURSOR + ibig_step, n_points )
		IF(ICURSOR .GT. i1) THEN
		    ia1 = min( i1 + ibig_step*2, n_points )
		    i0 = i1 - n_disp + 1
		    CHANGE_DISPLAY = .TRUE.
		ENDIF
		iop = 0
	    else
C
c		Present options menu and return "iop=1..14" if
c		an option has been selected. "iop=0" if no selection
c
		iop = IMENU_VERTICAL1(menu,'1+QPH234567890$',nmenu,
     &		istatus_left-1,1,new_menu,iop,' Fit Options ',key)


	    endif
c
c ---	    Process menu options selected by user --------------------
c
	    select case( iop )

	    case( 1 )
c
c		Select channel and record type
c
		new_menu = .true.
		call select_channel( 2,2, ' Channel No. ', ich )
		call select_record_type( 3,3+ich, selected_type )

		irecord = 1
		call find_next_record(ifile,irecord,iwork,
     &		selected_type, 0, ich, out_of_range )

		new_menu = .true.
		change_display = .true.

	    case( 2 )
C
C --		Select display scaling mode
C
		n_hold = n_channels
		n_channels = 1
		call change_display_magnification(iwork,i0,n_disp,
     &		iy_scale(ich),iy_offset(ich),min_y_scale(ich),
     &		max_y_scale(ich),iarea)
		n_channels = n_hold
		icursor = max(min(icursor,i0+n_disp-1),i0)
		new_menu = .true.
		change_display = .true.

	    case( 3 )
C
C --		PgDn - Read next frame
C
		call find_next_record(ifile,irecord,iwork,
     &		selected_type, 1, ich, out_of_range )
		change_display = .true.

		if( rec.is .gt. 0 ) i_start = rec.is
		if( rec.ie .gt. 0 ) i_end = rec.ie
		if( rec.iz .gt. 0 ) i_zero = rec.iz

	    case( 4 )
C
C --		PgUp - Read last frame stored
C
		call find_next_record(ifile,irecord,iwork,
     &		selected_type, -1, ich, out_of_range )

		if( rec.is .gt. 0 ) i_start = rec.is
		if( rec.ie .gt. 0 )i_end = rec.ie
		if( rec.iz .gt. 0 )i_zero = rec.iz

		change_display = .true.

	    case( 5 )
C
C --		Goto selected record
C
		write(string,'('' Go to record (1-'',i5,'') ? '')')
     &		 n_records
		call display_message(3,3,46,string(1:30),1)
		call get_number(r,1.,float(n_records),float(irecord))
		call erase_box(2,23,istatus_left-1,25)
		istep = int(r) - irecord

		call find_next_record(ifile,irecord,iwork,
     &		selected_type, istep, ich, out_of_range )

		if( rec.is .gt. 0 ) i_start = rec.is
		if( rec.ie .gt. 0 ) i_end = rec.ie
		if( rec.iz .gt. 0 ) i_zero = rec.iz

		change_display = .true.

	    case( 6 )
c
c		Mark zero time point on record
c
		i_zero = icursor
		change_display = .true.

	    case( 7 )
c
c		Mark start of analysis area
c
		i_start = icursor
		change_display = .true.

	    case( 8 )
c
c		Mark end of analysis area
c
		i_end = icursor
		change_display = .true.

	   case( 9 )
c
c		Do curve fit(s)
c
		call do_fit(ifile,neq,
     &		irecord,selected_type,text,nlines,ich,
     &		i_start,i_end,i_zero,title)

		call find_next_record(ifile,irecord,iwork,
     &		selected_type, 0, ich, out_of_range )
		new_menu = .true.
		change_display = .true.

	    case( 10 )
C
C --		F5 Plot screen
C

		call plot_fit(ich,iwork,iwork(ifit),iwork(ires),
     &		i0,n_disp,iy_scale,
     &		iy_offset,iarea(4)-iarea(2),text,nlines,
     &		iline_or_dots)
		new_menu = .true.
		change_display = .true.

	    case( 11 )
c
c --		F6 Plot X/Y plots of results
c
		call plot_results(ifile,title(1:len_trim(title)+1),
     &		nv,selected_type,ich,xy)
		call erase_all
		new_menu = .true.
		change_display = .true.

	    case( 12 )
c
c --		Set zero baseline level
c
		call set_zero_level1(iwork,icursor,ich)
		call find_next_record(ifile,irecord,iwork,
     &		selected_type, 0, ich, out_of_range )

		new_menu = .true.
		change_display = .true.

	    case( 13 )
c
c --		Set signal smoothing factor
c
		call display_message(2,2,52,
     &		' Low-pass filter cut-off (Hz) ',1)
	       call get_number(filter_cutoff,0.,1000./rec.dt,
     &	       1000.*filter_cutoff)
	       filter_cutoff = filter_cutoff/1000.

		call find_next_record(ifile,irecord,iwork,
     &		selected_type, 0, ich, out_of_range )
		new_menu = .true.
		change_display = .true.

	    case( 14 )
c
c		Select data display: dots(-1) or lines(1)
c
		iline_or_dots = -iline_or_dots
		change_display = .true.

	    case( 15 )

C
C --		Esc quit this option
C
		quit = .true.

	    end select
	end do

	call save_header( ifile )
	close(unit=ifile)
	return
	end


	subroutine do_fit(ifile,neq,
     &	irecord,selected_type,text,nlines,ich,i_start,i_end,i_zero,title)
$include:'wcpcom.for'
	character*(*) selected_type,text(1),title


	character key
	logical new_menu,out_of_range,quit

	real RMACH(2) /0.01,0.005/

	parameter(maxp=200)
	real*4 weight(maxp),residual(maxp),sltjj(100)
	real*4 work(1)
	equivalence( work, iwork(max_points+1) )

	character*58 menu(11)
	equivalence( menu, iwork )
	character*36 pmenu(11)
	character*12 list(11)
	character*40 err

	parameter(nqm=3)
	character*32 qmenu(nqm) /
     &	' Try new initial parameters F1',
     &	' Skip to next fit           F2',
     &	' Abandon all fitting       ESC' /

	external fit_func
	real*4 x(maxp),y(maxp)
	common /ssqcom/ ieq,x,y
c
c	code
c

	if( ieq .eq. 0 ) ieq = 1

	do i = 1,neq
	    call define_equation( i, menu(i), npars )
	end do

	new_menu = .true.
	ieq = Iwait_MENU_VERTICAL1(menu,'123456789',neq
     &	,2,2,new_menu,ieq,' Select function ',key)

	ieq = max(ieq,1)
	call define_equation( ieq, menu(ieq), npars )

	call set_record_range(ir_s,ir_e,3,4+ieq,' Records to be fitted ')

	irecord = ir_s
	iold_record = irecord
	out_of_range = .false.
	do while( irecord .le. ir_e .and. .not. out_of_range )
c
c	    Read selected channel and transfer it into ibuf
c
	    call find_next_record(ifile,irecord,iwork,
     &	    selected_type, 0, ich, out_of_range )

	    if( .not. out_of_range ) then
		iold_record = irecord

		rec.iequation = ieq + 100*ich
		rec.is = i_start
		rec.ie = i_end
		rec.iz = i_zero

		write( text(1), '('' Fitting record '',i4,''/'',i4)')
     &		irecord,ir_e

		call display_results( text, 2, 2 )
		call find_cursor( ixc, iyc )
		call move_cursor(2,iyc+1)

		np = 0					! Create x,y data arrays
		i = i_start				! containing part of record
		do while( (i .lt. i_end) .and. (np.lt.maxp) )  ! to be fitted
		    np = np + 1
		    x(np) = float(i-i_zero)*rec.dt*tscale
		    y(np) = float(iwork(i)-iy_zero(ich))*y_scale(ich)
		    i = i + (np/40)+1
		end do

		ymaxa = 0.
		do i = 1,np
		    if( abs(y(i)) .gt. ymaxa ) ymaxa = abs(y(i))
		end do
		xmaxa = x(np)

		rescale = x(np)/ymaxa			     ! Normalise x & y
		do i = 1,np				    ! data to same
		    y(i) = y(i)*rescale 		    ! range (improves
		    weight(i) = 1.			    ! fit)
		end do

		iconv = 1
		quit = .false.
		do while( .not. quit )
c
c		    Produce an initial guess
c
		    call initial_parameters(x,y,np,rec.par,ieq)

		    if( iconv .le. 0 ) then
c
c			If fit has failed let the user
c			try another initial guess, or quit
c
			new_menu = .true.
			iop = Iwait_MENU_VERTICAL1(qmenu,'12$',nqm
     &			,2,iyc+1,new_menu,1,
     &			' Fitting failed (or aborted) ',key)

			select case (iop)
			case (1)
c
c			    Let user try a new set of initial guesses
c
			    call unscale_parameters(
     &			    rec.par,ieq,rescale )

			    do i = 1,npars
			       write( pmenu(i),
     &			       '(''Par. '',a,'' Initial Guess '')')
     &			       var_name(11+i)
			       write( list(i), '(1pg12.3)' ) rec.par(i)
			    end do

			    err = ' '
10			    if( err .eq. ' ' )
     &			    err = ' Set initial parameters'
			    call text_window(pmenu,list,npars,
     &			    3,iyc+3,err )

			    do i = 1,npars
			       rec.par(i) = check_limits(list,
     &			       -1E30,1E30,i,err)
			       if( err .ne. ' ' ) goto 10
			    end do

			    call scale_parameters(
     &			    rec.par,ieq,rescale )

			case (2)
c
c			    Skip to next fit in list
c
			    quit = .true.
			    out_of_range = .false.
			case (3)
c
c			    Abandon fitting
c
			    quit = .true.
			    out_of_range = .true.
			end select
		    end if

		    nsig_pars = 4
		    nsig_ssq = 4
		    delta_max = 1E-16
		    max_iterations = 100
		    iconv = 0
		    call move_cursor(2,iyc+1)
		    call ssqmin(rec.par,np,npars,
     &		    max_iterations,1,nsig_pars,nsig_ssq,delta_max,rmach,
     &		    weight,sltjj,iconv,iteration,ssq,residual,fit_func,
     &		    work)
c
c		    Calculate parameter standard errors if fit
c		    has converged OK
c
		    if( iconv .gt. 0 ) then
			quit = .true.
			call stat(np,npars,residual,y,weight,sltjj,
     &			ssq,rec.se,rec.sd,r,rec.par)
		    else
			do i = 1,npars
			   rec.se(i) = -1.
			end do
		    end if

		end do

c
c		Restore correct scaling to y-related parameters
c
		call unscale_parameters(rec.par,ieq,rescale )
		call unscale_parameters(rec.se, ieq,rescale )

		rec.sd = rec.sd/rescale
c
c
c		Calculate chi-square
c
		if( izero_sample(ich) .gt. 0 ) then
c
c		    Calculate signal variance from portion of
c		    signal record used to compute zero level
c
		    i0 = izero_sample(ich)
		    i1 = i0 + nzero - 1

		    avg = 0.
		    do i = i0,i1
			avg = avg + float(iwork(i))
		    end do
		    avg = avg/float(max(nzero,1))

		    var = 0.
		    do i = i0,i1
			r = float(iwork(i)) - avg
			var = var + r*r
		    end do
		    var = var/float(max(nzero-1,1))
		    var = var*y_scale(ich)*y_scale(ich)
c
c		    Calculate variance ratio of residual variance
c		    and background variance

		    if( var .gt. 0. ) then
			rec.f = (rec.sd*rec.sd) / var
			df_num = float(np - npars)
			df_den = (nzero-1)
			rec.prob = f_prob( rec.f, df_num, df_den )
		    else
			rec.f = 0.
			rec.prob = 0.
		    end if

		else
		    rec.f = 0.
		    rec.prob = 0.
		end if

		call make_report(irecord,title,text,nlines)
		call display_results( text, 2, nlines )

		rec.results(ich,ixnum) = rec.number
		rec.results(ich,ixtim) = rec.time
		do i = 1,npars				! Copy best-fit parameters
		    rec.results(ich,11+i) = rec.par(i)	! into results array
		end do

c
c		Save best fit parameters in record analysis block
c
		call put_analysis_block(ifile,irecord,rec.buf)

		irecord = irecord + 1

	    end if

	end do

	irecord = iold_record

	return
	end

	subroutine initial_parameters( x,y,np, par, ieq )
	real*4 par(1),x(np),y(np)

	ymax = 0.
	do i = 1,np
	    if( abs(y(i)) .gt. abs(ymax) ) ymax = y(i)
	end do

	select case (ieq)
	case( 1 )
	    par(1) = y(1)*0.9		    ! a*exp(-t/b)
	    par(2) = (x(np)-x(1))/4.
	case( 2 )
	    par(3) = y(np)		! a*exp(-t/b) + c
	    par(2) = (x(np)-x(1))/4.
	    par(1) = (y(1) - y(np))
	case( 3 )
	    par(1) = y(1)*0.75		! a*exp(-t/b) + c*exp(-t/d)
	    par(2) = (x(np)-x(1))/40.
	    par(3) = y(1)*0.25
	    par(4) = par(2)*10.
	case( 4 )
	    par(1) = (y(1)-y(np))*0.75	! a*exp(-t/b) + c*exp(-t/d) + e
	    par(2) = (x(np)-x(1))/40.
	    par(3) = (y(1)-y(np))*0.25
	    par(4) = par(2)*10.
	    par(5) = y(np)
	case( 5 )
	    par(1) = (y(1)-y(np))*0.75	! a*exp(-t/b) + c*exp(-t/d) + e*exp(-t/f)
	    par(2) = (x(np)-x(1))/40.
	    par(3) = par(1)/3.
	    par(4) = par(2)*10.
	    par(5) = par(3)/3.
	    par(6) = par(4)*10.
	case( 6 )
	    par(1) = ymax		! a*0.5*(1+erf(t-d)/b))*exp(-(t-d)/c)
	    par(2) = x(np)/40.
	    par(3) = x(np)/4.
	    par(4) = x(3) - x(1)
	case(7)
	    par(1) = ymax		! a*0.5*(1+erf(t-d)/b))*exp(-(t-d)/c) + e
	    par(2) = x(np)/40.
	    par(3) = x(np)/4.
	    par(4) = x(3) - x(1)
	    par(5) = y(np)
	case( 8 )
c			    ' y(t) = a*[2*b*exp(-t/c) - [b*exp(-t/c)]^2 ]'
	    par(1) = ymax
	    par(2) = 1.
	    par(3) = x(np)/4.
	case( 9 )
c	' y(t) = a*[1-exp(-t/b)]^3 [c - (c-1)*exp(-x/d)]' /
	    par(1) = ymax
	    par(2) = x(np)/40.
	    par(3) = 0.5
	    par(4) = x(np)/4.
	case( 10 )
	    par(1) = y(np)-y(1) 	      ! a*(1.-exp(-t/b))^2 + c
	    par(2) = (x(np)-x(1))/4.
	    par(3) = y(np)
	end select

	return
	end

	subroutine unscale_parameters( par, ieq, rescale )
	real*4 par(1)

	select case (ieq)
	case( 1 )
	    par(1) = par(1)/rescale
	case( 2 )
	    par(3) = par(3)/rescale
	    par(1) = par(1)/rescale
	case( 3 )
	    par(1) = par(1)/rescale
	    par(3) = par(3)/rescale
	case( 4 )
	    par(1) = par(1)/rescale
	    par(3) = par(3)/rescale
	    par(5) = par(5)/rescale
	case( 5 )
	    par(1) = par(1)/rescale
	    par(3) = par(3)/rescale
	    par(5) = par(5)/rescale
	case( 6 )
	    par(1) = par(1)/rescale
	case( 7 )
	    par(1) = par(1)/rescale
	    par(5) = par(1)/rescale
	case( 8 )
	    par(1) = par(1)/rescale
	case( 9 )
	    par(1) = par(1)/rescale
	case( 10 )
	    par(1) = par(1)/rescale
	    par(3) = par(3)/rescale
	end select

	return
	end

	subroutine scale_parameters( par, ieq, rescale )
	real*4 par(1)

	select case (ieq)
	case( 1 )
	    par(1) = par(1)*rescale
	case( 2 )
	    par(3) = par(3)*rescale
	    par(1) = par(1)*rescale
	case( 3 )
	    par(1) = par(1)*rescale
	    par(3) = par(3)*rescale
	case( 4 )
	    par(1) = par(1)*rescale
	    par(3) = par(3)*rescale
	    par(5) = par(5)*rescale
	case( 5 )
	    par(1) = par(1)*rescale
	    par(3) = par(3)*rescale
	    par(5) = par(5)*rescale
	case( 6 )
	    par(1) = par(1)*rescale
	case( 7 )
	    par(1) = par(1)*rescale
	    par(5) = par(1)*rescale
	case( 8 )
	    par(1) = par(1)*rescale
	case( 9 )
	    par(1) = par(1)*rescale
	case( 10 )
	    par(1) = par(1)*rescale
	    par(3) = par(3)*rescale
	end select

	return
	end

	subroutine fit_func( par, np, npar, residual )
	real*4 par(npar),residual(np)

	parameter(maxp=200)
	real*4 x(maxp),y(maxp)
	common /ssqcom/ ieq,x,y

	do i = 1,np
	    residual(i) = y(i) - func( par, ieq, x(i) )
	end do
	return
	end

	real*4 function func( par, ieq, x )
	real*4 par(1)

	select case (ieq)

	case( 1 )
	    func = par(1)*expl(-x,par(2))
	case( 2 )
	    func = par(1)*expl(-x,par(2)) + par(3)
	case( 3 )
	    func = par(1)*expl(-x,par(2)) +
     &		   par(3)*expl(-x,par(4))
	case( 4 )
	    func = par(1)*expl(-x,par(2)) +
     &		   par(3)*expl(-x,par(4)) + par(5)
	case( 5 )
	    func = par(1)*expl(-x,par(2)) +
     &		   par(3)*expl(-x,par(4)) +
     &		   par(5)*expl(-x,par(6))
	case( 6 )
	    t = x - par(4)
	    func = par(1)*0.5*(1.+erf(t/par(2)))*expl(-t,par(3))
	case( 7 )
	    t = x - par(4)
	    func = par(1)*0.5*(1.+erf(t/par(2)))*expl(-t,par(3)) +
     &		   par(5)
	case( 8 )
	    expr = par(2)*expl(-x,abs(par(3)))
	    func = par(1)*(2.*expr - expr*expr)
	case( 9 )
	    rm = 1. - expl( -x,abs(par(2)) )
	    rh = (par(3) - 1.)*expl( -x,abs(par(4)) )
	    func = par(1)*rm*rm*rm*(par(3) - rh)
	case( 10 )
	    y = 1. - expl( -x, abs(par(2)) )
	    func = par(1)*y*y + par(3)
	end select
	return
	end

	real function expl(x,tau)
	real*4 x,tau
	if( tau .ne. 0. ) then
	    r = x/tau
	    y = sign(min(abs(r),20.),r)
	    expl = exp(y)
	else
	    expl = 0.
	end if
	return
	end

	subroutine paws
	character key
	logical sp
	call wait_for_key(key,sp)
	return
	end


	subroutine make_report(irecord,title,text,nlines)
$include:'wcpcom.for'
	character*(*) text(1),title
	character rec_type*4

	nlines = 1
	text(nlines) = title

	nlines = nlines + 1
	rec_type = rec.type
	ieq = mod(rec.iequation,100)
	ich = rec.iequation/100
	write(text(nlines),
     &	'(''Record'',i5,''/'',i5,1x,a,'' Ch.'',i1,1x,a)')
     &	irecord,n_records,rec_type,ich,y_name(ich)


	call variable_units( ich )

	if( ieq .gt. 0 ) then

	    nlines = nlines + 1
	    call define_equation( ieq, text(nlines), npars )

	    nlines = nlines + 1
	    ia = ichar('a')-1
	    do i = 1,npars
		nlines =nlines + 1
		par = rec.par(i)
		se = rec.se(i)
		write( text(nlines),
     &		'(a,''= '',f12.4,'' +/- '',f12.4,'' (se) '',a)')
     &		var_name(11+i),par,se,v_units(i+11)
	    end do

	    nlines =nlines + 1
	    r = rec.sd
	    write( text(nlines),
     &	    '(''Residual variance = '',1pg11.3,a,''^2'')' )
     &	    r,y_units(ich)

	    if( rec.f .gt. 0. ) then
		nlines =nlines + 1
		r = rec.f
		p = rec.prob
		write( text(nlines),
     &		'(''F = Res. var. / Background var. = '',f7.2,
     &		'' p= '',f7.5)' )
     &		r,p
	    end if
	end if
	return
	end

	subroutine plot_fit( ichan, ibuf,ifit,ires,i0,n_disp,
     &	iy_scale, iy_offset,idisplay_height,text,nlines,
     &	iline_or_dots)
$include:'wcpcom.for'
	integer*2 ibuf(1),ifit(1),ires(1),iy_scale(1),iy_offset(1)
c
c	Plot a hard copy of the channel displayed on-screen and the
c	best fit (if one is available)
c
c	ibuf(1...n_points) = Data channel to be plotted
c	ifit(1...n_points) = Best fit line
c	ires(1...n_points) = Residual differences between fit and data
c	i0		   = Starting point
c	n_disp		   = No. of points to be plotted
c	iy_scale(1..n_channels) = Display magnification factor
c	iy_offset(1..n_channels) = Offset subtracted before scaling
c	idisplay_height = Height in n.d.c. unit of screen display area
c	iline_or_dots = 1 data plotted as line, -1 data plotted as dots
c	--------------------------------------------------------------

	LOGICAL SPECIAL
	CHARACTER*(*) TEXT(1)
	CHARACTER*30 device
	character key
	parameter(nmenu=2,lwidth=53)
	character*40 menu(nmenu) /
     &	' Vertical calibration bar (   )',
     &	' Time calibration bar     (ms)' /

	character*12 list(nmenu)
	character*36 err
	character*20 string
	character*2 crlf

	integer*2 iarea(4)

	integer*2 ixy(max_points*2)
	equivalence( iwork(max_points*max_channels+1),ixy )

	integer*2 ichan_old /0/
C
C -- CODE ------------------------------------------------------------
C
	if( ichan .ne. ichan_old ) then
	    cal_bar = (float(idisplay_height)*y_scale(ichan))/
     &	    (float(iy_scale(ichan))*10.)
	    ichan_old = ichan
	end if

c	Let user set calibration bars
c
	i = 1
	write(list(i), '(f10.3)' ) cal_bar
	i = 1 + i
	menu(i) = ' Time calibration bar     ('//t_units//')'
	r = float(n_disp)*dt*tscale/10.
	write(list(i), '(f10.3)' ) r

	err = ' '
10	if( err .eq. ' ' )  err = ' Plot Display '
	call text_window(menu,list,nmenu,3,5,err )

	j = 1
	cal_bar = check_limits(list,0.,1E30,j,err)
	if( err .ne. ' ' ) goto 10

	j = 1 + j
	t_cal = check_limits(list,0.,1E30,j,err)/tscale
	if( err .ne. ' ' ) goto 10

c
c	Let user select O/P device
c
	call get_screen_device( iscreen )
	call select_plot_device(4,6,idev,ihandle,device)
	if( (idev.eq. 0) .and. (ihandle.eq.0) ) return

	if( (idev.eq.0) .and. (ihandle.ne.0) ) then
c
c	    ASCII file output option.
c
c	    Title
c
	    crlf = char(13)//char(10)
	    do i = 1,nlines
		write(unit=ihandle) text(i)(1:len_trim(text(i)))
		write(unit=ihandle) crlf
	    end do
c
c	    Channel names and units
c
	    string = 'Time '//t_units
	    write ( unit=ihandle ) string(1:12)
	    write(string,'(a1,''Ch.'',i1,1x,a2,1x,a2)')
     &	    char(9),ichan-1,y_name(ichan),y_units(ichan)
	    write(unit=ihandle) string(1:13)
	    if( ifit(1) .ge. 0 ) then
		write(string,'(a1,''Best fit '',a)')
     &		char(9),y_units(ichan)
		write(unit=ihandle) string(1:13)
	    end if
	    write( unit=ihandle ) crlf
c
c	    Write data points to text file in format
c	    T <TAB> Data point <TAB> Best fit <CR> <LF>
c
	    x = 0.
	    do i = i0,i0+n_disp-1

		write( string, '(1pg12.4)') x
		write( unit=ihandle ) string(1:len_trim(string))

		y = float(ibuf(i)-iy_zero(ichan))*y_scale(ichan)
		write( string, '(a,1pg12.4)') char(9),y
		write(unit=ihandle) string(1:len_trim(string))

		if( ifit(1) .ge. 0 ) then
		    y = float(ifit(i)-iy_zero(ichan))*y_scale(ichan)
		    write( string, '(a,1pg12.4)') char(9),y
		    write(unit=ihandle) string(1:len_trim(string))
		end if

		write( unit=ihandle ) crlf
		x = x + rec.dt*tscale
	    end do

	    return

	endif

	call get_text_attributes( idev, i,i,i,i,i,
     &	ichar_width,ichar_height)

	call set_polyline_width( idev, (iline_thickness-1)*50+3 )

	if( idev .eq. iscreen ) call erase_all

C
C -- Set plotting area size
C
	ibottom = max_ndc / 6
	ileft = max_ndc / 4
	iplot_height = max_ndc/4
	iplot_length = max_points*10
c
c	Plot digitised signal record
c
	iarea(1) = ileft
	iarea(2) = ibottom + iplot_height + ichar_height
	iarea(3) = iarea(1) + iplot_length
	iarea(4) = iarea(2) + iplot_height
c
c	Prevent plotting outside defined area
c
	call set_size( iarea(1), iarea(2), iarea(3), iarea(4))
	call enable_clipping( idev )
c
c ------Scale channel data to fit into plotting area		   ---
c	and plot it

	idx = ( iarea(3) - iarea(1) ) / n_disp
	ix = iarea(1)
	yscale = float(iplot_height) *
     &	float(iy_scale(ichan)) / float(idisplay_height)

	k = 0
	do j = i0,i0+n_disp-1
	    k = k + 1
	    ixy(k) = ix
	    k = k + 1
	    ixy(k) = int(float(ibuf(j)-iy_offset(ichan))*yscale)+ iarea(2)
	    ix = ix + idx
	end do

	if( iline_or_dots .gt. 0 ) then
	    call polyline( idev, ixy, k/2 )
	else
	    call polymarker( idev, ixy, k/2 )
	end if
c
c	Plot fitted line (if it exists)
c
	if( ifit(1) .ge. 0 ) then
	    k = 0
	    ix = iarea(1)
	    do j = i0,i0+n_disp-1
		k = k + 1
		ixy(k) = ix
		k = k + 1
		ixy(k) = int(float(ifit(j)-iy_offset(ichan))*yscale)+
     &		iarea(2)
		ix = ix + idx
	    end do
	    call polyline( idev, ixy, k/2 )
	end if


c
c ------Draw dotted line to indicate zero level 		   ---
c
	ixy(1) = iarea(1)
	ixy(2) = int(float(iy_zero(ichan)-iy_offset(ichan))*
     &	yscale )+iarea(2)
	ixy(3) = iarea(3)
	ixy(4) = ixy(2)
	call set_writing_mode( idev, 2 )
	call set_polyline_type( idev, 3 )
	call set_polyline_width( idev, 3 )
	call polyline( idev, ixy, 2 )
	call set_polyline_width( idev, (iline_thickness-1)*50+3 )
	call set_polyline_type( idev, 1 )
	call set_writing_mode( idev, 1 )

	call disable_clipping( idev )
c
c ------Channel name						   ---
c
	ixy(1) = iarea(3) + ichar_width
	ixy(2) = iarea(4) - ichar_height
	call graphics_text( idev, ixy, y_name(ichan) )

c
c ------Plot Calibration bars					    ---
c
	iy_bar = int((yscale*cal_bar)/y_scale(ichan))
	ix = 2*ichar_width
	iy = iarea(2)
	call yt_calibration( idev, ix, iy, iy_bar,ichar_width,
     &	ichar_height,cal_bar,y_units(ichan),'V')

	itime_bar = int( t_cal*float(idx) / rec.dt )
	call yt_calibration( idev, ix, iy, itime_bar,
     &	 ichar_width,ichar_height,t_cal*tscale,t_units,'H')

c
c	Plot residuals (if they exist)
c
	if( ires(1) .ge. 0 ) then

	    iarea(1) = ileft
	    iarea(2) = ibottom
	    iarea(3) = iarea(1) + iplot_length
	    iarea(4) = iarea(2) + iplot_height
c
c	    Prevent plotting outside defined area
c
	    call set_size( iarea(1), iarea(2), iarea(3), iarea(4))
	    call enable_clipping( idev )

	    k = 0
	    ix = iarea(1)
	    do j = i0,i0+n_disp-1
		k = k + 1
		ixy(k) = ix
		k = k + 1
		ixy(k) = int(float(ires(j))*yscale)+ iarea(2)
		ix = ix + idx
	    end do
	    if( iline_or_dots .gt. 0 ) then
		call polyline( idev, ixy, k/2 )
	    else
		call polymarker( idev, ixy, k/2 )
	    end if
c
c	    Plot zero level
c
	    ires_zero = 512
	    ixy(1) = iarea(1)
	    ixy(2) = int(float(ires_zero)* yscale )+iarea(2)
	    ixy(3) = iarea(3)
	    ixy(4) = ixy(2)
	    call set_writing_mode( idev, 2 )
	    call set_polyline_type( idev, 3 )
	    call set_polyline_width( idev, 3 )
	    call polyline( idev, ixy, 2 )
	    call set_polyline_width( idev, (iline_thickness-1)*50+3 )
	    call set_polyline_type( idev, 1 )
	    call set_writing_mode( idev, 1 )

	    call disable_clipping( idev )

	end if

C
C --	Print identification information
C
	IXY(1) = ileft
	IXY(2) = max_ndc - ICHAR_HEIGHT*3
	DO I = 1,nlines
	    IXY(2) = IXY(2) - ICHAR_HEIGHT
	    CALL GRAPHICS_TEXT( Idev, IXY ,TEXT(I) )
	end do
C
C	Close plotting workstation
C
	IF( Idev .NE. ISCREEN ) THEN
	    CALL UPDATE_WORKSTATION(Idev)
	    CALL CLEAR_WORKSTATION(Idev)
	    CALL UNLOAD_FONTS(Idev)
	    CALL CLOSE_WORKSTATION(Idev)
c
c	    If output has been to an HPGL file
c	    fix it to make it compatible with Microsoft Word
c	    and other programs
c
	    if( device(1:1) .eq. 'H' )
     &	     call fix_hpgl( device(2:len(device)) )

	else
	    call move_cursor(2,25)
	    call display_string('<<< Press any key to continue >>>')
	    call wait_for_key( key, special )
	    call erase_all
	end if

	if( idev .ne. 0 ) call set_polyline_width( idev, 3 )

	RETURN
	END

      real*4 function f_prob( vr, df_num, df_den )

c     Calculate F-distribution probability of <vr> <= F <= inf.
c     where <df_num> and <df_den> are the degrees of freedom
c     of the numerator and denominator variances
c

	parameter( dz = 0.01, pi=3.14156 )

	if( (df_num.gt.0.) .and. (df_den.gt.0.)
     &	    .and. (vr.lt.20.) ) then
	    z = ( (1.- 2./(9.*df_den))*vr**(1./3.)
     &		  - (1. - 2./(9.*df_num)) ) /
     &	    sqrt( (2./(9.*df_den))*vr**(2./3.) + 2./(9*df_num) )
	    sum = 0.
	    do while( z .le. 6. )
	       sum = sum + exp( -(z*z)/2. )
	       z = z + dz
	    end do
	    f_prob = (dz/sqrt(2.*pi))*sum
	 else
	    f_prob = 0.
	 end if
	 return
	 end
 
	real function erf(x)
	real*8 t,z,y,erfx
	z = dabs(dble(x))
	t = 1./( 1. + 0.5*z )
	y = t*dexp( -z*z - 1.26551223 +
     &	 t*(1.00002368 + t*(.37409196 + t*(.09678418 +
     &	 t*(-.18628806 + t*(.27886807 + t*(-1.13520398 +
     &	 t*(1.48851587 + t*(-.82215223 + t*.17087277 )))))))))

	if( x .lt. 0. ) y = 2. - y
	erfx = 1. - y
	erf = sngl(erfx)
	return
	end

	subroutine define_equation( ieq, title, npars )
$include:'wcpcom.for'
c
c	Create equation and parameter names
c
	character*(*) title

	do i = 12,nvars
	    var_name(i) = ' '
	end do

	select case (ieq)
	case( 1 )
	    title = ' y(t)= a*exp(-t/tau) '
	    var_name(12) = 'a'
	    var_name(13) = 'tau'
	    npars = 2
	case( 2 )
	    title = ' y(t)= a*exp(-t/tau) + ss'
	    var_name(12) = 'a'
	    var_name(13) = 'tau'
	    var_name(14) = 'ss'
	    npars = 3
	case( 3 )
	    title = ' y(t)= a1*exp(-t/tau1) + a2*exp(-t/tau2)'
	    var_name(12) = 'a1'
	    var_name(13) = 'tau1'
	    var_name(14) = 'a2'
	    var_name(15) = 'tau2'
	    npars = 4
	case( 4 )
	    title = ' y(t)= a1*exp(-t/tau1) + a2*exp(-t/tau2) + ss'
	    var_name(12) = 'a1'
	    var_name(13) = 'tau1'
	    var_name(14) = 'a2'
	    var_name(15) = 'tau2'
	    var_name(16) = 'ss'
	    npars = 5
	case( 5 )
	    title =
     &	    ' y(t)= a1*exp(-t/tau1) + a2*exp(-t/tau2) + a3*exp(-t/tau3)'
	    var_name(12) = 'a1'
	    var_name(13) = 'tau1'
	    var_name(14) = 'a2'
	    var_name(15) = 'tau2'
	    var_name(16) = 'a3'
	    var_name(17) = 'tau3'
	    npars = 6

	case( 6 )
	    title = ' y(t)= a*0.5*(1+erf(t-t0)/tau1)*exp(-t/tau2) '
	    var_name(12) = 'a'
	    var_name(13) = 'tau1'
	    var_name(14) = 'tau2'
	    var_name(15) = 't0'
	    npars = 4
	case( 7 )
	    title = ' y(t)= a*0.5*(1+erf(t-t0)/tau1)*exp(-t/tau2) + ss'
	    var_name(12) = 'a'
	    var_name(13) = 'tau1'
	    var_name(14) = 'tau2'
	    var_name(15) = 't0'
	    var_name(16) = 'ss'
	    npars = 5
	case( 8 )
	   title = ' y(t)= a*[2*b*exp(-t/tau) - [b*exp(-t/tau)]^2 ]'
	    var_name(12) = 'a'
	    var_name(13) = 'b'
	    var_name(14) = 'tau'
	    npars = 3
	case( 9 )
	   title =
     &	   ' y(t)= a*[1-exp(-t/taum)]^3 [hinf - (hinf-1)*exp(-x/tauh)]'
	    var_name(12) = 'a'
	    var_name(13) = 'taum'
	    var_name(14) = 'hinf'
	    var_name(15) = 'tauh'
	    npars = 4
	case( 10 )
	    title = ' y(t)= a*(1-exp(-t/tau))^2 + ss'
	    var_name(12) = 'a'
	    var_name(13) = 'tau'
	    var_name(14) = 'ss'
	    npars = 3
	end select
	return
	end
