	SUBROUTINE DISPLAY_records(itype)
$INCLUDE: 'wcpcom.for'
C	-------------------------------------------------------------------
C	Display selected records and allow values to be read by cursor.
C	-------------------------------------------------------------------
C
c	24/10/95 .. 1 sample offset in readout cursor fixed
c
	LOGICAL SPECIAL,new_menu,redraw,quit
	INTEGER*2 IDISPLAY_AREA(4)

	character string*60, key, stat*14,title*56

	parameter(nmenu=14,istatus_left=64,istatus_top=19)
	character*15 menu(nmenu) /
     &	'Magnify       +',
     &	'Next  rec. PgDn',
     &	'Prev. rec. PgUp',
     &	'Goto  rec. Home',
     &	'Accept/Rej.  F1',
     &	'Record type  F2',
     &	'Keep trace   F3',
     &	'Save cursor  F4',
     &	'Plot records F5',
     &	'Mark T. zero F6',
     &	'Zero levels  F7',
     &	'Channels     F8',
     &	'LP Filter    F9',
     &	'Exit        ESC'/

	character*16 keep_menu(2) /
     &	' Keep Record F1',
     &	' Cancel Keep F2' /

c
c	Display magnification, offsets & colour
c
	integer*2 iy_magn(max_channels) / 6*6 /
	integer*2 min_y_scale(max_channels) / 6*6 /
	integer*2 max_y_scale(max_channels) / 6*1024 /
	integer*2 iy_offset(max_channels) / 6*0 /
	character*1 display_channel(max_channels) / 6*'Y' /

	integer*2 ikeep(max_points)
	equivalence( iwork(max_points*max_channels+1), ikeep )

	integer*2 i_zero /1/
C
C -- CODE -------------------------------------------------------
c
c	Select data file: (original data records or averages),
c	open file attached to unit# ifile
c
	call select_data_file( 2,2, itype, ifile, title )
C
C -- Set size of display area
C 
	CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	CALL GET_CHARACTER_SIZE(IW,IH)
	IDISPLAY_AREA(1) = IW
	IDISPLAY_AREA(2) = MAX_ndc - 24576 - IH
	IDISPLAY_AREA(3) = IDISPLAY_AREA(1) + ((60*IW)/512)*512
	IDISPLAY_AREA(4) = IDISPLAY_AREA(2) + 24576
	CALL SET_SIZE(IDISPLAY_AREA(1),IDISPLAY_AREA(2)
     &	,IDISPLAY_AREA(3),IDISPLAY_AREA(4))
C
C	Set display size to whole of buffer , cursor in middle
C
	N_DISP = N_POINTS
	ICURSOR = N_DISP/2
	IOLD_CURSOR = ICURSOR
	I0 = 1
	I1 = N_DISP
C
C	Read first frame then do a change frame
C	to get frame number on display
C
	N_TABLE = 0
	irecord = 1
	call get_record(ifile,irecord,rec.buf,iwork)
	istep = 0
	call change_record(ifile,irecord,istep,rec.buf,iwork)

	call erase_all

C -- Begin display loop --------------------------------------------
C
	new_menu = .true.
	quit = .false.
	redraw = .true.
	do while ( .not. quit )
c
c	    Refresh options menu
c
	    if( new_menu ) then
		key = ' '
		iop = IMENU_VERTICAL1(menu,'+QPH123456789$',nmenu,
     &		istatus_left-1,1,new_menu,iop,' Disp. Options ',key)
	    endif

	    IF( redraw ) THEN
C
C		-- Redraw display
C
		T_MIN = FLOAT(I0 -1)*rec.DT*tscale
		T_MAX = FLOAT(I0 + N_DISP - 1)*rec.DT*tscale
		call set_writing_mode( iscreen, overwrite )
c		 call set_fill_interior( iscreen, 1, 1, 5 )
		CALL ERASE_BOX(1,1,62,21)
		CALL DISPLAY_BOX(1,1,62,21)
		CALL MOVE_CURSOR(2,21)
		WRITE(STRING,'(1x,f7.2,1x,a)') T_MIN,T_UNITS
		CALL DISPLAY_STRINGt(STRING)
		WRITE(STRING,'(1x,f10.1,1x,a)') T_MAX,T_UNITS
		CALL MOVE_CURSOR(46,21)
		CALL DISPLAY_STRINGt(STRING)
		call move_cursor(2,1)
		call display_stringt(title)

c		 call set_fill_interior( iscreen, 0, 0, 1 )
		call set_writing_mode( iscreen, 2 )

		call display_box(1,22,istatus_left-2,25)

c
c		Display time zero cursor
c
		CALL SET_WRITING_MODE(ISCREEN,2)
		call set_polyline_type(iscreen,3)
		call set_polyline_type(iscreen,6)
		if( (i_zero.ge.i0) .and. (i_zero.le.i0+n_disp))
     &		call display_cursor(
     &		ISCREEN,idisplay_area,I_zero-I0+1,N_DISP)

c
c		Display zero level
c
		do ich = 1,n_channels
		    if( display_channel(ich) .eq. 'Y' ) then
			call set_polyline_type(iscreen,3)
			call set_polyline_colour( iscreen,
     &			icolour(ich))
			call display_horizontal_cursor(iscreen,
     &			idisplay_area,iy_zero(ich),iy_magn(ich),
     &			iy_offset(ich))
		    end if
		end do
c
c		Put readout cursor on-screen
c
a		call set_polyline_colour( iscreen, 1 )
		call set_polyline_type(iscreen,1)
		call set_writing_mode( iscreen, exor )
		icursor = max(min(icursor,i0+n_disp-1),i0)
		iold_cursor = icursor
		call display_cursor(
     &		iscreen,idisplay_area,iold_cursor-i0+1,n_disp)
		CALL SET_WRITING_MODE(	ISCREEN, overwrite )

C
C --		Display signal on screen
C
		do ich = 1,n_channels
		    if( display_channel(ich) .eq. 'Y' ) then
			call plot_channel( iscreen, idisplay_area,
     &			iwork,ich,n_channels,i0, n_disp, iy_magn(ich),
     &			iy_offset(ich),icolour(ich))
		    end if
		end do
c
c		Display channel in keep buffer
c		(if one is there)
c
		if( ikeep_ch .gt. 0 ) then
		    call plot_channel( iscreen, idisplay_area,
     &		    ikeep,1,1,i0, n_disp,iy_magn(ikeep_ch),
     &		    iy_offset(ikeep_ch),8)
		end if
		redraw = .false.
	    end if
C
C --	   Draw vertical readout cursor
C
	    call set_polyline_colour( iscreen, 1 )
	    call set_writing_mode( iscreen, exor )
	    call display_cursor(iscreen,idisplay_area,
     &	    iold_cursor-i0+1,n_disp)
	    call display_cursor(iscreen,idisplay_area,icursor-i0+1,
     &	    n_disp)
	    call set_writing_mode( iscreen, overwrite )
	    IOLD_CURSOR = ICURSOR

c
c --	    Display status information
c
	    call move_cursor(3,23)
	    stat = rec.status//' '//rec.type
	    tm = rec.time
	    group = rec.number
	    write(string,
     &	 '(''Rec. '',i5,''/'',i5,'' Group'',i5,'' at'',f9.2,1x,a)')
     &	     irecord,n_records,int(group),tm,stat
	    call display_stringt(string)
c
c	    Time at sample under cursor
c
	    iy = 25 - n_channels - 2
	    call display_box(istatus_left-1,iy,79,25)
	    TIME = FLOAT(ICURSOR-I_ZERO)*rec.DT*tscale
	    write(string,'(''T:'',F10.2,a)') time,t_units
	    call move_cursor(istatus_left,iy+1)
	    call display_stringt(string)
c
c	    Channel values at sample under cursor
c
	    do ich = 1,n_channels
		call move_cursor(istatus_left,iy+ich+1)
		if( display_channel(ich) .eq. 'Y' ) then
		    i = (icursor-1)*n_channels + ich
		    y = float(iwork(i) - iy_zero(ich))*y_scale(ich)
		    write( string,'(a2,f10.2,a2)')
     &		    y_name(ich),y,y_units(ich)
		    call set_text_colour( iscreen, icolour(ich) )
		    call display_stringt(string)
		else
		    string = ' '
		    call display_stringt(string)
		end if
	    end do
	    call set_text_colour( iscreen, black )

	    call set_margins(2,1,80,25)

c
c	    Wait for user to press a key
c
	    call wait_for_key( key, special )

	    ibig_step = max(n_disp/10,2)

	    if( special .and. (key .eq. 'L') ) then
C		<- = move cursor left 1 point
		ICURSOR = max( ICURSOR - 1, 1 )
		IF(ICURSOR .LT. I0) THEN
		    I0 = max(I0 - ibig_step,1)
		    I1 = I0 + N_DISP - 1
		    redraw = .true.
		ENDIF
		iop = 0
	    elseif( special .and. (key .eq. 'R') ) then
C		-> = move cursor right 1 point
		ICURSOR = min(ICURSOR + 1,n_points)
		i1 = i0 + n_disp - 1
		IF(ICURSOR .GT. I1) THEN
		    I1 = min(I1 + ibig_step,n_points)
		    I0 = I1 - N_DISP + 1
		    redraw = .true.
		ENDIF
		iop = 0
	    elseif( special .and. (key .eq. 'B') ) then
C		CTRL <- = B Move cursor left (big step)
		ICURSOR = max(ICURSOR - ibig_step,1)
		IF(ICURSOR .LT. I0) THEN
		    I0 = max(I0 - ibig_step*2,1)
		    I1 = I0 + N_DISP - 1
		    redraw = .true.
		ENDIF
		iop = 0
	    elseif( special .and. (key .eq. 'F') ) then
C		CTRL -> = Move cursor right (big step)
		ICURSOR = min( ICURSOR + ibig_step, n_points )
		i1 = i0 + n_disp - 1
		IF(ICURSOR .GT. I1) THEN
		    I1 = min( I1 + ibig_step*2, n_points )
		    I0 = I1 - N_DISP + 1
		    redraw = .true.
		ENDIF
		iop = 0
	    else
C
c		Present options menu and return "iop=1..14" if
c		an option has been selected. "iop=0" if no selection
c
		iop = IMENU_VERTICAL1(menu,'+QPH123456789$',nmenu,
     &		istatus_left-1,1,new_menu,iop,' Disp. Options ',key)


c ------------- This routine added to swap channels 0 & 1
c		to recover from bug which caused these to be switched
c		over in some records 2/9/94
c
		if( key .eq. '!' ) then
		    CALL QUERY_BOX(2,2,
     &		    ' Swap channels 0 & 1! Are you sure (Y/N) ? ',key)
		    if( key .eq. 'Y' ) then
			do i = 1,n_points
			    j = 2*i
			    itemp = iwork(j)
			    iwork(j) = iwork(j-1)
			    iwork(j-1) = itemp
			end do
			istep = 0
			call change_record(ifile,irecord,
     &			istep,rec.buf,iwork)
		    end if
		end if
c -------------------------

	    endif

	    select case (iop)
	    case (1)
C
C		Expand display
C
		call change_display_magnification( iwork,
     &		i0,n_disp,iy_magn,iy_offset,min_y_scale,max_y_scale,
     &		idisplay_area )
		icursor = max(min(icursor,i0+n_disp-1),i0)
		redraw = .true.
		new_menu = .true.

	    case (2)
C
C		PgDn - Read next frame
C
		istep = 1
		call change_record(ifile,irecord,istep,rec.buf,iwork)
		redraw = .true.
		new_menu = .true.

	    case (3)
C
C		PgUp - Read last frame stored
C
		istep = -1
		call change_record(ifile,irecord,istep,rec.buf,iwork)
		redraw = .true.
		new_menu = .true.

	    case (4)
C
C		Goto selected record
C
		write(string,'('' Go to record (1-'',i5,'') ? '')')
     &		n_records
		call display_message(2,23,46,string(1:30),1)
		call get_number(r,1.,float(n_records),float(irecord))
		call erase_box(2,23,istatus_left-1,25)
		istep = int(r) - irecord
		call change_record(ifile,irecord,istep,rec.buf,iwork)
		redraw = .true.
		new_menu = .true.

	    case (5)
C
C		F1 - Change record status
C
		new_menu = .true.
		call change_record_status( rec.status, irecord, ifile )
		call change_record(ifile,irecord,0,rec.buf,iwork)
		redraw = .true.
		new_menu = .true.

	    case (6)
C
C		F2 - Change record type
C
		new_menu = .true.
		call set_record_type( 2,2, rec.type )
		call change_record(ifile,irecord,0,rec.buf,iwork)
		redraw = .true.
		new_menu = .true.

	    case (7)
C
C		F3 - Transfer a channel from the current record
c		     into the keep buffer
C
		if( ikeep_ch .gt. 0 ) then
		    ik = Iwait_MENU_VERTICAL1(keep_menu,'12'
     &		    ,2,2,2,new_menu,1,' Keep Channel ',key)
		else
		    ik = 1
		end if

		if( ik .eq. 1 ) then
		    call select_channel( 3,3, ' Keep Ch. ', ikeep_ch )
		    j = ikeep_ch
		    do i = 1,n_points
			ikeep(i) = iwork(j)
			j = j + n_channels
		    end do
		else
		    ikeep_ch = 0
		end if

		redraw = .true.
		new_menu = .true.

	    case (8)
C
C		F4 - Save cursor readout value to table
C
		nc = 1
		string = ' '
		write( string(nc:nc+4),'(i4,1x)') irecord
		nc = len_trim(string) + 1
		write( string(nc:nc+12),'(1pg12.4,1x)') time
		nc = len_trim(string) + 1

		do ich = 1,n_channels
		    if( display_channel(ich) .eq. 'Y' ) then
			i = (icursor-1)*n_channels + ich
			nc = len_trim(string) + 1
			write( string(nc:nc+12),'(1pg12.4,1x)')
     &			float(iwork(i) - iy_zero(ich))*y_scale(ich)
		    end if
		end do
		call write_to_log( string )
		call move_cursor(3,24)
		call display_stringt( string )
		redraw = .true.
		new_menu = .true.

	    case (9)
C
C		F5 - Plot screen
C
		iheight = idisplay_area(4) - idisplay_area(2)
		call plot_display( ifile,irecord,i0,n_disp,
     &		display_channel,iy_magn, iy_offset,iheight,
     &		min_y_scale )
c
c	       Restore current record
c
	       call get_record(ifile,irecord,rec.buf,iwork)

		redraw = .true.
		new_menu = .true.

	    case (10)
C
C	    F6 - Set time zero
C
		I_ZERO = ICURSOR
		redraw = .true.
		new_menu = .true.

	    case( 11 )
C
C		F7 Calibrate signal
C
		call set_zero_level( iwork, icursor )
		call calculate_zero_levels(iwork)
		redraw = .true.
		new_menu = .true.

	    case (12)
c
c		F8 - Select channels to be displayed
c
		call channels_in_use( display_channel )
		redraw = .true.
		new_menu = .true.

	    case( 13 )
c
c		F9 - Set low pass filter cut-off frequency
c
		call display_message(2,2,52,
     &		' Low-pass filter cut-off (Hz) ',1)
		call get_number(filter_cutoff,0.,1000./rec.dt,
     &		1000.*filter_cutoff)
		filter_cutoff = filter_cutoff/1000.
		istep = 0
		call change_record(ifile,irecord,istep,rec.buf,iwork)
		redraw = .true.
		new_menu = .true.

	    case (14)
C
C		Esc quit this option
C
		quit = .true.

	    end select
	end do

	istep = 0
	call change_record(ifile,irecord,istep,rec.buf,iwork)
	call save_header( ifile )
	close(unit=ifile)
	return
	end

	SUBROUTINE set_zero_level(ibuf,icursor)
	integer*2 ibuf(1)
c
c	Define zero level for each channel
c
c	Enter with:
c	ibuf(1..n_points*n_channels) = digitised data record
c	icursor = measurement cursor point
c
$INCLUDE: 'wcpcom.for'

	character*28 menu(max_channels+1)
	character*38 title
	character*12 list(2)
	character key
	logical new_menu

	call select_channel( 2,2, ' Channel No. ', ich )

c	Select zero mode
c	Relative to a sample within each record OR
c	relative to a fixed signal level
c
	menu(1) = ' Relative zero level F1'
	menu(2) = ' Fixed zero level    F2'

	itype = Iwait_MENU_VERTICAL1(menu,'12'
     &	,2,3,3+ich,new_menu,iop,' Zero level ',key)

	if( itype .eq. 1 ) then
c
c	    Relative zero level
c
	    menu(1) = ' Zero level from sample '
	    write(list(1),'(i4)') icursor
	    menu(2) = ' No of samples averaged '
	    write(list(2),'(i4)') nzero

	    title = ' '
100	    if( title .eq. ' ' ) title = ' Relative zero level '
	    call text_window(menu,list,2,5,5+ich+itype,title)

	    izero_sample(ich) = int(check_limits(list,1.,
     &	    float(n_points),1,title))
	    if( title .ne. ' ' ) goto 100
	    nzero = int(check_limits(list,1.,
     &	    float(n_points),2,title))
	    if( title .ne. ' ' ) goto 100

	else
c
c	    Fixed zero level

	    izero_sample(ich) = 0

	    menu(1) = ' Set level ('//y_units(ich)//')'
	    i = (icursor-1)*n_channels + ich
	    write(list(1),'(f8.2)')
     &		float(ibuf(i)-iy_zero(ich))*y_scale(ich)

	    title = ' '
200	    if( title .eq. ' ' ) title = ' Fixed zero level '
	    call text_window(menu,list,1,5,5+ich+itype,title)

	    r = check_limits(list,-1E30,1E30,1,title)
	    if( title .ne. ' ' ) goto 200
	    iy_zero(ich) = ibuf(i) - int(r/y_scale(ich))
	end if

	return
	end

	subroutine calculate_zero_levels( ibuf )
$include:'wcpcom.for'
c
c	Calculate zero levels for each channel of the current
c	digitised record in <ibuf(1..n_points*n_channels)>
c	and place results in iy_zero(1..n_channels) (see wcpcom.for)
c
	integer*2 ibuf(1)
	integer*4 sum

	do ich = 1,n_channels

	    if( izero_sample(ich) .gt. 0 ) then
		i0 = izero_sample(ich)
		i1 = min(i0 + nzero - 1,n_points)
		sum = 0
		do i = i0,i1
		    k = (i-1)*n_channels + ich
		    sum = sum + ibuf(k)
		end do
		iy_zero(ich) = sum/(i1-i0+1)
	    endif
	end do
	return
	end

	subroutine change_display_magnification( ibuf,
     &	i0,n_disp,iy_magn,iy_offset,min_y_scale,max_y_scale,
     &	iarea )
$include:'wcpcom.for'
	integer*2 ibuf(1),iy_magn(max_channels),iy_offset(max_channels),
     &	min_y_scale(max_channels),max_y_scale(max_channels),iarea(4)

c
c	code
c
	call select_channel( 2,2, ' Channel No. ', ich )

	max_y = 4096
c
c	Erase selected Display area and re-draw
c	channel at minimum magnification
c
	call fill_rectangle( iscreen, iarea )
	min_dx = (iarea(3) - iarea(1))/n_points
	max_dx = 32*min_dx

	call plot_channel( iscreen, iarea, ibuf,
     &	ich, n_channels, 1, n_points, min_y_scale,
     &	0, icolour(ich) )
c
c	Superimpose box indicating current magnified display
c	area and let user move box's size and location
c
	call set_display_window(iarea
     &	,min_dx,max_dx,min_y_scale(ich),max_y_scale(ich),max_y
     &	,i0,n_disp,iy_magn(ich),iy_offset(ich),1,22)

	return
	end

	subroutine change_record_status( status, irec, ifile )
$include:'wcpcom.for'

	character*(*) status
	integer irec		! Current record no.
	integer*2 iop /1/
	logical new_menu,quit

	parameter(nmenu1=3)
	character*36 menu1(nmenu1)
	character*38 title
	character*10 list(nmenu1)
	character key,Stat

	parameter(nmenu=3)
	character*16 menu(nmenu) /
     &	'Rejected   F1',
     &	'Accepted   F2',
     &	'Set Block  F3' /
c
c	code
c
	iop = iwait_menu_vertical1(menu,'123',nmenu,2,2
     &	,new_menu,iop,' Set Status ',key)

	select case (iop)
	case (1)
	    status = 'REJECTED'
	case(2)
	    status = 'ACCEPTED'
	case(3 )

	    i = 1
	    write( menu1(i), '('' Start at record (1-'',i4,'')'')')
     &	    n_records
	    list(i) = ' 1'
	    i = i + 1
	    menu1(i) = ' End at record '
	    write(list(i),'(i5)') n_records
	    i = i + 1
	    menu1(i) = ' Status (A=Accepted, R=Rejected) '
	    list(i) = 'A'

	    title = ' '
100	    if( title .eq. ' ' ) title = ' Set record status '
	    call text_window(menu1,list,nmenu,3,3,title)

	    i = 1
	    iStart = int(check_limits(list,1.,float(n_records),i,title))
	    if( title .ne. ' ' ) goto 100
	    i = i + 1
	    iEnd = int(check_limits(list,1.,float(n_records),i,title))
	    if( title .ne. ' ' ) goto 100
	    i = i + 1
	    Stat = check_letter(list,'AR',i,title)
	    if( title .ne. ' ' ) goto 100

	    CALL QUERY_BOX(4,4,
     &	    ' Change record status! Are you sure (Y/N) ? ',key)

	    if( key .eq. 'Y' ) then
		quit = .false.
		irecord = iStart
		do while( .not. quit )
		    call get_record(ifile,irecord,rec.buf,iwork)
		    if( Stat .eq. 'R' ) then
			rec.status = 'REJECTED'
		    else
			rec.status = 'ACCEPTED'
		    end if
		    call put_record(ifile,irecord,rec.buf,iwork)

		    call display_progress( 3, 9,
     &	    ' Records done (ESC to abort)', irecord, iEnd, key )

		    irecord = irecord + 1
		    if( irecord .gt. iEnd .or. key.eq.'$') quit = .TRUE.
		end do
	    end if
c
c	    Re-load original record
c
	    call get_record(ifile,irec,rec.buf,iwork)

	end select

	return
	end

	subroutine channels_in_use( display_channel )
	character*(*) display_channel(1)
$include:'wcpcom.for'

	character*30 menu(max_channels)
	character*2 list(max_channels)
	character*30 title

	if( n_channels .gt. 1 ) then
	    do i = 1,n_channels
		write( menu(i), '('' Display Ch.'',i1,'' (Y/N)'')') i-1
		list(i) = display_channel(i)
	    end do

100	    title = ' Channels displayed '
	    call text_window(menu,list,n_channels,2,2,title)

	    do i = 1,n_channels
		display_channel(i) = check_letter(list,'YN',i,title)
		if( title .ne. ' ' ) goto 100
	    end do
	end if

	return
	end

	subroutine plot_display( ifile,irecord,i0,n_disp,
     &	display_channel,
     &	iy_scale, iy_offset,idisplay_height, min_y_scale )
$include:'wcpcom.for'
	integer*2 iy_scale(1),iy_offset(1),idisplay_height,min_y_scale(1)
	character*(*) display_channel(1)

c	--------------------------------------------------------------
c	Plot a hard copy of the currently displayed record on
c	Printer,Plotter,ASCII file, or HPGL file.
c
c	i0 = Start at point
c	n_disp = No of points to be displayed
c	iy_scale(1..n_channels) = Display magnification factor
c	iy_offset(1..n_channels) = Offset subtracted before scaling
c	idisplay_height = Height in n.d.c. unit of screen display area
c	--------------------------------------------------------------

	LOGICAL SPECIAL
C
	CHARACTER*30 device
	character key
C
	parameter(lwidth=53)
	character*40 name(max_channels+1)
	character*12 list(max_channels+1)
	character*36 err

	real*4 y_bar(max_channels)
	integer*2 iarea(4)

	integer*2 ixy(max_points*2)
	equivalence( iwork(max_points*max_channels+1),ixy )

	logical first / .true. /, not_set / .true. /, new_menu
	character*2 crlf
	character*40 string
	character*60 rec_list

	parameter(nmenu=3)
	character*18 menu(nmenu) /
     &	' This record F1 ',
     &	' All records F2 ',
     &	' From list   F3 ' /

	parameter( isingle=1, iall=2, ilist=3 )
	parameter(nmax=100)
	integer*2 irlist(nmax) /100*0/
	character draw_zero /  'Y' /
	real*4 y_max(max_channels),y_min(max_channels)
c
c	code
c
c
c	Select record or range of records to be plotted
c
	new_menu = .true.
	itype = Iwait_MENU_VERTICAL1(menu,'123'
     &	,nmenu,2,2,new_menu,itype,' Plot Records ',key)

	select case (itype)
	case (isingle)
	    ir_s = irecord
	    ir_e = irecord
	    write( rec_list, '(''Rec. '',i4)') irecord
	case (iall)
	    ir_s = 1
	    ir_e = n_records
	    write( rec_list, '(''Recs. '',i4,'' - '',i4)') ir_s,ir_e
	case (ilist)
	    call edit_list( 3, 3+itype, ' List ', irlist, nmax )
	    ir_s = 1
	    ir_e = nmax
	    rec_list = 'Recs.'
	    j = 6
	    do i = 1,max(nmax,10)
		if( irlist(i) .gt. 0 ) then
		    write( rec_list(j:j+4), '(i4)' ) irlist(i)
		    j = j + 5
		end if
	    end do
	end select

c
c	Select destination to send plot to
c
	call select_plot_device(3,3+itype,idev,ihandle,device)
	if( (idev.eq. 0) .and. (ihandle.eq.0) ) return

c
c	Provide some initial estimates for calibration bars
c
	if( not_set ) then
	    do i = 1,n_channels
		y_bar(i) = (float(idisplay_height)*y_scale(i))/
     &		(float(min_y_scale(i))*10.)
	    end do
	    t_cal = float(n_points)*rec.dt/10.
	    not_set = .false.
	end if
c
c	Let user enter calibration bars
c
	if( idev .ne. 0 ) then
	    j = 0
	    do i = 1,n_channels
		if( display_channel(i) .eq. 'Y' ) then
		    j = j + 1
		    write(name(j),
     &		    '('' Ch.'',i1,1x,a,'' Calibration bar ('',a,'')'')' )
     &		    i-1,y_name(i),y_units(i)
		    write( list(j), '(g10.3)') y_bar(i)
		end if
	    end do

	    j = j + 1
	    name(j) = ' Time calibration ('//t_units//')'
	    write(list(j), '(g10.3)' ) t_cal*tscale

	    j = j + 1
	    name(j) = ' Draw zero level (Y/N) '
	    list(j) = draw_zero
	    nlist = j

	    err = ' '
10	    if( err .eq. ' ' )	err = ' Set calibration bars '
	    call text_window(name,list,nlist,4,10,err )

	    j = 0
	    do i = 1,n_channels
		if( display_channel(i) .eq. 'Y' ) then
		    j = j + 1
		    y_bar(i) = check_limits(list,0.,1E30,j,err)
		    if( err .ne. ' ' ) goto 10
		end if
	    end do

	    j = 1 + j
	    t_cal = check_limits(list,0.,1E30,j,err)/tscale
	    if( err .ne. ' ' ) goto 10

	    j = 1 + j
	    draw_zero = check_letter(list,'YN',j,err)
	    if( err .ne. ' ' ) goto 10
	end if

	if( idev .ne. 0 ) then
	   call get_text_attributes( idev, i,i,i,i,i,
     &	   ichar_width,ichar_height)
	   call set_polyline_width( idev, (iline_thickness-1)*50+3 )
	end if

	if( idev .eq. iscreen ) call erase_all
C
C --	Set plotting area size
C
	nplots = 0
	do ichan = 1,n_channels
	    if( display_channel(ichan) .eq. 'Y' ) nplots = nplots + 1
	end do

	ivertical_spacing = ((max_ndc/4)*3)/nplots
	ibottom = max_ndc / 6
	ileft = max_ndc / 4
	iplot_height = (ivertical_spacing/5)*4
	iplot_length = max_points*10

c
c	Plot list of records
c
	first = .true.
	do ir = ir_s,ir_e

	    if( itype .eq. ilist ) then
		irec = irlist(ir)
		if( irec.gt.0 .and. irec.le.n_records ) then
		    call get_record(ifile,irec,rec.buf,iwork)
		else
		    rec.status = 'REJECTED'
		end if
	    else
		irec = ir
		call get_record(ifile,irec,rec.buf,iwork)
	    end if


	    if( (idev.eq.0) .and. (ihandle.ne.0) .and.
     &		(rec.status .eq. 'ACCEPTED') ) then
c
c		Export data to ASCII file
c		=========================

		call display_progress(2,23,
     &		' Writing to file (Press ESC to abort)',ir,ir_e,key)
		if( key .eq. '$' ) goto 101
c
c
c		Title
c
		crlf = char(13)//char(10)

		if( first ) then
		   write(unit=ihandle) 'File: '//file_name//crlf
		   write(unit=ihandle) id//crlf
		   write(unit=ihandle) rec_list//crlf
c
c		    Channel names and units
c
		    string = 'Time '//t_units
		    write ( unit=ihandle ) string(1:12)
		    do ichan = 1,n_channels
			if( display_channel(ichan) .eq. 'Y' ) then
			    write(string,'(a1,''Ch.'',i1,1x,a2,1x,a2)')
     &			    char(9),ichan-1,y_name(ichan),y_units(ichan)
			    write(unit=ihandle) string(1:13)
			end if
		    end do
		    write( unit=ihandle ) crlf
		    first = .false.
		end if

		write( string, '(''Record='',i5)' ) irec
		write( unit=ihandle) string(1:len_trim(string))//crlf
c
c		Write data points to text file in format
c		T <TAB> Ch.0 <TAB> Ch.1 <TAB> ...etc <CR> <LF>
c
		x = 0.
		do i = i0,i0+n_disp-1
		    ncols = 1

		    write( string, '(1pg12.4)') x
		    write( unit=ihandle ) string(1:len_trim(string))

		    do ichan = 1,n_channels
		       if( display_channel(ichan) .eq. 'Y' ) then
			   j = (i-1)*n_channels + ichan
			   y = float(iwork(j)-iy_zero(ichan))*
     &			   y_scale(ichan)
			   write( string, '(a,1pg12.4)') char(9),y
			   write(unit=ihandle) string(1:len_trim(string))
			end if
		    end do

		    write( unit=ihandle ) crlf

		    x = x + rec.dt*tscale
		end do

	    else if( rec.status .eq. 'ACCEPTED' ) then
c
c		Plot traces on printer or plotter
c		=================================


		nplots = 0
		do ichan = 1,n_channels

		    if( display_channel(ichan) .eq. 'Y' ) then

			if( first ) then
			    y_min(ichan) = y_scale(ichan) *
     &			    float(iy_offset(ichan) - iy_zero(ichan))
			    y_max(ichan) = y_min(ichan) +
     &			    y_scale(ichan) * float(max_adc) *
     &			    float(min_y_scale(ichan)) /
     &			    float(iy_scale(ichan))
			end if
c
c			Define plotting area on page
c
			iarea(1) = ileft
			iarea(2) = ibottom + nplots*ivertical_spacing
			iarea(3) = iarea(1) + iplot_length
			iarea(4) = iarea(2) + iplot_height
			yscale = float( iarea(4) - iarea(2) ) /
     &			(y_max(ichan) - y_min(ichan) )

			nplots = nplots + 1

			call set_size( iarea(1), iarea(2), iarea(3),
     &			iarea(4))
			call enable_clipping( idev )
c
c ------	---	Scale channel data to fit into plotting area
c			and plot it

			ix = iarea(1)
			idx = (iarea(3) - iarea(1))/n_disp

			j0 = (i0-1)*n_channels + ichan
			j1 = j0 + n_disp*n_channels - 1

			k = 0
			do j = j0,j1,n_channels
			    k = k + 1
			    ixy(k) = ix
			    k = k + 1

			    y = y_scale(ichan)*
     &			    float( iwork(j) - iy_zero(ichan) )
			    ixy(k) = iarea(2) +
     &			    int((y - y_min(ichan))*yscale)

			    ix = ix + idx
			end do

			call polyline( idev, ixy, k/2 )

c
c ------	---	Draw dotted line to indicate zero level
c
			if( first ) then
			    ixy(1) = iarea(1)
			    ixy(2) = iarea(2) +
     &			    int(-y_min(ichan)*yscale)
			    ixy(3) = iarea(3)
			    ixy(4) = ixy(2)
			    call set_writing_mode( idev, 2 )
			    call set_polyline_type( idev, 3 )
			    if( draw_zero .eq. 'Y' ) then
				call set_polyline_width( idev, 3 )
				call polyline( idev, ixy, 2 )
				call set_polyline_width( idev,
     &				(iline_thickness-1)*50+3 )
			    end if
			    call set_polyline_type( idev, 1 )
			    call set_writing_mode( idev, 1 )


			    call disable_clipping( idev )
c
c ------	---	    Channel name
c
			    ixy(1) = iarea(3) + ichar_width
			    ixy(2) = iarea(4) - ichar_height
			    call graphics_text(idev,ixy,y_name(ichan))

c
c ------	---	    Plot Calibration bar
c
			    iy_bar = int(yscale*y_bar(ichan))
C			    ix = iarea(1) - 12*ichar_width
			    ix = 2*ichar_width
			    iy = iarea(2)
			    call yt_calibration( idev, ix, iy, iy_bar,
     &			    ichar_width,
     &			    ichar_height,y_bar(ichan),y_units(ichan),'V')

			    it_bar = int(t_cal*float(idx)/rec.dt)
			    call yt_calibration( idev, ix, iy, it_bar,
     &			    ichar_width,ichar_height,
     &			    t_cal*tscale,t_units,'H')

			end if

		    endif
		end do

		call disable_clipping( idev )
		call display_progress(2,23,
     &		' Plotting (Press ESC to abort)',ir,ir_e,key)
		if( key .eq. '$' ) goto 101
		first = .false.

	    end if
	end do
101	continue
C
C --	Print identification information
C
	if( idev.ne.0 ) then
	    call disable_clipping( idev )
	    IXY(1) = ileft
	    IXY(2) = max_ndc - ICHAR_HEIGHT*3
	    CALL GRAPHICS_TEXT( Idev, IXY , 'File: '//file_name )
	    ixy(2) = ixy(2) - ichar_height
	    CALL GRAPHICS_TEXT( Idev, IXY , id(1:len_trim(id)) )
	    ixy(2) = ixy(2) - ichar_height
	    CALL GRAPHICS_TEXT(Idev,IXY,rec_list(1:len_trim(rec_list)))
	end if
C
C	Close plotting workstation
C
	if( (idev.eq.0) .and. (ihandle.ne.0) ) then
	    write( unit=ihandle ) char(26)
	    close( unit=ihandle )
	else if( Idev .NE. ISCREEN ) THEN
	    CALL UPDATE_WORKSTATION(Idev)
	    CALL CLEAR_WORKSTATION(Idev)
	    CALL UNLOAD_FONTS(Idev)
	    CALL CLOSE_WORKSTATION(Idev)

c
c	    If output has been to an HPGL file
c	    fix it to make it compatible with Microsoft Word
c	    and other programs
c
	    if( device(1:1) .eq. 'H' )
     &	     call fix_hpgl( device(2:len(device)) )

	else
	    call move_cursor(3,24)
	    call display_string(
     &	    '     <<< Press any key to continue >>>     ')
	    call wait_for_key( key, special )
	ENDIF

	if( idev .ne. 0 ) call set_polyline_width( idev, 3 )

	CALL SET_MARGINS(1,1,80,25)
	call erase_all

	RETURN
	END

	subroutine edit_list( il, it, title, ilist, nmax )
$include:'wcpcom.for'
	integer*2 ilist(nmax)
	character*(*) title
	logical quit, new_list
	character*8 string
	character key
	parameter(ndisp=10)

	ncs = len(string)
	ib = it + ndisp + 3
	call erase_box( il,it,il+ncs+2,it+ndisp+3)
	call display_box( il,it,il+ncs+2,it+ndisp+3)
	call move_cursor(il+1,it)

	call set_text_colour( iscreen, blue )
	call display_stringt( title )

	call move_cursor(il+1,ib-2)
	call set_text_colour( iscreen, red )
	call display_string('ESC ')
	call move_cursor(il+1,ib-1)
	call display_string('to exit.')
	call set_text_colour( iscreen, black )

	new_list = .true.
	quit = .false.
	i0 = 1
	i1 = i0 + ndisp - 1
	ic = 1
	do while( .not. quit )

	    if( new_list ) then
		do i = i0,i1
		    call move_cursor(il+1,it+i-i0+1)
		    write( string, '(i5)' ) ilist(i)
		    if( ilist(ic) .le. 0 ) string = ' '
		    call display_string( string )
		end do
		new_list = .false.
	    end if
c
c	    Edit a list entry
c
	    write( string, '(i5)' ) ilist(ic)
	    if( ilist(ic) .le. 0 ) string = ' '
	    call move_cursor(il+1,ic-i0+it+1)
	    call get_string( string, nc, key )
	    read( string, '(f6.0)',err=10 ) r
	    ilist(ic) = int(r)
	    goto 11
10	    ilist(ic) = 0
11	    continue

	    call move_cursor(il+1,it+ic-i0+1)
	    write( string, '(i5)' ) ilist(ic)
	    if( ilist(ic) .le. 0 ) string = ' '
	    call display_string( string )

	    select case (key)
	    case ('U')
		ic = max(ic-1,1)
		if( ic .lt. i0 ) then
		    i0 = max(i0 - ndisp/2,1)
		    i1 = i0 + ndisp - 1
		    new_list = .true.
		end if
	    case ('D')
		ic = min(ic+1,nmax)
		if( ic .gt. i1 ) then
		    i1 = min(i1 + ndisp/2,nmax)
		    i0 = i1 - ndisp + 1
		    new_list = .true.
		end if
	    case ('$')
		quit = .true.
	    end select
	end do

	return
	end



