	title aglasm.asm
;
;	Read a line of ASCII text (terminated by CR LF )
;	from COM1
;
SAVE_REGS     MACRO
              PUSH DS
              PUSH BP
              MOV BP,SP
              ENDM
;
RESTORE_REGS  MACRO
              MOV SP,BP
              POP BP
              POP DS
              ENDM
;
UNPACK	      MACRO P1,PNARGS
	      MOV SI,[BP]+(4+4*(PNARGS-P1+1))
	      MOV DS,[BP]+(6+4*(PNARGS-P1+1))
	      ENDM

aglasm	segment para public 'code'

	ASSUME CS:aglasm

set_com1    proc far
	public set_com1
;
	SAVE_REGS
;
;
;	Set COM1 to 9600 baud N, 8 bits, 1 stop bit
;
	MOV DX,0
	MOV AX,0E3H
	INT 14H

	restore_regs
	ret

set_com1    endp
;
get_line  proc far
	public get_line

	save_regs
	unpack 1,1

	cli			;Turn interrupts off

get_start:

	MOV DX,0
	MOV AH,2		;Wait for character from COM1
	INT 14H 		;Returned in AL,AH=errors

	cmp al,10
	jz get_start

	MOV DS:[SI],AL		;Save to IBYTES
	INC SI

	CMP al,13		;Exit on CR
	jnz get_start
;
	STI		    ;Interrupts back on
;
	RESTORE_REGS
	RET 4

get_line    endp

to_com1     proc far
	    public to_com1
;
;	    Write a byte to COM1
;	    call to_com1( ibyte )
;
	    save_regs
	    unpack 1,1
	    mov al,ds:[si]	;AL = byte to be sent
	    mov ah,1		;AH=1 to write a character
	    mov dx,0		;DX = port 0
	    int 14h

	    restore_regs
	    ret 4

to_com1     endp



aglasm	ends

	END

 
