	subroutine digitise_analogue_signal( i_start, i_end )
$INCLUDE:'wcpcom.for'
c
c	9/5/94 Fixed to prevent crash when pulse width is less
c	than DAC update interval
c	25/10/94 CED 1902 control added
C	8/5/95 Groups now continue to increment
c	11/9/95 Voltage output scaling factor added to pulse program
c	16/1/96 Seal test pulse added
c	24/1/96 ... Seal test & iadc allocation fixed
c	25/3/97 ... Improved event detection routine
c       30/4/98 ... Holding potential now set correctly between
c                   sweeps, when voltage scale factor different from 1.    
c
C	Record analogue signals
C	-----------------------
c	Enter with:
c	i_start = start of analysis area
c	i_end = end of analysis area
c	(both of these can be set in WCPANA.FOR)
C
	CHARACTER KEY
	LOGICAL SPECIAL,RECORDING,ERASE_SCREEN,new_menu,averaging,
     &	new_setup,quit,logging,done,save_records,ADCActive
	CHARACTER*70 NEW_FILE_NAME / ' ' /
	character*58 old_default_path / ' ' /
	character*15 string
	INTEGER IDISPLAY_AREA(4)

	real*4 sum(max_points)
	equivalence( iwork(max_points*(2*max_channels-3)+1),sum)
C
	parameter(nmenu=12 ,istatus_left=64,istatus_top=17)
	character*15 menu(nmenu) /
     &	'New file     F1',
     &	'Start sweep  F2',
     &	'Set trigger  F3',
     &	'Set display  F4',
     &	'Set V. Prot. F5',
     &	'Averaging    F6',
     &	'Set comment  F7',
     &	'Measuring    F8',
     &	'Set up       F9',
     &	'CED 1902    F10',
     &	'Test Pulse    T',
     &	'Exit        ESC' /

	parameter(nmenur=4)
	character*15 menur(nmenur) /
     &	'Stop       ESC',
     &	'Erase disp. F1',
     &	'Del. rec.   F2',
     &	'Res. avg.   F3' /

	parameter(nmenu2=4)
	character*36 menu2(nmenu2) /
     &	' Start recording to disk        F1',
     &	' Start recording (no saving)    F2',
     &	' No. of records to be collected F3',
     &	' Cancel                        ESC'/

	parameter( ifree_run=1,iexternal=2, idetect=3, iv_prog=4,
     &	max_trigger_modes=4  )
	character*15 trigger_mode(max_trigger_modes) /
     &	 'Free Run     ',
     &	 'Ext. Trigger ' ,
     &	 'Detect Event',
     &	 'Voltage Pulse' /

	parameter( iauto_erase=1,imanual_erase=2,no_display=3)
	character*15 display_mode(3) /
     &	  'Auto Erase     ',
     &	  'Manual Erase   ',
     &	  'No Display' /

	parameter( iyscale=6, iy_lo=0 )

	character*4 rec_type


         record /detector/ det


	record /pulse/ primary
	record /pulse/ alternate

	real*4 vdac(2)
	integer*2 iavg_chan /1/, ilog_chan /1/
	integer*2 n_requested /1/, n_target /0/
	logical first / .true. /
C
C -- CODE
C
	if(old_default_path.eq.' ') old_default_path = default_path
c
c	Select and initialise laboratory interface
c
	CALL OPEN_LAB(INTERFACE_CARD,iwork)
	IF(iwork(1) .NE. 0) return
c
c	Allocate portions of <iwork> array
c	A/D input buffer = iwork(iadc...iadc+np-1)
c	(Note ensure that there is space for at least n_points*2
c	 samples to allow detect_event to work)
c	D/A output buffer = iwork(idac...idac+n_points*2-1)
c	Averaging buffer = iwork(iavg...iavg+n_points
c

c
c	Open data file
c
	ifile = idata_file
	open(unit=ifile,
     &	file=file_name,
     &	form='binary',
     &	access='direct',
     &	recl=512,
     &	iostat=istat )

	call get_header( ifile )
C
C	Set size of display area
C 
	CALL GET_SCREEN_DEVICE(ISCREEN)
	CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	CALL GET_CHARACTER_SIZE(IW,IH)
	IDISPLAY_AREA(1) = IW
	IDISPLAY_AREA(2) = max_ndc - 24576 - IH
	IDISPLAY_AREA(3) = IDISPLAY_AREA(1) + ((60*IW)/512)*512
	IDISPLAY_AREA(4) = IDISPLAY_AREA(2) + iyscale*max_adc
	CALL SET_SIZE(IDISPLAY_AREA(1),IDISPLAY_AREA(2)
     &	,IDISPLAY_AREA(3),IDISPLAY_AREA(4))

c
c	Initialise voltage protocols
c
	if( first ) then
	    call init_protocol( primary, alternate )
	    first = .false.
	end if

C	MAIN PROGRAM LOOP
C	=================

	recording = .false.
	new_menu = .true.
	new_file_name = file_name
	new_setup = .true.
	quit = .false.
	logging = .false.
	save_records = .true.

	do while( .not. quit )

	    if( new_setup ) then
c
c		Allocate A/D and D/A buffers
c
		if( itrigger_mode .eq. idetect ) then
c
c		    Detect mode needs a buffer twice as large as
c		    record size.
c
                    np = min( n_points*n_channels*4,
     &		    max_points*max_channels )
                    if( n_channels .eq. 1 ) np = 8192    

		    np_Circular = np
		    call allocate_adc_buffer(iwork,1,iCircBuf,np)
		    if( iCircBuf .le. np ) then
			iADC = np + 1
		    else
			iADC = 1
		    end if
		    i0 = iADC
		    iADC_test = iCircBuf

		else
c
c		    All other modes
c
		    np = n_points*max(n_channels,4)
		    call allocate_adc_buffer(iwork,1,iadc,np)
		    iadc1 = iadc

		    if( iadc .le. np ) then
			i0 = np + 1
		    else
			i0 = 1
		    end if

		    iADC_test = iADC
		end if

		call allocate_dac_buffer(iwork,i0,idac,np_dac_max*2)
		iavg = max_points*max_channels*2 - n_points + 1

c
c		Make sure sampling interval is set to a value
c		supported by lab. interface
c
		dt1 =  dt/float(n_channels)
		call check_dt( dt1 )
		dt = dt1*float(n_channels)

C		Display plotting area

		CALL ERASE_ALL
		CALL DISPLAY_BOX(1,1,62,21)

		call move_cursor(44,1)
		if( recording .and. save_records ) then
		    call display_reversed(  ' * RECORDING * ')
		elseif( recording ) then
		    call display_reversed(  ' * NO SAVING * ')
		else
		    call display_string(    ' * IDLE      * ')
		endif

		CALL MOVE_CURSOR(2,21)
		WRITE(string,'(F8.1,1X,A2)') 0.,t_units
		CALL DISPLAY_STRINGt(string)
		WRITE(string,'(F10.1,1X,A2)')
     &		dt*float(n_points-1)*tscale,t_units
		CALL MOVE_CURSOR(48,21)
		CALL DISPLAY_STRINGt(string)


		CALL MOVE_CURSOR(2,1)
		call display_stringt(' File '//file_name(1:54) )
c
c --		Display status box ----------------------------------
c
		call display_box(istatus_left-1,istatus_top-1,79,25)

		call move_cursor(istatus_left,istatus_top)
		write(string,'(''Records '',I5)') n_records
		call display_string(string)

		call move_cursor(istatus_left,istatus_top+1)
		call display_string(display_mode( idisplay_mode ) )

		call move_cursor(istatus_left,istatus_top+2)
		call display_string( trigger_mode(itrigger_mode) )

		if( itrigger_mode .eq. idetect ) then
		    call move_cursor(istatus_left,istatus_top+3)
		    write(string,'(''On Channel '',i1)')
     &		    itrigger_channel-1
		    call display_string( string(1:14) )
		end if

		call move_cursor(istatus_left,istatus_top+4)
		if( averaging ) then
		    call display_string('Averaging ON ')
		else
		    call display_string('Averaging OFF')
		endif
		call move_cursor(istatus_left,istatus_top+5)
		if( logging ) then
		    call display_string('Measuring ON ')
		else
		    call display_string('Measuring OFF')
		endif

		if( itrigger_mode .eq. iv_prog ) then
		    call move_cursor(istatus_left,istatus_top+6)
		    call display_string('Pri '//primary_name(6:16))
		    call move_cursor(istatus_left,istatus_top+7)
		    call display_string('Alt '//alternate_name(6:16))
		end if

		new_setup = .false.
	    end if

	    call move_cursor(istatus_left,istatus_top)
	    write(string,'(''Records '',I5)') n_records
	    call display_string(string)

C	    RECORD ANALOGUE SIGNAL
C	    ======================
c
	    if( recording .and. (itrigger_mode .eq. iv_prog) ) then
c
c		In Voltage Pulse mode, wait here until time
c		for next pulse.
c
		t = time_in_secs()
		do while( t .le. t_start )
		    call wait(0.05)
		    t = time_in_secs()
		    call display_time(1,25)
		    call get_key( key, special )
		    if( key .eq. '1' ) then
			call fill_rectangle(iscreen,idisplay_area)
		    elseif( key .eq. '$' ) then
			recording = .false.
			if( .not. save_records ) then
			    call get_header(ifile)
			    new_setup = .true.
			else
			    call save_header(ifile)
			    new_setup = .true.
			end if
		    end if
		end do
		t_start = t + primary.period/1000.
	    end if

	    if ( recording ) then

		n_records = n_records + 1

		if( new_menu ) then
		    call erase_box(istatus_left-1,1,79,istatus_top-2)
		    call display_message(istatus_left-1,1,16,menur,nmenur)
		    call move_cursor(istatus_left,1)
		    call display_string(' Options ')
		    new_Menu = .false.
		endif
c
c		 If - Voltage Pulse mode - create D/A output waveform
c
		if( itrigger_mode .eq. iv_prog ) then
		    call create_stimulus(iwork(idac),n_records,
     &		    igroup,dt_dac_ms,
     &		    np_dac,primary,alternate,rec_type)
		    rec.type = rec_type
c
c		    Begin D/A output (D/A0 = Waveform, D/A1 = sync. pulse)
c
		    idac_trigger = 0
		    idac_mode = 1
		    ndac_channels = 2
		    call memory_to_dac( dt_dac_ms, ndac_channels,
     &		    np_dac,idac_trigger,iwork(idac),idac_mode,ierr)

		else
		    rec.type = 'TEST'
		    igroup = n_records
		end if

		dt1 =  dt/float(n_channels)
		call check_dt( dt1 )
		dt = dt1*float(n_channels)
		WRITE(string,'(F6.1,1X,A2)')
     &		dt*float(n_points-1)*tscale,t_units
		CALL MOVE_CURSOR(52,21)
		CALL DISPLAY_STRINGt(string)
c
c		Start A/D conversion sweep
c

C		Start filling DMA buffer
C		IMODE = 2 indicate circular re-filling of IWORK(iadc)
C		with A/D samples, ITRIG=0 indicates immediate start
C		Note buffer size is 2 x n_points

		if( itrigger_mode .eq. idetect ) then
c
c		    Event detection routine
c
		    call detect_events(det,iwork(iCircBuf),
     &              np_circular,iwork(iadc),key,ADCActive)

		elseif( (interface_card .eq. 1) .and.
     &			(itrigger_mode .eq. iv_prog ) ) then
c
c		    Special recording mode for use with CED 1401
c		    in Voltage Pulse mode only. (Uses the ADCMEMI
c		    command to record A/D sweep since the normal
c		    command ADCDMA cannot run simultaneously with
c		    MEMDAC.
c
		    call move_cursor(2,2)
		    call display_string(
     &		    ' ... Waiting for Event 4 Trigger Pulse ...')
		    call adc_special_ced(dt,n_points,n_channels,
     &		    iwork(iadc),key)
		else
c
c		    All other A/D conversion modes
c		    (Free Run, External Trigger, Voltage Pulse)
c
c		    Set external trigger flag
c		    0 = start A/D sampling immediately
c		    1 = wait for external trigger pulse
c
		    if( itrigger_mode .eq. ifree_run ) then
			itrig = 0
		    else
			call move_cursor(2,2)
			call display_string(
     &			' ... Waiting for Ext. Trigger Pulse ...')
			itrig = 1
		    end if

		    imode = 1
		    call adc_to_memory(dt,n_channels,n_points,
     &		    itrig,iwork(iadc),iadc1,imode,adc_range,key)
		    if( iadc1 .ne. 1 ) then
			call move_cursor(2,1)
			call display_String('Error Allocating ADC buffer')
		    end if

		end if

c
c		Display A/D sweeps as they are recorded
c
		if( idisplay_mode .ne. no_display ) then
		   if(idisplay_mode .eq. iauto_erase) erase_screen = .true.

		   call display_adc(iscreen,iwork(iadc),n_points
     &		   ,n_channels,idisplay_area,icolour,
     &		    erase_screen,key)

		   if( key .eq. '1' ) erase_screen = .true.
		else
c
c ------------------ No Display mode - Wait for A/D sampling to be completed
c
		    key = ' '
		    done = .false.
		    do while( (key.ne.'$') .and. (.not. done) )
			call check_adc_sweep(iwork(iadc),n_points,
     &			n_channels,done)
			call wait( 0.05 )
			call get_key( key, special )
		    end do
		    call convert_adc_values(iwork(iadc),
     &		    n_points*n_channels)

		end if

c
c		Shut down A/D and D/A operations
c
		if( itrigger_mode .ne. idetect) call adc_stop
		if( itrigger_mode .eq. iv_prog ) then
		    call dac_stop
		    if((.not. recording).and.(interface_card.eq.1)) then
c
c		     Temporary Bug Fix to force CED 1401 to stop DAC output
			call write_ced( 'clear;')
			call wait(0.2)
		    end if
                    vdac(1) = (primary.holding_voltage
     &                         *primary.VStimScaleFactor) / 1000.
		    vdac(2) = 0.
		    call set_dacs( vdac, 2 )
		endif

C
C		Get time of collection
C
		rec.time = time_in_secs()
		if( n_records .eq. 1 ) time_start = rec.time
		rec.time = rec.time - time_start
C
C		Save on file
C
		if( key .eq. '2' ) then
c
c		    IF F2 key pressed - delete previous record by
c		    overwriting it with latest one
c
		    n_records = max(n_records - 1,0)
		endif

		rec.ad_range = adc_range
		rec.dt = dt
		rec.number = FLOAT(igroup)
		rec.status = 'ACCEPTED'
		rec.iequation = 0
                rec.is = 0
                rec.ie = 0
                rec.iz = 0

		iwork(iadc) = iwork(iadc+n_channels)
		nb_data = (n_points*n_channels)/npoints_per_block
c
c		If the saving of records has been disabled,
c
c
		if( save_records )
     &		call put_record(ifile,n_records,rec.buf,iwork(iadc))

		if(logging) call log_to_file(iwork(iadc),
     &		i_start,i_end,ilog_chan,istatus_left-2 )
c
c		If in on-screen averaging mode - add the latest record
c		to the average - and display it
c
		if( averaging ) then

		    if( key .eq. '3' ) navg = 0
		    if( navg .eq. 0 ) then     ! Reset averaging
			do i = 1,n_points	! buffer
			    sum(i) = 0.
			end do
		    endif

		    navg = navg + 1				! Calculate
		    j0 = iadc + iavg_chan - 1			! average
		    do i = 1,n_points
			j = (i-1)*n_channels + j0
			sum(i) = sum(i) + float(iwork(j))
			iwork(i) = int( sum(i)/float(navg) )
		    end do

		    call set_polyline_colour( iscreen, 2 )		! Plot
		    call yt_plot( iscreen, iwork(iadc), n_points )     ! on
		    call set_polyline_colour( iscreen, 1 )		! screen
		endif

c		Stop recording after required number of records
c		or if user has pressed the ESC key.

		if( (key .eq. '$') .or.
     &		    (n_records .ge. n_target ) ) then
		    CALL GET_KEY(KEY,SPECIAL)
		    CALL GET_KEY(KEY,SPECIAL)
		    RECORDING = .FALSE.
		    CALL ADC_STOP
		    ADCActive = .False.
		    if( save_records ) then
			call save_header( ifile )
		    else
			call get_header(ifile)
		    end if
		    new_setup = .true.
		end if

	    endif

c	    If not recording, wait for user to select an option from menu
c
	    if( .not. recording ) then
		call move_cursor(44,1)
		call display_string(	' * IDLE      * ')

		new_menu = .true.
		iop = Iwait_MENU_VERTICAL1(menu,'1234567890T$',nmenu,
     &	       istatus_left-1,1,new_menu,iop,' IDLE Options ',key)
	    else
		iop = 0
	    end if

	    select case( iop )

	    case( 1 )
c
c		Open a new WCP data file
c

		new_file_name = file_name
		if( default_path .ne. old_default_path ) then
		    new_file_name = default_path
		else
		    new_file_name = file_name
		end if
		old_default_path = default_path

		call get_file_name(2,2,new_file_name,'.wcp','NEW'
     &		,' New file name ',iflag)

		if( iflag .ge. 0 ) then
		    file_name = new_file_name
		    close(unit=ifile)

		    open(unit=ifile,
     &		    file=file_name,
     &		    form='binary',
     &		    access='direct',
     &		    iostat=istat,
     &		    recl=512)

		    if( iflag .eq. 1 ) then
			call get_header( ifile )
		    else
			n_records = 0
			call save_header( ifile )
		   end if

		   call write_to_log('Data File: '//file_name)

		end if

		new_setup = .true.

	    case( 2 )

C		 Enable recording to file

		IF( .NOT. RECORDING ) THEN

		    done = .false.
		    do while( .not. done )
			ii = Iwait_MENU_VERTICAL1(menu2,'123$',nmenu2,
     &			2,2,new_menu,1,' Start sweep ',key)
			select case (ii)
			case (1)
			    recording = .true.		! Record to disk
			    save_records = .true.
			    done = .true.
			case (2)
			    recording = .true.		! Record, no save
			    save_records = .false.	! to disk.
			    done = .true.
			case (3)
c
c			   Set no. of records to be collected
c
			   call display_message(3,3+ii,52,
     &			   ' No. of records to be collected? ',1)
			   call get_number(r,1.,1E5,float(n_requested))
			   n_requested = int(r)
			   call erase_box(2,2,52,3)

			case (4)
			    recording = .false.
			    save_records = .true.
			    done = .true.
			end select
		    end do

		    if( itrigger_mode .eq. iv_prog ) then
			r = float(n_records) +
     &			(primary.pulses+alternate.pulses)*primary.groups
			n_target = int( min(r,32767.) )
		    else
			r = float(n_requested) + float(n_records)
			n_target = int(min(r, 32767.))
		    end if

		    if( recording .and. save_records ) then
			call write_to_log('Recording')
		    elseif( recording ) then
			call write_to_log('Recording (no save)')
		    endif

		    new_menu = .true.
		    new_setup = .true.
		    ADCActive = .false.
		ENDIF

	    case( 3 )

C		Change triggering mode:
c		Auto-trigger=1/External trigger=2 Detect=3
c
		new_menu = .true.
		nl = num_trigger_modes()
		inew_mode = iwait_menu_vertical1(trigger_mode,'1234',nl,
     &		2,2,new_menu,itrigger_mode,' Trigger Mode ',key)
		if( inew_mode .gt. 0 ) itrigger_mode = inew_mode

		new_setup = .true.

		if( itrigger_mode .eq. idetect ) then
		    if( n_points*n_channels .le. 3072 ) then
			call select_channel( 3,3+itrigger_mode,
     &			' Trigger on ', itrigger_channel )
		    else
			caLL move_cursor(2,2)
			call display_string(
     &	' Warning .. Record too big. Detect mode not available!')
		       itrigger_mode = ifree_run
			new_Setup = .false.
		    end if
		end if


	    case( 4 )
c
c ---------	Select Display mode: Auto-erase,Manual-erase,No display
c
		new_menu = .true.
		inew_mode = iwait_menu_vertical1(display_mode,'123'
     &		,3,2,2,new_menu,idisplay_mode,' Display Mode ',key)
		if( inew_mode .gt. 0 ) idisplay_mode = inew_mode
		new_setup = .true.

	    case( 5 )
c
c		Setup voltage pulse protocol
c
		call voltage_program(idisplay_area,primary,alternate)
		new_setup = .true.
		new_menu = .true.
		new_setup = .true.

	    case( 6 )
c
c		Set on-screen averaging On/Off
c
		averaging = .not. averaging
		if( averaging ) then
		    call select_channel( 2,2,' Averaging Ch. ',iavg_chan)
		    menu(6) = 'Stop Avg.    F8'
		else
		    menu(6) = 'Averaging    F8'
		end if
		if( averaging )
     &		call select_channel( 2,2, ' Average Ch. ', iavg_chan)
		navg = 0
		new_setup = .true.

	    case( 7 )
c
C		Enter a comment line

		call text_window(' ',id(1:50),1,2,2,' Enter comment ')

		call write_to_log( id )
		new_setup = .true.

	    case( 8 )
c
c		Enable/disable data logging
c
		logging = .not. logging
		if( logging ) then
		    call select_channel( 2,2,' Logging Ch. ',ilog_chan)
		    menu(8) = 'Stop Meas.   F8'
		else
		    menu(8) = 'Measuring    F8'
		end if
		new_setup = .true.
		new_menu = .true.

	    case( 9 )

		call setup
		new_setup = .true.
		new_menu = .true.

	    case( 10 )
c
c		Set CED 1902 amplifier
c
		call ced_1902
		new_setup = .true.
		new_menu = .true.

	    case( 11 )
c
c		Gigaseal test pulse
c
		call Test_Pulse(idisplay_area,iwork(iadc_test),
     &		  iwork(iDac))
		new_setup = .true.
		new_menu = .true.

	    case( 12 )

C		ESC = Return to menu
		quit = .true.
	    end select
	end do
C
C	Finished with laboratory interface
C
	CALL ADC_STOP
	ADCActive = .False.
	CALL CLOSE_LAB
	close(unit=ifile)
	return
	end

	subroutine log_to_file(ibuf,i_start,i_end,ilog_chan,iright )
$include:'wcpcom.for'
	integer*2 ibuf(1)
c
c	Printer record measurements to printer or log file
c	as they are collected
c
	character*82 string
c
c	code
c
	if( i_start .le. 0 ) i_start = 1
	if( i_end .le. 0 ) i_end = n_points
	i_end = min(i_end,n_points)
c
c
c	Calculate channel zero level
c
	if( izero_sample(ilog_chan) .gt. 0 ) then
	    sum = 0.
	    i0 = izero_sample(ilog_chan)
	    i1 = min(izero_sample(ilog_chan)+nzero-1,n_points)
	    do i = i0,i1
		j = (i-1)*n_channels + ilog_chan
		sum = sum + float(ibuf(j))
	    end do
	    iy_zero(ilog_chan) = int( sum/float(i1-i0+1) )
	end if

	y_scale(ilog_chan) = convert_gain( gain(ilog_chan) )

	area = 0.
	j = ilog_chan + (i_start-1)*n_channels
	iz = iy_zero(ilog_chan)
	do i = i_start,i_end
	    area = area + float(ibuf(j)-iz)
	    j = j + n_channels
	end do
	area = area*y_scale(ilog_chan)*dt


	ipeak_pos = -max_adc
	ipeak_neg = max_adc
	j = ilog_chan + (i_start-1)*n_channels
	do i = i_start,i_end
	    iy = ibuf(j) - iz
	    if( iy .gt. ipeak_pos ) ipeak_pos = iy
	    if( iy .lt. ipeak_neg ) ipeak_neg = iy
	    j = j + n_channels
	end do
	peak_pos = float(ipeak_pos)*y_scale(ilog_chan)
	peak_neg = float(ipeak_neg)*y_scale(ilog_chan)

	write( string,
     &	 '(i4,1x,3(f10.2,1x),a2)')
     &	 n_records,peak_pos,peak_neg,area

	call write_to_log( string(1:len_trim(string)) )

	call display_box(1,23,iright,25)
	call move_cursor(3,24)
	call display_string( string(1:59) )

	return
	end

	subroutine voltage_program( idisplay_area, primary, alternate )
$include: 'wcpcom.for'
	integer*2 idisplay_area(4)
	record /pulse/ primary		! Primary pulse protococl
	record /pulse/ alternate	! Alternate protocol

	parameter(nmenu=7)
	character*28 menu(nmenu) /
     &	'Edit Pulse Protocol    F1',
     &	'Load Pulse Protocol    F2',
     &	'Save Pulse Protocol    F3',
     &	'Load Alternate Prot.   F4',
     &	'Preview Protocol       F5',
     &	'Delete Protocol        F6',
     &	'Exit                  ESC' /

	character key
	parameter(max_files=100)
	character*12 files(max_files)
	equivalence(iwork,files)
	logical new_menu,quit

c	code
c
	quit = .false.
	do while( .not. quit )
c
c	    Erase background
c
	    call fill_rectangle( iscreen, idisplay_area )

	    if( alternate.pulses .gt. 0. ) then
		menu(4) =  'Cancel Alternate Prot. F4'
	    else
		menu(4) =  'Load Alternate Prot.   F4'
	    endif

	    new_menu = .true.
	    iop = iwait_menu_vertical1(menu,'123456$',nmenu,2,2,
     &	    new_menu,iop,' Voltage Pulse Protocols ',key)

	    select case( iop )

	    case( 1 )
c
c ----		Edit voltage program settings
c
c
c		Initialise the protocol to default values, if it is not defined
c
		if( primary.groups .eq. 0. ) then
		    call init_protocol( primary, alternate )
		end if
		call edit_voltage_program( primary )

	    case( 2 )
c
c ----		Load a pulse protocol from a *.vpr file
c
		call load_voltage_protocol(3,3+iop,
     &		primary, primary_name )

		call write_to_log(
     &		'Primary Pulse Protocol: '//primary_name )

	    case( 3 )
c
c		Save voltage program to *.vpr file
c
		call save_voltage_protocol( 3,3+iop,
     &		primary, primary_name )

	    case( 4 )
c
c ----		Load/Cancel the alternate voltage program
c
		if( alternate.pulses .ne. 0. ) then
c
c		    If an alternate pulse protocol is ALREADY in use
c		    this cancels it
c
		    alternate.pulses = 0.
		    call write_to_log(
     &		    'Alternate Pulse Protocol: None.' )
		    alternate_name = ' '
		else
c
c		    Load the alternate program from file
c
		    call load_voltage_protocol(3,3+iop,
     &		    alternate, alternate_name )

		    call write_to_log(
     &		    'Alternate Pulse Protocol: '//alternate_name )

		endif

	    case( 5 )

		call preview_protocol(idisplay_area,primary,alternate)

	    case( 6 )

		call delete_protocol_file( 3,3+iop )

	    case( 7 )

		quit = .true.
	    end select
	end do
	return
	end



	subroutine edit_voltage_program( active )
$include: 'wcpcom.for'

	record /pulse/ active	       ! Primary pulse protococl

	parameter(nmenu=21, big=1E30)
	character*26 menu(nmenu) /
     &	'Pulse repeat period  (ms)',
     &	'Sampling interval (ms)  ',
     &	'Pulses per group        ',
     &	'Groups per program      ',
     &	'Holding Voltage      (mV)',
     &	'Pulse height (start) (mV)',
     &	'Pulse height (end)   (mV)',
     &	'Increment            (mV)',
     &	'Pulse width          (ms)',
     &	'Increment            (ms)',
     &	'Pre-pulse height     (mV)',
     &	'Increment            (mV)',
     &	'Pre-pulse width      (ms)',
     &	'Increment            (ms)',
     &	'Mid-pulse height     (mV)',
     &	'Increment            (mV)',
     &	'Mid-pulse width      (ms)',
     &	'Increment            (ms)',
     &	'Synch. pulse delay   (ms)',
     &	'Increment            (ms)',
     &	'Voltage Scaling factor '/

	character*12 list(nmenu)
	character*36 title

c
c	code
c

	r = active.period
	write(list(1),'(f12.3)') r
	r = active.dt
	write(list(2),'(f12.3)') r
	r = active.pulses
	write(list(3),'(f12.3)') r
	r = active.groups
	write(list(4),'(f12.3)') r
	r = active.holding_voltage
	write(list(5),'(f12.3)') r
	r = active.pulse_height_start
	write(list(6),'(f12.3)') r
	r = active.pulse_height_end
	write(list(7),'(f12.3)') r
	r = active.pulse_height_inc
	write(list(8),'(f12.3)') r
	r = active.pulse_width
	write(list(9),'(f12.3)') r
	r = active.pulse_width_inc
	write(list(10),'(f12.3)') r
	r = active.pre_pulse_height
	write(list(11),'(f12.3)') r
	r = active.pre_pulse_height_inc
	write(list(12),'(f12.3)') r
	r = active.pre_pulse_width
	write(list(13),'(f12.3)') r
	r = active.pre_pulse_width_inc
	write(list(14),'(f12.3)') r
	r = active.mid_pulse_height
	write(list(15),'(f12.3)') r
	r = active.mid_pulse_height_inc
	write(list(16),'(f12.3)') r
	r = active.mid_pulse_width
	write(list(17),'(f12.3)') r
	r = active.mid_pulse_width_inc
	write(list(18),'(f12.3)') r
	r = active.synch_delay
	write(list(19),'(f12.3)') r
	r = active.synch_delay_inc
	write(list(20),'(f12.3)') r
	r = active.VStimScaleFactor
	write(list(21),'(f12.3)') r

	title = ' '
100	if( title .eq. ' ' ) title = ' Edit Pulse Protocol '
	call text_window( menu, list, nmenu, 2, 2, title )

	active.period = check_limits(list,0.,big,1,title)
	if( title .ne. ' ' ) goto 100

	active.dt = check_limits(list,0.,big,2,title)
	if( title .ne. ' ' ) goto 100

	active.pulses = check_limits(list,1.,big,3,title)
	if( title .ne. ' ' ) goto 100

	active.groups = check_limits(list,1.,big,4,title)
	if( title .ne. ' ' ) goto 100

	active.holding_voltage = check_limits(list,-big,big,5,title)
	if( title .ne. ' ' ) goto 100

	active.pulse_height_start = check_limits(list,-big,big,6,title)
	if( title .ne. ' ' ) goto 100

	active.pulse_height_end = check_limits(list,-big,big,7,title)
	if( title .ne. ' ' ) goto 100

	active.pulse_height_inc = check_limits(list,-big,big,8,title)
	if( title .ne. ' ' ) goto 100

	active.pulse_width = check_limits(list,0.,big,9,title)
	if( title .ne. ' ' ) goto 100

	active.pulse_width_inc = check_limits(list,-big,big,10,title)
	if( title .ne. ' ' ) goto 100

	active.pre_pulse_height = check_limits(list,-big,big,11,title)
	if( title .ne. ' ' ) goto 100

	active.pre_pulse_height_inc = check_limits(list,-big,big,12,title)
	if( title .ne. ' ' ) goto 100

	active.pre_pulse_width = check_limits(list,0.,big,13,title)
	if( title .ne. ' ' ) goto 100

	active.pre_pulse_width_inc = check_limits(list,-big,big,14,title)
	if( title .ne. ' ' ) goto 100

	active.mid_pulse_height = check_limits(list,-big,big,15,title)
	if( title .ne. ' ' ) goto 100

	active.mid_pulse_height_inc = check_limits(list,-big,big,16,title)
	if( title .ne. ' ' ) goto 100

	active.mid_pulse_width = check_limits(list,0.,big,17,title)
	if( title .ne. ' ' ) goto 100

	active.mid_pulse_width_inc = check_limits(list,-big,big,18,title)
	if( title .ne. ' ' ) goto 100

	active.synch_delay = check_limits(list,0.,big,19,title)
	if( title .ne. ' ' ) goto 100

	active.synch_delay_inc = check_limits(list,-big,big,20,title)
	if( title .ne. ' ' ) goto 100

	active.VStimScaleFactor = check_limits(list,1.,1000.,21,title)
	if( title .ne. ' ' ) goto 100

	return
	end

	subroutine init_protocol( primary, alternate )
$include:'wcpcom.for'
	record / pulse / primary
	record / pulse / alternate

	primary.pulses = 1.
	primary.groups = 10.
	primary.period = 1000.
	primary.dt = dt
	primary.pulse_height_start = 100.
	primary.pulse_height_end = 100.
	primary.pulse_height_inc = 0.
	primary.pulse_width = 100.
	primary.pulse_width_inc = 0.
	alternate_pulses = 0.
	primary.VStimScaleFactor = 1.


	if( primary_name .ne. ' ' ) then
	    call load_voltage_protocol(0,0,primary,primary_name )
	end if
	if( alternate_name .ne. ' ' ) then
	    call load_voltage_protocol(0,0,alternate,alternate_name)
	end if

	return
	end


	 subroutine create_stimulus(idac_buffer,irecord,
     &	 igroup,dt_dac,np_dac,primary,alternate,rec_type)
$include:'wcpcom.for'
	integer*2 idac_buffer(1)
c
c	Create Voltage-clamp command pulse & synch. pulse waveforms
c	for output via D/A converter channels 0 & 1.
c	-----------------------------------------------------------
c	Pulse voltage programs are defined in common block /vprog/
c	(See wcpcom.for). D/A output waveform is return in array
c	"idac_buffer(2*n_points)" interleaved DA0,DA1,DA0,DA1....
c	D/A output period is returned in "dt_dac" (ms) (Returned)
c	<dt_adc> = A/D sampling period (IN)
c	<np_dac> = No. of D/A values to be output (per channel)
c
c
c	Note maximum number of points per D/A waveform
c	<np_dac_max> is obtained from WCPCOM.FOR
c
	record /pulse/ primary
	record /pulse/ alternate
	character*4 rec_type
	record /pulse/ active

	parameter(izero_level=2048,start_delay=100.)
c
c	code
c
c
c	Initialise the protocol to default values, if it is not defined
c
	if( primary.groups .eq. 0. ) then
	    call init_protocol( primary, alternate )
	end if

	call lab_limits(interface_card,dt_min,dt_max,ad_min,ad_max,dac)
	bitv = (dac*1000.) / (2048.*primary.VStimScaleFactor)

c	Note VStimScaleFactor adjusts for the scaling down
c	applied to the command voltage by the patch clamp
c	amplfier. Typically 50 for Axon products, 10 for others
c

c
c	If an alternate voltage program is in use, determine the
c	total number of pulses (both primary & alternate) per group
c

	ngroups_per_program = int(primary.groups)
	nprimary_pulses = int(primary.pulses)
	npulses = nprimary_pulses + int(alternate.pulses)
	dt1 = primary.dt / float(n_channels)
	call check_dt( dt1 )
	dt = dt1*float(n_channels)
c
c	Determine D/A update period which allows a complete voltage
c	program to be fitted into an array of length "n_points"
c
	t_max = 1.2 * (
     &	primary.pulse_width +
     &	primary.pulse_width_inc*primary.groups +
     &	primary.pre_pulse_width +
     &	primary.pre_pulse_width_inc*primary.groups +
     &	primary.mid_pulse_width +
     &	primary.mid_pulse_width_inc*primary.groups +
     &	dt*float(n_points/8) +
     &	start_delay )
c
c	Get minimum D/A update interval allowed by lab. interface
c	(See LAB.FOR)
c
	dt_dac_min = dac_min_interval()
	dt_dac = max( t_max/float(np_dac_max), dt, dt_dac_min )
	np_dac = min( int( t_max/dt_dac ) + 2,np_dac_max)

c
c	Select primary or alternate voltage
c
	ipulse = mod(irecord-1,npulses) + 1
	igroup = (irecord-1)/npulses + 1
	iprog_group = mod(igroup-1,ngroups_per_program)+1
	if( ipulse .le. nprimary_pulses ) then
	    active = primary
	    rec_type = 'TEST'
	else
	    active = alternate
	    rec_type = 'LEAK'
c
c	    This line ensures that the period after the last
c	    alternate pulse, is a primary period rather than
c	    an alternate
c
	    if( ipulse .eq. npulses )
     &	    active.period = alternate.period

	end if

c
c	Set holding voltage level
c
	iholding_level = izero_level + int(active.holding_voltage/bitv)
c
c	Set pre-pulse level
c
	ipre_pulse_level = iholding_level +
     &  int( (active.pre_pulse_height/bitv) +
     &       (active.pre_pulse_height_inc/bitv)*(iprog_group-1) ) 
c
c	Set mid-pulse level
c
	imid_pulse_level = iholding_level +
     &  int( (active.mid_pulse_height/bitv) +
     &       (active.mid_pulse_height_inc/bitv)*(iprog_group-1) ) 
c
c	Set pulse level
c
	ipulse_level = iholding_level +
     &  int( (active.pulse_height_start/bitv) +
     &       (active.pulse_height_inc/bitv)*(iprog_group-1) )

	ipre_pulse_start = max(int(start_delay/dt_dac)+1, 2) +
     &	int( dt*float(n_points/8)/dt_dac )

	imid_pulse_start = ipre_pulse_start +
     &  int( (active.pre_pulse_width/dt_dac) +
     &       (active.pre_pulse_width_inc/dt_dac)*(iprog_group-1) )

	ipulse_start = imid_pulse_start +
     &  int( (active.mid_pulse_width/dt_dac) +
     &       (active.mid_pulse_width_inc/dt_dac)*(iprog_group-1) )

	ipulse_end = ipulse_start +
     &	max(int(active.pulse_width/dt_dac),1) +
     &	int(active.pulse_width_inc/dt_dac)*(iprog_group-1)

c
c	voltage step factor for voltage ramps
c
	step = (active.pulse_height_end - active.pulse_height_start)/
     &	(bitv*float( max(ipulse_end - ipulse_start,1) ) )

	isynch_pulse_start = int(active.synch_delay/dt_dac) +
     &  int( (active.synch_delay_inc/dt_dac)*(iprog_group-1) +
     &       (start_delay/dt_dac) )
	isynch_pulse_start = max(min(isynch_pulse_start,np_dac-2),3)
	isynch_pulse_end = isynch_pulse_start + 1
	isynch_off  = izero_level
        bitvS = (dac*1000.) / (2048.)
        isynch_on = int( 4999. / bitvS ) + izero_level
        isynch_on = min( isynch_on, 4095 )


	j = 1
	dlevel = 0.
	do i = 1,np_dac
	    if( i .ge. ipulse_end ) then
		idac_buffer(j) = iholding_level
	    elseif( i .ge. ipulse_start ) then
		idac_buffer(j) = ipulse_level + int(dlevel)
		dlevel = dlevel + step
	    elseif( i .ge. imid_pulse_start ) then
		idac_buffer(j) = imid_pulse_level
	    elseif( i .ge. ipre_pulse_start ) then
		idac_buffer(j) = ipre_pulse_level
	    else
		idac_buffer (j) = iholding_level
	    endif

	    if( i .ge. isynch_pulse_end ) then
		idac_buffer(j+1) = isynch_off
	    elseif( i .ge. isynch_pulse_start ) then
		idac_buffer(j+1) = isynch_on
	    else
		idac_buffer(j+1) = isynch_off
	    endif
	    j = j + 2
	end do
	idac_buffer(np_dac*2-1) = iholding_level
	idac_buffer (np_dac*2) = isynch_off
c
c	Keep within 0-4095 limits
c
	do j = 1,np_dac*2
	    idac_buffer(j) = min(4095,idac_buffer(j))
	end do

	if( np_dac .gt. np_dac_max ) then
	    call move_cursor(2,25)
	    call display_string('ERROR ... D/A buffer too big! ')
	    call display_int(np_dac)
	    call display_int(np_points)
	end if

	return
	end

	subroutine preview_protocol(iarea,primary,alternate)
$include:'wcpcom.for'
	integer*2 iarea(4)
	record /pulse/ primary
	record /pulse/ alternate
	character*4 rec_type
	logical start
	character key
	logical special
c
c	Display pre-view of voltage program on screen.
c	(No output is sent to D/A converters)
c
	character*40 string

	call get_screen_device(iscreen)

	call erase_box(1,1,62,21)
	call display_box(1,1,62,21)
	call move_cursor(2,1)
	call display_string(' Voltage Pulse Protocol Pre-view ')
	call move_cursor(2,21)
	call display_string(' 0. ')
	call erase_box(1,22,62,25)
	call display_box(1,22,62,25)
	call move_cursor(2,24)
	call display_string(' Press ESC to abort ')

	call create_stimulus(iwork,1,igroup,dt_dac,np_dac,
     &	 primary,alternate,rec_type)

	call move_cursor(49,21)
	write(string,'(1x,f9.1,a)') dt_dac*float(np_dac),t_units
	call display_stringt( string )


	npulses = int(primary.groups*(primary.pulses+alternate.pulses))
	do irecord = 1,npulses
c
c	    Plot voltage pulse
c
	   call create_stimulus(iwork,irecord,igroup,dt_dac,np_dac,
     &	   primary,alternate,rec_type)

	    call move_cursor(2,23)
	    if( rec_type .eq. 'TEST' ) then
		write( string,
     &		'('' Primary:   Group '',i4,'' Pulse '',i4)')
     &		igroup, mod(irecord-1,npulses)+1
		itrace_colour = red
	    else
		write( string,
     &		'('' Alternate: Group '',i4,'' Pulse '',i4)')
     &		igroup, mod(irecord-1,npulses)+1
		itrace_colour = blue
	    end if
	    call display_string( string )

	    call plot_channel( iscreen, iarea, iwork,
     &	    1, 2, 1, np_dac, 6, 0, itrace_colour )
c
c	    Indicate period of recording
c
	    start = .false.
	    t = 0.
	    do i = 2,np_dac*2,2
		iwork(i) = iwork(i) - 2048
		if(iwork(i) .gt. 0 ) start = .true.
		if( start .and. t .le. float(n_points)*dt ) then
		    iwork(i) = 100
		    t = t + dt_dac
		else
		    iwork(i) = 0
		end if
	     end do

	    call plot_channel( iscreen, iarea, iwork,
     &	    2, 2, 1, np_dac, 6, 0, black )

	    call get_key( key, special )
	    if( key .eq. '$' ) goto 101

	end do

	call move_cursor(2,24)
	call display_string(' Press any key to continue ')
	call wait_for_key( key, special )

101	continue
	string = ' '
	call move_cursor(2,24)
	call display_string( string )

	return
	end

	subroutine load_voltage_protocol( ix,iy,protocol,fname )
$INCLUDE:'wcpcom.for'
c
c	Load a voltage protocol from file.
c
	record /pulse/ protocol     ! Pulse protocol record
	character*(*) fname	    ! Pulse protocol file name

	parameter(maxc=512)
	character*512 cbuf
	equivalence( cbuf, iwork )
	parameter(max_files=500)
	character*12 files(max_files)
	equivalence( iwork(257), files )
	character*20 new_file_name / ' ' /

	logical eof,ok
C
C	CODE
C	----
C
	ok = .false.
	if( ix .ne. 0 ) then

	    call files_menu('\ses\*.vpp',0,new_file_name,
     &	    ix,iy,10,files,max_files)
	    if( new_file_name .ne. ' ' ) then
		fname = '\ses\'//new_file_name
		ok = .true.
	    end if
	else
	    ok = .true.
	end if

	if( ok ) then

	    call move_cursor(2,2)
	    call display_string(' Loading ... ')
	    call display_string(fname)

	    open(unit=itemp_file,
     &	    file=fname,
     &	    form='binary',
     &	    access='direct',
     &	    recl=1,
     &	    iostat=istat )

	    if( istat .ne. 0 ) then
		call move_cursor(1,25)
		call display_reversed(
     &		'ERROR: Cannot open file ')
		call display_reversed(fname)
		close(unit=itemp_file,iostat=istat)
		fname = ' '
		return
	    end if
c
c	    Open file and read in ASCII text until EOF character is found
c	    or we run out of characters.
c
	    eof = .false.
	    nc = 0
	    cbuf = ' '
	    do while( .not. eof )
		nc = nc + 1
		read(unit=itemp_file,err=100,rec=nc) i
		cbuf(nc:nc) = char(i)
		if( (i .eq. 26) .or. (nc.eq.maxc) ) eof = .true.
	    end do
100	    close(unit=itemp_file)

	    call read_flt( 'PER=',cbuf, protocol.period )
	    call read_flt( 'DT=',cbuf, protocol.dt )
	    call read_flt( 'PULS=',cbuf, protocol.pulses )
	    call read_flt( 'GRPS=',cbuf, protocol.groups )
	    call read_flt( 'HV=',cbuf, protocol.holding_voltage )
	    call read_flt( 'PHS=',cbuf, protocol.pulse_height_start)
	    call read_flt( 'PHE=',cbuf, protocol.pulse_height_end )
	    call read_flt( 'PHI=',cbuf, protocol.pulse_height_inc)
	    call read_flt( 'PW=',cbuf, protocol.pulse_width)
	    call read_flt( 'PWI=',cbuf, protocol.pulse_width_inc)
	    call read_flt( 'PPH=',cbuf, protocol.pre_pulse_height)
	    call read_flt( 'PPHI=',cbuf, protocol.pre_pulse_height_inc)
	    call read_flt( 'PPW=',cbuf, protocol.pre_pulse_width)
	    call read_flt( 'PPWI=',cbuf, protocol.pre_pulse_width_inc)
	    call read_flt( 'MPH=',cbuf, protocol.mid_pulse_height)
	    call read_flt( 'MPHI=',cbuf, protocol.mid_pulse_height_inc)
	    call read_flt( 'MPW=',cbuf, protocol.mid_pulse_width)
	    call read_flt( 'MPWI=',cbuf, protocol.mid_pulse_width_inc)
	    call read_flt( 'SD=',cbuf, protocol.synch_delay)
	    call read_flt( 'SDI=',cbuf, protocol.synch_delay_inc)
	    protocol.VStimScaleFactor = 1.
	    call read_flt( 'VSC=',cbuf, protocol.VStimScaleFactor)
	end if

	return
	end

	subroutine save_voltage_protocol( ix,iy,vpp,fname )
$INCLUDE:'wcpcom.for'
c
c	Save a voltage protocol to file.
c
	record /pulse/ vpp	    ! Pulse protocol record
	character*(*) fname	    ! Pulse protocol file name

	character*512 cbuf
	equivalence( cbuf, iwork )
	character*20 new_file_name / '\ses\' /

	character*8 f
C
C	CODE
C	----
C

	 call get_file_name(ix,iy,new_file_name,'.vpp','NEW'
     &	 ,' File name ',iflag)

	if( iflag .ge. 0 ) then
c
c	    Open file
c
	    fname = new_file_name
	    open(unit=itemp_file,file=new_file_name,form='binary',
     &	    access='direct', recl=1, iostat=istat )

	    f = '(f10.2)'
	    cbuf = ' '
	    call add_flt( vpp.period, 'PER=',cbuf,f)
	    call add_flt( vpp.dt,'DT=',cbuf,f)
	    call add_flt( vpp.pulses, 'PULS=',cbuf,f)
	    call add_flt( vpp.groups, 'GRPS=',cbuf,f )
	    call add_flt( vpp.holding_voltage, 'HV=',cbuf,f)
	    call add_flt( vpp.pulse_height_start,'PHS=',cbuf,f)
	    call add_flt( vpp.pulse_height_end,'PHE=',cbuf,f)
	    call add_flt( vpp.pulse_height_inc,'PHI=',cbuf,f)
	    call add_flt( vpp.pulse_width,'PW=',cbuf,f)
	    call add_flt( vpp.pulse_width_inc,'PWI=',cbuf,f)
	    call add_flt( vpp.pre_pulse_height,'PPH=',cbuf,f)
	    call add_flt( vpp.pre_pulse_height_inc,'PPHI=',cbuf,f)
	    call add_flt( vpp.pre_pulse_width,'PPW=',cbuf,f)
	    call add_flt( vpp.pre_pulse_width_inc,'PPWI=',cbuf,f)
	    call add_flt( vpp.mid_pulse_height,'MPH=',cbuf,f)
	    call add_flt( vpp.mid_pulse_height_inc,'MPHI=',cbuf,f)
	    call add_flt( vpp.mid_pulse_width,'MPW=',cbuf,f)
	    call add_flt( vpp.mid_pulse_width_inc,'MPWI=',cbuf,f )
	    call add_flt( vpp.synch_delay,'SD=',cbuf,f )
	    call add_flt( vpp.synch_delay_inc,'SDI=',cbuf,f )
	    if (vpp.VStimScaleFactor .eq. 0.) vpp.VStimScaleFactor = 1.
	    call add_flt( vpp.VStimScaleFactor,'VSC=',cbuf,f )

	    nc = len_trim(cbuf)
	    cbuf(nc+1:nc+1) = char(26)
	    do i = 1,nc+1
		write(unit=itemp_file) cbuf(i:i)
	    end do
	    close(unit=itemp_file)
	end if

	return
	end

	subroutine delete_protocol_file(il,it)
C
C --	Delete .vpp protocol file
C
$INCLUDE:'wcpcom.for'
C
	CHARACTER*12 NEW_FILE_NAME/ ' ' /
	parameter(max_files=500,nc_path=52)
	character*52 path / ' ' /
	character*12 files(max_files)
	equivalence( iwork, files )
	character key
C
C	CODE
C
	path = '\ses\'
	ix = len_trim(path) + 1
	path(ix:nc_path) = '*.vpp'
	call files_menu(path,0,new_file_name,il,it,10,files,max_files)

	if( new_file_name .ne. ' ' ) then
	    path(ix:nc_path) = new_file_name
	    call query_box(4,7,
     &	    ' Delete: '//path(1:len_trim(path))//' (Y/N) ? ',key)
	    if( key .eq. 'Y' ) then
		call delete_file( ierr, path )
		call write_to_log(
     &		path(1:len_trim(path))//' deleted.' )
	    end if
	end if

	return
	end

	subroutine Test_Pulse(iarea,iadc,iDac)
$include:'wcpcom.for'
c
	integer*2 iarea(4)	! Display area coords.
	integer*2 iadc(1)	! A/D data buffer
	integer*2 iDac(1)	! D/A data buffer
	character key
	logical erase_screen,quit,new_menu
	character*50 string
	parameter(nmenu=2 ,istatus_left=64,istatus_top=17)
	character*15 menu(nmenu) /
     &	' Set Pulse   F1 ',
     &	' Exit       ESC ' /
c
c	code
c
	np_test = 256
c
c	Calculate scaling factor for D/A converter
c
	call lab_limits(interface_card,dt_min,dt_max,ad_min,ad_max,dac)
	bitv = (dac*1000.) / 2048.
	dt_test = max(0.1,2.*dt_min)

	CALL ERASE_ALL
	CALL DISPLAY_BOX(1,1,62,21)
	call display_box(1,22,62,25)

	call move_cursor(2,1)
	call display_string(' Patch clamp seal formation test pulse ')

	CALL MOVE_CURSOR(2,21)
	CALL DISPLAY_STRINGt(' 0. ms ')
	WRITE(string,'(F7.1,'' ms '' )') dt_test*float(np_test-1)
	CALL MOVE_CURSOR(48,21)
	CALL DISPLAY_STRINGt(string)

c
c	Generate test pulse
c
	DtDac = 1.
	call check_dt_dac( DtDac )

	Delay = 100.
	SweepDuration = float(np_test)*dt_test
	nDac = int( (Delay + SweepDuration)/DtDac ) + 1
	iStart = int( (Delay + SweepDuration/8.)/DtDac ) + 1
	iEnd = nDac - max(int( SweepDuration/(8.*DtDac)),1 )
	iSync = int( Delay/DtDac )
	iDacZero = 2048
	iSyncLevel = 2047

	new_menu = .true.
	quit = .false.
	key = ' '
	do while( .not. quit )



	    iop = IMENU_VERTICAL1(menu,'1$',nmenu,
     &	    istatus_left-1,1,new_menu,iop,' Options ',key)

	    select case(iop)
	    case (1)
c
c		Let user set test pulse parameter

		call set_test_pulse

	    case (2)
		quit = .true.
	    end select
c
c	    Create test pulse waveform
c
	    iLevel = int(
     &		     (TestPulseHeight*TestPulseScaleFactor)/bitV )

	    do i = 1,nDac
		j = (2*i)-1
		iDac(j) = iDacZero
		iDac(j+1) = iDacZero
		if( i.ge.iStart .and. i.le.iEnd )
     &		iDac(j) = iDac(j) + iLevel
		if( i .eq. iSync )
     &		iDac(j+1) = iDac(j+1) + iSyncLevel
	    end do

	    idac_trigger = 0
	    idac_mode = 1
	    ndac_channels = 2
	    call memory_to_dac( DtDac, ndac_channels,
     &	    nDac,idac_trigger,iDac,idac_mode,ierr)

	    iExtTrig = 1

	    nChannels = 2

	    if( interface_card .eq. 1 ) then
c
c		Special recording mode for use with CED 1401
c		in Voltage Pulse mode only. (Uses the ADCMEMI
c		command to record A/D sweep since the normal
c		command ADCDMA cannot run simultaneously with
c		MEMDAC.
c
		call adc_special_ced(dt_test,np_test,nChannels,iadc,key)

	    else
c
c		Record a single record of samples for preview
c		and display on screen
c
		imode = 1
		CALL ADC_TO_MEMORY(dt_test,nChannels,np_test,
     &		iExtTrig,iadc,iadc1,imode,adc_range,key)
		if( iadc1 .ne. 1 ) then
		    call move_cursor(2,1)
		    call display_String('Error Allocating ADC buffer')
		end if


	    end if

	    erase_screen = .true.
	    call display_adc(iscreen,iadc,np_test,2,
     &	    iarea,iColour,erase_screen,key)

	    call dac_stop
	    call adc_stop

c
c	    Calculate and display holding current (Im)
c	    and potential (Vm)
c
	    rIm = 0.
	    rVm = 0.
	    navg = 20
	    do i = 2,2+navg-1
		j = 2*(i-1)
		rVm = rVm + float(iadc(j+iVm_Chan))
		rIm = rIm + float(iadc(j+iIm_chan))
	    end do
	    rIm = rIm / float(navg)
	    rVm = rVm / float(navg)
	    iadcZero = 2048
	    rIm = (rIm - float(iadcZero))*y_scale(iIm_chan)
	    rVm = (rVm - float(iadcZero))*y_scale(iVm_chan)

	    call move_cursor(2,23)
	    write(string,'('' Vm= '',f7.1,''mV'',
     &	    '' Im= '',f7.1,''pA'')')
     &	    rVm,rIm
	    call display_stringt(string)
c
c	    Calculate and display pulse current (Ip),
c	    Potential (Vp) and Pipette resistance
c
	    rIp = 0.
	    rVp = 0.
	    navg = 20
	    i0 = (np_test-navg)/2
	    do i = i0,i0+navg-1
		j = 1 + 2*i-3
		rVp = rVp + float(iAdc(j+iVm_chan))
		rIp = rIp + float(iAdc(j+iIm_chan))
	    end do
	    rIp = rIp / float(navg)
	    rVp = rVp / float(navg)
	    rIp = (rIp - float(iadcZero))*y_scale(iIm_chan) - rIm
	    rVp = (rVp - float(iadcZero))*y_Scale(iVm_chan) - rVm

		Resistance = rVp / max(rIp,1E-5)
		call move_cursor(2,24)
		write(string,'('' Vp= '',f7.1,''mV'',
     &		'' Ip= '',f7.1,''pA'',
     &		'' Res= ''f7.3,'' Gohms'')')
     &		rVp,rIp,Resistance
		call display_stringt(string)

	end do

	return
	end

	subroutine set_test_pulse()
$include:'wcpcom.for'
c
c	Set test pulse options
c
c
	parameter(nmenu=4)
	character*34 menu(nmenu) /
     &	' Pulse height (mV) ',
     &	' Pulse scaling factor ',
     &	' Voltage channel No.',
     &	' Current channel No. '/
	character*36 title / ' ' /
	character*10 list(nmenu)
c
c	code
c
	i = 1
	write( list(i), '(f8.1)' ) TestPulseHeight
	i = i + 1
	write( list(i), '(f8.1)' ) TestPulseScaleFactor
	i = i + 1
	write( list(i), '(i2)' ) iVm_chan
	i = i + 1
	write( list(i), '(i2)' ) iIm_chan

	title = ' Test Pulse Setup '
	do while( title .ne. ' ' )

	    call text_window(menu,list,nmenu,2,2,title)

	    i = 1
	    TestPulseHeight = check_limits(list,-10000.,10000.,i,title)
	    if( title .ne. ' ' ) cycle
	    i = 1 + i
	    TestPulseScaleFactor = check_limits(list,1.,1000.,i,title)
	    if( title .ne. ' ' ) cycle
	    i = 1 + i
	    iVm_chan = int(check_limits(list,1.,float(n_channels),i,
     &		       title))
	    if( title .ne. ' ' ) cycle

	    i = 1 + i
	    iIm_chan = int(check_limits(list,1.,float(n_channels),i,
     &		       title))
	    if( title .ne. ' ' ) cycle

	end do
	return
	end

	subroutine detect_events(det,iCircBuf,npCircBuf,
     &   iOutBuf,key,ADCActive)
$include:'wcpcom.for'
c
c       Spontaneous Event Detector
c       ==========================

	record /detector /det	! Event detector record
	integer*2 iCircbuf(1)	! Circular A/D buffer (must be
				! twice as large as signal to be collected)
	integer*2 npCircBuf	! No. of samples in iCircBuf
	integer*2 iOutBuf(1)	! Buffer to hold detected signal (Out)
        character key           ! Returns key pressed by user
	logical ADCActive	! If routine is entered with this
				! value TRUE then circular A/D
				! buffer is already running
	real*4 BitScale
	logical special,done
        parameter( iEmptyFlag = 32760 )
c
c       code
c
	np_record = n_points*n_channels

	if( .not. ADCActive ) then

c           Set up continuous sampling into a circulating buffer }
c           Set size of circular buffer

	    Det.EndofBuf = npCircBuf

c	    Set channel counter

	    Det.LastChan = n_channels
	    Det.Chan = 1

            Det.ChanSelected = itrigger_channel

c	    Set event detection threshold and polarity

	    call get_lab_bit_range( bits_min, bits_max )
	    BitScale = (Bits_max - Bits_min) / 4096.
	    Det.Threshold = int(trigger_level*40.96*BitScale)

            if (Det.Threshold .ge. 0) then 
               Det.Polarity = 1 
c	       Note ... baseline set to maximum value to prevent
c	       event triggering when the recording starts

	       Det.Baseline = Bits_max
            else 
	       Det.Polarity = -1
	       Det.Baseline = Bits_min
            end if
            Det.Threshold = Abs(Det.Threshold) 

c	    Initialise sample pointer

	    Det.Pointer = 1
            

c	    Number of pre-trigger points

            Det.PreTriggerPoints = int(pre_trigger*float(n_points)*0.01)
     &                                  * n_Channels   

c	    Fill buffer with empty marker

	    do i = 1,npCircBuf
		iCircBuf(i) = iEmptyFlag
            end do

c	    Start sampling into circular buffer

            itrig = 0
            imode = 2
            CALL ADC_TO_MEMORY(dt,n_channels,npCircBuf/n_channels,
     &	    itrig,iCircBuf,1,imode,adc_range,key)

            ADCActive = .True.
        end if

        call move_cursor(2,2)
        call display_string(' ... Detecting ...')

c	{ Scan circular A/D buffer for an event }

	Done = .False.
	Det.EventDetected = .false.
	Iteration = 0
	KeyCheckatIteration = int( 250. / dt )

	do while( .not. Done )

           PointerPlus1 = Det.Pointer + 1
           if ( PointerPlus1 .gt. Det.EndofBuf ) PointerPlus1 = 1

           if( iCircBuf(PointerPlus1) .ne. iEmptyFlag ) then

	      iY = iCircBuf(Det.Pointer)
	      iOutBuf(Det.Pointer) = iY
	      iCircBuf(Det.Pointer) = iEmptyFlag

	      if( .not. Det.EventDetected ) then

		  if( Det.Chan .eq. Det.ChanSelected ) then

c		      Event detected ... if signal exceeds threshold

		      if ( Det.Polarity*(iY - Det.Baseline) .gt.
     &			   Det.Threshold ) then
			   Det.EventDetected = .True.

c			   Get segment of buffer to be extracted

			   Det.StartAt =
     &			   (((Det.Pointer-1)/n_Channels)*n_channels)
     &			   + 1 - Det.PreTriggerPoints
                           if ( Det.StartAt .lt. 1 ) then
                              Det.StartAt = Det.StartAt + Det.EndofBuf
			   end if

			   Det.EndAt = Det.StartAt + np_record -1
			   if (Det.EndAt .gt. Det.EndofBuf) then
                               Det.EndAt = Det.EndAt - Det.EndofBuf
			   end if

c			   Time of detection

			   Det.TimeDetected = Det.BufferCycles
			   Det.TimeDetected = dt *
     &			   ((Det.TimeDetected*(Det.EndOfBuf+1)
     &			   + Det.Pointer ) / n_Channels)

		      end if
		 end if

	      else

c		  If an event has been detected ...
c		  Wait till all samples have been collected.
c		  Then transfer the samples to ADC buffer

		  if (Det.Pointer .eq. Det.EndAt) then

c		     If record wrapped around move it to
c		     a contiguous part of the buffer

		     if( Det.EndAt .lt. Det.StartAt ) then
			iFrom = Det.StartAt
                        iTo = Det.EndAt + 1
			do i = 1,np_record
			    iOutBuf(iTo) = iOutBuf(iFrom)
			    iTo = iTo + 1
			    iFrom = iFrom + 1
			    if( iFrom .gt. Det.EndOfBuf ) iFrom = 1
			end do
			Det.StartAt = Det.EndAt+1
                        Det.EndAt = Det.StartAt + np_record - 1
		     end if

c		     Move record to start of buffer

		     j = Det.StartAt
		     do i = 1,np_record
			  iOutBuf(i) = iOutBuf(j)
			  j = j + 1
		      end do
		      Det.EventDetected = .False.
		      Done = .True.
		  end if
	      end if

c	      Update baseline level with 30 point running mean

	      if( Det.Chan .eq. Det.ChanSelected ) then
		    Det.Baseline = (iY + 30*Det.Baseline) / 31
	      end if

c	      Increment pointer

	      Det.Pointer = Det.Pointer + 1
	      if ( Det.Pointer .gt. Det.EndofBuf ) then
		   Det.BufferCycles = Det.BufferCycles + 1
		   Det.Pointer = 1
	      end if

c	      Increment channel counter

	      Det.Chan = Det.Chan + 1
	      if( Det.Chan .gt. Det.LastChan ) Det.Chan = 1

c	      Exit loop if ESC key pressed

	      Iteration = Iteration + 1
	      if ( Iteration .ge. KeyCheckAtIteration ) then
		   Iteration = 0
		   call get_key( key, special )
                   if( key .eq. '$' ) then
                       call get_lab_bit_range( bits_min, bits_max )
                       j = (bits_max + bits_min) / 2
                       do i = 1,np_record
                          iOutBuf(i) = j
                       end do
                       done = .True.
                   end if
	      end if
	   end if

        end do

        return

	end
