	program wcp
$INCLUDE:'wcpcom.for'
c
c    Strathclyde Electrophysiology Software
c    WCP V1.0 Whole Cell Program
c    (c) J. Dempster  1993
c    V1.0b ... Error in WCPTST.FOR noise generator fixed
c    V1.0c ... Curve fitting crashes fixed (WCPFIT.FOR)
c	       Printer fonts bug fixed (WCPSHA.FOR)
c	       Time cal. bar bug fixed	"
c   V1.0d .... 15th AUg 1993
c	       CFS file import fixed
c	       New sweep method for DISPLAY_ADC
c   V1.0e .... 25th Aug 1993 VOLTAGE PULSE INCREMENT BUG FIXED
c   v1.0f .... 31st Aug 1993 print_results fixed
c   V1.0g .... 6th Sep. Records now set to LEAK by Alt. Prot.
c   V1.0j .... 9/11/93 WCPA2d.FOR Now loads .VPP files correctly
c	       on start up
c   V1.1  .... 9/2/94 Digidata 1200 support added
c   V1.1a .... 28/2/94 pCLAMP V6 conversiona added (but not tested)
c   V1.2  .... 2/4/94 Support N.I. ATMIO-16F added
c   V1.2a .... 20/4/94 ATMIO-16F A/D inputs in DIFF mode
c	       Bug in MERGE FILE fixed
c   V1.2b .... 21/4/94 WCP can now recover files which have NR=0 in header
c   V1.2c .... 9/5/94 Bug in wcpa2d.for fixed which caused crash when
c	       pulse duration was less than DAC updated interval
c   V1.2d ... 21/6/94 wcpana.for record number readout enlarged
c   V1.2e ... 2/9/94 Channel flipping bug fixed (labpc.for)
c   V1.3  ... 8/5/95 pClamp V6 conversion support added
c   V1.3a ... 3/7/95 Spurious triggering on multi-channel detection fixed
c		     LABDET.FOR
c   V1.3b ... 29/7/95 Change directory now works with all types of drive
c		      (change to gemflist.for, in gem.lib)
c   V1.4 ... 11/9/95 Scale factor added to voltage pulse
c   V1.4a ... 18/10/95 Bug in averaging routine fixed. Zero levels
c		       were being taken from rejected records
c   V1.4b ... 24/10/95 One sample offset error in cursor in WCPDSP.FOR fixed
c   V1.5  ... 16/1/96 Gigaseal test option added
c   V1.5a  .. 24/1/96 Loss of last leak subtract group fixed
c   V1.6  .. 10/4/96 Fixes for MSD added
c	      Log file option removed to save space
c	      Zero level now updates correctly when changed in
c	     analyse and curve fitting
c   V1.6a .. Synch. pulse now set to 5V (wcpa2d.for)
c   V1.6b .. wcpconv.for Error in exported pclamp sampling rate fixed
	logical new_menu,new_start
c  V1.6c 29/7/96 Voltage steps now increment more accurately     
c                Curve fitting cursors now update when record changed
c  V1.7 26/3/97 Supports CED micro1401
c               Improved event detector (WCPA2D.for)
c  V1.7a 3/4/97 sampling interval corrected for pCLAMP import
c  V1.7b 30/4/98 Holding potential now set correctly between sweeps

	CHARACTER KEY
	PARAMETER(nmenu=11,istatus_left=59,istatus_top=20)
	CHARACTER*20 MENU(Nmenu) /
     &	 'Record to Disc    F1',
     &	 'View Records      F2',
     &	 'Signal Averaging  F3',
     &	 'Leak Subtraction  F4',
     &	 'Waveform Analysis F5',
     &	 'Curve Fitting     F6',
     &	 '                  F7',
     &	 'Set Parameters    F8',
     &	 'Data Files        F9',
     &	 'Lab. Interface   F10',
     &	 'Exit Program       Q' /

	character*40 lab_card_name / ' ' /
	logical file_exists,quit,abandon
	character drive

	integer*2 i_start /1/, i_end /0/
	character*30 string
C
C
C	CODE
C	----
C
C -- Initialisation ----------------------------------------------
C

C	Prevent run-time MATHs error from aborting program
C	(see Appendix D Microsoft FORTRAN V4.1 Users Guide)
	CALL LCWRQQ(16#133E)
C
C	Open Gem graphics package
C
	CALL OPEN_WORKSTATION(ISCREEN,1)
	IF(ISCREEN.EQ.0) STOP
	CALL SET_MARGINS(2,1,80,25)

c	 open(unit=ilog_file,
c     &   file='\ses\wcp.log',
c     &   access='APPEND',
c     &   form='binary',
c     &   iostat=istat)

c	 call getdat( iyear, imon, iday )
c	 write( string,
c     &   '(i2,''-'',i2,''-'',i4,'' WCP V1.5b Started'')' )
c     &   iday,imon,iyear
c	 call write_to_log( string )

C	Read configuration file which supplies interface card no.,
c	default data directory and last data file name

	call read_initialisation_file( '\gemapps\gemsys\wcp.ini')
c
c	Try to open the last data file
c
	inquire(file=file_name,exist=file_exists)
	if( file_exists ) then
	    open(unit=idata_file,file=file_name,form='binary',
     &	    access='direct', recl=512,iostat=istat, err=100)
	else
100	    continue
	    call get_default_disc( drive )	! does not exist, create
	    default_path = drive//':\'          ! one on the current drive.
	    file_name = drive//':\unnamed.wcp'
	    open(unit=idata_file,file=file_name,form='binary',
     &	    access='direct', recl=512,iostat=istat)
	    if(istat.ne.0) call abort('Cannot create file '//file_name)
	end if

	if( file_exists ) then
	    call get_header( idata_file )
	else
	    n_records = 0
	    call save_header( idata_file )
	end if
	close(unit=idata_file,iostat=istat)

	quit = .false.
	do while( .not. quit )

	    call set_margins(2,1,79,25)
c
c	    Flush all disc buffers
c
	    call reset_disc

	    call erase_all
	    call title_box
c
c	    Present options menu and wait for user response
c
	    new_Menu = .true.
	    iop = Iwait_MENU_VERTICAL1(menu,'1234567890Q'
     &	    ,nmenu,istatus_left-1,1,new_menu,iop,' Options ',key)

	    select case( iop )

		case( 1 )
c
c		    Digitise signals
c
$if defined(demo)
$else
		    CALL DIGITISE_ANALOGUE_SIGNAL(i_start,i_end)
$endif
		case( 2 )
c
c		    View records on file
c
		    IF(n_records .GT. 0) THEN
			itype = 0
			call display_records(itype)
		    ENDIF

		case( 3 )
C
C		     View/Create averaged records
C
		    IF( n_records .GT. 0 ) THEN
			call record_averaging( abandon )
			if( .not. abandon ) then
			    itype = 2
			    call display_records(itype)
			end if
		    ENDIF

		case( 4 )
C
C		     View/Create leak-subtracted records
C
		    IF( n_records .GT. 0 ) THEN
			call leak_subtraction( abandon )
			if( .not. abandon ) then
			    itype = 2
			    call display_records(itype)
			end if
		    ENDIF

		case( 5 )
C
C		      Analyse Peak/Steady-state
C
		    if( n_records .gt. 0 ) then
			call waveform_analysis(i_start,i_end)
		    endif

		case( 6 )
C
C		    Analyse exponentials
C
		    if( n_records .gt. 0 ) then
			call fit_curves( new_start )
		    endif

		case( 7 )
c
c		    Display experiment log

c		     call read_log( istatus_left )

		case( 8 )
C
C		     Configure ADC collection parameters
C
		    open(unit=idata_file,file=file_name,form='binary',
     &		    access='direct', recl=512)
		    call setup
		    close( unit=idata_file )

		case( 9 )
C
C		     Files options
C
		    CALL FILES_OPTIONS

		case( 10 )
c
c		    Choose lab. interface
c
$if defined( dagan )
		    call select_dagan_interface(interface_card,
     &		    lab_card_name)
$else
		    call select_lab_interface(interface_card,
     &		    lab_card_name)
$endif

		 case( 11 )
C
C		     Stop program
C
		    CALL QUERY_BOX(2,2,
     &		    ' Exit Program! Are you sure (Y/N) ? ',key)
		    if( key .eq. 'Y' ) quit = .true.

	    end select
	end do

	call save_initialisation_file('\gemapps\gemsys\wcp.ini')
c	 close(unit=ilog_file)
	call close_workstation( iscreen )
	stop

	end

	subroutine title_box
$include:'wcpcom.for'

	PARAMETER(istatus_left=59,istatus_top=22)
	character*24 string
	character*18 lab_card_name / ' ' /
c
c	Display title
c
	call display_box(1,1,istatus_left-2,25)
	call move_cursor(5,5)
	call display_string(
     &  'WCP - Whole Cell Electrophysiology Program V1.7b')
	call move_cursor(5,6)
	call display_string(
     &	'(c) J. Dempster 1993-96, All Rights Reserved')

$if defined (dagan)
	call move_cursor(5,7)
	call display_string(
     &	'  (Licensed to DAGAN Corporation, 1993)')
$endif

$if defined (life)
	call move_cursor(5,7)
	call display_string(
     &	'  (Licensed to Life Science Resources, 1994)')
$endif

$if defined (demo)
	call move_cursor(5,8)
	call display_string(
     &	' (Demonstration version - recording disabled)')
$endif

	call move_cursor(2,24)
	call display_stringt( 'File '//file_name(1:46) )
	write( string, '('' ('',i5,'' records)'')' ) n_records
	call display_stringt( string )
c
c	Display program status
c
	call display_box(istatus_left-1,istatus_top-1,79,25)

	call move_cursor(istatus_left,istatus_top)
	call get_lab_interface_shortname(interface_card,lab_card_name)
	call display_string( lab_card_name )

	call move_cursor(istatus_left,istatus_top+1)
	write(string,'(''Disc space'',i7,''Kb'')' )
     &	int4(free_disc_space())
	call display_stringt( string )

	call move_cursor(istatus_left,istatus_top+2)
	write(string,'(''Free Memory  '',i4,''Kb'')' ) ifree_memory()
	call display_stringt( string )

	return
	end

	BLOCK DATA
C
$INCLUDE:'wcpcom.for'
C
	DATA NB_ANALYSIS,NB_DATA,N_CHANNELS /1,2,1/
	DATA N_records,N_RECORDS,N_POINTS /0,0,512/
	DATA N_RECORDS_REQUESTED /10/
	data y_scale / 6*1. /
	data gain / 6*1. /
	data iy_zero / 6*2048 /
	data y_units / 6*'mV' /
	DATA DT / 1.  /
	data filter_cutoff / 0. /
	data nzero / 10 /
	data izero_sample / 6*1 /
	DATA T_UNITS /'s'/
	DATA ADC_RANGE /5./
	DATA TRIGGER_LEVEL /10./
	data pre_trigger /20./
	data record_type / 'EVOK','MINI','FAIL','TEST','LEAK','ALL' /
	DATA INTERFACE_CARD /1/
	DATA default_path,FILE_NAME / ' ',' ' /
	data primary_name,alternate_name / ' ',' ' /
	data itrigger_mode /1/
	data idisplay_mode /1/
	DATA ID / ' ' /
        data ifont, ipoint_size / 9, 12 /
	data iline_thickness /1/
	data icolour / 2,3,4,5,6,7 /
	data iComPort /1/
c	data status1902 /66*' '/
	data TestPulseHeight / 10. /
	data TestPulseScaleFactor / 10. /
	data iVm_chan,iIm_chan / 1,2 /

	data var_name /
     &	'Record No.',
     &	'Clock Time',
     &	'Average',
     &	'Area',
     &	'Peak',
     &	'Rise time',
     &	'Rate of rise',
     &	'T.50%',
     &	'T.90%',
     &	'Variance',
     &	'Interval',
     &	'a',
     &	'b',
     &	'c',
     &	'd',
     &	'e',
     &	'f' /

	END

