	PROGRAM SPAN
$INCLUDE: 'SPACOM.FOR'

C    SPAN Spectral/Variance ananlysis program v3.1e
C    =============================================
C    (c) J. Dempster  1988,1990
C	Department of Physiology/Pharmacology,
C	University of Strathclyde.
C	This program is provided for academic research purposes
C	only and must not be sold or distributed further without
C	the permission of the author.
C -------------------------------------------------------------
C
c	V3.1 May 1991 ... LAB-PC interface added, new default file path.
c	V3.1b August 1991 ... Dagan labmaster problems fixed
c	V3.1c September 1991 ... ALLOCATE fault in SPAPLOT.FOR fixed
c	V3.1d Sep. 1991 ... Set Params in SPAA2D.for fixed
c	V3.1e Dec. 1992 ... Simulation now has true Lorentzian spectrum
c	v3.2 FEB 994 ... Support for Digidata 1200
c	v3.3 APR 1994 ... Support for N.I. ATMIO-16F
c	v3.3a ATMIO-16F in diff mode
c	V3.3b Channel flipping bug fixed (labpc.for) 2/9/94
c       V3.4 ... Support for CED micro1401 added

	logical new_menu
	integer*4 ifree4

	CHARACTER KEY,string*80,drive*1
	PARAMETER(nmenu=10,istatus_left=59,istatus_top=20)
	CHARACTER*20 MENU(Nmenu) /
     &	 'Record to disc    F1',
     &	 'View records      F2',
     &	 'Analysis mode     F3',
     &	 'Variance analysis F4',
     &	 'Spectral analysis F5',
     &	 'Plot overview     F6',
     &	 'Set parameters    F7',
     &	 'Data files        F8',
     &	 'Lab. interface    F9',
     &	 'Exit program       Q' /

	character*40 lab_card_name / ' ' /

C
C	CODE
C	----
C
C -- Initialisation ----------------------------------------------
C
C

C	Prevent run-time MATHs error from aborting program
C	(see Appendix D Microsoft FORTRAN V4.1 Users Guide)
	CALL LCWRQQ(16#133E)
C
C	Open Gem graphics package
C
	CALL OPEN_WORKSTATION(ISCREEN,1)
	IF(ISCREEN.EQ.0) STOP
	CALL SET_MARGINS(2,1,80,25)


C	Read configuration file

	CALL OPEN_FILE(IFILE,IERR,'SPAN.INI')
	IF(IERR .EQ. 0) THEN
		CALL GET_HEADER
		CALL CLOSE_FILE(IFILE,IERR)
		IFILE = 0
		n_records = 0
	ENDIF

	if( default_path .eq. ' ' ) then	! If a default file path
	    call get_default_disc( drive )	! does not exist, create
	    default_path = drive//':\lab\'      ! one on the current drive.
	end if

	ix = len_trim(default_path)		! Make sure the path
	if( default_path(ix:ix).ne.'\') then    ! ends with a '\'
	    ix = ix + 1
	    default_path(ix:ix) = '\'
	end if

	file_name = default_path			! Create the
	file_name(ix+1:len(file_name)) = 'unnamed.spa'	! default data file.

	call open_file( ifile, ierr, file_name )
	if( ierr .eq. 0 ) then
	    string = default_path
	    call get_header
	    default_path = string
	else
	    call create_file( ifile, ierr, file_name )
	    if( ierr .ne. 0 ) then
		default_path = drive//':\'
		file_name = default_path(1:len_trim(default_path))//
     &		'unnamed.spa'
		call create_file( ifile, ierr, file_name )
	    end if
	end if

c
c	Set display areas for high and low gain channels
c
	call get_text_attributes( iscreen, i,i,i,i,i,
     &	ichar_width,ichar_height)
	iheight = 4096*4
	iarea(1) = ichar_width
	iwidth = ((60*ichar_width)/512)*512
	iarea(3) = iarea(1) + iwidth

	iarea(2) = ichar_height
	iarea(4) = ndc_max - ichar_height
	iupper_area(1) = iarea(1)
	iupper_area(3) = iarea(3)
	ilower_area(1) = iarea(1)
	ilower_area(3) = iarea(3)
	iupper_area(4) = iarea(4)
	iupper_area(2) = iupper_area(4) - iheight
	ilower_area(2) = iarea(2)
	ilower_area(4) = ilower_area(2) + iheight


100	CONTINUE
c
c	Flush disc buffers
c
	call reset_disc

	dt = 1000./(2.*bandwidth)

	call erase_all

c
c	Display title
c
	call display_box(1,1,istatus_left-2,25)
	call move_cursor(5,5)
	call display_string(
     &  'SPAN - Spectral / Variance analysis program V3.4 ')
	call move_cursor(5,6)
	call display_string(
     &  ' (c) J. Dempster 1990-1997, All Rights Reserved')

$if defined (dagan)
	call move_cursor(5,7)
	call display_string(
     &	'  (Licensed to DAGAN Corporation, 1991)')
$endif
$if defined (life)
	call move_cursor(5,7)
	call display_string(
     &	'  (Licensed to Life Science Resources, 1994)')
$endif


$if defined (demo)
	call move_cursor(5,8)
	call display_string(
     &	' (Demonstration version - recording disabled)')
$endif
	call move_cursor(3,24)
	call get_lab_interface_name ( interface_card, lab_card_name )
	call display_string( lab_card_name )

c
c	Display program status
c
	call display_box(istatus_left-1,istatus_top-1,79,25)
	call set_margins(istatus_left,istatus_top,79,25)
	call move_cursor(istatus_left,istatus_top)

	call display_string( analysis_mode(ianalysis_mode)(1:20) )
	call new_line

	call display_string( file_name(1:20) )
	call new_line
	call display_string( file_name(21:30) )
	call new_line

	ifree4 = int4( free_disc_space() )
	write(string,'(''Disc space'',I7,''Kb'')' ) ifree4
	call display_string( string(1:20) )
	call new_line

	write(string,'(''Free Memory  '',i4,''Kb'')' ) ifree_memory()
	call display_string( string(1:20) )

	call set_margins(2,1,80,25)

C
c	Present options menu and wait for user response
c
	new_Menu = .true.
	iop = Iwait_MENU_VERTICAL1(menu,'123456789Q'
     &	,nmenu,istatus_left-1,1,new_menu,iop,' Options ',key)

	select case( iop )

	    case( 1 )
c
c		Record to disc
c
		IF(IFILE .NE. 0) CALL SAVE_HEADER
		call record_to_disc()

	    case( 2 )
c
c		View recording
c
		if( n_records .gt. 0 ) then
		    irecord = 1
		    call display_records( ' Display records ',irecord )
		endif

	    case( 3 )
c
c		Select recording mode
c
		new_menu = .true.
		inew_mode = iwait_menu_vertical1(analysis_mode,'12',
     &		2,3,5,new_menu,ianalysis_mode,' Analysis Mode ',key)
		if( inew_mode .gt. 0 ) ianalysis_mode = inew_mode

	    case( 4 )
c
c		Variance analysis
c
		if( n_records .gt. 0 ) then
		    call variance_analysis
		endif

	    case( 5 )
c
c		Spectral analysis
c
		if( n_records .gt. 0 ) then
		    call spectral_analysis
		endif

	    case( 6 )
c
c		Plot overview of whole file
c
		if( n_records .gt. 0 ) call plot_whole_file

	    case( 7 )
		call set_parameters

	    case( 8 )
		IF(IFILE .NE. 0) CALL SAVE_HEADER
		CALL FILES_OPTIONS

	    case( 9 )
c
c		Choose lab. interface
c
$if defined( dagan )
		call select_dagan_interface(interface_card,lab_card_name)
$else
		call select_lab_interface(interface_card,lab_card_name)
$endif

	    case( 10 )
C
C -- Stop program -------------------------------------------------
C
		CALL QUERY_BOX(2,23,
     &		' Exit Program! Are you sure (Y/N) ? ',KEY)
		IF( KEY .EQ. 'Y' ) THEN
		    IF( IFILE .NE. 0 ) THEN
			CALL SAVE_HEADER
			CALL CLOSE_FILE(IFILE,IERROR)
		    ENDIF
		    CALL CLOSE_WORKSTATION(ISCREEN)
		    STOP
		ENDIF

	    end select

	goto 100

	END
	


	REAL FUNCTION CONVERT_GAIN(GAIN,ICHAN)
$INCLUDE: 'SPACOM.FOR'
C
C	Derive BIT_VALUE from GAIN and vice_versa.
C	ADC_RANGE is the maximum input voltage range of the
C	ADCs on the laboratory interface.
C
	PARAMETER(ADC_MAX = 2.048)
C
	CONVERT_GAIN = ADC_RANGE/(ADC_MAX*GAIN)
	RETURN
	END

	BLOCK DATA
$INCLUDE: 'SPACOM.FOR'
C
	DATA MIN_SECTOR /20/
	DATA BANDWIDTH /1000./
	DATA Y_SCALE,IY_CAL /2.44,2.44,2048,2048/
	DATA NP_RECORD /512/
	DATA RECORDING_TIME /10000./
	data n_groups_requested / 100 /
	data trigger_level / 10. /
	DATA IFILE /0/
	DATA Y_UNITS,T_UNITS /'pA','ms'/
	DATA ADC_RANGE,INTERFACE_CARD /5.,1/
	DATA FILE_NAME,ID,default_path /' ',' ',' '/
	data ianalysis_mode / 1 /
	data analysis_mode /
     &	 'Stationary analysis  ',
     &	 'Ensemble   analysis' /
	data v_hold / -100. /
	data v_rev / 0. /
C
	END

	subroutine erase_display_area( title )
$include:'spacom.for'

	character*(*) title	! Display area title (IN)

	character string*20

	call  erase_box( 1, 1, 62, 25 )
	call  display_box( 1, 1, 62, 13 )
	call  display_box( 1, 13, 62, 25 )
	call move_cursor( 2,1 )
	call display_string( title )

	if( ianalysis_mode .eq. istationary ) then
	    call move_cursor( 2,1 )
	    call display_string( title )
	    call display_string( ' (stationary) ' )
	    call move_cursor( 41, 13 )
	    call display_string(' Ch.0 Fluctuation ')
	    call move_cursor( 41, 1 )
	    call display_string(' Ch.1 Mean current ')
	else
	    call move_cursor( 2,1 )
	    call display_string( title )
	    call display_string( ' (ensemble) ' )
	    call move_cursor( 36, 13 )
	    call display_string(' Residual fluctuation ')
	    call move_cursor( 36, 1 )
	    call display_string('    Ch.0 Mean current ')
	endif

	T_MIN = 0.
	T_MAX = FLOAT(NP_RECORD - 1)*DT

	call move_cursor( 2, 25 )
	write( string, '(f6.1,a2)') t_min,t_units
	call display_string( string(1:9) )

	call move_cursor( 52, 25 )
	write( string, '(f6.1,a2)') t_max,t_units
	call display_string( string(1:9) )

	call move_cursor(14,25)
	call display_string(' File '//file_name)

	return
	end

	SUBROUTINE GET_RECORD(IRECORD,IBUF)
$INCLUDE: 'SPACOM.FOR'
	INTEGER IBUF(1)
C
C	Get a variance/spectral record from file
C	========================================
C
	INTEGER*4 IRECORD_32,NBYTES_32,IP_32,IDATA_32
	INTEGER IP(2)
	EQUIVALENCE (IP,IP_32)
C
C	CODE
C
C	Calculate byte pointer (32 bit) into file for start
C	of record IRECORD
C
	NBYTES = NP_RECORD*2*N_CHANNELS
	IRECORD_32 = IRECORD-1
	NBYTES_32 = NBYTES
	IP_32 = IRECORD_32*NBYTES_32
C	
C	Create 32 bit pointer to start of data section in file
C	and add it to record pointer
C
	IDATA_32 = MIN_SECTOR-1
	IDATA_32 = IDATA_32*512
	IP_32 = IP_32 + IDATA_32
C
C	Move to and Read record
C
	CALL MOVE_FILE_POINTER(IFILE,IERR,IP(1),IP(2))
	CALL READ_BYTES(IFILE,IERR,IBUF,NBYTES)
	RETURN
	END
	


	SUBROUTINE PUT_RECORD(IRECORD,IBUF)
$INCLUDE: 'SPACOM.FOR'
	INTEGER IBUF(1)
C
C	Put a variance/spectral record on to file
C	=========================================
C
	INTEGER*4 IRECORD_32,NBYTES_32,IP_32,IDATA_32
	INTEGER IP(2)
	EQUIVALENCE (IP,IP_32)
C
C	CODE
C
C	Calculate byte pointer (32 bit) into file for start
C	of record IRECORD
C
	NBYTES = NP_RECORD*2*N_CHANNELS
	IRECORD_32 = IRECORD-1
	NBYTES_32 = NBYTES
	IP_32 = IRECORD_32*NBYTES_32
C	
C	Create 32 bit pointer to start of data section in file
C	and add it to record pointer
C
	IDATA_32 = MIN_SECTOR-1
	IDATA_32 = IDATA_32*512
	IP_32 = IP_32 + IDATA_32
C
C	Move to and Read record
C
	CALL MOVE_FILE_POINTER(IFILE,IERR,IP(1),IP(2))
	CALL WRITE_BYTES(IFILE,IERR,IBUF,NBYTES)
	RETURN
	END

