	SUBROUTINE simulations
C
C	-----------------------------------------------------------------
C	Generate test series of single channels records with added noise.
C	-----------------------------------------------------------------
C	V1.0 6-JAN-84
C	V2.0 10-APR-84 Generates test signal in bursts
C	V2.1 30-OCT-84 Ensures PATCH.1 is fixed as a file
c	V7.0 5/9/94 Gaussian filter now used and drift added
c	V7.1 12/1/96 Crash when Simulation cancelled now fixed
c       V7.2a 8/5/96 Crashed when ScaleIm = 0 fixed (possibly)
C
$INCLUDE: 'PATCOM.FOR'
C
	CHARACTER KEY
	PARAMETER(ICLOSED_LONG=0,ICLOSED_SHORT=1)

	parameter(nmenu=9,lwidth=46,bigpos=1E30,bigneg=-1E30)
	character*8 list(nmenu)
	character*40 err
	character*36 menu(nmenu) /
     &	'Simulation period (s)',
     &	'Unitary current amplitude (pA)',
     &	'Mean open time (ms)',
     &	'Mean closed time within burst (ms)',
     &	'Mean closed time between bursts (ms)',
     &	'No. of openings per burst',
     &	'Random noise (pA)',
     &	'Low pass filter cut-off (Hz) ',
     &	'Drift (pA/sec) ' /

	integer*2 nopen /20/
	integer*2 nclosed_short /5/
	integer*2 nclosed_long /200/
	integer*2 nclosures_per_burst /3/
	real*4 drift /0./
	character*50 new_file_name /' '/,temp_name /' '/,
     &	old_file_name /' '/
	integer*4 iStart,iEnd,ii

C
C	CODE
C	----
C
	nc = len_trim( default_path )
	if( file_name(1:nc) .ne. default_path(1:nc) ) then
	    new_file_name = default_path
	else
	    new_file_name = file_name
	end if

	call get_file_name(2,2,new_file_name,'.scd','NEW',
     &	' File name ',iflag)

	if( iflag .ge. 0 ) then

	   file_name = new_file_name
	   call open_data_file
	   if( iflag .eq. 0 ) n_records = 0
           if (ScaleIm .le. 0. ) ScaleIm = 0.03
	   CMAX = 2047.*ScaleIm
C
c	   Get simulation parameters from user
c
	    i = 1
	    write(list(i),'(F8.2)') RecordingTime/1000.
	    i = i + 1
	    write(list(i),'(F8.2)') cmax/2.
	    i = i + 1
	    write(list(i),'(f8.2)') float(nopen)*dt
	    i = i + 1
	    write(list(i),'(f8.2)') float(nclosed_short)*dt
	    i = i + 1
	    write(list(i),'(f8.2)') float(nclosed_long)*dt
	    i = i + 1
	    write(list(i),'(i3)') nclosures_per_burst
	    i = i + 1
	    write(list(i),'(f8.2)') cmax/10.
	    i = i + 1
	    write(list(i),'(f8.2)') filter_cutoff*1000.
	    i = i + 1
	    write(list(i),'(f8.2)') drift

	    err = ' '
100	    if( err .eq. ' ' ) err =
     &	    ' Create simulated single channel current '

	    call text_window(menu,list,nmenu,2,10,err)

	    i = 1
	    RecordingTime = check_limits(list,0.,bigpos,i,err)*1000.
	    i = i + 1
	    iunitSim = int( check_limits(list,bigneg,bigpos,i,err) /
     &	    ScaleIm )
	    if( err .ne. ' ' ) goto 100
	    i = i + 1
	    nopen = int( check_limits(list,0.,bigpos,i,err)/dt +.1)
	    if( err .ne. ' ' ) goto 100
	    i = i + 1
	    nclosed_short = int( check_limits(list,0.,bigpos,i,err)
     &	     /dt +.1)
	    if( err .ne. ' ' ) goto 100
	    i = i + 1
	    nclosed_long = int( check_limits(list,0.,bigpos,i,err)
     &	     /dt +.1)
	    if( err .ne. ' ' ) goto 100
	    i = i + 1
	    nclosures_per_burst = int( check_limits(list,0.,bigpos,i,
     &	     err) +.1)
	    if( err .ne. ' ' ) goto 100
	    i = i + 1
	    rnoise = check_limits(list,bigneg,bigpos,i,err)/ScaleIm
	    if( err .ne. ' ' ) goto 100
	    i = i + 1
	    filter_cutoff = check_limits(list,0.,250./dt,i,err)/1000.
	    if( err .ne. ' ' ) goto 100
	    i = i + 1
	    cmax = 200.*ScaleIm
	    drift = check_limits(list,-cmax,cmax,i,err)
	    if( err .ne. ' ' ) goto 100

	    ROPEN = 1./FLOAT(NOPEN)
	    RCLOSED_LONG = 1./FLOAT(NCLOSED_LONG)
	    RCLOSED_SHORT = 1./FLOAT(NCLOSED_SHORT)
	    IF(NCLOSURES_PER_BURST.GT.0) THEN
		RCLOSURES_PER_BURST = ROPEN/FLOAT(NCLOSURES_PER_BURST)
	    ELSE
		RCLOSURES_PER_BURST = 1.
	    ENDIF
	    ICLOSED_LEVEL = 0
	    IOPEN_LEVEL = IUNIT
	    ISTATE = ICLOSED_LONG
	    ILAST = -1
	    LEVEL = ICLOSED_LEVEL

C
C	    Generate bursts of single channel currents
C	    ------------------------------------------
C
	    iStart = n_records + 1
	    iEnd = iStart +
     &	    int4(RecordingTime/(dt*float(np_record))) - 1
	    key = 'S'
	    drift_offset = 0.
	    do ii = iStart,iEnd

		DO I=1,NP_record
		    call random(X)
		    IF((ISTATE.EQ.ICLOSED_LONG)
     &		    .AND. (X.LE.RCLOSED_LONG)) THEN
			ISTATE = IOPEN
			LEVEL = IOPEN_LEVEL
		    ELSEIF((ISTATE.EQ.ICLOSED_SHORT)
     &		    .AND. (X.LE.RCLOSED_SHORT)) THEN
			ISTATE = IOPEN
			LEVEL = IOPEN_LEVEL
		    ELSEIF((ISTATE.EQ.IOPEN).AND. (X.LE.ROPEN)) THEN
			IF(X.LE.RCLOSURES_PER_BURST) THEN
			    ISTATE = ICLOSED_LONG
			    LEVEL = ICLOSED_LEVEL
			ELSE
			    ISTATE = ICLOSED_SHORT
			    LEVEL = ICLOSED_LEVEL
			ENDIF
		    ENDIF
		    iBuf(I) = LEVEL
		end do
C
C		Add noise (if required)
C
		IF(RNOISE.NE.0.) THEN
		    DO I=1,NP_record
			iBuf(I) = iBuf(I)
     &			+ int(gaussian_random()*rnoise)
		    end do
		ENDIF
c
c		Add drift (if required)
c
		if( drift .ne. 0. ) then
		    drift_inc = (drift*0.001*dt)/ScaleIm
		    do i = 1,np_record
			drift_offset = drift_offset + drift_inc
			iBuf(i) = iBuf(i) + int(drift_offset)
			iBuf(i) = min(max(iBuf(i),-2047),2047)
		    end do
		end if

		izero = max_adc/2
		do i = 1,np_record
		    iBuf(i) = iBuf(i) + izero
		end do

		n_records = n_records + 1
		write( unit=1, rec=n_records+idata_offset )
     &		(iBuf(i),i=1,np_record)

		call display_progress( 2,21,
     &		' Record (ESC to abort)      ',ii,iEnd, key )
		if( key .eq. '$') goto 10

	    end do
10	    continue

	    if( filter_cutoff .ne. 0. ) then

		call create_path( temp_name, ' ', file_name, '.tmp' )

		old_file_name = file_name
		call gaussian_filter( temp_name, filter_cutoff )
		close(unit=idata_file)

		file_name = old_file_name
		call delete_file( ierr, file_name )
		call rename_file( ierr, temp_name, file_name )
		call open_data_file

	    end if
C
C	    Write header block to file and close
C
	    n_events = 0
	    nOverviewSlice = 0
	    VoltageGatedChannels = .false.
	    np_file = n_records * np_record
	    call save_header

	end if


	RETURN
	END

	real*4 function gaussian_random()
	integer*2 iset/0/
	real*8 v1,v2,r,fac
	integer*2 nn0 /0/
	integer*2 nn1 /0/
	integer*2 nnm1 /0/
	integer*2 nn2 /0/

c
10	continue
	if( iset .eq. 0 ) then
	    call random(RR)
1	    v1 = 2.*RR-1.
	    call random(RR)
	    v2 = 2.*RR-1.
	    r = v1**2 + v2**2
	    if( r .ge. 1.     ) goto 1
	    fac = sqrt( -2.*dlog( r )/r )
	    gset = v1*fac
	    gaussian_random = v2*fac
	    iset = 1
	else
	    gaussian_random = gset
	    iset = 0
	endif

	if( abs(Gaussian_random) .lt. 2e-4 ) goto 10
	ix = int( gaussian_random * 1000  )
	if( ix .eq. -1	) then
	    nnm1 = nnm1 + 1
	end if
	if( ix .eq. 0 ) then
	    nn0 = nn0 + 1
	end if
	if( ix .eq. 1 ) then
	    nn1 = nn1 + 1
	end if
	if( ix .eq. 2 ) then
	    nn2 = nn2 + 1
	end if
	return
	end

