	subroutine time_histograms
C
C	-------------------------------------------
C
c       15/6/98 ... Openings per burst option now works
c
$INCLUDE:'patCOM.FOR'
C
	CHARACTER*52 TITLE
	CHARACTER KEY
	CHARACTER*40 STRING
	character*20 xlabel,ylabel
	LOGICAL special,new_plot,plot_available,cursor_key,new_menu,quit

	parameter(max_bins=200)

	integer*2 nbins /100/
	real*4 bins(4,max_bins),xy(4*max_bins+4)
	equivalence (iwork, bins),
     &		    (iwork(8*max_bins+1),xy)

	parameter(nmenu=8,naxes_menu=6,istatus_left=59,istatus_top=15)
	parameter(bigneg=-1E30,bigpos=1E30)
	character*36 axes_menu(naxes_menu)
	character*12 list(naxes_menu)
	character*36 err
	character xlog,ylog
	character cEventsPerMsec /'N'/	   ! 'Y' = normalise Y axis
					   ! into events/msec for lin-lin
					   ! and log-log histograms
	character cRootY /'N'/		   ! 'Y' = Square root Y axis

	character*20 menu(nmenu) /
     &	' Create histogram F1',
     &	' Set axes range   F2',
     &	' Plot display     F3',
     &	' List histogram   F4',
     &	' Set A.R. start   F5',
     &	' Set A.R. end     F6',
     &	' Fit exponentials F7',
     &	' Exit            ESC'/

	logical Display(4)
	character*12 label(4)
	logical new_cursor_pos

C
C	CODE
C	----
C

	new_plot = .false.
	plot_available = .false.
	cursor_key = .false.
	new_menu = .true.
	new_cursor_pos = .false.

	xy(1) = 0.
	xy(2) = 0.

	iop = 1
	CALL ERASE_ALL

	quit = .false.
	do while( .not. quit )

	    if( new_menu ) then
		key = ' '
		iop = IMENU_VERTICAL1(menu,'1234567$',nmenu
     &		,istatus_left-1,1,new_menu,iop,' Options ',key)
		call erase_box(1,1,istatus_left-2,25)
		call display_box(1,1,istatus_left-2,25)
		CALL MOVE_CURSOR(2,1)
		CALL DISPLAY_STRING(
     &		' Dwell time distributions ')
	    endif
C
C	    Plot graph on screen
C
	    if( new_plot .and. plot_available ) then

		call erase_box(1,1,istatus_left-2,25)
		call display_box(1,1,istatus_left-2,25)

		call move_cursor(2,1)
		call display_stringt( title )

		call plot_histogram('S',bins,nbins
     &		,xlo,ylo,xhi,yhi,xtic,ytic,title,xlabel,ylabel
     &		,report,nrep,xy,xlog,ylog)
c
c		Plot analysis area cursors
c
		call cursor_line(iStart,bins,ylo,yhi,xlog,ylog,dotted)
		call cursor_line(iEnd,bins,ylo,yhi,xlog,ylog,dotted)

		call cursor_line(icursor,bins,ylo,yhi,xlog,ylog,solid)

c
c		Calculate no. of events within analysis region
c
		ARtotal = 0.
		ARavg = 0.
		do i = iStart,iEnd
		    r = bins(4,i)
		    if( cRootY .eq. 'Y' ) r = r*r
		    if( cEventsPerMsec .eq. 'Y' ) r = r *
     &		    (bins(3,i) - bins(1,i))
		    ARtotal = ARtotal + r
		    ARavg = ARavg + r*bins(2,i)
		end do
		ARavg = ARavg / max(ARtotal,1)

		new_plot = .false.
		plot_available = .true.

		call display_box(istatus_left-1,istatus_top-1,79,25)
		call move_cursor(istatus_left,istatus_top+7)
		call display_string('- Analysis Region -')

		call move_cursor(istatus_left,istatus_top+8)
		write(string,'(''Avg. time'',F8.3,''ms'')') ARavg
		call display_stringt(string)

		call move_cursor(istatus_left,istatus_top+9)
		write(string,'(''No. events '',F8.0)') ARtotal
		call display_stringt(string)

		new_cursor_pos = .true.
	    endif

	    if( new_cursor_pos ) then

		ix = istatus_left
		iy = istatus_top
		call move_cursor(ix,iy)
		call display_string('-     Cursor      -')

		bin_width = bins(3,icursor) - bins(1,icursor)

		iy = iy + 1
		call move_cursor(ix,iy)
		write(string,'(''Width  '',f9.2,''ms'')')
     &		bin_width
		call display_stringt(string)

		iy = iy + 1
		call move_cursor(ix,iy)
		write(string,'(''Bin    '',F9.2,''ms'')')
     &		bins(2,icursor)
		call display_stringt(string)

		iy = iy + 1
		call move_cursor(ix,iy)
		bin_events = bins(4,icursor)
		if( cEventsPerMsec .eq. 'Y' )
     &		bin_events = bin_events * bin_width
		if( cRootY .eq. 'Y' )
     &		bin_events = bin_events * bin_events
		write(string,'(''Events   '',i9)') int4(bin_events)
		call display_stringt(string)


		iy = iy + 1
		call move_cursor(ix,iy)
		EventsPerMsec = bins(4,icursor)
		if( cEventsPerMsec .eq. 'N' )
     &		EventsPerMsec = bin_events / bin_width
		write(string,'(''Events/ms'',F9.1)') EventsPerMsec
		call display_stringt(string)

		iy = iy + 1
		call move_cursor(ix,iy)
		write(string,'(''%        '',f9.3)')
     &		100.*bin_events/total
		call display_stringt(string)

		new_cursor_pos = .false.
	    end if


c
	    call wait_for_key( key, special )

	    if( (key.eq.'L').or.(key.eq.'R').or.(key.eq.'B')
     &	    .or.(key.eq.'F') ) then
		cursor_key = .true.
	    else
		cursor_key = .false.
	    endif
c
c	    Test for left/right cursor movement request
c
	    if( plot_available .and. cursor_key ) then
		call cursor_line(icursor,bins,ylo,yhi,xlog,ylog,solid)
		if( key .eq. 'L' ) then
c		    <- cursor left
		    icursor = max(icursor - 1,imin)
		elseif( key .eq. 'B' ) then
c		    Ctrl+<- cursor left (10 bins)
		    icursor = max(icursor - 10,imin)
		elseif( key .eq. 'R' ) then
c		    -> cursor right
		    icursor = min(icursor + 1,imax)
		elseif( key .eq. 'F' ) then
c		    Ctrl+-> cursor right (10 bins)
		    icursor = min(icursor +10,imax)
		endif
		call cursor_line(icursor,bins,ylo,yhi,xlog,ylog,solid)

c
c		Set "iop=0" to prevent selection of previous option
c
		iop = 0
		new_cursor_pos = .true.

	    endif

	    if( .not. cursor_key ) then
	       iop = IMENU_VERTICAL1(menu,'1234567$',
     &		nmenu,istatus_left-1,1
     &	       ,new_menu,iop,' Options ',key)
	       cursor_key = .false.
	    endif

	    select case( iop )

	    case( 1 )
C
C		Create state time histogram
c
		call create_time_histogram(bins,nbins,max_bins,
     &		title,plot_available,xlog,ylog,
     &		xlabel,ylabel,cEventsPerMsec,cRootY)

		if( plot_available ) then
c
c		    Find min/max range of axes
c
		    imin = 1
		    imax = nbins
		    iStart = imin
		    iEnd = nbins-1
		    xmin = bins(1,1)
		    xmax = bins(3,nbins)
		    ymin = 1E30
		    ysmall = 1E30
		    ymax = -1E30
		    do i = 1,nbins
			y = bins(4,i)
			if( y .gt. ymax ) ymax = y
			if( y .lt. ymin ) ymin = y
			if( y .gt. 0. .and. y.lt.ysmall ) ysmall = y
		    end do
		    nrep = 0
		    xy(1) = 0.
c
c		    Set display axes range
c
		    xlo = xmin
		    if( ylog .eq. 'Y' ) then	! Set lower limits
			ylo = ysmall		! to smallest positive
		    else			! value if log Y axis
			ylo = 0.		! otherwise set to zero
		    end if
		    xhi = xmax
		    yhi = ymax
		    if(xlo .eq. xhi ) xhi = xlo + 1.
		    if(ylo .eq. yhi ) yhi = ylo + 1.
		    xtic = (xhi-xlo)/5.
		    ytic = (yhi-ylo)/5.

c
c		    Calculate total no. of events
c
		    total = 0.
		    do i = 1,nbins
			r = bins(4,i)
			if( cRootY .eq. 'Y' ) r = r*r
			if( cEventsPerMsec .eq. 'Y' ) r = r *
     &			(bins(3,i) - bins(1,i))
			total = total + r
		    end do
		    icursor = 1
		    new_plot = .true.
		endif
		new_menu = .true.

	    case( 2 )
C
C --		Set plot axes range and tic spacing
C
		if( plot_available ) then

		    WRITE(axes_menu(1)
     &		    ,'('' X axis range: minimum ('',G10.4,'')'')') XMIN
		    WRITE(axes_menu(2)
     &		    ,'('' X axis range: maximum ('',G10.4,'')'')') XMAX
		    axes_menu(3) = ' X axis tic spacing '
		    WRITE(axes_menu(4)
     &		    ,'('' Y axis range: minimum ('',G10.4,'')'')') YMIN
		    WRITE(axes_menu(5)
     &		    ,'('' Y axis range: maximum ('',G10.4,'')'')') YMAX
		    axes_menu(6) = ' Y axis tic spacing '

		    write(list(1),'(F12.3)') xlo
		    write(list(2),'(F12.3)') xhi
		    write(list(3),'(F12.3)') xtic
		    write(list(4),'(F12.3)') ylo
		    write(list(5),'(F12.3)') yhi
		    write(list(6),'(F12.3)') ytic

		    err = ' '
2100		    if( err .eq. ' ' ) err = ' Set axes range '

		    CALL text_window(axes_menu,list,naxes_menu,2,2,err)

		    xlo  = check_limits(list,bigneg,bigpos,1,err)
		    if( err .ne. ' ' ) goto 2100
		    xhi  = check_limits(list,bigneg,bigpos,2,err)
		    if( err .ne. ' ' ) goto 2100
		    xtic = check_limits(list,0.,bigpos,3,err)
		    if( err .ne. ' ' ) goto 2100
		    ylo  = check_limits(list,bigneg,bigpos,4,err)
		    if( err .ne. ' ' ) goto 2100
		    yhi  = check_limits(list,bigneg,bigpos,5,err)
		    if( err .ne. ' ' ) goto 2100
		    ytic = check_limits(list,0.,bigpos,6,err)
		    if( err .ne. ' ' ) goto 2100

		    imin = 1
		    imax = nbins
		    do i = 1,nbins
			if( xlo .gt. bins(2,i) ) imin = i
			if( xhi .ge. bins(2,i) ) imax = i
		    end do
		    iStart = min(max(iStart,imin),imax)
		    iEnd = min(max(iEnd,imin),imax)
		    iEnd = min(iEnd,nbins-1)
		    icursor = min(max(icursor,imin),imax)
		    new_plot = .true.
		    new_menu = .true.
		endif

	    case( 3 )
C
C --		Plot graph
C
		if( plot_available ) then
		    call plot_histogram('H',bins,nbins
     &		    ,xlo,ylo,xhi,yhi,xtic,ytic,title,xlabel,
     &		    ylabel,report,nrep,xy,xlog,ylog)
		    new_plot = .true.
		    new_menu = .true.
		endif

	    case( 4 )
C
C --		Display table of current graph values
C
		if( plot_available ) then
		    Display(1) = .false.
		    Display(2) = .true.
		    label(2) = xlabel
		    Display(3) = .false.
		    Display(4) = .true.
		    label(4) = ylabel
		    call ListData( bins(1,imin), imax-imin+1,
     &		    4, Display, Label, 2,2)
		    new_plot = .true.
		    new_menu = .true.
		endif

	    case( 5 )
c
c --		Set start cursor
c
		iStart = icursor
		if( iStart .gt. iEnd ) then
		    iTemp = iStart
		    iStart = iEnd
		    iEnd = iTemp
		end if
		new_plot = .true.

	    case( 6 )
c
c --		Set end cursor
c
		iEnd = icursor
		iEnd = min(iEnd,nbins-1)
		if( iStart .gt. iEnd ) then
		    iTemp = iStart
		    iStart = iEnd
		    iEnd = iTemp
		end if
		new_plot = .true.

	    case( 7 )
C
C --		Fit exponentials
c
		if( plot_available ) then
		    call fit_exponentials(bins,nbins,iStart,iEnd,
     &		    total,cEventsPerMsec,cRootY,xy)
		    new_plot = .true.
		    new_menu = .true.
		endif

	    case( 8 )

		quit = .true.
		new_plot = .true.
	    end select
	end do

	return
	end

	subroutine create_time_histogram(bins,nbins,max_bins,
     &	title,plot_available,xlog,ylog,xlabel,ylabel,
     &	cEventsPerMsec,cRootY)
$include:'patcom.for'
c
c	Calculate channel state duration histograms
c	-------------------------------------------
c
      real*4 bins(4,nbins)               ! (Out) Histogram results
      integer*2 nbins                    ! (In) No. of bins
      integer*2 max_bins		 ! (In) Max. No. of bins allowed
      character*(*) title
      logical plot_available
      character xlog			 ! (In) 'Y' = logarithmic x axis
      character ylog			 ! (In) 'Y' = logarithmic y axis
      character*(*) xlabel
      character*(*) ylabel
      character cEventsPerMsec		 ! (Out) 'Y' = normalise Y axis
					 ! into events/msec for lin-lin
					 ! and log-log histograms
      character cRootY			 ! (Out) 'Y' = Square root Y axis
 

	character key
	logical new_menu

	parameter(nmenu=11)
	character*40 menu(nmenu) /

     &	' Open times                        F1',
     &	' Closed times                      F2',
     &	' Sub-state times                   F3',
     &	' Latency times                     F4',
     &	' Burst length                      F5',
     &	' Single open times                 F6',
     &	' Open times within burst           F7',
     &	' Openings per burst                F8',
     &	' Import from time list file        F9',
     &	' Import from histogram file       F10',
     &	' Cancel                           ESC' /

	parameter(naxes=3)
	character*16 axes_types(naxes) /
     &	' Linear      F1',
     &	' Log-Lin     F2',
     &	' Log-Log     F3'/

	parameter( iLinLin=1, iLogLin=2, iLogLog=3 )

	integer*4 iEventStart,iEventEnd
	real*4 bins_per_decade /16./

c
c ---- code
c
c
c	Display menu of histogram types
c
	iy = 2
	itype = Iwait_MENU_VERTICAL1(menu,'1234567890$',
     &	nmenu,3,iy,new_menu,itype,' Select Histogram Type ',key)
	plot_available = .true.
	call move_cursor(4,3+itype)

	select case ( itype )	    ! Set burst flag for histograms
	case (5:8)		    ! which analyse bursts of openings
	    nsetup = 1		    ! Used by _setup routines do
	case ( 9 )
	    nsetup = -2
	case default		    ! determine whether "End of Burst.."
	    nsetup = 0		    ! item is presented to user
	end select

	if( itype .lt. 9 .and. n_events.le.0 ) then
	    plot_available = .false.
	    call Report_Error(2,24,' No dwell times to plot')
	    return
	end if

	if( itype .lt. 10 ) then

	    iy = iy + itype + 1
            if( itype .ne. 8 ) then
		iHistType = Iwait_MENU_VERTICAL1(axes_types,'123',
     &		naxes,4,iy,new_menu,iHistType,' Axes type ',key)
	    else
c
c		Only linear histogram allowed for openings per burst
c
		iHistType = iLinLin
		bin_width = 1.
	    end if

	    select case( iHistType )
	    case (iLinLin)
c
c		Set up linear histogram
c
		xlog = 'N'
		ylog = 'N'
		call linear_setup(nbins,iEventStart,iEventEnd
     &		,bin_width,t_critical,max_bins,cEventsPerMsec,
     &		5,iy+iHistType+1,nsetup)
		cRootY = 'N'

	    case (iLogLin)
c
c		Set up for Sigworth-Sine log(x) histogram
c
		xlog = 'Y'
		ylog = 'N'
		call loglin_setup(nbins,iEventStart,iEventEnd
     &		,bins_per_decade,t_critical,max_bins,cRootY,
     &		5,iy+iHistType+1,nsetup)
		cEventsPerMsec = 'N'
	    case (iLogLog)
c
c		Set up for Magleby log(x)-log(y) histogram
c
		xlog = 'Y'
		ylog = 'Y'
		call loglog_setup(nbins,iEventStart,iEventEnd
     &		,bins_per_decade,t_critical,max_bins,
     &		5,iy+iHistType+1,nsetup)
		cRootY = 'N'
		cEventsPerMsec = 'Y'

	    end select
	end if

c
c	Do selected option


	select case( itype )
        case( 1:8 )
	   call dwell_time_histogram(bins,nbins,bin_width,
     &	   iEventStart,iEventEnd,itype,bins_per_decade,
     &	   t_critical,iHistType,cEventsPerMsec,cRootY,
     &	   xlabel,ylabel)

	   title = menu(itype)(1:34)
           if( iType .eq. 8 ) then xLabel = ' ' 

	case( 9 )
c
c	   Times list file
c
	   call dwell_time_list_file(bins,nbins,bin_width,
     &	   bins_per_decade,iHistType,cEventsPerMsec,cRootY,
     &	   xlabel,ylabel,title,total)
	   if( total .eq. 0. ) plot_available = .false.

	case( 10 )
c
c	    Histogram file
c
	    call histogram_from_file(bins,nbins,max_bins,
     &	    total,iHistType,xlog,ylog)
	    title = 'Dwell time histogram from file '
	    xlabel = 'ms'
	    ylabel = 'Events'
	    cEventsPerMsec = 'N'
	    cRootY = 'N'
	    if( nbins .le. 0 ) plot_available = .false.

	case( 11 )
c
c	    Cancel operation
c
	     plot_available = .false.

	end select


	return
	end


	SUBROUTINE linear_setup(nbins,iEventStart,iEventEnd
     &	,bin_width,tcrit,max_bins,cEventsPerMsec,ileft,itop,nsetup)
$INCLUDE: 'PATCOM.FOR'
C
C	Get No. of bins, histogram range resolution limit from user
C
	integer*2 nbins
	integer*4 iEventStart,iEventEnd
	real*4 bin_width
	real*4 tcrit
	integer*2 max_bins
	character cEventsPerMsec

	parameter(nmenu=6,small=1E-30,big=1E30)
	character*36 menu(nmenu) /
     &	' No. of bins (2 -        )',
     &	' Bin width ( >=           ms )',
     &	' Events/ms bins (Y/N)',
     &	' Start at event (1 -        )',
     &	' End at event ',
     &	' End-of-burst closed time (ms)' /

	character*10 list(nmenu)
	character*40 string
	logical initialise / .true. /
c
c	code
c

	if( initialise ) then
	    iEventStart = 1
	    iEventEnd = n_events
	    initialise = .false.
	end if

	i = 1
	ix = index(menu(i),'-') + 2
	write(menu(i)(ix:ix+4),'(i4)') max_bins
	write(list(i),'(I3)') nbins

	i = 1 + i
	ix = index(menu(i),'=') + 2
	write(menu(i)(ix:ix+6),'(f6.2)') dt
	write(list(i),'(f6.2)') max(bin_width,dt)

	i = 1 + i
	list(i) = cEventsPerMsec

	i = 1 + i
	ix = index(menu(i),'-') + 2
	write(menu(i)(ix:ix+6),'(i7)') n_events
	write(list(i),'(i7)') max(min(iEventStart,n_events),1)

	i = 1 + i
	write(list(i),'(i7)') max(min(iEventEnd,n_events),1)

	i = 1 + i
	write(list(i),'(F9.2)') tcrit

	string = ' '
	nList = nmenu + nsetup - 1
100	if( string .eq. ' ' ) string = ' Setup Histogram '
	call text_window(menu,list,nList,ileft,itop,string)

	i = 1
	if( i .gt. nList ) goto 101
	nbins = int(check_limits(list,1.,float(max_bins),i,string))
	if( string .ne. ' ' ) goto 100

	i = i + 1
	if( i .gt. nList ) goto 101
	bin_width = check_limits(list,dt,big,i,string)
	bin_width = float(int(bin_width/dt + .1))*dt
	if( string .ne. ' ' ) goto 100

	i = i + 1
	if( i .gt. nList ) goto 101
	cEventsPerMsec = check_letter(list,'YN',i,string)
	if( string .ne. ' ' ) goto 100

	i = i + 1
	if( i .gt. nList ) goto 101
	iEventStart = int4(check_limits(list,1.,float(n_events),i,string))
	if( string .ne. ' ' ) goto 100

	i = i + 1
	if( i .gt. nList ) goto 101
	iEventEnd = int4(check_limits(list
     &	,float(iEventStart),float(n_events),i,string))
	if( string .ne. ' ' ) goto 100

	i = i + 1
	if( i .gt. nList ) goto 101
	tcrit = check_limits(list,0.,big,i,string)
	if( string .ne. ' ' ) goto 100

101	continue

	RETURN
	END

	subroutine loglin_setup(nbins,iEventStart,iEventEnd,
     &	bins_per_decade,tcrit,max_bins,cRootY,ileft,itop,nsetup)
$INCLUDE: 'PATCOM.FOR'
C
C	Get No. of bins, histogram range resolution limit from user
C
	integer*2 nbins
	integer*4 iEventStart,iEventEnd
	character cRootY

	parameter(nmenu=6,small=1E-30,big=1E30)
	character*36 menu(nmenu) /
     &	' No. of bins (2 -        )',
     &	' Bins per decade (2 - 100)',
     &	' Square root Y axis (Y/N)',
     &	' Start at event (1 -        )',
     &	' End at event ',
     &	' End-of-burst closed time (ms)' /

	character*10 list(nmenu)
	character*40 string
	logical initialise / .true. /
c
c	code
c
	if( initialise ) then
	    iEventStart = 1
	    iEventEnd = n_events
	    xmax = 10.
	    initialise = .false.
	end if

	i = 1
	ix = index(menu(i),'-') + 2
	write(menu(i)(ix:ix+4),'(i4)') max_bins
	write(list(i),'(I3)') nbins

	i = 1 + i
	write(list(i),'(f6.2)') bins_per_decade

	i = 1 + i
	list(i) = cRootY

	i = 1 + i
	ix = index(menu(i),'-') + 2
	write(menu(i)(ix:ix+6),'(i6)') n_events
	write(list(i),'(i6)') max(min(iEventStart,n_events),1)

	i = 1 + i
	write(list(i),'(i6)') max(min(iEventEnd,n_events),1)

	i = 1 + i
	write(list(i),'(F9.2)') tcrit

	string = ' '
	nList = nmenu-1+nsetup
100	if( string .eq. ' ' ) string = ' Setup Histogram '
	call text_window(menu,list,nList,ileft,itop,string)

	i = 1
	if( i .gt. nList ) goto 101
	nbins = int(check_limits(list,1.,float(max_bins),i,string))
	if( string .ne. ' ' ) goto 100

	i = i + 1
	if( i .gt. nList ) goto 101
	bins_per_decade = check_limits(list,2.,100.,i,string)
	if( string .ne. ' ' ) goto 100

	i = i + 1
	if( i .gt. nList ) goto 101
	cRootY = check_letter(list,'YN',i,string)
	if( string .ne. ' ' ) goto 100

	i = i + 1
	if( i .gt. nList ) goto 101
	iEventStart = int4(check_limits(list,1.,float(n_events),i,string))
	if( string .ne. ' ' ) goto 100

	i = i + 1
	if( i .gt. nList ) goto 101
	iEventEnd = int4(check_limits(list
     &	,float(iEventStart),float(n_events),i,string))
	if( string .ne. ' ' ) goto 100

	i = i + 1
	if( i .gt. nList ) goto 101
	tcrit = check_limits(list,0.,big,i,string)
	if( string .ne. ' ' ) goto 100
101	continue

	RETURN
	END

	subroutine loglog_setup(nbins,iEventStart,iEventEnd,
     &	bins_per_decade,tcrit,max_bins,ileft,itop,nsetup)
$INCLUDE: 'PATCOM.FOR'
C
C	Get No. of bins, histogram range resolution limit from user
C
	integer*2 nbins
	integer*4 iEventStart,iEventEnd

	parameter(nmenu=5,small=1E-30,big=1E30)
	character*36 menu(nmenu) /
     &	' No. of bins (2 -        )',
     &	' Bins per decade (2 - 100)',
     &	' Start at event (1 -        )',
     &	' End at event ',
     &	' End-of-burst closed time (ms)' /

	character*10 list(nmenu)
	character*40 string
	logical initialise / .true. /
c
c	code
c
	if( initialise ) then
	    iEventStart = 1
	    iEventEnd = n_events
	    xmax = 10.
	    initialise = .false.
	end if

	i = 1
	ix = index(menu(i),'-') + 2
	write(menu(i)(ix:ix+4),'(i4)') max_bins
	write(list(i),'(I3)') nbins

	i = 1 + i
	write(list(i),'(f6.2)') bins_per_decade

	i = 1 + i
	ix = index(menu(i),'-') + 2
	write(menu(i)(ix:ix+6),'(i6)') n_events
	write(list(i),'(i6)') max(min(iEventStart,n_events),1)

	i = 1 + i
	write(list(i),'(i6)') max(min(iEventEnd,n_events),1)

	i = 1 + i
	write(list(i),'(F9.2)') tcrit

	string = ' '
	nList = nmenu-1+nsetup
100	if( string .eq. ' ' ) string = ' Set Histogram bins and range '
	call text_window(menu,list,nList,ileft,itop,string)

	i = 1
	if( i .gt. nList ) goto 101
	nbins = int(check_limits(list,1.,float(max_bins),i,string))
	if( string .ne. ' ' ) goto 100

	i = i + 1
	if( i .gt. nList ) goto 101
	bins_per_decade = check_limits(list,2.,100.,i,string)
	if( string .ne. ' ' ) goto 100

	i = i + 1
	if( i .gt. nList ) goto 101
	iEventStart = int4(check_limits(list,1.,float(n_events),i,string))
	if( string .ne. ' ' ) goto 100

	i = i + 1
	if( i .gt. nList ) goto 101
	iEventEnd = int4(check_limits(list
     &	,float(iEventStart),float(n_events),i,string))
	if( string .ne. ' ' ) goto 100

	i = i + 1
	if( i .gt. nList ) goto 101
	tcrit = check_limits(list,0.,big,i,string)
	if( string .ne. ' ' ) goto 100
101	continue

	RETURN
	END


      subroutine dwell_time_histogram(bins,nbins,bin_width,iStart,iEnd,
     & imode,bins_per_decade,end_of_burst,
     & iHistType,cEventsPerMsec,cRootY,xlabel,ylabel)
c
c	Calculate dwell time histograms
c
$include:'patcom.for'
      real*4 bins(4,nbins)               ! (Out) Histogram results
      integer*2 nbins                    ! (In) No. of bins
      real*4 bin_width			 ! (In) Bin width (linear) (ms)
      integer*4 iStart,iEnd		 ! (In) Range of events in histogram
      integer*2 imode			 ! (In) Operating mode 1-7
      real*4 bins_per_decade		 ! (In) No. of bins per decade
      real*4 end_of_burst		 ! (In) End of burst closed time limit (ms)
      integer*2 iHistType		 ! (In) Type of histogram
					 ! 1 = linear X linear Y
					 ! 2 = Log X linear Y (Sigworth-Sine)
					 ! 3 = Log X Log Y (magleby)
      character cEventsPerMsec		 ! (In) 'Y' = normalise Y axis
					 ! into events/msec for lin-lin
					 ! and log-log histograms
      character cRootY			 ! (In) 'Y' = Square root Y axis
					 ! for log-lin histogram
      character*(*) xlabel		 ! (Out) X axis label
      character*(*) ylabel		 ! (Out) Y axis label
      record /event_record/ event

	logical add_to_histogram,subtract_from_histogram,bad
	integer*4 ievent
	parameter( iLinLin=1, iLogLin=2, iLogLog=3 )

	antilog10(x) = exp(2.302585*x)

c
c	code
c


      call tell_user_box(5,18,' WAIT ... Creating Histogram ')
 
      if( iHistType .eq. iLinLin ) then
          if( imode .eq. 8 ) then
	       bin_width = 1.	    ! Openings per bin histogram
	       x = 0.5		    ! must have a width of 1.
	  else
	      x = 0.
	  end if
					      ! Linear histogram
          do ibin = 1,nbins                   ! fixed bin widths
              bins(1,ibin) = x
	      bins(2,ibin) = x + (bin_width)/2.
	      bins(3,ibin) = x + bin_width
	      bins(4,ibin) = 0.
	      x = x + bin_width
          end do
      else
          tmin = log10(dt)                          ! Logarithmic histogram.
          bw = 1./bins_per_decade                   ! Bin width increasing
          do ibin = 1,nbins                         ! logarithmically.
	      bins(3,ibin) = float(ibin)*bw + tmin  ! (Sigworth & Sine)
              bins(1,ibin) = bins(3,ibin) - bw
              bins(2,ibin) = bins(3,ibin) - bw/2.
	      bins(4,ibin) = 0.
	      bins(3,ibin) = antilog10(bins(3,ibin))
	      bins(1,ibin) = antilog10(bins(1,ibin))
	      bins(2,ibin) = antilog10(bins(2,ibin))
          end do
      end if

      n_count = 0
      add_to_histogram = .false.
      subtract_from_histogram = .false.
      burst = 0.
      bad = .false.

      do ievent = iStart,iEnd

	  read( unit=ievent_file, rec=ievent ) event	  ! Get event record

	  select case( imode )
	  case( 1 )
	    if( event.level .eq. iopen ) then	! Open times
		time = event.dwell_time
		add_to_histogram = .true.
	    end if

	  case( 2 )
	    if( event.level .eq. iclose ) then ! Closed times
		time = event.dwell_time
		add_to_histogram = .true.
	    end if

	  case( 3 )
	    if( event.level .eq. isub ) then	! Sub-states
		time = event.dwell_time
		add_to_histogram = .true.
	    end if

	  case( 4 )
	    if( event.level .eq. ilatency ) then    ! Latencies
		time = event.dwell_time
		add_to_histogram = .true.
	    end if

	  case( 5 )
c
c	    Burst duration (bursts defined by series of openings
c	    separated by closures shorter than <end_of_burst> )
c
	    if( event.level .ne. iclose ) then
		burst = burst + event.dwell_time
		if( event.level .eq. irejected ) bad = .true.
	    elseif( event.dwell_time .gt. end_of_burst ) then
		add_to_histogram = .true.
		time = burst
		burst = 0.
	    end if

	 case( 6 )
c
c	    Single openings
c
	    if( event.level .ne. iclose ) then
		time = event.dwell_time
		nopen = nopen + 1
	    elseif( event.dwell_time .gt. end_of_burst ) then
		if( nopen .gt. 1 ) add_to_histogram = .true.
		nopen = 0
	    end if

	 case( 7 )
c
c	    Open/sub times within a burst of several openings
c
	    if( event.level .ne. iclose ) then
		time = event.dwell_time
		nopen = nopen + 1
		add_to_histogram = .true.
	    elseif( event.dwell_time .gt. end_of_burst ) then
		if( nopen .eq. 1 ) subtract_from_histogram = .true.
		nopen = 0
	    end if

	 case( 8 )
c
c	    Openings per burst
c
	    if( event.level .ne. iclose ) then
		nopen = nopen + 1
	    elseif( event.dwell_time .gt. end_of_burst ) then
		time = float(nopen)
		add_to_histogram = .true.
		nopen = 0
	    end if

	 end select

	  if( add_to_histogram .and. .not. bad ) then
              n_count = n_count + 1
	      if( iHistType .ne. iLinLin ) then
		  if( time .gt. 0. ) then
		     ix = 1 + int(bins_per_decade*(log10(time)-tmin))
		  else
		     call move_cursor(1,1)
		    call display_flt(time)
		    call display_int(ievent)
		end if
              else
		  ix = int(time/bin_width + 0.1) + 1
              end if
	      ix = max(min(ix,nbins),1)
	      bins(4,ix) = bins(4,ix) + 1.

	      bad = .false.
	      add_to_histogram = .false.
	  elseif( subtract_from_histogram ) then
	      n_count = n_count - 1
	      if( iHistType .ne. iLinLin ) then
		  if( time .gt. 0. ) then
		    ix = 1 + int( bins_per_decade*(log10(time)-tmin))
		  end if
              else
		  ix = int(time/bin_width + 0.1) + 1
              end if
	      ix = max(min(ix,nbins),1)
	      bins(4,ix) = bins(4,ix) - 1.

	      subtract_from_histogram = .false.

          end if
      end do


c
c     Normalise bins contents by dividing by bin width
c     for either log-log histogram or if requested for lin-lin.
c
      ylabel = 'Events'
      if( iHistType.eq.iLogLog .or. cEventsPerMsec.eq.'Y') then
	  do i = 1,nbins
	      bins(4,i) = bins(4,i) / (bins(3,i)-bins(1,i))
	  end do
	  ylabel = 'Events/ms'
      end if
c
c     If log(Y) - lin(X) histogram and square root Y axis selected
c
      if( iHistType .eq. iLogLin .and. cRootY .eq. 'Y' ) then
	  do i = 1,nbins
	      bins(4,i) = SafeSqrt( bins(4,i) )
          end do
	  ylabel = 'Sqrt(Events)'
      end if

        if( imode .eq. 8 ) then
	    xlabel = 'Openings'
	else
	    xlabel = 'ms'
	end if

      return
      end

	real*4 function SafeSqrt( x )
	if( x .gt. 0. ) then
	    SafeSqrt = sqrt(x)
	else
	    SafeSqrt = 0.
	end if
	return
	end

      subroutine dwell_time_list_file(bins,nbins,bin_width,
     & bins_per_decade,iHistType,cEventsPerMsec,cRootY,
     & xlabel,ylabel,title,total)

$INCLUDE: 'PATCOM.FOR'
C
C	Calc. dwell time histogram from an ASCII list file
c	containing dwell times
c
      real*4 bins(4,nbins)               ! (Out) Histogram results
      integer*2 nbins                    ! (In) No. of bins
      real*4 bin_width			 ! (In) Bin width (linear) (ms)
      real*4 bins_per_decade		 ! (In) No. of bins per decade
      integer*2 iHistType		 ! (In) Type of histogram
					 ! 1 = linear X linear Y
					 ! 2 = Log X linear Y (Sigworth-Sine)
					 ! 3 = Log X Log Y (magleby)
      character cEventsPerMsec		 ! (In) 'Y' = normalise Y axis
					 ! into events/msec for lin-lin
					 ! and log-log histograms
      character cRootY			 ! (In) 'Y' = Square root Y axis
					 ! for log-lin histogram
      character*(*) xlabel		 ! (Out) X axis label
      character*(*) ylabel		 ! (Out) Y axis label
      character*(*) title		 ! (Out) Title
      real*4 total			 ! (Out) Total number of events

	LOGICAL end_of_file

	parameter(lwidth=50)

	parameter( iLinLin=1, iLogLin=2, iLogLog=3 )

	character*40 list_file_name / ' ' /
	real*4 row(10)

	antilog10(x) = exp(2.302585*x)
C
C	CODE
C
	if( list_file_name .eq. ' ' ) list_file_name = default_path
	call get_file_name(5,16,list_file_name,' ','OLD',
     &	' File name ',iflag)

	total = 0.
	if( iflag .ne. -1 ) then
	    open(unit=itemp_file,
     &	    file=list_file_name,
     &	    form='binary',
     &	    iostat=istat,
     &	    recl=1)

	    if( istat .ne. 0 ) then
		call Report_Error( 2,24,' Cannot open this file ')
		iflag = -1
	    end if
	end if

	if( iflag .ne. -1 ) then

	    call tell_user_box(5,20,' WAIT ... Creating Histogram ')

	    if( iHistType .eq. iLinLin ) then
		x = 0.				    ! Linear histogram
		do ibin = 1,nbins		    ! fixed bin widths
		    bins(1,ibin) = x
		    bins(2,ibin) = x + (bin_width)/2.
		    bins(3,ibin) = x + bin_width
		    bins(4,ibin) = 0.
		    x = x + bin_width
		end do
	    else
		tmin = log10(dt)			  ! Logarithmic histogram.
		bw = 1./bins_per_decade 		  ! Bin width increasing
		do ibin = 1,nbins			  ! logarithmically.
		    bins(3,ibin) = float(ibin)*bw + tmin  ! (Sigworth & Sine)
		    bins(1,ibin) = bins(3,ibin) - bw
		    bins(2,ibin) = bins(3,ibin) - bw/2.
		    bins(4,ibin) = 0.
		    bins(3,ibin) = antilog10(bins(3,ibin))
		    bins(1,ibin) = antilog10(bins(1,ibin))
		    bins(2,ibin) = antilog10(bins(2,ibin))
		end do
	    end if

	    end_of_file = .false.
	    do while( .not. end_of_file )

		call extract_row(itemp_file,row,nc,end_of_file)
		if( .not. end_of_file .and. row(1).gt.0. ) then
c
c		    Add to appropriate bin
c
		    if( iHistType .ne. iLinLin ) then
			ix = 1 + int(
     &			bins_per_decade*(log10(row(1))-tmin))
		    else
			ix = int(row(1)/bin_width + 0.1) + 1
		    end if

		    ix = max(min(ix,nbins),1)
		    bins(4,ix) = bins(4,ix) + 1.
		endif
	    end do

	    total = 0.
	    do i = 1,nbins
		total = total + bins(4,i)
	    end do

	    if( total .eq. 0. ) then
		call Report_Error(2,24,'WARNING! No data in file')
	    end if
c
c	    Normalise bins contents by dividing by bin width
c	    for either log-log histogram or if requested for lin-lin.
c
	    ylabel = 'Events'
	    if( iHistType.eq.iLogLog .or. cEventsPerMsec.eq.'Y') then
		do i = 1,nbins
		    bins(4,i) = bins(4,i) / (bins(3,i)-bins(1,i))
		end do
		ylabel = 'Events/ms'
	    end if
c
c	    If log(Y) - lin(X) histogram and square root Y axis selected
c
	    if( iHistType .eq. iLogLin .and. cRootY .eq. 'Y' ) then
		do i = 1,nbins
		    bins(4,i) = SafeSqrt( bins(4,i) )
		end do
		ylabel = 'Sqrt(Events)'
	    end if

	    xlabel = 'ms'
	    title = ' Dwell times from list file '

	    close(unit=itemp_file)
	end if

	return
	end

	subroutine histogram_from_file(bins,nbins,max_bins,
     &	total,iHistType,xlog,ylog)

$INCLUDE: 'PATCOM.FOR'
C
c	Load histogram from an ASCII list file
c
      real*4 bins(4,nbins)               ! (Out) Histogram results
      integer*2 nbins			 ! (Out) No. of bins
      integer*2 max_bins		 ! (In) Max. No. of bins allowed
      real*4 bin_width			 ! (Out) Bin width (linear) (ms)
      integer*2 iHistType		 ! (Out) Type of histogram
					 ! 1 = linear X linear Y
					 ! 2 = Log X linear Y (Sigworth-Sine)
					 ! 3 = Log X Log Y (magleby)
	character xlog
	character ylog

	LOGICAL end_of_file

	parameter( iLinLin=1, iLogLin=2, iLogLog=3 )

	character*40 list_file_name / ' ' /
	real*4 row(10)
C
C	CODE
C
	call find_cursor(ix,iy)
	if( list_file_name .eq. ' ' ) list_file_name = default_path
	call get_file_name(ix,iy,list_file_name,' ','OLD',
     &	' File name ',iflag)

	if( iflag .ne. -1 ) then
	    open(unit=itemp_file,
     &	    file=list_file_name,
     &	    form='binary',
     &	    iostat=istat,
     &	    recl=1)

	    if( istat .ne. 0 ) then
		call Report_Error( 2,24,' Cannot open this file ')
		iflag = -1
	    end if
	end if

	if( iflag .ne. -1 ) then

	    call tell_user_box(5,20,' WAIT ... Creating Histogram ')

	    nbins = 0
	    end_of_file = .false.
	    do while( (.not. end_of_file) .and. nbins.lt.max_bins)

		call extract_row(itemp_file,row,nc,end_of_file)
		if( (.not. end_of_file) .and. nc .ge. 4 ) then
		    nbins = nbins + 1
		    bins(1,nbins) = row(1)
		    bins(2,nbins) = row(2)
		    bins(3,nbins) = row(3)
		    bins(4,nbins) = row(4)
		endif
	    end do

	    close(unit=itemp_file)

c
c	    Determine histogram type from ratio of widths
c	    of first and last bins
c
	    if( nbins .gt. 0 ) then
		r = (bins(3,nbins-1) - bins(1,nbins-1))/
     &		(bins(3,2)-bins(1,2))
		bin_width = bins(3,1) - bins(1,1)
		if( r .gt. 1.01 ) then
		    iHistType = iLogLin
		    xlog = 'Y'
		    ylog = 'N'
		else
		    iHistType = iLinLin
		    xlog = 'N'
		    ylog = 'N'
		end if

		total = 0.
		do i = 1,nbins
		    total = total + bins(4,i)
		end do
	    else
	    end if
	else
	    total = 0.
	    nbins = 0
	end if

	return
	end


