	subroutine simplex(par,npar,iteration,fmin,ep)
c
c	Find set of "npar" model parameters "par(n)" which minimises
c	the sum of squared residuals between the function in
c	"rlog_likelihood" and the x,y data points in "x(npoints)"
c	and "y(npoints)"
c
c       13/10/97 maximum interations now 31000
c
	real*4 par(1)
	integer*2 npar
	real*4 s(10,10),centroid(10)
	real*8 ssq(10),ssq_min,f,epd
        parameter(max_iteration = 31000 )
	character key
	character*50 string
	logical special,new_start,converged
	real*8 rLog_likelihood
	external rLog_likelihood
c
c	code
c
c

	nvertices = npar+1

c
c	Iterative loop to minimise rlog_likelihood
c
	ilow = 1
	do ipar = 1,npar
	    s(ilow,ipar) = par(ipar)
	end do
	iteration = 0
	converged = .false.
	new_start = .true.
	step = .2

	do while( (.not. converged) .and. (iteration.lt.max_iteration) )

	    if( new_start ) then
		do ivertex = 1,nvertices	      ! Compute initial simplex
		    if( ivertex .ne. ilow ) then
			do ipar = 1,npar
			    s(ivertex,ipar) = s(ilow,ipar) +
     &			    float(ivertex-ilow)*step
			    par(ipar) = s(ivertex,ipar)
			end do
		    endif
		    ssq(ivertex) = rlog_likelihood(par,npar)
		end do
		new_start = .false.
	    endif


	    call get_key( key, special )
	    if( key .eq. '$' ) goto 100

	    iteration = iteration + 1

	    ilow = 1
	    ihigh = 2
	    do ivertex = 1,nvertices				    ! Find
		if( ssq(ivertex) .lt. ssq(ilow) ) ilow = ivertex    ! highest
		if( ssq(ivertex) .gt. ssq(ihigh) ) ihigh = ivertex  ! and lowest
	    end do						    ! vertices

	    do ipar = 1,npar			      ! Centroid
		centroid(ipar) = 0.
		do ivertex = 1,nvertices
		    if( ivertex .ne. ihigh ) then
			centroid(ipar) = centroid(ipar) +
     &			s(ivertex,ipar)/float(npar)
		    endif
		end do
	    end do

	    do ipar = 1,npar				  ! Reflection
		par(ipar) = 2.*centroid(ipar) - s(ihigh,ipar)
	    end do

	    f = rlog_likelihood(par,npar)

	    if( f .le. ssq(ilow) ) then
		do ipar = 1,npar		      ! Successful step
		    s(ihigh,ipar) = par(ipar)
		end do
		ssq(ihigh) = f
		ilow = ihigh

		do ipar = 1,npar		      ! Try an expanded simplex
		    par(ipar) = 2.*par(ipar) - centroid(ipar)
		end do
		f = rlog_likelihood(par,npar)

		if( f .le. ssq(ilow) ) then	     ! If expansion has reduced f,
		    do ipar = 1,npar		     ! incorporate it into simplex
			s(ihigh,ipar) = par(ipar)    ! replacing the worst
		    end do			     ! parameter set
		    ssq(ihigh) = f
		endif

	    else

		n = 0
		do ivertex = 1,nvertices
		    if( f .lt. ssq(ivertex) ) n = n + 1
		end do

		if( n .gt. 1 ) then		     ! Reflection is, at least,
		    do ipar = 1,npar		     ! better than the current
			s(ihigh,ipar) = par(ipar)    ! two highest points,
		    end do			     ! so subsitute it for the
		    ssq(ihigh) = f		     ! highest
		elseif( n .eq. 1 ) then

		    do ipar = 1,npar
			s(ihigh,ipar) = par(ipar)
			ssq(ihigh) = f
		    end do

		    do ipar = 1,npar
			par(ipar) = (par(ipar) + centroid(ipar))/2.
		    end do
		    f = rlog_likelihood(par,npar)

		    if( f .lt. ssq(ihigh) ) then
			do ipar = 1,npar
			    s(ihigh,ipar) = par(ipar)
			    ssq(ihigh) = f
			end do
		    endif
		else

		    do ipar = 1,npar			  ! Contract the size
			par(ipar) = (centroid(ipar)+s(ihigh,ipar))/2.
		    end do
		    f = rlog_likelihood(par,npar)

		    if( f .lt. ssq(ihigh) ) then	      ! If this result is better
		       do ipar = 1,npar 		      ! then the current worst
			   s(ihigh,ipar) = par(ipar)	      ! parameter set,
		       end do				      ! incorporate it into the
		       ssq(ihigh) = f			      ! simplex
		    else
c
c			The contraction strategy produced no improvement
c			so contract the whole vertex about the current
c			best parameter set

			do ivertex = 1,nvertices
			    if( ivertex .ne. ilow ) then
				do ipar = 1,npar
				    s(ivertex,ipar) =
     &				    (s(ivertex,ipar) + s(ilow,ipar))/2.
				    par(ipar) = s(ivertex,ipar)
				end do
				ssq(ivertex) = rlog_likelihood(par,npar)
			    endif
			end do
		    endif
		endif
	    endif

	    ilow = 1
	    ihigh = 2
	    do ivertex = 1,nvertices				    ! Find
		if( ssq(ivertex) .lt. ssq(ilow) ) ilow = ivertex    ! highest
		if( ssq(ivertex) .gt. ssq(ihigh) ) ihigh = ivertex  ! and lowest
	    end do						    ! vertices

	    ncc = 0
	    converged = .false.
	    epd = ep
	    eps = max(abs(ssq(ihigh)*epd),epd)
	    if( (ssq(ihigh)-ssq(ilow)) .le. eps ) then
		converged = .true.
		ncc = -1
	    end if
	    do ipar = 1,npar
		 if( abs(s(ihigh,ipar)-s(ilow,ipar)).le. 2.*ep ) then
		     converged = .true.
		     ncc = ipar
		 end if
	    end do

c	     sum = 0.
c	     do ipar = 1,npar
c		 sum = sum +abs(s(ihigh,ipar)-s(ilow,ipar))
c	     end do
c	     if( sum .le. ep ) converged = .true.

	    if( converged ) then

		ssq_min = 1E30
		do istep = -1,1,2
		    do ipar = 1,npar
			par(ipar) = s(ilow,ipar) + 0.02*float(istep)
     &			 *s(ilow,ipar)
			ssq_min = rlog_likelihood(par,npar)
			if( ssq_min .lt. ssq(ilow) ) then
			    do i = 1,npar
				s(ilow,i) = par(i)
			    end do
			    ssq(ilow)=ssq_min
			    kconv = 0
			    nrestarts = nrestarts + 1
			    step = 0.05
c			     new_start = .true.
			    converged = .false.
			endif
		    end do
		end do

	    endif
c
c	    Display iteration
c
	    call find_cursor(ix,iy)
	    write( string, '('' Iteration '',i4,)') iteration
	    call display_stringt ( string )
	    call display_int4(int4(ssq(ilow)))

	    call move_cursor(ix,iy)

c	     write(*,'(1x,i3,5(1x,f10.6),1x,f10.4,1x,i2)')
c     &      iteration,s(ilow,1),s(ilow,2),s(ilow,3),
c     &      s(ilow,4),s(ilow,5),
c     &      ssq(ilow),nrestarts

	end do
100	continue
	do ipar = 1,npar
	    par(ipar) = s(ilow,ipar)
	end do
	fmin = ssq(ilow)
	return
	end
