	subroutine select_state( ix,iy,ilevel,ndisplay )

	parameter( nmenu=6 )
	character*16 menu(nmenu) /
     &	' Closed',
     &	' Sub-state ',
     &	' Open',
     &	' Latency ',
     &	' Rejected ',
     &	' All States ' /

	integer*2 istates(nmenu) / 0,1,2,3,-1,-2/
	integer*2 i /1/

	character key
	logical new_menu

	i = min(ndisplay,i)
	i = Iwait_MENU_VERTICAL1(menu,'123456',ndisplay,ix,iy,new_menu
     &	,i,' Channel state ',key)
	ilevel = istates(i)
	return
	end

	subroutine select_plot_device(ix,iy,idev,ihandle,device)
$include: 'patcom.for'
c
c	Let user select plotter output device
c
c	IX,IY = top left of entry form
c	Workstation No. returned in IDEV
c	Output file handle returned in IHANDLE (with IDEV=0)
c	IDEV and IHANDLE = 0 indicates abort
c	DEVICE is returned with letter pressed by user
c
	character*(*) device

	parameter(nmenu=6,iprinter=2,iplotter=3,ifile=4,idisplay=1
     &	,ihpgl=5)
	character*20 menu(nmenu) /
     &	' Screen       S',
     &	' Printer      R',
     &	' Plotter      P',
     &	' ASCII file   F',
     &	' HPGL file    H',
     &	' Cancel     ESC'/

	character*50 list_file / ' ' /
	character*6 keys /'SRPFH$'/
	logical new_menu
	character key

	new_menu = .true.
	itype = Iwait_MENU_VERTICAL1(menu,keys,nmenu,ix,iy,new_menu
     &	,itype,' Output to: ',key)

	select case ( itype )
	case ( idisplay )
c
c	    Write to screen
c
	    call get_screen_device(idev)

	case (iplotter)
c
c	    Open plotter
c
	    call display_message(ix+1,iy+1,22,' WAIT ... Plotting ',1)
	    CALL OPEN_WORKSTATION(IDEV,11)
	    CALL LOAD_FONTS(IDEV)
	    CALL SET_TEXT_FACE(IDEV,1)

	    iheight = int( (32767./12.)*(14. / 72.) )
	    call set_character_height( idev, iheight )

	case ( iprinter )
c
c	    Open printer
c
	    call display_message(ix+1,iy+1,22,' WAIT ... Plotting ',1)
	    CALL OPEN_WORKSTATION(IDEV,21)
	    CALL LOAD_FONTS(IDEV)
	    CALL SET_TEXT_FACE(IDEV,max(ifont,1))
	    call set_point_size( idev, max(ipoint_size,10) )

	case ( ifile )
c
c	    Open ASCII file
c
	    call get_file_name(ix+1,iy+itype+1,
     &	    list_file,' ','NEW',
     &	    ' ASCII file ',iflag)
	    if( iflag .ge. 0 ) then
		ihandle = itemp_file
		if( iflag .eq. 0 ) then
		    open(unit=ihandle,
     &		    file=list_file,
     &		    form='binary',
     &		    err=100)
		else
		    open(unit=ihandle,file=list_file,form='binary',
     &		    access='APPEND',err=100)
		end if
		idev = 0
		call display_message(ix+2,iy+2,28
     &		,' WAIT ... Writing to file ',1)
100		continue
	    else
		idev = 0
		ihandle = 0
	    endif

	case  (ihpgl )
c
c	    Output to an HPGL file
c
	    call get_file_name(ix,iy+itype+1,
     &	    list_file,' ','NEW',
     &	    ' HPGL file ',iflag)
	    if( iflag .ge. 0 ) then
		call display_message(ix+1,iy+1,22,' WAIT ... Plotting ',1)
		CALL OPEN_WORKSTATION_to_file(IDEV,11,list_file)
		CALL LOAD_FONTS(IDEV)
		CALL SET_TEXT_FACE(IDEV,1)
		iheight = int( (32767./12.)*(14. / 72.) )
		call set_character_height( idev, iheight )

	    endif

	case default
c
c	    ESC = abort plot
c
	    idev = 0
	    ihandle = 0

	end select

	if( itype .ne. 0 ) then
	    device = keys(itype:itype)
	    if( device(1:1) .eq. 'H')
     &	    device(2:len(device)) = list_file
	else
	    device = ' '
	endif
	return
	end

	subroutine get_file_name(ix,iy,
     &	file_name,extension,file_type,title,iflag)

	character*(*) file_name,extension,file_type,title
	character key

	parameter( nnew=4 )
	character*16 new_menu(nnew) /
     &	' Change Name F1',
     &	' Overwrite   F2',
     &	' Append      F3',
     &	' Abort      ESC' /

	parameter( nold=2 )
	character*16 old_menu(nold) /
     &	' Change Name F1',
     &	' Abort      ESC' /

	logical file_exists,new_m,quit

	integer*2 overwrite,append,abort
	parameter( overwrite=0, append=1, abort=-1 )

c	code
c
	quit = .false.
	iflag = abort
	do while ( .not. quit )

	    lwidth = max(max(len(title)+2,len(file_name)+2),40)
	    call erase_box(ix,iy,ix+lwidth,iy+3)
	    call display_box(ix,iy,ix+lwidth,iy+3)
	    call move_cursor(ix+1,iy)
	    call get_screen_device(iscreen)
	    call set_text_colour(iscreen,4)
	    call display_string(title)
	    call set_text_colour(iscreen,1)
	    call move_cursor(ix+1,iy+3)
	    call display_string(' Press RETURN to continue, ESC=cancel ')

	    call move_cursor(ix+2,iy+1)
	    call get_string( file_name, nc, key )

	    if( key .ne. '$' ) then

		nc = len_trim( file_name )
		if( extension .ne. ' ' ) then
		    i = index( file_name, '.' )
		    if( i .eq. 0 ) i = nc+1
		    file_name(i:i+3) = extension
		endif
c
c		Does a file of this name exist already?
c
		inquire( file=file_name, exist = file_exists )

		call upper_case( file_type )

		if( file_type .eq. 'NEW' ) then
c
c		    NEW file tests
c
		    if( file_exists ) then
			new_m = .true.
			iop = 1
			iop = Iwait_MENU_VERTICAL1(new_menu,'123$',nnew,
     &			ix+1,iy+2,new_m,iop,' File Exists! ',key)

			if( iop.gt.1 ) quit = .true.
			if( iop.eq.2 ) iflag = overwrite
			if( iop.eq.3 ) iflag = append
			if( iop.eq.4 ) iflag = abort

		    else
c
c			If file does not exist
c			check to see if the file can be opened
c
			open(unit=9,file=file_name,iostat=istat )
			if( istat .ne. 0 ) then
			    call erase_box(ix+1,iy+4,ix+34,iy+6)
			    call display_box(ix+1,iy+4,ix+34,iy+6)
			    call move_cursor(ix+2,iy+5)
			    call display_string(
     &			    ' ERROR! Cannot create this file ')
			    quit = .false.
			    iflag = abort
			else
			    quit = .true.
			    iflag = overwrite
			end if
			close(unit=9,iostat=istat)

		    end if
		else
c
c		    Open an OLD file
c
		    if( .not. file_exists ) then
			new_m = .true.
			iop = 1
			iop = Iwait_MENU_VERTICAL1(old_menu,'1$',nold,
     &			ix+1,iy+2,new_m,iop,' File not found! ',key)
			if( iop .eq. 2 ) then
			    quit = .true.
			    iflag = abort
			end if
		    else
			quit = .true.
			iflag = overwrite
		    endif
		endif
	    else
		quit = .true.
		iflag = abort
	    end if
	end do

	return
	end

	subroutine display_progress( ix,iy, title, i,n, key )
	character*(*) title,key

	integer*4 i,n
	character*60 string
	logical special
	real*4 tMessage /0./

	if( time_in_secs() .ge. tMessage ) then
	    write(string,'(a,1x,i7,''/'',i7)') title,i,n
	    nc = len_trim( string )
	    call erase_box(ix,iy,ix+nc+2,iy+2)
	    call display_box(ix,iy,ix+nc+2,iy+2)
	    call move_cursor(ix+1,iy+1)
	    call display_string( string(1:nc) )
	    call get_key( key, special )
	    TMessage = time_in_secs() + 1.
	end if
	return
	end

	subroutine display_error( ix,iy, title )
	character*(*) title

	nc = len_trim( title )
	call erase_box(ix,iy,ix+nc+2,iy+2)
	call display_box(ix,iy,ix+nc+2,iy+2)
	call move_cursor(ix+1,iy+1)
	call display_string( title )
	call wait(1.)

	return
	end

	REAL FUNCTION CONVERT_GAIN(GAIN_IN)
$INCLUDE: 'PATCOM.FOR'
C
C	Derive "bit_value" from "gain" and vice_versa
C
	PARAMETER( ADC_MAX = 2048.)
	CONVERT_GAIN = 1000.*adc_range/(ADC_MAX*GAIN_IN)
	RETURN
	END

	subroutine open_event_list_file
$include:'patcom.for'

c
c	Open event list file
c
	open(unit=ievent_file,
     &	file='patevent.lst',
     &	form='binary',
     &	access='direct',
     &	recl=nbytes_event)

	return
	end

       subroutine extract_row(ifile,row,n,end_of_file)
       real*4 row(1)
       integer*2 n
       logical end_of_file

	logical quit
	character*1 byte,cr,lf
	character*80 string /' '/

	cr = char(13)
	lf = char(10)

	end_of_file = .false.
	is = 0
	n = 0
	quit = .false.
	do while( .not. quit )
	    read(unit=ifile,end=50) byte
	    if( byte .eq. cr ) quit = .true.
	    goto 51
50	    quit = .true.
	    end_of_file = .true.
51	    continue

	    inum = index('0123456789Ee+-.',byte)

	    if( inum .gt. 0 ) then
c
c		If character is part of a number, append it to
c		the number string
c
		is = is + 1
		string(is:is) = byte
	    elseif( is .gt. 0 ) then
c
c		If enough characters are available for a number
c		decode it.
c
		n = n + 1
		read( string, '(f16.0)', err=100 ) row(n)
		goto 101
100		row(n) = 0.
101		continue
		is = 0
		string = ' '
	    end if
	end do
	return
	end

	subroutine state_name( ilevel, name )
	integer*2 ilevel
	character*(*) name

	parameter( nmenu=6 )
	character*8 menu(nmenu) /
     &	'All ',
     &	'Reject ',
     &	'Closed',
     &	'Sub ',
     &	'Open',
     &	'Latency' /

	name = menu(ilevel+3)
	return
	end

	subroutine tell_user_box(ix,iy,string)
	character*(*) string

	nc = len_trim(string)+1
	call erase_box(ix,iy,ix+nc+2,iy+2)
	call display_box(ix,iy,ix+nc+2,iy+2)
	call move_cursor(ix+1,iy+1)
	call display_stringt(string)
	return
	end

	subroutine write_to_log( string )
$include:'wcpcom.for'
	character*(*) string
	character*12 tod

	call time_of_day( tod )
	write(unit=ilog_file,iostat=istat) tod
	write(unit=ilog_file,iostat=istat) string(1:len_trim(string))
	write(unit=ilog_file,iostat=istat) char(13)//char(10)

	return
	end

	subroutine time_of_day( string )
	character*(*) string

	call gettim( ihr, imin, isec, icsec )
	write( string, '(i2,'':'',i2,''.'',i2)') ihr,imin,isec
	if( string(4:4) .eq. ' ' ) string(4:4) = '0'
	if( string(7:7) .eq. ' ' ) string(7:7) = '0'
	return
	end

	subroutine gaussian_filter( new_file_name, fc )
c	Gaussian digital filter. (based on Sigworth, 1983)
$include:'patcom.for'
	character*(*) new_file_name
	real*4 fc

	parameter(max_nc=108)
	real*4 a(max_nc)		      ! Filter coefficients array
	integer*4 iRecord
	character*16 string
	logical quit
	character key
c
c	code
c
	if( new_file_name .eq. ' ' ) then
	    new_file_name = file_name
	    call get_file_name(2,2,new_file_name,'.scd','NEW',
     &	'   Filtered output to File ',iflag)
	else
	    iflag = 1
	end if

	if( iflag .ne. -1 ) then
c
c	    Open output file to hold filtered results
c
	    open(unit=itemp_file,
     &	    file= new_file_name,
     &	    form='binary',
     &	    access='direct',
     &	    recl=np_record*2,iostat=istat)

	    if( istat .ne. 0 ) then
		call Report_Error(2,24,' Cannot open this file! ')
		iflag = -1
	    end if

	end if

	if( iflag .ne. -1 ) then

	    if( fc .le. 0. ) then
c
c	       If the routine has not been supplied with a
c	       filter cut-off frequency, ask the user

	       fc = fc*1000.
	       fmax = 250./dt
	       write( string, '('' (0 - '',i5,'' Hz )'')') int(fmax)
	       call get_number_box(2,6,' Filter cut-off frequency ',
     &	       string,0.,fmax,fc)
	       fc = fc/1000.
	    end if
c
c	    Calculate gaussian filter coefficients
c
	    sigma = .132505/(fc*dt)
	    if( sigma .ge. .62 ) then
c
c		 Generate positive half of filter coefficients
c			   1		 j2
c		 a(j) = ------- exp( - ------ )    j=0,nc
c			+2p s		2 s2
c
		b = -1./(2.*sigma*sigma)
		temp = 1.
		iMid = max_nc/2
		i0 = iMid
		i1 = iMid
		do while( (temp.ge.epsilon(temp)) .and. (i0.gt.1) )
		    temp = exp( float(i1-iMid)*float(i1-iMid)*b  )
		    i0 = i0 - 1
		    i1 = i1 + 1
		    a(i1) = temp
		    a(i0) = temp
		end do

c
c		Normalise the coefficients so they add up to 1
c
		sum = 0.
		do i = i0,i1
		    sum = sum + a(i)
		end do

		do i = i0,i1
		    a(i) = a(i) / sum
		end do
	    else
c
c	       Special case for very light filtering (See Colquhoun & Sigworth, 1983)
c
		a(1) = (sigma*sigma)/2.
		a(2) = 1. - 2.*a(1)
		a(3) = a(1)
		i0 = 1
		i1 = 3
	    end if
	    nc = i1 - i0 + 1

c
c	    Copy header block to output file
c
	    nOverviewSlice = 0
	    call save_header()
	    do iRecord = 1,idata_offset
		read(unit=idata_file,rec=iRecord)
     &		(iwork(i),i=1,np_record)
		write(unit=itemp_file,rec=iRecord)
     &		(iwork(i),i=1,np_record)
	    end do
c
c	    Read points from input file, filter, and send
c	    to output file
c
	    quit = .false.
	    key = 'S'
	    iRecord = 1
	    n_filtered = 0
	    do while( .not. quit )

		n_filtered = n_filtered + 1

		read(unit=idata_file,rec=idata_offset+iRecord)
     &		(iBuf(i),i=1,np_record)

		call display_progress( 2,21,
     &		' Records filtered (ESC to abort) ',
     &		 iRecord,n_records, key )
		if( key .eq. '$' ) quit = .true.
c
c		Fill work buffer up at start of file
c
		if( iRecord .eq. 1 ) then
		    do i = 1,nc
			iwork(i) = iBuf(i)
		    end do
		end if

		do ip = 1,np_record

		    iEnd = iEnd + 1
		    if( iEnd .gt. nc ) iEnd = 1
		    iwork(iEnd) = iBuf(ip)

		    i = iEnd + 1
		    if( i .gt. nc ) i = 1
		    sum = 0.
		    do j = i0,i1
			sum = sum + float(iwork(i))*a(j)
			i = i + 1
			if( i .gt. nc ) i = 1
		   end do

		   iBuf(ip) = int(sum)
		end do

		write(unit=itemp_file,rec=idata_offset+iRecord)
     &		(iBuf(i),i=1,np_record)

		iRecord = iRecord + 1
		if( iRecord .eq. n_records ) quit = .true.
	    end do

	    close(unit=itemp_file)	! Close temp. file

	    file_name = new_file_name	! Re-open as work file
	    call open_data_file

	    nOverViewSlice = 0
	    n_records = n_filtered
	    np_file = np_record*n_records
	    call save_header

	end if
	return
	end

	subroutine get_number_box(ix,iy,title,label,rmin,rmax,r)

	integer*2 ix,iy 	! Left/Top of box (In)
	character*(*) title	! Box title (In)
	character*(*) label	 ! Label Line in box (In)
	real*4 rmin,rmax	! Min/Max limits (In)
	real*4 r		! Value (In/Out)

	character*36 err
	character*12 list
	character*40 menu
c
c	code
c
	menu = label
	nc = max(len_trim(label)+1,20)
	if( abs(r) .le. 10000. .and. abs(r) .gt. 0.9 ) then
	    write( list, '(f8.1)' ) r
	else
	    write( list, '(1pg12.3)' ) r
	end if

	err = ' '
10	if( err .eq. ' ' ) err = title
	call text_window(menu(1:nc),list,1,ix,iy,err)
	r = check_limits(list,rmin,rmax,1,err)
	if( err .ne. ' ' ) goto 10

	return
	end

        subroutine ListData( Results, nRows, nCols, Display,
     &	Label, iLeft, iTop )
$include:'patcom.for'


	integer*2 nRows,nCols		! Array dimensions
	real*4 Results(nCols,nRows)	! Data array to be listed
	logical Display(nCols)		! Columns to be used (T/F)
	character*(*) label(nCols)	! Column labels
	integer*2 iLeft,iTop		! Top,left of window

	character string*13
	logical quit,special,refresh_window
	character key
	parameter( nRowsDisplayed=12, nColWidth=14 )
	character*40 list_file /' '/


c	code

	ibottom = itop + nRowsDisplayed + 6

	iright = ileft + 2
	nDisp = 0
	do i = 1,nCols
	    if( Display(i) ) then
	       iright = iright + nColWidth
	       nDisp = nDisp + 1
	    end if
	end do

	quit = .false.
	refresh_window = .true.
	iRow = 1
	do while ( .not. quit )

	    if( refresh_window ) then
		call erase_box(ileft,itop,iright,ibottom)
		call display_box(ileft,itop,iright,ibottom)

c		Display labels at top

		j = ileft + 1
		do i = 1,nCols
		    if( Display(i) ) then
			call move_cursor( j, itop)
			call display_string(' ')
			call display_string( label(i) )
			j = j + nColWidth
		    end if
		end do

c		Display function keys

		call get_screen_device(iscr)
		call set_text_colour(iscr,2)		    ! Red text
		call move_cursor( ileft+1, ibottom-4 )
		call display_string(' PgDn Move Down ')
		call move_cursor( ileft+1, ibottom-3 )
		call display_string(' PgUp Move Up ')
		call move_cursor( ileft+1, ibottom-2 )
		call display_string(' F1   Save to File ')
		call move_cursor( ileft+1, ibottom-1 )
		call display_string(' ESC  Quit ')
		call get_screen_device(iscr)
		call set_text_colour(iscr,1)
		refresh_window = .false.
	    end if

	    iRow0 = iRow
	    do i = 1,nRowsDisplayed
		j = ileft + 1

		do iCol = 1,nCols
		    if( Display(iCol) ) then
			call move_cursor( j, itop+i )
			if( iRow .le. nRows ) then
			    write( string, '(1pg12.3)' )
     &			    Results(iCol,iRow)
			    call display_string( string )
			else
			    string = ' '
			    call display_string( string )
			end if
			j = j + nColWidth
		    end if
		end do
                iRow = min(iRow,nRows) + 1
	    end do
	    iRow = iRow0

	    call wait_for_key( key, special )

	    if( key .eq. 'Q' ) then
c		PgDn
		iRow = min( iRow + nRowsDisplayed,
     &		nRows - nRowsDisplayed + 1)
		iRow = max(iRow,1)
	    elseif( key .eq. 'P' ) then

c		PgUp

		iRow = max( iRow - 2*nRowsDisplayed,1 )

	    elseif( key .eq. '1' ) then
c
c		Save to file
c
		call get_file_name(ileft+1,itop+1,
     &		list_file,' ','NEW',
     &		' Save to file ',iflag)
		if( iflag .ge. 0 ) then
		    if( iflag .eq. 0 ) then
			open(unit=itemp_file,
     &			file=list_file,
     &			form='binary',
     &			err=100)
		    else
			open(unit=itemp_file,
     &			file=list_file,
     &			form='binary',
     &			access='APPEND',
     &			err=100)
		    end if

		    do i = 1,nRows
			n = 0
			do j = 1,nCols
			    if( Display(j) ) then
				n = n + 1
				write( string, '(1pg12.3)' )
     &				Results(j,i)
				if( n .ne. nDisp ) then
				    write(unit=itemp_file)
     &				    string//char(9)
				else
				    write(unit=itemp_file)
     &				    string//char(13)//char(10)
				end if
			    end if
			end do
		    end do
		    write(unit=itemp_file) char(26)
		    close(unit=itemp_file,err=100)
100		    continue
		    refresh_window = .true.
		end if
	    elseif( key .eq. '$' ) then
c		ESC
		quit = .true.
	    end if
	end do

	return
	end

	subroutine Report_Error(ileft,itop,msg)
	integer*2 ileft,itop
	character*(*) msg
	character*60 string
c
c	code
c
	string = msg
	nc = len_trim (string )

	call get_screen_device( iscreen )
	call set_text_colour( iscreen, 2 )
	call move_cursor(ileft,itop)
	call display_string( string(1:nc) )
	call set_text_colour( iscreen, 1 )
	string = ' '
	call wait(1.)
	call display_string( string(1:nc) )
	return
	end

	subroutine Check_if_File_Exists( fname, iflag )
c
c	Check if the file given in fname exists.
c	Note that iflag=0 on entry indicates that the operation
c	has already been aborted, so don't bother with check
c
	character*(*) fname
	integer*2 iflag

	logical FileExists

	if( iflag .ne. 0 ) then
	    inquire( file=fname, exist=FileExists )
	    if( .not. FileExists ) then
		call Report_Error(2,24,'Cannot open this file ')
		iflag = 0
	    end if
	end if
	return
	end

	subroutine display_int4( i4)
	integer*4 i4
	character*12 string
	write( string, '(i10)' ) i4
	call display_string( string )
	return
	end

      real*4 function chi_prob( chi2, df )

c     Calculate probability of finding a value of chi2
c     greater than <chi2> for a distribution with <df>
c     degrees of freedom
c

	parameter( dz = 0.01, pi=3.14156 )

	if( df.gt.0. ) then
	    z = ( (chi2/df)**(1./3.) - (1. - 2./(9.*df)) ) /
     &	    sqrt( 2./(9.*df) )
	    sum = 0.
	    do while( z .le. 6. )
	       sum = sum + exp( -(z*z)/2. )
	       z = z + dz
	    end do
	    chi_prob = (dz/sqrt(2.*pi))*sum
	 else
	    chi_prob = 0.
	 end if
	 return
	 end
 
	real function erf(x)
	real*8 t,z,y,erfx
	z = dabs(dble(x))
	t = 1./( 1. + 0.5*z )
	y = t*dexp( -z*z - 1.26551223 +
     &	 t*(1.00002368 + t*(.37409196 + t*(.09678418 +
     &	 t*(-.18628806 + t*(.27886807 + t*(-1.13520398 +
     &	 t*(1.48851587 + t*(-.82215223 + t*.17087277 )))))))))

	if( x .lt. 0. ) y = 2. - y
	erfx = 1. - y
	erf = sngl(erfx)
	return
	end

	subroutine create_path( path, dir_path, fname, fext )
	character*(*) path, dir_path, fname, fext
c
c	Create a complete file path (In path) by assembling the
c	directory path (dir_path), file name (fname) and
c	file extension) (fext components

	nc = len(path)
	if( dir_path .ne. ' ' ) then
	    path = dir_path
	    ix = len_trim(path)+1
	else
	    path = ' '
	    ix = 1
	end if

	path(ix:nc) = fname

	if( fext .ne. ' ' ) then
	    ix = index( path, '.' )
	    if( ix .le. 0 ) ix = len_trim(path)+1
	    path(ix:nc) = fext
	end if
	return
	end

	subroutine writeNoSpaces( ifile, string )
	integer*2 ifile
	character*(*) string

	nc = len_trim(string)
	j = 0
	do i = 1,nc
	    if( string(i:i) .ne. ' ' ) then
		j = j + 1
		string(j:j) = string(i:i)
	    end if
	end do

	j = max(j,1)
	write(unit=ifile) string(1:j)

	return
	end
