        subroutine transition_detection
$INCLUDE: 'PATCOM.FOR'
C
c       3/6/96 Modified to allow appending to event list
c              Bug where part of signal wasn't updated fixed
c       26/3/97 ... Bug when n_events not set to zero for new file fixed 
C	-------------------------------------------------------------------
C	Transition detection and state classification (4 state model)
C	Three threshold levels are used to classify the signal into
C	4 states: CLOSED, SUB sub-level, OPEN.
C	-------------------------------------------------------------------
C
	LOGICAL QUIT,new_menu,display_on,new_border,compress
	integer*2 iwindow(4)
	CHARACTER*1 KEY
	parameter(nmenu=10,istatus_left=64)
	character*15 menu(nmenu) /
     &	'Start detect F1',
     &	'Setup        F2',
     &	'Next Event PgDn',
     &	'Prev Event PgUp',
     &	'Goto Event   F3',
     &	'Edit Event   F4',
     &  'Block Edit   F5',
     &	'Export list  F6',
     &	'Cont./Epis.  F7',
     &	'Exit        ESC' /

	record / event_record / event
        integer*4 ip_s,ip_e,np_max,isample_offset,ii,i_start,i_end
        integer*4 nskip,np_display,ie
	integer*2 ixy(12)
	character*50 string
        logical ClearEventsList
        integer*4 iEvent

C
C -- CODE -------------------------------------------------------
C

	i_start = 1
	i_end = n_records

	isample_offset = nbytes_header / 2
	np_max = np_record
	np_max = np_max*n_records

	if( BriefEvent .eq. 0. ) BriefEvent = 3.*dt

	np_display = np_record
	np_record = 1
	call open_data_file

	call erase_all
C
C -- Set size of display area
C 
	CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	CALL GET_CHARACTER_SIZE(IW,IH)

	iwindow_width = ((60*IW)/512)*512
	iwindow(1) = iw
	iwindow(2) = ndc_max - 14*ih
	iwindow(3) = iw + iwindow_width
	iwindow(4) = iwindow(2) + max_adc*iy_magn_min

	ihi_level = abs(int((open_threshold/100.)*float(iunit)))
	ilo_level = abs(int((close_threshold/100.)*float(iunit)))
	if( iunit .lt. 0 ) then
	    ipolarity = -1
	else
	    ipolarity = 1
	end if
	quit = .false.
	display_on = .true.
	track_baseline = .false.
	new_border = .true.
	compress = .false.
	iEvent = 1
	ihalf = iunit/2

	do while( .not. quit )

	    if( n_events .gt. 0 ) then

		read(unit=iEvent_file,rec=max(iEvent-1,1)) event
		ilast_level = event.level
		read(unit=iEvent_file,rec=min(iEvent+1,n_events)) event
		inext_level = event.level
		read(unit=iEvent_file,rec=iEvent) event

		ip_s = event.DisplayStart
		ip_e = event.DisplayEnd
		ii = ip_s + isample_offset
                if( (ip_s + np_display) .gt. np_file ) then
                        ie = ip_e - ip_s + 1
                        do i = 1,np_display
                                iBuf(i) = 2048
                        end do
                else
                        ie = np_display
                 end if
                read(unit=idata_file,rec=ip_s+isample_offset )
     &           (iBuf(i),i=1,ie)

		t_min = float(ip_s)*dt*0.001
		call display_traces( new_border, iwindow, np_display,
     &		ilo_level,ihi_level,ipolarity,iBuf,t_min,event.zero)

		dx = float(iwindow(3)-iwindow(1))/float(np_display)

		ilev = IdealLevel( ilast_level )
		ixy(2) = iwindow(2) + iy_magn *
     &		(ilev + event.zero - iy_offset )
		ixy(3) = int(float(event.start - ip_s)*dx) + iwindow(1)
		ixy(1) = max( ixy(3) - 1000, iwindow(1) )
		ixy(4) = ixy(2)
		ixy(5) = ixy(3)
		ilev = IdealLevel( event.level )
		ixy(6) = iwindow(2) + iy_magn *
     &		(ilev + event.zero - iy_offset )

		if( event.end - ip_s .gt. np_display ) then
		    ixy(7) = iwindow(3)
		    ixy(8) = ixy(6)
		    np_event = 4
		else

		    ixy(7) = int(float(event.end-ip_s)*dx) + iwindow(1)
		    ixy(8) = ixy(6)
		    ixy(9) = ixy(7)
		    ilev = IdealLevel( inext_level )
		    ixy(10) = iwindow(2) + iy_magn *
     &		    (ilev + event.zero - iy_offset )
		    ixy(11) = min(ixy(9) + 1000,iwindow(3))
		    ixy(12) = ixy(10)
		    np_event = 6

		end if

		call set_polyline_colour( iscreen, red )
		call polyline( iscreen, ixy, np_event )
		call set_polyline_colour( iscreen, black )

		call move_cursor(2,17)
                write(string,'('' Event             : '',i7)') iEvent
		call display_string(string)

		call move_cursor(2,18)
		irec = (event.DisplayStart / np_display) + 1
                write(string,'('' Record            : '',i7)') irec
		call display_string(string)

		call move_cursor(2,19)
		ilev = event.level + 2
		write(string,'('' State             : '',a)')
     &		level_name(ilev)
		call display_string(string)

		call move_cursor(2,20)
		r = event.dwell_time
		write(string,'('' Duration (ms)     : '',f8.2)') r
		call display_string( string )

		if( event.variance .ne. -1. ) then
		    r = event.average_current
		    call move_cursor(2,21)
		    write(string,'('' Avg. current (pA) : '',f8.2)') r
		    call display_string( string )

		    call move_cursor(2,22)
		    r = event.variance
		    write(string,'('' Variance (pA^2)   : '',f8.2)') r
		    call display_string( string )
		else
		    string = ' '
		    call move_cursor(2,21)
		    call display_string( string )
		    call move_cursor(2,22)
		    call display_string( string )
		end if

	    else
		CALL erase_BOX(1,1,62,15)
		CALL DISPLAY_BOX(1,1,62,15)
		call move_cursor(2,1)
		call display_string(' Detect/Edit Transitions ')
		if( VoltageGatedChannels ) then
		    call display_String(' (Episodic record) ' )
		else
		    call display_String(' (Continuous record)  ' )
		end if
		call move_cursor(2,2)
		call display_string(' No Events ')

	    end if

	    iop = Iwait_MENU_VERTICAL1(menu,'12QP34567$'
     &	    ,nmenu,istatus_left-1,1,new_menu,iop,' Options'
     &	    ,key)

	    select case( iop )
	    case( 1 )

		if( n_events .gt. 0 ) then
		    CALL QUERY_BOX(2,2,
     & ' Append (A) or overwrite (O) event list (or Cancel (ESC)) ',
     &   key)
		else
		   key = 'O'
		end if

                IF( KEY .NE. '$' ) then
                     if( (Key .eq. 'A') .or. (key.eq.'a')) then
                        ClearEventsList = .false.
                     else
                        ClearEventsList = .true.
                     end if
		     close(unit=idata_file)

		     if( VoltageGatedChannels ) then
			 call detect_transitions_vgated(
     &			 ihi_level,ilo_level,np_display,
     &			 i_start,i_end,track_baseline,iwindow,
     &                   display_on,2,17,iBuf,ClearEventsList)
		    else
			 call detect_transitions_lgated(
     &			 ihi_level,ilo_level,
     &			 i_start,i_end,track_baseline,iwindow,
     &                   display_on,2,17,iBuf,ClearEventsList)
		    end if

		     if( n_events .gt. 0 ) then
			 nskip = int4( BriefEvent/dt )
			 call average_events(2,18,nskip)

			 call save_events(2,19)

			 isample_offset = nbytes_header / 2
			 np_record = 1
		     end if

		     call open_data_file

		end if

		new_border = .true.

	    case( 2 )

		if( VoltageGatedChannels ) then
		    nlist = 8
		else
		    nlist = 7
		end if
		call setup_detection(i_start,i_end,np_display,nlist)
		ihi_level = abs(int((open_threshold/100.)*float(iunit)))
		ilo_level = abs(int((close_threshold/100.)*float(iunit)))
		call save_header()
		new_border = .true.

	    case( 3 )
c
c		Display next event
c
		iEvent = min(iEvent + 1,n_events)
	    case( 4 )
c
c		Display previous event
c
		iEvent = max(iEvent -1 ,1)
	    case( 5 )
c
c		Display selected event
c
		write(string,'('' Go to event (1-'',i7,'') ? '')')
     &		n_events
		call display_message(2,2,44,string(1:30),1)
		call get_number(r,1.,float(n_events),float(iEvent))
		iEvent = int4(r)

	    case( 6 )
c
c		Edit event state
c
		iOldLevel = event.level
		call select_state( 2,2,event.level,5 )
		write(unit=iEvent_file,rec=iEvent) event
		if( iOldLevel .ne. event.level ) compress = .true.

	    case( 7 )
c
c		Block edit
c
		call block_edit( iEvent )
		compress = .true.

	    case( 8 )
c
c		Export event list
c
		call export_event_list(2,18)
		new_border = .true.

	    case( 9 )
c
c		Continuous / Episodic analysis
c
		VoltageGatedChannels = .not. VoltageGatedChannels
		call save_header
		new_border = .true.

	    case( 10 )
c
c		    Stop and exit
c
		    quit = .true.
	    end select
	end do

	if( compress ) then
	     call compress_events(2,18)
	     call average_events( 2,19, nskip )
	     call save_events(2,20)
	end if

	np_record = np_display
	call open_data_file
	call save_header
	close(unit=idata_file)
	return
	end

	subroutine setup_detection(i_start,i_end,np_display,nlist)
$include:'patcom.for'
	integer*4 i_start,i_end ! Start/End at records
	integer*4 np_display	! No. of samples in record
	integer*2 nlist 	! No. of lines to display in setup table

	parameter(nmenu=8)
	character*42 menu(nmenu) /
     &	' Start at record (1-    )',
     &	' End at record ',
     &	' Closed state threshold (0-100%) ',
     &	' Open state threshold (0-100%)',
     &	' Automatic baseline tracking (Y/N)',
     &	' Brief event definition (<= ms)    ',
     &	' Brief event exclusion limit (%) ' ,
     &	' Start at sample ' /

	character*12 list(nmenu)
	character key
	character*40 string

	i = 1
        write(menu(i),'('' Start at record (1-'',i7,'')'')')
     &	n_records / np_display
	write(list(i),'(I7)') i_start
	i = i + 1
	write(list(i),'(I7)') i_end
	i = i + 1
	write(list(i),'(f6.0)') close_threshold
	i = i + 1
	write(list(i),'(f6.0)') open_threshold
	i = i + 1
	if( track_baseline ) then
	    list(i) = 'Y'
	else
	    list(i) = 'N'
	end if
	i = i + 1
	write(list(i),'(f6.2)') BriefEvent
	i = i + 1
	write(list(i),'(f6.0)') BriefEventLimit
	i = i + 1
	write(list(i),'(i5)') iVoltageStepStart


	string = ' '
100	if( string .eq. ' ' ) string = ' Set transition detector '
	call text_window(menu,list,nlist,2,2,string)

	i = 1
	i_start = int4(check_limits(list,1.,float(n_records),i,string))
	if( string .ne. ' ' ) goto 100
	i = i + 1
	i_end = int4(check_limits(list,1.,float(n_records),i,string))
	if( string .ne. ' ' ) goto 100
	i = i + 1
	close_threshold = check_limits(list,0.,100.,i,string)
	if( string .ne. ' ' ) goto 100
	i = i + 1
	open_threshold = check_limits(list,0.,100.,i,string)
	if( string .ne. ' ' ) goto 100
	i = i + 1
	key = check_letter(list,'YN',i,string)
	track_baseline = .false.
	if( key .eq. 'Y' ) track_baseline = .true.
	i = i + 1
	BriefEvent = check_limits(list,0.,1E30,i,string)
	i = i + 1
	BriefEventLimit = check_limits(list,0.,100.,i,string)
	if( string .ne. ' ' ) goto 100
	i = i + 1
	iVoltageStepStart = int(check_limits(list,1.,float(np_display),
     &	i,string))
	if( string .ne. ' ' ) goto 100

	return
	end

      subroutine detect_transitions_lgated(iupper,ilower,
     & i_start,i_end,
     & track_zero,iwindow,display_on,ixp,iyp, ibuffer,
     & ClearEventsList )
$include:'patcom.for'
c
c     Transition detection for ligand gated channels
c     (Digitised samples are treated as a continuous recording)

      integer*2 iupper         ! (In) Upper transition threshold
      integer*2 ilower	       ! (In) Lower transition threshold
      integer*4 i_start        ! (In) First record to be analysed
      integer*4 i_end	       ! (In) Last record
      logical track_zero       ! (In) If .true. track drifting baseline.
      integer*2 iwindow(4)     ! (In) Display area for current records
      integer*2 ixp,iyp        ! (In) Position of progress box
      integer*2 ibuffer(1)
      logical ClearEventsList  ! (In) If .true. clear events list

      logical display_on
      parameter( np=512, nring=64, nzero_skip=10, a=0.9 )
      integer*2 iring(nring)
      integer*2 ixy(4)
      integer*4 isample 	       ! sample counter (n.b. 4 byte integer)
      integer*4 irecord
      integer*4 iBriefEventTLimit
 
      record /event_record/ event

      character*50 string
      character key
      logical quit,special,new_border,Initialise
      integer*4 np_max
c
c	code
c
 
      do i = 1,nring			    ! Set baseline history
	  iring(i) = ibase		    ! buffer to initial value
      end do                                ! for baseline supplied in
      ir = 1                                ! subroutine argument list
      event.start = 1
      event.end = 1
      d_start = 0.
      iold_state = iclose
      icurrent_state = iclose
      isample = 0


      IF(IUNIT.LT.0) THEN
	  IPOLARITY = -1
      ELSE
	  IPOLARITY = 1
      ENDIF
      ixy(4) = iy_magn*(ibase - iy_offset) + iwindow(2)

c
c	Open data file
c
       np_record = 512
       call open_data_file
       np_max = np_record*n_records

      iBriefEventLimit = int(float(iabs(iunit))*BriefEventLimit*0.01)
      iBriefEventTLimit = int4( BriefEvent / dt )

      irecord = i_start
      isample = (irecord-1)*np_record + 1
      quit = .false.
      new_border = .true.
      ihalf = iunit/2
      iDirection = 0
      iCrossed = ilower
      if( ClearEventsList ) then
        n_events = -1
      end if
      Initialise = .True.
      do while( (.not. quit) .and. irecord .le. i_end )

	  read(unit=idata_file,rec=irecord+idata_offset)
     &	  (ibuffer(i),i=1,np_record)


	  if( display_on ) then
	      t_min = float(irecord-1)*float(np_record)*dt*0.001
	      call display_traces( new_border, iwindow, np_record,
     &	      ilower,iupper,ipolarity, ibuffer, t_min, ibase )

	      ixy(1) = iwindow(1)
	      ix = iwindow(1)
	      IX_STEP = (iwindow(3) - IX)/np_record
	  end if

	  call set_polyline_colour( iscreen, red )
	  do i = 1,np_record
	      isample = isample + 1
	      iold_level = ilevel
c
c	      Subtract baseline & make signal positive going
c
	      ilevel = (ibuffer(i) - ibase)*ipolarity
c
c	      Determine the new state
c	      Points greater than <iUpper> classed as Open
c	      Points less than <iLower classed as Closed
c	      Points in between classed as Sub
c
	      if( ilevel .gt. iupper ) then
		  inew_state = iopen
		  iCrossed = iupper
	      elseif( ilevel .lt. ilower ) then
		  inew_state = iclose
		  iCrossed = ilower
	      else
		  inew_state = isub
	      end if

             if( Initialise ) then
                iCurrent_state = INew_state
                Event.Start = isample 
                Initialise = .false.
            end if
c
c	      Inhibit detection of short transitions which are
c	      shorter than BriefEventTLimit and less than
c	      BriefEventLimit from the threshold level
c
	      if( inew_state .ne. icurrent_state ) then
		if((isample-event.end) .le. iBriefEventTLimit .and.
     &		  iabs(ilevel-iCrossed).le. iBriefEventLimit) then
		    inew_state = icurrent_state
		end if
	      end if

C
C	      Plot next point of ideal current trace
C
	      IF( DISPLAY_ON ) THEN
		  IXY(1) = IX
		  IXY(2) = IXY(4)
		  IX = IX + IX_STEP
		  IXY(3) = IX
		  ixy(4) = iy_magn*(inew_state*ihalf + ibase - iy_offset)
     &			    + iwindow(2)
		  call polyline( iscreen, ixy, 2 )
	      end if
 
c	     Procedure for tracking a drifting zero baseline.
c	     The zero level <ibase> is updated with a recursive
c	     low pass filter using sample points only when the channel
c	     is found to be in the closed state. The first and last
c	     <nzero_skip> samples within the closed state are excluded.
 
	      if( track_zero .and. icurrent_state.eq.iclose ) then
                  ir = mod(ir,nring)+1
		  iring(ir) = ibuffer(i)
		  if( isample-event.end .gt. nzero_skip ) then
		      ibase = int(float(iring(
     &			  mod(ir-nzero_skip+nring,nring)+1))*
     &			  (1.-a) + a*float(ibase) )
                  end if
              end if
 
c	     If the channel has entered a new state, write the details of the
c	     event preceding the transition to the event list file
 
              if( inew_state .ne. icurrent_state ) then
c
c		 Exclude Sub-states which are simply part of
c		 the rising and falling edges of Open and Closed
c		 This is done by monitoring the direction of the
c		 transition (i.e. positive for opening, -1 for closure)
c		 and excluding double opening and closure events)
c
		 iOldDirection = iDirection
		 iDirection = isign(1,inew_state - icurrent_state)
		 if( iDirection .ne. iOldDirection ) then

		      n_events = n_events + 1
		      event.zero = ibase
		      event.level = icurrent_state
		      event.end = isample-1
c
c		      Interpolate between sample points to find
c		      where event crossed threshold
c
		      d_end = float(iCrossed-iold_level)/
     &			      float(ilevel-iold_level)
		      d_end = min(max(d_end,0.),1.)

		      event.dwell_time = (d_end - d_start +
     &		       float(event.end - event.start))*dt
		      event.dwell_time = max(event.dwell_time,dt*0.1)

		      if( d_end .gt.1. .or.
     &			 event.dwell_time .le. 0. ) then
			call move_cursor(1,1)
			call display_string('Err= ')
			call display_flt( d_end )
			call display_int( iold_level )
			call display_int( iCrossed )
			call display_int( ilevel )
			call display_int( iCurrent_state )
			call display_int( inew_state )
			call display_int( idirection )
		       endif

		      if(n_events.gt.0) then
			   event.DisplayStart =
     &			   max(event.start - np_record/10,1)
			   event.DisplayEnd =
     &			   min(event.DisplayStart + np_record - 1,
     &			   np_max)

			   write(unit=iEvent_file,rec=n_events) event
		      end if

		      event.start = event.end
		      d_start = d_end
		      iold_state = event.level
		      ir = mod(ir-nzero_skip+nring,nring)+1

                 end if
		 icurrent_state = inew_state
              end if
          end do
	  call set_polyline_colour( iscreen, black )
C
C	  Update status display
C
	  CALL MOVE_CURSOR(ixp,iyp)
	  WRITE(STRING,
     &    '(''Record '',I7,''/'',I7,'' Events detected '',i7)')
     &	   IRECORD,i_end,n_events
	  call display_stringt( string )

	  irecord = irecord + 1

	  call get_key( key, special )
	  if( key .eq. '$' ) quit = .true.
      end do

      call save_header
      close( unit=idata_file )

      return
      end

      subroutine detect_transitions_vgated(iupper,ilower,np_display,
     & i_start,i_end,
     & track_zero,iwindow,display_on,ixp,iyp, ibuffer,
     & ClearEventsList )
$include:'patcom.for'
c
c     Transition detection for voltage gated channels
c     (Digitised samples are treated as a series of discrete
c      records containing "np_record" samples)
c

      integer*2 iupper         ! (In) Upper transition threshold
      integer*2 ilower	       ! (In) Lower transition threshold
      integer*4 i_start        ! (In) First record to be analysed
      integer*4 i_end	       ! (In) Last record
      integer*4 np_display     ! (In) No. of samples in record
      logical track_zero       ! (In) If .true. track drifting baseline.
      integer*2 iwindow(4)     ! (In) Display area for current records
      integer*2 ixp,iyp        ! (In) Position of progress box
      integer*2 ibuffer(1)
      logical ClearEventsList  ! (In) If .true. clear events list

      logical display_on
      parameter( np=512, nring=64, nzero_skip=10, a=0.9 )
      integer*2 iring(nring)
      integer*2 ixy(4)
      integer*4 isample 	       ! sample counter (n.b. 4 byte integer)
      integer*4 irecord
      integer*4 iBriefEventTLimit
 
      record /event_record/ event

      character*50 string
      character key
      logical quit,special,new_border,first_event
c
c	code
c
 
      do i = 1,nring			    ! Set baseline history
	  iring(i) = ibase		    ! buffer to initial value
      end do                                ! for baseline supplied in
      ir = 1                                ! subroutine argument list
      event.start = 1
      event.end = 1
      d_start = 0.
      iold_state = iclose
      icurrent_state = iclose


      IF(IUNIT.LT.0) THEN
	  IPOLARITY = -1
      ELSE
	  IPOLARITY = 1
      ENDIF
      ixy(4) = iy_magn*(ibase - iy_offset) + iwindow(2)

c
c	Open data file
c
       np_record = np_display
       call open_data_file

      iBriefEventTLimit = int4( BriefEvent/dt )
      iBriefEventLimit = int(float(iabs(iunit))*BriefEventLimit*0.01)

      irecord = i_start
      quit = .false.
      new_border = .true.
      ihalf = iunit/2
      if( ClearEventsList ) then n_events = 0
      do while( (.not. quit) .and. irecord .le. i_end )

	  read(unit=idata_file,rec=irecord+idata_offset)
     &	  (ibuffer(i),i=1,np_record)

	  if( display_on ) then
	      t_min = float(irecord-1)*float(np_record)*dt*0.001
	      call display_traces( new_border, iwindow, np_record,
     &	      ilower,iupper,ipolarity, ibuffer, t_min, ibase )

	      dx = float(iwindow(3) - iwindow(1))/float(np_record)
	  end if

	  call set_polyline_colour( iscreen, red )
	  iVoltageStepStart = max(iVoltageStepStart,1)
c
c	  Define record display area as beginning-to-end of record
c
	  event.DisplayStart = (irecord-1)*np_record + 1
	  event.DisplayEnd = event.DisplayStart + np_display - 1
c
c	  Start at first sample after voltage step with channel
c	  in closed state
c
	  isample = iVoltageStepStart + np_record*(irecord-1) - 1
	  istate = iclose
	  ilevel = (ibuffer(iVoltageStepStart) - ibase)*ipolarity
	  event.start = isample
	  event.end = isample
	  x = float(iVoltageStepStart-1)*dx + iwindow(1)
	  first_event = .true.
	  iOldDirection = 0
c
c	  Scan record from starting sample to end of record
c
	  do i = iVoltageStepStart,np_record

	      isample = isample + 1
	      iold_level = ilevel
c
c	      Subtract baseline & make signal positive going
c
	      ilevel = (ibuffer(i) - ibase)*ipolarity
c
c	      Determine the new state
c	      Points greater than <iUpper> classed as Open
c	      Points less than <iLower classed as Closed
c	      Points in between classed as Sub
c
	      if( ilevel .gt. iupper ) then
		  inew_state = iopen
		  iCrossed = iupper
	      elseif( ilevel .lt. ilower ) then
		  inew_state = iclose
		  iCrossed = ilower
	      else
		  inew_state = isub
	      end if
c
c	      Inhibit detection of short transitions which are
c	      shorter than BriefEventTLimit and less than
c	      BriefEventLimit from the threshold level
c
	      if( inew_state .ne. icurrent_state ) then
		if((isample-event.end) .le. iBriefEventTLimit .and.
     &		  iabs(ilevel-iCrossed).le. iBriefEventLimit) then
		    inew_state = icurrent_state
		end if
	      end if

C
C	      Plot next point of ideal current trace
C
	      IF( DISPLAY_ON ) THEN
		  IXY(1) = int(x)
		  IXY(2) = IXY(4)
		  x = x + dx
		  IXY(3) = int(x)
		  ixy(4) = iy_magn*(inew_state*ihalf + ibase - iy_offset)
     &			    + iwindow(2)
		  call polyline( iscreen, ixy, 2 )
	      end if
 
c	     Procedure for tracking a drifting zero baseline.
c	     The zero level <ibase> is updated with a recursive
c	     low pass filter using sample points only when the channel
c	     is found to be in the closed state. The first and last
c	     <nzero_skip> samples within the closed state are excluded.
 
	      if( track_zero .and. icurrent_state.eq.iclose ) then
                  ir = mod(ir,nring)+1
		  iring(ir) = ibuffer(i)
		  if( isample-event.end .gt. nzero_skip ) then
		      ibase = int(float(iring(
     &			  mod(ir-nzero_skip+nring,nring)+1))*
     &			  (1.-a) + a*float(ibase) )
                  end if
              end if
 
c	     If the channel has entered a new state, write the details of the
c	     event preceding the transition to the event list file
 
	      if( inew_state .ne. icurrent_state ) then
c
c		 Exclude Sub-states which are simply part of
c		 the rising and falling edges of Open and Closed
c		 This is done by monitoring the direction of the
c		 transition (i.e. positive for opening, -1 for closure)
c		 and excluding double opening and closure events)
c
		 iOldDirection = iDirection
		 iDirection = isign(1,inew_state - icurrent_state)
		 if( iOldDirection .ne. iDirection ) then
		      n_events = n_events + 1
		      event.zero = ibase
c
c		      Make sure first closed state is classed
c		      as a "latency" state
c
		      if( first_event ) then
			  event.level = ilatency
			  first_event = .false.
		      else
			  event.level = icurrent_state
		      end if
		      event.end = isample-1
c
c		      Interpolate between sample points to find
c		      where event crossed threshold
c
		      d_end = float(iCrossed-iold_level)/
     &			      float(ilevel-iold_level)
		      d_end = min(max(d_end,0.),1.)

		      event.dwell_time = (d_end - d_start +
     &		       float(event.end - event.start))*dt
		      event.dwell_time = max(event.dwell_time,dt*0.1)

		      if( d_end .gt.1. .or.
     &			 event.dwell_time .le. 0. ) then
			call move_cursor(1,1)
			call display_string('Err= ')
			call display_flt( event.dwell_time)
			call display_int4( event.end-event.start )
			call display_flt( d_start )
			call display_flt( d_end )
		       endif

		      if(n_events.gt.0) then
			   write(unit=iEvent_file,rec=n_events) event
		      end if

		      event.start = event.end
		      d_start = d_end
		      iold_state = event.level
		      ir = mod(ir-nzero_skip+nring,nring)+1
                 end if
                 icurrent_state = inew_state
              end if
          end do
	  call set_polyline_colour( iscreen, black )
C
C	  Update status display
C
	  CALL MOVE_CURSOR(ixp,iyp)
	  WRITE(STRING,
     &    '(''Record '',I7,''/'',I7,'' States detected '',i7)')
     &	   IRECORD,i_end,n_events
	  call display_stringt( string )

	  irecord = irecord + 1

	  call get_key( key, special )
	  if( key .eq. '$' ) quit = .true.
      end do

      call save_header
      close( unit=idata_file )

      return
      end


       subroutine display_traces( new_border, iwindow, np_display,
     & ilo_level,ihi_level, ipolarity, ibuffer, t_min, iEventBase )
$include:'patcom.for'
c
c	Display digitised current record & idealised trace
c
	logical new_border	! (In) If .true. re-display borders & labels
	integer*2 iwindow(4)	! (In) Display Window
	integer*4 np_display	! (In) Points to display
	integer*2 ilo_level	! (In) Lower detection level
	integer*2 ihi_level	! (In) High detection level
	integer*2 ipolarity	! (In) Single channel current polarity
	integer*2 ibuffer(1)	   ! (In) Single channel data buffer
	real*4 t_min		! (In) Time record starts at

	character*30 string
c
c	code
c
	IUNIT_CURSOR = iEventbase + IUNIT
	ILO_CURSOR = iEVentbase + ilo_level*IPOLARITY
	IHI_CURSOR = iEventbase + ihi_level*IPOLARITY
	IBASE_CURSOR = iEventbase

	if( new_border ) then
c
c	    Clear ideal trace box
c
	    CALL erase_BOX(1,1,62,15)
	    CALL DISPLAY_BOX(1,1,62,15)
	    call move_cursor(2,1)
	    call display_string(' Detect/Edit Transitions ')
	    if( VoltageGatedChannels ) then
		call display_String(' (Episodic record) ' )
	    else
		call display_String(' (Continuous record)  ' )
	    end if

	    t_max = t_min + float(np_display)*dt*0.001
	    CALL MOVE_CURSOR(2,15)
	    WRITE(string,'(F8.3,''s'')') t_min
	    CALL DISPLAY_STRINGt(string)
	    WRITE(string,'(F8.3,''s'')') t_max
	    CALL MOVE_CURSOR(50,15)
	    CALL DISPLAY_STRINGt(string)
c
c	    Display status box
c
	    CALL erase_BOX(1,16,62,25)
	    CALL DISPLAY_BOX(1,16,62,25)
	    new_border = .false.

	end if

	CALL SET_POLYLINE_TYPE(ISCREEN,1)
	CALL FILL_RECTANGLE(ISCREEN,iwindow)
	call plot_channel( iscreen, iwindow,
     &	ibuffer,1,1,1, np_display, iy_magn, iy_offset, blue )

	CALL SET_WRITING_MODE(ISCREEN,2)
	CALL SET_POLYLINE_TYPE(ISCREEN,3)

	call display_horizontal_cursor(iscreen,
     &	iwindow,iunit_cursor,iy_magn,iy_offset)
	call display_horizontal_cursor(iscreen,
     &	iwindow,ilo_cursor,iy_magn,iy_offset)
	call display_horizontal_cursor(iscreen,
     &	iwindow,ihi_cursor,iy_magn,iy_offset)
	CALL SET_POLYLINE_TYPE(ISCREEN,5)
	call display_horizontal_cursor(iscreen,
     &	iwindow,ibase_cursor,iy_magn,iy_offset)

	if( VoltageGatedChannels ) then
	    CALL SET_POLYLINE_TYPE(ISCREEN,3)
	    call display_vertical_cursor(iscreen,iwindow,
     &	    iVoltageStepStart,np_display)
	end if

	CALL SET_POLYLINE_TYPE(ISCREEN,1)
	CALL SET_WRITING_MODE(ISCREEN,1)

	return
	end

	subroutine change_event_state( ilevel )
$include:'patcom.for'

	parameter(nmenu=4,istatus_left=64)
	character*15 menu(nmenu) /
     &	'Rejected F1',
     &	'Closed   F2',
     &	'Sub      F3',
     &	'Open     F4' /

	logical new_menu
	character key
c
c	code
c
	new_menu = .true.
	iop = ilevel + 2
	iop = Iwait_MENU_VERTICAL1(menu,'1234',
     &	nmenu,2,2,new_menu,iop,' New level ',key)
	ilevel = iop - 2
	return
	end

	subroutine export_event_list(ixp,iyp)
$include:'patcom.for'
c
c	Export data in event list file to ASCII list file
c
	parameter(nmenu=4)
	character*36 title
	character*36 menu(nmenu) /
     &	' State           (Y/N) ',
     &	' Dwell time      (Y/N) ',
     &	' Average current (Y/N) ',
     &	' Variance        (Y/N) ' /

	character*2 list(nmenu)
	character add_to_file(nmenu) / 'Y','Y','Y','Y' /

	character*40 list_file_name / ' ' /
	integer*2 ilevel /5/
	character*14 string
	character*14 column_name(nmenu) /
     &	'State ',
     &	'Dwell time ms',
     &	'Current pA',
     &	'Variance pA^2' /

	record /event_record / event
	integer*4 iEvent
	character key

c
c	code
c
	if( list_file_name .eq. ' ' ) list_file_name = default_path
	call get_file_name(2,2,list_file_name,' ','NEW',
     &	' Export to File ',iflag)

	if( iflag .ge. 0 ) then
c
c	    Open file for binary sequential access
c
	    open(unit=itemp_file,
     &	    file=list_file_name,
     &	    form='binary',
     &	    iostat=istat)

	    do i = 1,nmenu
		list(i) = add_to_file(i)
	    end do

	    title = ' '
100	    if( title .eq. ' ' ) title = ' Items to be Exported '
	    call text_window(menu,list,nmenu,2,6,title)

	    do i = 1,nmenu
		add_to_file(i) = check_letter(list,'YN',i,title)
	    end do

	    call select_state( 2,12, ilevel, 6 )

c
c	    Write title line to file
c
	    write(unit=itemp_file) 'ATF 1'//char(13)//char(10)
	    write(unit=itemp_file) '4    1'//char(13)//char(10)

	    do i = 1,nmenu
		if( add_to_file(i) .eq. 'Y' ) then
		    write(unit=itemp_file)
     &		    '"'//column_name(i)//char(9)//'"'
		end if
	    end do
	    write(unit=itemp_file) char(13)//char(10)

	    key = 'S'
	    do iEvent = 1,n_events
		read(unit=iEvent_file,rec=iEvent) event
		if( (event.level .eq. ilevel) .or.
     &		    (ilevel .eq. iall ) ) then

		    if( add_to_file(1) .eq. 'Y' ) then
			call state_name( event.level, string )
			call WriteNoSpaces(itemp_file,string//char(9))
		    end if
		    if( add_to_file(2) .eq. 'Y' ) then
			r = event.dwell_time
			write(string,'(f12.3)') r
			call WriteNoSpaces(itemp_file,string//char(9))
		    end if
		    if( add_to_file(3) .eq. 'Y' ) then
			r = event.average_current
			write(string,'(f12.3)') r
			call WriteNoSpaces(itemp_file,string//char(9))
		    end if
		    if( add_to_file(4) .eq. 'Y' ) then
			r = event.variance
			write(string,'(f12.3)') r
			call WriteNoSpaces(itemp_file,string//char(9))
		    end if

		    write(unit=itemp_file) char(13)//char(10)

		    call display_progress(ixp,iyp,
     &		    'Events Exported (ESC to abort)',iEvent,n_events,key)
		   if( key .eq. '$' ) goto 101

		end if

	    end do

101	    continue

	    write(unit=itemp_file) char(26)	! Write EOF character
	    close(unit=itemp_file)

	end if
	return
	end


	subroutine average_events(ixp,iyp,nskip)
$include:'patcom.for'
c
c	Calculate averages and variances for each state
c	and write result to event list file.
c
	integer*2 ixp,iyp	  ! (In) Display position
	integer*4 nskip

	integer*4 ir,i4,isum,isum2,icount,iavg,iEvent
	record /event_record/ event
	character key
	character*50 string
	logical quit,special

c	code
c
c
c	Open A/D data file for sample-by-sample access
c
	logical FileOpen,FileExists
c
c	If file is already open close it
c
	inquire(unit=idata_file,opened=FileOpen,exist=FileExists)
	if( FileOpen ) close(unit=idata_file)

	open(unit=idata_file,
     &	file= file_name,
     &	form='binary',
     &	access='direct',
     &	recl=2)
	isample_offset = nbytes_header/2

	quit = .false.
	iEvent = 1
	do while ( .not. quit )
c
c	    Get event data
c
	    read( unit=iEvent_file, rec=iEvent ) event
c
c	    Summate A/D signal (after subtracting baseline)
c	    and squared signal for average and variance
c
	    icount = 0
	    isum = 0
	    isum2 = 0

	    ir = event.start + nskip
	    if( ir .gt. event.end - nskip ) then
		key = '$'
	    else
		key = 'S'
	    end if

	    do while( key .ne. '$' )

		np = min( event.end-nskip-ir+1,np_record)
		read(unit=idata_file,rec=ir+isample_offset)
     &		(iBuf(i),i=1,np)

		do i = 1,np
		    i4 = iBuf(i) - event.zero
		    isum = isum + i4
		    isum2 = isum2 + i4*i4
		    icount = icount + 1
		end do

		ir = ir + np
		if( ir .gt. event.end-nskip ) key = '$'
	    end do

	    if( icount .gt. 0 ) then
c
c		Calculate current average and variance for state
c		and put into event record
c
		iavg = isum / icount
		event.average_current = float(iavg)*ScaleIm
		if( icount .gt. 1 ) then
		    i4 = (isum2 - iavg*iavg*icount) / (icount-1)
		    event.variance = float(i4)*ScaleIm*ScaleIm
		else
		    event.variance = 0.
		end if

	    else
		event.variance = -1.
	    end if

	    write( unit=iEvent_file, rec=iEvent ) event

	    if( mod( iEvent,10 ) .eq. 0 ) then
		call move_cursor(ixp,iyp)
		write( string,
     &		'(''Averaging Events '',i7,''/'',i7)')
     &		iEvent,n_events
		call display_stringt( string )
		call get_key( key, special )
		if( key .eq. '$' ) quit = .true.
	    end if

	    iEvent = iEvent + 1
	    if( iEvent .gt. n_events ) quit = .true.
	end do

	close(unit=idata_file)

	return
	end

	subroutine compress_events(ixp,iyp)
$include:'patcom.for'
c
c	Compress event list by combining adjacent events
c	at the same level then save on to the end of the
c	data file
c
	integer*4 iEventOut,iEventIn
	record / event_record / EventIn
	record / event_record / EventOut
	character*50 string
c
c	code
c
	iEventOut = 0
	read(unit=iEvent_file,rec=1) EventOut
	iOldLevel = EventOut.level

	do iEventIn = 2,n_events

	    read(unit=iEvent_file,rec=iEventIn) EventIn

	    if( EventIn.level .ne. iOldLevel ) then
		iEventOut = iEventOut + 1
		write(unit=iEvent_file,rec=iEventOut) EventOut
		EventOut = EventIn
		iOldLevel = EventIn.level
	    else
		EventOut.end = EventIn.end
		EventOut.dwell_time =
     &		EventOut.dwell_time + EventIn.dwell_time
	    end if

	    if( mod( iEventIn,10 ) .eq. 0 ) then
		call move_cursor(ixp,iyp)
		write( string,
     &		'(''Compressing event list '',i7,''/'',i7)')
     &		iEventIn,n_events
		call display_stringt( string )
	    end if

	end do
	n_events = iEventOut
	return
	end

	subroutine save_events(ixp,iyp)
$include:'patcom.for'
c
c	Save event list to end of data file
c
c
	integer*4 iEventOffset,nSave,iEvent
	record / event_record / Event
	character key
c
c	code
c

	nSave = np_record
	np_record = 16
	call open_data_file
	iEventOffset = n_records+idata_offset

	key = 'S'
	iEvent = 1
	do while( key .ne. '$' )
	    read(unit=iEvent_file,rec=iEvent) Event
	    write(unit=idata_file,rec=iEvent+iEventOffset) Event
	    call display_progress(ixp,iyp,
     &	    'Saving event list (ESC to abort)',iEvent,n_events,key)

	    iEvent = iEvent + 1
	    if( iEvent .gt. n_events ) key = '$'

	end do

	call save_header

	np_record = nSave
	n_records = np_file / np_record

	return
	end

	subroutine load_events(ixp,iyp)
$include:'patcom.for'
c
c	Extract event list from end of data file and
c	copy to patevent.lst
c
c
	integer*4 iEventOffset,nSave,iEvent
	record / event_record / Event
	character key
c
c	code
c

	nSave = np_record
	np_record = 16
	call open_data_file
	iEventOffset = n_records+idata_offset

	key = 'S'
	do iEvent = 1,n_events
            read(unit=idata_file,rec=iEvent+iEventOffset,
     &      err=100) Event
	    write(unit=iEvent_file,rec=iEvent) Event
	    call display_progress(ixp,iyp,
     &	    'Loading event list ',iEvent,n_events,key)
	end do

	close(unit=idata_file)
	np_record = nSave
	n_records = np_file / np_record
	return
c
c       Exit routine if error occurs reading event list
c
100     continue
        CALL Report_Error(2,2,' Error! Bad list of events. ? ')

c       Clear event list (26/4/97 to fix Ken Wann's bug)

        n_events = 0
	np_record = nSave
	n_records = np_file / np_record
        call save_header()
	close(unit=idata_file)

        return
	end

	subroutine block_edit(iEventIn)
$include:'patcom.for'
c
c	Change a block of events to the same  level
c
	parameter(nmenu=2)
	character*30 menu(nmenu)
	character*10 list(nmenu)
	character*36 title
        integer*4 iEvent,iStart,iEnd,iEventIn
	record / event_record / Event
c
c	code
c

	i = 1
	write(menu(i),'('' Start at event (1-'',i7,'')'')') n_events
	write(list(i),'(i7)') iEventIn
	i = i + 1
	menu(i) = ' End at event '
	write(list(i),'(i7)') iEventIn

	title = ' Change block of events '
	do while( title .ne. ' ' )

	    call text_window(menu,list,nmenu,2,2,title)

	    i = 1
	    iStart = int4(check_limits(list,1.,float(n_events),i,title))
	    if( title .ne. ' ' ) cycle
	    i = i + 1
	    iEnd = int4(check_limits(list,1.,float(n_events),i,title))
	    if( title .ne. ' ' ) cycle

	end do


	call select_state( 2,6, iNewLevel, 5 )

	do iEvent = iStart,iEnd
	    read(unit=iEvent_file,rec=iEvent) Event
	    Event.level = iNewLevel
	    write(unit=iEvent_file,rec=iEvent) Event
	end do

	return
	end

	integer*2 function IdealLevel( ilevel )
$include:'patcom.for'

	if( ilevel .ne. ilatency ) then
	    IdealLevel = ilevel * iunit / 2
	else
	    iDealLevel = 0
	end if
	return
	end


