	subroutine write_ascii_list(ihandle,rlist,ncols,nrows)
c
c	Write contents of REAL array RLIST(NCOLS,NROWS) to file
c	as NROWS rows of ASCII text (NCOLS per row) to file
c	attached to IHANDLE

	character tab,cr,lf
	real rlist(ncols,nrows)

	character*200 string
	integer*2 istring(100)
	equivalence(string,istring)

c
c	code
c
	tab = char(9)
	cr = char(13)
	lf = char(10)
	do irow = 1,nrows
	    string = ' '
	    j = 1
	    do icol = 1,ncols
		write(string(j:j+12),'(1pg12.5,a)') rlist(icol,irow),tab
		j = j + 13
	    end do
	    string(j-1:j+1) = cr//lf
	    nc = len_trim( string )
	    call write_bytes(ihandle,ierr,istring,nc)
	end do
	return
	end

	subroutine plot_histogram(output,bins,nbins
     &	,xlo,ylo,xhi,yhi,xtic,ytic,title,xlabel,ylabel
     &	,rep,nlines,xyfit,xlog,ylog)
C
C	Plot histogram
C	--------------

	character xlog		    ! xlog='Y' indicates log x axis
	character ylog		    ! ylog='Y' indicates log y axis

C	Enter with "output='S'" for screen display, "output='H' for
C	hard copy. Bin data in array "bins"
C	No. of bins "NBINS", width of bin in pA "BIN_WIDTH"
C	"xlo,ylo,xhi,yhi" are limits of X and Y axes
C	"xtic,ytic" spacing of calibration tics on axes
C	"xbase" zero current baseline value
C	"title" Histogram title
C	"ylabel" Y axis label
C
$INCLUDE: 'PATCOM.FOR'
C
	character*(*) output,rep(nlines)
	REAL*4 BINS(4,NBINS),xyfit(1)
	INTEGER*2 IXY(2)
	CHARACTER*(*) TITLE,YLABEL,xlabel
	CHARACTER device
	real*4 xy[allocatable](:)

	character*70 string

C
C	CODE
C
	if( xlog .eq. 'Y' ) then
	    if( xhi .le. 0. ) xhi = 1.
	    if( xlo .le. 0. ) xlo = xhi*0.01
	end if
	if( ylog .eq. 'Y' ) then
	    if( yhi .le. 0. ) yhi = 1.
	    if( ylo .le. 0. ) ylo = yhi*0.01
	end if
	if( xlo .eq. xhi ) xhi = xlo + 1.
	if( ylo .eq. yhi ) yhi = ylo + 1.

	device = ' '
	if( output .ne. 'S' ) then
c
c	    Let user select O/P device
c
	    call select_plot_device(2,2,idev,ihandle,device)

	    if( (idev.eq.0) .and. (ihandle.ne.0) ) then
c
c	    Write histogram to ASCII text file in format
c	    Bin Min <TAB> Bin mean <TAB>  Bin Max <TAB> Bin contents <CR> <LF>
c	    Terminate with ASCII end-of-file marker ctrl-z
c
		do i = 1,nbins
		    if((bins(1,i).ge.xlo).and.(bins(3,i).le.xhi)) then
			write(string,'(4(1PG12.5,A))')
     &			bins(1,i),char(9),
     &			bins(2,i),char(9),
     &			bins(3,i),char(9),
     &			bins(4,i),char(13)//char(10)
			call WriteNoSpaces( ihandle, string )
c			 write(unit=ihandle) string(1:len_trim(string))
		    end if
		end do
		write(unit=ihandle) char(26)
		close(unit=ihandle)
		return

	    endif

	    if( idev .eq. 0 ) idev = iscreen
	else
	    idev = iscreen
	endif

c	Get character cell size

	call get_text_attributes( idev, i,i,i,i,i,
     &	ichar_width,ichar_height)
C
c	Select plotting sizes for O/P devices
c
	if( device .eq. 'P' .or. device.eq.'H') then
	    inormal_colour = black
	    call set_polyline_width( idev,
     &	    (iline_thickness-1)*50+3 )
	    CALL SET_SIZE(7000,5000,20000,24000)
	elseif( device .eq. 'R' ) then
	    inormal_colour = black
	    call set_polyline_width( idev,
     &	    (iline_thickness-1)*50+3 )
	    CALL SET_SIZE(8000,7000,28000,20000)
	else
	    inormal_colour = blue
	    CALL SET_SIZE(6500,5000,ichar_width*53,21000)
	endif

	allocate( xy(nbins*4+4) )

C
C	Create histogram
C
	j = 1
	do i = 1,nbins
	    if( (bins(1,i).ge.xlo) .and. (bins(3,i).le.xhi) ) then
		if( j .eq. 1 ) then
		    xy(j) = ToLog( bins(1,i), xlo, xlog )
		    xy(j+1) = ToLog( 0., ylo, ylog )
		    j = j + 2
		end if
		xy(j) =   ToLog( bins(1,i), xlo, xlog )
		xy(j+1) = ToLog( bins(4,i), ylo, ylog )
		xy(j+2) = ToLog( bins(3,i), xlo, xlog )
		xy(j+3) = ToLog( bins(4,i), ylo, ylog )
		j = j + 4
	    end if
	end do
	xy(j) = xy(j-2)
	xy(j+1) = ToLog( 0., ylo, ylog )
	j = j + 2
	nplot = j/2

	call draw_axes_manual(idev,xlo,ylo,xhi,yhi,xlabel,
     &	ylabel,xlog,ylog,'Y',xtic,ytic )

	call set_polyline_colour(idev,inormal_colour)
	CALL DRAW_LINE(IDEV,XY,NPLOT)
	call set_polyline_colour(idev,black)

c	Superimpose fitted gaussians stored in array "xyfit"
c	(Note that xyfit(1) = no. of graphs, xyfit(2) = no. of points
c	in each graph)
c
	ngraphs = int( xyfit(1) )
	np = int( xyfit(2) )
	call set_polyline_colour( idev, red )
	do igraph = 1,ngraphs
	    is = 2*(igraph-1)*np + 3
	    do i = 1,np
		xy(2*i-1) = Tolog( xyfit(is), xlo, xlog )
		xy(2*i) =   Tolog( xyfit(is+1), ylo, ylog )
		is = is + 2
	    end do
	    call draw_line(idev, xy, np )
	end do
	call set_polyline_colour( idev, inormal_colour )
c
C
	if( idev .eq. iscreen ) then
	    do i = 1,nlines
		call move_cursor(2,i+1)
		call display_string( rep(i) )
	    end do
	else
	    IXY(1) = ICHAR_WIDTH
	    IXY(2) = NDC_MAX - ICHAR_HEIGHT*3
	    CALL GRAPHICS_TEXT(IDEV,IXY,file_name)
	    IXY(2) = IXY(2) - ICHAR_HEIGHT
	    CALL GRAPHICS_TEXT(IDEV,IXY,CELL(1:76))
	    IXY(2) = IXY(2) - ICHAR_HEIGHT
	    CALL GRAPHICS_TEXT(IDEV,IXY,TITLE)
	    do i = 1,nlines
		ixy(2) = ixy(2) - ichar_height
		call graphics_text( idev, ixy, rep(i) )
	    end do
	endif

C
C	Close hard copy workstation
C
	IF( IDEV.NE.ISCREEN ) THEN
		CALL UPDATE_WORKSTATION(IDEV)
		CALL CLEAR_WORKSTATION(IDEV)
		CALL UNLOAD_FONTS(IDEV)
		CALL CLOSE_WORKSTATION(IDEV)
	ENDIF

	deallocate( xy )
	call set_polyline_colour(iscreen,black)

	RETURN
	END

	real*4 function ToLog( rValue, Rmin, cLog )
c
c	Convert the number "rValue" to log.10 if "cLog='Y'",
c	If the number is zero or negative set log value to log10(rMin)
c
	real*4 rValue
	real*4 rMin
	character cLog

	if( cLog .eq. 'Y' ) then
	    if( rValue .gt. 0. ) then
		ToLog = log10( rValue )
	    else
		ToLog = log10( rMin )
	    end if
	else
	    ToLog = rValue
	end if
	return
	end

	subroutine cursor_line(icursor,bins,ylo,yhi,xlog,ylog,itype)
$include:'patcom.for'
c
c	Draw vertical cursor
c	Enter with:
c	icursor = bin index number
c	bins = Bins definition
c	xylo,yhi = plotting range limits
	integer*2  itype	   ! Type of line 1=solid,3=dotted
c
	real*4 bins(4,1)
	real xy(4)
	character xlog,ylog

c
c	code
c
	if( xlog .eq. 'Y' ) then
	     xy(1) = log10(bins(2,icursor))
	     xy(3) = xy(1)
	else
	     xy(1) = bins(2,icursor)
	     xy(3) = xy(1)
	end if
	if( ylog .eq. 'Y' ) then
	    xy(2) = log10(ylo)
	    xy(4) = log10(yhi)
	else
	    xy(2) = ylo
	    xy(4) = yhi
	end if
	call set_writing_mode( iscreen, 3 )
	call set_polyline_type( iscreen, itype )
	call draw_line( iscreen, xy, 2 )
	call set_writing_mode( iscreen, 1 )
	return
	end

	subroutine plot_graph(output,xy,np
     &	,xlo,ylo,xhi,yhi,xtic,ytic,xlabel,ylabel,rep,nlines)
$include: 'patcom.for'
C
C	Plot X/Y graph on screen, printer, plotter, or file.
C	----------------------------------------------------
C	Enter with "output='S'" for screen display, "output='H' for
C	hard copy. Graph points is array "xy" "np" = No. of points
C	"xlo,ylo,xhi,yhi" are limits of X and Y axes
C	"xtic,ytic" spacing of calibration tics on axes
C	"ylabel" and "xlabel" =  axes labels
c	"rep" contains "nlines" of text ro be displayed with plot
C
	character*(*) output,rep(nlines)
	REAL*4 XY(1)
	INTEGER*2 IXY(2)
	CHARACTER*(*) ylabel,xlabel
	CHARACTER device
	character*70 string

C
C	CODE
c

	if( output .ne. 'S' ) then
c
c	    Let user select O/P device
c
	    call select_plot_device(2,2,idev,ihandle,device)
	    if( (idev.eq. 0) .and. (ihandle.eq.0) ) return

	    if( (idev.eq.0) .and. (ihandle.ne.0) ) then
c
c	    Write graph ASCII text file in format
c	    Bin Min <TAB> Bin mean <TAB>  Bin Max <TAB> Bin contents <CR> <LF>
c	    Terminate with ASCII end-of-file marker ctrl-z
c
		do i = 1,np
		    write(string,'(2(1PG12.5,A))')
     &		    xy(2*i-1),char(9),
     &		    xy(2*i),char(13)//char(10)
		    call WriteNoSpaces( ihandle, string )
		end do
		write(unit=ihandle) char(26)
		close(unit=ihandle)
		return
	    endif
	else
	    idev = iscreen
	endif

	call get_text_attributes( idev, i,i,i,i,i,
     &	ichar_width,ichar_height)
c
c	Set size/position of plot on page
c
	if( idev .eq.  iscreen ) then
	    CALL SET_SIZE(7000,5000,ichar_width*54,20000)
	elseif( device .eq. 'P' .or. device .eq. 'H' ) then
	    call set_polyline_width( idev,
     &	    (iline_thickness-1)*50+3 )
	    CALL SET_SIZE(7000,5000,20000,24000)
	else
	    call set_polyline_width( idev,
     &	    (iline_thickness-1)*50+3 )
	    CALL SET_SIZE(8000,7000,28000,20000)
	endif

	call draw_axes_manual(idev,xlo,ylo,xhi,yhi,xlabel,ylabel
     &	,'N','N','N',xtic,ytic )

	CALL SET_POLYMARKER_TYPE(IDEV,2)
	CALL SET_POLYMARKER_HEIGHT(IDEV,ICHAR_HEIGHT/4)
	CALL DRAW_marker(IDEV,XY,NP)
C
c	Display rep list
c
	if( idev .eq. iscreen ) then
	    do 35 i = 1,nlines
		call move_cursor(2,i+1)
		call display_string( rep(i) )
35	    continue
	else
	    IXY(1) = ICHAR_WIDTH
	    IXY(2) = ndc_max - ICHAR_HEIGHT*2
	    CALL GRAPHICS_TEXT(IDEV,IXY,file_name)
	    IXY(2) = IXY(2) - ICHAR_HEIGHT
	    CALL GRAPHICS_TEXT(IDEV,IXY,CELL(1:76))
	    IXY(2) = IXY(2) - ICHAR_HEIGHT
	    do i = 1,nlines
		ixy(2) = ixy(2) - ichar_height
		call graphics_text( idev, ixy, rep(i) )
	    end do
	endif

C
C	Close hard copy workstation
C
	CALL GET_SCREEN_DEVICE(ISCREEN)
	IF( IDEV.NE.ISCREEN ) THEN
		CALL UPDATE_WORKSTATION(IDEV)
		CALL CLEAR_WORKSTATION(IDEV)
		CALL UNLOAD_FONTS(IDEV)
		CALL CLOSE_WORKSTATION(IDEV)
	ENDIF
	rETURN
	end

