	subroutine fit_exponentials(bins_in,nbins,iStart,iEnd,total,
     &	cEventsPerMsec,cRootY,xy)
$INCLUDE: 'PATCOM.FOR'
C
C	Fits a single or sum of two or three exponential decays to
C	to % count histogram of channel state times.
C	The SSQMIN non-linear least squares routine is used
c	14/6/95 ... Max. lik. now uses prob. dist function
c	to integrate bin probability, as in Sigworth & Sine
c       13/10/97 Max iterations now 31000
C
	real*4 bins_in(4,1)	! (In) Histogram bin array
				! bins(1,i) = Lower bound
				! bins(2,i) = Upper bound
				! bins(3,i) = Midpoint
				! bins(4,i) = Contents
	integer*2 nbins 	! (In) No. of bins
	integer*2 iStart	! (In) First bin to be used
	integer*2 iEnd		! (In) Last bin to be used
	real*4 total		! (In) Total number of events
	character cRootY	 ! (In) 'Y' = Y axis square root transformed
	character cEventsPerMsec ! (In) 'Y' = Y axis normalised to events/ms
	real*4 xy(1)		! (Out) Best fitting lines
				! Also used as work array by SSQMIN
	logical maximum_likelihood



c	SSQMIN Fitting common block
	parameter(max_bins=512,maxpar=12)
	real*4 bins(4,max_bins)
	real*4 weight(max_bins)
	real*4 residual(max_bins)
	integer*2 imap(maxpar)
	common /fitcom/ bins,weight,residual,
     &	total1,nfit,iflag,imap,npar
c	-----------------------------

	parameter(max_exp=6)
	REAL*4 SLTJJ(36),par(max_exp*2)
	real*4 par_mapped(maxpar)
	real*4 par_se(max_exp*2),par_se_mapped(max_exp*2)

        PARAMETER (IPRINT=2,ITMAX=31000,NUMSIG=4,NSIGSQ=4,DELTA=1E-16
     &	,NPMAX=200)
	real RMACH(2) /.005,.0001/

	EXTERNAL ExpPdfResidual


	logical new_menu
	character key
	parameter(nFitTypes=2)
	character*30 fit_menu(nFitTypes) /
     &	' Least squares         F1 ',
     &	' Maximum likelihood    F2 ' /

	character*20 par_name(maxpar) /
     &	' Pdf  1  Mean (ms)',
     &	'         Area (%) ',
     &	' Pdf  2  Mean (ms)',
     &	'         Area (%) ',
     &	' Pdf  3  Mean (ms)',
     &	'         Area (%) ',
     &	' Pdf  4  Mean (ms)',
     &	'         Area (%) ',
     &	' Pdf  5  Mean (ms)',
     &	'         Area (%) ',
     &	' Pdf  6  Mean (ms)',
     &	'         Area (%) ' /

	logical fixed(maxpar) / 12*.false. /
	character*44 msg(2)

	integer*2 nexp /1/

	DATA par_se /12*0./
C
C	CODE
C	----
c
	maximum_likelihood = .true.

c
c	Copy histogram into fitting array
c
	j = 0
	do i = iStart,iEnd
	    j = j + 1
	    bins(1,j) = bins_in(1,i)
	    bins(2,j) = bins_in(2,i)
	    bins(3,j) = bins_in(3,i)
	    bins(4,j) = bins_in(4,i)
	    if( cRootY .eq. 'Y' ) bins(4,j) = bins(4,j)*bins(4,j)
	    if( CEventsPerMsec .eq. 'Y' ) bins(4,j) =
     &	    bins(4,j) * ( bins(3,j) - bins(1,j))
	    weight(j) = 1.
	end do
c
c	Note that last bins is excluded from fit because it may
c	contain excess counts which exceed histogram range
c
	nfit = j
	total1 = total
	do while( bins(4,nfit) .le. 0. .and. nfit.gt.1 )
	    nfit = nfit - 1
	end do

c
c	Get number of exps. to fit
c
	r = float(nexp)
	call get_number_box(2,2,' No. of exponentials ',
     &	' (<=6) ',1.,6.,r)
	nexp = int(r)

c
c	Set initial parameter guesses and fixed/variable settings
c
	j = 1
	do iexp = 1,nexp
	    count = 0.
	    xavg = 0.
	    do i = 1,nfit/nexp
		count = count + bins(4,j)
		xavg = xavg + bins(2,j)*bins(4,j)
		j = min(j + 1,nfit)
	    end do
	    par(2*iexp) = (count*100.) / total
	    par(2*iexp-1) = xavg / count
	end do
	npar = 2*nexp

	yscale = 1.
c
c	Choose maximum likelihood or least squares fit
c
	iFitType = Iwait_MENU_VERTICAL1(fit_menu,'12',
     &	nFitTypes,2,5,new_menu,iFitType,' Curve fitting method ',key)
	if( iFitType .eq. 2 ) then
c
c	    Maximum likehihood fit
c
	    maximum_likelihood = .true.
	    total1 = 0. 			! Total no. of events
	    do i = 1,nfit			! in histogram range
		total1 = total1 + bins(4,i)	! being analysed
	    end do
c
c	    Note that the maximum likelihood fit has one less
c	    free parameter than the SSQMIN fit since the area
c	    must add up to 100% (so npar-1 used)
c
	    call InitialiseFit( par, par_name, npar-1, fixed, nvars,
     &	    imap, 2,9, ' Initial parameter settings ' )
	    imap(npar) = npar
	    call ParamNormalisation( par, nexp, 0.01, 1)
	    call MapParameters( par, par_mapped, imap, npar, 1 )
c
c	    Display fitting in progress box
c
	    msg(1) = ' WAIT ... Fitting curve. (ESC to abort) '
	    msg(2) = ' '
	    call display_message(2,21,len(msg(1))+2,msg,2)
	    call move_cursor(3,23)

	    ep = 0.000001
	    call simplex(par_mapped,nvars,iteration,rLikelihood,ep)

	    call MapParameters( par, par_mapped, imap, npar, -1 )
	    call ParamNormalisation( par,nexp,0.01,-1)
c
c	    Calculate chi-square
c
	    chi2 = 0.
	    do i = 1,nfit
		bins(4,i) = bins(4,i) / yscale
		bin_width = bins(3,i) - bins(1,i)
		y = PDFExp(bins(2,i), par, nexp)*total*bin_width*0.01
		if( y .gt. 0. )
     &		 chi2 = chi2 + (bins(4,i)-y)*(bins(4,i)-y)/y
	    end do
c
c	    Report
c
	    l = 0
	    do i = 1,nexp
		 l = l + 1
		 write(report(l),
     &		 '(''Tau='',f8.2,''ms '',
     &		 ''Area='',f8.2,''%'')')
     &		 par(2*i-1),par(2*i)
	    end do
	    l = l + 1

	    pChi2 = chi_prob( chi2,float(nfit-npar))

	    write(report(l),
     &	    '(''LL='',F8.0,
     &	      '' Chi2='',g10.3,
     &	      '' p='',f5.3,
     &	      '' n='',i4,
     &	      '' df='',i4)')
     &	      -rLikelihood,chi2,pchi2,nfit,nfit-npar
	    nrep = l

	else
c
c	    SSQMIN (Levenberg-Marquardt least squares fit)
c
	    total1 = total			! Total number of
	    maximum_likelihood = .false.	! events
	    call InitialiseFit( par, par_name, npar, fixed, nvars,
     &	    imap, 2,9, ' Initial parameter settings ' )

	    call ParamNormalisation( par, nexp, 1., 1)
	    call MapParameters( par, par_mapped, imap, npar, 1 )
c
c	    Display fitting in progress box
c
	    msg(1) = ' WAIT ... Fitting curve. (ESC to abort) '
	    msg(2) = ' '
	    call display_message(2,21,len(msg(1))+2,msg,2)
	    call move_cursor(3,23)

	    CALL SSQMIN(par_mapped,nfit,nvars,ITMAX,IPRINT,
     &	     NUMSIG,NSIGSQ
     &	    ,DELTA,RMACH,WEIGHT,SLTJJ,ICONV,ITER,SSQ,RESIDual,
     &	    ExpPdfResidual,xy)
	    IF(ICONV.ge.0) THEN
C
C		Find error in best fit parameters
C
		do i = 1,nfit
		    xy(i) = bins(4,i)
		end do
		CALL STAT(NFIT,nvars,RESIDual,xy,WEIGHT,SLTJJ,SSQ,
     &		par_se_mapped,SDMIN,RHAM,par_mapped)
	    endif
c
c	    Restore area & tau parameters and s.e.s to actual sizes
c
	    call MapParameters( par, par_mapped, imap, npar, -1 )
	    call ParamNormalisation( par,nexp,1.,-1)

	    call MapParameters(par_se,par_se_mapped,imap,npar,-1)
	    call ParamNormalisation( par_se, nexp, 1., -1)

c
c	    Calculate chi-square
c
	    chi2 = 0.
	    do i = 1,nfit
		bins(4,i) = bins(4,i) / yscale
		bin_width = bins(3,i) - bins(1,i)
		y = PDFExp(bins(2,i), par, nexp)*total*bin_width*0.01
		if( y .gt. 0. )
     &		 chi2 = chi2 + (bins(4,i)-y)*(bins(4,i)-y)/y
	    end do
c
c	    Report
c
	    l = 0
	    do i = 1,nexp
		 l = l + 1
		 write(report(l),
     &		 '(''Tau='',f8.2,'' +/-'',f7.2,''ms '',
     &		 ''Area='',f8.2,'' +/-'',f7.2,''%'')')
     &		 par(2*i-1),par_se(2*i-1),
     &		 par(2*i),par_se(2*i)
	    end do
	    l = l + 1

	    pChi2 = chi_prob( chi2,float(nfit-npar))

	    write(report(l),
     &	    '(''R.S.D.='',F8.2,
     &	      '' Chi2='',g10.3,
     &	      '' p='',f5.3,
     &	      '' n='',i3,
     &	      '' df='',i3)')
     &	      sdmin,chi2,pChi2,nfit,nfit-npar
	end if
	nrep = l

c
c	Create plot of fitted p.d.f. and place in
c	array "xy"
c	xy(1) = No. of plots
c	xy(2) = No. of points in each plot = "nbins"
c	xy(3),xy(4) .... x,y plotting values
c
c
	xy(1) = 1.
	xy(2) = float(nbins)
	j = 3
	do i = 1,nbins
	    bin_width = (bins_in(3,i) - bins_in(1,i))
	    xy(j) = bins_in(2,i)
	    xy(j+1) = PDFExp(xy(j), par, nexp)*total*bin_width*0.01

	    if( cRootY .eq. 'Y' ) xy(j+1) = SafeSqrt( xy(j+1) )
	    if( cEventsPerMsec .eq. 'Y' ) xy(j+1) = xy(j+1) / bin_width

	    j = j + 2
	end do

	return
	end

	SUBROUTINE ExpPdfResidual(par_mapped,npfit,nVar,resid)
C
C	This subroutine calculates the residuals for
C	SSQMIN. It contains the equations specifying
C	the exponential curves to be fitted.
C
	real*4 par_mapped(1)	    ! Parameters supplied for test
				    ! by SSQMIN (In)
	integer*2 npfit 	     ! No. of data points (In)
	integer*2 nVar		    ! No. of variable parameters in
				    ! par_mapped (In)
	real*4 resid(1) 	    ! Residuals (Out)

	parameter(max_bins=512,maxpar=12)
	real*4 bins(4,max_bins)
	real*4 weight(max_bins)
	real*4 residual(max_bins)
	integer*2 imap(maxpar)
	common /fitcom/ bins,weight,residual,
     &	total1,nfit,iflag,imap,npar

	parameter(max_exps=6)
	real*4 par(maxpar)
C
C	CODE
C	----

	nexp  = npar/2
	call MapParameters( par, par_mapped, imap, npar, -1 )
	call ParamNormalisation( par, nexp, 1., -1)
c
c	Display trial values of tau and area
c

	do i = 1,nfit
	    bin_width = (bins(3,i) - bins(1,i))
	    y = PDFExp(bins(2,i),par,nexp )*total1*bin_width*0.01
	    resid(i) = bins(4,i) - y
	end do
	return
	end

	real*8 function rlog_likelihood(par_mapped,nvars)
	real*4 par_mapped(1)
c
c	Sum of squares function for maximum likelihood calculation
c	(called by SIMPLEX)

	parameter(max_bins=512,maxpar=12)
	real*4 bins(4,max_bins)
	real*4 weight(max_bins)
	real*4 residual(max_bins)
	integer*2 imap(maxpar)
	common /fitcom/ bins,weight,residual,
     &	total1,nfit,iflag,imap,npar

	real*4 par(maxpar)
	real*8 f
c
c	code
c

	nexp  = npar/2
c
c	Recover parameters from compressed set
c

	call MapParameters( par, par_mapped, imap, npar-1, -1 )
	call ParamNormalisation(par,nexp,1.,-1)

c	pdf. parameters stored as
c	par(1), par(3), .... taus
c	par(2), par(4), .... areas (as %)

c	The last parameter par(npar) is the area of the last
c	exponential (nexp). It is a function of the other areas
c	to ensure that all the area parameters add up to 1.
c
	par(npar) = 1.
	do iarea = 2,npar-1,2
	    par(npar) = par(npar) - par(iarea)
	end do
	par_mapped(npar) = par(npar)
c
c	If any areas are negative, return a large SSQ to push
c	the simplex away from this point
c
	do iarea = 2,npar,2
	    if( (par(iarea).lt.0.) .or. (par(iarea).gt.1.) ) then
		rlog_likelihood = 1E10
		return
	    end if
	end do

c
c	Calculate probabilty of events excluded from histogram
c
	tlo = bins(1,1)
	thi = bins(3,nfit)
	plo = 0.
	phi = 0.
	do i = 2,npar,2
	    phi  = phi + par(i)*SafeExp(thi,par(i-1))
	    plo  = plo + par(i)*SafeExp(tlo,par(i-1))
	end do
	ptl = plo-phi

c
c	Calculate log-likelihood
c
	f = 0.
	do i = 1,nfit
	    pHi = PDistFExp( bins(3,i), par, nexp )
	    pLo = PDistFExp( bins(1,i), par, nexp )
	    f = f - dble((log(max((pLo-pHi)/ptl,1E-9)) )*bins(4,i))
	end do

	rlog_likelihood = f
	return
	end


	real*4 function PDFExp( x, par, nexp )
	real*4 par(1)

	y = 0.
	do i = 1,nexp
	    tau = par(2*i-1)
	    if( tau .ne. 0. ) then
		area = par(2*i)
		y = y + (area/tau)*SafeExp(x,tau)
	    end if
	end do
	PDFExp = y
	return
	end

	real*4 function PDistFExp( x, par, nexp )
	real*4 par(1)

	y = 0.
	do i = 1,nexp
	    tau = par(2*i-1)
	    if( tau .ne. 0. ) then
		area = par(2*i)
		y = y + area*SafeExp(x,tau)
	    end if
	end do
	PDistFExp = y
	return
	end

	subroutine ParamNormalisation(par,nexp,yscale,iflag)
	real*4 par(1)
	integer*2 iflag

	j = 1
	tmult = 10.
	do i = 1,nexp

	    if( iflag .eq. 1 ) then
		par(j+1) = par(j+1)*yscale
		par(j) = par(j)/tmult
	    else
		par(j) = abs(par(j)*tmult)
		par(j+1) = par(j+1)/yscale
	    end if

	    j = j + 2
	    tmult = tmult*10.

	end do
	return
	end

	real*4 function SafeExp( x, tau )

	if( tau .gt. 0. ) then
	    SafeExp = exp(-min(x/abs(tau),20.))
	else
	    SafeExp = 0.
	end if
	return
	end

	subroutine fit_gaussians(bins_in,imin,imax,xy)
$INCLUDE: 'PATCOM.FOR'
C
c	Fit 1-4 Gaussian curves to current amplitude distribution
c	---------------------------------------------------------
c	Gaussian is defined by : y = A*exp(-(x-XM)^2)/(2*VAR))
c	where A is amplitude, XM is mean, VAR is variance
C	The SSQMIN non-linear least squares routine is used
C
c	Enter with:
c	bins = array containing histogram values
c	imin,imax = range of entries in "bins" to be used in fit
c	title = title of histogram
c	Returns:
	real*4 xy(1)		! (Out) Best fitting lines
				! Also used as work array by SSQMIN
	real*4 bins_in(4,1)

	parameter(max_bins=512,maxpar=12)
	real*4 bins(4,max_bins)
	real*4 weight(max_bins)
	real*4 residual(max_bins)
	integer*2 imap(maxpar)
	common /fitcom/ bins,weight,residual,
     &	total1,nfit,iflag,imap,npar

	parameter(maxg=4)

	real xmean(maxg),sdev(maxg),area(maxg),peak(maxg),
     &	xmean_se(maxg),sdev_se(maxg),area_se(maxg)
     &	,par(maxpar),par_mapped(maxpar),se(maxpar),se_mapped(maxpar)
     &	,sltjj(100),rmach(2)

	parameter(max_iteration=200,nsig_pars=5,nsig_ssq=5,delta=1E-16
     &	,sig=6. )

	EXTERNAL GaussianResiduals

	character*20 par_name(maxpar) /
     &	' Peak 1 Mean (pA)',
     &	'        S.D. (pA)',
     &	'        Peak (%)',
     &	' Peak 2 Mean (pA)',
     &	'        S.D. (pA)',
     &	'        Peak (%)',
     &	' Peak 3 Mean (pA)',
     &	'        S.D. (pA)',
     &	'        Peak (%)',
     &	' Peak 4 Mean (pA)',
     &	'        S.D. (pA)',
     &	'        Peak (%)' /

	integer*2 ngaus /1/
	character*44 msg(2)


	logical fixed(maxpar) / 12*.false. /

C
C	CODE
C	----
C
c	Get number of Gaussians to fit
c
	r = float(ngaus)
	call get_number_box(2,2,' No. of Gaussians ',
     &	' (<=4) ',1.,6.,r)
	ngaus = int(r)
	npar = ngaus*3

	ymax = -1E30
	nfit = 0
	do i = imin,imax
	    nfit = nfit + 1
	    do j = 1,4
		bins(j,nfit) = bins_in(j,i)
	    end do
	    weight(nfit) = 1.
	    ymax = max(bins_in(4,i),ymax)
	end do
	xmin = bins(1,1)
	xmax = bins(3,nfit)

	k = 1
	do i = 1,ngaus
	    xmean(i) = 0.
	    peak(i) = 0.
	    count = 0.
	    k0 = k
	    do j = 1,nfit/ngaus
		xmean(i) = xmean(i) + bins(2,k)*bins(4,k)
		count = count + bins(4,k)
		if( bins(4,k) .gt. peak(i) ) peak(i) = bins(4,k)
		k = k + 1
	    end do
	    xmean(i) = xmean(i) / count
	    sdev(i) = (bins(2,k-1) - bins(2,k0))/6.

	    j = 3*i-2
	    par(j) = xmean(i)
	    par(j+1) = sdev(i)
	    par(j+2) = peak(i)
	end do

	call InitialiseFit( par, par_name, npar, fixed, nvars,
     &	imap, 2,5, ' Initial parameter settings '  )
c
c	Display fitting in progress box
c
	msg(1) = ' WAIT ... Fitting curve. (ESC to abort) '
	msg(2) = ' '
	call display_message(2,21,len(msg(1))+2,msg,2)
	call move_cursor(3,23)

C
C	Copy histogram to fitting data buffers
C	and scale YDATA to lie in same range as XDATA
C
	yscale = max(abs(xmax),abs(xmin))/ymax
	do i = 1,nfit
	    bins(4,i) = bins(4,i)*yscale
	end do

C
C	Scale parameters
C
	call GaussianNormalisation(par,ngaus,yscale,1)
	call MapParameters( par, par_mapped, imap, npar, 1 )

C
C -- Find best fit parameters -------------------------------------
C
	IF(NVARS.GT.0) THEN
	    RMACH(1) = 5.0*10.0 **(-SIG+3)
	    RMACH(2) =10.0 **(-(SIG/2)-1)

	    CALL SSQMIN(PAR_MAPPED,NFIT,NVARS,MAX_ITERATION
     &	    ,1,NSIG_PARS,NSIG_SSQ,DELTA,RMACH,WEIGHT
     &	    ,SLTJJ,ICONV,ITERATION,SUM_SQUARES,RESIDUAL
     &	    ,GaussianResiduals,xy)


	    IF(ICONV.gt.0) THEN
C
C --		Find S.E. of best fit parameters
C
		do i = 1,nfit
		    xy(i) = bins(4,i)
		end do
		CALL STAT(NFIT,NVARS,RESIDUAL,xy,WEIGHT,SLTJJ
     &		,SUM_SQUARES,SE_MAPPED,RESIDUAL_SD,rham,PAR_MAPPED)

	    endif
	ENDIF
C
C	Copy fitted parameters from PAR_MAPPED to PAR
C	and re-scale back to normal

	call MapParameters( par, par_mapped, imap, npar, -1 )
	call GaussianNormalisation(par,ngaus,yscale,-1)
	call MapParameters( se, se_mapped, imap, npar, -1 )
	call GaussianNormalisation(se,ngaus,yscale,-1)
	RESIDUAL_SD = RESIDUAL_SD/YSCALE

	do i = 1,ngaus
	    j = 3*i-2
	    xmean(i) = par(j)
	    sdev(i) = par(j+1)
	    peak(i) = par(j+2)
	end do
c
c	Calculate chi-square
c
	chi2 = 0.
	do i = 1,nfit
	    bins(4,i) = bins(4,i) / yscale
	    y = Gaussian(bins(2,i),xmean,sdev,peak,ngaus)
	    if( y .gt. 0. )
     &	     chi2 = chi2 + (bins(4,i)-y)*(bins(4,i)-y)/y
	end do
	pChi2 = chi_prob( chi2,float(nfit-npar))

C
C	
C	Create gaussian function plot with best fit parameters
C
	xy(1) = 1.
	xy(2) = float(nfit)
	j = 3
	do i = 1,nfit
	    xy(j) = bins(2,i)
	    xy(j+1) = Gaussian(xy(j),xmean,sdev,peak,ngaus)
	    j = j + 2
	end do

	bin_width = bins(3,1) - bins(1,1)
	DO IG = 1,NGAUS
	    K = 3*IG
	    XMEAN(IG) = PAR(K-2)
	    XMEAN_SE(IG) = SE(K-2)
	    SDEV(IG) = abs(PAR(K-1))
	    SDEV_SE(IG) = ABS(se(K-1))
	    AREA(IG) = PAR(K)*par(k-1)*SQRT(6.2831)/bin_width
	    AREA_SE(IG) = SE(K)*par(k-1)*SQRT(6.2831)/bin_width
	end do


	l = 0
	do i = 1,ngaus
	     l = l + 1
	     write(report(l),
     &	     '(''Peak '',i1,'' Mean='',f6.2,''pA S.D.='',f5.3
     &	     ,''pA Area='',f6.2,''%'')') i,xmean(i),sdev(i),area(i)
	     l = l + 1
	     write(report(l),
     &	     '(''(s.e.)      '',f6.3,8X,f5.3
     &	     ,8X,f6.3)') xmean_se(i),sdev_se(i),area_se(i)
	end do
	    l = l + 1
	    write(report(l),
     &	    '(''R.S.D.='',F8.3,
     &	      '' Chi2='',f9.1,
     &	      '' p='',f6.4,
     &	      '' n='',i3,
     &	      '' df='',i3)')
     &	      residual_sd,chi2,pChi2,nfit,nfit-npar
	nrep = l

	RETURN
	END

	SUBROUTINE GaussianResiduals(PAR_mapped,NP,NVAR,RES)
$include:'patcom.for'
C
C -- CALCULATE RESIDUALS (YDATA - YFIT) FOR GAUSSIAN FUNCTION
C	PAR : PARAMETERS FOR EQUATION, NP : NO. OF DATA POINTS
C 	NVAR : NO. OF VARIABLE PARAMETERS, RESIDUAL : ARRAY OF RESIDUALS
C -------------------------------------------------------------------
C
	REAL PAR_mapped(1),RES(1)
c
c	Data to be fitted supplied in xdata and ydata
c	through iwork common area in patcom

	parameter(maxg=4)
	real*4 xmean(maxg),sdev(maxg),peak(maxg)

	parameter(max_bins=512,maxpar=12)
	real*4 bins(4,max_bins)
	real*4 weight(max_bins)
	real*4 residual(max_bins)
	integer*2 imap(maxpar)
	common /fitcom/ bins,weight,residual,
     &	total1,nfit,iflag,imap,npar

	real*4 par(maxpar)


C
C -- CODE
C
	ngaus = npar/3
	call MapParameters( par, par_mapped, imap, npar, -1 )

	do i = 1,ngaus
	    j = 3*i-2
	    xmean(i) = par(j)
	    sdev(i) = par(j+1)
	    peak(i) = par(j+2)
	end do

	do i = 1,np
	    res(i) = bins(4,i) -
     &	    Gaussian(bins(2,i),xmean,sdev,peak,ngaus)
	end do
	return
	end

	subroutine GaussianNormalisation(par,ngaus,yscale,iflag)
	real*4 par(1)
	integer*2 iflag

	do i = 1,ngaus
	    j = 3*i-2
	    if( iflag .eq. 1 ) then
		par(j+1) = abs(par(j+1))
		par(j+2) = abs(par(j+2))*yscale
	    else
		par(j+1) = abs(par(j+1))
		par(j+2) = abs(par(j+2))/yscale
	    end if
	end do
	return
	end

	real*4 function Gaussian( x, xmean, sd, peak, ngaus )
c
c	Sum of gaussian p.d.f.s
c
	real*4 x	    !(In) independent variable
	real*4 xmean(1)     !(In) Mean value
	real*4 sd(1)	    !(In) standard deviation
	real*4 peak(1)	    !(In) peak
	integer*2 ngaus     !(In) No. of gaussians

	sum = 0.
	do ig = 1,ngaus
	    var = sd(ig)*sd(ig)
	    z = x - xmean(ig)
	    sum = sum + abs(peak(ig))*exp( -min(z*z/(2.*var),20.) )
	end do
	Gaussian = sum
	return
	end


	subroutine InitialiseFit( par, par_name, npar, fixed, nvar,
     &	imap, ileft,itop, title )
$include:'patcom.for'
c
c	Set initial guesses for equation parameters
c	and determine whether they are fixed or variable
c
	real*4 par(npar)	! Parameter array (In)
	character*(*) par_name(npar) ! Name of parameter (In)
	integer*2 npar		! No of parameter (In)
	logical fixed(npar)	! T = fixed, F = variable parameter
	integer*2 nvar		! No. of variable parameters
	integer*2 imap(npar)
	integer*2 ileft,itop	! Top/left of box (In)
	character*(*) title	! Box title

	logical quit
	character*12 string
	character key
c
c	code
c

	iright = ileft + len( par_name(1) ) + 26
	ibottom = itop + npar + 5
	call erase_box(ileft,itop,iright,ibottom)
	call display_box(ileft,itop,iright,ibottom)
	call move_cursor(ileft+1,itop)
	call display_string( title )

	call move_cursor(ileft+1,ibottom-1)

	call set_text_colour( iscreen, 2 )
	call move_cursor(ileft+1,ibottom-3)
	CALL DISPLAY_STRING(' '//
     &	char(1)//' '//char(2)//' to select parameter field')
	call move_cursor(ileft+1,ibottom-2)
	CALL DISPLAY_STRING(' Press Tab key to change Fixed/Variable ')
	call move_cursor(ileft+1,ibottom-1)
	CALL DISPLAY_STRING(' Press Return when to begin fitting ')
	call set_text_colour( iscreen, 1 )

	quit = .false.
	ipar = 1
	do while( .not. quit )

	    do i = 1,npar
		call move_cursor(ileft+1,itop+i)
		call display_string( par_name(i) )
		write( string, '(1pg12.3)' ) par(i)
		call display_string( string )
		if( fixed(i) ) then
		    call display_string( ' Fixed   ' )
		else
		    call display_string( ' Variable' )
		end if
	    end do

	    call move_cursor( ileft + len(par_name(1)) + 1,itop+ipar)
	    write( string, '(1pg12.3)' ) par(ipar)
	    call get_string( string, nc, key )
	    read( string, fmt='(f12.0)',err=10 ) par(ipar)
10	    continue
	    if( key .eq. char(9) ) fixed(ipar) = .not. fixed(ipar)

	    if( key .eq. 'U' ) ipar = max(ipar-1,1)
	    if( key .eq. 'D' ) ipar = min(ipar+1,npar)
	    if( key .eq. '$' .or. key .eq. char(13) ) quit = .true.

	end do

	nvar = 0
	ifix = npar
	do ipar = 1,npar
	    if( fixed(ipar) ) then
		imap(ipar) = ifix
		ifix = ifix - 1
	    else
		nvar = nvar + 1
		imap(ipar) = nvar
	    end if
	end do
	return
	end

	subroutine MapParameters(par,par_mapped,imap,npar,iDirection)
c
c	Copy parameters to/from compressed array
c
	real*4 par(npar)
	real*4 par_mapped(npar)
	integer*2 imap(npar)
	integer*2 iDirection

c      code

	do ipar = 1,npar
	    if( IDirection .eq. 1 ) then
		par_mapped(imap(ipar)) = par(ipar)
	    else
		par(ipar) = par_mapped(imap(ipar))
	    end if
	end do

	return
	end

