	subroutine file_conversion
$include:'patcom.for'
c
c	Convert SES data format to/from data files of other
c	electrophysiology programs
c	12/1/96 V7.1 Fix for pClamp_to_PAT error when reading large files
c		     (*** Not tested ***)
c       8/5/96 ... V7.1a User can now set scale factor in ASCII_TO_PAT
c       27/3/97 ... V7.3 pclamp V6 import scaling fixed
c       1/12/97 ... V7.4 ASCII import from current only data file
c	8/12/97 ... V7.4a Scaling factor corrected
c	7/12/98 ... V7.4 Large pClamp V5 files can now be imported
c			 and signal amplitude scaling has been corrected
c
	parameter(nmenu = 7,istatus_left=59)
	character*28 menu(nmenu) /
     &	' PAT V6  to  PAT V7  F1',
     &	' WCP     to  PAT     F2',
     &	' pCLAMP  to  PAT     F3',
     &	' PAT     to  pCLAMP  F4',
     &	' ASCII   to  PAT     F5',
     &	' PAT     to  ASCII   F6',
     &	' Exit               ESC' /

	logical new_menu
	character key

c
c	code
c
	new_menu = .true.
	key = ' '

	iop = Iwait_MENU_VERTICAL1(menu,'123456$',nmenu
     &	,3,3,new_menu,iop,' File Conversion ',key)

	select case (iop)
	case(1)
	    call oldpat_to_pat( 26, 3	  )
	case(2)
	    call wcp_to_pat( 26, 3 )
	case(3)
	    call pclamp _to_pat( 26, 3 )
	case(4)
	    call pat_to_pclamp( 26, 3 )
	case(5)
	    call ascii_to_pat( 26, 3 )
	case(6)
	    call pat_to_ascii( 26, 3 )
	end select
	return
	end

	subroutine oldpat_to_pat( ileft, itop )
$include:'patcom.for'
c
c	Convert old .PAT (V6 and earlier) to PAT V7
c
	character*12 new_file_name / ' ' /
	parameter(max_files=500)
	character*52 path / ' ' /
	character*12 files(max_files)
	equivalence( iwork, files )

	structure /oldpatcom/
	union
	map
	integer*2 buf(256)
	end map
	map
	integer*2 n_records
	integer*2 nbreqd
	real*4 timreq
	integer*2 nblock
	character*78 cell
	integer*2 irate
	real*4 dt
	real*4 bit_current
	real*4 range_volts
	real*4 gain
	integer*2 nstate
	integer*2 iunit
	integer*2 ibase
	end map
	end union
	end structure

	record /oldpatcom/ header

	parameter(np_old_event=8)
	structure /oldpat_event/
	union
	map
	integer*2 buf(16)
	end map
	map
	integer*2 istate
	integer*2 ibase
	integer*2 irecord
	integer*2 iend
	integer*4 count32
	real*4 avg_current
	end map
	end union
	end structure

	record /oldpat_event/ OldEvent
	record /event_record/ Event

	integer*4 n_events_in,n_records_in,ib

	character key

c
c	code
c

	call create_path( path, default_path, '*.pat', '.pat' )
	call files_menu(path,0,new_file_name,ileft,itop,10,
     &	files,max_files)

	if( new_file_name .ne. ' ' ) then
c
c	    Open old PAT data file
c
	    call create_path(path,default_path,new_file_name,'.pat')
	    open(unit=itemp_file,
     &	    file=path,
     &	    form='binary',
     &	    access='direct',
     &	    iostat=istat,
     &	    recl=512)
c
c	    Open .SCD file with same name
c
	    call create_path(file_name,default_path,new_file_name,
     &	    '.scd')
	    call get_file_name(2,itop+12,
     &	    file_name,'.scd','NEW',' Create file? ',iflag)
	    if( iflag .eq. -1 ) then
		close(unit=itemp_file)
		return
	    end if
c
c	    Open data file

	    np_record = 512
	    call open_data_file

c
c	    Get header block and extract parameters
c
	    read(unit=itemp_file,rec=1,iostat=istat) header.buf
	    dt = header.dt
	    y_scale(1) = header.bit_current
	    y_units(1) = 'pA'
	    gainIm = header.gain
	    ScaleIm = header.bit_current
	    gainVm = 1.
	    adc_range = header.range_volts
	    iUnit = header.iunit
	    iBase = header.ibase
	    np_record = 512
	    n_records_in = header.n_records
	    n_events_in = header.nstate

	    call write_to_log( 'Import from '//path )

	    ib = 0
	    n_records = 0
	    key = 'S'
	    do while( key .ne. '$' )
c
c		Read from old PAT file
c
		ib = ib + 2
		read(unit=itemp_file,rec=ib)
     &		(iBuf(i),i=1,np_record)
c
c		Write to new SCD file
c
		n_records = n_records + 1
		write(unit=idata_file,rec=n_records+idata_offset)
     &		(iBuf(i),i=1,np_record)

		call display_progress( 2, 20,
     &		' Records done (ESC to abort) ',
     &		n_records,n_records_in,key)

		if( n_records .ge. n_records_in ) key = '$'
	    end do
	    np_file = n_records*np_record

c
c	    Read and translate event list
c

	    n_events = 0
	    if( n_events_in .ne. 0 ) then

		key = ' '
		ib = n_records_in*2 + 1
		do while( key .ne. '$' )
c
c		    Read event list from old PAT file
c
		    ib = ib + 1
		    read(unit=itemp_file,rec=ib,err=101)
     &		    (iBuf(i),i=1,256)
101		    continue

		    j = 1
		    nevents_per_block = 256 / np_old_event
		    do iev = 1,nevents_per_block

			do i = 1,np_old_event
			    OldEvent.buf(i) = iBuf(j)
			    j = j + 1
			end do

			Event.level = OldEvent.istate
			Event.zero = ibase
c
c			Start/end of event in data file
c
			Event.end = (OldEvent.irecord-1)*np_record
     &				    + OldEvent.iend
			Event.start = Event.end -
     &				      OldEvent.count32 + 1
c
c			Event duration
c
			Event.dwell_time = float(OldEvent.count32)*dt
c
c			Start/end of display window
c
			Event.DisplayStart = Event.start - np_record/10
			Event.DisplayStart = max(Event.DisplayStart,1)
			Event.DisplayEnd = Event.start + np_record - 1
			Event.DisplayEnd = min(Event.DisplayEnd,np_file)

			Event.average_current = OldEvent.avg_current
			Event.variance = 0.
c
c			Write to event list file (patevent.lst)
c
			n_events = n_events + 1
			if( n_events .eq. 1 ) Event.level = iRejected
			write(unit=iEvent_file,rec=n_events) Event

			call display_progress( 2, 20,
     &			' Events done (ESC to abort) ',n_events,
     &			  n_events_in,key)

		    end do

		    if( n_events .ge. n_events_in ) key = '$'
		end do
c
c		Calculate average current within event
c
		call average_events(2,20,1)
c
c		Save events to end of .SCD file
c
		call save_events( 2, 20 )

	    end if

	    nOverviewSlice = 0
	    call save_header()

	    close(unit=idata_file)
	    close(unit=itemp_file)

	    call write_to_log( 'New file '//file_name )

	end if
	return
	end

	subroutine wcp_to_pat( ileft, itop )
$include:'patcom.for'
c
c	Extract a channel from .WCP data file and
c	place it into PAT .SCD file
c
	character*12 new_file_name / ' ' /
	parameter(max_files=500)
	character*52 path / ' ' /
	character*12 files(max_files)
	equivalence( iwork, files )

	structure /analysis_block/
	union
	map
	integer*2 buf(256)
	end map
	map
	character*8 status
	character*4 type
	real*4 number
	real*4 time
	real*4 dt
	real*4 ad_range
	integer*2 is
	integer*2 ie
	integer*2 iz
	real*4 results(max_channels,17)
	real*4 par(6)
	real*4 se(6)
	real*4 sd
	real*4 f
	real*4 prob
	integer*2 iequation
	end map
	end union
	end structure

	record /analysis_block/ rec

	character*512 header
	equivalence (iBuf,header)

	character key
	character*30 string
	character*6 keyword
	character*30 menu(6)
	logical new_menu
	integer*4 ir,ib,n_records_in

c
c	code
c

	call create_path( path, default_path, '*.wcp', '.wcp' )
	call files_menu(path,0,new_file_name,ileft,itop,10,
     &	files,max_files)

	if( new_file_name .ne. ' ' ) then
c
c	    Open WCP data file
c
	    call create_path(path,default_path,new_file_name,'.wcp')

	    open(unit=itemp_file,
     &	    file=path,
     &	    form='binary',
     &	    access='direct',
     &	    iostat=istat,
     &	    recl=512)

c
c	    Open .SCD data file to receive data
c
	    call create_path( file_name, path, ' ', '.scd' )
	    call get_file_name(2,itop+12,
     &	    file_name,'.scd','NEW',' Create file? ',iflag)
	    if( iflag .lt. 0 ) then
		close(unit=itemp_file)
		return
	    end if
c
c	    Read header block from .WCP file
c
	    read(unit=itemp_file,rec=1,iostat=istat)
     &	    (Ibuf(i),i=1,256)

	    call read_int( 'NC=', header, n_chans )
	    call read_int( 'NBA=', header, nb_analysis )
	    call read_int( 'NBD=', header, nb_data )
	    np_record = (nb_data*256)/max(n_chans,1)
c
c	    Open .SCD data file

            call open_new_data_file

	    call read_flt( 'AD=', header, adc_range )
	    call read_int( 'NR=', header, n )
	    n_records_in = n
	    call read_flt( 'DT=', header, dt )

	    do i = 1,n_chans
		write( keyword,'(''YN'',i1,''='')') i-1
		call read_char( keyword, header, string )
		write( menu(i),'(''Ch. '',i1,1x,a)') i-1,string(1:4)
	    end do
	    ichan = Iwait_MENU_VERTICAL1(menu,'123456',n_chans,
     &	    2,itop+16,new_menu,ichan,' Select Channel ',key)

	    write( keyword,'(''YU'',i1,''='')') ichan-1
	    call read_char( keyword, header, c_units )
	    write( keyword,'(''YS'',i1,''='')') ichan-1
	    call read_flt( keyword, header, ScaleIm )
	    write( keyword,'(''YG'',i1,''='')') i-1
	    call read_flt( keyword, header, gainIm )

	    n_records = 0
	    iVoltageStepStart = 1
	    key = 'S'
	    do ir = 1,n_records_in

		ib = 2 + (ir-1)*(nb_data+nb_analysis)
		read(unit=itemp_file,rec=ib) rec

		if( rec.status .eq. 'ACCEPTED' .and.
     &		    rec.type .ne. 'LEAK' ) then
c
c		    Read in A/D samples
c
		    ib = ib + nb_analysis
		    read(unit=itemp_file,rec=ib)
     &		    (iwork(i),i=1,np_record*n_chans)

		    iVoltageStepStart = rec.iz
c
c		    Extract channel of interest
c
		    j = ichan
		    do i = 1,np_record
			iBuf(i) = iwork(j)
			j = j + n_chans
		    end do
c
c		    Write to .SCD file
c
		    n_records = n_records + 1
		    write(unit=idata_file,rec=n_records+idata_offset)
     &		    (iBuf(i),i=1,np_record)

		    call display_progress( 2, 20,
     &		    ' Records done (ESC to abort) ',n_records,
     &		    n_records_in,key)
	       end if
	    end do
	    np_file = n_records*np_record
	    nOverviewSlice = 0
	    n_events = 0
	    VoltageGatedChannels = .true.
	    call save_header

	    call write_to_log( 'Import from '//path )
	    call write_to_log( 'New file '//file_name )

	end if
	return
	end

	subroutine pclamp_to_pat( ileft, itop )
$include:'patcom.for'
c
c	Convert a pCLAMP binary data file into an SES file
c
c	7/12/98 ... Large pCLAMP V5 files now read correctly
c
c	pCLAMP data file header format
c
	structure /pclamp5/
	union
	map
	integer*2 header(512)
	end map
	map
	real*4 par(80)
	character*77 comment
	character*80 labels
	character*35 reserved
	character*64 pulse
	real*4 par_ext(16)
	real*4 adc_offset(16)
	real*4 adc_gain(16)
	real*4 adc_amplification(16)
	real*4 adc_shift(16)
	character*8 units(16)
	end map
	end union
	end structure

	record /pclamp5/ pc5
	equivalence( pc5, iwork )

	structure /pclamp6/
	union
	map
	integer*2 header(1024)
	end map
	map
	character*4 FileType
	real*4 FileVersionNumber
	integer*2 OperationMode
	integer*4 ActualAcqLength
	integer*2 NumPointsIgnored
	integer*4 ActualEpisodes
	integer*4 FileStartDate
	integer*4 FileStartTime
	integer*4 StopwatchTime
	real*4 HeaderVersionNumber
	integer*2 nFileType
	integer*2 MSBinFormat
	integer*4 DataSectionPtr
	integer*4 TagSectionPtr
	integer*4 NumTagEntries
	integer*4 LongDescriptionPtr
	integer*4 LongDescriptionLines
	integer*4 DACFilePtr
	integer*4 DACFileNumEpisodes
	character*4 Unused
	integer*4 DeltaArrayPtr
	integer*4 NumDeltas
	integer*4 NoteBookPtr
	integer*4 NotebookManEntries
	integer*4 NotebookAutoEntries
	integer*4 SynchArrayPtr
	integer*4 SynchArraySize
	character*20 Unused100

	integer*2 ADCNumChannels
	real*4 ADCSampleInterval
	real*4 ADCSecondSampleInterval
	real*4 SynchTimeUnit
	real*4 SecondsPerRun
	integer*4 NumSamplesPerEpisode
	integer*4 PreTriggerSamples
	integer*4 EpisodePerRun
	integer*4 RunsPerTrial
	integer*4 NumberOfTrials
	integer*2 AveragingMode
	integer*2 UndoRunCount
	integer*2 FirstEpisodeInRun
	real*4 TriggerThreshold
	integer*2 TriggerSource
	integer*2 TriggerAction
	integer*2 TriggerPolarity
	real*4 ScopeOutputInterval
	real*4 EpisodeStartToStart
	real*4 RunStartToStart
	real*4 TrialStartToStart
	integer*4 AverageCount
	character*6 Unused194
	integer*2 DrawingStrategy
	integer*2 TiledDisplay
	integer*2 nEraseStrategy
	integer*2 DataDisplayMode
	integer*4 DisplayAverageUpdate
	integer*2 ChannelStatsStrategy
	integer*4 CalculationPeriod
	integer*4 SamplesPerTrace
	integer*4 StartDisplayNum
	integer*4 FinishDisplayNum
	integer*2 MultiColor
	integer*2 ShowPNRawData
	character*10 Unused234
	real*4 ADCRange
	real*4 DACRange
	integer*4 ADCResolution
	integer*4 DACResolution
	integer*2 ExperimentType
	integer*2 AutosampleEnable
	integer*2 AutosampleADCNum
	integer*2 AutosampleInstrument
	real*4 AutosampleAdditGain
	real*4 AutosampleFilter
	real*4 AutosampleMembraneCap
	integer*2 ManualInfoStrategy
	real*4 CellD1
	real*4 CellD2
	real*4 CellD3
	character*16 CreatorInfo
	character*56 FileComment
	character*12 Unused366

	integer*2 ADCPtoLChannelMap(16)
	integer*2 ADCSamplingSeq(16)
	character*10 ADCChannelname(16)
	character*8 ADCUnits(16)
	real*4 ProgrammableGain(16)
	real*4 DisplayAmplification(16)
	real*4 DisplayOffset(16)
	real*4 InstrumentScaleFactor(16)
	real*4 InstrumentOffset(16)
	real*4 SignalGain(16)
	real*4 SignalOffset(16)
	real*4 SignalLowPassFilter(16)
	real*4 SignalHighPassFilter(16)
	end map
	end union
	end structure

	record /pclamp6/ pc6
        equivalence( pc6, iwork )

	character*50 new_file_name / ' ' /
	parameter(max_files=500)
	character*52 path / ' ' /
	character*12 files(max_files)
	equivalence( iwork, files )

	character key
	logical pClampV6,pClampV5

	integer*4 ir,n_points_in,n_records_in,iblock,ifirst_block,np
	integer*4 nb
	character*4 fVersion
	character*5 fType

c
c	code
c

	call create_path( path, default_path, '*.dat', '.dat' )
	call files_menu(path,0,new_file_name,ileft,itop,10,
     &	files,max_files)

	if( new_file_name .ne. ' ' ) then
c
c	    Open pCLAMP data file
c
	    call create_path(path,default_path,new_file_name,'.dat')
	    open(unit=itemp_file,
     &	    file=path,
     &	    form='binary',
     &	    access='direct',
     &	    iostat=istat,
     &	    recl=512)

	    call write_to_log( 'Import from '//path )

c
c	    Load header information from pCLAMP header file
c
	    read(unit=itemp_file,rec=1,iostat=istat)
     &      (pc6.header(i),i=1,1024)
                                              
c
c	    Determine whether this is a pClamp V5 or V6 file
c
	    pClampV5 = .false.
	    pClampV6 = .false.
	    if( pc5.par(1) .eq. 1. .or.
     &		pc5.par(1).eq.10. ) pClampV5 = .true.
	    if( pc6.FileType .eq. 'ABF' .or.
     &		pc6.FileType .eq. 'CPLX' .or.
     &		pc6.FileType .eq. 'FTCX' ) pClampV6 = .true.

	if (pclampv5 .eqv. .true.) call write_to_log('pclamp V5')
	if (pclampv6 .eqv. .true. ) call write_to_log('pclamp V6')

	    if( pClampV5 ) then
c
c		pClamp V5 data file
c
		fVersion = ' V5'
		if( pc5.par(1) .eq. 1. ) then
		    fType = 'CLPX'
		elseif( pc5.par(1) .eq. 10. ) then
		    fType = 'FTCX'
		else
		    fType = '??'
		end if

		n_channels_in = int(pc5.par(2))
		n_points_in = int4(pc5.par(3))* int(pc5.par(4))

                if( int(pc5.par(4)) .eq. 1 ) then
		    VoltageGatedChannels = .false.
		else
		    VoltageGatedChannels = .true.
		end if

                dt = (pc5.par(5)*n_channels_in)/1000.
		adc_range = pc5.par(53)

		ADCScale = (2.**pc5.par(55))/4096.

		cell = pc5.comment
c
c		Channel scaling/units information
c		(pCLAMP gain factor Volts/units converted to
c		WCP gain factor mV/units. Note how pCLAMP's
c		starting A/D channel number obtained from pc.par(32) )
c
		ipc_chan = int ( pc5.par(32) ) + 1
		gainIm = pc5.adc_gain(ipc_chan)
     &			 *pc5.adc_amplification(ipc_chan)*1000.0

		if (pc5.par(42) .ne. 0) then
		    gainIm = gainIm * pc5.par(40)
		end if

		ibase = 2048
		y_units(1) = pc5.units(ipc_chan)
		ScaleIm = convert_gain( GainIm )
		ifirst_block = 3

	    end if

	    if( pClampV6 ) then
c
c		pClamp V6 data file
c
		fType = pc6.FileType
		fVersion = ' V6'

		n_channels_in = pc6.ADCNumChannels
                n_points_in = pc6.ActualAcqLength 

                dt = (pc6.ADCSampleInterval*n_channels_in)/1000.
		adc_range = pc6.ADCRange
		ADCScale = (2.*pc6.ADCResolution) / 4096.
		cell = pc6.FileComment

		if( pc6.ActualEpisodes .eq. 1 ) then
		    VoltageGatedChannels = .false.
		else
		    VoltageGatedChannels = .true.
		end if
c
c		Channel scaling/units information
c		(pCLAMP gain factor Volts/units converted to
c               PAT gain factor mV/units.
c
		ipc_chan = pc6.ADCSamplingSeq(1) + 1
		gainIm = pc6.InstrumentScaleFactor(ipc_chan)
     &			 * pc6.SignalGain(ipc_chan) * 1000.

                if( (pc6.AutoSampleADCNum .eq. (ipc_Chan-1))
     &              .and. (pc6.AutoSampleEnable .ne. 0 ) ) then
                    gainIm = gainIm * pc6.AutosampleAdditGain
                end if

                if( gainIm .eq. 0. ) gainIm = 1.
 
		ibase = 2048
		y_units(1) = pc6.ADCUnits(ipc_chan)
		ScaleIm = convert_gain( GainIm )
		ifirst_block = 5

	    end if

c
c	    Create a new PAT data file to hold converted data
c
	    if( pClampV6 .or. pClampV5 ) then
		call create_path(new_file_name,path,' ','.scd')
		call get_file_name(3,13,new_file_name,'.scd','NEW',
     &		' Copy to file ',iflag)
	    else
		iflag = -1
		call Report_Error(2,24,'Unknown file format')
	    end if

	    if( iflag .ge. 0 ) then

		file_name = new_file_name
                np_record = 512

                call open_new_data_file

                np = np_record*n_channels_in
		nb = np/256
		n_records = 0
		n_records_in = n_points_in / np

		key = 'S'
		do ir = 1,n_records_in

		    iblock = (ir-1)*nb + ifirst_block
		    read(unit=itemp_file,
     &			 rec=iblock,
     &			 iostat=istat,
     &			 err=101)
     &			 (iBuf(i),i=1,np)

		    j = 1
		    do i = 1,np,n_channels_in
			iwork(j) = int(float(iBuf(i)/ADCScale)) +2048
			j = j + 1
		    end do

		    n_records = n_records + 1

		    write( unit=1, rec=n_records+idata_offset )
     &		    (iWork(i),i=1,np_record)

		    call display_progress( 3, 20,
     &		    fVersion//fType//' Records (ESC to abort) ',
     &		    ir,n_records_in,key)

		    iblock = iblock + np/256

		    if( key .eq. '$' )	goto 101

		end do
101		continue

		np_file = n_records * np_record
		n_events = 0
		nOverviewSlice = 0
		call save_header

		call write_to_log( 'New file '//file_name )
	    end if

	    close(unit=itemp_file)
	    close(unit=idata_file)

	end if
	return
	end

	subroutine pat_to_pclamp( ileft, itop )
$include:'patcom.for'
c
c	Convert a PAT .SCD file into a pCLAMP V6 .DAT file
c
c
	structure /pclamp6/
	union
	map
	integer*2 header(1024)
	end map
	map
	character*4 FileType
	real*4 FileVersionNumber
	integer*2 OperationMode
	integer*4 ActualAcqLength
	integer*2 NumPointsIgnored
	integer*4 ActualEpisodes
	integer*4 FileStartDate
	integer*4 FileStartTime
	integer*4 StopwatchTime
	real*4 HeaderVersionNumber
	integer*2 nFileType
	integer*2 MSBinFormat
	integer*4 DataSectionPtr
	integer*4 TagSectionPtr
	integer*4 NumTagEntries
	integer*4 LongDescriptionPtr
	integer*4 LongDescriptionLines
	integer*4 DACFilePtr
	integer*4 DACFileNumEpisodes
	character*4 Unused
	integer*4 DeltaArrayPtr
	integer*4 NumDeltas
	integer*4 NoteBookPtr
	integer*4 NotebookManEntries
	integer*4 NotebookAutoEntries
	integer*4 SynchArrayPtr
	integer*4 SynchArraySize
	character*20 Unused100

	integer*2 ADCNumChannels
	real*4 ADCSampleInterval
	real*4 ADCSecondSampleInterval
	real*4 SynchTimeUnit
	real*4 SecondsPerRun
	integer*4 NumSamplesPerEpisode
	integer*4 PreTriggerSamples
	integer*4 EpisodesPerRun
	integer*4 RunsPerTrial
	integer*4 NumberOfTrials
	integer*2 AveragingMode
	integer*2 UndoRunCount
	integer*2 FirstEpisodeInRun
	real*4 TriggerThreshold
	integer*2 TriggerSource
	integer*2 TriggerAction
	integer*2 TriggerPolarity
	real*4 ScopeOutputInterval
	real*4 EpisodeStartToStart
	real*4 RunStartToStart
	real*4 TrialStartToStart
	integer*4 AverageCount
	character*6 Unused194
	integer*2 DrawingStrategy
	integer*2 TiledDisplay
	integer*2 nEraseStrategy
	integer*2 DataDisplayMode
	integer*4 DisplayAverageUpdate
	integer*2 ChannelStatsStrategy
	integer*4 CalculationPeriod
	integer*4 SamplesPerTrace
	integer*4 StartDisplayNum
	integer*4 FinishDisplayNum
	integer*2 MultiColor
	integer*2 ShowPNRawData
	character*10 Unused234
	real*4 ADCRange
	real*4 DACRange
	integer*4 ADCResolution
	integer*4 DACResolution
	integer*2 ExperimentType
	integer*2 AutosampleEnable
	integer*2 AutosampleADCNum
	integer*2 AutosampleInstrument
	real*4 AutosampleAdditGain
	real*4 AutosampleFilter
	real*4 AutosampleMembraneCap
	integer*2 ManualInfoStrategy
	real*4 CellD1
	real*4 CellD2
	real*4 CellD3
	character*16 CreatorInfo
	character*56 FileComment
	character*12 Unused366

	integer*2 ADCPtoLChannelMap(16)
	integer*2 ADCSamplingSeq(16)
	character*10 ADCChannelname(16)
	character*8 ADCUnits(16)
	real*4 ProgrammableGain(16)
	real*4 DisplayAmplification(16)
	real*4 DisplayOffset(16)
	real*4 InstrumentScaleFactor(16)
	real*4 InstrumentOffset(16)
	real*4 SignalGain(16)
	real*4 SignalOffset(16)
	real*4 SignalLowPassFilter(16)
	real*4 SignalHighPassFilter(16)
	end map
	end union
	end structure

	record /pclamp6/ pc6
	equivalence( pc6, iwork )

	character*52 path / ' ' /

	character key

	integer*4 ir

c
c	code
c

c
c	Create a name for a pCLAMP data file
c
	call create_path( path, ' ', file_name, '.dat' )
	call get_file_name(2,itop+12,
     &	path,'.dat','NEW', ' Create file? ',iflag)
	if( iflag .lt. 0 ) return
c
c	Open the pCLAMP file
c
	open(unit=itemp_file,
     &	file=path,
     &	form='binary',
     &	access='direct',
     &	recl=512)

	call write_to_log( 'Export to pCLAMP file: '//path )
c
c	Create pClamp V6 (Axon Binary File) header
c
	do i = 1,1024
	    pc6.header(i) = 0
	end do

	pc6.FileType = 'ABF '
	pc6.FileVersionNumber = 1.1
	pc6.OperationMode = 3
	pc6.ActualAcqLength = np_file
	pc6.NumPointsIgnored = 0
	pc6.ActualEpisodes = 1
	pc6.FileStartDate = 950101
	pc6.FileStartTime = 0
	pc6.StopwatchTime = 0
	pc6.HeaderVersionNumber = 1.1
	pc6.nFileType = 1
	pc6.MSBinFormat = 0

	pc6.DataSectionPtr = 4
	pc6.TagSectionPtr = 0
	pc6.NumTagEntries = 0
	pc6.LongDescriptionPtr = 0
	pc6.LongDescriptionLines = 0
	pc6.DACFilePtr = 0
	pc6.DACFileNumEpisodes = 0
	pc6.DeltaArrayPtr = 0
	pc6.NumDeltas = 0
	pc6.NotebookPtr = 0
	pc6.NotebookManEntries = 0
	pc6.NotebookAutoEntries = 0
	pc6.SynchArrayPtr = 0
	pc6.SynchArraySize = 0

	pc6.ADCNumChannels = 1
	pc6.ADCSampleInterval = dt * 1000.
	pc6.ADCSecondSampleInterval = 0.
	pc6.SynchTimeUnit = 0.
	pc6.SecondsPerRun = 0
	pc6.NumSamplesPerEpisode = 512	! Undefined in mode 3
	pc6.PreTriggerSamples = 50	! Undefined in mode 3
	pc6.EpisodesPerRun = 1
	pc6.RunsPerTrial = 1
	pc6.NumberofTrials = 1
	pc6.AveragingMode = 0
	pc6.UndoRunCount = -1
	pc6.FirstEpisodeInRun = 1
	pc6.TriggerThreshold = 100
	pc6.TriggerSource = -2
	pc6.TriggerAction = 0
	pc6.TriggerPolarity = 0
	pc6.ScopeOutputInterval = 0.
	pc6.EpisodeStartToStart = 1.
	pc6.RunStartToStart = 1.
	pc6.TrialStartToStart = 1.
	pc6.AverageCount = 1

	pc6.DrawingStrategy = 1
	pc6.TiledDisplay = 0
	pc6.DataDisplayMode = 1
	pc6.DisplayAverageUpdate = -1
	pc6.ChannelStatsStrategy = 1
	pc6.CalculationPeriod = 16384
	pc6.SamplesPerTrace = 1024
	pc6.StartDisplayNum = 1
	pc6.FinishDisplayNum = 0
	pc6.MultiColor = 1
	pc6.ShowPNRawData = 0

	pc6.ADCRange = ADC_Range
	pc6.DACRange = ADC_Range
	pc6.ADCResolution = 2048
	pc6.DACResolution = 2048
        pc6.AutosampleEnable = 0
        pc6.AutosampleAddItGain = 1.

	pc6.ExperimentType = 0

	pc6.FileComment = cell

	do i = 1,16
	    pc6.ADCPToLChannelMap(i) = i-1
	    pc6.ADCSamplingSeq(i) = -1
	    pc6.ADCChannelName(i) = ' '
	    pc6.ADCUnits(i) = 'mV'
	    pc6.ProgrammableGain(i) = 1.
	    pc6.DisplayAmplification(i) = 1.
	    pc6.DisplayOffset(i) = 0.
	    pc6.InstrumentScaleFactor(i) = 1.
	    pc6.InstrumentOffset(i) = 0.
	    pc6.SignalGain(i) = 1.
	    pc6.SignalOffset(i) = 0.
	    pc6.SignalLowpassFilter(i) = 100000.
	    pc6.SignalHighpassFilter(i) = 0.

	end do

	pc6.ADCSamplingSeq(1) = 15
	ipc_chan = pc6.ADCSamplingSeq(1) + 1
	pc6.InstrumentScaleFactor(ipc_chan) = GainIm / 1000.
	pc6.ADCUnits(ipc_chan) = y_units(1)

c
c	Write header information to pCLAMP header file
c
	write(unit=itemp_file,rec=1,iostat=istat) (pc6.header(i),i=1,1024)

c
c	Open PAT data file
c
	np_record = 512
	call open_data_file

	ifirst_block = 5
	key = 'S'
	do ir = 1,n_records

	    read( unit=1, rec=ir+idata_offset ) (iWork(i),i=1,np_record)

	    do i = 1,np_record
		iWork(i) = iWork(i) - 2048
	    end do

	    iblock = (ir-1)*2 + ifirst_block
	    write(unit=itemp_file,rec=iblock,iostat=istat)
     &	     (iWork(i),i=1,np_record)

	    call display_progress( 3, 20,
     &	    ' Records Exported (ESC to abort) ',ir,n_records,key)

	    if( key .eq. '$' )	goto 101

	end do
101	continue

	close(unit=itemp_file)
	close(unit=idata_file)

	return
	end

	subroutine ascii_to_pat( ileft, itop )
$include:'patcom.for'
c
c	Import a list of numbers into a .SCD file

	character*12 new_file_name / ' ' /
	parameter(max_files=500)
        PARAMETER(NROWS=2)
	character*52 path / ' ' /
	character*12 files(max_files)
	equivalence( iwork, files )
	real*4 yBuf(1)
	equivalence( iWork, yBuf )
	real*4 row(20)

	character*30 menu(nrows)
	CHARACTER*12 LIST(NROWS)
	character*38 title

	character key
        logical end_of_file
	integer*4 n,nr_out
c
c	code
c

	call create_path( path, default_path, '*', '.*' )
	call files_menu(path,0,new_file_name,ileft,itop,10,
     &	files,max_files)

	if( new_file_name .ne. ' ' ) then

	    call create_path(path,default_path,new_file_name,' ')
	    open(unit=itemp_file,
     &	    file=path,
     &	    form='binary',
     &	    iostat=istat,
     &	    recl=1)

	    call write_to_log( 'Import from '//path )

c
c	    Open .SCD file with same name
c
	    call create_path(path,default_path,new_file_name,'.scd')
	    call get_file_name(2,itop+12,
     &	    path,'.scd','NEW',' Create file? ',iflag)
	    if( iflag .lt. 0 ) then
		close(unit=itemp_file)
		return
	    end if
c
c	    Open .SCD data file with maximum record size
c
	    file_name = path
	    call open_data_file
c
c	    Find maximum/minumum of data
c
	    ymax = -1E30
	    ymin = 1E30
	    n = 0
	    np_file = 0
	    n_records = 0

c
c           Allow i.d. lines at beginning of file to be ignored
c
            r = 0.    
            call get_number_box(2,20,
     &      ' Number of initial lines to ignore ',' ',0.,1E30,r)
            nIgnore = int(r)
            if ( nIgnore .gt. 0 ) then
                do i = 1,nIgnore 
                   call extract_row(itemp_file,row,nc,end_of_file)
                end do
            end if

            end_of_file = .false.
            t0 = 0.
            t1 = 0.
	    do while( .not. end_of_file )

                call extract_row(itemp_file,row,nc,end_of_file)

                if (nc .eq. 1) then 
                   y = row(1)
                else
                    y = row(2)
                    if( .not. end_of_file ) then
                        t0 = t1
                        t1 = row(1)
                    end if
                end if

                if( y .gt. ymax ) ymax = y
                if( y .lt. ymin ) ymin = y

		np_file = np_file + 1
		n = n + 1
		yBuf(n) = y

		call display_progress( 2, 20,
     &		' Points done (ESC to abort) ', np_file,np_file, key )
		if( key .eq. '$' ) end_of_file = .true.

		if( (n .ge. np_record) .or.
     &		    (end_of_file .eqv. .true.) ) then

		   n_records = n_records + 1
		   write( unit=idata_file, rec=n_records+idata_offset )
     &		   (yBuf(i),i=1,np_record)
		   n_records = n_records + 1

		   n = 0
		end if

	    end do

c
c           Let user change scale factor and sampling interval
c

            ScaleBy = 1.
            menu(1) = ' Scale factor (X) '
            write(list(1),'(f9.3)') ScaleBy

            dt = t1 - t0
            menu(2) = ' Sampling interval (ms) '
            write(list(2),'(f9.3)') dt
            title = ' '
100         if( title .eq. ' ' ) title = ' File Conversion '
C
            CALL TEXT_WINDOW(MENU,LIST,NROWS,2,18,title)
C
            i = 1
            ScaleBy = check_limits(list,0.,1E30,i,title)
            if( title .ne. ' ' ) goto 100
            i = i + 1
            dt = check_limits(list,0.,1E30,i,title)
            if( title .ne. ' ' ) goto 100

	    r = (ymax - ymin)*2.5
            ScaleIm = r/(float(max_adc)*ScaleBy)


	    nr_out = 0
	    do ir = 1,n_records,2
c
c		Read real number record
c
		read( unit=idata_file, rec=ir+idata_offset )
     &		(yBuf(i),i=1,np_record)
c
c		Convert to integer
c
		do i = 1,np_record
		     iWork(i) = int( yBuf(i) / ScaleIm ) + 2048
		end do
c
c		Write back to file (note takes up half the space)
c
		nr_out = nr_out + 1
		write( unit=idata_file, rec=nr_out+idata_offset )
     &		(iWork(i),i=1,np_record)

	    end do

	    n_records = nr_out
	    np_file = n_records*np_record
	    nOverviewSlice = 0
	    n_events = 0
	    VoltageGatedChannels = .false.
            GainIm = convert_gain( ScaleIm ) 
	    call save_header

	    call write_to_log( 'New file '//file_name )

	    close(unit=itemp_file)
	    close(unit=idata_file)

	end if
	return
	end

	subroutine pat_to_ascii( ileft, itop )
$include:'patcom.for'
c
c	Export an .SCD data file to an ASCII list
c
	character*52 path / ' ' /

	character*80 string
	integer*1 istring(80)
	equivalence( string, istring )

	character key
	integer*4 ir
c
c	code
c
c
c	Create a name for an ASCII data file
c
	call create_path( path, ' ', file_name, '.dat' )
	call get_file_name(2,itop+12,
     &	path,' ','NEW', ' Create file? ',iflag)
	if( iflag .lt. 0 ) return
c
c	Open the ASCII file
c
	open(unit=itemp_file,
     &	file=path,
     &	form='binary' )

	call write_to_log( 'Export to ASCII file: '//path )

c
c	Open .SCD data file
c
	np_record = 512
	call open_data_file

	key = 'S'
	x = 0.
	do ir = 1,n_records

	    read( unit=1, rec=ir+idata_offset ) (iWork(i),i=1,np_record)

	    do i = 1,np_record
		y = float(iWork(i) - ibase)*ScaleIm
		write( string, '(f10.3,a,f10.3,a)')
     &		x,char(9),y,char(13)//char(10)
		nc = len_trim(string)
		write(unit=itemp_file) (istring(j),j=1,nc)
		x = x + dt
	    end do

	    call display_progress( 3, 20,
     &	    ' Records Exported (ESC to abort) ',ir,n_records,key)

	    if( key .eq. '$' )	goto 101

	end do
101	continue

	close(unit=itemp_file)
	close(unit=idata_file)

	return
	end
