	subroutine amplitude_histograms
C
C	-------------------------------------------
c       27/6/96 ... IStart/End cursor crash bug fixed
C
$INCLUDE:'patCOM.FOR'
C
	CHARACTER*52 TITLE
	CHARACTER*18 YLABEL,xlabel
	CHARACTER KEY
	CHARACTER*40 STRING
	LOGICAL special,new_plot,plot_available,cursor_key,new_menu,quit,
     &	histogram_available

	parameter(max_bins=512,max_np=max_bins*2+8)
	real*4 bins(4,max_bins),xy(2*max_np)
	equivalence (iwork, bins),
     &		    (iwork(max_bins*8+1),xy)

	integer*2 nbins /512/
C
	parameter(nmenu=10,naxes_menu=7,istatus_left=59,istatus_top=16)
	parameter(bigneg=-1E30,bigpos=1E30)
	character*36 axes_menu(naxes_menu)
	character*12 list(naxes_menu)
	character*35 err

	character*20 menu(nmenu) /
     &	' Create histogram F1',
     &	' Set axes         F2',
     &	' Plot display     F3',
     &	' List histogram   F4',
     &	' Set zero current F5',
     &	' Set unit current F6',
     &	' Set A.R. Start   F7',
     &	' Set A.R. End     F8',
     &	' Fit gaussians    F9',
     &	' Exit            ESC'/

	character ylog / 'N' /
	character xlog / 'N' /
	logical Display(4)
	character*12 label(4)
	logical new_cursor_pos

C
C	CODE
C	----
C


	xy(1) = 0.
	xy(2) = 0.
	new_plot = .false.
	plot_available = .false.
	histogram_available = .false.
	cursor_key = .false.
	new_cursor_pos = .false.

	xunit = float(iunit)*ScaleIm
	iop = 1
	CALL ERASE_ALL
	call display_box(1,1,istatus_left-2,25)
	CALL MOVE_CURSOR(2,1)
	CALL DISPLAY_STRINg(' Current amplitude distributions ')

	title = ' '
	new_menu = .true.
	quit = .false.
	nrep = 0

	do while( .not. quit )

	    if( new_menu ) then
		key = ' '
		iop = IMENU_VERTICAL1(menu,'123456789$',nmenu
     &		,istatus_left-1,1,new_menu,iop,' Options ',key)
	    endif

C
C	    Plot graph on screen
C
	    if( new_plot ) then

                if( iStart .gt. iEnd ) then
c
c                       Ensure end point is greater than start
c
                        iTemp = iEnd
                        iEnd = iStart
                        iStart = iTemp
                end if

		call erase_box(1,1,istatus_left-2,25)
		call display_box(1,1,istatus_left-2,25)

		if( title .ne. ' ' ) then
		    call move_cursor(2,1)
		    call display_stringt( title )
		end if
		call erase_box(istatus_left-1,istatus_top-1,79,25)
		call display_box(istatus_left-1,istatus_top-1,79,25)

		if( histogram_available ) then

		    call plot_histogram('S',bins,nbins
     &		    ,xlo,ylo,xhi,yhi,xtic,ytic,title,xlabel,ylabel
     &		    ,report,nrep,xy,xlog,ylog)
c
c		    Finds limits of displayed region of histogram
c
		    imin = 0
		    imax = nbins + 1
		    do i = 1,nbins
			if( bins(1,i).le.xlo ) imin = imin + 1
			if( bins(3,nbins+1-i).ge.xhi) imax = imax - 1
		    end do
		    imax = min(imax,nbins)
		    imin = max(1,imin)
		    icursor = max(min(icursor,imax),imin)
c
c		    Display analysis region cursors
c		    (make sure they stay within displayed region)
c
		    iStart = min( max( iStart,imin), imax)
		    iEnd = max( min( iEnd,imax), imin )
		    CALL SET_POLYLINE_TYPE(ISCREEN,3)
		    call cursor_line(iStart,bins,ylo,yhi,xlog,ylog,dotted)
		    call cursor_line(iEnd,bins,ylo,yhi,xlog,ylog,dotted)
		    calL SET_POLYLINE_TYPE(ISCREEN,1)

		    call cursor_line(icursor,bins,ylo,yhi,xlog,ylog,solid)
c
c		    Calculate percentage of signal within analysis region
c		    and mean current within region
c
		    xavg = 0.
		    bin_sum = 0.
		    total_current = 0.
		    bins_total = 0.
		    do i = 1,nbins
			y = bins(4,i)
			x = bins(2,i)*y
			if( i .ge. iStart .and. i.le.iEnd ) then
			    bin_sum = bin_sum + y
			    xavg = xavg + x
			end if
			total_current = total_current + x
			bins_total = bins_total + y
		    end do
		    xavg = xavg / max(bin_sum,1.)
		    total_current = total_current / bins_total
c
c		    Calculate open channel probability
c		    (based upon whole histogram)
c
		    if( iunit .ne. 0 ) then
			p_open = total_current / (float(iunit)*ScaleIm)
		    else
			p_open = 0.
		    end if

		    call move_cursor(istatus_left,istatus_top)
		    call display_string('-     Cursor      -')

		    call move_cursor(istatus_left,istatus_top+3)
		    call display_string('- Analysis Region -')
		    call move_cursor(istatus_left,istatus_top+4)


		    write(string,'(''Current  '',F8.3,''pA'')') xavg
		    call display_stringt(string)

		    call move_cursor(istatus_left,istatus_top+5)
		    write(string,'(''% total  '',F8.3,1X,''%'' )')
     &		    (bin_sum * 100.) / bins_total
		    call display_stringt(string )

		    call move_cursor(istatus_left,istatus_top+6)
		    call display_string('- - - - - - - - - -')
		    call move_cursor(istatus_left,istatus_top+7)
		    write(string,'(''p(open)  '',F7.3)') p_open
		    call display_stringt(string)

		    call move_cursor(istatus_left,istatus_top+8)
		    write(string,'(''Unit Cur.'',F8.3,''pA'')') xunit
		    call display_stringt(string)

		    new_cursor_pos = .true.

		end if

		if( plot_available ) then
		    call plot_graph('S',xy,np
     &		    ,xlo,ylo,xhi,yhi,xtic,ytic,xlabel,ylabel
     &		    ,report,nrep)
		end if

		new_plot = .false.

	    endif

	    if( new_cursor_pos ) then
		call move_cursor(istatus_left,istatus_top+1)
		write(string,'(''Bin      '',F7.3,1X,A)')
     &		bins(2,icursor),c_units
		call display_stringt(string)
		call move_cursor(istatus_left,istatus_top+2)
		write(string,'(''Contents '',F7.3,'' %'')')
     &		bins(4,icursor)
		call display_stringt(string)
		new_cursor_pos = .false.
	    end if

	    call wait_for_key( key, special )

	    if( (key.eq.'L').or.(key.eq.'R').or.(key.eq.'B')
     &	    .or.(key.eq.'F') ) then
		cursor_key = .true.
	    else
		cursor_key = .false.
	    endif
c
c	    Test for left/right cursor movement request
c
	    if( histogram_available .and. cursor_key ) then
		call cursor_line(icursor,bins,ylo,yhi,xlog,ylog,solid)
		if( key .eq. 'L' ) then
c		    <- cursor left
		    icursor = max(icursor-1,imin)
		elseif( key .eq. 'B' ) then
c		    Ctrl+<- cursor left (10 bins)
		    icursor = max(icursor-10,imin)
		elseif( key .eq. 'R' ) then
c		    -> cursor right
		    icursor = min(icursor+1,imax)
		elseif( key .eq. 'F' ) then
c		    Ctrl+-> cursor right (10 bins)
		    icursor = min(icursor+10,imax)
		endif
		call cursor_line(icursor,bins,ylo,yhi,xlog,ylog,solid)

		new_cursor_pos = .true.
		iop = 0
	    endif



	    if( .not. cursor_key ) then
	       iop = IMENU_VERTICAL1(menu,'123456789$',nmenu,
     &	       istatus_left-1,1,new_menu,iop,' Options ',key)
	       cursor_key = .false.
	    endif

	    select case( iop )

	    case( 1 )
C
C		Create amplitude histogram
c
		nbins = max_bins
		call create_amp_histogram(bins,nbins,max_bins,
     &		xy,np,max_np,total,
     &		xlabel,ylabel,title,
     &		plot_available,histogram_available)
		iStart = 1
		iEnd = nbins

		call erase_box(2,2,50,24)

		if( histogram_available ) then

		    xmin = bins(1,1)
		    xmax = bins(3,nbins)
		    xlo = xmin
		    xhi = xmax
		    ymin = 0.
		    ylo = ymin
		    ymax = -1E30
		    do i = 1,nbins
			ymax = max(ymax,bins(4,i))
		    end do
		    yhi = ymax

		    if(xlo .eq. xhi ) xhi = xlo + 1.
		    if(ylo .eq. yhi ) yhi = ylo + 1.

		    xtic = (xhi-xlo)/5.
		    ytic = (yhi-ylo)/5.
		    new_plot = .true.
		    xy(1) = 0
		    nrep = 0
		endif
		new_menu = .true.

		if( plot_available ) then

		    xmin = 1E30
		    xmax = -xmin
		    ymin = 1E30
		    ymax = -ymin
		    do i = 1,np*2,2
			if( xy(i) .lt. xmin ) xmin = xy(i)
			if( xy(i) .gt. xmax ) xmax = xy(i)
			if( xy(i+1) .lt. ymin ) ymin = xy(i+1)
			if( xy(i+1) .gt. ymax ) ymax = xy(i+1)
		    end do

		    xlo = xmin
a		    xhi = xmax
		    ylo = ymin
		    yhi = ymax

		    if(xlo .eq. xhi ) xhi = xlo + 1.
		    if(ylo .eq. yhi ) yhi = ylo + 1.

		    xtic = (xhi-xlo)/5.
		    ytic = (yhi-ylo)/5.
		    new_plot = .true.
		    new_menu = .true.

		    nrep = 0
		endif

	    case( 2 )
C
C --		Set plot axes range and tic spacing
C
		if( plot_available .or. histogram_available ) then
		    WRITE(axes_menu(1)
     &		    ,'('' X axis range: minimum ('',G10.4,'')'')') XMIN
		    WRITE(axes_menu(2)
     &		    ,'('' X axis range: maximum ('',G10.4,'')'')') XMAX
		    axes_menu(3) = ' X axis tic spacing '
		    WRITE(axes_menu(4)
     &		    ,'('' Y axis range: minimum ('',G10.4,'')'')') YMIN
		    WRITE(axes_menu(5)
     &		    ,'('' Y axis range: maximum ('',G10.4,'')'')') YMAX
		    axes_menu(6) = ' Y axis tic spacing '
		    axes_menu(7) = ' Logarithmic Y axis '

		    write(list(1),'(F12.3)') xlo
		    write(list(2),'(F12.3)') xhi
		    write(list(3),'(F12.3)') xtic
		    write(list(4),'(F12.3)') ylo
		    write(list(5),'(F12.3)') yhi
		    write(list(6),'(F12.3)') ytic
		    list(7) = ylog

		    err = ' '
2100		    if( err .eq. ' ' ) err = ' Set axes range '

		    CALL text_window(axes_menu,list,naxes_menu,2,2,err)

		    xlo  = check_limits(list,bigneg,bigpos,1,err)
		    if( err .ne. ' ' ) goto 2100
		    xhi  = check_limits(list,bigneg,bigpos,2,err)
		    if( err .ne. ' ' ) goto 2100
		    xtic = check_limits(list,0.,bigpos,3,err)
		    if( err .ne. ' ' ) goto 2100
		    ylo  = check_limits(list,bigneg,bigpos,4,err)
		    if( err .ne. ' ' ) goto 2100
		    yhi  = check_limits(list,bigneg,bigpos,5,err)
		    if( err .ne. ' ' ) goto 2100
		    ytic = check_limits(list,0.,bigpos,6,err)
		    if( err .ne. ' ' ) goto 2100
		    ylog = check_letter(list,'YN',7,string)

		    if( ylog .eq. 'Y' ) then
			if( yhi .le. 0. ) yhi = 1.
			if( ylo .le. 0. ) ylo = yhi*0.01
		    end if

		    new_plot = .true.
		    new_menu = .true.
		endif

	    case( 3 )
C
C --		Plot hard copy of graph or histogram
C
		if( histogram_available ) then
		    call plot_histogram('H',bins,nbins
     &		    ,xlo,ylo,xhi,yhi,xtic,ytic,title,xlabel,ylabel
     &		    ,report,nrep,xy,xlog,ylog)
		    new_plot = .true.
		    new_menu = .true.
		endif
		if( plot_available ) then
		    call plot_graph('H',xy,np
     &		    ,xlo,ylo,xhi,yhi,xtic,ytic,xlabel,ylabel
     &		    ,report,nrep)
		    new_plot = .true.
		    new_menu = .true.
		endif

	    case( 4 )
C
C --		Display table of current graph values
C
		if( histogram_available ) then
		    Display(1) = .false.
		    Display(2) = .true.
		    label(2) = xlabel
		    Display(3) = .false.
		    Display(4) = .true.
		    label(4) = ylabel
		    call ListData( bins(1,imin), imax-imin+1,
     &		    4, Display, Label, 2,2)
		 endif
		 if( plot_available ) then
		    Display(1) = .true.
		    label(1) = xlabel
		    Display(2) = .true.
		    label(2) = ylabel
		    call ListData( xy, np, 2, Display, Label, 2,2)
		endif
		new_menu = .true.
		new_plot = .true.

	    case( 5 )
C
C --		Set zero level
c
		if( histogram_available ) then
		    call open_data_file
		    ibase_old = ibase
		    ibase = int(bins(2,icursor)/ScaleIm) + ibase
		    call save_header
		    close(unit=1)

		    x = float(min_adc-ibase)*ScaleIm
		    dx = float((max_adc-min_adc)/nbins)*ScaleIm
		    do i = 1,nbins
			bins(1,i) = x
			bins(2,i) = x + dx/2.
			bins(3,i) = x + dx
			x = x + dx
		    end do
		    xmin = bins(1,1)
		    xmax = bins(3,nbins)
		    xlo = xlo + float(ibase_old-ibase)*ScaleIm
		    xhi = xhi + float(ibase_old-ibase)*ScaleIm
		    xy(1) = 0.
		    nrep = 0
		    new_plot = .true.
		end if

	    case( 6 )
C
c --		Set unitary current level
c
		if( histogram_available ) then
		    call open_data_file
		    xunit = bins(2,icursor)
		    iunit = int(xunit/ScaleIm)
		    call save_header
		    close(unit=1)
		    new_plot = .true.
		end if

	    case( 7 )
c
c --		Set start cursor
c
		iStart = icursor
		new_plot = .true.

	    case( 8 )
c
c --		Set end cursor
c
		iEnd = icursor
		new_plot = .true.

	    case( 9 )
c
c --		Fit Gaussian curves to amplitude peaks
c
		if( histogram_available ) then
		    call fit_gaussians(bins,iStart,iEnd,xy)
		endif
		new_plot = .true.
		new_menu = .true.

	    case( 10 )
c
c --		Exit
c
		quit = .true.
		new_plot = .true.

	    end select
	end do

	return
	end

	subroutine create_amp_histogram(bins,nbins,max_bins,xy,np,max_np,
     &	total,xlabel,ylabel,title,
     &	plot_available,histogram_available)
$include:'patcom.for'
c
c	Calculate current amplitude histograms
c
	real*4 bins(4,1)	! (Out) Histogram bin array
				! bins(1,i) = Lower bound
				! bins(2,i) = Upper bound
				! bins(3,i) = Midpoint
				! bins(4,i) = Contents

	integer*2 nbins 	! (Out) No. of bins in histogram
	integer*2 max_bins	! (In) Maximum no. of bins allowed
	real*4 xy(1)		! (Out) X/Y graph array
	integer*2 np		! (Out) No. of points in xy
	integer*2 max_np	! (In) Max. number of points allowed

	real*4 total		! (Out) Total no. of counts in histogram
	character*(*) xlabel	! (Out) X axis label
	character*(*) ylabel	! (Out) Y axis label
	character*(*) title	! (Out) Plot title
	logical plot_available	! (Out) .true. = result is in XY
	logical histogram_available ! (Out) .true. = result is in BINS

	character key,xlog,ylog
	logical new_menu

	parameter(nmenu=8)
	character*40 menu(nmenu) /
     &	' All point amplitude               F1',
     &	' All points within state           F2',
     &	' Average state amplitude           F3',
     &	' Patlak running average            F4',
     &	' Average amplitude vs dwell time   F5',
     &	' Import from amplitudes list file  F6',
     &	' Import from histogram file        F7',
     &	' Quit                             ESC' /

	integer*4 istate_start /0/, istate_end /0/
	integer*4 irecord_start /0/, irecord_end /0/

c	code
c
	title = ' '
	histogram_available = .false.
	plot_available = .false.
	new_menu = .true.

	itype = Iwait_MENU_VERTICAL1(menu,'1234567$',nmenu,2,2,new_menu
     &	,itype,' Select Plot Type ',key)
	call move_cursor(4,3+itype)

	select case( itype )
	case( 1 )
	    call all_points_amplitude(bins,nbins,max_bins,
     &	    irecord_start,irecord_end,total,xlabel,ylabel,title)
	    histogram_available = .true.

	case( 2 )
	    if( n_events .gt. 0 ) then
	       call all_points_in_state(bins,nbins,max_bins,
     &	       istate_start,istate_end,total,xlabel,ylabel,title)
	       histogram_available = .true.
	    else
		call Report_Error(2,24,' No states to plot')
	    end if

	case( 3 )
	    if( n_events .gt. 0 ) then
		call average_amplitude(bins,nbins,max_bins,
     &		istate_start,istate_end,total,xlabel,ylabel,title)
		histogram_available = .true.
	    else
		call Report_Error(2,24,' No states to plot')
	    end if

	case( 4 )
	    call patlak_average_amplitude(bins,nbins,max_bins,
     &	    irecord_start,irecord_end,total,xlabel,ylabel,title)
	    if( total .gt. 0. ) histogram_available = .true.

	case( 5 )
	    call average_vs_dwell_time(xy,np,max_np,
     &	    istate_start,istate_end,xlabel,ylabel,title)
	    plot_available = .true.

	case( 6 )
	    call amplitude_list_file(bins,nbins,max_bins,
     &	    total,xlabel,ylabel,title)
	    if( total .gt. 0. ) histogram_available = .true.

	case( 7 )
c
c	    Histogram file
c
	    call histogram_from_file(bins,nbins,max_bins,
     &	    total,iHistType,xlog,ylog)
	    title = 'Amplitude histogram from file '
	    xlabel = 'pA'
	    ylabel = 'Events'
	    if( nbins .gt. 1 ) histogram_available = .true.

	case( 8 )

	    call erase_box(2,2,50,24)

	end select

	if( itype .ne. 7 ) then
	    x = float(min_adc-ibase)*ScaleIm
	    dx = float((max_adc-min_adc)/nbins)*ScaleIm
	    do i = 1,nbins
		bins(1,i) = x
		bins(2,i) = x + dx/2.
		bins(3,i) = x + dx
		x = x + dx
	    end do
	end if
	return
	end

	subroutine all_points_amplitude(bins,nbins,max_bins,
     &	istart,iend,total,xlabel,ylabel,title)
$INCLUDE: 'PATCOM.FOR'
c
c	Calculate all-points amplitude histogram from A/D samples
c
	real*4 bins(4,nbins)		! Returned containing histogram
	integer*2 nbins 		! Returned with no. of bins
	integer*2 max_bins		! (In) Max. no. of bins allowed
	integer*4 istart,iend		! Entered = first..last records
	real*4 total			! Returned = total counts
	character*(*) xlabel		! (Out) x axis label
	character*(*) ylabel		! (Out) y axis label
	character*(*) title		! (Out) Histogram title

	parameter(nmenu=3)
	character*30 menu(nmenu) /
     &	' Start at record (1-       )',
     &	' End at record ',
     &	' No. of bins (<=512)' /
	character*10 list(nmenu)
	character*32 err
	character key
	integer*4 irecord
c
c	code
c
	call open_data_file

	call find_cursor(ix,iy)

	i = 1
	write(menu(i),'('' Start at record (1-'',i7,'')'')')
     &	n_records
	write(list(i),'(I7)') max(min(istart,n_records),1)
	i = i + 1
	if( iend .eq. 0 ) iend = n_records
	write(list(i),'(I7)') iend
	i = i + 1
	write(menu(i),'('' No. of bins (<='',i4,'')'')') max_bins
	write(list(i),'(I5)') nbins

	err = ' '
50	if( err .eq. ' ' ) err = ' Setup histogram '
	call text_window(menu,list,nmenu,ix,iy, err )

	i = 1
	istart = int4( check_limits(list,1.,float(n_records),i
     &	,err))
	if( err .ne. ' ' ) goto 50
	i = i + 1
	iend   = int4( check_limits(list,float(istart),
     &	float(n_records),i,err))
	if( err .ne. ' ' ) goto 50
	i = i + 1
	nbins = int( check_limits(list,1.,float(max_bins),i,err))
	if( err .ne. ' ' ) goto 50

	iy = iy + 5

	ibin_width = (max_adc - min_adc) / nbins
	do i = 1,nbins
	    bins(4,i) = 0.
	end do

	key = 'S'
	irecord = istart
	do while( key .ne. '$' )

	    read(unit=idata_file,rec=irecord+idata_offset)
     &	    (iBuf(i),i=1,np_record)

	    do i = 1,np_record
		idx = (iBuf(i) - min_adc)/ibin_width + 1
		bins(4,idx) = bins(4,idx) + 1.
	    end do

	    call display_progress(ix,iy,
     &	    'Records (ESC to abort)  ',irecord,iend,key)

	    irecord = irecord + 1
	    if( irecord .gt. iend ) key = '$'

	end do

	sum = 0.
	do i = 1,nbins
	    sum = sum + bins(4,i)
	end do
	do i = 1,nbins
	    bins(4,i) = bins(4,i)*100./max(sum,1.)
	end do

	total = sum*dt/1000.

	close(unit=idata_file)

	xlabel = 'pA'
	ylabel = '%'
	title = ' All-points amplitude histogram '

	return
	end

	subroutine average_amplitude(bins,nbins,max_bins,
     &	istart,iend,total,xlabel,ylabel,title)
$INCLUDE: 'PATCOM.FOR'
c
c	Calculate histogram of average amplitude in each channel state
c
	real*4 bins(4,nbins)		! Returned containing histogram
	integer*2 nbins 		! (Out) No. of bins in histogram
	integer*2 max_bins		! (In) Max. no. of bins allowed
	integer*4 istart,iend		! Entered = first..last records
	real*4 total			! Returned = total counts
	character*(*) xlabel		! (Out) x axis label
	character*(*) ylabel		! (Out) y axis label
	character*(*) title		! (Out) Histogram title

	parameter(nmenu=3)
	character*40 menu(nmenu) /
     &	' Start at event (1-       )',
     &	' End at event ',
     &	' No. of bins (<=        )' /

	character*10  list(nmenu)
	character*32 err
	character key
	integer*4 ievent,nSave
	character*6 sname

	record /event_record/ event
c
c	code
c
c
c	Open A/D data file for sample-by-sample access
c
	nSave = np_record
	np_record = 1
	call open_data_file

	call find_cursor(ix,iy)

	call select_state( ix,iy, ilevel, 6 )

	i = 1
	write(menu(i),'('' Start at event (1-'',i7,'')'')') n_events
	write(list(i),'(I7)') max(min(istart,n_events),1)
	i = i + 1
	if( iend .eq. 0 ) iend = n_events
	write(list(i),'(I7)') iend
	i = i + 1
	write(menu(i),'('' No. of bins (<='',i4,'')'')') max_bins
	write(list(i),'(I5)') nbins

	iy = iy + 6
	err = ' '
50	if( err .eq. ' ' ) err = ' Setup Histogram '
	call text_window(menu,list,nmenu,ix,iy, err )

	i = 1
	istart = int4( check_limits(list,1.,float(n_events),i
     &	,err))
	if( err .ne. ' ' ) goto 50
	i = i + 1
	iend = int4(check_limits(list,float(istart),float(n_events),
     &	i,err))
	if( err .ne. ' ' ) goto 50
	i = i + 1
	nbins = int( check_limits(list,1.,float(max_bins),i,err))
	if( err .ne. ' ' ) goto 50

	iy = iy + 5

	cur_min = float(min_adc - ibase)*ScaleIm
	cur_max = float(max_adc - ibase)*ScaleIm
	bin_width = (cur_max - cur_min) / float(nbins)

	do i = 1,nbins
	    bins(4,i) = 0.
	end do

	key = 'S'
	ievent = istart
	do while( key .ne. '$' )

	    read( unit=ievent_file, rec=ievent ) event

	    if( ((event.level .eq. ilevel) .or.
     &		(ilevel .eq. iall )) .and.
     &		(event.variance .ge. 0.) ) then
		idx = 1 + int( (event.average_current - cur_min) /
     &		bin_width )
		bins(4,idx) = bins(4,idx) + 1.
	    end if

	    call display_progress(ix,iy,
     &      'Events Done (ESC to Abort)    ', ievent,iend,key)

	    ievent = ievent + 1
	    if( ievent .gt. iend ) key = '$'

	end do

	total = 0.
	do i = 1,nbins
	    total = total + bins(4,i)
	end do

	np_record = nSave
	call open_data_file

	xlabel = 'pA'
	ylabel = 'States'
	call state_name( ilevel, sname )
	title = ' Average '//sname//' state amplitude histogram '

	return
	end

	subroutine all_points_in_state(bins,nbins,max_bins,
     &	istart,iend,total,xlabel,ylabel,title)
$INCLUDE: 'PATCOM.FOR'
c
c	Amplitude histogram computed from all points within
c	a selected type of state
c
	real*4 bins(4,nbins)		! Returned containing histogram
	integer*2 nbins 		! (Out) No. of bins in histogram
	integer*2 max_bins		! (In) Max. no. of bins allowed
	integer*4 istart,iend		! Entered = first..last records
	real*4 total			! Returned = total counts
	character*(*) xlabel		! (Out) x axis label
	character*(*) ylabel		! (Out) y axis label
	character*(*) title		! (Out) Histogram title

	parameter( imax = 4095, imin = 0 )

	parameter(nmenu=4)
	character*40 menu(nmenu) /
     &	' Start at event (1-       )',
     &	' End at event ',
     &	' No. of bins (<=        )',
     &	' Samples excluded at edges of event' /

	character*10 list(nmenu)
	character*32 err
	character key
	integer*4 ievent,ir,np,nskip,nSave
	logical quit

	record /event_record/ event
	character*6 sname

c
c	code
c
c
c	Open A/D data file for sample-by-sample access
c
	nSave = np_record
	np_record = 1
	call open_data_file


	call find_cursor(ix,iy)
	call select_state( ix,iy, ilevel, 6 )

	i = 1
	write(menu(i),'('' Start at event (1-'',i7,'')'')') n_events
	write(list(i),'(I7)') max(min(istart,n_events),1)
	i = i + 1
	if( iend .eq. 0 ) iend = n_events
	write(list(i),'(I7)') iend
	i = i + 1
	write(menu(i),'('' No. of bins (<='',i4,'')'')') max_bins
	write(list(i),'(I5)') nbins
	i = i + 1
	write(list(i),'(I5)') nskip

	iy = iy + 6

	err = ' '
50	if( err .eq. ' ' ) err = ' Setup Histogram '
	call text_window(menu,list,nmenu,ix,iy, err )

	i = 1
	istart = int4( check_limits(list,1.,float(n_events),i,err))
	if( err .ne. ' ' ) goto 50
	i = i + 1
	iend   = int4( check_limits(list,float(istart)
     &	,float(n_events),i,err))
	if( err .ne. ' ' ) goto 50
	i = i + 1
	nbins = int( check_limits(list,1.,float(max_bins),i,err))
	if( err .ne. ' ' ) goto 50
	i = i + 1
	nskip = int( check_limits(list,0.,1E6,i,err))
	if( err .ne. ' ' ) goto 50

	iy = iy + 6

	ibin_width = (max_adc - min_adc) / nbins
	do i = 1,nbins
	    bins(4,i) = 0.
	end do

	key = 'S'
	ievent = istart
	do while( key .ne. '$' )

	    read( unit=ievent_file, rec=ievent ) event

	    if( (event.level .eq. ilevel) .or.
     &		(ilevel .eq. iall ) ) then

		count = 0.
		sum = 0.
		ir = event.start + nskip
		if( ir .gt. event.end - nskip ) then
		    quit = .true.
		else
		    quit = .false.
		end if
		do while( .not. quit )

		    np = min( event.end-nskip-ir+1,np_record)
		    read(unit=idata_file,rec=ir+idata_offset)
     &		    (iBuf(i),i=1,np)

		    iCorrectBase = ibase - event.zero
		    do i = 1,np
			idx = (iBuf(i) + iCorrectBase - min_adc)/
     &			ibin_width + 1
			bins(4,idx) = bins(4,idx) + 1.
		    end do

		    ir = ir + np
		    if( ir .gt. event.end-nskip ) quit = .true.
		end do

	    end if

	    call display_progress(ix,iy,
     &   'Events Done (ESC to Abort)        ',ievent,iend,key)

	    ievent = ievent + 1
	    if( ievent .gt. iend ) key = '$'

	end do
c
c	Convert to % of total number of samples
c
	sum = 0.
	do i = 1,nbins
	    sum = sum + bins(4,i)
	end do
	do i = 1,nbins
	    bins(4,i) = bins(4,i)*100./max(sum,1.)
	end do
	total = sum*dt/1000.

	np_record = nSave
	call open_data_file

	xlabel = 'pA'
	ylabel = '%'
	call state_name( ilevel, sname )
	title = ' All-points in '//sname//' states histogram '
	return
	end

	subroutine patlak_average_amplitude(bins,nbins,max_bins,
     &	istart,iend,total,xlabel,ylabel,title)
$INCLUDE: 'PATCOM.FOR'

C
C	Calculate average amplitude histogram averaged over
C	a series on <n> samples, using Patlak's variance method
C	to exclude sample sets which contain transitions between states
C	---------------------------------------------------------------

	real*4 bins(4,1)		! (Out) Histogram data
	integer*2 nbins 		! (Out) No. of bins in histogram
	integer*2 max_bins		! (In) Max. no. of bins allowed
	character*(*) xlabel		! (Out) x axis label
	character*(*) ylabel		! (Out) y axis label
	character*(*) title		! (Out) Histogram title


c	"total" containing total time
C
c	*** NOTE ***
c	This routine also obtains a measure of the signal variance
c	from variance VARIANCE in PATCOM.FOR common area. VARIANCE
c	is set using the area variance option (F7) in PATDSP.FOR
c

	integer*4 istart,iend

	parameter(max_avg=256)
	integer*4 navg4 /16/
	INTEGER*4 sum4,sumsq4,var4,avg4
	real*4 sum
	integer*4 bin_width4,n_included4,n_excluded4,add4,drop4
     &	,var_threshold4

	integer*4 ring4(max_avg)
	equivalence( iWork(nWork-max_avg*4),ring4 )

	CHARACTER KEY

	parameter( np = 512)

	parameter(nmenu=5)
	character*40 menu(nmenu) /
     &	' Start at record (1-       )',
     &	' End at record ',
     &	' No. of bins (<=        )',
     &	' No. of samples in average (<=256)',
     &	' Variance acceptance threshold (pA^2)'/
	character*10 list(nmenu)
	character*32 err
	character*18 string
	integer*4 irecord
	logical special

C
C	CODE


	call open_data_file

	call find_cursor(ix,iy)

	i = 1
	write(menu(i),'('' Start at record (1-'',i7,'')'')')
     &	n_records
	write(list(i),'(I7)') max(min(istart,n_records),1)
	i = i + 1
	if( iend .eq. 0 ) iend = n_records
	write(list(i),'(I7)') iend
	i = i + 1
	write(menu(i),'('' No. of bins (<='',i4,'')'')') max_bins
	write(list(i),'(I5)') nbins
	i = i + 1
	write(list(i),'(I5)') navg4
	i = i + 1
	write(list(i),'(f8.4)') variance

	err = ' '
50	if( err .eq. ' ' ) err = ' Setup Histogram '
	call text_window(menu,list,nmenu,ix,iy, err )

	i = 1
	istart = int4( check_limits(list,1.,float(n_records),i,err))
	if( err .ne. ' ' ) goto 50
	i = i + 1
	iend   = int4( check_limits(list,float(istart)
     &	,float(n_records),i,err))
	if( err .ne. ' ' ) goto 50

	i = i + 1
	nbins = int( check_limits(list,1.,float(max_bins),i,err))
	if( err .ne. ' ' ) goto 50

	i = i + 1
	navg4 = int4( check_limits(list,1.,float(max_avg),i,err))
	if( err .ne. ' ' ) goto 50

	i = i + 1
	var_threshold4 = int4( check_limits(list,0.,1E30,i,err) /
     &	(ScaleIm*ScaleIm) )
	if( err .ne. ' ' ) goto 50


	iy = iy + nmenu + 2

	bin_width4 = (max_adc - min_adc) / nbins
	do i = 1,nbins
	    bins(4,i) = 0.
	end do

	call erase_box(ix,iy,ix+52,iy+2)
	call display_box(ix,iy,ix+52,iy+2)
	call move_cursor(ix+1,iy+1)
	call display_string(' Records done (ESC to abort) ')
	call find_cursor(ix,iy)

	key = 'S'
	irecord = istart
	do while( key .ne. '$' )

C	    Get record from file
C
	    read(unit=idata_file,rec=irecord+idata_offset)
     &	    (iBuf(i),i=1,np_record)
c
c	    If this is the first record, do complete calculation
c	    of sum and sum of squares of first "navg" points

	    if( irecord .eq. istart ) then
		sum4 = 0
		sumsq4 = 0
		do i = 1,navg4
		    add4 = iBuf(i)
		    sum4 = sum4 + add4
		    sumsq4 = sumsq4 + add4*add4
		    ring4(i) = add4
		end do
		n_included4 = 0
		n_excluded4 = 0
		inew = navg4
		is = navg4 + 1
	    else
		is = 1
	    endif

c
c	    Calculate variance "var4" and average "avg4" of
c	    sequence of "navg" points, stepping through "iBuf"
c	    one point at a time. If "var4" is less than acceptance
c	    threshold "var_threshold4" add the value "avg4" to
c	    the average amplitude histogram.
c
	    do i = is,np_record
c
c		Keep most recent "navg" points in buffer "ring4"
c
		inew = mod( inew, navg4 ) + 1
		add4 = iBuf(i)
		drop4 = ring4(inew)
		ring4(inew) = add4
c
c		Update variance by dropping oldest value
c		add adding most recent

		sum4 = sum4 + add4 - drop4
		sumsq4 = sumsq4 + add4*add4 - drop4*drop4
		avg4 = sum4 / navg4
		var4 = (sumsq4 - navg4*avg4*avg4)/navg4
c
c		Add to histogram if good variance
c
		if( var4 .lt. var_threshold4 ) then
		    idx = (avg4 / bin_width4 ) + 1
		    bins(4,idx) = bins(4,idx) + 1
		    n_included4 = n_included4 + 1
		else
		    n_excluded4 = n_excluded4 + 1
		endif

	    end do

	    if( mod( irecord,10) .eq. 1 ) then
		write(string,'(i5,''/'',i5,1x,i3,''% '')')
     &		irecord,iend, (100*n_included4)/(n_included4+n_excluded4)
		call move_cursor(ix,iy)
		call display_string( string )
		call get_key( key, special )
	    end if

	    irecord = irecord + 1
	    if( irecord .gt. iend ) key = '$'

	end do
c
c	Convert to %
c
	sum = 0.
	do i = 1,nbins
	    sum = sum + bins(4,i)
	end do
	do i = 1,nbins
	    bins(4,i) = bins(4,i)*100./max(sum,1.)
	end do
	total = sum*dt/1000.

	xlabel = 'pA'
	ylabel = '%'
	title = ' Patlak average amplitude histogram '
	return
	end

	subroutine average_vs_dwell_time(xy,np,max_np,istart,iend,
     &	xlabel,ylabel,title)
$INCLUDE: 'PATCOM.FOR'
c
c	Calculate histogram of average amplitude in each channel state
c
	real*4 xy(1)			! (Out) current vs dwell time
	integer*2 np			! (Out) No. of points in plot
	integer*2 max_np		! (In) Max. points allowed
	integer*4 istart,iend		! Entered = first..last records
	character*(*) xlabel		! (Out) x axis label
	character*(*) ylabel		! (Out) y axis label
	character*(*) title		! (Out) Histogram title

	parameter(nmenu=2)
	character*40 menu(nmenu) /
     &	' Start at event (1-       )',
     &	' End at event ' /

	character*10  list(nmenu)
	character*32 err
	character key
	integer*4 ievent,i4

	record /event_record/ event
	character*6 sname
c
c	code
c
	call find_cursor(ix,iy)

	call select_state( ix,iy, ilevel, 6 )

	i = 1
	write(menu(i),'('' Start at event (1-'',i7,'')'')') n_events
	write(list(i),'(I7)') max(min(istart,n_events),1)
	i = i + 1
	if( iend .eq. 0 ) iend = n_events
	write(list(i),'(I7)') iend

	iy = iy + 7
	err = ' '
50	if( err .eq. ' ' ) err = ' Setup Plot '
	call text_window(menu,list,nmenu,ix,iy, err )

	i = 1
	istart = int4( check_limits(list,1.,float(n_events),i
     &	,err))
	if( err .ne. ' ' ) goto 50
	i = i + 1
	iend = int4(check_limits(list,float(istart),float(n_events),
     &	i,err))
	if( err .ne. ' ' ) goto 50

	iy = iy + 6

	key = 'S'
	np = 0
	i4 = max_np
	key = 'S'
	ievent	= istart
	iend = min(iend,istart+i4-1)
	do while( key .ne. '$' )

	    read( unit=ievent_file, rec=ievent ) event

	    if( ((event.level .eq. ilevel) .or.
     &		(ilevel .eq. iall )) .and.
     &		(event.variance .ge. 0.) ) then
		np = np + 1
		xy(2*np-1) = event.dwell_time
		xy(2*np) = event.average_current
	    end if

	    call display_progress(ix,iy,
     &	    'Events Done (ESC to Abort) ',ievent,iend,key)

	    ievent = ievent + 1
	    if( ievent .gt. iend ) key = '$'

	end do


	xlabel = 'ms'
	ylabel = 'pA'
	call state_name( ilevel, sname )
	title = ' Average amplitude vs '//sname//' state dwell time '

	return
	end


	SUBROUTINE amplitude_list_file(bins,nbins,max_bins,total,
     &	xlabel,ylabel,title)
$INCLUDE: 'PATCOM.FOR'
C
C	Calc. amplitude histogram from an ASCII list file
c	containing measured channel current amplitudes
C	---------------------------------------------------
c
	integer*2 nbins 		! (Out) No. of bins in histogram
	integer*2 max_bins		! (In) Max. bins allowed
	character*(*) xlabel		! (Out) x axis label
	character*(*) ylabel		! (Out) y axis label
	character*(*) title		! (Out) Histogram title

c	Exit with array "bins" containing histogram
C	"nbins" = no. of bins in histogram
c	"total" containing total number of states
C

	real*4 bins(4,1)

	CHARACTER*34 STRING
	LOGICAL end_of_file

	parameter(nmenu=1,lwidth=50)
	character*40 menu(nmenu) /
     &	' No. of bins ' /
	character*10 list(nmenu) / ' ' /

	character*40 list_file_name / ' ' /
	real*4 row(10)
C
C	CODE
C

	call find_cursor(ix,iy)

	if( list_file_name .eq. ' ' ) list_file_name = default_path
	call get_file_name(2,iy,list_file_name,' ','OLD',
     &	' File name ',iflag)

	if( iflag .ge. 0 ) then

	    open(unit=itemp_file,
     &	    file=list_file_name,
     &	    form='binary',
     &	    iostat=istat,err=100,
     &	    recl=1)

	    string = ' '
	    i = 1
	    write(menu(i),'('' No. of bins (<='',i4,'')'')') max_bins
	    write(list(i),'(I5)') nbins

50	   if( string .eq. ' ' ) string = ' Setup Histogram '
	   call text_window(menu,list,nmenu,2,iy+3, string )

	   nbins = int(check_limits(list,0.,float(max_bins),1,
     &	   string))
	   if( string .ne. ' ' ) goto 50

	    ibin_width = (max_adc - min_adc) / nbins
	    x = float(min_adc-ibase)*ScaleIm
	    xmin = x
	    dx = float(ibin_width)*ScaleIm
	    bin_width = dx
	    do i = 1,nbins
		bins(4,i) = 0.
	    end do

	    end_of_file = .false.
	    do while( .not. end_of_file )

		call extract_row(itemp_file,row,nc,end_of_file)
		if( .not. end_of_file ) then
c
C		    Add to appropriate bin
C
		    idx = int( (row(1) - xmin)/bin_width )
		    idx = max(min(idx,nbins),1)
		    BINS(4,idx) = BINS(4,idx) + 1.
		endif
	    end do

	    total = 0.
	    do i = 1,nbins
		total = total + bins(4,i)
	    end do

	    xlabel = 'pA'
	    ylabel = ' '
	    title = ' Amplitude histogram (from list) '

	    close(unit=itemp_file)
	else
100	    total = 0.
	    if( iflag .eq. -1 )
     &	     call Report_Error(2,24,' Cannot open file! ')
	end if

	return
	end
