	subroutine record_to_disc
C
C	Continuos adc data collection routine
C	from channel 0 of ADC to file PATCH.1
c	26/7/95 ... nOverviewSlice now set to zero when recording occurs
c	12/1/96 ... Resistance calculation fixed
c	16/4/96 ... Voltage stepping with multipe files added
c		    Test pulse now alternates between high speed
c		    sampling for gigaseal and recording rate when
c		    pulse is off.
c	4/6/96 .... n_events=0 added to New File
c	4/7/96 .... DAC_STOP now only called when Test pulse has been run
c		    fixed bug which caused hang on Labmaster
C
$INCLUDE: 'PATCOM.FOR'
C
	LOGICAL new_menu,quit,TestPulse,erase_screen,NewDisplay
	INTEGER IDISPLAY_AREA(4)
	CHARACTER*1 KEY
	character*50 string
	CHARACTER*50 NEW_FILE_NAME / ' ' /
	character*50 old_default_path / ' ' /

	parameter(nmenu=8,istatus_left=64)
	character*15 menu(nmenu) /
     &	'New File     F1',
     &	'Record       F2',
     &	'Comment      F3',
     &	'To log       F4',
     &	'Pulse On/Off F5',
     &	'Set Zero     F6',
     &	'Setup        F7',
     &	'Exit        ESC'/

	character*40 title
	parameter(nrecmenu=5)
	CHARACTER*32 recmenu(nrecmenu) /
     &	' Recording block duration (s) ',
     &	' No. of blocks ',
     &	' Starting at Vm (mV)',
     &	' Voltage increment (mV)',
     &	' Command voltage divide factor ' /
	character*10 list(nrecmenu)

	real*4 VDac(2)

	parameter(maxDac=512)
	parameter(nAdcChannels=2)

	integer*2 iColour(nAdcChannels) / 2,3 /
	integer*2 iVm /1/
	integer*2 iIm /2/
	integer*2 iZero(2) / 2*2048 /

C
C	CODE
C
c
c	Allocate A/D and D/A buffers
c
	CALL OPEN_LAB(INTERFACE_CARD,iWork)

c
c	Set current and voltage channels according to which
c	interface is in use. Current should always be Ch.0
c	(Ch.15 for Labmasters) and voltage Ch.1 (Ch.14)
c	but they appear in buffer in different order depending
c	on whether the interface's channel sequencer counts down
c	or up.
c
	if( (interface_card .le.  5) .or.
     &	    (interface_card .ge. 14) .or.
     &	    (interface_card .eq. 11) .or.
     &	    ((interface_card .ge. 6) .and. (interface_card.le.9)) .or.
     &	    (interface_card .eq. 12) ) then
c
c	    CED 1401s, Data Translation interfaces, ATMIOS, Digidata
c
	    iVm = 2
	    iIm = 1
	else
c
c	    Labmasters & Lab-PC
c
	    iVm = 1
	    iIm = 2
	end if

	np_test   = 256
	n = np_test*nAdcChannels
	call allocate_adc_buffer(iWork,1,iadc0,n)
c
c	Allocate D/A buffer
c
	if( iadc0 .gt. n ) then
	    i0 = 1
	else
	    i0 = n + 1
	end if
	call allocate_dac_buffer(iWork,i0,idac0,maxDac*2)
c
c	Determine sampling interval and voltage limits of A/D converter
c
	call lab_limits(interface_card,dt_min,dt_max,ad_min,ad_max,dac)
	DacmVToBits = 2048. / ( dac*1000. )

c	Data file containing digitized current signal

	call open_data_file

	call check_dt(dt)

	call erase_all
	key = ' '
	new_menu = .true.
	iop = IMENU_VERTICAL1(menu,'1234567$'
     &	,nmenu,istatus_left-1,1,new_menu,iop,' Options',key)

C
C -- Set size of display area
C 
	CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	CALL GET_CHARACTER_SIZE(IW,IH)
	IDISPLAY_AREA(1) = IW
	IDISPLAY_AREA(2) = NDC_MAX - 24576 - IH
	IDISPLAY_AREA(3) = IDISPLAY_AREA(1) + ((60*IW)/512)*512
	IDISPLAY_AREA(4) = IDISPLAY_AREA(2) + 24576
C
C-- Draw display border and help information -------------------
C	
C
c	Master loop
c	-----------
c

	TestPulse = .false.
	NewDisplay = .true.
	quit = .false.
	do while ( .not. quit )

c
c	    When using the giga-seal test pulse switch to
c	    as high a sampling rate as possible
c
c
	    if( TestPulse ) then
		dt_test = max( 0.05, dt_min*2)
c               Slower rate for CED 1401       
                if( interface_card .eq. 1 ) dt_test = 0.1
	    else
		dt_test = dt
	    end if

	    if( NewDisplay ) then
		T_MIN = 0.
		T_MAX = FLOAT(np_test)*DT_Test
		CALL erase_BOX(1,1,62,21)
		CALL DISPLAY_BOX(1,1,62,21)
		CALL MOVE_CURSOR(2,1)
		CALL DISPLAY_STRINGt(' Record to: '//file_name)
		CALL MOVE_CURSOR(2,21)
		WRITE(string,'(F7.2,''ms'')') T_MIN
		CALL DISPLAY_STRINGt(string)
		WRITE(string,'(F7.2,''ms'')') T_MAX
		CALL MOVE_CURSOR(50,21)
		CALL DISPLAY_STRINGt(string)

		CALL erase_BOX(1,22,62,25)
		CALL DISPLAY_BOX(1,22,62,25)

		NewDisplay = .false.
	    end if

	    if( TestPulse ) then
c
c		Generate test pulse
c
		DtDac = 1.
		call check_dt_dac( DtDac )

		Delay = 100.
		SweepDuration = float(np_test)*dt_test
		nDac = int( (Delay + SweepDuration)/DtDac )
		iSync = int( Delay/DtDac )
		iStart = iSync + int(SweepDuration/(DtDac*4.))
		iEnd = iStart + int(SweepDuration/(DtDac*2.))
		iDacZero = 2048
                iLevel = int( PulseHeight * VDivide * DacmVToBits )
		iSyncLevel = int( 4999. * DacmVToBits )

		do i = 1,nDac
		    j = 2*i-2 + idac0
		    iWork(j) = iDacZero
		    iWork(j+1) = iDacZero
		    if( i.ge.iStart .and. i.le.iEnd )
     &		    iWork(j) = iWork(j) + iLevel
		    if( i .eq. iSync )
     &		    iWork(j+1) = iWork(j+1) + iSyncLevel
		end do

		idac_trigger = 0
		idac_mode = 1
		ndac_channels = 2
		call memory_to_dac( DtDac, ndac_channels,
     &		nDac,idac_trigger,iWork(iDac0),idac_mode,ierr)

		iExtTrig = 1

	    else
		iExtTrig = 0
	    end if

	    nChannels = 2
	    if( interface_card .eq. 1 .and. TestPulse ) then
c
c		    Special recording mode for use with CED 1401
c		    in Voltage Pulse mode only. (Uses the ADCMEMI
c		    command to record A/D sweep since the normal
c		    command ADCDMA cannot run simultaneously with
c		    MEMDAC.
c
		    call adc_special_ced(dt_test,np_test,nChannels,
     &		    iwork(iadc0),key)

	    else
c
c		Record a single record of samples for preview
c		and display on screen
c
		imode = 1
		CALL ADC_TO_MEMORY(dt_test,nChannels,np_test,
     &		iExtTrig,iWork,iadc0,imode,adc_range,key)

	    end if

	    erase_screen = .true.
	    call display_adc(iscreen,iWork(iadc0),np_test
     &	    ,nChannels,idisplay_area,iColour,erase_screen,key)

	    if( TestPulse ) call dac_stop
	    call adc_stop

c
c	    Calculate and display holding current (Im)
c	    and potential (Vm)
c
	    rIm = 0.
	    rVm = 0.
	    navg = 20
	    do i = 2,2+navg-1
		j = iAdc0 + 2*i-3
		rVm = rVm + float(iWork(j+iVm))
		rIm = rIm + float(iWork(j+iIm))
	    end do
	    rIm = rIm / float(navg)
	    rVm = rVm / float(navg)
	    rIm = (rIm - float(iZero(iIm)))*ScaleIm
	    rVm = (rVm - float(iZero(iVm)))*ScaleVm

	    call move_cursor(2,23)
	    write(string,'('' Vm= '',f7.1,''mV'',
     &	    '' Im= '',f7.1,''pA'')')
     &	    rVm,rIm
	    call display_stringt(string)
c
c	    Calculate and display pulse current (Ip),
c	    Potential (Vp) and Pipette resistance
c
	    rIp = 0.
	    rVp = 0.
	    navg = 20
	    i0 = (np_test-navg)/2
	    do i = i0,i0+navg-1
		j = iAdc0 + 2*i-3
		rVp = rVp + float(iWork(j+iVm))
		rIp = rIp + float(iWork(j+iIm))
	    end do
	    rIp = rIp / float(navg)
	    rVp = rVp / float(navg)
	    rIp = (rIp - float(iZero(iIm)))*ScaleIm - rIm
	    rVp = (rVp - float(iZero(iVm)))*ScaleVm - rVm

	    if ( TestPulse ) then
		Resistance = rVp / max(rIp,1E-5)
		call move_cursor(2,24)
		write(string,'('' Vp= '',f7.1,''mV'',
     &		'' Ip= '',f7.1,''pA'',
     &		'' Res= ''f7.3,''Gohms'')')
     &		rVp,rIp,Resistance
		call display_stringt(string)
	    end if

c
c	    Respond to user key presses
c
	    if( key .ne. char(0) ) then
		iop = IMENU_VERTICAL1(menu,'1234567$'
     &		,nmenu,istatus_left-1,1,new_menu,iop,' Options',key)
c
c		If an option has been selected - process it
c
		select case ( iop )

		case( 1 )
c
c		    Open a new file

		    new_file_name = file_name
		    if( default_path .ne. old_default_path ) then
			new_file_name = default_path
		    else
			new_file_name = file_name
		    end if
		    old_default_path = default_path

		    call get_file_name(2,2,new_file_name,'.scd','NEW'
     &		    ,' New file name ',iflag)

		    if( iflag .ge. 0 ) then
			file_name = new_file_name

			call write_to_log('New file: '//file_name)

			call open_data_file

			if( iflag .eq. 1 ) then
			    call get_header( ifile )
			else
			    n_records = 0
			    np_file = 0
                            n_events = 0
			    VoltageGatedChannels = .false.
			    call save_header
		       end if

		       nOverViewSlice = 0
		       NewDisplay = .true.
		    end if

		    new_menu = .true.

		case( 2 )
c
c		    Set up recording
c		    A Series of nSteps sweeps are acquired at holding
c		    potentials incrementing from VStart in steps
c		    of VStep
c
		    i = 1
		    write(list(i),'(f10.3)') RecordingTime / 1000.
		    i = i + 1
		    write(list(i),'(i2)') nSteps
		    i = 1 + i
		    write(list(i),'(f10.3)') VStart
		    i = 1 + i
		    write(list(i),'(f10.3)') VStep
		    i = 1 + i
		    write(list(i),'(f10.3)') VDivide

		    title = ' Record '
		    do while( title .ne. ' ' )
			CALL TEXT_WINDOW(RecMenu,list,nrecmenu,
     &			2,2,title)
			i = 1
			RecordingTime = check_limits(list,0.,
     &			1E30,i,title)*1000.
			if( title .ne. ' ' ) cycle
			i = 1 + i
			nSteps = int(check_limits(list,1.,26.,i,title))
			if( title .ne. ' ' ) cycle
			i = 1 + i
			VStart = check_limits(list,-10000.,10000.,
     &			 i,title)
			if( title .ne. ' ' ) cycle
			i = 1 + i
			VStep = check_limits(list,-10000.,10000.,
     &			 i,title)
			if( title .ne. ' ' ) cycle
			i = 1 + i
			VDivide = check_limits(list,1.,1000.,i,title)
			if( title .ne. ' ' ) cycle

		    end do

		    quit = .false.
		    iStep = 0
		    do while ( .not. quit )
c
c		       Set patch clamp command voltage (D/A 0)
c		       and synch. pulse (D/A 1)
c
		       VComm = (VStart + float(iStep)*VStep)*
     &			       VDivide
		       VDac(1) = VComm / 1000.
		       VDac(2) = 5.
		       call Set_Dacs( VDac, 2 )
		       call wait( 0.05 )
		       VDac(2) = 0.
		       call Set_Dacs( VDac, 2 )
c
c		       Modify last letter in file name
c
		       if ( nSteps .gt. 1 ) then
			    ix = index( File_name, '.' ) - 1
			    if( ix .gt. 0 ) File_name(ix:ix) =
     &				char( ichar('a') + iStep )

                            call write_to_log(
     &                       'New file: '//file_name)

			    call open_data_file
			    n_records = 0
			    np_file = 0
			    VoltageGatedChannels = .false.
			    call save_header
		       end if
c
c		       Record 32 points and
c		       calculate average membrane potential
c
		       imode = 0
		       iExtTrig = 0
		       CALL ADC_TO_MEMORY(dt_test,nChannels,32,
     &		       iExtTrig,iWork,iadc0,imode,adc_range,key)
		       rVm = 0.
		       n = 0
		       do i = 2,31
			  j = iadc0 + (i-1)*nChannels + iVm - 1
			  rVm = rVm + float(iwork(j) - iZero(iVm))
			  n = n + 1
		       end do
		       rVm = ( rVm/float(n) ) * ScaleVm
c
c		       Record signal
c
		       CALL MOVE_CURSOR(2,1)
		       CALL DISPLAY_STRINGt(
     &			' Record to: '//file_name)

		       write( string,
     &		       '(''Holding potential (mV) = '',f8.2)') rVm
		       call write_to_log( string )
c
c		       Set Global holding voltage variable "Vm"
c
		       Vm = rVm
                       call Save_header

		       write( string, '('' Vm = '',f7.1,'' mV'')') Vm
		       call move_cursor(40,1)
		       call display_stringt( string )

		       iKeep = np_record
		       call continuous_recording( quit )
		       np_record = iKeep
		       call open_data_file
		       nOverViewSlice = 0

		       iStep = iStep + 1
		       if( iStep .ge. nSteps ) quit = .true.
		    end do
c
c		    Set patch clamp command voltage back to zero
c
		    VDac(1) = 0.
		    VDac(2) = 0.
		    call Set_Dacs( VDac, 2 )


		case( 3 )
c
c		    Enter comment line
c
		    call open_data_file
		    call text_window(' ? ',cell(1:50),1,2,2
     &		    ,' Enter comment line ')
		    NewDisplay = .true.
		    call write_to_log( cell )
		    call save_header

		case( 4 )
c
c		    Type a line to log file
c
		    string = ' '
		    call text_window(' ? ',string,1,2,2
     &		    ,' Write to log ')
		    NewDisplay = .true.
		    call write_to_log( string )

		case( 5 )
c
c		    Test pulse on/off

		    TestPulse = .not. TestPulse
		    NewDisplay = .true.

		case( 6 )
c
c		    Set current and voltage channel zero levels
c
		    iZero(iVm) = int(rVm/ScaleVm) + iZero(iVm)
		    iZero(iIm) = int(rIm/ScaleIm) + iZero(iIm)

		case( 7 )
c
c		    Set test pulse parameters

		    call setup
		    NewDisplay = .true.
		    new_menu = .true.

		case( 8 )
c
c		    Return to main menu
c
		    quit = .true.

		end select

	    end if
	end do

	close(unit=1)
	return
	END

	subroutine continuous_recording( abort )
$include:'patcom.for'
c
c	Record a continuous stream of A/D samples to disc
c
	logical abort	    ! Returned .True. is user aborted recording
	integer*4 iRecord,nRecordsRequired,nRecordsDone,
     &	nSamplesRequired,nSave
	logical LowerHalfInUse,quit
	character key
	character*8 string8
	character*60 string

	integer*2 iFlag / 32767 /
	logical OverRun
c
c	code
c
c

	nSave = np_record
	np_record = 4096
	call open_data_file
c
c	Create an A/D buffer equal to two records
c
	n = np_record*2
	call allocate_adc_buffer(iWork,1,iadc0,n)

	call tell_user_box(2,10,' Recording (ESC to abort)         s')
	ix = 29
	iy = 11

c	Start repeatedly filling DMA buffer with A/D samples
c
	nSamplesRequired = max(int4(RecordingTime/dt),1)
	nRecordsRequired = max( nSamplesRequired / np_record, 1 )
	if( (nSamplesRequired - nRecordsRequired*np_record) .gt. 0 ) then
	    nRecordsRequired = nRecordsRequired + 1
	end if
	RecordingTime = float(nRecordsRequired*np_record)*dt
c
c	Write to expected end of data file to ensure
c	all allocation units are created (to speed up writing)
c
	iRecord = n_records+nRecordsRequired
	write(unit=idata_file,rec=idata_offset+iRecord) iWork(1)
c
c	Position disk head at start of disk area to be written to
c
	iRecord = n_records+1
	write(unit=idata_file,rec=idata_offset+iRecord) iWork(1)

	iAdcLow = iadc0
	iAdcLowEnd = iadc0 + np_record - 1
	iWork(iadcLowEnd) = iFlag
	iAdcHigh = iAdcLowEnd + 1
	iAdcHighEnd = iAdcHigh + np_record - 1
	iWork(iAdcHighEnd) = iFlag
c
c	Start continuous recording into A/D buffer from Ch.0
c
	itrig = 0
	imode = 2
	nAdcChannels = 1
	CALL ADC_TO_MEMORY(dt,nAdcChannels,np_record*2,
     &	itrig,iWork,iadc0,imode,adc_range,key)
	iWork(iadcLowEnd) = iFlag
	iWork(iAdcHighEnd) = iFlag
c
c	Double-buffered continuous recording
c
	LowerHalfInUse = .true.
	quit = .false.
	OverRun = .false.
	nRecordsDone = 0
	do while( .not. quit )

	    if( LowerHalfInUse ) then
c
c		Monitor lower buffer ... when flag at end of buffer
c		is overwritten copy contents of buffer to file
c
		if( iWork(iAdcLowEnd) .ne. iFlag ) then

		    if(iWork(iAdcHighEnd).ne.iFlag) OverRun = .true.

		    write(unit=idata_file,rec=idata_offset+iRecord)
     &		    (iWork(i),i=iAdcLow,iAdcLowEnd)
		    iWork(iAdcLowEnd) = iFlag
		    iRecord = iRecord + 1
		    LowerHalfInUse = .false.
		    call get_key( key, special )

		    nRecordsDone = nRecordsDone + 1
		    if( (nRecordsDone .eq. nRecordsRequired) .or.
     &			( key .eq. '$' ) ) quit = .true.

		    call move_cursor(ix,iy)
		    t = float(nRecordsDone*np_record)*dt/1000.
		    write( string8, '(f8.1)') t
		    call display_string( string8 )
		end if

	    else
c
c		Monitor upper buffer ... when flag at end of buffer
c		is overwritten copy contents of buffer to file
c
		if( iWork(iAdcHighEnd) .ne. iFlag ) then

		    if(iwork(iAdcLowEnd).ne.iFlag) OverRun = .true.

		    write(unit=idata_file,rec=idata_offset+iRecord)
     &		    (iWork(i),i=iAdcHigh,iAdcHighEnd)
		    iWork(iAdcHighEnd) = iFlag
		    iRecord = iRecord + 1
		    LowerHalfInUse = .true.
		    call get_key( key, special )

		    nRecordsDone = nRecordsDone + 1
		    if( (nRecordsDone .eq. nRecordsRequired) .or.
     &			( key .eq. '$' ) ) quit = .true.

		    call move_cursor(ix,iy)
		    t = float(nRecordsDone*np_record)*dt/1000.
		    write( string8, '(f8.1)') t
		    call display_string( string8 )
		end if
	    end if

	end do

	if( key .eq. '$' ) then
	    abort = .true.
	else
	    abort = .false.
	end if

	call adc_Stop

	if( OverRun ) call Report_Error(2,24,
     &	' ADC Overrun! Possible loss of data. ')

	t0 = (float(n_records*np_record)*dt)/1000.
	t1 = t0 + (float(nrecordsDone*np_record)*dt)/1000.
	write( string,
     &	'('' Record collected: t= '',f7.1,'' - '',f7.1,''s'')') t0,t1
	call write_to_log( string )
c
c	Convert samples from A/D converter data range to 0-4095
c
	key = 'S'
	do iRecord = n_records+1,n_records+nRecordsDone
	    read(unit=idata_file,rec=idata_offset+iRecord)
     &	    (iWork(i),i=1,np_record)
	    call convert_adc_values( iWork, np_record )
	    write(unit=idata_file,rec=idata_offset+iRecord)
     &	    (iWork(i),i=1,np_record)
	    call display_progress(2,10,' Normalising data   ',
     &	    iRecord,n_records+nRecordsDone,key)
	end do

	n_records = nRecordsDone + n_records
	np_file = n_records*np_record
	nOverViewSlice = 0
	call save_header
	np_record = nSave
	call open_data_file

	return
	end
