	PROGRAM PAT
C
C	Patch clamp data analysis program V7.2
C	--------------------------------------------------
C	Copyright - Univ. of Strathclyde, J. Dempster 1987-1996
C	--------------------------------------------------
C	Note: This program is supplied for academic
C	research purposes only on the basis that its use will
C	be acknowledged in any publications. It  must not be
C	sold or distributed to other users without the permission 
C	of the author. The program is provide on an "as found"
C	basis without any software support. While this program
C	has been extensively tested, it the responsibility of the
C	user to verify that it functions correctly for their own
C	purposes.
C
C	For further details, contact:
C
C	John Dempster
C	Department of Physiology and Pharmacology
C	University of Strathclyde
C	Glasgow
C	G1 1XW
C	Tel. 041 552 4400 x2673
C	---------------------------------------------------
C	
C	Patch clamp analysis program.
C	-----------------------------
C	Digitises continuous stretch of single channel current signals
C	and stores on Winchester disc for processing.
C	Current signal can be viewed on CRT. Current amplitude 
C	histogram can be computed and single channel conductance derived.
C	Automatic transition detection routine can analyse channel
C	open/close states and generate dwell time histograms.
C
c	V6.4 Labmaster support added, Microsoft FORTRAN V5
c	V6.6 National Instruments LAB-PC support added
c	V6.6a Old LABCED.FOR restored due to problems (in Ljubljana)
c	V7.0 log-time distributions added
c	V7.0c fixes at Plymouth
c	V7.0d 10/1/95
C	V7.0e 6/6/95 ... Time histogram import fixed
c	V7.0f 7/6/95
c	V7.0k 28/7/95 ... Overview now refreshed after a new recording
c	V7.0l 29/7/95 ... Change Directory now detects all drives
c	V7.0m 3/10/95 ... Overview ASCII plot fixed
c	V7.1  19/20/95 ... Seal Resistance corrected
c			   Extra file information on main display
c	V7.2  16/4/96  ... Voltage stepping during recording
c       V7.2a 8/7/96 ... ASCII_to_PAT User can now set scaling factor
c       v7.2b 3/6/96 ... Detection can now be done in blocks
c       v7.2c 4/6/96 ... n_events now set to zero by New File
c	v7.2d 5/6/96 ,,, Goto Event (patscn.for) now works OK
c       v7.2e ..... Amplitude Start/End cursors fixed        
c       v7.2f 4/7/96 ... Labmaster hang-up bug fixed.
c       v7.2g 10/10/96 ... LP Filter bug in PATDSP.FOR fixed
c       V7.3 26/4/97 ... CED micro1401 support added
c                        Bug when loading events list fixed (Ken Wann)       
c	V7.3a 27//4/97 ... Bugs in pClamp import fixed
c	V7.3b 28/3/97  ... pClamp import bug
c       V7.3c 3/4/97 ... pCLAMP sampling interval bug fixed
c       V7.3d 11/6/97 ... PATDSP.FOR Several hard copy bugs fixed
c                         (Only half of overview was plotted)
c       V7.3e 13/10/97 ... Maximum fittings iterations now 31000
c       V7.4 2/12/97 ... Now reads single column ASCII files
c       V7.4a 8/12/97 ... ASCII import scaling factor corrected
c       V7.4b 15/6/98 ... Openings per Burst now works correctly
c			  (pattim.for)
c	V7.4c 7/12/98 ... Large pCLAMP V5 files can now be imported
c			  Amplitude scaling factor also corrected
c
C	Cell identification header block
C	--------------------------------
C
	character*70 string
	integer*2 iop /1/

	PARAMETER(nmenu=11,istatus_left=59,istatus_top=22)
	CHARACTER*20 MENU(Nmenu) /
     &	 'Record to disc    F1',
     &	 'View recording    F2',
     &	 'Amplitude hists.  F3',
     &	 'Det. transitions  F4',
     &	 'Dwell time hists. F5',
     &	 'Stability plots   F6',
     &	 'Display Log       F7',
     &	 'Set parameters    F8',
     &	 'Data files        F9',
     &	 'Lab. interface   F10',
     &	 'Exit program       Q' /

	character*40 lab_card_name / ' ' /


$INCLUDE: 'PATCOM.FOR'
C
	CHARACTER KEY
	LOGICAL new_menu,quit
	integer*4 ifree4
C
C	CODE
C	----
C

C	Prevent run-time MATHs error from aborting program
C	(see Appendix D Microsoft FORTRAN V4.1 Users Guide)
	CALL LCWRQQ(16#133E)

	CALL OPEN_WORKSTATION(ISCREEN,1)
	CALL SET_MARGINS(2,1,80,25)
c
c	Open log file
c
	open(unit=ilog_file,
     &	 file='\gemapps\gemsys\pat.log',
     &	 access='APPEND',
     &	 form='binary',
     &	 iostat=istat)

	call getdat( iyear, imon, iday )
	write( string,
     &	 '(i2,''-'',i2,''-'',i4,'' PAT V7.4 Started'')' )
     &	 iday,imon,iyear
	call write_to_log( string )

	call read_initialisation_file( '\gemapps\gemsys\pat.ini' )

	np_record = 512
	call open_data_file
	close(unit=idata_file)

c
c	Open event list file working file
c
	open(unit=ievent_file,
     &	file='patevent.lst',
     &	form='binary',
     &	access='direct',
     &	recl=nbytes_event)

C
C	Master option selection loop
C	----------------------------

	quit = .false.
	do while( .not. quit )

	    n_records = np_file / np_record
c
c	    Flush disc buffers
c
	    call reset_disc
	    call erase_all
	    call title_box
c
c	    Display program status
c
	    call display_box(istatus_left-1,istatus_top-1,79,25)

	    ifree4 = int4( free_disc_space() )
	    write(string,'(''Disc space'',I7,''Kb'')' ) ifree4
	    call move_cursor(istatus_left,istatus_top)
	    call display_stringt( string )

	    write(string,'(''Free Memory  '',i4,''Kb'')' )
     &	    ifree_memory()
	    call move_cursor(istatus_left,istatus_top+1)
	    call display_stringt( string )

	    call get_lab_interface_shortname(interface_card,string)
	    call move_cursor(istatus_left,istatus_top+2)
	    call display_stringt( string )


C
c	    Present options menu and wait for user response
c
	    new_Menu = .true.
	    iop = Iwait_MENU_VERTICAL1(menu,'1234567890Q'
     &	    ,nmenu,istatus_left-1,1,new_menu,iop,' Options',key)

	    select case( iop )

	    case( 1 )

C
C		Digitise analogue current signal and store on disc
C
$if defined(demo)
$else
		call record_to_disc
$endif

	    case( 2 )
C
C		 View recording on screen
C
		if( n_records .gt. 0 ) call display_records

	    case( 3 )
C
C	    Compute and display current amplitude distribution
C
		call amplitude_histograms

	    case( 4 )
C
C	    Search stored signal for open/close transitions
C	    and generate dwell time histograms
C
		if( n_records .gt. 0 ) then
		    call transition_detection
		end if

	    case( 5 )
C
C		 Display and print channel state dwell time histograms
C
		 call time_histograms

	    case( 6 )
c
c		Stability plots
c
		if( n_records .gt. 0 ) call stability_plots

	    case( 7 )
c
c		Display experiment log

		 call read_log( istatus_left )

	    case( 8 )
C
C		 Enter data collection parameters
C
		call setup

	    case( 9 )
c
c		Load/Save data files
C
		call files_options

	    case( 10 )
c
c		 Choose lab. interface
c
		 call select_lab_interface(interface_card,
     &		 lab_card_name)

	    case( 11 )
C
		CALL QUERY_BOX(2,2,
     &		' Exit Program! Are you sure (Y/N) ? ',KEY)
		IF( KEY .EQ. 'Y' ) quit = .true.
	    end select
	end do

	call save_initialisation_file( '\gemapps\gemsys\pat.ini' )
	call close_workstation( iscreen )
	close(unit=ievent_file)
	close(unit=ilog_file)
	stop
	end

	BLOCK DATA
$INCLUDE: 'PATCOM.FOR'
	data GainVm /10./
	data GainIm / 100./
	DATA DT /0.05/
	data RecordingTime / 10000. /
	DATA IBASE,IUNIT /2048,-1024/
	data n_records /0/
	DATA adc_range /5./
	DATA INTERFACE_CARD /1/
	data close_threshold,open_threshold / 50.,50. /
	data BriefEvent,BriefEventLimit / 0.,10./
	data iline_thickness /3/
	data ifont /1/
	data ipoint_size /10/
	data iy_magn_min /4/
	data iy_magn /4/
	data iy_offset /0/
	data n_events /0/
	data y_scale / 1. /
	data y_units / 'pA' /
	data y_name / 'Im' /
	data cell / ' '/
	data level_name /'Rejected','Closed','Sub','Open','Latency'/
	data PulseHeight,PulseWidth / 10., 20. /
	data Vstart,VStep,nSteps,VDivide / 0.,0.,1,10./
	data VoltageGatedChannels,iVoltageStepStart / .false., 1 /
	END

	subroutine open_data_file
$include:'patcom.for'
c
c	Open data file holding A/D samples
c
	logical FileOpen,FileExists
c
c	If file is already open close it
c
	inquire(unit=idata_file,opened=FileOpen,exist=FileExists)
	if( FileOpen ) close(unit=idata_file)

	np_record = max(np_record,1)

	open(unit=idata_file,
     &	file= file_name,
     &	form='binary',
     &	access='direct',
     &	recl=np_record*2)

c
c	Read file header
c
	if( FileExists ) call get_header

	idata_offset = nbytes_header / (np_record*2)
	n_records = np_file / np_record
	return
	end

        subroutine open_new_data_file
$include:'patcom.for'
c
c	Open data file holding A/D samples
c
	logical FileOpen,FileExists
c
c	If file is already open close it
c
	inquire(unit=idata_file,opened=FileOpen,exist=FileExists)
	if( FileOpen ) close(unit=idata_file)

	np_record = max(np_record,1)

	open(unit=idata_file,
     &	file= file_name,
     &	form='binary',
     &	access='direct',
     &	recl=np_record*2)

	idata_offset = nbytes_header / (np_record*2)
	n_records = np_file / np_record
	return
	end


	subroutine title_box
$include:'patcom.for'
	PARAMETER(istatus_left=59,istatus_top=19)
	character*66 string
c
c	code
c

	    call erase_box(1,1,istatus_left-2,25)
	    call display_box(1,1,istatus_left-2,25)
	    call move_cursor(5,5)
	    call display_string(
     &	    'PAT - Single Channel Current Analysis Program V7.4c')
	    call move_cursor(5,6)
	    call display_string(
     &      '    (c) J. Dempster 1989-1998, All Rights Reserved')

$if defined (dagan)
	    call move_cursor(5,7)
	    call display_string(
     &	'      (Licensed to DAGAN Corporation, 1990)')
$endif

$if defined (life)
	call move_cursor(5,7)
	call display_string(
     &	'  (Licensed to Life Science Resources, 1994)')
$endif


$if defined (demo)
	    call move_cursor(5,8)
	    call display_string(
     &	' (Demonstration version - recording disabled)')
$endif

	    call move_cursor(2,22)
	    call display_stringt( file_name )

	    call move_cursor(2,23)
	    call display_string('( ')
	    write( string,'(f6.1)') float(np_file)*dt*0.001
	    call compress_string( string )
	    call display_stringt(string)
	    call display_string('secs, ')

	    write( string, '(i7)' ) np_file / 512
	    call compress_string( string )
	    call display_stringt(string)
	    call display_string('Kb ), ')

	    write( string, '(i7)' ) n_events
	    call compress_string( string )
	    call display_stringt(string)
	    call display_string('events, ')

	    call display_string('Vm = ')
	    write( string,'(f6.1)') Vm
	    call compress_string( string )
	    call display_stringt(string)
	    call display_string('mV')

	    call move_cursor(2,24)
	    call display_string ( cell(1:50) )

	    return
	    end

	    subroutine compress_string( string )
	    character*(*) string
	    character*80 Out

	    Out = ' '
	    j = 1
	    do i = 1,len(string)
		if( string(i:i) .ne. ' ' ) then
		    Out(j:j) = string(i:i)
		    j = j + 1
		end if
	    end do
	    String = Out
	    return
	    end
