
C	National Instruments LAB-PC code
C	================================
C	V1.0 MAY 1991 C) J. dempster
C	V1.1 JAN 1992 Minor modification to work with Lab-PC+
c	V1.1a SEP 94 Bug which caused  flipping of channels at
c		     high sampling rates fixed (adc_to_memory)

	subroutine open_labpc( ierr )
$INCLUDE: 'labpcc.FOR'

c	Reset the LAB-PC
c
	call outb( icsr, 0 )
	icr2_state = 2#00110000 	    ! DACs in 2's comp. mode
	call outb( icr2, icr2_state)	    ! Save state of command reg. 2
	icr3_state = 0
	call outb( icr3, icr3_state )

	call outb( icr4, 0 )

	call outb( icounterA_mode, 16#34 )
	call outb( icounterA0, 0 )
	call outb( icounterB0, 0 )
	call outb( idma_clear, 0 )
	call outb( itimer_clear, 0 )

	call outb( iadc_clear, 0 )
	call fifo_loop( 10 )
	ierr = 0

	return
	end

	subroutine fifo_loop( n )
$INCLUDE: 'labpcc.FOR'
	do i = 1,n
	    call inpb( ififor, ii )
	end do
	return
	end

	subroutine adc_stop_labpc
$INCLUDE: 'labpcc.FOR'
$INCLUDE: 'labdmab.FOR'
c
c	Stop A/D conversions
c
	CALL OUTB(IDMA_MASK, ICH1_OFF )
	icr2_state = 2#00110000 	    ! DACs in 2's comp. mode
	call outb( icr2, icr2_state)	    ! Save state of command reg. 2
	icr3_state = icr3_state .and. 2#11111110   ! Turn off DMA
	call outb( icr3, icr3_state )
	call outb( icsr, 0 )
	return
	end

	subroutine check_dt_labpc( dt, ticksA, ticksB )
$INCLUDE: 'labpcc.for'
C
C	Correct sampling period DT so that it produces one
c	of the valid LAB-PC clock rates

	parameter( period = 0.0005 )

C
C	CODE
C

	ticksb = 1.
	ticksa = 1E30
	do while( ticksa .gt. 32767. )
	    ticksb = ticksb*2.
	    ticksa = dt/(period*ticksb)
	end do
	dt = period*ticksA*ticksB
	RETURN
	END

	subroutine set_clock_labpc( dt )
$INCLUDE: 'labpcc.for'
C
C	Set A/D sampling clock to DT (ms)
c
c	A/D sampling is initiated by a Hi-Lo transition on the LAB-PC's
c	8253 Counter A0 using Counter B0 as its frequency source.
c	Sampling interval is :- 0.5usec X B0 X A0
	parameter( period = 0.0005 )

C
C	CODE
C

	call check_dt_labpc( dt, ticksA, ticksB )

	call outb( icounterB_mode, 16#36 )	! Counter B in mode 3
	iticks = int( ticksb )
	call outb( icounterB0, iticks )
	call outb( icounterB0, iticks/256 )

	call outb( icounterA_mode, 16#34 )	! Counter A0 in mode 2
	iticks = int( ticksa )
	call outb( icounterA0, iticks )
	call outb( icounterA0, iticks/256 )
c
c	CounterA0 is gated by CounterA1, so force CounterA1 output
c	LOW to allow CounterA0 to run.
c
	call outb( icounterA_mode, 16#70 )	    ! Counter A1 in mode 2

	return
	end

	subroutine set_dac_clock_labpc( dt )
$INCLUDE: 'labpcc.for'
C
C	Set D/A output clock to DT (ms)
c
c	D/A sampling is initiated by a Hi-Lo transition on the LAB-PC's
c	8253 Counter A2 using Counter B0 as its frequency source.
c	D/A output interval is :- 0.5usec X B0 X A2
	parameter( period = 0.0005 )

C
C	CODE
C

	if( ticksB_save .eq. 0. ) then
	    call check_dt_labpc( dt, ticksA, ticksB )
	    ticksB_save = ticksB

	    call outb( icounterB_mode, 16#36 )	    ! Counter B0 in mode 3
	    iticks = int( ticksb )
	    call outb( icounterB0, iticks )
	    call outb( icounterB0, iticks/256 )
	else
	    ticksA = dt/(period*ticksB_save)
	end if

	call outb( icounterA_mode, 2#10110100 )      ! Counter A2 in mode 2
	iticks = int( ticksa )
	call outb( icounterA2, iticks )
	call outb( icounterA2, iticks/256 )

	return
	end


	subroutine adc_to_memory_labpc(dt,n_channels,n_points,itrigger,
     &	ibuffer,istart,imode,adc_range,key_returned)
$INCLUDE: 'labpcc.for'
$INCLUDE: 'LABDMAB.FOR'

	INTEGER IBUFFER(1)
C
C	Input arguments
C	DT =         Group sampling period (ms)
C	N_CHANNELS = No. A/D channels to be scanned
C	N_POINTS =   No. of sample groups held by IBUFFER
C	ITRIGGER =   1 Wait for external trigger before starting sampling
C	             0 Start sampling immediately
C	IBUFFER =    DMA Memory buffer to hold ADC samples
C	ISTART =     Starting point in IBUFFER
C			   either 1, or (N_POINTS*N_CHANNELS)/2 + 1
C	IMODE =      0 Wait till IBUFFER is full before returning
C	             1 Return once sampling has started, collect
C	               a single buffer-ful
C	             2 Return once sampling has started, keep
C	               filling IBUFFEr circulerly until told to stop
c	ADC_RANGE =  Input voltage range
C	KEY_RETURNED = Key pressed by user during sampling

	CHARACTER*(*) KEY_RETURNED
	CHARACTER KEY
	LOGICAL end_of_sweep
	parameter( nranges=8 )
	real*4 range(nranges) / 5., 4., 2.5, 1., 0.5, 0.25, 0.1, 0.05 /

C
C	CODE
C
C	Inter-sample interval is channel group sampling interval
C	divided by number of channels in group. Note that DT1 and DT
C	are modified after SET_CLOCK_LABPC to be precisely equal to an
C	interval supported by the interface.
C
	dt1 = dt / float(n_channels)
	call set_clock_labpc( dt1 )
	dt = dt1 * float(n_channels)
c
c
c ----- Note: this bit MUST be done before multiple channel scanning
c	is enabled. Otherwise channels get out of sequence at high
c	sampling rates 1/8/94

	call outb( iadc_clear, 0 )	! Clear out any data which
	call fifo_loop( 10 )
	call inpb( ififor, ibyte )	! may be in the FIFO buffer
	call inpb( ififor, ibyte )
	call outb( idma_clear, 0 )     ! Clear DMA TC flag in status reg.
c --------------
c
c	Program ADC input gain and channel range into command register 1
c	Bits 4-6 = Channel gain X1 .. X100
c	Bit7 = SCANEN = 1 for multichannel scanning
c			0 for single channel
c	Bit3 = TWOSCMP = 1 for 2 complement representation of A/D data.
c	Bits0-2 = Max. Channel No.
c
	igain = 0
	do while( range(igain+1) .gt. adc_range )
	    igain = igain + 1
	end do
	adc_range = range(igain+1)

	ibyte = igain*16 + 16#8 + n_channels - 1
	call outb( icsr, ibyte )		    ! Note how 2 writes
	if( n_channels .gt. 1 ) then		    ! are made to command
	    ibyte = ibyte + 16#80		    ! register 1. This
	    call outb( icsr, ibyte )		    ! is required.
	end if

c
c	Tell LAB-PC to use DMA transfer via command register 3
c	Bit 0 = DMAEN = 1 = DMA data transfer enabled
c
	icr3_state = icr3_state .or. 2#1
	call outb( icr3, icr3_state )

C
C --	Set-up DMA controller for transfer to memory --
C
C	Select auto-initialise or single sweep DMA mode
C
	CALL OUTB(IDMA_MASK, ICH1_OFF )
	IF(IMODE.EQ.2) THEN
	    CALL OUTB(IDMA_MODE,IWRITE_MODEA)	! DMA in auto-initialise mode
	ELSE
	    CALL OUTB(IDMA_MODE,IWRITE_MODE)	! DMA in single sweep mode
	ENDIF
	NBYTES = N_POINTS*N_CHANNELS*2
	CALL SET_DMAB_ADDRESS(IBUFFER,ISTART,NBYTES)
c
c	Add marker to buffer if in single sweep mode
c
	if( imode .le. 1 ) call mark_buffer( ibuffer(istart), nbytes/2)

	CALL SET_DMAB_COUNT(NBYTES-1)
	CALL OUTB( IDMA_MASK, ICH1_ON )
c
c
c	Program  A/D sampling clock source and sampling trigger mode
c	into command register 2
c	Bit 3 = TBSEL =  1 2MHz*CounterB*CounterA used as sampling clock
c	Bit 2 = SWTRIG = 1 (for Immediate & Detect Trigger mode)
c		       = 0 (For External trigger mode)
c
	ibyte = 16#38
	if( itrigger .ne. 0 ) then
	    ibyte = ibyte + 16#2
	else
	    ibyte = ibyte + 16#4
	end if
	icr2_state = ibyte
	call outb( icr2, icr2_state )

C
C	If IMODE = 0 wait here till conversions are completed
C	which is indicated by the terminal count flag ITC in the
C	DMA status register being set

	clock_start = time_in_secs()

	IERR = 0
	if( IMODE .EQ. 0 ) then
	    end_of_sweep = .false.
	    do while( .not. end_of_sweep )
		call check_sweep(
     &		ibuffer(istart), nbytes/2, end_of_sweep, key )
		IF( KEY .NE. CHAR(0) ) KEY_RETURNED = KEY
	    end do

	    call adc_stop_labpc
	    call convert_adc_values( ibuffer(istart), nbytes/2 )

	end if

	return
	end

	subroutine memory_to_dac_labpc( dt, nchan, npoints, itrig,
     &	ibuffer, imode, ierr )
$include:'labpcc.for'
	integer*2 ibuffer(1)
c
c	Do D/A output to DAC 0 ( or DAC 0 and 1 ) of using values
c	from buffer <ibuffer> containing <npoints> values per channel,
c	updating at intervals of <dt> ms. <nchan> = no. of D/A channels
c	in use (1 or 2). If <imode>=0 wait for D/A sequence to complete
c	before returning, <imode>=1 setup D/A output and return immediately.
c

	parameter( iwait_mode = 0 )
c
c	code
c
	call find_para_start( ibuffer, istart )
	if( istart .ne. 1 ) then
	    call abort(
     &	    'MEMORY_TO_DAC_LABPC: IBUFFER NOT ON PARAGRAPH BOUNDARY')
	endif
c
c	Attach D/A update interrupt service routine
c
	nbytes = nchan*npoints*2
	call setup_dacs_labpc(ibuffer,nbytes,nchan,imode)
c
c	Enable Counter A2 to trigger interrupt
c
	icr3_state = icr3_state .or. 2#00001000
	call outb( icr3, icr3_state )
c
c	Link D/A update to counter A2 overflow
c	by setting LDAC1 & LDAC0 in command register 2.
c	(Register state is saved in <icr2_state> in /labpc_com/)

	icr2_state = icr2_state .or. 2#11000000
	call outb( icr2, icr2_state )
c
c	Set DAC clock and start output
c
	call set_dac_clock_labpc( dt )

	if( imode .eq. iwait_mode ) then
c
c	    Wait till DAC output counter reaches 0
c
	    ncount = 1
	    do while( ncount .gt. 0 )
		call get_dac_count_labpc( ncount )
	    end do

	    call dac_stop_labpc()

	endif

	return
	end

	subroutine set_dacs_labpc( vdac, ndacs )
$include:'labpcc.for'
	real vdac(ndacs)
	parameter( bitv = 5. / 2048. )
	integer*2 iword
	integer*1 ibyte(2)
	equivalence( iword,ibyte )
c
c	code
c
	icr2_state = icr2_state .and. 2#00111111
	call outb( icr2, icr2_state )

	iword = max(min(int(vdac(1)/bitv),2047),-2048)
	call outb( idac0, ibyte(1) )
	call outb( idac0+1, ibyte(2) )
	if( ndacs .gt. 1 ) then
	    iword = max(min(int(vdac(2)/bitv),2047),-2048)
	    call outb( idac1, ibyte(1) )
	    call outb( idac1+1, ibyte(2) )
	endif
	return
	end

	subroutine dac_stop_labpc
$include:'labpcc.for'

	icr3_state = icr3_state .and. 2#11110111    ! Disable counter A2
	call outb( icr3, icr3_state )		    ! from IRQ

	icr2_state = icr2_state .and. 2#00111111    ! Unlink DAC hardware
	call outb( icr2, icr2_state )		    ! from A2
	call detach_dac_interrupt_labpc()	    ! Remove DAC IRQ
	return					    ! from vector table
	end

	subroutine memory_to_dac_labpc_irq0(dt,nchan,npoints,itrig,
     &	ibuffer, imode, ierr )
$include:'labpcc.for'
	integer*2 ibuffer(1)
	integer*4 idiv4,iperiod4
c
c	Do D/A output to DAC 0 ( or DAC 0 and 1 ) of using values
c	from buffer <ibuffer> containing <npoints> values per channel,
c	updating at intervals of <dt> ms. <nchan> = no. of D/A channels
c	in use (1 or 2). If <imode>=0 wait for D/A sequence to complete
c	before returning, <imode>=1 setup D/A output and return immediately.
c

	parameter( iwait_mode = 0 )
c
c	code
c
	call find_para_start( ibuffer, istart )
	if( istart .ne. 1 ) then
	    call abort(
     &	    'MEMORY_TO_DAC_LABPC: IBUFFER NOT ON PARAGRAPH BOUNDARY')
	endif

c
c	Set D/A update clock to a rate which is a multiple of the
c	P.C. time-of-day clock (18.2Hz) and as close as possible
c	to the requested D/A update interval in <dt> ms.
c
	call check_dt_system( dt, iperiod4, idiv4 )
c
c	Begin D/A output sequence
c
	nbytes = nchan*npoints*2
	call setup_dacs_labpc_irq0(ibuffer,nbytes,nchan,
     &	idiv4,iperiod4,imode)

	if( imode .eq. iwait_mode ) then
c
c	    Wait till DAC output counter reaches 0
c
	    ncount = 1
	    do while( ncount .gt. 0 )
		call get_dac_count_labpc( ncount )
	    end do

	    call dac_stop_labpc_irq0()

	endif

	return
	end

	subroutine Set_LABPC_Counter_Mode( ICounter, INum, iMode )
$include:'labpcc.for'
c
c	Set 8253 counter mode
c	Enter with :-
c	ICounter : 1=A, 2=B
c	iNum : 0-2 counter number
c	iMode : 0-5 counter mode
c
	integer*2 iport(2) / icounterA_mode, icounterB_mode /

	ibyte = iNum*2#1000000 + 2#110000 + 2*iMode
	call outb( iport(iCounter), ibyte )

	return
	end

	subroutine Set_LABPC_Counter( Icounter, iNum, iValue )
$include:'labpcc.for'

	integer*2 iport(2) / icounterA0, icounterB0 /
	integer*2 iWord
	integer*1 iByte(2)
	equivalence( iWord, iByte )

	iWord = iValue
	call outb( iport(iCounter)+iNum, iByte(1) )
	call outb( iport(iCounter)+iNum, iByte(2) )

	return
	end

	subroutine Read_LABPC_Counter( iCounter,iNum,iCount)
$include:'labpcc.for'

	integer*2 imodeport(2) / icounterA_mode, icounterB_mode /
	integer*2 icountport(2) / icounterA0, icounterB0 /
	integer*2 iWord
	integer*1 iByte(2)
	equivalence( iWord, iByte )

	ibyte = iNum*2#1000000
	call outb( imodeport(iCounter), ibyte )
	call inpb( icountport(iCounter)+iNum, iByte(1) )
	call inpb( icountport(iCounter)+iNum, iByte(2) )
	iCount = iWord
	return
	end
