c
c	11/5/93 ... SET_CED_CLOCK improved so that 1MHz clock can be used
c       25/3/97 ... CED micro1401 support added
c
	BLOCK DATA
$INCLUDE: 'LABCEDC.FOR'
        DATA IFILE,CED1401Type /0,0/
	END

	SUBROUTINE OPEN_CED(iwork)
	integer*2 iwork(1)
C
$INCLUDE: 'LABCEDC.FOR'

	LOGICAL LOADED
	parameter(ncommands=3)
	character*10 command(ncommands) /
     &	'ADCDMA;',
     &	'MEMDACI;',
     &	'ADCMEMI;' /
	character*20 file(ncommands) /
     &	'\1401\ADCDMA.CMD',
     &	'\1401\MEMDACI.CMD',
     &	'\1401\ADCMEMI.CMD' /

	character*10 command_plus(ncommands) /
     &	'ADCDMA;',
     &	'MEMDAC;',
     &	'ADCMEM;' /
	character*20 file_plus(ncommands) /
     &	'\1401\ADCDMA.GXC',
     &	'\1401\MEMDAC.GXC',
     &	'\1401\ADCMEM.GXC' /

        character*10 command_micro(ncommands) /
     &	'ADCDMA;',
     &	'MEMDAC;',
     &	'ADCMEM;' /
        character*20 file_micro(ncommands) /
     &  '\1401\ADCDMA.ARM',
     &  '\1401\MEMDAC.ARM',
     &  '\1401\ADCMEM.ARM' /

	logical new_menu
	character key
        parameter(nmenu=3)
	character*26 menu(nmenu) /
     &	' CED 1401 ',
     &  ' CED 1401-plus',
     &  ' CED micro1401' /

C
C	CODE
C

	IF( IFILE.EQ.0 ) THEN
	    CALL OPEN_FILE(IFILE,IERR,'LABO')
	    IF( IERR .NE. 0 ) THEN
		iwork(1) = 1
		RETURN
	    ENDIF
	ENDIF

	call check_ced_error(
     &	'CED1401 not answering! Check power, connections, and Reboot')
c
c	Determine if a CED 1401 or 1401-plus is in use
c
        if( CED1401Type .eq. 0 ) then
            new_Menu = .true.
            ced1401Type = 1
            ced1401Type = Iwait_MENU_VERTICAL1(menu,'123'
     &      ,nmenu,2,2,new_menu,iop,' Select Interface ',key)
	end if
c
c	Load commands
c
        if( CED1401Type .eq. Type1401Plus ) then
c
c	    Load 1401-plus command set
c
	    do i = 1,ncommands
		call load_ced_command(file_plus(i),command_plus(i),
     &		loaded,iwork)
		if( .not. loaded ) call abort( 'Cannot load'//
     &		 file_plus(i))
	    end do
        else if ( CED1401Type .eq. TypeMicro1401 ) then
c
c           Load micro 1401 command set
c
	    do i = 1,ncommands
                call load_ced_command(file_micro(i),
     &               command_micro(i),loaded,iwork)
		if( .not. loaded ) call abort( 'Cannot load'//file(i))
	    end do
        else
c
c           Load 1401 command set
c
	    do i = 1,ncommands
                call load_ced_command(file(i),command(i),loaded,iwork)
		if( .not. loaded ) call abort( 'Cannot load'//file(i))
	    end do

	end if

	iwork(1) = 0

	RETURN
	END


	SUBROUTINE CLOSE_CED
$INCLUDE: 'LABCEDC.FOR'
$INCLUDE: 'LABDMAB.FOR'
C
C	Clear up after DAC_DMA
C
	LOGICAL DATA_AVAILABLE
	CHARACTER*10 STRING
C
C	CODE
C	----
C

	IF(IFILE.NE.0) THEN
	    CALL ADC_STOP_CED
	    CALL ENABLE_CED_TIMEOUT
	    CALL CHECK_CED_INPUT( DATA_AVAILABLE )
	    IF( DATA_AVAILABLE ) CALL READ_CED(STRING)
	    CALL WRITE_CED('CLEAR;')
	    CALL CLOSE_FILE(IFILE,IERR)

C	    Mask DMA channel 1 off

	    CALL OUTB(IDMA_MASK,ICH1_OFF)

	ENDIF
	IFILE = 0
	RETURN
	END


	SUBROUTINE READ_CED(STRING)
	CHARACTER*(*) STRING
	LOGICAL BYTES_AVAILABLE
$INCLUDE: 'LABCEDC.FOR'
C
	I = 0
	nlimit = len(string)
10	IBYTE = 0
11	    CALL CHECK_CED_INPUT(BYTES_AVAILABLE)
	    IF( BYTES_AVAILABLE .EQV. .FALSE. ) GOTO 11
	    CALL READ_BYTES(IFILE,IERR,IBYTE,1)
	    I = I + 1
	    if( i .le. nlimit ) then
		STRING(I:I) = CHAR(IBYTE)
	    else
		call move_cursor(1,25)
		call display_string(' READ_CED:Overflow ')
		call display_string(string)
		ibyte = 13
	    end if
	IF(IBYTE.NE.13) GOTO 10
	RETURN
	END



	SUBROUTINE WRITE_CED(STRING)
$INCLUDE: 'LABCEDC.FOR'
	CHARACTER*(*) STRING
	INTEGER*2 I_BUF(41)
	CHARACTER*82 C_BUF
	EQUIVALENCE (I_BUF,C_BUF)	
C
	NC = LEN(STRING)
	DO 10 I=1,NC
	    C_BUF(I:I) = STRING(I:I)
	    IF(C_BUF(I:I).EQ.';') GOTO 11
10	CONTINUE
11	CONTINUE
	NC = I
	CALL WRITE_BYTES(IFILE,IERR,I_BUF,NC)

	RETURN
	END


	SUBROUTINE SET_CED_SEGMENT(ISEG)
$INCLUDE: 'LABCEDC.FOR'
C
C	Set Segment base for CED-host DMA transfer area
C
	CHARACTER*8 STRING
	INTEGER*2 ISTRING(4)
	EQUIVALENCE(STRING,ISTRING)
C
C	CODE
C
C	Set of CED escape string in form <Esc>Sxxxx<CR> where
C	xxxx is the segment address in HEX code
C
	STRING(1:1) = CHAR(27)
	STRING(2:2) = 'S'
	STRING(7:7) = CHAR(13)
	CALL HEX(ISEG,STRING(3:6))
C
C	Send to CED driver
C
	CALL WRITE_BYTES(IFILE,IERR,ISTRING,7)
	RETURN
	END



	SUBROUTINE CHECK_CED_INPUT(FLAG)
C
C	Check if there are any characters in CED->host input buffer
C	FLAG = .TRUE. if their are any characters in buffer
C
	LOGICAL FLAG
C
$INCLUDE: 'LABCEDC.FOR'

	CALL GET_CED_STATUS(IFILE,ISTATUS)
	IF( ISTATUS .EQ. 255 ) THEN
	    FLAG = .TRUE.
	ELSE
	    FLAG = .FALSE.
	ENDIF
	RETURN
	END



	SUBROUTINE ENABLE_CED_TIMEOUT
C
C	Turn CED device driver time-out ON
C
$INCLUDE: 'LABCEDC.FOR'
	CHARACTER*4 STRING
	INTEGER ISTRING(2)
	EQUIVALENCE(STRING,ISTRING)
	STRING(1:1) = CHAR(27)
	STRING(2:2) = 'T'
	STRING(3:3) = CHAR(13)
	CALL WRITE_BYTES(IFILE,IERR,ISTRING,3)
	RETURN
	END



	SUBROUTINE DISABLE_CED_TIMEOUT
C
C	Turn CED device driver time out OFF
C
$INCLUDE: 'LABCEDC.FOR'
	CHARACTER*4 STRING
	INTEGER ISTRING(2)
	EQUIVALENCE(STRING,ISTRING)
	STRING(1:1) = CHAR(27)
	STRING(2:2) = 'U'
	STRING(3:3) = CHAR(13)
	CALL WRITE_BYTES(IFILE,IERR,ISTRING,3)
	RETURN
	END



	SUBROUTINE LOAD_CED_COMMAND(FILE_NAME,COMMAND_NAME,LOADED
     &,IBUFFER)
C
C	Reads a CED1401 command file and transfers it to the
C	1401 interface unit. Note that the routine checks whether
C	the command has already	been loaded.
C	---------------------------------------------------------
C	FILE_NAME = Name of file containing 1401 command
C			  usually in directory \1401\
C	COMMAND_NAME = Name of 1401 command (eg. ADCDMA;) Note
C				must be terminated with a ;
C	LOADED = Return flag .TRUE. = command in 1401
C	IBUFFER = Host memory array for temporary storage of command
C
	CHARACTER*(*) FILE_NAME
	CHARACTER*(*) COMMAND_NAME
	LOGICAL LOADED
	INTEGER*2 IBUFFER(1)
	INTEGER*2 IHEADER(5)
	CHARACTER*10 HEADER
	EQUIVALENCE(HEADER,IHEADER)
C
	CHARACTER*20 STRING
C
C	CODE
C	----
C
C	Test if command is already loaded
C
	CALL CHECK_CED_COMMAND(COMMAND_NAME,LOADED)
	IF(LOADED.EQV. .TRUE.) RETURN
C	
	CALL OPEN_FILE(IC_FILE,IERR,FILE_NAME)
	IF(IERR.NE.0) THEN
		LOADED = .FALSE.
		RETURN
	ENDIF
C
C	Get No. of bytes in 1401 command file (The 1401 commands are
C	stored in a BASIC BLOADable type of file. Bytes 8 and 9 of
C	this file contains the number of bytes in the command and
C	and command code itself is stored thereafter)
C
	CALL READ_BYTES(IC_FILE,IERR,IHEADER,9)
	NBYTES = ICHAR(HEADER(8:8)) + 256*ICHAR(HEADER(9:9))
C
C	Read rest of command
C
	CALL READ_BYTES(IC_FILE,IERR,IBUFFER,NBYTES)
	CALL CLOSE_FILE(IC_FILE,IERR)
C
C	Find segment and offset of address of start of command
C
	CALL VARPTR(ISEG,IOFFSET,IBUFFER)
C
C	Send address segment to 1401
C
	CALL SET_CED_SEGMENT(ISEG)
C
C	Compile and execute 1401 command string to load new command
C
	STRING = 'CLOAD,$0000,$0000;'
	CALL HEX(IOFFSET,STRING(8:11))
	CALL HEX(NBYTES,STRING(14:17))
	CALL WRITE_CED(STRING)
	CALL WRITE_CED('ERR;')
	CALL READ_CED(STRING)
C
C	Confirm that command has been loaded
C
	CALL CHECK_CED_COMMAND(COMMAND_NAME,LOADED)
C
	RETURN
	END
	SUBROUTINE CHECK_CED_COMMAND(COMMAND,LOADED)
C
C	Check that a 1401 command is loaded
C
	CHARACTER*(*) COMMAND
	LOGICAL LOADED
C
	CHARACTER*10 STRING
C
C	CODE
C
	CALL WRITE_CED(COMMAND)
	CALL WRITE_CED('ERR;')
	STRING = ' '
	CALL READ_CED(STRING)
C
	IF(STRING(1:3).EQ.'255') THEN
		LOADED = .FALSE.
	ELSE
		LOADED = .TRUE.
	ENDIF
	RETURN
	END


	SUBROUTINE ADC_TO_MEMORY_CED(DT,NCHAN,NPOINTS,ITRIG
     &,IBUFFER,ISTART,IMODE,ADC_RANGE,KEY_RETURNED)
$INCLUDE: 'LABCEDC.FOR'
$INCLUDE: 'LABDMAB.FOR'
C
C	Set up 1401 for A/D conversion and transfer via DMA
C	into a buffer in host memory. This buffer is filled and refilled
C	in a circular fashion until ADC_STOP is called.
C	-------------------------------------------------------
C	DT       Sampling rate/channel (ms),
C	NCHAN    No. of channels
C	NPOINTS  No. of sample points per channel,
C	ITRIG    1= Ext. triggered start (Event I/P 4)
C	IBUFFER  data storage buffer (4 x NCHAN*NPOINTS bytes)
C			Must be at least 2Kbyte to allow loading of ADCMEMF
C	ISTART   Starting point of DMA transfer buffer within IBUFFER
C	         either 1 or NCHAN*NPOINTS/2 + 1
C	-------------------------------------------------------
C	N.B. The DMA transfer area used to store the
C	sequence of A/D samples from the 1401 MUST be contained
C	within a single 64K DMA page. This is a consequence of the
C	design of the PC's DMA controller chip. If DMA transfers
C	are attempted ACROSS page boundaries the program will probably
C	crash.
C
	CHARACTER*80 STRING
	CHARACTER*(*) KEY_RETURNED
	CHARACTER KEY
	INTEGER IBUFFER(1)
	LOGICAL data_available,end_of_sweep
	character*16 chans(8) /
     &	 '0,',
     &	 '0 1,',
     &	 '0 1 2,',
     &	 '0 1 2 3,',
     &	 '0 1 2 3 4,',
     &	 '0 1 2 3 4 5,',
     &	 '0 1 2 3 4 5 6,',
     &	 '0 1 2 3 4 5 6 7,' /

	parameter( irepeat_mode = 2, iwait_mode = 0 )
C
C	CODE
C	----
C
C	Clear any spurious messages from the CED 1401
C
	CALL CHECK_CED_INPUT(DATA_AVAILABLE)
	IF( DATA_AVAILABLE ) CALL READ_CED(STRING)


C
C	Send address segment of DMA transfer buffer to 1401 driver
C	N.B. Choose upper or lower half of IBUFFER to ensure that
C	transfer area is contained within a single 64K memory page
C
	np = nchan*npoints
	nbytes = np*2
	call allocate_adc_buffer(ibuffer,1,istart,np)
c
c	Add marker to buffer if in single sweep mode
c
	if( imode .le. 1 ) call mark_buffer( ibuffer(istart), np)
C
C	Disable any transfers on DMA channel
C
	CALL OUTB(IDMA_MASK,ICH1_OFF)

C
C	Get segment & offset for starting address of transfer buffer
C
	CALL VARPTR(ISEG,IOFF,IBUFFER(ISTART))
C
C	Send segment to 1401 driver
C
	CALL SET_CED_SEGMENT(ISEG)
C
C       Generate command string
C
        String =
     &	'ADCDMA,2,$0000,$0000,0 1 2 3 4 5 6 7,1,C ,$0000,$0000;'
        CALL HEX(IOFF,STRING(11:14))
        CALL HEX(NBYTES,STRING(17:20))
        STRING(22:37) = CHANS(NCHAN)

c
c	Set repeating/single sweep mode
c
	if( imode .eq. irepeat_mode ) then
	    string(38:38) = '0'
	else
	    string(38:38) = '1'
	endif
c
c	Set trigger mode
c
	if( itrig .ne. 0 ) string(41:41) = 'T'
c
c	Set sampling clock rate
c
	dt1 = dt / float(nchan)
	call set_ced_clock( dt1, string(44:53) )
	dt = dt1 * float(nchan)
c
C	Set DMA controller byte count
C
	CALL SET_DMAB_COUNT(NBYTES-1)
C
C	Start DMA transfer by sending command to 1401
C
	CALL WRITE_CED(STRING)

C
C	If wait mode, wait here till conversions are completed
C
	IF(IMODE .EQ. iwait_mode ) THEN
	    end_of_sweep = .false.
	    do while( .not. end_of_sweep )
		call check_sweep(
     &		ibuffer(istart), np, end_of_sweep, key )
		IF( KEY .NE. CHAR(0) ) KEY_RETURNED = KEY
	    end do

C	    Tidy up

	    CALL ENABLE_CED_TIMEOUT
	    call adc_stop_ced

C	    Convert from +/-32767 -> 0..4095

	    call convert_adc_values( ibuffer(istart), np )
	    IBUFFER(ISTART) = IBUFFER(ISTART+nchan)
	ENDIF

	RETURN
	eND

	SUBROUTINE ADC_STOP_CED
$INCLUDE: 'LABCEDC.FOR'
$INCLUDE: 'LABDMAB.FOR'

	LOGICAL DATA_AVAILABLE, IDLE
	CHARACTER*10 STRING
	INTEGER ISTRING(5)
	EQUIVALENCE(STRING,ISTRING)
	PARAMETER( MAX_TRIES = 20 )
C
C	Stop DMA transfer from 1401
C
	STRING(1:1) = CHAR(27)
	STRING(2:2) = ';'
	STRING(3:3) = CHAR(13)
	IF(IFILE.NE.0) CALL WRITE_BYTES(IFILE,NWRITTEN,ISTRING,3)
C
C	Request an error report from 1401. Only returned if 1401
C	is idle.

	CALL DISABLE_CED_TIMEOUT
	CALL WRITE_CED('ERR;')

C	Wait for error report. If it doesn't appear, try reseting
C	the 1401 as a last resort.

	ITRY = 0
20	CALL CHECK_CED_INPUT( DATA_AVAILABLE )

C	    Any reply from 1401 ?

	IF( DATA_AVAILABLE ) THEN

C	    YES ... Read reply and exit

	    CALL READ_CED(STRING)
	    IDLE = .TRUE.
	ELSE
C
C	    NO ... Try again

	    ITRY = ITRY + 1
	    CALL WAIT(0.1)
	    IDLE = .FALSE.

C	    If 1401 is not yet in an idle condition after half
C	    of the retries, reset it with ESC I CR
C
	    IF( ITRY .EQ. MAX_TRIES/2 ) THEN
		STRING(1:1) = CHAR(27)
		STRING(2:2) = 'I'
		STRING(3:3) = CHAR(13)
		IF(IFILE.NE.0) CALL WRITE_BYTES(IFILE,NWRITTEN,ISTRING,3)
		CALL WAIT(1.)
		CALL DISABLE_CED_TIMEOUT
		CALL WRITE_CED('ERR;')
	    ENDIF
	    IF( ITRY .LT. MAX_TRIES ) GOTO 20
	ENDIF


C	Give up, if 1401 isn't idle

	IF( .NOT. IDLE ) call abort( 'ADC_STOP_CED: 1401 not responding' )

	RETURN
	END

	SUBROUTINE CHECK_DT_CED(DT,iticks,iprescale)
$INCLUDE: 'LABCEDC.FOR'
C
C	Correct sampling period DT so that it is a multiple
C	of the clock period of 1401
C
	PRESCALE = 0.2
10	CONTINUE
	    PRESCALE = PRESCALE*10.
	    TICKS = (DT*1000.)/PRESCALE
	IF((TICKS .GT. 32767.).AND.(PRESCALE.LT.32767.) ) GOTO 10
	ITICKS = max(int(TICKS + 0.1),2)
	IPRESCALE = max(int(PRESCALE + 0.1),2)
	DT = FLOAT(ITICKS)*FLOAT(IPRESCALE)/1000.
	RETURN
	END


	SUBROUTINE MEMORY_TO_DAC_CED(DT,NCHAN,NPOINTS,ITRIG
     &,IBUFFER,IMODE,IERR)
$INCLUDE: 'LABCEDC.FOR'
C
C	Set up 1401 for D/A conversion and transfer from host memory.
C	---------------------------------------------------------
C	DT       Sampling rate/channel (ms),
C	NCHAN    No. of channels
C	NPOINTS  No. of sample points per channel,
C	ITRIG    1= Ext. triggered start (Event I/P 4)
C	STRING   1401 command string returned for use by DAC_DMA
C	IBUFFER  data storage buffer (4 x NCHAN*NPOINTS bytes)
C	-------------------------------------------------------
C	N.B. The DMA transfer area used by TO1401 to send the
C	sequence of D/A points to the 1401 MUST be contained
C	within a single 64K DMA page. This is a consequence of the
C	design of the PC's DMA controller chip. If DMA transfers
C	are attempted ACROSS page boundaries the program will probably
C	crash.
C
	INTEGER IBUFFER(1)

	LOGICAL DONE
	CHARACTER*50 STRING

	character*8 chans(4) /
     &	'0,',
     &	'0 1,',
     &	'0 1 2,',
     &	'0 1 2 3,' /

	parameter( iwait_mode=0 )

C
C	CODE
C	----
C

C	Exit if CED device not open

	IF(IFILE.EQ.0) THEN
		IERR = 1
		RETURN
	ENDIF
C
C	Send address segment of DMA transfer buffer to 1401 driver
C	N.B. Choose upper or lower half of IBUFFER to ensure that
C	transfer area is contained within a single 64K memory page
C
	NBYTES = NCHAN*NPOINTS*2
C
C	Get segment & offset for starting address of transfer buffer
C
	CALL VARPTR(ISEG,IOFFSET,IBUFFER)
C
C	Send segment to 1401 driver
C
	CALL SET_CED_SEGMENT(ISEG)
C
C	Convert from 0-4095 to  +/-32767 range
C
	DO J = 1, NBYTES/2
	    IBUFFER(J) = (IBUFFER(J) - 2048)*16
	end do
C
C --	Transfer samples from host memory buffer to 1401 (at loc.200...)
C
	STRING = 'TO1401,$200,$0000,$0000;'
	CALL HEX(NBYTES,STRING(14:17))
	CALL HEX(IOFFSET,STRING(20:23))
	CALL WRITE_CED(STRING)
	call wait_ced_done()

C
C	Generate 1401 command string to initiate D/A output sequence
C
        if( CED1401Type .ne. Type1401 ) then
	    string = 'MEMDAC,I,2,$200,$0000,0 1 2 3,1,C ,$0000,$0000;'
	    call hex( nbytes, string(18:21) )
	    string(23:30) = chans(nchan)
	    if( itrig .ne. 0 ) string(34:34) = 'T'
	    call set_ced_clock( dt, string(37:46) )
	else
	    string = 'MEMDACI,2,$200,$0000,0 1 2 3,1,C ,$0000,$0000;'
	    call hex( nbytes, string(17:20) )
	    string(22:29) = chans(nchan)
	    if( itrig .ne. 0 ) string(33:33) = 'T'
	    call set_ced_clock( dt, string(36:45) )
	end if


	call write_ced( string )
c
c	If in mode 0 wait till D/A is all done

	if( imode .eq. iwait_mode ) then
	    done = .false.
	    do while( .not. done )
		call wait( 0.05 )
		call check_dac_completion_ced( done )
	    enddo
	endif

	ierr = 0
	return
	end

	subroutine wait_ced_done()
c
c	Wait till a CED 1401 operation has been completed
c	by sending an ERR request and waiting till a reply arrives
c
	logical done
	character*20 string

	call wait( 0.05 )
	call disable_ced_timeout
	CALL WRITE_CED('ERR;')
20	CALL CHECK_CED_INPUT( DONE )
	IF( .not. DONE ) GOTO 20
	CALL READ_CED(STRING)
	call enable_ced_timeout
	return
	end

	SUBROUTINE CHECK_CED_DONE( CED_DONE )
	LOGICAL CED_DONE
C
C	Return CED_DONE = .TRUE. 	If CED 1401 has completed
C	its task and responded to ERR; request
C
	LOGICAL DATA_AVAILABLE
	CHARACTER*20 STRING

	CALL CHECK_CED_INPUT( DATA_AVAILABLE )
	IF( DATA_AVAILABLE ) THEN
		CALL READ_CED(STRING)
		CALL ENABLE_CED_TIMEOUT
		CED_DONE = .TRUE.
	ELSE
		CED_DONE = .FALSE.
	ENDIF
	RETURN
	END


	SUBROUTINE ADC_special_ced(DT_ADC,NPOINTS,nchan,IBUFFER,key)
$INCLUDE: 'LABCEDC.FOR'
$INCLUDE: 'LABDMAB.FOR'
c
c	Special routine for simultaneous voltage pulse generation
c	and recording since normal ADCDMA routine cannot run
c	simultanenously with MEMDACI
C
C	DT_ADC	 A/D Sampling rate/channel (ms),
C	NPOINTS  No. of sample points per channel,
c	nchan	No. of A/D channels
C	IBUFFER  data storage buffer (4*NPOINTS bytes)
c
	character*80 string
	CHARACTER KEY
	INTEGER IBUFFER(1),IERR2(2)
	LOGICAL DATA_AVAILABLE,SPECIAL,done
	character*16 chans(8) /
     &	 '0,',
     &	 '0 1,',
     &	 '0 1 2,',
     &	 '0 1 2 3,',
     &	 '0 1 2 3 4,',
     &	 '0 1 2 3 4 5,',
     &	 '0 1 2 3 4 5 6,',
     &	 '0 1 2 3 4 5 6 7,' /
C
C	CODE
C	----
C
C	Clear any spurious messages from the CED 1401
C
	CALL CHECK_CED_INPUT( DATA_AVAILABLE )
	IF( DATA_AVAILABLE ) CALL READ_CED(STRING)

C
C ----- Send address segment of DMA transfer buffer IBUFFER to 1401 driver
C	N.B. Ensure transfer area is contained within a single 64K memory page
C
	NBYTES = NCHAN*NPOINTS*2
	CALL CHECK_DMAB(IERR2,IBUFFER,NBYTES)
	IF(IERR2(1).NE.0) THEN
	    call abort(' ADC_SPECIAL_ced: Data Buffer spans 64K block ')
	ENDIF

c
c	Request A/D conversion sweep into 1401 memory block
c	(starting at address 3000H) Wait for external trigger
c	on Event Input 4, before starting recording
c
        if( CED1401Type .ne. Type1401 ) then
	    string =
     &	    'ADCMEM,I,2,$3000,$0000,0 1 2 3 4 5 6 7,1,CT,$0000,$0000;'
	    STRING(24:39) = CHANS(NCHAN)
	    call hex( nbytes, string(19:22) )
	    dt_adc = dt_adc / float(nchan)
	    call set_ced_clock( dt_adc, string(46:55) )
	    dt_adc = dt_adc * float(nchan)
	else
	    string =
     &	    'ADCMEMI,2,$3000,$0000,0 1 2 3 4 5 6 7,1,CT,$0000,$0000;'
	    call hex( nbytes, string(18:21) )
	    STRING(23:38) = CHANS(NCHAN)
	    dt_adc = dt_adc / float(nchan)
	    call set_ced_clock( dt_adc, string(45:54) )
	    dt_adc = dt_adc * float(nchan)
	end if
	CALL WRITE_CED( string )
c
c	Wait for completion of sweep
c
10	continue
	    call wait( 0.05 )
	    call check_adc_completion( done )
	    call get_key( key, special )
	if( (.not. done) .and. (key .ne. '$') ) goto 10

C
C --	Transfer samples from 1401 to host memory buffer
C
	if( key .ne. '$' ) then
	    CALL VARPTR(ISEG,IOFF,IBUFFER)
	    CALL SET_CED_SEGMENT(ISEG)
	    STRING = 'TOHOST,$3000,$0000,$0000;'
	    CALL HEX(NBYTES,STRING(15:18))
	    CALL HEX(IOFF,STRING(21:24))
	    CALL WRITE_CED(STRING)
	    call wait_ced_done()
	else
            if( CED1401Type .ne. Type1401 ) then
		call write_ced('ADCMEM,K;')
	    else
		call write_ced('ADCMEMI,K;')
	    end if
	    call wait_ced_done()
	endif


	RETURN
	END

	subroutine check_dac_completion_ced( done )
$INCLUDE: 'LABCEDC.FOR'
	logical done
	character*10 string

        if( CED1401Type .ne. Type1401 ) then
	    call write_ced( 'MEMDAC,?;' )
	else
	    call write_ced( 'MEMDACI,?;' )
	end if

10	call check_ced_input( done )
	if( .not. done ) goto 10
	call read_ced( string )
	if( string(1:1) .eq. '0' ) then
	    done = .true.
	else
	    done = .false.
	endif
	return
	end

	subroutine check_adc_completion( done )
$INCLUDE: 'LABCEDC.FOR'
	logical done
	character*10 string

        if( CED1401Type .ne. Type1401 ) then
	    call write_ced( 'ADCMEM,?;' )
	else
	    call write_ced( 'ADCMEMI,?;' )
	end if

10	call check_ced_input( done )
	if( .not. done ) goto 10
	call read_ced( string )

	if( string(1:1) .eq. '0' ) then
	    done = .true.
	else
	    done = .false.
	endif
	return
	end

	subroutine set_ced_clock( dt, command )
	character*(*) command
	real dt
c
c	Enter with: dt = clock period requested (us)
c	Return with : dt = clock period set
c		      command = PPPP,$TTTT where PPPP is prescale
c			and TTTT is ticks portion of 1401 command line
c
	call CHECK_DT_CED(DT,iticks,iprescale)

	call hex( iprescale, command(1:4) )
	call hex( iticks, command(7:10) )
	return
	end

	subroutine dac_stop_ced
$INCLUDE: 'LABCEDC.FOR'
c
c	Stop CED 1401 D/A output command
c
        if( CED1401Type .ne. Type1401 ) then
	    call write_ced( 'MEMDAC,K;' )
	    call check_ced_error( 'MEMDAC,K;' )
	else
	    call write_ced( 'MEMDACI,K;' )
	    call check_ced_error( 'MEMDACI,K;' )
	end if
	return
	end


	subroutine check_ced_error( string )
$include:'labcedc.for'
	character*(*) string
	character*10 response / ' ' /
	logical data_available
	character*4 string4
	integer*2 istring4(2)
	equivalence(string4,istring4)

	parameter( maxtry = 400 )

5	call check_ced_input( data_available )
	if( data_available ) then
	    call read_ced( response )
	    goto 5
	endif

	call disable_ced_timeout
	call write_ced('ERR;')

	call get_time( ihr, imin, isec, icsec_old )
	ntry = 0

10	call check_ced_input( data_available )
	if( data_available ) then
	    response = ' '
	    call read_ced( response )
	    is = index( response, '0' )
	    if( is .le. 0 )  then
		call get_screen_device( idev )
		call close_workstation( idev )
		write(*,'(1x,a)') string
		write(*,'(1x,a)') response
		stop
	    endif
	else
	    call get_time( ihr, imin, isec, icsec )
	    if( icsec .ne. icsec_old ) then
		ntry = ntry + 1
		icsec_old = icsec
	    endif


C	    If 1401 is not yet in an idle condition after half
C	    of the retries, reset it with ESC I CR
C
	    IF( NTRY .EQ. MAXTRY/2 ) THEN
		STRING4 = CHAR(27)//'I'//char(13)
		IF(IFILE.NE.0) CALL WRITE_BYTES(IFILE,NW,ISTRING4,3)
		CALL WAIT(1.)
		CALL DISABLE_CED_TIMEOUT
		CALL WRITE_CED('ERR;')
	    ENDIF

	    if( ntry .gt. maxtry ) then
		call get_screen_device( idev )
		call close_workstation( idev )
		write(*,*) string
		stop ' Cannot get ERR; response from CED 1401 '
	    endif
	    goto 10
	endif

20	call check_ced_input( data_available )
	if( data_available ) then
	    call read_ced( response )
	    goto 20
	endif

	call enable_ced_timeout
	return
	end

	subroutine set_digital_output( ibyte )
	integer*4 ibyte4
	integer*2 ibyte2
	equivalence( ibyte4, ibyte2 )
	character*16 string

	string = 'DIG,O,$0000;'
	ibyte4 = ibyte
	ibyte4 = ibyte4 * 16#100
	call hex( ibyte2, string(8:11) )
	call write_ced( string )
	return
	end

	subroutine set_dac_output( vdac0, vdac1, vdac2, vdac3 )
	real vdac0,vdac1,vdac2,vdac3
	character*40 string
	parameter( bitv = 5. / 32768. )

	string = 'DAC,0 1 2 3,$0000 $0000 $0000 $0000;'
	call hex( int( vdac0 / bitv ),string(14:17))
	call hex( int( vdac1 / bitv ),string(20:23))
	call hex( int( vdac2 / bitv ),string(26:29))
	call hex( int( vdac3 / bitv ),string(32:35))
	call write_ced( string )
	return
	end

	subroutine set_dacs_ced( vdac, ndacs )
	real vdac(ndacs)
	character*40 string
	parameter( bitv = 5. / 32768. )

	string = 'DAC,       ,'
	do 10 i = 1,ndacs
	    j = (i-1)*2 + 5
	    write( string(j:j), '(i1)' ) i-1

	    j = 13 + (i-1)*6
	    string(j:j+6) = '$0000 ;'
	    call hex( int( vdac(i) / bitv ),string(j+1:j+4) )

10	continue
	call write_ced( string )
	return
	end

	subroutine tohost_ced(ioffset_1401,ibuffer,nbytes)
$INCLUDE: 'LABCEDC.FOR'
$INCLUDE: 'LABDMAB.FOR'
C
C --	Transfer data from 1401 memory to host memory buffer
c	ioffset_1401 ... Starting offset of data in 1401 memory
c	ibuffer ... Buffer to receive data in P.C.
c	nbytes ... No. of bytes to be transferred

	integer*2 ibuffer(1),ierr2(2)
	character string*30

C
C ----- Send address segment of DMA transfer buffer IBUFFER to 1401 driver
C	N.B. Ensure transfer area is contained within a single 64K memory page
C
	call check_dmab( ierr2, ibuffer, nbytes )
	IF(ierr2(1).NE.0) THEN
	    call abort(' tohost_ced: Data Buffer spans 64K block ')
	ENDIF

	CALL VARPTR(ISEG,IOFF,IBUFFER)
	CALL SET_CED_SEGMENT(ISEG)
	STRING = 'TOHOST,$0000,$0000,$0000;'
	CALL HEX(ioffset_1401,STRING(9:12))
	CALL HEX(NBYTES,STRING(15:18))
	CALL HEX(IOFF,STRING(21:24))
	CALL WRITE_CED(STRING)
	call wait_ced_done()
	return
	end


