C
C	================================================================
C	 LAB V2.7     Laboratory Interface Library (c) J. Dempster 1994
C	================================================================
C	1 = Cambridge Electronic Design 1401
C	2 = Data Translation DT2801
C	3 = Data Translation DT2801A
C	4 = Data Translation DT2821
C	5 = Data Translation DT2821F
c	6 = Labmaster (16 channel)
c	7 = Labmaster DMA (16 channel)
c	8 = Labmaster (16 channel)
c	9 = Labmaster DMA (8 channel)
c	10 = Reserved for external user supplied interface code
c	11 =Data Translation DT2801A + PC24',
c	12 =Data Translation DT2821  + PC24' /
c	13 = National Instruments LAB-PC/PC+
c	14 = National Instruments ATMIO-16X
c	15 = Axon Instruments Digidata 1200
c	16 = National Instruments ATMIO-16F
c
c	Revised 16th March 1991 to  include _EXTERNAL hooks (10)
C	Revised May 1991 to include LAB-PC
c	Revised Aug 1991 to include routine select_dagan_interface
c	Revised Sep 1992 to include CED 1401-plus
c	Revised Oct 1992 to improve D/A timing for LAB-PC
c	Revised Jan 1993 to work with LAB-PC+
c	Revised Mar 1993 coloured line added,
c	get_lab_interface_shortname() added
c	Revised Mar 1993 ATMIO-16X support added
c	Revised Apr 1993 get_lab_bit_range() added
c	Revised Jan 1994 Digidata 1200
c	Revised Apr 1994 N.I. ATMIO-16F
c       27/3/97 support for CED micro1401 added

	block data
$INCLUDE:'LABCOM.FOR'

	data card_list /
     &  ' CED 1401/1401-plus/Micro1401 ',
     &	' Data Translation DT2801',
     &	' Data Translation DT2801A',
     &	' Data Translation DT2821',
     &	' Data Translation DT2821G',
     &	' Labmaster     (16 channel)',
     &	' Labmaster DMA (16 channel)',
     &	' Labmaster     ( 8 channel)',
     &	' Labmaster DMA ( 8 channel)',
     &	' Data Translation DT2812',
     &	' Data Translation DT2801A + PC24',
     &	' Data Translation DT2821  + PC24',
     &	' National Instruments LAB-PC/PC+',
     &	' National Instruments ATMIO-16X',
     &	' Axon Instruments Digidata 1200',
     &	' National Instruments ATMIO-16F' /

	end

	subroutine select_lab_interface( inew_interface, name )
$INCLUDE:'LABCOM.FOR'
	character*(*) name
	character key
	logical new_menu
c
c	code
c
	new_Menu = .true.
	inew_interface = Iwait_MENU_VERTical1(card_list,'123456789ABCEFGH'
     &	,ncards,2,2,new_menu,max(inew_interface,1),
     &	' Select Laboratory Interface ',key)
	name = card_list(inew_interface)
	return
	end

	subroutine select_dagan_interface( inew_interface, name )
$INCLUDE:'LABCOM.FOR'
	character*(*) name
	character key
	logical new_menu
c
c	code
c
	new_Menu = .true.
	inew_interface = inew_interface - 5
	inew_interface = Iwait_MENU_VERTical1(card_list(6),'1234'
     &	,4,3,5,new_menu,max(inew_interface,1),
     &	' Select Labmaster configuration ',key)
	inew_interface = inew_interface + 5
	name = card_list(inew_interface)
	return
	end

	subroutine get_lab_interface_name( inew_interface, name )
$INCLUDE: 'LABCOM.FOR'
	character*(*) name
	name = card_list(inew_interface)
	return
	end

	subroutine get_lab_interface_shortname( inew_interface, name )
$INCLUDE: 'LABCOM.FOR'
	character*(*) name
	character*18 names(ncards)
	data names /
     &	'CED 1401/1401+ ',
     &	'DT2801',
     &	'DT2801A',
     &	'DT2821',
     &	'DT2821G',
     &	'Labmaster     (16)',
     &	'Labmaster DMA (16)',
     &	'Labmaster     ( 8)',
     &	'Labmaster DMA ( 8)',
     &	'DT2812',
     &	'DT2801A + PC24',
     &	'DT2821  + PC24',
     &	'N.I. LAB-PC/PC+',
     &	'N.I. ATMIO-16X',
     &	'Digidata 1200',
     &	'N.I. ATMIO-16F' /

	name = names(inew_interface)

	return
	end

	subroutine get_lab_bit_range( bits_min, bits_max )
$INCLUDE: 'LABCOM.FOR'
c
c	Integer range of A/D samples supplied by A/D converter
c
	real*4 range(2,ncards) /
     &	-32768.,32767.,
     &	0.,4095.,
     &	0.,4095.,
     &	0.,4095.,
     &	0.,4095.,
     &	-2048.,2047.,
     &	-2048.,2047.,
     &	-2048.,2047.,
     &	-2048.,2047.,
     &	0.,4095.,
     &	0.,4095.,
     &	0.,4095.,
     &	-2048.,2047.,
     &	-32768.,32767.,
     &	-32768.,32767.,
     &	-2048.,2047. /

	bits_min = range(1,interface)
	bits_max = range(2,interface)

	return
	end

	SUBROUTINE OPEN_LAB(ITYPE,ierr)
$INCLUDE: 'LABCOM.FOR'

C	ITYPE = Interface card type #
C	DT    = Sampling interval (ms). Note that it may be
C		   altered if it is outside the permitted range for the
C		   interface
C	IERR  = Error return flag 0=OK
C
C	CODE
C
	INTERFACE = ITYPE
	ierr = 0

	select case( interface )
	case( 1 )
	    CALL OPEN_CED(IERR)
	case( 2:3, 11 )
	    CALL OPEN_2801(INTERFACE,IERR)
	case( 4:5, 12 )
	    CALL OPEN_2821(INTERFACE,IERR)
	case( 6:7 )
	    call open_labmaster( 16 )
	case( 8:9 )
	    call open_labmaster( 8 )
	case( 10 )
	    call open_external( interface, ierr )
	case( 13 )
	    call open_labpc( ierr )
	case( 14 )
	    call open_atmio( ierr )
	case( 15 )
	    call open_digidata( ierr )
	case( 16 )
	    call open_atmio16f( ierr )
	case default
	    ierr = -1
	end select
	return
	end

	SUBROUTINE CLOSE_LAB()
$INCLUDE: 'LABCOM.FOR'
C
C	CODE
C

	select case( interface )
	case( 1 )
	    CALL close_CED(IERR)
	case( 2:3, 11 )
	    CALL adc_stop_2801()
	case( 4:5, 12 )
	    CALL adc_stop_2821()
	case( 6:9 )
	    call adc_stop_labmaster()
	case( 10 )
	    call adc_stop_external()
	case( 13 )
	    call adc_stop_labpc
	case( 14 )
	    call adc_stop_atmio
	case( 15 )
	    call adc_stop_digidata()
	case( 16 )
	    call adc_stop_atmio16f
	end select
	return
	end

	SUBROUTINE ADC_STOP()
$INCLUDE: 'LABCOM.FOR'
C
C	CODE
C
	select case( interface )
	case( 1 )
	    CALL adc_stop_CED(IERR)
	case( 2:3, 11 )
	    CALL adc_stop_2801()
	case( 4:5, 12 )
	    CALL adc_stop_2821()
	case( 6:9 )
	    call adc_stop_labmaster()
	case( 10 )
	    call adc_stop_external()
	case( 13 )
	    CALL adc_stop_labpc()
	case( 14 )
	    CALL adc_stop_atmio()
	case( 15 )
	    CALL adc_stop_digidata()
	case( 16 )
	    CALL adc_stop_atmio16f()
	end select
	return
	end

	SUBROUTINE CHECK_DT(DT)
$INCLUDE: 'LABCOM.FOR'
C
C	CODE
C
	select case( interface )
	case( 1 )
	    CALL CHECK_DT_CED(DT,iticks,iprescale)
	case( 2:3, 11 )
	    CALL CHECK_DT_2801(DT)
	case( 4:5, 12 )
	    CALL CHECK_DT_2821(DT)
	case( 6:9 )
	    call check_dt_labmaster( dt, iticks, ifreq )
	case( 10 )
	    call check_dt_external(dt)
	case( 13 )
	    CALL CHECK_DT_labpc(DT,ticksa,ticksb)
	case( 14 )
	    CALL CHECK_DT_atmio(DT,ticks,i)
	case( 15 )
	    CALL CHECK_DT_digidata(DT,iticks,i)
	case( 16 )
	    CALL CHECK_DT_atmio16f(DT,ticks,i)
	end select
	return
	end

	subroutine check_adc_range( interface_card, adc_range )
$INCLUDE: 'LABCOM.FOR'
	parameter(nr1=4)
	real*4 range1(nr1) / 10.,5.,2.5,1.25/
	parameter(nr2=8)
	real*4 range2(nr2) / 5., 4., 2.5, 1., 0.5, 0.25, 0.1, 0.05 /
	parameter(nr3=7)
	real*4 range3(nr3) / 10., 5., 2., 1.,0.5, 0.2, 0.1 /

	select case( interface_card )
	case( 1 )
c
c	    CED 1401
c
	    adc_range = 5.
	case( 2:11, 12, 15 )
c
c	    Data Translation, Labmasters & Digidata 1200
c
	    i = 1
	    do while((range1(i).gt.(adc_range+.01)) .and. (i.lt.nr1))
		i = i + 1
	    end do
	    adc_range = range1(i)
	case( 13 )
c
c	    LAB-PC
c
	    i = 1
	    do while((range2(i).gt.(adc_range+.01)) .and. (i.lt.nr2))
		i = i + 1
	    end do
	    adc_range = range2(i)
	case( 14,16 )
c
c	    ATMIO-16X, ATMIO-16F
c
	    i = 1
	    do while((range3(i).gt.(adc_range+.01)) .and. (i.lt.nr3))
		i = i + 1
	    end do
	    adc_range = range3(i)
	end select
	return
	end

	SUBROUTINE ADC_TO_MEMORY(DT,NCHAN,NPOINTS,ITRIG
     &,IBUFFER,ISTART,IMODE,ADC_RANGE,KEY_RETURNED)
$INCLUDE: 'LABCOM.FOR'
C
C	Transfer a stream of A/D samples from interface
C	to buffer in PC memory using DMA
C	===============================================
C
C
C	DT =         Group sampling period (ms)
C	N_CHANNELS = No. A/D channels in group
C	N_POINTS =   No. of sample groups held by IBUFFER
C	ITRIGGER =   1 Wait for external trigger before starting sampling
C	             0 Start sampling immediately
C	IBUFFER =    DMA Memory buffer to hold ADC samples
C	ISTART =     Starting point in IBUFFER
C			   either 1, or (N_POINTS*N_CHANNEL)/2 + 1
C	IMODE =      0 Wait till IBUFFER is full before returning
C	             1 Return once sampling has started, collect
C	               a single buffer-ful
C	             2 Return once sampling has started, keep
C	               filling IBUFFEr circulerly until told to stop
C	ADC_RANGE =      1.25,2.5,5,10V A/D INPUT RANGE
C	KEY_RETURNED = Key pressed by user during sampling
C
	integer*2 ibuffer(1)
	CHARACTER*(*) KEY_RETURNED
C
C	CODE
C
$if defined( demo )
	return
$elseif defined( dagan )
	if( interface .lt. 6 ) return
$endif

C	If interface isn't set-up, return ESC

	IF(INTERFACE .EQ. 0) THEN
		KEY_RETURNED = '$'
		RETURN
	ELSE
		KEY_RETURNED = CHAR(0)
	ENDIF
c
c	Place marker at end of ADC buffer to provide an indication
c	(when it is overwritten) that the buffer is filled
c
	ibuffer(nchan*npoints) = imark
	ibuffer(2*nchan*npoints) = imark
	call find_para_start( ibuffer, istart )
	ibuffer( nchan*npoints + istart - 1) = imark

	select case( interface )
	case( 1 )
	    CALL ADC_TO_MEMORY_CED(DT,NCHAN,NPOINTS,ITRIG
     &	   ,IBUFFER,ISTART,IMODE,ADC_RANGE,KEY_RETURNED)
	case( 2:3, 11 )
	    CALL ADC_TO_MEMORY_2801(DT,NCHAN,NPOINTS,ITRIG
     &	    ,IBUFFER,ISTART,IMODE,ADC_RANGE,KEY_RETURNED)
	case( 4:5, 12 )
	    CALL ADC_TO_MEMORY_2821(DT,NCHAN,NPOINTS,ITRIG
     &	    ,IBUFFER,ISTART,IMODE,ADC_RANGE,KEY_RETURNED)
	case( 6:9 )
	    CALL ADC_TO_MEMORY_labmaster(DT,NCHAN,NPOINTS,ITRIG
     &	    ,IBUFFER,ISTART,IMODE,ADC_RANGE,KEY_RETURNED)
	case( 10 )
	   CALL ADC_TO_MEMORY_external(DT,NCHAN,NPOINTS,ITRIG
     &	   ,IBUFFER,ISTART,IMODE,ADC_RANGE,KEY_RETURNED)
	case( 13 )
	   CALL ADC_TO_MEMORY_labpc(DT,NCHAN,NPOINTS,ITRIG
     &	   ,IBUFFER,ISTART,IMODE,ADC_RANGE,KEY_RETURNED)
	case( 14 )
	   CALL ADC_TO_MEMORY_atmio(DT,NCHAN,NPOINTS,ITRIG
     &	   ,IBUFFER,ISTART,IMODE,ADC_RANGE,KEY_RETURNED)
	case( 15 )
	   CALL ADC_TO_MEMORY_digidata(DT,NCHAN,NPOINTS,ITRIG
     &	   ,IBUFFER,ISTART,IMODE,ADC_RANGE,KEY_RETURNED)
	case( 16 )
	   CALL ADC_TO_MEMORY_atmio16f(DT,NCHAN,NPOINTS,ITRIG
     &	   ,IBUFFER,ISTART,IMODE,ADC_RANGE,KEY_RETURNED)
	end select
	return
	end

	SUBROUTINE MEMORY_TO_DAC(DT,NCHAN,NPOINTS,ITRIG
     &,IBUFFER,IMODE,IERR)
$INCLUDE: 'LABCOM.FOR'
C
C	Transfer a stream of D/A values from a memory buffer
C	to the interface
C	====================================================
C
$if defined( demo )
	return
$elseif defined( dagan )
	if( interface .lt. 6 ) return
$endif

	select case( interface )
	case( 1 )
	    CALL MEMORY_TO_DAC_CED(DT,NCHAN,NPOINTS,ITRIG
     &	    ,IBUFFER,IMODE,IERR)
	case( 2:3 )
	    CALL MEMORY_TO_DAC_2801(DT,NCHAN,NPOINTS,ITRIG
     &	    ,IBUFFER,IMODE,IERR)
	case( 4:5 )
	    CALL MEMORY_TO_DAC_2821(DT,NCHAN,NPOINTS,ITRIG
     &	    ,IBUFFER,IMODE,IERR)
	case( 6:9 )
	     call memory_to_dac_labmaster( dt, nchan, npoints, itrig,
     &	     ibuffer, imode, ierr )
	case( 10 )
	     CALL MEMORY_TO_DAC_external(DT,NCHAN,NPOINTS,ITRIG
     &	     ,IBUFFER,IMODE,IERR)
	case( 11:12 )
	     call memory_to_dac_pc24( dt, nchan, npoints, itrig,
     &	     ibuffer, imode, ierr )
	case( 13 )
	     call memory_to_dac_labpc(dt,nchan,npoints,itrig,
     &	     ibuffer, imode, ierr )
	case( 14 )
	     call memory_to_dac_atmio( dt, nchan, npoints, itrig,
     &	     ibuffer, imode, ierr )
	case( 15 )
	     call memory_to_dac_digidata(dt,nchan,npoints,ibuffer)
	case( 16 )
	     call memory_to_dac_atmio16f( dt, nchan, npoints, itrig,
     &	     ibuffer, imode, ierr )
	end select
	return
	end

	subroutine dac_stop()
$include: 'labcom.for'
c
c	Abort D/A output sweep
c
	select case( interface )
	case( 1 )
	    call dac_stop_ced()
	case( 6:9 )
	     call dac_stop_labmaster()
	case( 10 )
	     call dac_stop_external()
	case( 11:12 )
	     call dac_stop_pc24()
	case( 13 )
	     call dac_stop_labpc()
	case( 14 )
	     call dac_stop_atmio()
	case( 15 )
	     call dac_stop_digidata()
	case( 16 )
	     call dac_stop_atmio16f()
	end select
	return
	end

	subroutine set_dacs( vdacs, ndacs )
$include: 'labcom.for'
c
c	Set <ndacs> D/A output channels to values (mV) in array <vdacs>
c
	select case( interface )
	case( 1 )
	    call set_dacs_ced( vdacs, ndacs )
	case( 6:9 )
	     call set_dacs_labmaster( vdacs, ndacs )
	case( 10 )
	     call set_dacs_external( vdacs, ndacs )
	case( 11:12 )
	     call set_dacs_pc24( vdacs, ndacs )
	case( 13 )
	     call set_dacs_labpc( vdacs, ndacs )
	case( 14 )
	     call set_dacs_atmio( vdacs, ndacs )
	case( 15 )
	     call set_dacs_digidata( vdacs, ndacs )
	case( 16 )
	     call set_dacs_atmio16f( vdacs, ndacs )
	end select
	return
	end


       SUBROUTINE TO_DISC(IFILE,IERR,IBUFFER,NBYTES,NBUFFERS
     &,ISTART,NWRITTEN)
$INCLUDE: 'LABCOM.FOR'
	INTEGER IBUFFER(1)
C
C	Copy A/D samples from IBUFFER to a disc file in a continuous
C	stream to disc file. IBUFFER is filled by DMA.
C
C	IFILE = File handle no.
C	IERR = Error return flag 0=OK
C	IBUFFER = DMA memory buffer
C	NBYTES = No. bytes per buffer
C	NBUFFERS = No. of buffer-fuls to be copied to file
C	ISTART = Starting sector on file
C	NWRITTEN = No. of buffer-fuls actually written after completion
C
	logical wait_lo
	integer*4 ipointer4
	integer*2 ipointer(2)
	equivalence ( ipointer4, ipointer )
	character key
	logical special
c
c	code
c
$if defined( demo )
	return
$elseif defined( dagan )
	if( interface .lt. 6 ) return
$endif

	call find_cursor(ix,iy)

	ilo_buf = 1
	ihi_buf = nbytes/4 + 1
	nbytes_half = nbytes/2
	isector = istart
	nsectors = nbytes/512
	nsectors_half = nsectors/2
	nwritten = 0
c
c	Move file pointer to start of data area
c
	ipointer4 = istart-1
	ipointer4 = ipointer4*512

	call move_file_pointer( ifile, ierr, ipointer(1), ipointer(2) )

	ibuffer(ihi_buf) = imark
	wait_lo = .true.

	do while( nwritten .lt. nbuffers )

	     if( wait_lo .and. (ibuffer(ihi_buf).ne.imark)) then

		call write_bytes(ifile,nw,ibuffer(ilo_buf),nbytes_half)
		isector = isector + nsectors_half
		wait_lo = .false.
		ibuffer(ilo_buf) = imark

	     elseif((.not.wait_lo).and.(ibuffer(ilo_buf).ne.imark)) then

		call write_bytes(ifile,nw,ibuffer(ihi_buf),nbytes_half)
		isector = isector + nsectors_half
		ibuffer(ihi_buf) = imark
		wait_lo = .true.
		nwritten = nwritten + 1
		call move_cursor(ix,iy)
		call display_string('Buffers done ')
		call display_int(nwritten)
		call get_key( key, special )
		if( key .eq. '$' ) goto 200

	    endif
	end do
200	continue

	call adc_stop

	call display_string(' ... WAIT ... ')
	isector = istart
	do i = 1,nwritten
	    call read_file(ifile,ierr,ibuffer,isector,nsectors)
	    call convert_adc_values( ibuffer, nbytes/2 )
	    call write_file(ifile,ierr,ibuffer,isector,nsectors)
	    isector = isector + nsectors
	end do
	return
	end


	SUBROUTINE DETECT_EVENT(IWORK_BUFFER,IBUFFER_OUT,NSAMPLES
     &,ITRIGGER,NPRE,IESC,IKEY)
	INTEGER IWORK_BUFFER(1),IBUFFER_OUT(1)
$INCLUDE: 'LABCOM.FOR'
C
$if defined( demo )
	return
$elseif defined( dagan )
	if( interface .lt. 6 ) return
$endif
	logical convert

	IF(INTERFACE .EQ. 0) THEN
		IKEY = ICHAR('$')
		RETURN
	ENDIF
c
c	23/FEB/93 ...
	if( ikey .eq. -1 ) then
	    convert = .false.
	else
	    convert = .true.
	end if

	select case( interface )
	case( 1 )
	    CALL DETECT_EVENT_CED(IWORK_BUFFER,IBUFFER_OUT,NSAMPLES
     &	    ,ITRIGGER,NPRE,IESC,IKEY)
	case( 2:3, 7, 9, 11, 13 )
c
c	    8 bit DMA channel 1 detection routine
c	    DT2801, DT2801A, Labmaster DMA, LAB-PC,
c
	    CALL DETECT_EVENTB(IWORK_BUFFER,IBUFFER_OUT,NSAMPLES
     &	    ,ITRIGGER,NPRE,IESC,IKEY)
	case( 4:5, 12 )
c
c	    16 bit DMA channel 5 detection routine
c	    DT2821, DT2821F, ATMIO-16X
c
	    CALL DETECT_EVENTW(IWORK_BUFFER,IBUFFER_OUT,NSAMPLES
     &	    ,ITRIGGER,NPRE,IESC,IKEY)
	case( 6, 8 )
c
c	    Interrupt driven detection routine
c	    Labmaster (without DMA)
c
	    CALL DETECT_EVENTI(IWORK_BUFFER,IBUFFER_OUT,NSAMPLES
     &	    ,ITRIGGER,NPRE,IESC,IKEY)
	case( 10 )
c
c	    Call user supplied detection  routine
c
	    CALL DETECT_EVENT_external(IWORK_BUFFER,IBUFFER_OUT,NSAMPLES
     &	    ,ITRIGGER,NPRE,IESC,IKEY)

	case( 14 )
c
c	    National Instrument ATMIO-16X

	    CALL DETECT_EVENT_atmio(IWORK_BUFFER,IBUFFER_OUT,NSAMPLES
     &	    ,ITRIGGER,NPRE,IESC,IKEY)

	case( 15 )
c
c	    Digidata 1200

	    CALL DETECT_EVENT_digidata(IWORK_BUFFER,IBUFFER_OUT,
     &	    NSAMPLES,ITRIGGER,NPRE,IESC,IKEY)

	case( 16 )
c
c	    National Instruments ATMIO-16F

	    CALL DETECT_EVENT_atmio16f(IWORK_BUFFER,IBUFFER_OUT,
     &	    NSAMPLES,ITRIGGER,NPRE,IESC,IKEY)



	case default
	    call move_cursor(1,1)
	    call display_string(' Not Implemented ')

	end select

	if( convert ) call convert_adc_values( ibuffer_out, nsamples )
	return
	end

	SUBROUTINE LAB_LIMITS(ITYPE,DT_MIN,DT_MAX,AD_MIN,AD_MAX,DAC)
$include:'labcom.for'
C
	REAL*4 RANGE(5,ncards)
C
	DATA RANGE /
     & 0.01, 1.E6, 5.,	  5.,  5.,
     & 0.08,81.9, 1.25, 10., 10.,
     & 0.04,40.9, 1.25, 10., 10.,
     & 0.02,4000., 1.25, 10., 10.,
     & 0.004,4000.,1.25,10.,10.,
     & 0.04,  1.E6,   1.25,   10.,   10.,
     & 0.01,  1.E6,   1.25,   10.,   10.,
     & 0.04,  1.E6,   1.25,   10.,   10.,
     & 0.01,  1.E6,   1.25,   10.,   10.,
     & 0.,  1E30,    0.,   1E30,   10.,
     & 0.04,40.9, 1.25, 10., 10.,
     & 0.02,4000., 1.25, 10., 10.,
     & 0.02,1E30, 0.05, 5., 5.,
     & 0.01,1E30, 0.1, 10., 10.,
     & 0.005, 1E30, 1.25, 10., 10.,
     & 0.005, 1E30, 0.1,10.,10. /
C
	DT_MIN = RANGE(1,ITYPE)
	DT_MAX = RANGE(2,ITYPE)
	AD_MIN = RANGE(3,ITYPE)
	AD_MAX = RANGE(4,ITYPE)
	DAC = RANGE(5,ITYPE)
	RETURN
	END

	SUBROUTINE GET_DMA_COUNT(ICOUNT)
$INCLUDE: 'LABCOM.FOR'
C
C	Read DMA count register
C
	select case( interface )
	case( 1:3, 7, 9, 11, 13 )
	    CALL GET_DMAB_COUNT(ICOUNT)
	case( 4:5, 12 )
	    CALL GET_DMAW_COUNT(ICOUNT)
	    ICOUNT = ICOUNT*2 + 1
	case( 6, 8 )
	    call get_adc_count_labmaster( icount )
	    icount = icount - 1
c
c	    Note <icount> is altered to run from <max_counts>-1 to -1
c	    this makes it compatible with DMA byte counter
c
	case( 10 )
	    call get_dma_count_external(icount)
	case( 14 )
	    call get_dma_atmio( icount )
	case( 15 )
	    call get_dma_count_digidata( icount )
	    icount = icount*2 + 1
	case( 16 )
	    call get_dma_count_atmio16f( icount )
	    icount = icount*2 + 1
	case default
	    call move_cursor(1,1)
	    call display_string(' Not Implemented ')

	end select

	return
	end

	SUBROUTINE DISPLAY_ADC(iscREEN,IBUF,N_POINTS,N_CHANNELS
     &,IDISPLAY_AREA,icolour,ERASE_SCREEN,KEY_RETURNED)
	INTEGER*2 IDISPLAY_AREA(4),IBUF(1),icolour(1)
	CHARACTER*(*) KEY_RETURNED
	LOGICAL ERASE_SCREEN
$INCLUDE: 'LABCOM.FOR'
$include: 'labdigc.for'
C	Display ADC samples as they are placed into buffer IBUF under
C	DMA (set-up by ADC_TO_MEMORY)
C
C	ISCREEN ... Scren workstation no.
C	IBUF ... Buffer being filled with ADC samples
C	N_POINTS ... Total samples (per channel) to be placed in IBUF
C	N_CHANNELS ... No. of channels being recorded
C	IDISPLAY_AREA ... Array defining display area on screen
C	(1)=left,(2)=bottom,(3)=right,(4)=top
c	icolour(n_channels) = Channel colours
C	ERASE_SCREEN ... .TRUE. requests screen to be erased
C				Note that it is returned .FALSE.
C	KEY_RETURNED ... Returns key pressed during sampling sweep

	CHARACTER*10 STRING
	CHARACTER KEY
	LOGICAL SPECIAL
	integer*4 iy4
	parameter(nmax=512)
	integer*2 ixy(nmax)

C	CODE
C	----

$if defined( demo )
	return
$elseif defined( dagan )
	if( interface .lt. 6 ) return
$endif


	n_samples = n_points*n_channels
	nmin = n_channels*2
	n_end = n_samples - nmin - 1

C	Initialise elapsed time counter
C
	clock_start = time_in_secs()

C	Set-up X and Y plotting scale factors

	DX = float(IDISPLAY_AREA(3)-IDISPLAY_AREA(1))/float(n_samples)
	IY_SCALE = (IDISPLAY_AREA(4)-IDISPLAY_AREA(2))/4096

C	MAIN DISPLAY LOOP
C	-----------------

	key = char(0)
	ip0 = 1
	ip1 = 1
	do while( ( ip0.lt. n_end .or. ibuf(n_samples).eq.imark ) .and.
     &		  key.ne.'$' )

	    do while( ibuf(ip1) .ne. imark .and. ip1.le.n_samples )
		ip1 = ip1 + 1
	    end do
	    ip1 = max(ip1-1,1)

	    if( ip1 .ge. (ip0 + nmin) ) then

C		 If ERASE_SCREEN has been requested, do it now

		 IF( ERASE_SCREEN ) THEN

C		    **** NOTE ********************************************
C		    A delay of 100ms inserted to prevent problem with DMA
C		    (At 0.05ms sampling intervals DMA appears to lock up
C		    after screen is erased. Origin of this problem unknown)

		    CALL WAIT(0.1)
		    CALL FILL_RECTANGLE(ISCREEN,IDISPLAY_AREA)
		    ERASE_SCREEN = .FALSE.
		 ENDIF

C		 Plot each channel separately

		 do ichannel = 1,n_channels

		     call set_polyline_colour(iscreen,icolour(ichannel))

		     j = 0
		     ip = ip0
		     do while( (j .lt. nmax) .and. (ip.lt.ip1) )

c			 X coordinate
C
			 j = j + 1
			 ixy(j) = int(float(ip)*dx) + idisplay_area(1)

c			  Y coord. (Note re-scaling to 0-4095 range)
C
			 ic = ip + ichannel - 1
			 select case( interface )
			 case( 1, 14, 15 )
			     iy4 = ibuf(ic)	      ! CED 1401
			     iy4 = iy4/16	      ! ATMIO-16X
			     iy = iy4 + 2048	      ! Digidata 1200
			 case( 6:9, 13, 16 )
			     iy = ibuf(ic) + 2048     ! Labmaster, LAB-PC
						      ! ATMIO-16F
			 case( 10 )
			    iy = ibuf(ic)
			    call convert_adc_values( iy, 1 )
			 case default
			     iy = ibuf(ic)	      ! all others
			 end select

			 j = j + 1
			 ixy(j) = iy*iy_scale + idisplay_area(2)
			 ip = ip + n_channels

		     end do

C		     Plot line
C
		     call polyline( iscreen, ixy, j/2 )
		 end do

c
C		 All points plotted, so move IP0 up to last set of
C		 N_CHANNEL points before latest (to ensure that there are
C		 no gaps in lines)
C
		 ip0 = max(ip - n_channels,1)

C		 Display time elapsed since start of recording
C		 in bottom-right corner of screen

		 clock_time = time_in_secs()
		 ELAPSED_TIME = CLOCK_TIME - CLOCK_START
		 CALL MOVE_CURSOR(70,25)
		 WRITE(STRING,'(i4,''s'')') int(ELAPSED_TIME)
		 CALL DISPLAY_STRING(STRING(1:5))
	    ENDIF
c
C	    Read keyboard to see if user has done anything
C
	    CALL GET_KEY( KEY, SPECIAL )
	    IF( KEY .NE. CHAR(0) ) KEY_RETURNED = KEY
	    if( key .eq. '$' ) call adc_stop

	end do

C	EXIT PROCEDURE
C	==============
C
c	 call adc_stop()

c	Convert to 12 bit offset binary format
c
	call convert_adc_values( ibuf, n_samples )


C	THIS IS A BODGE ... The 1401 DMA seems to wrap
C	round for one sample before stopping, overwriting
C	the first point in IBUF. This is a temporary fix
C
	IBUF(1) = IBUF(N_CHANNELS+1)

	call set_polyline_colour(iscreen,1)

	RETURN
	END


	SUBROUTINE CHECK_DMA_DONE( DMA_DONE )
	LOGICAL DMA_DONE
$INCLUDE: 'LABCOM.FOR'
C
C	Return DMA_DONE = .TRUE. if DMA sweep has terminated
C
	select case( interface )
	case( 1 )
	    CALL CHECK_CED_DONE(DMA_DONE)
	case( 2:3, 7, 9, 11, 13, 14 )
	    CALL CHECK_DMAB_DONE(DMA_DONE)
	case( 4:5, 12 )
	    CALL CHECK_DMAW_DONE(DMA_DONE)
	case( 6, 8  )
	    call check_adc_done_labmaster( dma_done )
	case( 10 )
	    call check_adc_done_external( dma_done )
	case default
	    call move_cursor(1,1)
	    call display_string(' Not Implemented ')
	end select
	return
	end

	real function time_in_secs()
	call get_time( ihour, imin, isec, icsec )
	time_in_secs = (float(ihour)*60. + float(imin))*60.
     &	+ float(isec) + float(icsec)/100.
	return
	end

	subroutine abort( string )
	character*(*) string

	call get_screen_device( idev )
	if( idev .ne. 0 ) call close_workstation( idev )
	write(*,'(1x,a)') string
	stop
	end

	subroutine allocate_dac_buffer(idac,istart,idac0,np)
$include:'labcom.for'
	integer*2 idac(1),ierr2(2)
c
c	Find a valid portion of array <idac> which does not
c	span 64Kbyte memory pages (for DMA transfers) or
c	is 16byte paragraph aligned for interrupt transfer
c
	select case( interface )
	case( 1:5, 16 )
c
c	    Interfaces which use 8 or 16 bit DMA
c
	    nbytes = np*2
	    idac0 = istart
	    call check_dmab( ierr2, idac(idac0),nbytes)
	    if( ierr2(1) .ne. 0 ) then
		idac0 = istart + np
		call check_dmab( ierr2, idac(idac0), nbytes )
		if( ierr2(1) .ne. 0 ) call abort(
     &		'ALLOCATE_DAC_BUFFER: DMA PAGE ERROR')
	    endif
	case( 6:9, 11:13  )
c
c	    Interfaces which use interrupts
c	    Labmaster, PC24, LAB-PC
c
	    call find_para_start( idac(istart), idac0 )
	    idac0 = istart + idac0 - 1
	case( 10 )
	    call allocate_dac_buffer_external(idac,istart,idac0,np)
	case( 14:15 )
c
c	    ATMIO, Digidata
	    idac0 = istart

	end select
	return
	end

	subroutine allocate_adc_buffer(iadc,istart,iadc0,np)
$include:'labcom.for'
	integer*2 iadc(1),ierr2(2)
c
c	Find a valid portion of array <iadc> which does not
c	span 64Kbyte memory pages (for DMA transfers) or
c	is 16byte paragraph aligned for interrupt transfer
c
	select case( interface )
	case( 1:5, 7, 9, 11:16	)
c
c	    Interfaces which use 8 or 16 bit DMA
c	    CED 1401, DT2801/A, Labmaster DMA, LAB-PC, ATMIO-16X, ATMIO-16F
c	    & Digidata 1200
c
	    nbytes = np*2
	    iadc0 = istart
	    call check_dmab( ierr2, iadc(iadc0),nbytes)
	    if( ierr2(1) .ne. 0 ) then
		iadc0 = istart + np
		call check_dmab( ierr2, iadc(iadc0), nbytes )
		if( ierr2(1) .ne. 0 ) call abort(
     &		'ALLOCATE_ADC_BUFFER: DMA PAGE ERROR')
	    endif
	case( 6, 8 )
c
c	    Interfaces which use interrupts
c
	    call find_para_start( iadc(istart), iadc0 )
	    iadc0 = istart + iadc0 - 1
	case( 10 )
	    call allocate_adc_buffer_external(iadc,istart,iadc0,np)
	end select
	return
	end

	subroutine check_dt_dac( dt )
$include:'labcom.for'
c
c	Adjust DAC update interval <dt> so that it is a valid
c	multiple of the lab. interface's clock (or system clock) period.
c
	integer*4 iperiod4,idiv4

	select case( interface )
	case( 1:5 )
c
c	    Interfaces which use their internal pacer clock for DAC timing
c
	    call check_dt( dt )
	case( 6:9, 11:12 )
c
c	    Interfaces which use the PC system clock for DAC timing
c	    Labmaster, PC24, LAB-PC
c
	    call check_dt_system( dt, iperiod4, idiv4 )
	case( 13 )
	    call check_dt_labpc( dt, ticksA, ticksB )
	case( 14 )
	    call check_dt_atmio( dt, ticks, i )
	case( 10 )
	    call check_dt_dac_external(dt)
	case( 15 )
	    CALL CHECK_DT_digidata(DT,iticks,i)
	case( 16 )
	    call check_dt_atmio16f( dt, ticks, i )
	end select
	return
	end

	subroutine convert_adc_values( ibuffer, np )
$include:'labcom.for'
	integer*2 ibuffer(np)
c
c	Convert A/D sample values from native form of lab. interface
c	to 12 bit offset binary (ie. 0-4095 with 2048= 0V)
c
	integer*4 iy4

	select case( interface )
	case( 1, 14 )
c
c	    CED 1401, ATMIO-16X (boards which supply A/D sample
c	    in 16 bit form)
c
	    DO I = 1,np
		iy4 = ibuffer(i)
		iy4 = iy4 / 16
		IBUFFER(I) = iy4 + 2048
	    end do
	case( 6:9, 13, 16 )
c
c	    Labmaster, LAB-PC, ATMIO-16F
c
	    call add_array( 2048, ibuffer, np )
	case( 10 )
	    call convert_adc_values_external(  ibuffer, np )
	case( 15 )
	    call convert_adc_values_digidata(  ibuffer, np )
	end select
	return
	end

	subroutine check_adc_sweep(ibuf,n_points,n_channels,done)
$include:'labcom.for'
	integer*2 ibuf(1)
	logical done

	if( ibuf(n_points*n_channels) .eq. imark ) then
	    done = .false.
	else
	    done = .true.
	end if
	return
	end

	subroutine digital_out( ibyte )
$include:'labcom.for'
c
c	Set an 8 bit digital output port
c
	select case( interface )
	case( 6:9 )
	    call digital_out_labmaster( ibyte )
	end select
	return
	end

	subroutine display_bits( ibyte )
	character*18 string
	call bits( ibyte, string )
	call display_string(string)
	return
	end

	subroutine bits( ibyte, string )
	integer*2 ibyte
	character*(*) string
	integer*4 ibit,ib4

	ibit = 1
	ib4 = ibyte
	do i = 16,1,-1
	    j = ibit .and. ib4
	    if( j .ne. 0 ) then
		string(i:i) = '1'
	    else
		string(i:i) = '0'
	    end if
	    ibit = ibit*2
	end do
	return
	end

	subroutine mark_buffer( ibuf, np )
	integer*2 ibuf(np)
$include:'labcom.for'
c
c	Place marker number into buffer
c	(Used by DISPLAY_ADC to regulate sweep)

	do i = 1,np
	    ibuf(i) = imark
	end do
	return
	end

	subroutine check_sweep( ibuf, np, end_of_sweep, key )
$include:'labcom.for'
$include:'labdigc.for'
	integer*2 ibuf(np)	! A/D data buffer
	integer*2 np		! No. of points in ibuf
	logical end_of_sweep	! .true. if sweep is done
	character key		! Key pressed by user

	real*4 old_time /0./
	logical special

	key = char(0)
	clock_time = time_in_secs()
	if( clock_time .lt. old_time ) old_time = clock_time - .2
	if( clock_time .gt. (old_time + 0.1) ) then
	    CALL GET_KEY(KEY,SPECIAL)
	    old_time = clock_time
	endif

	if( (ibuf(np) .ne. imark ) .or. (key.eq.'$') ) then
	    end_of_sweep = .true.
	else
	    end_of_sweep = .false.
	end if

	return
	end

	integer*2 function num_trigger_modes()
$include:'labcom.for'

	integer*2 ntrigger_modes(ncards)
     &	/ 4,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4 /

	num_trigger_modes = ntrigger_modes(interface)

	return
	end

	subroutine get_adc_ranges( interface_card, adc, nr )
$include:'labcom.for'
	real*4 adc(1)
	integer*2 nr

	select case( interface_card )
	case( 1 )
	    adc(1) = 5.     ! CED 1401
	    nr = 1
	case( 2:12, 15 )
	    adc(1) = 10.    ! Data Translation, Labmaster, Digidata 1200
	    adc(2) = 5.     ! interfaces
	    adc(3) = 2.5
	    adc(4) = 1.25
	    nr = 4
	case( 13 )
	    adc(1) = 5.     ! National Instruments Lab-PC
	    adc(2) = 4.
	    adc(3) = 2.5
	    adc(4) = 1.
	    adc(5) = 0.5
	    adc(6) = 0.25
	    adc(7) = 0.1
	    adc(8) = 0.05
	    nr = 8
	case( 14, 16 )
	    adc(1) = 10.     ! National Instruments ATMIO-16X, 16F
	    adc(2) = 5.
	    adc(3) = 2.5
	    adc(4) = 1.
	    adc(5) = 0.5
	    adc(6) = 0.25
	    adc(7) = 0.1
	    adc(8) = 0.05
	    nr = 8
	end select

	return
	end

	real function dac_min_interval()
$include:'labcom.for'
	select case( interface )
	case( 1:14 )
	    dac_min_interval = 1.
	case( 15:16 )
	    dac_min_interval = 0.05
	end select
	return
	end

	subroutine get_adc_resolution(interface, bits_min, bits_max )
	select case (interface)
	case( 1, 14, 15 )
	    bits_min = -32768.
	    bits_max = 32767.
	case( 2:5, 10:12 )
	    bits_min = 0.
	    bits_max = 4095.
	case( 6:9, 13, 16 )
	    bits_min = -2047.
	    bits_max = 2048.
	end select
	return
	end
