$NOTRUNCATE
$STORAGE:2
	SUBROUTINE YT_PLOT(IDEVICE,IYT,NP)
C
C	Plot an array of 12 bit integers with 0 - 4095 range
C	as a Y vs T array.
C
	INTEGER IYT(1)
C
$INCLUDE:'GEMCOM.FOR'
C
	IX_SPACING = (NDC_XMAX - NDC_XMIN)/NP
	IX = NDC_XMIN + ix_spacing
	iyscale = (ndc_ymax - ndc_ymin) / 4096
	NPLOT = NP
	is1 = 1
9	IF( NPLOT .gt. 127 ) then
C
C	    Plot groups of 128 points
C
	    ix = ix - ix_spacing
	    is0 = is1
	    is1 = is0 + 127
	    j = 1
	    DO 10 is = is0,is1
		IPTSIN(J) = IX
		J = J + 1
		IPTSIN(J) = iyt(is)*iyscale + ndc_ymin
		J = J + 1
		IX = IX + IX_SPACING
10	    CONTINUE
	    CALL POLYLINE(IDEVICE,IPTSIN,128)
	    NPLOT = NPLOT - 127
	    goto 9
	endif

20	IF( NPLOT .GT. 1 ) THEN
C
C	    Plot any remaining points
C
	    ix = ix - ix_spacing
	    is0 = is1
	    is1 = is0 + nplot - 1
	    j = 1
	    DO 21 is = is0,is1
		IPTSIN(J) = IX
		J = J + 1
		IPTSIN(J) = iyt(is)*iyscale + ndc_ymin
		J = J + 1
		IX = IX + IX_SPACING
21	    CONTINUE
	    CALL POLYLINE(IDEVICE,IPTSIN,nplot)
	ENDIF

	RETURN
	END


	SUBROUTINE YT_CALIBRATION(IDEVICE,IX,IY,LENGTH
     &	,ICHAR_W,ICHAR_H,CALIB,UNITS,ORIENTATION)
$INCLUDE:'GEMCOM.FOR'
C
C	Draw a calibration bar starting at coord. <IX,IY> of
C	<LENGTH> NDC units.  <CALIB> is size of bar in units <UNITS>
C	<ORIENTATION>='H' indicates horizontal, 'V' vertical.
C
	CHARACTER*(*) UNITS,ORIENTATION 
	CHARACTER STRING*12,value*12
C
C	CODE
C	----
C
	IF(ORIENTATION(1:1).EQ.'H') THEN
C
C		Plot first terminal bar
C
		IPTSIN(1) = IX
		IPTSIN(2) = IY + ICHAR_H/2
		IPTSIN(3) = IX
		IPTSIN(4) = IY - ICHAR_H/2
		CALL POLYLINE(IDEVICE,IPTSIN,2)
C
C		Plot second terminal bar
C
		IPTSIN(1) = IX + LENGTH
		IPTSIN(3) = IX + LENGTH
		CALL POLYLINE(IDEVICE,IPTSIN,2)
C
C		Plot cross bar
C
		IPTSIN(1) = IX
		IPTSIN(2) = IY
		IPTSIN(3) = IX + LENGTH
		IPTSIN(4) = IY
		CALL POLYLINE(IDEVICE,IPTSIN,2)
C
C		Plot calibration
C
		IPTSIN(1) = IX + length + ichar_w
		IPTSIN(2) = IY - ichar_h

		WRITE(value,'(f8.2)') CALIB
		ie = 8
		do while( (value(ie:ie) .eq. ' ') .or.
     &		(value(ie:ie) .eq. '0' ) )
		    ie = ie - 1
		end do
		is = ileading_space( value )
		string = value(is:ie)//units
		ie = itrailing_space( string )
		CALL GRAPHICS_TEXT(IDEVICE,IPTSIN,STRING(1:ie))
C
	ELSE
C
C	----	Y axis bar ----------------------------------------------
C	
C		Plot first terminal bar
C
		IPTSIN(1) = IX + ICHAR_W/2
		IPTSIN(2) = IY 
		IPTSIN(3) = IX - ICHAR_W/2
		IPTSIN(4) = IY
		CALL POLYLINE(IDEVICE,IPTSIN,2)
C
C		Plot second terminal bar
C
		IPTSIN(2) = IY + LENGTH
		IPTSIN(4) = IY + LENGTH
		CALL POLYLINE(IDEVICE,IPTSIN,2)
C
C		Plot cross bar
C
		IPTSIN(1) = IX
		IPTSIN(2) = IY
		IPTSIN(3) = IX 
		IPTSIN(4) = IY + LENGTH
		CALL POLYLINE(IDEVICE,IPTSIN,2)
C
C		Plot calibration
C
		IPTSIN(1) = IX + ICHAR_W
		IPTSIN(2) = IY + LENGTH

		WRITE(value,'(f8.2)') CALIB
		ie = 8
		do while( (value(ie:ie) .eq. ' ') .or.
     &		(value(ie:ie) .eq. '0' ) )
		    ie = ie - 1
		end do
		is = ileading_space( value )
		string = value(is:ie)//units
		ie = itrailing_space( string )
		CALL GRAPHICS_TEXT(IDEVICE,IPTSIN,STRING(1:ie))


	ENDIF
	RETURN
	END


	SUBROUTINE YT_HORIZONTAL_CURSOR(IDEVICE,IY_IN)
C
C	Draw a horizontal cursor within YT display area
C
$INCLUDE:'GEMCOM.FOR'
C
	IY_SCALE = (NDC_YMAX - NDC_YMIN)/4096
	IPTSIN(1) = NDC_XMIN
	IPTSIN(2) = IY_IN*IY_SCALE + NDC_YMIN
	IPTSIN(3) = NDC_XMAX
	IPTSIN(4) = IPTSIN(2)
	CALL POLYLINE(IDEVICE,IPTSIN,2)
	RETURN
	END
	SUBROUTINE YT_VERTICAL_CURSOR(IDEVICE,IX_IN,NP)
C
C	Draw a vertical cursor within the YT display area
C
$INCLUDE:'GEMCOM.FOR'
C
C
	IX_SPACING = (NDC_XMAX - NDC_XMIN)/NP
	IPTSIN(1) = NDC_XMIN + (IX_IN-1)*IX_SPACING
	IPTSIN(2) = NDC_YMIN
	IPTSIN(3) = IPTSIN(1)
	IPTSIN(4) = NDC_YMAX
	CALL POLYLINE(IDEVICE,IPTSIN,2)
	RETURN
	END


	SUBROUTINE YT_HORIZONTAL_LINE(IDEVICE,IX_START,IX_END,IY_IN
     &							,NP)
C
C	Draw a horizontal line from IX_START to IX_END at level IY_IN
C
$INCLUDE:'GEMCOM.FOR'
C
	IX_SPACING = (NDC_XMAX - NDC_XMIN)/NP
	IY_SCALE = (NDC_YMAX - NDC_YMIN)/4096
	IPTSIN(1) = NDC_XMIN + (IX_START-1)*IX_SPACING
	IPTSIN(2) = IY_IN*IY_SCALE + NDC_YMIN
	IPTSIN(3) = NDC_XMIN + (IX_END-1)*IX_SPACING
	IPTSIN(4) = IPTSIN(2)
	CALL POLYLINE(IDEVICE,IPTSIN,2)
	RETURN
	END


	SUBROUTINE YT_FIND_XY(IX,IY,NP,IXY)
C
C	Find NDC coordinates of position IX,IY in YT display
C	of length NP points.
C
	INTEGER IXY(2)
$INCLUDE:'GEMCOM.FOR'
C
	IX_SPACING = (NDC_XMAX - NDC_XMIN)/NP
	IY_SCALE = (NDC_YMAX - NDC_YMIN)/4096
	IXY(1) = NDC_XMIN + (IX-1)*IX_SPACING
	IXY(2) = IY*IY_SCALE + NDC_YMIN
	RETURN
	END


	SUBROUTINE YT_scaled_PLOT(IDEVICE,IYT,NP,iyscale,iy_lo)
C
C	Plot an array of 12 bit integers with 0 - 4095 range
c	scaled by factor IYSCALE after iy_lo has been subtracted
C	as a Y vs T array.
C
	INTEGER IYT(1)
C
$INCLUDE:'GEMCOM.FOR'
C
	IX_SPACING = (NDC_XMAX - NDC_XMIN)/NP
	IX = NDC_XMIN + ix_spacing
	iy_hi = (ndc_ymax - ndc_ymin) / iyscale + 10
	NPLOT = NP
	is1 = 1
9	IF( NPLOT .gt. 127 ) then
C
C	    Plot groups of 128 points
C
	    ix = ix - ix_spacing
	    is0 = is1
	    is1 = is0 + 127
	    j = 1
	    DO 10 is = is0,is1
		IPTSIN(J) = IX
		J = J + 1
		iy = max(min(iyt(is)-iy_lo,iy_hi),-10)
		IPTSIN(J) = iy*iyscale + ndc_ymin
		J = J + 1
		IX = IX + IX_SPACING
10	    CONTINUE
	    CALL POLYLINE(IDEVICE,IPTSIN,128)
	    NPLOT = NPLOT - 127
	    goto 9
	endif

20	IF( NPLOT .GT. 1 ) THEN
C
C	    Plot any remaining points
C
	    ix = ix - ix_spacing
	    is0 = is1
	    is1 = is0 + nplot - 1
	    j = 1
	    DO 21 is = is0,is1
		IPTSIN(J) = IX
		J = J + 1
		iy = max(min(iyt(is)-iy_lo,iy_hi),0)
		IPTSIN(J) = iy*iyscale + ndc_ymin
		J = J + 1
		IX = IX + IX_SPACING
21	    CONTINUE
	    CALL POLYLINE(IDEVICE,IPTSIN,nplot)
	ENDIF
	return
	end

	subroutine plot_channel(idev,iarea,ibuffer,ichannel,n_channels
     &	,istart,np,iy_scale,iy_lo, icolour)
$include:'gemcom.for'

	integer*2 idev,iarea(4),ibuffer(1),ichannel,n_channels,
     &	istart,np,iy_scale
c
c	Plot channel No. "ichannel" from array "ibuffer" containing
c	"n_channels" channels on device "idev", within plotting area
c	defined by "iarea(1..4) = xlo,ylo,xhi,yho (ndc units)"
c	Plot "np" points starting at point "istart". Before plotting
c	each point subtract "iy_lo" then multiply by "iy_scale"

	call set_polyline_colour( idev, iabs(icolour) )
	call set_polymarker_colour( idev, iabs(icolour) )

	ix_spacing = (iarea(3) - iarea(1))/np
	IX = iarea(1) + ix_spacing
	iy_hi = (iarea(4) - iarea(2)) / iy_scale + 10
	NPLOT = NP
	is1 = (istart-1)*n_channels + ichannel
9	IF( NPLOT .gt. 127 ) then
C
C	    Plot groups of 128 points
C
	    ix = ix - ix_spacing
	    is0 = is1
	    is1 = is0 + 127*n_channels
	    j = 1
	    DO is = is0,is1,n_channels
		IPTSIN(J) = IX
		J = J + 1
		iy = max(min(ibuffer(is)-iy_lo,iy_hi),-10)
		IPTSIN(J) = iy*iy_scale + iarea(2)
		J = J + 1
		IX = IX + IX_SPACING
	    end do
	    if( icolour .gt. 0 ) then
		CALL POLYLINE(idev,IPTSIN,128)
	    else
		CALL POLYmarker(idev,IPTSIN,128)
	    end if
	    NPLOT = NPLOT - 127
	    goto 9
	endif

20	IF( NPLOT .GT. 1 ) THEN
C
C	    Plot any remaining points
C
	    ix = ix - ix_spacing
	    is0 = is1
	    is1 = is0 + (nplot - 1)*n_channels
	    j = 1
	    DO is = is0,is1,n_channels
		IPTSIN(J) = IX
		J = J + 1
		iy = max(min(ibuffer(is)-iy_lo,iy_hi),0)
		IPTSIN(J) = iy*iy_scale + iarea(2)
		J = J + 1
		IX = IX + IX_SPACING
	    end do
	    if( icolour .gt. 0 ) then
		CALL POLYLINE(idev,IPTSIN,nplot)
	    else
		CALL POLYmarker(idev,IPTSIN,nplot)
	    end if
	ENDIF

	call set_polyline_colour( idev, 1 )
	call set_polymarker_colour( idev, 1 )

	return
	end

	subroutine set_display_window(idisplay_area
     &	,min_dx,max_dx,min_yscale,max_yscale,max_y
     &	,i0,n_disp,iyscale,iy_lo,ileft,itop)
c
c	Let user set 12 bit A/D data display window
c	-------------------------------------------
c	Enter with:
c	IDISPLAY_AREA(4) = NDC coords. of display screen area (see above)
c	MIN_DX,MAX_DX = Min./Max. spacing between samples along X axis
c	MIN_YSCALE,MAX_YSCALE = Min./Max. scaling factors applied to
c	12 bit A/D samples
c
c	i0 = First A/D sample point to be displayed
c	n_disp = No. of A/D points displayed
c	IYSCALE = Y scaling factor applied to A/D data
c	iy_lo = Offset subtracted from A/D data before scaling
c
c	(Note i0,n_disp,IYSCALE,iy_lo are returned with new values
c	set by user)

	integer*2 iy_lo,min_yscale,i0,n_disp,idisplay_area(4),iy_hi

	integer*2 ixy(10)
	parameter(maxadc=4096)
	character key
	logical special, shift_mode, new_mode
	character*54 msg(2)
	character*4 arrows
c
c	code
c

	arrows = char(4)//char(1)//char(2)//char(3)

	call get_screen_device ( idev )

	ilength = (idisplay_area(3) - idisplay_area(1) )
	iheight = idisplay_area(4) - idisplay_area(2)
	idx = ilength / n_disp
	max_disp = ilength / min_dx
	iy_hi = iheight/iyscale + iy_lo
	i1 = i0 + n_disp - 1
	nx_step = max_disp / 32
	ny_step = max_y / 32

	call set_polyline_colour( idev, 2 )
	call set_polyline_type ( idev, 3 )
	call set_writing_mode( idev, 3 )

	shift_mode = .false.
	new_mode = .true.

100	continue
c
c	Display box on screen
c
	ixy(1) = (i0-1)*min_dx + idisplay_area(1)
	ixy(2) = iy_lo*min_yscale + idisplay_area(2)
	ixy(3) = ixy(1)
	ixy(4) = iy_hi*min_yscale + idisplay_area(2)
	ixy(5) = ixy(1) + (n_disp-1)*min_dx
	ixy(6) = ixy(4)
	ixy(7) = ixy(5)
	ixy(8) = ixy(2)
	ixy(9) = ixy(1)
	ixy(10) = ixy(2)
	call polyline( idev, ixy, 5 )

	if( new_mode ) then
	    call set_writing_mode( idev, 1 )
	    call set_polyline_colour( idev, 1 )
	    call set_polyline_type ( idev, 1 )
	    if( shift_mode ) then
		msg(1) = ' MOVE WINDOW: Using '//arrows
		msg(2) = ' Press SPACEBAR to change size, RETURN to exit.'
		call display_message(ileft,itop,56,msg,2)
		new_mode = .false.
	    else
		msg(1) = ' SCALE WINDOW: Using '//arrows
		msg(2) = ' Press SPACEBAR to move window, RETURN to exit.'
		call display_message(ileft,itop,56,msg,2)
		new_mode = .false.
	    endif
	    call set_polyline_colour( idev, 2 )
	    call set_polyline_type ( idev, 3 )
	    call set_writing_mode( idev, 3 )
	    new_mode = .false.
	endif


c
c      Wait for key press
c
	call wait_for_key( key, special )
c
c	Remove box
c
	call polyline( idev, ixy, 5 )
c
c	Change Move/Scale mode
c
	if( key .eq. ' ' ) then
	    if( shift_mode ) then
		shift_mode = .false.
	    else
		shift_mode = .true.
	    endif
	    new_mode = .true.
	endif

	if( shift_mode ) then
c
c ---	--  Move display window
c

	    if( key .eq. 'L' ) then
c
c		Move window left
c
		i0 = max(i0 - nx_step,1)
		i1 = i0 + n_disp - 1
	    elseif( key .eq. 'R'  ) then
c
c		Move window right
c
		i1 = min(i1 + nx_step, max_disp )
		i0 = i1 - n_disp + 1
	    elseif( key .eq. 'U'  ) then
c
c		Move window up
c
		iy_hi = min( iy_hi + ny_step, max_y )
		iy_lo = iy_hi - (iheight / iyscale)
	    elseif( key .eq. 'D'  ) then
c
c		Move window down
c
		iy_lo = max(iy_lo - ny_step,0)
		iy_hi = iy_lo + (iheight / iyscale)
	    endif
	else
c
c   ----    Expand/Contract display window ---
c

	    if( key .eq. 'L'  ) then
c
c		Move left edge of window to the left
c
		idx = min( idx + 1, max_dx )
		n_disp = ilength / idx
		i1 = i0 + n_disp - 1
	    elseif( key .eq. 'R'  ) then
c
c		Move left edge of window to the right
c
		idx = max( idx - 1, min_dx )
		n_disp = ilength / idx
		i1 = min(i0 + n_disp - 1,max_disp)
		i0 = i1 - n_disp + 1
	    elseif( key .eq. 'D'  ) then
c
c		Move top edge of window down
c
		iyscale = min(iyscale + 1,max_yscale)
		iy_hi = iheight/iyscale + iy_lo
	    elseif( key .eq. 'U'  ) then
c
c		Move top edge of window up
c
		iyscale = max(iyscale - 1,min_yscale)
		iyrange = iheight/iyscale
		iy_hi = min( iyrange + iy_lo, max_y )
		iy_lo = max( iy_hi - iyrange, 0 )
	    endif
	endif

	if( key .ne. char(13) ) goto 100

	call set_polyline_colour( idev, 1 )
	call set_polyline_type ( idev, 1 )
	call set_writing_mode( idev, 1 )
	call erase_box(1,22,58,25)

	return
	end


	subroutine display_vertical_cursor( idevice, iarea, ix_in, np )
	integer*2 iarea(4)
C
C	Draw a vertical cursor within the display area "iarea(1..4)"
C
$INCLUDE:'GEMCOM.FOR'
C
C
	ix_spacing = (iarea(3) - iarea(1) ) / np
	IPTSIN(1) = iarea(1) + (IX_IN-1)*IX_SPACING
	IPTSIN(2) = iarea(2)
	IPTSIN(3) = IPTSIN(1)
	IPTSIN(4) = iarea(4)
	CALL POLYLINE( IDEVICE, IPTSIN, 2 )
	RETURN
	END

	subroutine display_horizontal_cursor( idevice, iarea, iy,
     &	iy_scale,iy_offset)
	integer*2 iarea(4)
C
C	Draw a horizontal cursor within the display area "iarea(1..4)"
c	IY is scaled by IY_SCALE after subtraction of IY_OFFSET
C
$INCLUDE:'GEMCOM.FOR'
C
C
	IPTSIN(1) = iarea(1)
	IPTSIN(2) = iarea(2) + (iy - iy_offset)*iy_scale
	if( (iptsin(2).ge.iarea(2)).and.(iptsin(2).le.iarea(4)) ) then
	    IPTSIN(3) = iarea(3)
	    IPTSIN(4) = iptsin(2)
	    CALL POLYLINE( IDEVICE, IPTSIN, 2 )
	end if
	RETURN
	END


