$NOTRUNCATE
$STORAGE:2


	SUBROUTINE SET_MARGINS(ILEFT,ITOP,IRIGHT,IBOTTOM)
$INCLUDE:'GEMCOM.FOR'

C	Set text margins
C	(Used by NEW_LINE)

	ILEFT_MARGIN = (ILEFT-1)*ICHAR_WIDTH
	ITOP_MARGIN = (MAX_ROWS - ITOP)*ICHAR_HEIGHT
	IRIGHT_MARGIN = (IRIGHT-1)*ICHAR_WIDTH
	IBOTTOM_MARGIN = (MAX_ROWS - IBOTTOM)*ICHAR_HEIGHT
	RETURN
	END


	SUBROUTINE SET_RANGE(XLO,YLO,XHI,YHI)
$INCLUDE:'GEMCOM.FOR'

C	Defines the range of the REAL data to be plotted
C	within the viewport (defined by SET_SIZE)
C	(used by CONVERT_TO_NDC,PLOT_LINE,PLOT_MARKERS etc.)

	XMIN = XLO
	YMIN = YLO
	XMAX = XHI
	YMAX = YHI
	RETURN
	END

	SUBROUTINE SET_SIZE(IXLO,IYLO,IXHI,IYHI)
$INCLUDE:'GEMCOM.FOR'
C
C	Sets the physical plotting area (or viewport) in NDC coordinates
C	(used by CONVERT_TO_NDC,PLOT_LINE,YT_PLOT)
C
C
	NDC_XMIN = IXLO
	NDC_YMIN = IYLO
	NDC_XMAX = IXHI
	NDC_YMAX = IYHI
	RETURN
	END


	SUBROUTINE SET_CHARACTER_HEIGHT(IDEVICE,IHEIGHT)
C
C -- Set height of character to IHEIGHT NDC units
C	NB. Height is set to NEAREST available size
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /12,1,2,0,0,0,0/
C
	ICONTRL(7) = IDEVICE
	IPTSIN(1) = 0
	IPTSIN(2) = IHEIGHT
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	IF(IDEVICE.EQ.ISCREEN) THEN
c
c	    If we are setting size of screen characters make
c	    sure that at least 80 can fit in a row.
c
	    ih = iheight
10	     if( iptsout(3) .gt. 410 ) then
		 ih = ih - 10
		 iptsin(1) = 0
		 iptsin(2) = ih
		 CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
		 goto 10
	     endif
	     ICHAR_WIDTH = IPTSOUT(3)
	     ICHAR_HEIGHT = 1311
	     iptsout(4) = 1311
	ENDIF
	RETURN
	END

	SUBROUTINE SET_POINT_SIZE(IDEVICE,IPOINTS)
C
C -- Set height of character in points (1=1/72 inch)
C	NB. Height is set to NEAREST available size
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /107,0,2,1,1,0,0/
C
	ICONTRL(7) = IDEVICE
	IntIN(1) = ipoints
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END


	SUBROUTINE GET_CHARACTER_SIZE(IWIDTH,IHEIGHT)
$INCLUDE:'GEMCOM.FOR'
	IWIDTH = IPTSOUT(3)
	IHEIGHT = IPTSOUT(4)
	RETURN
	END


	SUBROUTINE SET_POLYLINE_TYPE(IDEVICE,ITYPE)
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /15,0,0,1,1,0,0/
C
	ICONTRL(7) = IDEVICE
	INTIN(1) = ITYPE
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	ILINE_TYPE = INTOUT(1)
	RETURN
	END


	SUBROUTINE SET_POLYLINE_END_STYLE(IDEVICE,IBEGIN,IEND)
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /108,0,0,2,0,0,0/
C
	ICONTRL(7) = IDEVICE
	INTIN(1) = IBEGIN
	INTIN(2) = IEND
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END


	SUBROUTINE SET_POLYLINE_WIDTH(IDEVICE,IWIDTH)
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /16,1,1,0,0,0,0/
C
	ICONTRL(7) = IDEVICE
	IPTSIN(1) = IWIDTH
	IPTSIN(2) = 0
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END

	SUBROUTINE SET_POLYLINE_COLOUR(IDEVICE,ICOLOUR)
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /17,0,0,1,1,0,0/
C
	ICONTRL(7) = IDEVICE
	INTIN(1) = ICOLOUR
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END


	SUBROUTINE SET_POLYMARKER_TYPE(IDEVICE,ITYPE)
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /18,0,0,1,1,0,0/
C
	ICONTRL(7) = IDEVICE
	INTIN(1) = ITYPE
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END


	SUBROUTINE SET_POLYMARKER_HEIGHT(IDEVICE,IHEIGHT)
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /19,1,1,0,0,0,0/
C
	ICONTRL(7) = IDEVICE
	IPTSIN(1) = 0

c
c *** BUG FIX ... Screen & printer devices seem to require the
c	the polymarker height defined as NDC_MAX - IHEIGHT
c	Plotter device need IHEIGHT. The array IDEVICE_TYPE
c	(See GEMCOM.FOR) contains what kind of device is attached
c	to handle No. IDEVICE. Plotter=11)
c
	if( idevice_type(idevice) .eq. 11 ) then
	    iptsin(2) = iheight
	else
	    iptsin(2) = ndc_max - iheight
	endif
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END


	SUBROUTINE SET_POLYMARKER_COLOUR(IDEVICE,ICOLOUR)
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /20,0,0,1,1,0,0/
C
	ICONTRL(7) = IDEVICE
	INTIN(1) = ICOLOUR
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END


	SUBROUTINE SET_CHARACTER_BASELINE_VECTOR(IDEVICE,IANGLE)
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /13,0,0,1,1,0,0/
C
	ICONTRL(7) = IDEVICE
	INTIN(1) = IANGLE
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END


	SUBROUTINE SET_TEXT_FACE(IDEVICE,IFACE)
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /21,0,0,1,1,0,0/
C
	ICONTRL(7) = IDEVICE
	INTIN(1) = IFACE
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END


	SUBROUTINE SET_TEXT_COLOUR(IDEVICE,ICOLOUR)
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /22,0,0,1,1,0,0/
C
	ICONTRL(7) = IDEVICE
	INTIN(1) = ICOLOUR
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END


	SUBROUTINE SET_FILL_INTERIOR(IDEVICE,Itype,istyle,icolour)
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /23,0,0,1,1,0,0/
C
	ICONTRL(7) = IDEVICE
	icontrl(1) = 23
	INTIN(1) = Itype
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	icontrl(1) = 24
	INTIN(1) = Istyle
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	icontrl(1) = 25
	INTIN(1) = ICOLOUR
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END

	SUBROUTINE SET_FILL_INTERIOR_STYLE(IDEVICE,ISTYLE)
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /23,0,0,1,1,0,0/
C
	ICONTRL(7) = IDEVICE
	INTIN(1) = ISTYLE
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END


	SUBROUTINE SET_FILL_COLOUR(IDEVICE,ICOLOUR)
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /25,0,0,1,1,0,0/
C
	ICONTRL(7) = IDEVICE
	INTIN(1) = ICOLOUR
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END


	SUBROUTINE SET_FILL_PERIMETER(IDEVICE,IVISIBLE)
C
C	Set border of fill area IVISIBLE=1 := draw border
C	0 := no border
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /104,0,0,1,1,0,0/
C
	ICONTRL(7) = IDEVICE
	INTIN(1) = IVISIBLE
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END


	SUBROUTINE SET_TEXT_SPECIAL_EFFECT(IDEVICE,IEFFECT)
C
C	Set text special effects
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /106,0,0,1,1,0,0/
C
	ICONTRL(7) = IDEVICE
	INTIN(1) = IEFFECT
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END


	SUBROUTINE SET_WRITING_MODE(IDEVICE,IMODE)
$INCLUDE:'GEMCOM.FOR'
C
C	1=Replace,2=Transparent,3=XOR,4=Rev. Trans.
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /32,0,0,1,1,0,0/
C
	ICONTRL(7) = IDEVICE
	INTIN(1) = IMODE
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END


	SUBROUTINE SET_CHARACTER_ALIGNMENT(IDEVICE,IHOR,IVERT)
C
$INCLUDE:'GEMCOM.FOR'
C
	INTEGER ICONTRL(7)
	DATA ICONTRL /39,0,0,2,2,0,0/
C
	ICONTRL(7) = IDEVICE
	INTIN(1) = IHOR
	INTIN(2) = IVERT
	CALL VDI( IPTSOUT, INTOUT, IPTSIN, INTIN, ICONTRL )
	RETURN
	END

	subroutine select_font(ileft,itop,ifont_num,isize_num)

	parameter(nfonts=9)
	character*20 menu(nfonts) /
     &	' System 10 pt. ',
     &	' System 12 pt. ',
     &	' System 14 pt. ',
     &	' Swiss  10 pt. ',
     &	' Swiss  12 pt. ',
     &	' Swiss  14 pt. ',
     &	' Dutch  10 pt. ',
     &	' Dutch  12 pt. ',
     &	' Dutch  14 pt. ' /

	integer*2 ifont(nfonts) / 1,1,1,2,2,2,14,14,14 /
	integer*2 isize(nfonts) / 10,12,14,10,12,14,10,12,14 /

	character key
	logical new_menu

	i = 1
	do while( ifont(i).ne.ifont_num .and. i.lt.nfonts )
	    i = i + 1
	end do
	do while( isize(i) .ne. isize_num .and. i.lt.nfonts )
	    i = i + 1
	end do
	if( i .gt. nfonts ) i = 1

	new_Menu = .true.
	i = Iwait_MENU_VERTICAL1(menu,'123456789'
     &	,nfonts,ileft,itop,new_menu,i,' Select Font ',key)
	ifont_num = ifont(i)
	isize_num = isize(i)
	return
	end






