	subroutine files_menu(search,isearch_attribute,
     &	file_selected,ileft,itop,nrows,files,max_files)
c
c	Search current directory for files matching the pattern in
c	"search" with the file attribute "isearch_attribute"
c	and display on screen a vertical list of file
c	names of length "nrows"
c	Return selected file in "file_selected"
c
c	A search for sub-directory files can be made by setting
c	search = '*.*' and isearch_attribute = 2#10000
c
c	"files" is workspace for storing file list (size="max_files")
c	"ileft/itop" = column/row of top-left of display window
C
	integer*2 ileft,itop,max_files,nrows
	CHARACTER*(*) SEARCH,FILE_SELECTED,files(max_files)
	CHARACTER KEY
	LOGICAL SPECIAL,selected,new_list,first,quit
	parameter( isub_directory = 2#10000 )
C
C	CODE
C
	iright = ileft + len(files(1)) + 4
	ibottom = itop + nrows + 4
	CALL ERASE_BOX(ILEFT,ITOP,IRIGHT,IBOTTOM)
	CALL DISPLAY_BOX(ILEFT,ITOP,IRIGHT,IBOTTOM)
	CALL MOVE_CURSOR(ILEFT+1,ITOP)
	il = len_trim(search)
	if( isearch_attribute .eq. isub_directory ) then
	    il = il - 3
	    CALL DISPLAY_STRING(' Dir: ')
	    CALL DISPLAY_STRING(SEARCH(1:il))
	else
	    CALL DISPLAY_STRING(' Files: ')
	    CALL DISPLAY_STRING(SEARCH(1:il))
	end if

	call move_cursor(ileft+1,ibottom-3)
	call display_string('...............')
	CALL MOVE_CURSOR(ILEFT+1,IBOTTOM-2)
	call display_string('ENTER to Select')
	CALL MOVE_CURSOR(ILEFT+1,IBOTTOM-1)
	call display_string('ESC   to Cancel')
	call move_cursor(ileft+1,ibottom)
	call display_string(' '//char(1)//char(2)//' PgDn PgUp ')

c	Ensure first NROWS of array FILES is blank, in case
c	less than NROWS files are found

	do i = 1,nrows
	    files(i) = ' '
	end do
c
c	Compile a list of matching files
c
	quit = .false.
	first = .true.
	do while( .not. quit )

	    if( first ) then
		nfiles = 1
		iattributes = isearch_attribute
		call find_first_file( ierr, search, iattributes,
     &		files(nfiles) )
		if( ierr .ne. 0 ) nfiles = 0
		first = .false.
	    else
		nfiles = nfiles + 1
		call find_next_file(ierr,iattributes,files(nfiles))
	    end if

	    if( ierr .ne. 0 ) then
		quit = .true.
		nfiles = max(nfiles - 1,0)
	    else
		if( isearch_attribute .ne. 0 ) then
		    ii = iattributes .and. isearch_attribute
		    if( ii .eq. 0 ) nfiles = max(nfiles - 1,0)
		end if
	    end if

	    if( nfiles .eq. max_files-1 ) quit = .true.

	end do

	nfiles = nfiles + 1
	files(nfiles) = 'Exit'
c
c	If this is a directory search, remove "." and ".."
c	which are always the first two in the list
c
	if( files(1) .eq. '.' .or. files(1) .eq. '..' ) then
	    do i = 1,nfiles-2
		files(i) = files(i+2)
	    end do
	    files(nfiles) = ' '
	    files(nfiles-1) = ' '
	    nfiles = nfiles - 2
	end if

C
C --	Let user select a file from the list using
c	Up/Down and PgUp/PgDn keys to find, then CR to select
C	and pass it back to the main program
C
	i0 = 1
	ifile = i0
	selected = .false.
	new_list = .true.
	do while( .not. selected )
c
c	    Refresh list of files in window
c
	    if( new_list ) then
		do i = i0,i0+nrows-1
		   call move_cursor(ileft+1,itop+i-i0+1)
		   call display_string( files(i) )
		end do
		new_list = .false.
	    endif
C
c	    Highlight currently selected file in reverse-video
C
	    call move_cursor(ileft+1,itop+ifile-i0+1)
	    call display_reversed( files(ifile) )
c
c	    Wait for user to press a key
c
	    call wait_for_key( key, special )
c
C	    Return highlighted entry to normal video
c
	    call move_cursor(ileft+1,itop+ifile-i0+1)
	    call display_string( files(ifile) )
c
c	    Select response to key-press

	    if( key .eq. 'U' ) then
		ifile = max(ifile - 1,1)	! Up-arrow
		if( ifile .lt. i0 ) then
		    i0 = i0 - 1
		    new_list = .true.
		endif
	    elseif( key .eq. 'P' ) then
		ifile = max(ifile - 10,1)	! PgDn
		i0 = max(i0 - 10,1)
		new_list = .true.
	    elseif( key .eq. 'D' ) then
		ifile = min(ifile + 1,nfiles)	    ! Down Arrow
		if( ifile .gt. i0+nrows-1 ) then
		    i0 = i0 + 1
		    new_list = .true.
		endif
	    elseif( key .eq. 'Q' ) then
		ifile = min(ifile + 10,nfiles)	    ! PgUp
		i0 = min(i0 + 10,nfiles-nrows+1)
		new_list = .true.
	    elseif( key .eq. char(13) ) then
		file_selected = files(ifile)	    ! CR
		selected = .true.
	    elseif( key .eq. '$' ) then
		file_selected = ' '		    ! ESC
		selected = .true.
	    endif
	end do

	if( ifile .eq. nfiles ) file_selected = ' '

	return
	end

	subroutine get_drives( list, n )
	character*(*) list(1)
	parameter(ndrives=26)

	n = 0
	ia = ichar('A') - 1
	do idrive = 1,ndrives
	    iax = 16#440e
	    ibx = idrive

	     call dos(iax,ibx,icx,idx,icarry)

	    if( icarry .eq. 0 .or. iax.lt.15 ) then
		n = n + 1
		list(n) = char( ia + idrive )
		list(n)(2:2) = ':'
	    end if
	end do
	return
	end
