	subroutine file_box(ix,iy,file_name,extension,file_type
     &	,title,abort)

	character*(*) file_name,extension,file_type,title
	logical abort

	character key

c	code
c

	lwidth = max(max(len(title)+2,len(file_name)+2),40)
	call erase_box(ix,iy,ix+lwidth,iy+3)
	call display_box(ix,iy,ix+lwidth,iy+3)
	call move_cursor(ix+1,iy)
	call display_string(title)
	call move_cursor(ix+1,iy+3)
	call display_string(' Press RETURN to continue, ESC=cancel ')

10	call move_cursor(ix+2,iy+1)
	call get_string( file_name, nc, key )

	if( key .eq. '$' ) then
	    abort = .true.
	    call erase_box(ix,iy,ix+lwidth,iy+4)
	    return
	endif

	if( extension .ne. ' ' ) then
	    i = index( file_name(1:nc), '.' )
	    if( i .eq. 0 ) i = nc+1
	    file_name(i:i+3) = extension
	endif

	call upper_case( file_type )
	if( file_type .eq. 'NEW' ) then
c
c	    Create a NEW file
c
	    call open_file( ifile, ierr, file_name )
	    if( ierr .eq. 0 ) then
		call close_file( ifile, ierr )
		call move_cursor(ix+1,iy+2)
		call ask_user(' File exists! Overwrite (Y/N) ? ',key)
		call erase_box(ix+1,iy+2,ix+lwidth-1,iy+1)
		if( key .ne. 'Y') goto 10
	    endif
	ELSE
c
c	    Open an OLD file
c
	    call open_file( ifile, ierr, file_name )
	    if( ierr .NE. 0 ) then
		call move_cursor(ix+1,iy+2)
		call display_string(' Can''t find file!')
		goto 10
	    else
		call close_file( ifile, ierr)
	    endif
	endif

	call move_cursor(ix+1,iy+2)
	abort = .false.
	return
	end
