$NOTRUNCATE
$STORAGE:2

	subroutine reset_disc
c
c	Flush all disc buffers
c
	iax = 16#0d00
	CALL DOS(IAX,I,I,I,I)
	return
	end

	SUBROUTINE CREATE_FILE(IH,IERR,FILE_NAME)
	CHARACTER*(*) FILE_NAME
	CHARACTER*80 ASCIIZ
	COMMON /DOSXXXX/ ASCIIZ
	INTEGER*1 IASCIIZ(80)
	EQUIVALENCE( ASCIIZ,IASCIIZ)
C
C	Create a file
C	-------------
C
	CALL CONVERT_ASCIIZ(FILE_NAME,ASCIIZ)
C
	IAX = 16#3C00
	ICX = 0
	CALL DOSF(IAX,IBX,ICX,ICARRY,IASCIIZ)
C
	IF(ICARRY.EQ.0) THEN
		IH = IAX
		IERR = 0
	ELSE
		IERR = IAX
	ENDIF
	RETURN
	END


	SUBROUTINE OPEN_FILE(IH,IERR,FILE_NAME)
	CHARACTER*(*) FILE_NAME
	CHARACTER*80 ASCIIZ
	COMMON /DOSXXXX/ ASCIIZ
	INTEGER*1 IASCIIZ(80)
	EQUIVALENCE( ASCIIZ,IASCIIZ)
C
C	Open an existing file
C	---------------------
C
	CALL CONVERT_ASCIIZ(FILE_NAME,ASCIIZ)
C
C	AH=3DH AL=2H for compatibility mode
C
	IAX = 16#3D02
	ICX = 0
	CALL DOSF(IAX,IBX,ICX,ICARRY,IASCIIZ)
C
	IF(ICARRY.EQ.0) THEN
		IH = IAX
		IERR = 0
	ELSE
		IERR = IAX
	ENDIF
	RETURN
	END


	SUBROUTINE CLOSE_FILE(IH,IERR)
C
C	Close a file
C	------------
C
	IAX = 16#3E00
	IBX = IH
	CALL DOS(IAX,IBX,ICX,IDX,ICARRY)
	IF(ICARRY.EQ.1) THEN
		IERR = IAX
	ELSE
		IERR = 0
	ENDIF
	RETURN
	END


	SUBROUTINE READ_BYTES(IH,NREAD,IBUFFER,NBYTES)
	INTEGER*1 IBUFFER(1)
C
C	Read NBYTES bytes from file attached to handle IH
C	and place in buffer IBUFFER. No. of bytes read returned in NREAD
C	NREAD = error code if an error has occurred,
C
	IAX = 16#3F00
	IBX = IH
	ICX = NBYTES
	CALL DOSF(IAX,IBX,ICX,ICARRY,IBUFFER)
C
	NREAD = IAX
	RETURN
	END


	SUBROUTINE WRITE_BYTES(IH,NWRITTEN,IBUFFER,NBYTES)
	INTEGER*1 IBUFFER(1)
C
C	Write NBYTES bytes to file attached to handle IH
C	from buffer IBUFFER. No. of bytes written returned in NWRITTEN
C	NWRITTEN = error code if an error has occurred,
C
	IAX = 16#4000
	IBX = IH
	ICX = NBYTES
	CALL DOSF(IAX,IBX,ICX,ICARRY,IBUFFER)
C
	NWRITTEN = IAX
	RETURN
	END


	SUBROUTINE MOVE_FILE_POINTER(IH,IERR,ILO,IHI)
C
C	Move file pointer of file attached to handle IH by
C	ILO + 1000H*IH bytes
C
	IAX = 16#4200
	IBX = IH
	ICX = IHI
	IDX = ILO
	CALL DOS(IAX,IBX,ICX,IDX,ICARRY)
	IF(ICARRY.EQ.1) THEN
		IERR = IAX
	ELSE
		IERR = 0
	ENDIF
	RETURN
	END


	SUBROUTINE READ_FILE(IH,IERR,IBUFFER,IBLOCK,NBLOCKS)
C
C	Read sequence of 512 byte blocks from file attached to IH
C	and place them in IBUFFER. Start at block IBLOCK and read NBLOCKS
C	NREAD = No. of bytes read
C
	INTEGER*1 IBUFFER(1)
	INTEGER*4 POINTER_32
	INTEGER IPOINTER(2)
	EQUIVALENCE(POINTER_32,IPOINTER)
C
C	CODE
C
	POINTER_32 = IBLOCK-1
	POINTER_32 = 512*POINTER_32
	NBYTES = 512*NBLOCKS
	CALL MOVE_FILE_POINTER(IH,IERR,IPOINTER(1),IPOINTER(2))
	CALL READ_BYTES(IH,NREAD,IBUFFER,NBYTES)
	IF(NREAD.NE.NBYTES) THEN
		IERR = 1
	ELSE
		IERR = 0
	ENDIF
	RETURN
	END


	SUBROUTINE WRITE_FILE(IH,IERR,IBUFFER,IBLOCK,NBLOCKS)
C
C	Write sequence of 512 byte blocks from file attached to IH
C	and place them in IBUFFER. Start at block IBLOCK and read NBLOCKS
C	NWRITTEN = No. of bytes written
C
	INTEGER*1 IBUFFER(1)
	INTEGER*4 POINTER_32
	INTEGER IPOINTER(2)
	EQUIVALENCE(POINTER_32,IPOINTER)
C
C	CODE
C
	POINTER_32 = IBLOCK-1
	POINTER_32 = 512*POINTER_32
	NBYTES = 512*NBLOCKS
	CALL MOVE_FILE_POINTER(IH,IERR,IPOINTER(1),IPOINTER(2))
	CALL WRITE_BYTES(IH,NWRITTEN,IBUFFER,NBYTES)
	IF(NWRITTEN.NE.NBYTES) THEN
		IERR = 1
	ELSE
		IERR = 0
	ENDIF
	RETURN
	END


	REAL FUNCTION FREE_DISC_SPACE()
C
C	Find free disc space in default drive
C
	integer*4 iax,ibx,icx,idx

	IAX = 16#3600
	IDX = 0
	ibx = 0
	icx = 0
	CALL DOS(IAX,IBX,ICX,IDX,ICARRY)
C
C	Returns IAX = sectors/cluster, IBX = clusters available
C	ICX = bytes / cluster
C
	FREE_DISC_SPACE =  FLOAT(IBX)*FLOAT(IAX)*FLOAT(ICX)/1024.
	RETURN
	END


	SUBROUTINE GET_TIME(IHOUR,IMIN,ISEC,ICENTISEC)
C
C	Get time from system
C
	IAX = 16#2C00
	CALL DOS(IAX,IBX,ICX,IDX,ICARRY)
	IHOUR = ICX/256
	IMIN = IAND(ICX,255)
	ISEC = IDX/256
	ICENTISEC = IAND(IDX,255)
	RETURN
	END

	real function time_in_seconds()
	call get_time( ihour, imin, isec, icsec )
	time_in_seconds = float(ihour)*3600. + float(imin)*60. +
     &	float(isec) + float(icsec)/100.
	return
	end

	subroutine display_time(ix,iy)
	character*8 string
	call get_time( ihour, imin, isec, icsec )
	if( isec .ne. iold_sec ) then
	    call move_cursor(ix,iy)
	    write( string, '(i2,'':'',i2,''.'',i2)') ihour,imin,isec
	    call display_string ( string )
	    iold_sec = isec
	endif
	return
	end


	SUBROUTINE CONVERT_ASCIIZ(STRING,ASCIIZ)
	CHARACTER*(*) STRING,ASCIIZ
	NC = LEN(STRING)
	I = 1
10	IF(STRING(I:I).NE.' ') THEN
		ASCIIZ(I:I) = STRING(I:I)
		I = I + 1
		IF(I.LE.NC) GOTO 10
	ENDIF
	ASCIIZ(I:I) = CHAR(0)
	RETURN
	END

	SUBROUTINE WAIT(DELAY)
C
C	Wait for <delay> seconds
C

	wait_time = time_in_seconds() + delay
C
105	CONTINUE
		clock_time = time_in_seconds()
	IF(CLOCK_TIME .LT. WAIT_TIME) GOTO 105
	RETURN
	END



