$NOTRUNCATE
$STORAGE:2
	SUBROUTINE DRAW_AXES_MANUAL(IDEVICE
     &,XMIN_NEW,YMIN_NEW,XMAX_NEW,YMAX_NEW
     &,XLABEL,YLABEL,LOG_X_NEW,LOG_Y_NEW
     &,FIX_ORIGIN,XTIC,YTIC)
C
C	Draw plot axes
C	----------------------------------------------------------
C	IDEVICE = GEM device to plot on
C	XMIN_NEW,YMIN_NEW = Minimum X&Y axes range 
C	XMAX_NEW,YMAX_NEW = Maximum X&Y axes range
C	XTIC,YTIC = X&Y axis tic spacing
C	XLABEL,YLABEL = axes labels
C	LOG_X_NEW,LOG_Y_NEW = Set to 'Y' if logarithmic axes
C	FIX_ORIGIN = Set to 'Y' if axes to be fixed at bottom/left
C	----------------------------------------------------------
C
	REAL XY_ORIGIN(2)
	INTEGER NDC_ORIGIN(2)
	CHARACTER*(*) XLABEL,YLABEL
	CHARACTER LOG_X_NEW,LOG_Y_NEW,FIX_ORIGIN
C
$INCLUDE:'GEMCOM.FOR'
C
C       CODE
C

	if( xtic .le. 0. ) then
	    xtic = ( xmax_new - xmin_new ) * 0.2
	    if( xtic .le. 0. ) xtic = 1.
	end if

	if( ytic .le. 0. ) then
	    ytic = ( ymax_new - ymax_new ) * 0.2
	    if( ytic .le. 0. ) ytic = 1.
	end if

	if( xmax_new .eq. xmin_new ) xmax_new = xmin_new + 1.
	if( ymax_new .eq. ymin_new ) ymax_new = ymin_new + 1.


	IF(LOG_X_NEW .EQ. 'Y') THEN
	    LOG_X = .TRUE.
	ELSE
	    LOG_X = .FALSE.
	ENDIF
	IF(LOG_Y_NEW .EQ. 'Y') THEN
	    LOG_Y = .TRUE.
	ELSE
	    LOG_Y = .FALSE.
	ENDIF
C
	IF(LOG_Y .EQV. .TRUE.) THEN
	    YMIN = ALOG10(YMIN_NEW)
	    YMAX = ALOG10(YMAX_NEW)
	ELSE
	    YMIN = YMIN_NEW
	    YMAX = YMAX_NEW
	ENDIF
C
	IF(LOG_X .EQV. .TRUE.) THEN
	    XMIN = ALOG10(XMIN_NEW)
	    XMAX = ALOG10(XMAX_NEW)
	ELSE
	    XMIN = XMIN_NEW
	    XMAX = XMAX_NEW
	ENDIF
C
	XRANGE = XMAX - XMIN
	YRANGE = YMAX - YMIN
C
C       Compute physical coords of origin
C
	XY_ORIGIN(1) = 0.
	IF(XMAX.LT.0.) XY_ORIGIN(1) = XMAX
	IF(XMIN.GT.0.) XY_ORIGIN(1) = XMIN
	XY_ORIGIN(2) = 0.
	IF(YMAX.LT.0.) XY_ORIGIN(2) = YMAX
	IF(YMIN.GT.0.) XY_ORIGIN(2) = YMIN
C
	CALL CONVERT_TO_NDC(XY_ORIGIN,NDC_ORIGIN,1)
C
C       If log axes - set axes crossing point to bottom left
C
	IF(LOG_X .EQV. .TRUE.
     &  .OR. (FIX_ORIGIN .EQ. 'Y')) NDC_ORIGIN(1) = NDC_XMIN
	IF(LOG_Y .EQV. .TRUE.
     &  .OR. (FIX_ORIGIN .EQ. 'Y')) NDC_ORIGIN(2) = NDC_YMIN
C
C       Plot X axis
C
	IPTSIN(1) = NDC_XMIN
	IPTSIN(2) = NDC_ORIGIN(2)
	IPTSIN(3) = NDC_XMAX
	IPTSIN(4) = NDC_ORIGIN(2)
	CALL POLYLINE(IDEVICE,IPTSIN,2)
C
C       Plot Y axis
C
	IPTSIN(1) = NDC_ORIGIN(1)
	IPTSIN(2) = NDC_YMIN
	IPTSIN(3) = NDC_ORIGIN(1)
	IPTSIN(4) = NDC_YMAX
	CALL POLYLINE(IDEVICE,IPTSIN,2)
C
C       Plot tics on axes (linear or log, as selected by LAW)
C
	IF(LOG_X .EQV. .FALSE.) THEN
	    cALL TICSM(IDEVICE,XMIN,XMAX,NDC_ORIGIN(2),'HO',XTIC,iy_label)
	ELSE
	    CALL LOG_TICSM(IDEVICE,XMIN,XMAX,NDC_ORIGIN(2),'HO',iy_label)
	ENDIF
	IF(LOG_Y .EQV. .FALSE.) THEN
	    CALL TICSM(IDEVICE,YMIN,YMAX,NDC_ORIGIN(1),'VE',YTIC,iy_label)
	ELSE
	    CALL LOG_TICSM(IDEVICE,YMIN,YMAX,NDC_ORIGIN(1),'VE',iy_label)
	ENDIF
C
C       Plot labels
C
	CALL CENTRE_LABELM(IDEVICE,XLABEL,'HO',iy_label)
	CALL CENTRE_LABELM(IDEVICE,YLABEL,'VE',iy_label)
C
        RETURN
	END

	SUBROUTINE TICSM(IDEVICE,RMIN,RMAX,IORIGIN,AXIS,TIC_SPACING,
     &	iy_label)
C
C	Divide selected axis into scale divisions
C	ranging from rmin to rmax on line iorigin
C	axis = 'HO' for horizontal, 'VE' for vertical
C
	REAL XY(2)
	CHARACTER*2 AXIS
	CHARACTER*14 STRING / ' ' /
	logical quit
C -- Global common area
$INCLUDE:'GEMCOM.FOR'
C ---------------------
C
C       CODE
C       ----
C
	RANGE = RMAX - RMIN
	TIC = RMIN
C
C       Plot series of tics on axis
C	starting at most negative value to steps of
C       Print scale value beside tic
C

	call get_text_size(idevICE,'0',ichar_w,ichar_h)

	iy_label = ndc_xmin - ichar_w
1	IF((TIC.GE.RMIN) .AND. (TIC.LE.RMAX)) THEN
C
C	     CHOOSE axis to be ticced
C
	     IF(AXIS.EQ.'HO') THEN
C
C		X axis
C
		XY(1) = TIC
		XY(2) = 0.
		CALL CONVERT_TO_NDC(XY,IPTSIN,1)
		IPTSIN(2) = IORIGIN
		IPTSIN(3) = IPTSIN(1)
		IPTSIN(4) = IORIGIN - (ichar_h/3)
		CALL POLYLINE(IDEVICE,IPTSIN,2)

		WRITE(STRING,'(g11.3)') TIC
C
C		Remove leading spaces and trailing zeroes and spaces
C
		is = verify( string, ' ' )
		ie = verify( string, '0 ', .true.)
		if( string(ie:ie) .eq. '.' ) ie = max(ie - 1,is)
		if( tic .eq. 0. ) then
		    string = '0'
		    is = 1
		    ie = 1
		endif
		nc = ie-is+1
C
		call get_text_size(idevICE,string(is:ie),itext_w,itext_h)
		IPTSIN(1) = IPTSIN(1) - itext_w/2
		IPTSIN(2) = NDC_YMIN - itext_h*2
		CALL GRAPHICS_TEXT(IDEVICE,IPTSIN,STRING(is:ie))

	     ELSE
C	
C		Y axis
C
		XY(1) = 0.
		XY(2) = TIC
		CALL CONVERT_TO_NDC(XY,IPTSIN,1)
		IPTSIN(1) = IORIGIN
		IPTSIN(4) = IPTSIN(2)
		IPTSIN(3) = IORIGIN - ichar_w/2
		CALL POLYLINE(IDEVICE,IPTSIN,2)

		WRITE(STRING,'(g11.3)') TIC
C
C		Remove leading spaces and trailing zeroes and spaces
C
		is = verify( string, ' ' )
c		 ie = verify( string, '0 ', .true.)

		quit = .false.
		ie = len_trim( string )
		do while( .not. quit )
		    if( string(ie:ie) .ne. '0' ) then
			quit = .true.
		    else
		       ie = ie - 1
		    end if
		 end do
		 if( string(ie:ie) .eq. '.' ) ie = max(ie - 1,is)

		if( tic .eq. 0. ) then
		    string = '0'
		    is = 1
		    ie = 1
		endif
		nc = ie-is+1
C
		call get_text_size(idevice,string(is:ie),itext_w,itext_h)
		call get_text_size(idevice,"0",i0_w,i0_h)

		IPTSIN(1) = NDC_XMIN - i0_w*(nc+1)
		iptsin(2) = iptsin(2) - itext_h/2
		iy_label = min( iptsin(1), iy_label )
		CALL GRAPHICS_TEXT(IDEVICE,IPTSIN,STRING(is:ie))

	     ENDIF
	ENDIF
	TIC = TIC + TIC_SPACING
	IF(TIC.LE.RMAX) GOTO 1
C
	RETURN
	END

	SUBROUTINE LOG_TICSm(IDEVICE,RMIN,RMAX,IORIGIN,AXIS,iy_label)
C
C       Divide selected axis into logarithmic scale divisions
C
	REAL DIV,RMIN,RMAX,XY(2)
	CHARACTER*2 AXIS
	CHARACTER*3 STRING
C
C -- Global common area
$INCLUDE:'GEMCOM.FOR'
C ---------------------
C
C       CODE
C       ----
C
	call get_text_size(idevICE,'0',ichar_w,ichar_h)
	iy_label = ndc_xmin - ichar_w

	TIC = SIGN(AINT(ABS(RMIN)),RMIN)
	DIV = 1.
	IF(DIV.LE.0.) RETURN
C
C       Plot series of tics on axis
C       starting at most negative value to steps of DIV
C       Insert sub tics 1,2,3..,9 scaled logarithmically
C       Print 10** (scale value) beside tic
C
1	IF( (TIC .GE.RMIN) .AND. (TIC.LE.RMAX) ) THEN
C
C	    Choose axis to be ticced
C
	    IF( AXIS .EQ. 'HO' ) THEN
C
C		X axis - Plot log sub-tics
C
		XY(2) = 0.
		DO I=1,9
		    XY(1) = ALOG10(FLOAT(I)) + TIC
		    iF(XY(1).LE.RMAX) THEN
			CALL CONVERT_TO_NDC(XY,IPTSIN,1)
			IPTSIN(2) = IORIGIN
			IPTSIN(3) = IPTSIN(1)
			IPTSIN(4) = IORIGIN - ichar_h/3
			CALL POLYLINE(IDEVICE,IPTSIN,2)
		    ENDIF
		end do
C
C		Print scale value
C
		XY(1) = TIC
		CALL CONVERT_TO_NDC(XY,IPTSIN,1)
		IPTSIN(2) = IORIGIN - ichar_h*2
		call get_text_size(idevice,'10',itext_w,itext_h)
		iptsin(1) = iptsin(1) - itext_w/2
		CALL GRAPHICS_TEXT(IDEVICE,IPTSIN,'10')
		IPTSIN(1) = IPTSIN(1) + ichar_w*2
		IPTSIN(2) = IPTSIN(2) + ichar_h/2
		WRITE(STRING,'(i3)') int(tic)
		ix = ileading_space( string )
		nc = len(string)
		CALL GRAPHICS_TEXT(IDEVICE,IPTSIN,STRING(ix:nc))
	    ELSE
C
C		Y axis - Plot log. sub-tics
C
		XY(1) = 0.
		DO I=1,9
		    XY(2) = ALOG10(FLOAT(I)) + TIC
		    IF(XY(2).LE.RMAX) THEN
			CALL CONVERT_TO_NDC(XY,IPTSIN,1)
			IPTSIN(1) = IORIGIN
			IPTSIN(3) = IPTSIN(1) - ichar_h/2
			IPTSIN(4) = IPTSIN(2)
			CALL POLYLINE(IDEVICE,IPTSIN,2)
		    ENDIF
		end do
C
C		Print scale value
C
		XY(2) = TIC
		CALL CONVERT_TO_NDC(XY,IPTSIN,1)
		IPTSIN(1) = IORIGIN - ichar_w*6
		iy_label = min( iptsin(1), iy_label )

		iptsin(2) = iptsin(2) - ichar_h/2
		CALL GRAPHICS_TEXT(IDEVICE,IPTSIN,'10')

		call get_text_size(idevice,'10',itext_w,itext_h)
		IPTSIN(1) = IPTSIN(1) + itext_w
		IPTSIN(2) = IPTSIN(2) + ichar_h/2
		WRITE(STRING,'(i3)') int(tic)
		CALL GRAPHICS_TEXT(IDEVICE,IPTSIN,STRING(1:3))

	    ENDIF

	ENDIF
	TIC = TIC + DIV
	IF(TIC.LE.RMAX) GOTO 1
	RETURN
	END

	SUBROUTINE CENTRE_LABELM(IDEVICE,LABEL,AXIS,iy_label)
C
C       Print label below and to side of plot
C
	CHARACTER*(*) LABEL,AXIS
C
$INCLUDE:'GEMCOM.FOR'
C
C       CODE
C       ----
C
C       Labels are centred on each axis
C       
	NC = LEN_trim(LABEL)
	IF(AXIS.EQ.'HO') THEN
C
C	    X label
C
	    call get_text_size(idevice,label(1:nc),itext_w,itext_h)
	    IPTSIN(2) = NDC_YMIN - (itext_h*7)/2
	    iptsin(1) = (ndc_xmax+ndc_xmin)/2 - itext_w/2
	    CALL GRAPHICS_TEXT(IDEVICE,IPTSIN,LABEL(1:nc))
	ELSE		
C
C	    Y label - Text is rotated 90 degrees to lie along Y axis
C
	    CALL SET_CHARACTER_BASELINE_VECTOR(IDEVICE,900)
	    call get_text_size(idevice,label(1:nc),itext_w,itext_h)
	    IPTSIN(1) = iy_label - itext_w
	    IPTSIN(2) = (NDC_YMAX+NDC_YMIN)/2 - itext_h/2
	    CALL GRAPHICS_TEXT(IDEVICE,IPTSIN,LABEL(1:nc))
	ENDIF
	CALL SET_CHARACTER_BASELINE_VECTOR(IDEVICE,0)
	RETURN
	END


