	REAL FUNCTION CONVERT_GAIN(GAIN)
$INCLUDE:'cmacom.FOR'
C
C	Derive BIT_VALUE from GAIN and vice_versa
C
	PARAMETER(ADC_MAX = 2.048)
C
	IF(RECORD_GAIN .LE. 0.) RECORD_GAIN = 1.
	CONVERT_GAIN = ADC_RANGE/(ADC_MAX*RECORD_GAIN*GAIN)
	RETURN
	END

	SUBROUTINE PUT_FRAME(IFRAME,IFILE_NO)
C
C	Write a frame to the file currently connected
c	to file handle no. "IFILE_NO"
C
C	Records are stored as collections of frames, each frame
c	consisting of 'NB_ANALYSIS' blocks and 'NB_DATA' data blocks.
C	A block contains 256 words. The first block on the file
C	contains the file header data, and the records follow thereafter.
C
$INCLUDE:'cmacom.FOR'
C
	NB_FRAME = NB_ANALYSIS + NB_DATA
	IBLOCK = (IFRAME - 1)*NB_FRAME + 2
C
C	SAVE ANALYSIS BLOCK
C
	CALL WRITE_FILE(IFILE_NO,IERROR,IANALYSIS,IBLOCK,NB_ANALYSIS)
	if( ierror .ne. 0 ) call disc_full_warning()
C
C	SAVE DATA BLOCKS
C
	IBLOCK = IBLOCK + NB_ANALYSIS
	CALL WRITE_FILE(IFILE_NO,IERROR,IBUFFER,IBLOCK,NB_DATA)
	if( ierror .ne. 0 ) call disc_full_warning()
	RETURN
	END

	SUBROUTINE PUT_ANALYSIS_BLOCK(IFRAME,IFILE_NO)
$INCLUDE:'cmacom.FOR'
	NB_FRAME = NB_ANALYSIS + NB_DATA
	IBLOCK = (IFRAME - 1)*NB_FRAME + 2
	CALL WRITE_FILE(IFILE_NO,IERROR,IANALYSIS,IBLOCK,NB_ANALYSIS)
	if( ierror .ne. 0 ) call disc_full_warning()
	RETURN
	END

	SUBROUTINE GET_FRAME(IFRAME,IFILE_NO)
C
C	READ A FRAME FROM THE FILE CURRENTLY CONNECTED
C	TO FILE HANDLE NO. "IFILE_NO"
C
C	RECORDS ARE STORED AS COLLECTIONS OF FRAMES, EACH FRAME
C	CONSISTING OF 'NB_ANALYSIS' BLOCKS AND 'NB_DATA' DATA BLOCKS.
C	A BLOCK CONTAINS 256 WORDS. THE FIRST BLOCK ON THE FILE
C	CONTAINS THE FILE HEADER DATA, AND THE RECORDS FOLLOW THEREAFTER.
C
$INCLUDE:'cmacom.FOR'
C
C	ENSURE THAT FRAME # REMAINS WITHIN LEGAL LIMITS FOR FILE
C
	IF(IFILE_NO .EQ. IAVG_FILE_NO) THEN
		IF(IFRAME .GT. N_RECORDS) IFRAME = N_RECORDS
	ELSE
		IF(IFRAME .GT. N_FRAMES) IFRAME = N_FRAMES
	ENDIF
	IF(IFRAME .LT. 1) IFRAME = 1
C
	NB_FRAME = NB_ANALYSIS + NB_DATA
	IBLOCK =  (IFRAME - 1)*NB_FRAME + 2
C
C	READ ANALYSIS BLOCK
C
	CALL READ_FILE(IFILE_NO,IERROR,IANALYSIS,IBLOCK,NB_ANALYSIS)
C
C	READ DATA BLOCKS
C
	IBLOCK = IBLOCK + NB_ANALYSIS
	CALL READ_FILE(IFILE_NO,IERROR,IBUFFER,IBLOCK,NB_DATA)
C
C	Update current per bit factor to account for any
C	changes in pre-amplification factor RECORD_GAIN
C
	BIT_CURRENT = CONVERT_GAIN(GAIN_CURRENT)
C
C	Determine sampling interval for this record
C
	IF(( RECORD_T_UNITS .EQ. 'ms') .OR.
     &	(RECORD_T_UNITS .EQ. 's') ) THEN
	   T_UNITS = RECORD_T_UNITS
	ENDIF
	RETURN
	END

	SUBROUTINE GET_ANALYSIS_BLOCK(IFRAME,IFILE_NO)
$INCLUDE:'cmacom.FOR'
	IF(IFILE_NO .EQ. IAVG_FILE_NO) THEN
		IF(IFRAME .GT. N_RECORDS) IFRAME = N_RECORDS
	ELSE
		IF(IFRAME .GT. N_FRAMES) IFRAME = N_FRAMES
	ENDIF
	IF(IFRAME .LT. 1) IFRAME = 1
C
	NB_FRAME = NB_ANALYSIS + NB_DATA
	IBLOCK =  (IFRAME - 1)*NB_FRAME + 2
	CALL READ_FILE(IFILE_NO,IERROR,IANALYSIS,IBLOCK,NB_ANALYSIS)
C
C	Update current per bit factor to account for any
C	changes in pre-amplification factor RECORD_GAIN
C
	BIT_CURRENT = CONVERT_GAIN(GAIN_CURRENT)
C
C	Determine sampling interval for this record
C
	IF(( RECORD_T_UNITS .EQ. 'ms') .OR.
     &	(RECORD_T_UNITS .EQ. 's') ) THEN
	   DT = RECORD_DT
	   T_UNITS = RECORD_T_UNITS
	ENDIF
	RETURN
	END

	SUBROUTINE CHANGE_FRAME(IFRAME,ISTEP,IFILE_NO)
C
C	SAVE CURRENT FRAME AND READ NEXT FRAME
C	SPLIT IBUFFER INTO CURRENT, VOLTAGE AND VOLTAGE/4 ARRAYS
C
C
$INCLUDE:'cmacom.FOR'
C
C -----
C
C	SAVE CURRENT FRAME
C
	if( i_start .gt. i_end ) then
	    itemp = i_end
	    i_end = i_start
	    i_start = itemp
	end if

	if( mod(iframe,2) .eq. 0 ) then
	    i_starts = i_start
	    i_ends = i_end
	else
	    i_startf = i_start
	    i_endf = i_end
	end if

	CALL PUT_FRAME(IFRAME,IFILE_NO)
C
C	READ NEXT FRAME
C
	IFRAME = IFRAME + ISTEP
	CALL GET_FRAME(IFRAME,IFILE_NO)

	if( mod(iframe,2) .eq. 0 ) then
	    i_start = i_starts
	    i_end = i_ends
	else
	    i_start = i_startf
	    i_end = i_endf
	end if
C
	RETURN
	END
	REAL FUNCTION FEXP(AMP,TAU,SS,NPAR,X)
C
C	SINGLE OR DOUBLE EXPONENTIAL FUNCTION
C	Enter with AMP = array of exponential amplitudes
C	TAU = times constants, SS = steady state
C	NPAR = 2 indicates single exp. decaying to zero
C	NPAR = 3 single exp. decaying to fitted steady-state
C	NPAR = 4 double exp. decaying to zero
C	NPAR = 5 double exp. decaying to fitted s-s
C

	REAL AMP(2),TAU(2)
	INTEGER*2 NPAR
C
	FEXP = 0.
	IF(NPAR .EQ. 2 ) THEN
		IF(TAU(1) .EQ. 0. ) RETURN
		FEXP = AMP(1)*EXP( -ABS(X/TAU(1)) )
	ELSEIF( NPAR .EQ. 3 ) THEN
		IF(TAU(1) .EQ. 0. ) RETURN
		FEXP = AMP(1)*EXP( -ABS(X/TAU(1)) ) + SS
	ELSEIF( NPAR .EQ. 4 ) THEN
		IF((TAU(1).EQ.0.).OR.(TAU(2).EQ.0.) ) RETURN
		FEXP = AMP(1)*EXP( -ABS(X/TAU(1)) )
     &		    +  AMP(2)*EXP( -ABS(X/TAU(2)) )
	ELSE
		IF((TAU(1).EQ.0.).OR.(TAU(2).EQ.0.) ) RETURN
		FEXP = AMP(1)*EXP( -ABS(X/TAU(1)) )
     &		    +  AMP(2)*EXP( -ABS(X/TAU(2)) ) + SS
	ENDIF
	RETURN
	END

	SUBROUTINE AVERAGE_SEGMENT(IBUFFER,I0,I1,AVG,SUM)
C
C	AVERAGE ELEMENTS OF IBUFFER FROM I0 TO I1 (INCLUSIVE)
C	AND RETURN AVERAGE IN AVG AND SUM IN SUM.
C
	INTEGER IBUFFER(1)
C
C	CODE
C
	SUM = 0.
	DO 10 I = I0,I1
		SUM = SUM + FLOAT(IBUFFER(I))
10	CONTINUE
	AVG = SUM/FLOAT(I1 - I0 + 1)
	RETURN
	END

	SUBROUTINE SUBTRACT_BASELINE(I0,I1,IBUF_IN,NPOINTS
     &						,IBASE_LEVEL)
C
C	CALCULATE A BASELINE LEVEL BY AVERAGING  POINTS FROM
C	ELEMENT "I0" TO "I1" IN INTEGER ARRAY "IBUF_IN", LENGTH "NPOINTS",
C	SUBTRACT THIS VALUE FROM "IBUF_IN"
C	AND RETURN THE BASELINE VALUE IN "IBASE_LEVEL"
C
	INTEGER IBUF_IN(1),NPOINTS,IBASE_LEVEL
C
C ------------------------------------------------------------------
C
	AVG = 0.
	DO 10 I = I0,I1
		AVG = AVG + FLOAT(IBUF_IN(I))
10	CONTINUE
	AVG = AVG/FLOAT(I1 - I0 + 1)
	IBASE_LEVEL = IFIX(AVG)
C
	CALL ADD_ARRAY(-IBASE_LEVEL,IBUF_IN,NPOINTS)
C
	RETURN
	END

	subroutine disc_full_warning()


	character*30 msg(2) /
     &	' WARNING ... Disc Full.',
     &	' Record not saved. ' /

	call display_message(3,3,28,msg,2)
	return
	end



