	PROGRAM CMAP
$INCLUDE:'CMACOM.FOR'
C
c
c -- CMAP V1.3 Cardiac Muscle action potential analysis
C    (c) J. Dempster  1990-1991
C	Department of Physiology/Pharmacology,
C	University of Strathclyde.
C	This program is provided for academic research purposes
C	only and must not be sold or distributed further without
C	the permission of the author.
C -------------------------------------------------------------
c	V2.1 MARCH 1991 ... Discrimination between CAP and stim. art.
c			    disc reset added to avoid floppy disc corruption
c			    New File error fixed
c	V1.3 MAY 1991	... New default file path added, LAB-PC interface
c	V1.4 JAN 1992	... Resting membrane potential corrected
c	V1.5 JUN 1992	... Now prints summary on postscript printer
c	V1.6 FEB 1994	... Support for Digidata 1200
c	V1.7 APR 1994	... SUpport for N.I. ATMIO-16F
c	V1.7a APR 1994	... ATMIO-16F in diff mode
c	V1.7b APR 1994	... Bug in DMA buffer allocation fixed
c	V1.7c JUL 1994	... file_menu bug fixed
c	V1.8 FEB 1996 ... Problems with Record duration changing fixed
c       V1.8a 10/7/96 ... Time bar on hard copy plots corrected
c       V1.9  17/7/96 ... Display now shows resting potential
c       V1.9a 8/1/98 ... Bug which caused incorrect APD.90 & APD.50
c                    when i_starts > 1 fixed
c
	character*80 string
	character drive
	logical new_menu

	CHARACTER KEY
	PARAMETER(nmenu=7,istatus_left=59,istatus_top=20)
	CHARACTER*20 MENU(Nmenu) /
     &	 'Record to disc    F1',
     &	 'View    records   F2',
     &	 'Analyse records   F3',
     &	 'Set parameters    F4',
     &	 'Data files        F5',
     &	 'Lab. interface    F6',
     &	 'Exit program       Q' /

	character*24 errmsg1 / ' No records available! ' /
	character*40 lab_card_name / ' ' /
C
C
C	CODE
C	----
C
C -- Initialisation ----------------------------------------------
C

C	Prevent run-time MATHs error from aborting program
C	(see Appendix D Microsoft FORTRAN V4.1 Users Guide)
	CALL LCWRQQ(16#133E)
C
C	Open Gem graphics package
C
	CALL OPEN_WORKSTATION(ISCREEN,1)
	IF(ISCREEN.EQ.0) STOP
	CALL SET_MARGINS(2,1,80,25)


C	Read configuration file

	CALL OPEN_FILE(IDATA_FILE_NO,IERR,'CMAP.INI')
	IF(IERR .EQ. 0) THEN
	    CALL GET_HEADER
	    CALL CLOSE_FILE(IDATA_FILE_NO,IERR)
	    IDATA_FILE_NO = 0
	ENDIF

	if( default_path .eq. ' ' ) then	! If a default file path
	    call get_default_disc( drive )	! does not exist, create
	    default_path = drive//':\'      ! one on the current drive.
	end if

	ix = len_trim(default_path)		! Make sure the path
	if( default_path(ix:ix).ne.'\') then    ! ends with a '\'
	    ix = ix + 1
	    default_path(ix:ix) = '\'
	end if

	file_name = default_path			! Create the
	file_name(ix+1:len(file_name)) = 'unnamed.sca'	! default data file.

	call open_file( idata_file_no, ierr, file_name )
	if( ierr .eq. 0 ) then
	    string = default_path
	    call get_header
	    default_path = string
	else
	    call create_file( idata_file_no, ierr, file_name )
	    if( ierr .eq. 0 ) idata_file_no = 0
	    n_frames = 0
	end if

	BIT_CURRENT = CONVERT_GAIN(GAIN_CURRENT)
C
C 	Create work  file for for frame averages
C
	CALL CREATE_FILE(IAVG_FILE_NO,IERROR,'SCAN.AVG')
	IF(IERROR .NE.0) THEN
	    CALL CLOSE_WORKSTATION(ISCREEN)
	    STOP 'Cannot create file SCAN.AVG'
	ENDIF
C
C
100	CONTINUE

	call reset_disc

	call erase_all

c
c	Display title
c
	call display_box(1,1,istatus_left-2,25)
	call move_cursor(5,5)
	call display_string(
     &  'CMAP - Cardiac Muscle Action Potential Program V1.9a')
	call move_cursor(5,6)
	call display_string(
     &	' (c) J. Dempster 1990-1996, All Rights Reserved')
        call move_cursor(5,7)
        call display_string('(Updated 8/1/98)')

	call move_cursor(3,24)
	call get_lab_interface_name ( interface_card, lab_card_name )
	call display_string( lab_card_name )

c
c	Display program status
c
	call display_box(istatus_left-1,istatus_top-1,79,25)
	call set_margins(istatus_left,istatus_top,79,25)
	call move_cursor(istatus_left,istatus_top)

	call display_string( file_name(1:20) )
	call new_line
	call display_string( file_name(21:30) )
	call new_line

	write(string,'(''Records '',I5)') n_frames
	call display_string( string(1:20) )
	call new_line

	write(string,'(''Disc space'',I7,''Kb'')' )
     &	 int4(free_disc_space())
	call display_string( string(1:20) )
	call new_line

	write(string,'(''Free Memory  '',i4,''Kb'')' ) ifree_memory()
	call display_string( string(1:20) )

	call set_margins(2,1,80,25)

C
c	Present options menu and wait for user response
c
	new_Menu = .true.
	iop = Iwait_MENU_VERTICAL1(menu,'123456Q'
     &	,nmenu,istatus_left-1,1,new_menu,iop,' Options ',key)

	select case( iop )

	case( 1 )
C
C -- Create ADC data file ---------------------------------------
C
	    CALL DIGITISE_ANALOGUE_SIGNAL
	    FREE_SPACE = FREE_DISC_SPACE()

	case( 2 )
C
C -- View ADC data records --------------------------------------
C
	    IF(N_FRAMES .GT. 0) THEN
		IFRAME = 1
		call display_records(' VIEW RECORDS ',idata_file_no
     &		,iframe,' ',0)
	    ELSE
		call display_message(3,3,26,errmsg1,1)
	    ENDIF

	case( 3 )
C
C -- Analyse Peak/Steady-state -----------------------------------
C
	    if( n_frames .gt. 0 ) then
		CALL PEAK_ANALYSIS
	    else
		call display_message(3,3,26,errmsg1,1)
	    endif

	case( 4 )
C
C -- Configure ADC collection parameters --------------------------
C
	   CALL SET_ADC_PARAMETERS

	case( 5 )
C
C --	Files options
C
	   CALL FILES_OPTIONS

	case( 6 )
c
c	Choose lab. interface
c
	   call select_lab_interface( interface_card, lab_card_name )

	case( 7 )
C
C -- Stop program -------------------------------------------------
C
	  CALL QUERY_BOX(2,2,' Exit Program! Are you sure (Y/N) ? '
     &	  ,KEY)
	  IF( KEY .EQ. 'Y' ) THEN
		IF(IDATA_FILE_NO.NE.0) THEN
		    CALL SAVE_HEADER
		    CALL CLOSE_FILE(IDATA_FILE_NO,IERROR)
		ENDIF
		CALL CLOSE_FILE(IAVG_FILE_NO,iERROR)
		CALL CLOSE_WORKSTATION(ISCREEN)
		STOP
	  ENDIF

	end select
	goto 100

	END


	BLOCK DATA
C
$INCLUDE:'cmacom.FOR'
C
	DATA NB_ANALYSIS,NB_DATA,N_CHANNELS,NB_FILE /1,2,1,0/
	DATA N_FRAMES,N_RECORDS,N_POINTS /0,0,512/
	DATA N_RECORDS_REQUESTED /10/
	DATA I_BASE,N_BASE,I_ZERO /1,20,1/
	data i_start,i_end,i_starts,i_ends,i_startf,i_endf
     &	/1,512,1,512,1,512/
	DATA GAIN_CURRENT,DT /10.,0.04/
	DATA Izero_CURRENT /2048/
	data fixed_zero / 'N' /
	DATA C_UNITS,T_UNITS /'mV  ','ms  '/
	DATA ADC_RANGE /5./
	DATA delay / 100. /
	DATA INTERFACE_CARD /1/
	DATA RECORD_GAIN /1./
	DATA FILE_NAME,default_path / ' ',' ' /
	DATA IDATA_FILE_NO /0/
	DATA IAVG_FILE_NO /0/
	DATA ID / ' ' /
	END



	SUBROUTINE SET_ADC_PARAMETERS
C
C	Set or change adc data collection parameters
C
	PARAMETER(NROWS=7)
	CHARACTER*36 MENU(NROWS) /
     &	' No. of records to be collected',
     &	' Record size (256,512,1024,2048)',
     &	' Record duration (ms)',
     &	' Scale factor (mV/',
     &	' Units',
     &	' Input voltage range ',
     &	' Fast record delay (ms)' /

	CHARACTER*12 TEXT(NROWS)
	character*40 title
C
$INCLUDE:'cmacom.FOR'
C
C	CODE
C	----

C	Get limits allowed by interface

	CALL LAB_LIMITS(INTERFACE_CARD
     &,DT_MIN,DT_MAX,AD_MIN,AD_MAX,DAC)
C
	MENU(4) = ' Calibration  factor (mV/'//C_UNITS//')'
C
C	Insert current values into reponse field of form
C
	WRITE(TEXT(1),901) N_RECORDS_REQUESTED
901	FORMAT(I4)
	write(text(2),901) n_points
	IF( T_UNITS .EQ. 's' ) DT = DT*1000.
	WRITE(TEXT(3),902) DT*float(nwork)
902	FORMAT(F12.3)
	WRITE(TEXT(4),902) GAIN_CURRENT
	TEXT(5) = C_UNITS
	WRITE(TEXT(6),902) ADC_RANGE
	WRITE(TEXT(7),902) delay
C

	title = ' '
100	if( title .eq. ' ' ) then
	    title = ' Set Recording/Analysis Parameters '
	endif

	CALL TEXT_WINDOW(MENU,TEXT,NROWS,2,2,title)

	n_records_requested = int(
     &	check_limits(text,1.,2000.,1,title) )
	if( title .ne. ' ' ) goto 100

	n_points = int(
     &	 check_limits(text,256.,float(max_points),2,title) )
	if( title .ne. ' ' ) goto 100

	i = 256
10	if( (n_points .gt. i) .and. (i.ne.max_points) ) then
	    i = i * 2
	    goto 10
	endif
	n_points = i

	r = check_limits(text,dt_min*float(nwork),
     &	dt_max*float(nwork),3,title)
	dt = r/float(nwork)
	if( title .ne. ' ' ) goto 100
	IF( DT .GT. 2. ) THEN
	    T_UNITS = 's'
	    DT = DT/1000.
	ELSE
	    T_UNITS = 'ms'
	ENDIF

	gain_current = check_limits(text,0.,1E30,4,title)
	if( title .ne. ' ' ) goto 100

	c_units = text(5)

	adc_range = abs( check_limits(text,-10.,10.,6,title) )
	if( title .ne. ' ' ) goto 100

	BIT_CURRENT = CONVERT_GAIN(GAIN_CURRENT)

	delay = abs( check_limits(text,0.,dt*float(nwork),7,title) )
	if( title .ne. ' ' ) goto 100
	RETURN
	END

	subroutine select_data_file( ix, iy, ifile_no, n_max, name )
	character*(*) name
$include:'cmacom.for'

	character key
	logical new_menu

	parameter(nmenu=2)
	character*24 menu(nmenu) /
     &	' Raw signal records  F1',
     &	' Average record      F2' /

c
c	code
c
	if( n_records .gt. 0 ) then
	    new_Menu = .true.
	    itype = Iwait_MENU_VERTICAL1(menu,'12'
     &	    ,nmenu,ix,iy,new_menu,itype,' Record type ',key)
	    if( itype .eq. 1 ) then
		ifile_no = idata_file_no
		n_max = n_frames
	    else
		ifile_no = iavg_file_no
		n_max = n_records
	    endif
	else
	    itype = 1
	    ifile_no = idata_file_no
	    n_max = n_frames
	endif

	name = menu(itype)
	return
	end

