	SUBROUTINE DISPLAY_records(TITLE,IFILE_NO,IFRAME,
     &	message,nmsg)
C       17/7/96 ... Now shows resting potential
$INCLUDE: 'cmacom.FOR'
C	-------------------------------------------------------------------
C	Display selected ADC records and allow values to be read by cursor.
C	-------------------------------------------------------------------
C	Enter with:
C	TITLE = Title string indicating context of display option
C	IFILE_NO = channel No. of data file in use
C	IFRAME = Start display at this record no.
C
	character*(*) message(1)
	CHARACTER*(*) TITLE

	LOGICAL CHANGE_BORDER,CHANGE_YT,SPECIAL,CLEAR_SCREEN,new_menu
	INTEGER*2 IDISPLAY_AREA(4),izero_level(2)

	character report*56(10), string*40, key
	automatic report,string,idisplay_area,izero_level

	parameter(nmenu=13,istatus_left=64,istatus_top=18)
	character*15 menu(nmenu) /
     &	'Zoom in       +',
     &	'Next  rec. PgDn',
     &	'Prev. rec. PgUp',
     &	'Goto  rec. Home',
     &	'Accept/Rej.  F1',
     &	'Store On/Off F2',
     &	'Save cursor  F3',
     &	'List saved   F4',
     &	'Plot display F5',
     &	'Set T.zero   F6',
     &	'Mark area    F7',
     &	'Resting pot. F8',
     &	'Exit        ESC'/

c
c	Display magnification, offsets & colour
c
	integer*2 iy_scale(max_channels) / 6 /
	integer*2 min_y_scale(max_channels) / 6 /
	integer*2 max_y_scale(max_channels) / 32 /
	integer*2 iy_offset(max_channels) / 0 /
	integer*2 icolour(max_channels) / 2 /
C
C	Cursor readout data table
C
	PARAMETER(MAX_ROW=500,MAX_COL=3)
	REAL TABLE(max_col,max_row)
	EQUIVALENCE (IWORK(1),TABLE(1,1))
c
c	Best fit line work area starts at iwork(8001)
c
	parameter(ifit0=8001)

	logical fit_available / .false. /
C
C
C
C -- CODE -------------------------------------------------------
C
	IF( IFILE_NO .EQ. IDATA_FILE_NO ) THEN
	    N_MAX = N_FRAMES
	ELSE
	    N_MAX = 1
	ENDIF
C
C -- Set size of display area
C 
	CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	CALL GET_CHARACTER_SIZE(IW,IH)
	IDISPLAY_AREA(1) = IW
	IDISPLAY_AREA(2) = MAX_ndc - 24576 - IH
	IDISPLAY_AREA(3) = IDISPLAY_AREA(1) + ((60*IW)/512)*512
	IDISPLAY_AREA(4) = IDISPLAY_AREA(2) + 24576
	CALL SET_SIZE(IDISPLAY_AREA(1),IDISPLAY_AREA(2)
     &	,IDISPLAY_AREA(3),IDISPLAY_AREA(4))
C
C	Set display size to whole of buffer , cursor in middle
C
	N_DISP = N_POINTS
	ICURSOR = N_DISP/2
	IOLD_CURSOR = ICURSOR
	I0 = 1
	I1 = N_DISP
	ILAST_F7 = I_END
C
C	Read first frame then do a change frame
C	to get frame number on display
C
	N_TABLE = 0
	CALL GET_FRAME(IFRAME,IFILE_NO)
	if( mod(iframe,2) .eq. 0 ) then
	    i_start = i_starts
	    i_end = i_ends
	else
	    i_start = i_startf
	    i_end = i_endf
	end if
	CALL CHANGE_FRAME(IFRAME,0,IFILE_NO)
	call calculate_zero_levels( izero_level )
C
	CLEAR_SCREEN = .TRUE.
	CHANGE_BORDER = .TRUE.
	new_menu = .true.
	call erase_all

C -- Begin display loop --------------------------------------------
C
100	CONTINUE
C
c
c	Refresh options menu
c
	if( new_menu ) then
	    key = ' '
	    iop = IMENU_VERTICAL1(menu,'+QPH12345678$'
     &	    ,nmenu,istatus_left-1,1,new_menu,iop,' Options ',key)
	endif


	IF( CHANGE_BORDER ) THEN

C
C 	-- Draw display border and help information -------------------
C
		T_MIN = FLOAT(I0 -1)*record_dt
		T_MAX = FLOAT(I0 + N_DISP - 1)*record_dt
		CALL ERASE_BOX(1,1,62,25)
		CALL DISPLAY_BOX(1,1,62,21)
		CALL MOVE_CURSOR(2,21)
		WRITE(STRING,'(f7.2,1x,a)') T_MIN,T_UNITS
		CALL DISPLAY_STRING(STRING(1:13))
		WRITE(STRING,'(f7.2,1x,a)') T_MAX,T_UNITS
		CALL MOVE_CURSOR(48,21)
		CALL DISPLAY_STRING(STRING(1:13))
c
c		Display optio  title
c
		CALL MOVE_CURSOR(2,1)
		CALL DISPLAY_STRING(TITLE)
		CHANGE_BORDER = .FALSE.
	    call move_cursor(2,25)
	    call display_string('DT= ')
	    call display_flt( record_dt)
	    call display_string(' ms')

c
c		Display any special messages for user
c
		if( nmsg .gt. 0 ) then
		    call display_message(2,24-nmsg,len(message(1))
     &		    ,message,nmsg)
		endif
c
c		Display start/end of analysis area
c
		CALL SET_WRITING_MODE(ISCREEN,2)
		call set_polyline_type(iscreen,3)

		if( (i_start .ge. i0) .and. (i_start.le.i0+n_disp))
     &		call display_vertical_cursor(
     &		iscreen,idisplay_area,i_start-i0+1,n_disp)

		if( (i_end.ge.i0) .and. (i_end.le.i0+n_disp))
     &		call display_vertical_cursor(
     &		ISCREEN,idisplay_area,I_end-I0+1,N_DISP)

		call set_polyline_type(iscreen,6)
		if( (i_zero.ge.i0) .and. (i_zero.le.i0+n_disp))
     &		call display_vertical_cursor(
     &		ISCREEN,idisplay_area,I_zero-I0+1,N_DISP)
c
c		Display zero level
c
		call set_polyline_type(iscreen,3)
		call set_polyline_colour( iscreen, icolour(1))
		call display_horizontal_cursor(iscreen,idisplay_area,
     &		izero_current,iy_scale(1),iy_offset(1) )
c
c               Display resting potential
c
                call set_polyline_type(iscreen,2)
		call set_polyline_colour( iscreen, icolour(1))
		call display_horizontal_cursor(iscreen,idisplay_area,
     &          izero_level(1),iy_scale(1),iy_offset(1) )

		call set_polyline_colour( iscreen, 1 )
		call set_polyline_type(iscreen,1)
		CALL SET_WRITING_MODE(ISCREEN,3)
c
c		Put readout cursor on-screen
c
		icursor = max(min(icursor,i0+n_disp-1),i0)
		IOLD_CURSOR = ICURSOR
		call display_vertical_cursor(
     &		ISCREEN,idisplay_area,iold_cursor-I0+1,N_DISP)

		CALL SET_WRITING_MODE(ISCREEN,1)

		CHANGE_YT = .TRUE.
	ENDIF
C
C -- Display signal on screen
C		
	IF( CHANGE_YT ) THEN

	    call plot_channel( iscreen, idisplay_area, ibuffer,1,
     &	    n_channels,i0, n_disp, iy_scale(1),iy_offset(1),icolour(1))

	    nlines = 0
	    fit_available = .false.

	    CHANGE_YT = .FALSE.
	ENDIF
C
C -- Draw vertical readout cursor -------------------------------
C
	CALL SET_WRITING_MODE(ISCREEN,3)
	CALL display_VERTICAL_CURSOR(
     &	ISCREEN,idisplay_area,IOLD_CURSOR-I0+1,N_DISP)
	CALL display_VERTICAL_CURSOR(
     &	ISCREEN,idisplay_area,ICURSOR-I0+1,N_DISP)
	CALL SET_WRITING_MODE(ISCREEN,1)
	IOLD_CURSOR = ICURSOR

c
c --	Display status box ----------------------------------
c
	call display_box(istatus_left-1,istatus_top-1,79,25)
	call set_margins(istatus_left,istatus_top,79,25)

	call move_cursor(istatus_left,istatus_top)
	write(string,'(I3,1x,a)') iframe,frame_status
	call display_string(string(1:15))
	call new_line

	write(string,'(''At'',f11.2,''s'')') frame_time
	call display_string(string(1:15))
	call new_line

	TIME = FLOAT(ICURSOR-I_ZERO)*record_dt
	write(string,'(''T:'',F11.2,a)') time,t_units(1:2)
	call display_string(string(1:15))
	call new_line

	CURRENT = FLOAT(ibuffer(ICURSOR) - IZERO_current )*BIT_CURRENT
	write(string,'(''Vabs'',F9.2,''mV'')') current
	call display_string(string(1:15))
	call new_line

	volts_rel = FLOAT(ibuffer(ICURSOR) - IZERO_level(1))*BIT_CURRENT
	write(string,'(''Vrel'',F9.2,''mV'')') volts_rel
	call display_string(string(1:15))
	call new_line

	dv_by_dt = float( ibuffer(icursor+1) - ibuffer(icursor) )
     &	* (bit_current / record_dt)
	write(string,'(''dV/dt'',F7.0,''V/s'')') dv_by_dt
	call display_string(string(1:15))
	call new_line

	if( .not. clear_screen ) then
	     call display_string('Storage On')
	else
	     call display_string('          ')
	endif


	call set_margins(2,1,80,25)


c --- END of status box code ---------------------------------


c
c --- Readout cursor movement code --------------------------
c
c
c	Wait for user to press a key
c
	call wait_for_key( key, special )

	if( special .and. (key .eq. 'L') ) then
C	    <- = move cursor left 1 point
	    ICURSOR = max0( ICURSOR - 1, 1 )
	    IF(ICURSOR .LT. I0) THEN
		I0 = max0(I0 - 40,1)
		I1 = I0 + N_DISP - 1
		change_border = .TRUE.
	    ENDIF
	    iop = 0
	elseif( special .and. (key .eq. 'R') ) then
C	    -> = move cursor right 1 point
	    ICURSOR = min0(ICURSOR + 1,n_points)
	    IF(ICURSOR .GT. I1) THEN
		I1 = min0(I1 + 40,n_points)
		I0 = I1 - N_DISP + 1
		change_border = .TRUE.
	    ENDIF
	    iop = 0
	elseif( special .and. (key .eq. 'B') ) then
C	    CTRL <- = B Move cursor left 20 points
	    ICURSOR = max0(ICURSOR - 20,1)
	    IF(ICURSOR .LT. I0) THEN
		I0 = max0(I0 - 40,1)
		I1 = I0 + N_DISP - 1
		change_border = .TRUE.
	    ENDIF
	    iop = 0
	elseif( special .and. (key .eq. 'F') ) then
C	    CTRL -> = Move cursor right 20 points
	    ICURSOR = min0( ICURSOR + 20, n_points )
	    IF(ICURSOR .GT. I1) THEN
		I1 = min0( I1 + 40, n_points )
		I0 = I1 - N_DISP + 1
		change_border = .TRUE.
	    ENDIF
	    iop = 0
	else
C
c	    Present options menu and return "iop=1..13" if
c	    an option has been selected. "iop=0" if no selection
c
	    iop = IMENU_VERTICAL1(menu,'+QPH12345678$'
     &	    ,nmenu,istatus_left-1,1,new_menu,iop,' Options ',key)

	endif
c
c --- END of readout cursor code --------------------------
C
C
	IF(IOP .LE. 0) GOTO 100
	GOTO(1,2,3,4,5,6,7,8,9,10,11,12,13) IOP
C
C -- Expand display ----------------------------------------------
C
1	call change_display_magnification( ibuffer,
     &	i0,n_disp,iy_scale,iy_offset,min_y_scale,max_y_scale,icolour,
     &	idisplay_area )
	CHANGE_BORDER = .TRUE.
	new_menu = .true.
	GOTO 100
C
C -- PgDn - Read next frame -----------------------------------------
C
2	CALL CHANGE_FRAME(IFRAME,1,IFILE_NO)
	call calculate_zero_levels( izero_level(1) )
	CHANGE_YT = .TRUE.
	IF( CLEAR_SCREEN ) CHANGE_BORDER = .TRUE.
	GOTO 100	
C
C -- PgUp - Read last frame stored ---------------------------------
C
3	CALL CHANGE_FRAME(IFRAME,-1,IFILE_NO)
	call calculate_zero_levels( izero_level(1) )
	CHANGE_YT = .TRUE.
	IF( CLEAR_SCREEN ) CHANGE_BORDER = .TRUE.
	GOTO 100	
C
C -- Goto selected record ------------------------------------------
C
4	CALL CHANGE_FRAME(IFRAME,0,IFILE_NO)
	write(string,'('' Go to record (1-'',i5,'') ? '')') n_max
	call display_message(2,23,46,string(1:30),1)
	call get_number(r,1.,float(n_frames),float(iframe))
	call erase_box(2,23,istatus_left-1,25)
	iframe = int(r)
	CALL GET_FRAME(IFRAME,IFILE_NO)
	CALL CHANGE_FRAME(IFRAME,0,IFILE_NO)
	call calculate_zero_levels( izero_level(1) )
	CHANGE_YT = .TRUE.
	IF( CLEAR_SCREEN ) CHANGE_BORDER = .TRUE.
	GOTO 100
C
C -- F1 - Change record status
C
5	new_menu = .true.
	if( frame_status .eq. 'ACCEPTED' ) then
	    frame_status = 'REJECTED'
	else
	    frame_status = 'ACCEPTED'
	endif
	change_border = .true.
	new_menu = .true.
	GOTO 100
C
C -- F2 - Clear screen after each frame
C
6	IF( CLEAR_SCREEN ) THEN
		CLEAR_SCREEN = .FALSE.
	ELSE
		CLEAR_SCREEN = .TRUE.
	ENDIF
	GOTO 100
C
C -- F3 - Save cursor readout value to table ------------------------
C
7	N_TABLE = N_TABLE + 1
	TABLE(1,N_TABLE) = IFRAME
	TABLE(2,N_TABLE) = TIME
	TABLE(3,N_TABLE) = CURRENT
	GOTO 100
C
C
8	CALL MOVE_CURSOR(3,3)
	CALL DISPLAY_STRING(
     &' F4 Saved cursor values ')
	CALL LIST_TABLE(TABLE,MAX_COL,N_TABLE,14,3,3
     &,'Record No.       '//T_UNITS//'       '//C_UNITS)
	call erase_all
	new_menu = .true.
	CHANGE_BORDER = .TRUE.
	GOTO 100
C
C -- F5 Plot screen -------------------------------------------------
C
9       continue
        report(1) = file_name
        write(report(2),'(''Rec='',i4,'' Scale factor='',f8.2,a)')
     &  iframe,gain_current,c_units
        report(3) = id
	iheight = idisplay_area(4) - idisplay_area(2)
	call plot_display( ibuffer, i0, n_disp, iy_scale, iy_offset,
     &  izero_level,iheight, report, nlines+3,
     &	fit_available, iwork(ifit0) )

	CHANGE_BORDER = .TRUE.
	new_menu = .true.
	GOTO 100
c
c	F6 - set time zero
c
10	I_ZERO = ICURSOR
	I_RECORD_ZERO = ICURSOR
	CHANGE_BORDER = .TRUE.
	goto 100
C
C -- F7 Mark analysis area ----------------------------------------
C
11	IF(ILAST_F7.EQ.I_END) THEN
		I_START = ICURSOR
		ILAST_F7 = I_START
	ELSE
		I_END = ICURSOR
		ILAST_F7 = I_END
	ENDIF
	IF(I_START.GT.I_END) THEN
		IKEEP = I_START
		I_START = I_END
		I_END = IKEEP
	ENDIF
	I_RECORD_START = I_START
	I_RECORD_END = I_END
	CHANGE_BORDER = .TRUE.
	GOTO 100
C
C -- F8 Calibrate signal
C
12	call calibrate_signal( icursor )
	call calculate_zero_levels( izero_level(1) )
	change_border = .true.
	goto 100
C
C -- Esc quit this option -------------------------------------------
C
13	CALL CHANGE_FRAME(IFRAME,0,IFILE_NO)
	return

	END

	SUBROUTINE calibrate_signal(icursor)
$INCLUDE: 'cmacom.FOR'
C
c	Let user set current zero levels
C
	PARAMETER (NLINES=4)
	CHARACTER*44 TITLE
	CHARACTER*40 MENU(NLINES) /
     &	'Voltage scaling factor ',
     &	'Resting potential (mV)',
     &	'Resting pot. measurement point',
     &	'No. of points averaged ' /
	character*10 list(nlines)

	automatic title,list
C
C	CODE
C
	write(list(1),'(f10.2)') convert_gain( bit_current )

	write(list(2),'(f10.2)') float(ibuffer(icursor) -
     &	izero_current )*bit_current

	write(list(3),'(i4)') icursor

	write(list(4),'(i4)') n_base

	title = ' '
100	if( title .eq. ' ' ) title = ' Calibrate '
	call text_window(menu,list,nlines,3,5,title)

	gain_current = check_limits(list,0.,1E30,1,title)
	if( title .ne. ' ' ) goto 100
	bit_current = convert_gain( gain_current )

	r = check_limits(list,-200.,200.,2,title)
	izero_current = ibuffer(icursor) - int(r/bit_current)
	if( title .ne. ' ' ) goto 100

	i_base = int ( check_limits(list,1.,float(n_points),3,title) )
	if( title .ne. ' ' ) goto 100

	n_base = int( check_limits(list,1.,float(n_points),4,title) )
	if( title .ne. ' ' ) goto 100

	RETURN
	END

	subroutine calculate_zero_levels(izero)
$include:'cmacom.for'

	if( fixed_zero .eq. 'Y ') then
	    izero = izero_current
	else
	    I_BASE1 = I_BASE + N_BASE - 1
	    CALL AVERAGE_SEGMENT(ibuffer,I_BASE,I_BASE1,AVG,SUM)
	    IZERO = int(avg)
	endif
	return
	end

	subroutine change_display_magnification( ibuf,
     &	i0,n_disp,iy_scale,iy_offset,min_y_scale,max_y_scale,
     &	icolour,iarea )
$include:'cmacom.for'
	integer*2 ibuf(1),iy_scale(max_channels),iy_offset(max_channels),
     &	min_y_scale(max_channels),max_y_scale(max_channels),
     &	icolour(max_channels),iarea(4)

c
c	code
c

	max_y = 4096
c
c	Erase selected Display area and re-draw
c	channel at minimum magnification
c
	call fill_rectangle( iscreen, iarea )
	min_dx = (iarea(3) - iarea(1))/n_points
	max_dx = 32*min_dx
	ich = 1
	call plot_channel( iscreen, iarea, ibuf,
     &	ich, max_channels, 1, n_points, min_y_scale,
     &	0, icolour )
c
c	Superimpose box indicating current magnified display
c	area and let user move box's size and location
c
	call set_display_window(iarea
     &	,min_dx,max_dx,min_y_scale,max_y_scale,max_y
     &	,i0,n_disp,iy_scale,iy_offset,1,22)

	return
	end
