	subroutine peak_analysis
c
c	Analyse peak value, area,  rise-time, for each record
c	and plot variable.
c       8/1/98 V1.9a Bug which caused incorrect APD.90 & APD.50
c                    when i_starts > 1 fixed   
C	-------------------------------------------
C
$INCLUDE:'cmacom.FOR'
C
	CHARACTER*18 YLABEL,xlabel
	CHARACTER KEY
	CHARACTER*40 STRING
	LOGICAL plot_available,new_menu,histogram

	character*52 report(10)
	REAL xy(1)
	EQUIVALENCE (xy,iwork(2001))

	parameter(nmenu=8,istatus_left=59,istatus_top=19)

	character*20 menu(nmenu) /
     &	' Analyse records  F1',
     &	' Plot X/Y graph   F2',
     &	' Set axes range   F3',
     &	' Plot hard copy   F4',
     &	' List graph       F5',
     &	' Summary report   F6',
     &	' Edit comment     F7',
     &	' Exit            ESC'/

	parameter(nvars=11)
	character*16 var_name(nvars)
	integer*2 ivar_map(nvars)

C
C	CODE
C	----
C

c
c	Define list of variable
c
	VAR_NAME(1) = 'Record No.'
	IVAR_MAP(1) = 1
	VAR_NAME(2) = 'Clock Time s'
	IVAR_MAP(2) = 2
	VAR_NAME(3) = 'Rise Time (ms)'
	IVAR_MAP(3) = 3
	var_name(4) = 'dV/dt (max) V/s'
	ivar_map(4) = 7
	VAR_NAME(5) = 'Average mV'
	IVAR_MAP(5) = 4
	VAR_NAME(6) = 'Peak mV'
	IVAR_MAP(6) = 5
	VAR_NAME(7) = 'Area mV.ms'
	IVAR_MAP(7) = 6
	VAR_NAME(8) = 'APD.50 ms'
	IVAR_MAP(8) = 27
	VAR_NAME(9) = 'APD.90 ms'
	IVAR_MAP(9) = 28
	VAR_NAME(10) = 'Interval s'
	iVAR_MAP(10) = 8
	VAR_NAME(11) = 'Rest. Pot. mV '
	iVAR_MAP(11) = 29

c ---------------------------------------------

	plot_available = .false.
	iop = 1

C
100	CONTINUE
	    CALL SET_MARGINS(2,1,80,25)

	    write(report(1)
     &	    ,'(''File: ''a,'' Recs. '',i4,''-'',i4)')
     &	    file_name,ir_s,ir_e
	    report(2) = id
	    nlines = 2
c
	    CALL ERASE_ALL
	    call display_box(1,1,istatus_left-2,25)
	    CALL MOVE_CURSOR(2,1)
	    CALL DISPLAY_STRING(' Analyse records ')

C
C	    Plot graph on screen
C
	    if( plot_available ) then
		if( .not. histogram ) then
		     call plot_graph('S',xy,np,xlo,ylo,xhi,yhi
     &		     ,xtic,ytic,xlabel,ylabel,report,nlines)
		else
		     call plot_histogram('S',xy,np,xlo,ylo,xhi,yhi
     &		     ,xtic,ytic,xlabel,ylabel,report,nlines)
		endif
	    endif
c
c	    Display status box
c
	    call display_box(istatus_left-1,istatus_top-1,79,25)
	    call set_margins(istatus_left,istatus_top,79,25)
	    call move_cursor(istatus_left,istatus_top)
	    call display_string(file_name(1:20))
	    call new_line
	    write(string,'(''Records '',i5,''-'',i5)') ir_s,ir_e
	    call display_string(string(1:20))
	    call new_line

	    call set_margins(2,1,80,25)

c
c	Wait for user to select an option from menu
c
	new_menu = .true.
	iop = Iwait_MENU_VERTICAL1(menu,'1234567$',nmenu
     &	,istatus_left-1,1,new_menu,iop,' Options ',key)

	if( iop .eq. 0 ) goto 100
	GOTO(1,2,3,4,5,6,7,8) IOP

c
c -- Analyse records on file
c
1	call analyse_records(ir_s,ir_e)
	plot_available = .false.
	goto 100
c
c -- X/Y plot of a selected pair of variables
c
	new_menu = .true.
2	ix_var = Iwait_MENU_VERTICAL1(var_name,'123456789AB',nvars
     &	,2,2,new_menu,iop,' X Variable ',key)
	xlabel = var_name(ix_var)
	new_menu = .true.
	iy_var = Iwait_MENU_VERTICAL1(var_name,'123456789AB',nvars
     &	,3,3,new_menu,iop,' Y Variable ',key)
	ylabel = var_name(iy_var)

	call create_graph(ivar_map(ix_var),ivar_map(iy_var)
     &	,idata_file_no,ir_s,ir_e
     &	,xy,np,xmin,ymin,xmax,ymax)

	xlo = xmin
	ylo = ymin
	xhi = xmax
	yhi = ymax
	if(xlo .eq. xhi ) xhi = xlo + 1.
	if(ylo .eq. yhi ) yhi = ylo + 1.
	xtic = (xhi-xlo)/5.
	ytic = (yhi-ylo)/5.
	if( np .gt. 0 ) plot_available = .true.
	histogram = .false.
	goto 100
C
C -- Set plot axes range and tic spacing
C
3	if( plot_available ) call set_axes_form(2,2,xmin,ymin,xmax,ymax
     &	,xlo,ylo,xhi,yhi,xtic,ytic)
	GOTO 100
C
C -- Plot hard copy of currently displayed graph
C
4	if( plot_available ) then
	    if( .not. histogram ) then
		 call plot_graph('H',xy,np,xlo,ylo,xhi,yhi
     &		 ,xtic,ytic,xlabel,ylabel,report,nlines)
	    else
		 call plot_histogram('H',xy,np,xlo,ylo,xhi,yhi
     &		 ,xtic,ytic,xlabel,ylabel,report,nlines)
	    endif
	endif
	GOTO 100
C
C -- Display table of current graph values
C
5	if( plot_available ) then
	    call list_table(xy,2,np,15,3,4,xlabel(1:12)//ylabel(1:12))
	endif
	goto 100
c
c --	Summary report of results
c
6	call summary(ivar_map,var_name,nvars,
     &	idata_file_no,ir_s,ir_e)
	plot_available = .false.
	goto 100
c
c --	Edit comment line
c
7	call erase_box(2,5,57,7)
	call display_box(2,5,57,7)
	call move_cursor(3,5)
	call display_string(' Edit Comment line ')
	call move_cursor(3,6)
	call get_string( id(1:52), nc, key )
	goto 100
c
c -- Exit
c
8	return
	GOTO 100
	END

	SUBROUTINE CREATE_GRAPH(IX_VAR,IY_VAR,IFILE_NO
     &	,IR_S,IR_E,XY,NP,XMIN,YMIN,XMAX,YMAX)
$INCLUDE:'cmacom.FOR'
C
c	Create aN X/Y plot of variables IX_VAR and IY_VAR
c	from record analysis array (see ANALYSIS in cmacom.FOR)
c	using records between IR_S and IR_E in file IFILE_NO
c
c	Return histogram in array XY of length NP points.
c	Data range is returned in XMIN,YMIN,XMAX,YMAX
c	YLABEL is returned as blank or as % if percentage
C	------------------------------------------------
C
C
	REAL XY(1)

	character*6 status
C
C	CODE
C	----
C
	call display_message(5,7,30,' WAIT ... Creating graph ',1)

	J = 0
	XMIN = 1E30
	YMIN = 1E30
	XMAX = -1E30
	YMAX = -1E30
	if( mod(ir_s,2) .eq. 0 ) ir_s = ir_s - 1
	DO 100 IRECORD = IR_S,IR_E,2
C
	    CALL GET_ANALYSIS_BLOCK(IRECORD,IFILE_NO)
C
	    status = frame_status
C
	    if( status .ne. 'REJECT') then

		J = J + 1

		X = ANALYSIS(IX_VAR)

		IF(X.LT.XMIN) XMIN = X
		IF(X.GT.XMAX) XMAX = X
		XY(J) = X
		J = J + 1
		Y = ANALYSIS(IY_VAR)

		IF(Y.LT.YMIN) YMIN = Y
		IF(Y.GT.YMAX) YMAX = Y
		XY(J) = Y
	    ENDIF
	    IF(J.GT.4000) GOTO 101
100	CONTINUE
101	CONTINUE
	NP = J/2
	RETURN
	END



	SUBROUTINE ANALYSe_records(ir_s,ir_e)
$INCLUDE:'cmacom.FOR'
C
C	------------------------------------------------------------------
C	Read each frame stored on file and calculate, average current,
C	peak current, area, rise time, zero current level. Store these
C	values in the frames's analysis block.
c	Return series of records analysed in IR_S and IR_E
C	------------------------------------------------------------------
C
	integer*2 ir_s,ir_e

	CHARACTER KEY
	LOGICAL SPECIAL
	PARAMETER(N_LIMIT=2000)
	parameter(nmenu=3)
	character*44 menu(nmenu) /
     &	' Start at record ',
     &	' End at record ' ,
     &	' Set anal. region for 1st record only (Y/N)' /

	character*6 list(nmenu)
	character*42 title
	character*56 msg(3)

	character first_only /'Y'/
	logical first_record
	character*6 status

C
C -- CODE -------------------------------------------------------------
C

c
c	Let user set range of records & type of peak analysis
c
	write(menu(1),'('' Start at record (1-'',I5,'')'')') n_frames
	write(list(1),'(i5)') min(max(1,ir_s),n_frames)
	if( ir_e .eq. 0 ) ir_e = n_frames
	write(list(2),'(i5)') min(max(ir_s,ir_e),n_frames)
	list(3) = first_only


	title = ' '
10     if( title .eq. ' ' ) title = ' Set Analysis type & range '
	call text_window(menu,list,nmenu,2,2,title)

	ir_s = int(check_limits(list,1.,float(n_frames),1,title))
	if( title .ne. ' ' ) goto 10
	ir_e = int(check_limits(list,float(ir_s),float(n_frames),2,title))
	if( title .ne. ' ' ) goto 10

	first_only = check_letter(list,'YN',3,title)
	if( title .ne .  ' ' ) goto 10


C
C	Ensure that total number of records in series does
C	not exceed array size N_LIMIT
C
	ir_e = min(ir_s+n_limit-1,ir_e)

C
C ----- Analyse records in series IR_S to IR_E
c	Place results in ANALYSIS sector of each record
c
	first_record = .true.
	FRAME_LAST_TIME = -1.
	if( mod(ir_s,2) .eq. 0 ) ir_s = ir_s - 1
	if( mod(ir_e,2) .eq. 1 ) ir_e = ir_e + 1
	do irecord = ir_s,ir_e,2
C
C	    Read FAST record from file
C
	    CALL GET_FRAME(IRECORD,IDATA_FILE_NO)
	    status = frame_status
	    dt_fast = record_dt

	    if( status .ne. 'REJECT' ) then
C
C --		Set analysis work area within record
c		Returns new values of I_START, I_END
c		through global common (see cmacom.FOR)
C
		if( (first_only.eq.'N') .or. first_record ) then
		    msg(1) =
     &		    ' Use (MARK AREA F7) to define analysis area limits'
		    msg(2) =
     &		    ' Use (RESTING POT. F8) to define abs. level'
		    irec = irecord
		    call display_records( ' DEFINE ANALYSIS AREA ',
     &		    idata_file_no,irec,msg,2)

		    msg(1) = ' WAIT ... Analysis in Progress'
		    msg(2) = ' Press ESC to Abort'
		    msg(3) = ' '
		    call display_message(2,2,34,msg,3)

		    first_record = .false.

		    CALL GET_FRAME(IRECORD,IDATA_FILE_NO)
		    status = frame_status
		    dt_fast = record_dt

		endif
c
c		Find peak of AP from fast frame
c
		CALL MAX_ARRAY(IBUFFER(I_STARTf),I_ENDf-I_STARTf+1
     &		,IPEAK_LEVEL,ipk_fast)
		ipk_fast = ipk_fast + i_startf - 1
c
c		Find resting potential from slow record
c
		ir = irecord + 1
		call get_frame( ir, idata_file_no)
		dt_slow = record_dt

c		Absolute value of record zero baseline area
c		starting at point <i_base> for <n_base> points
c
		call average_segment(ibuffer,i_base,i_base+n_base-1,
     &		avg,sum)
		zero_level = float(int(avg)-izero_current)*bit_current
		irest = int(avg)
		call add_array( -irest, ibuffer, n_points )

		ipeak_level = ipeak_level - irest
		PEAK = FLOAT(ipeak_level)*BIT_CURRENT
		level_10 = ipeak_level/10
		level_90 = ipeak_level - level_10
		level_50 = ipeak_level/2
c
C		Calculate time to 50% and 90% decay
c
		CALL MAX_ARRAY(IBUFFER(I_STARTs),I_ENDs-I_STARTs+1
     &		,IPEAK_slow,ipk_slow)
                ipk_slow = ipk_slow + i_starts - 1
                i = ipk_slow
		do while((ibuffer(i).ge.level_10).and.(i.le.n_points))
		    if( ibuffer(i) .gt. level_50 ) ip_50 = i
		    i = i + 1
		end do
		t_90 = float(i - ipk_slow)*dt_slow
		t_50 = float(ip_50 - ipk_slow)*dt_slow
C
C		Calculate steady state
C
		CALL AVERAGE_SEGMENT(IBUFFER,I_STARTs,I_ENDs,AVERAGE,SUM)
		AVERAGE = AVERAGE*BIT_CURRENT
		AREA = SUM*BIT_CURRENT*dt_slow
C
C		Save in analysis block # <irecord>
C
		CALL PUT_ANALYSIS_BLOCK(irecord,IDATA_FILE_NO)
c
c		Calculate rise time and rate of rise from fast record
c
		call get_frame( irecord, idata_file_no)
		call add_array( -irest, ibuffer, n_points )
C
		i = ipk_fast
		j = 0
		do while((ibuffer(i).ge.level_10).and.(i.ge.i_startf))
		    if( ibuffer(i) .le. level_90 ) j = j + 1
		    i = i - 1
		end do
		rise_time = float(j)*dt_fast
		ip_10 = i
C
C		Calculate max. rate-of-rise
c
		i = ipk_fast
		max_diff = 0
		do while( i.ge.ip_10 )
		    idiff = ibuffer(i) - ibuffer(i-1)
		    if( idiff .gt. max_diff ) max_diff = idiff
		    i = i - 1
		end do
		rate_of_rise = float(max_diff)*bit_current/dt_fast
C
C		Calculate time since last frame
C
		IF(FRAME_LAST_TIME.GE.0.) THEN
		    FRAME_INTERVAL = FRAME_TIME - FRAME_LAST_TIME
		ELSE
		    FRAME_INTERVAL = 0.
		ENDIF
		FRAME_LAST_TIME = FRAME_TIME
c
c		Save existing results to analysis block of record <irecord>
c
		record_dt = dt_fast
		call put_analysis_block( irecord, idata_file_no )
		record_dt = dt_slow
		call put_analysis_block( irecord+1, idata_file_no )

C
c		Display count of records done every 10th record
c
		if( mod(irecord,10) .eq. 0 ) then
		    write(msg(3),'('' Records done'',i5,''/'',i5)')
     &		    irecord,ir_e
		    call move_cursor(5,9)
		    call display_string(msg(3))
		endif
	    ENDIF
C
C	    Abort if user has pressed Esc
C
	    CALL get_KEY(KEY,SPECIAL)
	    IF(KEY.EQ.'$') GOTO 101

	end do
101	continue

	RETURN
	END

	subroutine set_axes_form(ix,iy,xmin,ymin,xmax,ymax
     &	,xlo,ylo,xhi,yhi,xtic,ytic)

	parameter(naxes_menu=6)
	parameter(bigneg=-1E30,bigpos=1E30)
	character*36 axes_menu(naxes_menu)
	character*12 list(naxes_menu)
	character*46 err

c
c	code
c
	WRITE(axes_menu(1)
     &	,'('' X axis range: minimum ('',G10.4,'')'')') XMIN
	WRITE(axes_menu(2)
     &	,'('' X axis range: maximum ('',G10.4,'')'')') XMAX
	axes_menu(3) = ' X axis tic spacing '
	WRITE(axes_menu(4)
     &	,'('' Y axis range: minimum ('',G10.4,'')'')') YMIN
	WRITE(axes_menu(5)
     &	,'('' Y axis range: maximum ('',G10.4,'')'')') YMAX
	axes_menu(6) = ' Y axis tic spacing '

	write(list(1),'(F12.3)') xlo
	write(list(2),'(F12.3)') xhi
	write(list(3),'(F12.3)') xtic
	write(list(4),'(F12.3)') ylo
	write(list(5),'(F12.3)') yhi
	write(list(6),'(F12.3)') ytic

	err = ' '
2100	if( err .eq. ' ' ) err = ' Set axes range '

	CALL text_window(axes_menu,list,naxes_menu,ix,iy,err)

	xlo  = check_limits(list,bigneg,bigpos,1,err)
	if( err .ne. ' ' ) goto 2100
	xhi  = check_limits(list,bigneg,bigpos,2,err)
	if( err .ne. ' ' ) goto 2100
	xtic = check_limits(list,bigneg,bigpos,3,err)
	if( err .ne. ' ' ) goto 2100
	ylo  = check_limits(list,bigneg,bigpos,4,err)
	if( err .ne. ' ' ) goto 2100
	yhi  = check_limits(list,bigneg,bigpos,5,err)
	if( err .ne. ' ' ) goto 2100
	ytic = check_limits(list,bigneg,bigpos,6,err)
	if( err .ne. ' ' ) goto 2100

	return
	end

	subroutine summary(ivar_map,var_name,nvars,ifile_no,ir_s,ir_e)
$include: 'cmacom.for'
c
c	Create summary report of analysis results and write
c	to file or printer.
c
	character*(*) var_name(nvars)
	integer*2 ivar_map(nvars)

	parameter(nmenu=2)
	character*42 menu(nmenu) /
     &	' Start at record ',
     &	' End at record ' /

	character*6 list(nmenu)
	character*42 title
	character*6 status

	character*62 string_out
	integer*2 istring_out(31)
	equivalence( string_out, istring_out )

	parameter(max_vars=20)
	real sumx(max_vars),sumx2(max_vars),avg(max_vars),se(max_vars)
	character*50 string(max_vars)
	equivalence( string, iwork(2001) )
	character key

c	code
c
c	Let user set range of records & type of peak analysis
c
	write(menu(1),'('' Start at record (1-'',I5,'')'')') n_frames
	write(list(1),'(i5)') min(max(1,ir_s),n_frames)
	if( ir_e .eq. 0 ) ir_e = n_frames
	write(list(2),'(i5)') min(max(ir_s,ir_e),n_frames)

	title = ' '
10     if( title .eq. ' ' ) title = ' Summary: Set range of records '
	call text_window(menu,list,nmenu,3,5,title)

	ir_s = int(check_limits(list,1.,float(n_frames),1,title))
	if( title .ne. ' ' ) goto 10
	ir_e = int(check_limits(list,float(ir_s),float(n_frames),2,title))
	if( title .ne. ' ' ) goto 10

	call display_message(5,7,30,' WAIT ... Creating summary ',1)

c
c	Summate analysis results of records
c	in range <ir_s> ... (ir_s>
c
	do ivar = 1,nvars
	    sumx(ivar) = 0.
	    sumx2(ivar) = 0.
	end do
	navg = 0
	if( mod(ir_s,2) .eq. 0 ) ir_s = ir_s - 1
	DO IRECORD = IR_S,IR_E,2
C
	    CALL GET_ANALYSIS_BLOCK(IRECORD,IFILE_NO)
C
	    status = frame_status

c	    If record meets criteria, add its analysis results
c	    to summation arrays
c
	    if( status .ne. 'REJECT' ) then
		do ivar = 3,nvars
		    x = analysis(ivar_map(ivar))
		    sumx(ivar) = sumx(ivar) + x
		    sumx2(ivar) = sumx2(ivar) + x*x
		end do
		navg = navg + 1
	    endif
	end do

c
c	Calculate average and s.e.
c
	rn = float( max(navg,1) )
	rn1 = float( max(navg-1,1) )
	do ivar = 3,nvars
	    avg(ivar) = sumx(ivar) / rn
	    if( rn .gt. 1. ) then
		se(ivar) = sqrt( abs(
     &		(sumx2(ivar) - sumx(ivar)*sumx(ivar)/rn )/(rn1*rn)))
	    else
		se(ivar) = 0.
	    end if
	end do

c
c	Create report text
c
	write(string(1),
     &	'(a,''Recs:'',i4,''-'',i4,'' ('',i4,'') '')')
     &	file_name(1:16),ir_s,ir_e,navg
	string(2) = id

	do ivar = 3,nvars
	    write( string(ivar),'(a,f12.2,'' +/- (s.e.)'',f10.4)')
     &	    var_name(ivar),avg(ivar),se(ivar)
	end do

c
c	Display report on screen
c
	call display_message(4,6,50,string,nvars)
c
c	Send report to printer
c
	call query_box(4,8+nvars,' Send to Printer (Y/N) ? ',key)
	if( key .eq. 'Y' ) call print_text( string, nvars )

	return
	end

	subroutine print_text( text, nlines )
	character*(*) text(nlines)
	parameter(ndc_max = 32767, lines_per_page = 62 )
	integer*2 ixy(2)

	CALL OPEN_WORKSTATION(IDEV,21)
	CALL LOAD_FONTS(IDEV)
	CALL SET_TEXT_FACE(IDEV,1)
	call set_point_size( idev, 10 )

	call get_text_attributes( idev, i,i,i,i,i,
     &	ichar_width,ichar_height)

	ixy(1) = 5*ichar_width
	itop = ndc_max - 5*ichar_height
	ixy(2) = itop
	line = 0
	do i = 1,nlines
	    call graphics_text( idev, ixy, text(i) )
	    ixy(2) = ixy(2) - ichar_height
	    line = line + 1
	    if( line .eq. lines_per_page ) then
		CALL UPDATE_WORKSTATION(Idev)
		CALL CLEAR_WORKSTATION(Idev)
		line = 1
		ixy(2) = itop
	    end if
	end do

	if( line .ne. 1 ) then
		CALL UPDATE_WORKSTATION(Idev)
		CALL CLEAR_WORKSTATION(Idev)
	end if

	CALL UNLOAD_FONTS(Idev)
	CALL CLOSE_WORKSTATION(Idev)

	return
	end

