	 SUBROUTINE PLOT_ANALYSIS(SCREEN_TITLE)
C
C	X/Y Plot and histogram of analysis results.
C	-------------------------------------------
C
$INCLUDE: 'CDRCOM.FOR'
C
	CHARACTER*(*) SCREEN_TITLE
	CHARACTER*60 TITLE(2)
	PARAMETER(NVARS=11)
	CHARACTER*18 VAR_NAME(NVARS)
	INTEGER IVAR_MAP(NVARS)
	CHARACTER*14 STRING14
	CHARACTER*18 XLABEL,YLABEL,HLABEL
	CHARACTER*2 PLOT
	CHARACTER KEY
	CHARACTER*40 STRING
	CHARACTER*46 MENU(7)
	PARAMETER(NROWS=5)
	CHARACTER*6 LIST(NROWS)
	LOGICAL SPECIAL,NEW_DATA,NEW_HISTOGRAM,AVERAGING_ON
	PARAMETER(NP_MAX=1000)
	INTEGER*2 NBINS /100/
	REAL XY(2000), BINS(200), RLIST(7)
	EQUIVALENCE (XY,IWORK(1))
C
	DATA IVAR_MAP /1,2,3,4,5,6,7,8,9,10,11/
C
C	CODE
C	----
C
	CALL MOVE_CURSOR( 2, LTOP )
	CALL ERASE_EOS
	CALL DISPLAY_STRING( SCREEN_TITLE )
	CALL NEW_LINE
	CALL NEW_LINE
	CALL DISPLAY_STRING('Set parameters. Press ESC to continue')
C
C	Define variable names and locations
C
	VAR_NAME(1) = 'Record No.'
	IVAR_MAP(1) = 1
	VAR_NAME(2) = 'Clock Time s'
	IVAR_MAP(2) = 2
	VAR_NAME(3) = 'Rise Time '//T_UNITS
	IVAR_MAP(3) = 3
	VAR_NAME(4) = 'Duration '//Y_UNITS
	IVAR_MAP(4) = 4
	VAR_NAME(5) = 'Peak '//Y_UNITS
	IVAR_MAP(5) = 5
	VAR_NAME(6) = 'Area '//Y_UNITS//T_UNITS
	IVAR_MAP(6) = 6
	VAR_NAME(7) = 'Zero level '//Y_UNITS
	IVAR_MAP(7) = 7
	VAR_NAME(8) = 'Interval s'
	IVAR_MAP(8) = 8
	VAR_NAME(9) = 'Amp(exp) '//Y_UNITS
	IVAR_MAP(9) = 9
	VAR_NAME(10) = 'Tau(exp) '//Y_UNITS
	IVAR_MAP(10) = 10
	VAR_NAME(11) = 'R(exp) '
	IVAR_MAP(11) = 11
	IX_VAR = 1
	IY_VAR = 5

C	Let user set up plotting parameters
C
	MENU(1) = ' Start at event '
	MENU(2) = ' End at event '
	MENU(3) = ' At intervals of '
	MENU(4) = ' Use averaging (Y/N) '
	MENU(5) = ' Type: '//TYPE_LIST(1)//' '//TYPE_LIST(2)//
     &	TYPE_LIST(3)//' '//TYPE_LIST(4)//' '//TYPE_LIST(5)//' ALL'

	IEVENT_0 = 1
	WRITE(LIST(1),900) IEVENT_0
900	FORMAT(I4)
	IEVENT_1 = N_EVENTS
	WRITE(LIST(2),900) IEVENT_1
	WRITE(LIST(3),900) (IEVENT_1 - IEVENT_0)/NP_MAX + 1
	LIST(4) = 'N'
	LIST(5) = TYPE_LIST(2)
C
	CALL TEXT_WINDOW(MENU,LIST,NROWS,2,LTOP+4
     &,' Parameter list ')
C
	I = 1
	READ(LIST(I),901) RN
901	FORMAT(F6.0)
	IEVENT_0 = IFIX(RN)
	IEVENT_0 = MAX0(MIN0(N_EVENTS,IEVENT_0),1)
C
	I = I + 1
	READ(LIST(I),901) RN
	IEVENT_1 = IFIX(RN)
	IEVENT_1 = MAX0(MIN0(IEVENT_1,N_EVENTS),IEVENT_0)
C
	I = I + 1
	READ(LIST(I),901) RN
	IEVENT_INC = IFIX(RN)
	IEVENT_INC = MAX0(MIN0(IEVENT_INC,N_EVENTS),1)
C
C	Ensure that no more than NP_MAX points are plotted
C
	IF( (IEVENT_1 - IEVENT_0 + 1)/IEVENT_INC .GT. NP_MAX ) THEN
	    IEVENT_1 = IEVENT_0 + (NP_MAX-1)*IEVENT_INC
	ENDIF

	I = I + 1
	CALL UPPER_CASE(LIST(I))
	IF(LIST(I).EQ.'Y') THEN
	    AVERAGING_ON = .TRUE.
	ELSE
	    AVERAGING_ON = .FALSE.
	ENDIF

	I = I + 1
	CALL UPPER_CASE(LIST(I))
	IREQUIRED_TYPE = 0
	DO 10 J = 1,5
		IF( LIST(I) .EQ. TYPE_LIST(J) ) THEN
			IREQUIRED_TYPE = J
		ENDIF
10	CONTINUE
C
C
	TITLE(1) = 'File .. '//FILE_NAME
	TITLE(2) = CELL
C
C	Define the default graph
C
	MEASURE = 'REL'
	NEW_DATA = .TRUE.
	PLOT = 'XY'
C
100	CONTINUE
C
	IF( NEW_DATA ) THEN
		CALL CREATE_GRAPH(IVAR_MAP(IX_VAR),IVAR_MAP(IY_VAR)
     &		,IREQUIRED_TYPE,IEVENT_0,IEVENT_1,IEVENT_INC
     &		,AVERAGING_ON
     &		,XY,NP,XMIN,YMIN,XMAX,YMAX)
		XLO = XMIN
		YLO = YMIN
		XHI = XMAX
		YHI = YMAX
		XTIC = (XHI-XLO)/5.
		YTIC = (YHI-YLO)/5.
		NEW_DATA = .FALSE.
	ENDIF
C
	IF( NEW_HISTOGRAM ) THEN
		CALL CREATE_HISTOGRAM(IVAR_MAP(IX_VAR),IREQUIRED_TYPE
     &		,IEVENT_0,IEVENT_1
     &		,BINS,NBINS,XLO,XHI,YMAX,HLABEL)
		YHI = YMAX
		YLO = 0.
		YMIN = 0.
		YTIC = (YHI-YLO)/5.
		NEW_HISTOGRAM = .FALSE.
	ENDIF
C
	XLABEL = VAR_NAME(IX_VAR)
	IF( PLOT .EQ. 'XY' ) THEN
		YLABEL = VAR_NAME(IY_VAR)
	ELSE
		YLABEL = HLABEL
	ENDIF
C
C -- Display list of analysis variables
C
	CALL ERASE_ALL
	CALL MOVE_CURSOR(2,1)
	CALL DISPLAY_STRING(SCREEN_TITLE)
	CALL DISPLAY_BOX(57,2,79,13)
	CALL MOVE_CURSOR(58,2)
	CALL DISPLAY_STRING(' Options ')
	CALL SET_MARGINS(58,2,79,25)
	CALL NEW_LINE
	CALL DISPLAY_STRING('F1 SET X VAR.')
	CALL NEW_LINE
	CALL DISPLAY_STRING('F2 SET Y VAR.')
	CALL NEW_LINE
	CALL DISPLAY_STRING('F3 SET HISTOGRAM')
	CALL NEW_LINE
	CALL DISPLAY_STRING('F4 SET AXES ')
	CALL NEW_LINE
	CALL DISPLAY_STRING('F5 PLOT SCREEN')
	CALL NEW_LINE
	CALL DISPLAY_STRING('F6 LIST X,Y DATA')
	CALL NEW_LINE
	CALL DISPLAY_STRING('Esc Exit')
C
C	Display current selection of channels & variables
C
	CALL DISPLAY_BOX(57,19,79,25)
	CALL MOVE_CURSOR(58,19)
	IF( IREQUIRED_TYPE .NE. 0 ) THEN
	     CALL DISPLAY_STRING(' Plot Selected '
     &	     //TYPE_LIST(IREQUIRED_TYPE))
	ELSE
	     CALL DISPLAY_STRING(' Plot Selected ALL')
	ENDIF
	CALL NEW_LINE
	WRITE(STRING,902) IEVENT_0,IEVENT_1
902	FORMAT('Events ',I5,'-',I5)
	CALL DISPLAY_STRING(STRING)
	CALL NEW_LINE
	CALL DISPLAY_STRING(TITLE(1)(1:21))
	CALL NEW_LINE
	CALL DISPLAY_STRING(TITLE(2)(1:21))
	CALL NEW_LINE
	IF(PLOT.EQ.'XY') THEN
		CALL DISPLAY_STRING('X: '//XLABEL)
		CALL NEW_LINE
	ELSE
		CALL DISPLAY_STRING('H: '//XLABEL)
		CALL NEW_LINE
	ENDIF
	CALL DISPLAY_STRING('Y: '//YLABEL)
	CALL SET_MARGINS(2,1,80,25)
C
C	Plot graph on screen
C
	IF(PLOT .EQ. 'XY') THEN
		CALL PLOT_XY('S',XY,NP,XLO,YLO,XHI,YHI
     &		,XTIC,YTIC,XLABEL,YLABEL,TITLE,2)
	ELSE
		CALL PLOT_HISTOGRAM('S',BINS,NBINS,XLO,YLO,XHI,YHI
     &		,XTIC,YTIC,XLABEL,HLABEL,TITLE,2)
	ENDIF
C
	CALL WAIT_FOR_KEY(KEY,SPECIAL)
	IOP = IFIND_CHAR('12345678$',KEY)
	GOTO(1,2,3,4,5,6,7,8,9) IOP
C
C -- Set X axis variable
C
1	I = 1
	I = IMENU_VERTICAL(VAR_NAME,'123456789',NVARS,5,5,I
     &,' X Variable ')
	IF(I.GT.0) THEN
		IX_VAR = I
		PLOT = 'XY'
		NEW_DATA = .TRUE.
	ENDIF
	GOTO 100
C
C -- Set Y axis variable
C
2	I = 1
	I = IMENU_VERTICAL(VAR_NAME,'123456789',NVARS,5,5,I
     &,' Y Variable ')
	IF(I.GT.0) THEN
		IY_VAR = I
		PLOT = 'XY'
		NEW_DATA = .TRUE.
	ENDIF
	GOTO 100
C
C -- Create histogram of a single variable
C
3	I = 1
	I = IMENU_VERTICAL(VAR_NAME,'123456789',NVARS,5,5,I
     &,' Histogram ')
	IF(I.GT.0) THEN
C
C		CREATE_HISTOGRAM requires valid values for XLO and XHI
C		which are supplied by CREATE_GRAPH. This statement
C		ensures that CREATE_GRAPH is called before CREATE_HISTOGRAM
C		for the selected variable I returned by IMENU_VERTICAL,
C		if it is NOT the currently displayed variable
C
		IF( I .NE. IX_VAR ) NEW_DATA = .TRUE.

		IX_VAR = I
		PLOT = 'HI'
		NEW_HISTOGRAM = .TRUE.
	ENDIF
	GOTO 100
C
C -- Set plot axes range at tic spacing
C
4	WRITE(MENU(1),910) XMIN
910	FORMAT(' X axis range: minimum (',G10.4,')')
	WRITE(MENU(2),911) XMAX
911	FORMAT(' X axis range: maximum (',G10.4,')')
	MENU(3) = ' X axis tic spacing '
	WRITE(MENU(4),912) YMIN
912	FORMAT(' Y axis range: minimum (',G10.4,')')
	WRITE(MENU(5),913) YMAX
913	FORMAT(' Y axis range: maximum (',G10.4,')')
	MENU(6) = ' Y axis tic spacing '
	MENU(7) = ' No. bins in histogram (<=100)'
C
	RLIST(1) = XLO
	RLIST(2) = XHI
	RLIST(3) = XTIC
	RLIST(4) = YLO
	RLIST(5) = YHI
	RLIST(6) = YTIC
	RLIST(7) = FLOAT(NBINS)
C
	CALL SET_MARGINS(1,1,80,25)
	CALL NUMBERS_WINDOW(MENU,RLIST,1,7,3,5,' Set axes range ')
C
	XLO = RLIST(1)
	XHI = RLIST(2)
	XTIC = RLIST(3)
	YLO = RLIST(4)
	YHI = RLIST(5)
	YTIC = RLIST(6)
	NBINS = IFIX(RLIST(7))
	IF(PLOT.EQ.'HI') NEW_HISTOGRAM = .TRUE.
	GOTO 100
C
C -- Plot graph
C
5	CALL ERASE_BOX(5,5,60,10)
	CALL DISPLAY_BOX(5,5,60,10)
	CALL MOVE_CURSOR(6,6)
	CALL ASK_USER(
     &' Plot on dot matrix printer (D), plotter (P) ? ',KEY)
	CALL MOVE_CURSOR(6,7)
	CALL DISPLAY_STRING(' WAIT ... Plotting in progress ')
	IF((KEY.NE.'D').AND.(KEY.NE.'P')) GOTO 100
	IF(PLOT .EQ. 'XY') THEN
		CALL PLOT_XY(KEY,XY,NP,XLO,YLO,XHI,YHI
     &		,XTIC,YTIC,XLABEL,YLABEL,TITLE,2)
	ELSE
		CALL PLOT_HISTOGRAM(KEY,BINS,NBINS,XLO,YLO,XHI,YHI
     &		,XTIC,YTIC,XLABEL,HLABEL,TITLE,2)
	ENDIF
	GOTO 100
C
C -- Display table of current graph values
C
6	IF( PLOT .EQ. 'XY' ) THEN
		CALL LIST_TABLE(XY,2,NP,15,3,4,XLABEL(1:12)//YLABEL(1:12))
	ELSE
		CALL LIST_TABLE(BINS,2,NBINS,15,3,4
     &	,XLABEL(1:12)//HLABEL(1:12))
	ENDIF
	GOTO 100
C
7	GOTO 100
C
8	GOTO 100
C
9	CALL EXIT_QUERY(5,5,KEY)
	IF(KEY.EQ.'$') RETURN
	GOTO 100
	END


	SUBROUTINE CREATE_GRAPH(IX_VAR,IY_VAR,IREQUIRED_TYPE
     &	,IEVENT_0,IEVENT_1,IEVENT_INC,AVERAGING_ON
     &	,XY,NP,XMIN,YMIN,XMAX,YMAX)
$INCLUDE: 'CDRCOM.FOR'
C
C	Read analysis variables IX_VAR and IY_VAR
C	from event analysis records (on file CDR.EVE) and create
C	an XY plot in array XY.
C
C	IX_VAR = X axis variable index into array ANALYSIS
C	IY_VAR = Y axis variable
C	IREQUIRED_TYPE = Event classification type selected
C	IEVENT_0 = First event to be used
C	IEVENT_1 = Last event to be used
C	IEVENT_INC = increment between plotted events
C	AVERAGING_ON = If .TRUE. average every IEVENT_INC records
C	XY = array returned containing X,Y plot
C	NP = Returns No. of XY pairs in XY (max. 1000)
C	XMIN,YMIN,XMAX,YMAX = Returns X/Y axes data range
C
	REAL XY(1)
	LOGICAL AVERAGING_ON
C
C	CODE
C	----
C
	J = 0
	XMIN = 1E30
	YMIN = 1E30
	XMAX = -1E30
	YMAX = -1E30

C	Don't use averaging if inter-point step is 1
C
	IF(IEVENT_INC .EQ. 1) AVERAGING_ON = .FALSE.


	DO 100 IEVENT = IEVENT_0,IEVENT_1-IEVENT_INC+1,IEVENT_INC
C
	    IF( AVERAGING_ON ) THEN
C
C		Average from IEVENT to IEVENT + IEVENT_INC - 1

		X = 0.
		Y = 0.
		NAVG = 0
		DO 110 II = IEVENT,IEVENT+IEVENT_INC-1

		    CALL GET_EVENT_ANALYSIS(II)

C		    If IREQUIRED_TYPE is 1..5 then include
C		    event only if it matches. If IREQUIRED_TYPE=0
C		    include ALL types EXCEPT REJECTED
C
		    IF( (IEVENT_TYPE .EQ. IREQUIRED_TYPE) .OR.
     &		    ((IREQUIRED_TYPE.EQ.0) .AND. (IEVENT_TYPE.NE.1))
     &			) THEN
			X = X + ANALYSIS(IX_VAR)
			Y = Y + ANALYSIS(IY_VAR)
			NAVG = NAVG + 1
		    ENDIF
110		CONTINUE

C		Put average into XY plotting array
C		and update min./max. values

		J = J + 1
		X = X / FLOAT(NAVG)
		XY(J) = X
		IF(X.LT.XMIN) XMIN = X
		IF(X.GT.XMAX) XMAX = X

		J = J + 1
		Y = Y / FLOAT(NAVG)
		XY(J) = Y
		IF(Y.LT.YMIN) YMIN = Y
		IF(Y.GT.YMAX) YMAX = Y

	    ELSE
C
C		No averaging
C
		CALL GET_EVENT_ANALYSIS( IEVENT )
C

C		If IREQUIRED_TYPE is 1..5 then include
C		event only if it matches. If IREQUIRED_TYPE=0
C		include ALL types EXCEPT REJECTED
C
		IF( (IEVENT_TYPE .EQ. IREQUIRED_TYPE) .OR.
     &		((IREQUIRED_TYPE.EQ.0) .AND. (IEVENT_TYPE.NE.1))
     &		) THEN
		    J = J + 1
		    X = ANALYSIS(IX_VAR)
		    XY(J) = X
		    IF(X.LT.XMIN) XMIN = X
		    IF(X.GT.XMAX) XMAX = X

		    J = J + 1
		    Y = ANALYSIS(IY_VAR)
		    XY(J) = Y
		    IF(Y.LT.YMIN) YMIN = Y
		    IF(Y.GT.YMAX) YMAX = Y
		ENDIF
	    ENDIF

100	CONTINUE
	NP = J/2
	RETURN
	END


	SUBROUTINE CREATE_HISTOGRAM(IX_VAR
     &	,IREQUIRED_TYPE,IEVENT_0,IEVENT_1
     &	,BINS,NBINS,XLO,XHI,YMAX,YLABEL)

$INCLUDE: 'CDRCOM.FOR'
C
C
C	Creates a histogram of variable # IV_VAR in ANALYSIS
C	array from event record of type IREQUIRED_TYPE, starting
C	at event IEVENT_0 till IEVENT_1. Histogram is returned
C	as X,Y graph in array BINS. Histogram range is supplied
C	by XLO,XHI with NBINS = no. of bins. Max. bin value is
C	returned in YMAX. YLABEL is returned with % if percentage
C	histogram has been produced
C	------------------------------------------------
C
	REAL BINS_WORK(100),BINS(1)
	CHARACTER*(*) YLABEL
	CHARACTER PERCENT
C
C	CODE
C
	CALL ERASE_BOX(4,4,56,10)
	CALL DISPLAY_BOX(5,5,55,9)
	CALL SET_MARGINS(6,6,55,10)
	CALL MOVE_CURSOR(6,5)
	CALL DISPLAY_STRING(' F3 Histogram ')
	CALL NEW_LINE
	CALL ASK_USER('Convert Bin count to % (Y/N) ? ',PERCENT)
	CALL DISPLAY_STRING(' WAIT ... Compiling histogram ')
C
	DX = (XHI - XLO)/FLOAT(NBINS)
C
C -- Clear bin count accumulators
C
	DO 5 I=1,NBINS
		BINS_WORK(I) = 0.
5	CONTINUE
C
C -- Generate bins
C
	COUNT = 0.
	DO 100 IEVENT = IEVENT_0,IEVENT_1
C
		CALL GET_EVENT_ANALYSIS(IEVENT)
C
C		    If IREQUIRED_TYPE is 1..5 then include
C		    event only if it matches. If IREQUIRED_TYPE=0
C		    include ALL types EXCEPT REJECTED
C
		    IF( (IEVENT_TYPE .EQ. IREQUIRED_TYPE) .OR.
     &		    ((IREQUIRED_TYPE.EQ.0) .AND. (IEVENT_TYPE.NE.1))
     &			) THEN
			J = IFIX((ANALYSIS(IX_VAR)-XLO)/DX) + 1
			J = MAX0(MIN0(J,NBINS),1)
			BINS_WORK(J) = BINS_WORK(J) + 1.
			COUNT = COUNT + 1.
		ENDIF
100	CONTINUE

C
C -- Convert histogram to %
C
	YLABEL = ' '
	IF(PERCENT.EQ.'Y') THEN
		YLABEL = '%'
		PERCENTAGE = 100./COUNT
		DO 20 I = 1,NBINS
			BINS_WORK(I) = BINS_WORK(I)*PERCENTAGE
20		CONTINUE
	ENDIF
C
C -- Copy histogram to BINS array for export
C
	X = DX/2. + XLO
	J = 0
	DO 30 I=1,NBINS
		J = J + 1
		BINS(J) = X
		J = J + 1
		BINS(J) = BINS_WORK(I)
		X = X + DX
30	CONTINUE
C
C -- Find Y axis range
C
	CALL FIND_MINMAX(BINS_WORK,NBINS,YMIN,YMAX)
	RETURN
	END


	SUBROUTINE PLOT_XY(PLOT_DEVICE,XY,NP,XLO,YLO,XHI,YHI,XTIC,YTIC
     &,XLABEL,YLABEL,TITLE,NLINES)
C
C	--------------------------------------------------
C	Plot graph on screen or hard copy device
C	PLOT_DEVICE = 'P' For plotter 'D' for dot matrix 'S' for screen
C	XY = Array of coordinates, NP = No. coords. in XY
C	XLO,YLO,XHI,YHI = X & Y axes plotting range
C	XLABEL,YLABEL = X & Y axis labels
C	TITLE = plot title lines
C	NLINES = No. of lines in TITLE
C	--------------------------------------------------
C
	REAL XY(1)
	CHARACTER*(*) XLABEL,YLABEL
	CHARACTER*(*) TITLE(1)
	CHARACTER KEY,PLOT_DEVICE
	LOGICAL SPECIAL
	INTEGER IXY(2)
	PARAMETER (NDC_MAX=32767)
C
C	CODE
C
	IF(XLO.EQ.XHI) THEN
		XLO = XLO - 1.
		XHI = XHI + 1.
		XTIC = (XHI - XLO)/5.
	ENDIF
	IF(YLO.EQ.YHI) THEN
		YLO = YLO - 1.
		YHI = YHI + 1.
		YTIC = (YHI - YLO)/5.
	ENDIF
C
	CALL GET_SCREEN_DEVICE(ISCREEN)
C
	IF(PLOT_DEVICE.EQ.'P') THEN
		CALL OPEN_WORKSTATION(IPLOT_DEV,11)
		ICHAR_HEIGHT = NDC_MAX/60
		CALL SET_SIZE(8000,8000,24000,20000)
	ELSEIF(PLOT_DEVICE.EQ.'D') THEN
		CALL OPEN_WORKSTATION(IPLOT_DEV,21)
		CALL LOAD_FONTS(IPLOT_DEV)
		CALL SET_TEXT_FACE(IPLOT_DEV,1)
		ICHAR_HEIGHT = NDC_MAX/60
		CALL SET_SIZE(8000,8000,24000,20000)
	ELSE
		IPLOT_DEV = ISCREEN
		ICHAR_HEIGHT = 1000
		CALL SET_SIZE(8000,8000,20000,24000)
	ENDIF
C
	CALL SET_CHARACTER_HEIGHT(IPLOT_DEV,ICHAR_HEIGHT)
	CALL GET_CHARACTER_SIZE(ICHAR_WIDTH,ICHAR_HEIGHT)
C
	CALL DRAW_AXES_MANUAL(IPLOT_DEV,XLO,YLO,XHI,YHI
     &,XLABEL,YLABEL,'N','N','N',XTIC,YTIC)
	CALL SET_POLYMARKER_TYPE(IPLOT_DEV,2)
	CALL SET_POLYMARKER_HEIGHT(IPLOT_DEV,ICHAR_HEIGHT/4)
	CALL DRAW_MARKER(IPLOT_DEV,XY,NP)
C
C	Draw title
C
	IF(IPLOT_DEV.NE.ISCREEN) THEN
		IXY(1) = 5*ICHAR_WIDTH
		IXY(2) = NDC_MAX - ICHAR_HEIGHT
		DO 10 I=1,NLINES
			IXY(2) = IXY(2) - ICHAR_HEIGHT
			CALL GRAPHICS_TEXT(IPLOT_DEV,IXY,TITLE(I))
10		CONTINUE
	ENDIF
C
20	IF(IPLOT_DEV .NE. ISCREEN) THEN
		CALL UPDATE_WORKSTATION(IPLOT_DEV)
		CALL CLEAR_WORKSTATION(IPLOT_DEV)
		CALL UNLOAD_FONTS(IPLOT_DEV)
		CALL CLOSE_WORKSTATION(IPLOT_DEV)
	ENDIF
	RETURN
	END


	SUBROUTINE PLOT_HISTOGRAM(PLOT_DEVICE,BINS,NBINS,XLO,YLO,XHI,YHI
     &,XTIC,YTIC,XLABEL,YLABEL,TITLE,NLINES)
C
C	--------------------------------------------------
C	Plot graph on screen or hard copy device
C	PLOT_DEVICE = 'P' For plotter 'D' for dot matrix 'S' for screen
C	BINS = Histogram bin contents NBINS = No. of elements in BINS
C	XY = Array of coordinates, NP = No. coords. in XY
C	XLO,YLO,XHI,YHI = X & Y axes plotting range
C	XLABEL,YLABEL = X & Y axis labels
C	TITLE = plot title lines
C	NLINES = No. of lines in TITLE
C	--------------------------------------------------
C
	REAL BINS(1),XY(8)
	CHARACTER*(*) XLABEL,YLABEL,TITLE(1)
	CHARACTER KEY,PLOT_DEVICE
	LOGICAL SPECIAL
	INTEGER IXY(2)
	PARAMETER (NDC_MAX=32767)
C
C	CODE
C
	IF(XLO.EQ.XHI) THEN
		XLO = XLO - 1.
		XHI = XHI + 1.
		XTIC = (XHI - XLO)/5.
	ENDIF
	IF(YLO.EQ.YHI) THEN
		YLO = YLO - 1.
		YHI = YHI + 1.
		YTIC = (YHI - YLO)/5.
	ENDIF
C
	CALL GET_SCREEN_DEVICE(ISCREEN)
C
	CALL NEW_LINE
	IF(PLOT_DEVICE.EQ.'P') THEN
		CALL OPEN_WORKSTATION(IPLOT_DEV,11)
		ICHAR_HEIGHT = NDC_MAX/60
		CALL SET_SIZE(8000,8000,24000,20000)
	ELSEIF(PLOT_DEVICE.EQ.'D') THEN
		CALL OPEN_WORKSTATION(IPLOT_DEV,21)
		CALL LOAD_FONTS(IPLOT_DEV)
		CALL SET_TEXT_FACE(IPLOT_DEV,1)
		ICHAR_HEIGHT = NDC_MAX/60
		CALL SET_SIZE(8000,8000,24000,20000)
	ELSE
		IPLOT_DEV = ISCREEN
		ICHAR_HEIGHT = 1000
		CALL SET_SIZE(8000,8000,20000,24000)
	ENDIF
C
	CALL SET_CHARACTER_HEIGHT(IPLOT_DEV,ICHAR_HEIGHT)
	CALL GET_CHARACTER_SIZE(ICHAR_WIDTH,ICHAR_HEIGHT)
C
	WIDTH = BINS(3) - BINS(1)
	HALF_WIDTH = WIDTH/2.
	CALL DRAW_AXES_MANUAL(IPLOT_DEV
     &	,XLO,YLO,XHI,YHI,XLABEL,YLABEL,'N','N','N',XTIC,YTIC)
C
	J = 0
	DO 10 I=1,NBINS
		J = J + 1
		XY(1) = BINS(J) - HALF_WIDTH
		XY(2) = 0.
		XY(3) = XY(1)
		J = J + 1
		XY(4) = BINS(J)
		XY(5) = XY(1) + WIDTH
		XY(6) = XY(4)
		XY(7) = XY(5)
		XY(8) = 0.
		CALL DRAW_LINE(IPLOT_DEV,XY,4)
10	CONTINUE
C
C	Draw title
C
	IF(IPLOT_DEV .NE. ISCREEN) THEN
		IXY(1) = 5*ICHAR_WIDTH
		IXY(2) = NDC_MAX - ICHAR_HEIGHT
		DO 15 I=1,NLINES
			IXY(2) = IXY(2) - ICHAR_HEIGHT
			CALL GRAPHICS_TEXT(IPLOT_DEV,IXY,TITLE(I))
15		CONTINUE
	ENDIF
C
20	IF(IPLOT_DEV .NE. ISCREEN) THEN
		CALL UPDATE_WORKSTATION(IPLOT_DEV)
		CALL CLEAR_WORKSTATION(IPLOT_DEV)
		CALL UNLOAD_FONTS(IPLOT_DEV)
		CALL CLOSE_WORKSTATION(IPLOT_DEV)
	ENDIF
	RETURN
	END

