	SUBROUTINE EXPORT_TO_SCAN_FILE
$INCLUDE: 'CDRCOM.FOR'
C
C	Export a series of event record to .SCA format file
C	for use by the SCAN program.
C	--------------------------------------------------
c       9/10/97 V5 pCLAMP import now accounts for A/D resolution

C	.SCA file frame analysis block definition
C
	CHARACTER*8 FRAME_STATUS
	CHARACTER*4 FRAME_TYPE
	INTEGER*2 IANALYSIS(256)
C
	COMMON /ANALYSIS_BLOCK/ IANALYSIS
C
	EQUIVALENCE (FRAME_STATUS,IANALYSIS(1))
     &		,(FRAME_TYPE,IANALYSIS(5))
     &		,(RECORD_NO,IANALYSIS(8))
     &		,(FRAME_TIME,IANALYSIS(10))
C

	CHARACTER*(512) HEADER
	EQUIVALENCE (IBUFFER,HEADER)
	character*12 new_file_name / ' ' /
	CHARACTER*50 export_file / ' ' /
	CHARACTER KEY
	LOGICAL ABORT,SPECIAL

	PARAMETER(NROWS=5)
	CHARACTER*44 MENU(NROWS)
	CHARACTER*6 LIST(NROWS)
	character*40 msg(2)
	character*44 title

	parameter(max_files=500)
	character*12 files(max_files)
	equivalence( files, iwork )
	integer*2 npre_trigger / 64 /
	integer*4 ifree4,ineeded4
C
C	CODE
C
	call set_margins(1,1,80,25)
C
C	Display directory of existing .CDR files
C
c	 call move_cursor(3,5)
c	 call display_string(' .SCA data files (RETURN to continue)')
c	 call files_menu('*.SCA',0,New_file_name,2,2,10,files,max_files)

	new_file_name = file_name
	call create_path(export_file,default_path,new_file_name,'.sca')

	call file_box(2,2,export_file,'.SCA','NEW'
     &	,' Name of export file ',abort)
	IF( ABORT ) RETURN
C
C
	CALL CREATE_FILE(IOUT_FILE,IERR,export_file)
	IF( IERR .NE. 0 ) THEN
	  ERROR = 'Can''t open file output file'
	  RETURN
	ENDIF

C	Get start/end/step size/type of series of event
C
	i = 1
	menu(i) = 'Start at event (1)'
	if( iev_sta .eq. 0 ) iev_sta = 1
	write(list(i),'(i5)') iev_sta
	i = i + 1
	write(menu(i),'(''End at event ('',i5'')'')') n_events
	if( iev_end .eq. 0 ) iev_end = n_events
	write(list(i),'(i5)') iev_end
	i = i + 1
	menu(i) = 'In steps of'
	write(list(i),'(i5)') max(iev_skip,1)
	i = i + 1
	menu(i) = 'No. of pre-event samples'
	write(list(i),'(i5)') max(npre_trigger,1)
	i = i + 1
	menu(i) = 'Type '//
     &TYPE_LIST(1)//' '//TYPE_LIST(2)//' '//
     &TYPE_LIST(3)//' '//TYPE_LIST(4)//' '//TYPE_LIST(5)//' ALL'

	if( irequired_type .eq. 0 ) then
	    list(i) = 'ALL'
	else
	    list(i) = type_list(irequired_type)
	endif

	title = ' '
5	if( title .eq. ' ' )
     &	title = ' Set range of events to be exported '
	CALL TEXT_WINDOW(MENU,LIST,NROWS,2,6,title)
C
	I = 1
	iev_sta = int(check_limits(list,1.,float(n_events),i,title))
	if( title .ne. ' ' ) goto 5

	I = i + 1
	iev_end = int(check_limits(list,float(iev_sta),float(n_events),
     &	 i,title))
	if( title .ne. ' ' ) goto 5

	I = i + 1
	iev_skip = int(check_limits(list,float(1.),float(n_events),
     &	 i,title))
	if( title .ne. ' ' ) goto 5

	I = i + 1
	npre_trigger = int(check_limits(list,1.,128.,i,title))
	if( title .ne. ' ' ) goto 5

	I = I + 1
	CALL UPPER_CASE(LIST(I))
	IREQUIRED_TYPE = 0
	DO 10 J = 1,MAX_TYPES
	    IF( LIST(I) .EQ. TYPE_LIST(J) ) THEN
		IREQUIRED_TYPE = J
	    ENDIF
10	CONTINUE
c
c	Abort if not enough disc space
c
	ifree4 = int4( free_disc_space() )
	ineeded4 = ( (iev_end - iev_sta)/iev_skip )*
     &	( (np_record/np_sector) + 1 )/2
c	 if( ifree4 .lt. ineeded4 ) then
c	     error = 'ERROR! Not enough space for .SCA file'
c	     return
c	 endif


C	Read series of events from iev_sta to iev_end
C	in steps of iev_skip into IBUFFER and transfer
C	on to .SCA file if of the required type

	IBLOCK = 2
	N_FRAMES = 0
	msg(1) = 'WAIT ... Writing to file '
	msg(2) = ' '
	call display_message(6,8,30,msg,2)
	ixc = 7
	iyc = 10
	DO 100 IEVENT = iev_sta,iev_end,iev_skip
C
C		Check for Esc key
C
		CALL GET_KEY(KEY,SPECIAL)
		IF(KEY.EQ.'$') goto 200
C
C		Read in data for event
C
		CALL GET_EVENT( IEVENT, IRECORD )
		IEVENT_OFFSET = IEVENT_START+(IEVENT_RECORD-IRECORD)
     &		*NP_RECORD
		ILO_LIMIT = MAX0(IEVENT_OFFSET - NPRE_TRIGGER,1)
		IHI_LIMIT = ILO_LIMIT + NP_RECORD
C
C
C		Copy event to .SCA file if it the required type
C		or all events (except REJECTED) if IREQUIRED_TYPE=0
C
		IF( (IEVENT_TYPE .EQ. IREQUIRED_TYPE) .OR.
     &		((IREQUIRED_TYPE.EQ.0).AND.(IEVENT_TYPE.NE.1))) THEN


		   CALL MOVE_CURSOR(ixc,iyc)
		   WRITE(msg(2),'(''Events '',I5,''/'',I5)')
     &		   IEVENT,iev_end
		   CALL DISPLAY_STRING(msg(2)(1:22))

C		    Write .SCA analysis block to file

		   N_FRAMES = N_FRAMES + 1
		   RECORD_NO = FLOAT(N_FRAMES)
		   FRAME_STATUS = 'ACCEPTED'
		   FRAME_TIME = TIME_EVENT
		   CALL WRITE_FILE(IOUT_FILE,IERR,IANALYSIS,IBLOCK,1)
		   IBLOCK = IBLOCK + 1
C
C		    Write data points to file
C
		   CALL WRITE_FILE(IOUT_FILE,IERR,IBUFFER(ILO_LIMIT)
     &		    ,IBLOCK,2)
		   IBLOCK = IBLOCK + 2
		ENDIF

100	CONTINUE
200	CONTINUE

C
C	Save .SCA file header block
C

	HEADER = ' '
C
	CALL ADD_ENTRY(DT,'DT=',HEADER)
	CALL ADD_ENTRY(BIT_CURRENT,'BC=',HEADER)
	CALL ADD_ENTRY(GAIN_CURRENT,'GC=',HEADER)
	CALL ADD_ENTRY(CAL_CURRENT,'CC=',HEADER)
	CALL ADD_ENTRY(FLOAT(ICAL_CURRENT),'ICC=',HEADER)
	CALL ADD_ENTRY(RANGE_VOLTS,'AD=',HEADER)
C
	CALL ADD_STRING('TU=',HEADER)
	CALL ADD_STRING(T_UNITS,HEADER)
	CALL ADD_STRING('\',HEADER)
C
	CALL ADD_STRING('CU=',HEADER)
	CALL ADD_STRING(Y_UNITS,HEADER)
	CALL ADD_STRING('\',HEADER)
C
	CALL ADD_ENTRY(1.,'NC=',HEADER)
	CALL ADD_ENTRY(FLOAT(N_FRAMES),'NRQ=',HEADER)
	CALL ADD_ENTRY(FLOAT(N_FRAMES),'NF=',HEADER)
	CALL ADD_ENTRY(1.,'NBA=',HEADER)
	CALL ADD_ENTRY(2.,'NBD=',HEADER)
	CALL ADD_ENTRY(FLOAT(INTERFACE_CARD),'IFC=',HEADER)
C
	CALL ADD_STRING('ID=',HEADER)
	CALL ADD_STRING(CELL,HEADER)
	CALL ADD_STRING('\',HEADER)
C
	CALL WRITE_FILE(IOUT_FILE,IERR,IBUFFER,1,1)
C
	CALL CLOSE_FILE(IOUT_FILE,IERR)
	RETURN
	END

	SUBROUTINE ADD_ENTRY(RN,KEY,HEADER)
C
C	CONVERT RN TO A STRING AND ADD KEY=RN\ TO HEADER STRING
C
	REAL RN
	CHARACTER*(*) KEY
	CHARACTER*(*) HEADER
	CHARACTER*(16) TEXT
C
	CALL ADD_STRING(KEY,HEADER)
	WRITE(TEXT,900) RN
900	FORMAT(1PG13.4,'\')
	CALL ADD_STRING(TEXT,HEADER)
	RETURN
	END

	SUBROUTINE import_from_scan_file
$INCLUDE: 'CDRCOM.FOR'
C
c	Import records from a .SCA format file from the SCAN program
C	------------------------------------------------------------

C	.SCA file frame analysis block definition
C
	CHARACTER*8 FRAME_STATUS
	CHARACTER*4 FRAME_TYPE
	INTEGER*2 IANALYSIS(256)
	COMMON /ANALYSIS_BLOCK/ IANALYSIS
	EQUIVALENCE (FRAME_STATUS,IANALYSIS(1))
     &	,(FRAME_TYPE,IANALYSIS(5))
     &	,(RECORD_NO,IANALYSIS(8))
     &	,(FRAME_TIME,IANALYSIS(10))
C

	CHARACTER*(512) HEADER
	EQUIVALENCE (IBUFFER,HEADER)

	CHARACTER*20 import_file / ' ' /
	CHARACTER KEY
	LOGICAL found,special

	character*40 msg(2)

	parameter(max_files=500)
	character*12 files(max_files)
	equivalence( files, iwork )
C
C	CODE
C
C
C	Select a .SCA file for import
C
	call move_cursor(2,2)
	call display_string(' .SCA data files ')
	call files_menu('*.SCA',0,import_file,2,3,10,files,max_files)
	if( import_file .eq. ' ' ) return
C
C
	CALL open_FILE( in_file, IERR, import_file )
	IF( IERR .NE. 0 ) THEN
	  ERROR = 'Can''t open file: '//import_file
	  RETURN
	ENDIF

C
C	Read header block of .SCA file
C
	CALL READ_FILE(in_file,IERROR,IBUFFER,1,1)
C
	CALL FIND_ENTRY('DT=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND  ) DT = GET_ENTRY(HEADER(ISTART:IEND))
C
	CALL FIND_ENTRY('GC=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND  ) GAIN_CURRENT = GET_ENTRY(HEADER(ISTART:IEND))
C
	CALL FIND_ENTRY('TU=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) T_UNITS = HEADER(ISTART:IEND)
C
	CALL FIND_ENTRY('AD=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) range_volts = GET_ENTRY(HEADER(ISTART:IEND))
C
	CALL FIND_ENTRY('BC=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) BIT_CURRENT = GET_ENTRY(HEADER(ISTART:IEND))
C
	CALL FIND_ENTRY('CU=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) y_UNITS = HEADER(ISTART:IEND)
C
	CALL FIND_ENTRY('NBA=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) NB_ANALYSIS = IFIX( GET_ENTRY(HEADER(ISTART:IEND)) )
C
	CALL FIND_ENTRY('NBD=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) NB_DATA = IFIX( GET_ENTRY(HEADER(ISTART:IEND)) )
C
	CALL FIND_ENTRY('NF=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) N_FRAMES = IFIX( GET_ENTRY(HEADER(ISTART:IEND)) )
C
	CALL FIND_ENTRY('ID=',ISTART,IEND,HEADER,FOUND)
	IF( FOUND) cell = HEADER(ISTART:IEND)

	msg(1) = 'WAIT ... Reading records '
	msg(2) = ' '
	call display_message(4,7,30,msg,2)
	ixc = 5
	iyc = 9
	n_records = 0
	nb_record = np_record/256
c
c	Set file pointer to start of data area in CDR.DAT
c
	iout_sector = 2

	do 10 i = 1,n_frames

	    call get_key( key, special )
	    if( key .eq. '$' ) goto 20
c
c	    Read SCAN record from .SCA file
c
	    in_sector = (i-1)*(nb_analysis+nb_data) + 2
	    call read_file(in_file,ierr,ianalysis,in_sector,nb_analysis)
	    call read_file(in_file,ierr,iwork,in_sector+nb_analysis,
     &	    nb_data)

	    if( frame_status .eq. 'ACCEPTED' ) then
c
c		If this record is marked ACCEPTED write its data
c		into CDR.DAT
c
		CALL MOVE_CURSOR(ixc,iyc)
		WRITE(msg(2),'(''Records '',i5,''/'',i5)') I,n_frames
		CALL DISPLAY_STRING(msg(2)(1:22))

		call write_file(ifile_1,ierr,iwork,iout_sector,nb_data)
		iout_sector = iout_sector + nb_data
		n_records = n_records + (nb_data/nb_record)
	    endif
10	continue
20	continue

	recording_time = float(n_records)*dt / 1000.

	call close_file( in_file, ierr )
	file_name = ' '
	return
	end

	SUBROUTINE FIND_ENTRY(MASK,ISTART,IEND,HEADER,FOUND)
C
C	Find the location of the string mask in the
C	header string and return the istart and iend indexes
C	found is set to .false. if mask is not found
C
	CHARACTER*(*) MASK
	CHARACTER*(*) HEADER
	LOGICAL FOUND
C
C	Search HEADER for MASK
C
	FOUND = .FALSE.
	NCH = LEN(HEADER)
	NCM = LEN(MASK)
	ICH = 0
	ICM = 0
10	CONTINUE
		IF(ICM .GE. NCM) THEN
			FOUND = .TRUE.
			ISTART = ICH + 1
		ENDIF
		ICH = ICH + 1
		ICM = ICM + 1
		IF(MASK(ICM:ICM) .NE. HEADER(ICH:ICH) ) THEN
			ICH = ICH - ICM + 1
			ICM = 0
		ENDIF
	IF(( .not. FOUND ) .AND. (ICH.LE.NCH)) GOTO 10
C
C	IF( .not. FOUND ) THEN
C		CALL MOVE_CURSOR(2,23)
C		CALL DISPLAY_STRING(MASK//' not found in header')
C	ENDIF

	IF( FOUND .EQV. .FALSE.) RETURN
C
C	FIND END OF ENTRY (TERMINATED BY A \)
C
	I = ISTART
	FOUND = .FALSE.
20	CONTINUE
	    IF((HEADER(I:I).EQ.'\').OR.(HEADER(I:I).EQ.CHAR(13))) THEN
		IEND = I - 1
		I = NCH
		FOUND = .TRUE.
	    ENDIF
	    I = I + 1
	IF(I.LE.NCH) GOTO 20
	RETURN
	END


	REAL FUNCTION GET_ENTRY(HEADER)
	REAL RN
C
C	CONVERT STRING IN HEADER
C	TO A REAL NUMBER
C
	CHARACTER*(*) HEADER
C
	READ(HEADER,900) RN
900	FORMAT(F13.0)
C
	GET_ENTRY = RN
	RETURN
	END


        SUBROUTINE EXPORT_TO_WCP_FILE
$INCLUDE: 'CDRCOM.FOR'
C
C       Export a series of event record to .WCP format file
C	--------------------------------------------------
C
C --	Record analysis block --------------------------------------
C
	parameter(nvars=17)
	parameter(max_channels=6)

	parameter(ixnum=1,ixtim=2,ixavg=3,ixarea=4,ixpeak=5,ixrise_time=6,
     &	ixrate_of_rise=7,ixt50=8,ixt90=9,ixvar=10,ixint=11)
	structure /analysis_block/
	union
	map
	integer*2 buf(256)
	end map
	map
	character*8 status
	character*4 type
	real*4 number
	real*4 time
	real*4 dt
	real*4 ad_range
	integer*2 is
	integer*2 ie
	integer*2 iz
	real*4 results(max_channels,nvars)
	real*4 par(6)
	real*4 se(6)
	real*4 sd
	real*4 f
	real*4 prob
	integer*2 iequation
	end map
	map
	character*8 scan_status
	character*6 scan_type
	real*4 scan_number
	real*4 scan_time
	integer*2 scan_pad(39)
	real*4 scan_gain
	integer*2 scan_pad1
	real*4 scan_dt
	character*4 scan_t_units
	end map
	end union
	end structure

        record /analysis_block/ rec

	CHARACTER*(512) HEADER
	EQUIVALENCE (IBUFFER,HEADER)

	CHARACTER*50 export_file / ' ' /
	character*50 new_file_name / ' ' /
	CHARACTER KEY
	LOGICAL ABORT,SPECIAL

	PARAMETER(NROWS=5)
	CHARACTER*44 MENU(NROWS)
	CHARACTER*6 LIST(NROWS)
	character*40 msg(2)
	character*44 title
	character*30 keyword

	integer*2 npre_trigger / 64 /
	integer*4 ifree4,ineeded4
C
C	CODE
C
	call set_margins(1,1,80,25)
C
	default_path = ' '
	new_file_name = file_name
	call create_path(export_file,default_path,new_file_name,'.wcp')
	call file_box(2,2,export_file,'.wcp','NEW'
     &	,' Name of export file ',abort)
	IF( ABORT ) RETURN

	CALL CREATE_FILE(IOUT_FILE,IERR,export_file)
	IF( IERR .NE. 0 ) THEN
	  ERROR = 'Can''t open file output file'
	  RETURN
	ENDIF

C	Get start/end/step size/type of series of event
C
	i = 1
	menu(i) = 'Start at event (1)'
	if( iev_sta .eq. 0 ) iev_sta = 1
	write(list(i),'(i5)') iev_sta
	i = i + 1
	write(menu(i),'(''End at event ('',i5'')'')') n_events
	if( iev_end .eq. 0 ) iev_end = n_events
	write(list(i),'(i5)') iev_end
	i = i + 1
	menu(i) = 'In steps of'
	write(list(i),'(i5)') max(iev_skip,1)
	i = i + 1
	menu(i) = 'No. of pre-event samples'
	write(list(i),'(i5)') max(npre_trigger,1)
	i = i + 1
	menu(i) = 'Type '//
     &TYPE_LIST(1)//' '//TYPE_LIST(2)//' '//
     &TYPE_LIST(3)//' '//TYPE_LIST(4)//' '//TYPE_LIST(5)//' ALL'

	if( irequired_type .eq. 0 ) then
	    list(i) = 'ALL'
	else
	    list(i) = type_list(irequired_type)
	endif

	title = ' '
5	if( title .eq. ' ' )
     &	title = ' Set range of events to be exported '
	CALL TEXT_WINDOW(MENU,LIST,NROWS,2,6,title)
C
	I = 1
	iev_sta = int(check_limits(list,1.,float(n_events),i,title))
	if( title .ne. ' ' ) goto 5

	I = i + 1
	iev_end = int(check_limits(list,float(iev_sta),float(n_events),
     &	 i,title))
	if( title .ne. ' ' ) goto 5

	I = i + 1
	iev_skip = int(check_limits(list,float(1.),float(n_events),
     &	 i,title))
	if( title .ne. ' ' ) goto 5

	I = i + 1
	npre_trigger = int(check_limits(list,1.,128.,i,title))
	if( title .ne. ' ' ) goto 5

	I = I + 1
	CALL UPPER_CASE(LIST(I))
	IREQUIRED_TYPE = 0
	DO 10 J = 1,MAX_TYPES
	    IF( LIST(I) .EQ. TYPE_LIST(J) ) THEN
		IREQUIRED_TYPE = J
	    ENDIF
10	CONTINUE
c
c	Abort if not enough disc space
c
	ifree4 = int4( free_disc_space() )
	ineeded4 = ( (iev_end - iev_sta)/iev_skip )*
     &	( (np_record/np_sector) + 1 )/2
c	 if( ifree4 .lt. ineeded4 ) then
c	     error = 'ERROR! Not enough space for .SCA file'
c	     return
c	 endif


C	Read series of events from iev_sta to iev_end
C	in steps of iev_skip into IBUFFER and transfer
C	on to .SCA file if of the required type

	IBLOCK = 2
	N_FRAMES = 0
	msg(1) = 'WAIT ... Writing to file '
	msg(2) = ' '
	call display_message(2,20,30,msg,2)
	ixc = 7
	iyc = 10
	DO 100 IEVENT = iev_sta,iev_end,iev_skip
C
C		Check for Esc key
C
		CALL GET_KEY(KEY,SPECIAL)
		IF(KEY.EQ.'$') goto 200
C
C		Read in data for event
C
		CALL GET_EVENT( IEVENT, IRECORD )
		IEVENT_OFFSET = IEVENT_START+(IEVENT_RECORD-IRECORD)
     &		*NP_RECORD
		ILO_LIMIT = MAX0(IEVENT_OFFSET - NPRE_TRIGGER,1)
		IHI_LIMIT = ILO_LIMIT + NP_RECORD
C
C
C		Copy event to .WCP file if it the required type
C		or all events (except REJECTED) if IREQUIRED_TYPE=0
C
		IF( (IEVENT_TYPE .EQ. IREQUIRED_TYPE) .OR.
     &		((IREQUIRED_TYPE.EQ.0).AND.(IEVENT_TYPE.NE.1))) THEN


		   CALL MOVE_CURSOR(ixc,iyc)
		   WRITE(msg(2),'(''Events '',I5,''/'',I5)')
     &		   IEVENT,iev_end
		   CALL DISPLAY_STRING(msg(2)(1:22))

C                   Write .WCP analysis block to file

                    N_FRAMES = N_FRAMES + 1
                    rec.status = 'ACCEPTED'
                    rec.Type = 'TEST'
                    rec.Number = n_frames
                    rec.Time = Time_Event*0.001
                    tt = rec.time
                    call move_cursor(1,1)
                    call display_flt(tt)
		    rec.ad_range = range_volts
		    rec.dt = dt
                    rec.is = 1
                    rec.ie = 512
                    rec.iz = 1
                   CALL WRITE_FILE(IOUT_FILE,IERR,rec.buf,IBLOCK,1)
		   IBLOCK = IBLOCK + 1
C
C		    Write data points to file
C
		   CALL WRITE_FILE(IOUT_FILE,IERR,IBUFFER(ILO_LIMIT)
     &		    ,IBLOCK,2)
		   IBLOCK = IBLOCK + 2
		ENDIF

100	CONTINUE
200	CONTINUE

C
C       Save .WCP file header block
C

	HEADER = ' '
	n_channels = 1
	version = 7.
	call add_flt( version, 'VER=', header, '(f4.1)' )
	call add_int( n_channels, 'NC=', header, '(i2)' )
        call add_int( n_frames, 'NF=', header, '(i5)' )
        call add_int( n_frames, 'NR=', header, '(i5)' )
        call add_int( 1, 'NBA=', header, '(i2)' )
        call add_int( 2, 'NBD=', header, '(i4)' )
        call add_int( 512, 'NP=', header, '(i4)' )
C
	call add_flt( dt, 'DT=', header, '(f8.4)' )
        call add_int( 20, 'NZ=', header, '(i4)' )


	do i = 1,n_channels
	    write( keyword,'(''YN'',i1,''='')') i-1
	    call add_char( 'Ch.0', keyword, header )
	    write( keyword,'(''YU'',i1,''='')') i-1
	    call add_char( y_units, keyword, header )
	    write( keyword,'(''YS'',i1,''='')') i-1
	    call add_flt( bit_current, keyword, header, '(g10.3)' )
	    write( keyword,'(''YG'',i1,''='')') i-1
	    call add_flt( gain_current, keyword, header, '(g10.3)' )
	    write( keyword,'(''YZ'',i1,''='')') i-1
	    call add_int( 1, keyword, header, '(i4)' )
	    write( keyword,'(''YR'',i1,''='')') i-1
	    call add_int( 1, keyword, header, '(i4)' )
	end do

        call add_flt( range_volts, 'AD=', header, '(f7.4)' )
	call add_char( t_units,'TU=', header )
	call add_char( cell,'ID=', header )

	CALL WRITE_FILE(IOUT_FILE,IERR,IBUFFER,1,1)

	CALL CLOSE_FILE(IOUT_FILE,IERR)
	RETURN
	END

	subroutine add_logical( log_val, key, string )
	logical log_val
	character*(*) key,string

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	write( string(i0:nc), '(l1,a2)' ) log_val,char(13)//char(10)
	return
	end

	subroutine add_flt( r, key, string, fstring )
	character*(*) key,string,fstring
	character*20 asc

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	write( asc, fmt=fstring ) r
	is = ileading_space(asc)
	ie = len_trim(asc)
	string(i0:nc) = asc(is:ie)//char(13)//char(10)
	return
	end

	subroutine add_int( i, key, string, fstring )
	character*(*) key,string,fstring
	character*20 asc

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	write( asc, fmt=fstring ) i
	is = ileading_space(asc)
	ie = len_trim(asc)
	string(i0:nc) = asc(is:ie)//char(13)//char(10)
	return
	end

	subroutine add_char( string_in, key, string )
	character*(*) key,string,string_in

	i0 = len_trim(string)+1
	nc = len(string)
	string(i0:nc) = key
	i0 = len_trim(string)+1
	string(i0:nc) = string_in
	i0 = len_trim(string)+1
	string(i0:i0+1) = char(13)//char(10)
	return
	end

	subroutine read_flt( mask, header, r )
	character*(*) mask, header
	real*4 r
	character*16 string

	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) then
	    string = header(is:ie)
	    read( string, '(f16.0)', err=100 ) r
	end if

100	return
	end

	subroutine read_int( mask, header, i )
	character*(*) mask, header
	integer*2 i
	character*16 string

	string = ' '
	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) then
	    string = header(is:ie)
	    read( string, '(f16.0)', err=100 ) r
	    i = int(r)
	end if
100	return
	end

	subroutine read_char( mask, header, string )
	character*(*) mask, header, string

	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) string = header(is:ie)
	return
	end

	subroutine read_logical( mask, header, log )
	character*(*) mask, header
	logical log
	character*6 string

	call find_item( header, mask, is, ie )
	if( is .gt. 0 ) then
	    string = header(is:ie)
	    read( string, '(L1)', err=100 ) log
	end if
100	return
	end

	subroutine find_item( string, name, is,ie )
	character*(*) name,string
	integer*2 nc,is,ie
c
c	Searches <string> for items with the form:
c	<name> <data> <cr> <lf>
c	or
c	<name> <data> <\>
c

	nc = len( string )
	nn = len_trim(name)
	is = index( string, name(1:nn) )
	if ( is .gt. 0 ) then
	    ie = index( string(is:nc), char(13) )
	    if( ie .ne. 0 ) then
		ie = is + ie - 2
		is = is + nn
	    endif
	endif
	return
	end

	SUBROUTINE import_from_pclamp_FILE
$INCLUDE: 'CDRCOM.FOR'
C
C	Import a data file from a pCLAMP file
C	-------------------------------------
C
c	pCLAMP data file header format
c
	parameter( np_record_max = 4096, np_record_min = 32  )
	parameter(n_channels=1)
	parameter(itemp_file=7)


	structure /pclamp5/
	union
	map
	integer*2 header(512)
	end map
	map
	real*4 par(80)
	character*77 comment
	character*80 labels
	character*35 reserved
	character*64 pulse
	real*4 par_ext(16)
	real*4 adc_offset(16)
	real*4 adc_gain(16)
	real*4 adc_amplification(16)
	real*4 adc_shift(16)
	character*8 units(16)
	end map
	end union
	end structure

	record /pclamp5/ pc5
	equivalence( pc5, iwork )

	structure /pclamp6/
	union
	map
	integer*2 header(1024)
	end map
	map
	character*4 FileType
	real*4 FileVersionNumber
	integer*2 OperationMode
	integer*4 ActualAcqLength
	integer*2 NumPointsIgnored
	integer*4 ActualEpisodes
	integer*4 FileStartDate
	integer*4 FileStartTime
	integer*4 StopwatchTime
	real*4 HeaderVersionNumber
	integer*2 nFileType
	integer*2 MSBinFormat
	integer*4 DataSectionPtr
	integer*4 TagSectionPtr
	integer*4 NumTagEntries
	integer*4 LongDescriptionPtr
	integer*4 LongDescriptionLines
	integer*4 DACFilePtr
	integer*4 DACFileNumEpisodes
	character*4 Unused
	integer*4 DeltaArrayPtr
	integer*4 NumDeltas
	integer*4 NoteBookPtr
	integer*4 NotebookManEntries
	integer*4 NotebookAutoEntries
	integer*4 SynchArrayPtr
	integer*4 SynchArraySize
	character*20 Unused100

	integer*2 ADCNumChannels
	real*4 ADCSampleInterval
	real*4 ADCSecondSampleInterval
	real*4 SynchTimeUnit
	real*4 SecondsPerRun
	integer*4 NumSamplesPerEpisode
	integer*4 PreTriggerSamples
	integer*4 EpisodePerRun
	integer*4 RunsPerTrial
	integer*4 NumberOfTrials
	integer*2 AveragingMode
	integer*2 UndoRunCount
	integer*2 FirstEpisodeInRun
	real*4 TriggerThreshold
	integer*2 TriggerSource
	integer*2 TriggerAction
	integer*2 TriggerPolarity
	real*4 ScopeOutputInterval
	real*4 EpisodeStartToStart
	real*4 RunStartToStart
	real*4 TrialStartToStart
	integer*4 AverageCount
	character*6 Unused194
	integer*2 DrawingStrategy
	integer*2 TiledDisplay
	integer*2 nEraseStrategy
	integer*2 DataDisplayMode
	integer*4 DisplayAverageUpdate
	integer*2 ChannelStatsStrategy
	integer*4 CalculationPeriod
	integer*4 SamplesPerTrace
	integer*4 StartDisplayNum
	integer*4 FinishDisplayNum
	integer*2 MultiColor
	integer*2 ShowPNRawData
	character*10 Unused234
	real*4 ADCRange
	real*4 DACRange
	integer*4 ADCResolution
	integer*4 DACResolution
	integer*2 ExperimentType
	integer*2 AutosampleEnable
	integer*2 AutosampleADCNum
	integer*2 AutosampleInstrument
	real*4 AutosampleAdditGain
	real*4 AutosampleFilter
	real*4 AutosampleMembraneCap
	integer*2 ManualInfoStrategy
	real*4 CellD1
	real*4 CellD2
	real*4 CellD3
	character*16 CreatorInfo
	character*56 FileComment
	character*12 Unused366

	integer*2 ADCPtoLChannelMap(16)
	integer*2 ADCSamplingSeq(16)
	character*10 ADCChannelname(16)
	character*8 ADCUnits(16)
	real*4 ProgrammableGain(16)
	real*4 DisplayAmplification(16)
	real*4 DisplayOffset(16)
	real*4 InstrumentScaleFactor(16)
	real*4 InstrumentOffset(16)
	real*4 SignalGain(16)
	real*4 SignalOffset(16)
	real*4 SignalLowPassFilter(16)
	real*4 SignalHighPassFilter(16)
	end map
	end union
	end structure

        record /pclamp6/ pc6
	equivalence( pc6, iwork )

	character*50 new_file_name / ' ' /
	parameter(max_files=500)
	character*52 path / ' ' /
	character*12 files(max_files)
	equivalence( iwork, files )

	character key
	logical pClampV6,pClampV5

	integer*4 ir,n_points_in,n_records_in,iblock,ifirst_block,np
	character*4 fVersion
	character*5 fType

	integer*2 ibuf(np_record_max)

c
c	code
c
	default_path = ' '
	call create_path( path, default_path, '*.dat', '.dat' )
	call files_menu(path,0,new_file_name,2,2,10,
     &	files,max_files)

	if( new_file_name .ne. ' ' ) then
c
c	    Open pCLAMP data file
c
	    call create_path(path,default_path,new_file_name,'.dat')
	    open(unit=itemp_file,
     &	    file=path,
     &	    form='binary',
     &	    access='direct',
     &	    iostat=istat,
     &	    recl=512)

c
c	    Load header information from pCLAMP header file
c
	    read(unit=itemp_file,rec=1,iostat=istat)
     &	    (pc6.header(i),i=1,1024)
c
c	    Determine whether this is a pClamp V5 or V6 file
c
	    pClampV5 = .false.
	    pClampV6 = .false.
	    if( pc5.par(1) .eq. 1. .or.
     &		pc5.par(1).eq.10. ) pClampV5 = .true.
	    if( pc6.FileType .eq. 'ABF' .or.
     &		pc6.FileType .eq. 'CPLX' .or.
     &		pc6.FileType .eq. 'FTCX' ) pClampV6 = .true.

	    if( pClampV5 ) then
c
c		pClamp V5 data file
c
		fVersion = ' V5'
		if( pc5.par(1) .eq. 1. ) then
		    fType = 'CLPX'
		elseif( pc5.par(1) .eq. 10. ) then
		    fType = 'FTCX'
		else
		    fType = '??'
		end if

		n_channels_in = int(pc5.par(2))
                n_points_in = int(pc5.par(3))* int(pc5.par(4))
		nb_data = 2
                dt = (pc5.par(5)*n_channels_in)/1000.
		range_volts = pc5.par(53)
c Change 9/10/97
                ADCScale = (2.0**pc5.par(55)) / 4096. 
                if ( ADCScale .eq. 0. ) then ADCScale = 1. 
		
		cell = pc5.comment
c
c		Channel scaling/units information
c		(pCLAMP gain factor Volts/units converted to
c		WCP gain factor mV/units. Note how pCLAMP's
c		starting A/D channel number obtained from pc.par(32) )
c
		ipc_chan = int ( pc5.par(32) ) + 1
		gain_current = pc5.adc_gain(ipc_chan)*1000.
		ibase = 2048
		y_units = pc5.units(ipc_chan)
		bit_current = convert_gain( Gain_current )
		ifirst_block = 3

	    end if

	    if( pClampV6 ) then
c
c		pClamp V6 data file
c
		fType = pc6.FileType
		fVersion = ' V6'

		n_channels_in = pc6.ADCNumChannels
		if( pc6.NumSamplesPerEpisode .le. 0 ) then
		    pc6.NumSamplesPerEpisode = 512
		end if
                n_points_in = pc6.ActualAcqLength 
                dt = (pc6.ADCSampleInterval*n_channels_in)/1000.
		range_volts = pc6.ADCRange
		if( range_volts .eq. 0. ) then Range_volts = 10

		ADCScale = (2.*pc6.ADCResolution) / 4096.
		cell = pc6.FileComment

c
c		Channel scaling/units information
c		(pCLAMP gain factor Volts/units converted to
c		WCP gain factor mV/units.
c
		ipc_chan = pc6.ADCSamplingSeq(1) + 1

		gain_current = pc6.InstrumentScaleFactor(ipc_chan)
     &			     * pc6.SignalGain(ipc_chan) * 1000.


                if( (pc6.AutoSampleADCNum .eq. (ipc_Chan-1))
     &              .and. (pc6.AutoSampleEnable.ne.0) ) then

                    if( pc6.AutosampleAdditGain .eq. 0. ) then
                        pc6.AutosampleAdditGain = 1.
                    end if
                    gain_Current = gain_current *
     &                             pc6.AutosampleAdditGain
		end if

               if( gain_current .eq. 0. ) gain_Current = 1.

		ibase = 2048
		y_units = pc6.ADCUnits(ipc_chan)
		bit_current = convert_gain( Gain_current )
		ifirst_block = 5
	    end if

	    iflag = 0
	    if( iflag .ge. 0 ) then

		file_name = new_file_name

		n_records = 0
		key = 'S'
		iout_Sector = 2
                n_records_in = n_points_in / (np_record*n_Channels_in)
                np = np_record*n_channels_in
                nb = np/256
		do ir = 1,n_records_in

		    iblock = (ir-1)*nb + ifirst_block

		    read(unit=itemp_file,
     &			 rec=iblock,
     &			 iostat=istat,
     &			 err=101)
     &			 (iBuf(i),i=1,np)
		    j = 1
		    do i = 1,np,n_channels_in
			iwork(j) = int(float(iBuf(i)/ADCScale)) +2048
			j = j + 1
		    end do
		    nb_data = 2
		    call write_file(ifile_1,ierr,iwork,iout_sector,nb_data)
		    iout_sector = iout_sector + nb_data
		    n_records = n_records + 1

		    call display_progress( 3, 20,
     &		    fVersion//fType//' Records (ESC to abort) ',
     &		    ir,n_records_in,key)

		    iblock = iblock + np/256

		    if( key .eq. '$' )	goto 101

		end do
101		continue

		recording_time = float(n_records)*dt / 1000.
		close(unit=itemp_file)
		file_name = ' '

	    end if
	end if
	return
	end

	subroutine display_progress( ix,iy, title, i,n, key )
	character*(*) title,key

	integer*4 i,n
	character*60 string
	logical special
	real*4 tMessage /0./

	if( time_in_secs() .ge. tMessage ) then
	    write(string,'(a,1x,i7,''/'',i7)') title,i,n
	    nc = len_trim( string )
	    call erase_box(ix,iy,ix+nc+2,iy+2)
	    call display_box(ix,iy,ix+nc+2,iy+2)
	    call move_cursor(ix+1,iy+1)
	    call display_string( string(1:nc) )
	    call get_key( key, special )
	    TMessage = time_in_secs() + 1.
	end if
	return
	end

	subroutine display_error( ix,iy, title )
	character*(*) title

	nc = len_trim( title )
	call erase_box(ix,iy,ix+nc+2,iy+2)
	call display_box(ix,iy,ix+nc+2,iy+2)
	call move_cursor(ix+1,iy+1)
	call display_string( title )
	call wait(1.)

	return
	end

	subroutine create_path( path, dir_path, fname, fext )
	character*(*) path, dir_path, fname, fext
c
c	Create a complete file path (In path) by assembling the
c	directory path (dir_path), file name (fname) and
c	file extension) (fext components

	nc = len(path)
	if( dir_path .ne. ' ' ) then
	    path = dir_path
	    ix = len_trim(path)+1
	else
	    path = ' '
	    ix = 1
	end if

	path(ix:nc) = fname

	if( fext .ne. ' ' ) then
	    ix = index( path, '.' )
	    if( ix .le. 0 ) ix = len_trim(path)+1
	    path(ix:nc) = fext
	end if
	return
	end

	subroutine Report_Error(ileft,itop,msg)
	integer*2 ileft,itop
	character*(*) msg
	character*60 string
c
c	code
c
	string = msg
	nc = len_trim (string )

	call get_screen_device( iscreen )
	call set_text_colour( iscreen, 2 )
	call move_cursor(ileft,itop)
	call display_string( string(1:nc) )
	call set_text_colour( iscreen, 1 )
	string = ' '
	call wait(1.)
	call display_string( string(1:nc) )
	return
	end
