	subroutine plot_display( ibuf, np,
     &	iy_scale, min_y_scale, iy_offset, icolour,
     &	dt_plot, t_zero, title )
$INCLUDE: 'cdrcom.for'
	integer*2 ibuf(1)
	real dt_plot,t_zero
	character*(*) title
c
c	(CALLED FROM FILE CDRDSP.FOR)
c
c	Plot a hard copy of the NP sample points in IBUF on
c	printer, plotter, ASCII file, HPGL file, or screen.
c	Data points is offset by IY_OFFSET and
c	scaled by IY_SCALE before plotting
c	within an area of height MIN_Y_SCALE*MAX_ADC
c	of the recording. dt_plot is time interval between samples
c	TITLE line is printed at top of page
c	T_ZERO is zero time

	parameter(max_ndc=32767)
	integer*2 iarea(4),ixy(4)
	integer*1 ieof /26/
	CHARACTER DEVICE,key
	LOGICAL SPECIAL
	real row(10)
C
C	CODE	
C
c
c	Select O/P device
c
	call get_screen_device( iscreen )
	call select_plot_device(4,6,idev,ihandle,device)

	if( idev .eq. 0 ) then
	    if( ihandle .ne. 0 ) then
c
c		Write record to ASCII text file in format
c		T <TAB> Y <CR> <LF>
c		Terminate with ASCII end-of-file marker ctrl-z
c
		do 21 i = 1,np
		    ncols = 1
		    row(ncols) = t_min + float(i-1)*dt_plot - t_zero
		    ncols = ncols + 1
		    row(ncols) = float(ibuf(i)-ical_current)*bit_current
		    call write_ascii_list(ihandle,row,ncols,1)
21		continue
c
c		Terminate with CTRL-Z e.o.f marker
c		and close file
c
		call write_bytes(ihandle,ierr,ieof,1)
		call close_file( ihandle, ierr )
		return
	    endif
	    return

	elseif( idev .eq. iscreen ) then
	    call erase_all
	endif

	call get_text_attributes( idev, i,i,i,i,i,
     &	ichar_width,ichar_height)

C
C	Set physical plotting area
C
	iheight = max_adc*min_y_scale
	ibottom = 5*ichar_height
	ilength = 24567
	ileft = 7*ichar_width
c
c	Define plotting area on page
c
	iarea(1) = ileft
	iarea(3) = iarea(1) + ilength
	iarea(2) = ibottom
	iarea(4) = iarea(2) + iheight
c
c	Plot channel
c
	call plot_channel( idev, iarea,
     &	ibuf, 1, 1, 1, np, iy_scale, iy_offset, icolour )
c
c	Draw channel zero level as dotted line
c	(Note use of transparent writing mode)
c
	ixy(1) = iarea(1)
	ixy(3) = iarea(3)
	ixy(2) = (ical_current - iy_offset)* iy_scale + iarea(2)
	ixy(4) = ixy(2)
	call set_polyline_type( idev, 3 )
	call set_polyline_colour( idev, icolour )
	call set_writing_mode( idev, 2 )
	call polyline( idev, ixy, 2 )
	call set_polyline_type( idev, 1 )
	call set_writing_mode( idev, 1 )
	call set_polyline_colour( idev, 1 )

c
c	Calibration bar
c
	y_10 = float((max_adc*min_y_scale)/iy_scale)* bit_current * 0.1
	y_bar = 10.**( int( alog10(y_10)) + 1 )
	dy = y_bar*0.1
	do 131 i=1,9
	    if( y_bar .le. y_10 ) goto 132
	    y_bar = y_bar - dy
131	continue
132	continue

	ix = iarea(1) - 5*ichar_width
	iy = iarea(2) + 3*ichar_height
	call yt_calibration( idev, ix, iy,
     &	iy_scale*int(y_bar/bit_current),
     &	ichar_width,ichar_height,y_bar,y_units,'V' )

C
C	Create and draw a suitably sized horizontal calibration bar
C
	x_10 = float(np)*dt_plot/10.
	CALL MOVE_cursor(1,1)
	call display_flt(x_10)

	X_BAR = 10.**(int(ALOG10(X_10))+1)
	DX = X_BAR*0.1
	DO 40 I=1,9
		IF(X_BAR.LE.X_10) GOTO 41
		X_BAR = X_BAR - DX
40	CONTINUE
41	CONTINUE

	ix = iarea(1)
	iy = ibottom - ichar_height
	idx = ilength / np
	CALL YT_CALIBRATION(IDEV,IX,IY
     &	,int(FLOAT(IDX)*X_BAR/DT_plot)
     &	,ICHAR_WIDTH,ICHAR_HEIGHT,X_BAR,t_units,'H')
C
C	Print title
C
	ixy(1) = ileft
	ixy(2) = ndc_max - 3*ichar_height
	nc = itrailing_space( title )
	call graphics_text( idev, ixy, title(1:nc) )
	ixy(2) = ndc_max - 4*ichar_height
	nc = itrailing_space( cell )
	call graphics_text( idev, ixy, cell(1:nc) )
C
	IF( IDEV .NE. ISCREEN ) THEN
	    CALL UPDATE_WORKSTATION(IDEV)
	    CALL CLEAR_WORKSTATION(IDEV)
	    CALL UNLOAD_FONTS(IDEV)
	    CALL CLOSE_WORKSTATION(IDEV)
	ELSE
	    CALL SET_CHARACTER_HEIGHT(ISCREEN,1000)
	    CALL MOVE_CURSOR(2,25)
	    CALL DISPLAY_STRING('<<< Press any key to continue >>>')
	    CALL WAIT_FOR_KEY( KEY, SPECIAL )
	ENDIF
C
	RETURN
	END

	subroutine select_plot_device(ix,iy,idev,ihandle,device)
c
c	Let user select plotter output device
c
c	IX,IY = top left of entry form
c	Workstation No. returned in IDEV
c	Output file handle returned in IHANDLE (with IDEV=0)
c	IDEV and IHANDLE = 0 indicates abort
c	DEVICE is returned with letter pressed by user
c
	character*(*) device

	parameter(nmenu=6,iprinter=2,iplotter=3,ifile=4,iscreen=1
     &	,ihpgl=5)
	character*20 menu(nmenu) /
     &	' Screen       S',
     &	' Printer      R',
     &	' Plotter      P',
     &	' ASCII file   F',
     &	' HPGL file    H',
     &	' Cancel     ESC'/

	character*12 list_file
	character*6 keys /'SRPFH$'/
	logical new_menu,abort

	new_menu = .true.
	itype = Iwait_MENU_VERTICAL1(menu,keys,nmenu,ix,iy,new_menu
     &	,itype,' Output to: ',key)

	if( itype .eq. iscreen ) then
c
c	    Write to screen
c
	    call get_screen_device(idev)

	elseif( itype .eq. iplotter ) THEN
c
c	    Open plotter
c
	    call display_message(ix+1,iy+1,22,' WAIT ... Plotting ',1)
	    CALL OPEN_WORKSTATION(IDEV,11)
	    CALL LOAD_FONTS(IDEV)
	    CALL SET_TEXT_FACE(IDEV,1)

	    iheight = int( (32767./12.)*(14. / 72.) )
	    call set_character_height( idev, iheight )


	ELSEIF( itype .eq. iprinter ) THEN
c
c	    Open printer
c
	    call display_message(ix+1,iy+1,22,' WAIT ... Plotting ',1)
	    CALL OPEN_WORKSTATION(IDEV,21)
	    CALL LOAD_FONTS(IDEV)
	    CALL SET_TEXT_FACE(IDEV,1)
	    call set_point_size( idev, 14 )

	ELSEIF( itype .eq. ifile ) then
c
c	    Open ASCII file
c
	    call file_box(ix+1,iy+1,list_file,' ','NEW'
     &	    ,' ASCII file ',abort)
	    if( .not. abort ) then
		call create_file( ihandle, ierr, list_file )
		idev = 0
		if (ierr .ne. 0 ) ihandle = 0
		call display_message(ix+2,iy+2,28
     &		,' WAIT ... Writing to file ',1)
	    else
		idev = 0
		ihandle = 0
	    endif
	elseif( itype .eq. ihpgl ) then
c
c	    Output to an HPGL file
c
	    call file_box(ix+1,iy+1,list_file,' ','NEW'
     &	    ,' HPGL file ',abort)
	    if( .not. abort ) then
		call display_message(ix+1,iy+1,22,' WAIT ... Plotting ',1)
		CALL OPEN_WORKSTATION_to_file(IDEV,11,list_file)
		CALL LOAD_FONTS(IDEV)
		CALL SET_TEXT_FACE(IDEV,1)
		iheight = int( (32767./12.)*(14. / 72.) )
		call set_character_height( idev, iheight )
	    endif
	else
c
c	    ESC = abort plot
c
	    idev = 0
	    ihandle = 0
	endif

	if( itype .ne. 0 ) then
	    device = keys(itype:itype)
	else
	    device = ' '
	endif
	return
	end

	subroutine write_ascii_list(ihandle,rlist,ncols,nrows)
c
c	Write contents of REAL array RLIST(NCOLS,NROWS) to file
c	as NROWS rows of ASCII text (NCOLS per row) to file
c	attached to IHANDLE

	character tab,cr,lf
	real rlist(ncols,nrows)

	character*200 string
	integer*1 istring(200)
	equivalence(string,istring)

c
c	code
c
	tab = char(9)
	cr = char(13)
	lf = char(10)
	do 20 irow = 1,nrows
	    string = ' '
	    j = 1
	    do 15 icol = 1,ncols
		write(string(j:j+12),'(1pg12.5,a)') rlist(icol,irow),tab
		j = j + 13
15	    continue
	    string(j-1:j+1) = cr//lf
	    nc = itrailing_space( string )
	     call write_bytes(ihandle,ierr,istring,nc)
20	continue
	return
	end

	subroutine plot_graph(output,xy,np
     &	,xlo,ylo,xhi,yhi,xtic,ytic,xlabel,ylabel,report,nlines)
C
C	Plot X/Y graph on screen, printer, plotter, or file.
C	----------------------------------------------------
C	Enter with "output='S'" for screen display, "output='H' for
C	hard copy. Graph points is array "xy" "np" = No. of points
C	"xlo,ylo,xhi,yhi" are limits of X and Y axes
C	"xtic,ytic" spacing of calibration tics on axes
C	"ylabel" and "xlabel" =  axes labels
c	"report" contains "nlines" of text ro be displayed with plot
C
	parameter(max_ndc=32767)
	character*(*) output,report(nlines)
	REAL XY(1)
	INTEGER*2 IXY(2)
	integer*1 ieof
	CHARACTER*(*) ylabel,xlabel
	CHARACTER device

C
C	CODE
c
	call get_screen_device( iscreen )

	if( output .ne. 'S' ) then
c
c	    Let user select O/P device
c
	    call select_plot_device(3,5,idev,ihandle,device)
	    if( (idev.eq. 0) .and. (ihandle.eq.0) ) return

	    if( (idev.eq.0) .and. (ihandle.ne.0) ) then
c
c		Write X/Y graph to ASCII text file in format
c		X <TAB> Y <CR> <LF>
c		Terminate with ASCII end-of-file marker ctrl-z
c
		call write_ascii_list(ihandle,xy,2,np)
		ieof = 26
		call write_bytes(ihandle,ierr,ieof,1)
		call close_file( ihandle, ierr )
		return
	    endif
	else
	    idev = iscreen
	endif

	call get_text_attributes( idev, i,i,i,i,i,
     &	ichar_width,ichar_height)
c
c	Set size/position of plot on page
c
	if( idev .eq.  iscreen ) then
	    CALL SET_SIZE(7000,5000,ichar_width*54,20000)
	elseif( device .eq. 'P' ) then
	    CALL SET_SIZE(7000,5000,20000,24000)
	else
	    CALL SET_SIZE(8000,7000,28000,20000)
	endif

	call draw_axes_manual(idev,xlo,ylo,xhi,yhi,xlabel,ylabel
     &	,'N','N','N',xtic,ytic )

	CALL SET_POLYMARKER_TYPE(IDEV,2)
	CALL SET_POLYMARKER_HEIGHT(IDEV,ICHAR_HEIGHT/4)
	CALL DRAW_marker(IDEV,XY,NP)
C
c	Display report list
c
	if( idev .eq. iscreen ) then
	    do 35 i = 1,nlines
		call move_cursor(2,i+1)
		call display_string( report(i) )
35	    continue
	else
	    IXY(1) = ICHAR_WIDTH
	    IXY(2) = max_ndc - ICHAR_HEIGHT*2
	    do 40 i = 1,nlines
		ixy(2) = ixy(2) - ichar_height
		call graphics_text( idev, ixy, report(i) )
40	    continue
	endif

C
C	Close hard copy workstation
C
	CALL GET_SCREEN_DEVICE(ISCREEN)
	IF( IDEV.NE.ISCREEN ) THEN
		CALL UPDATE_WORKSTATION(IDEV)
		CALL CLEAR_WORKSTATION(IDEV)
		CALL UNLOAD_FONTS(IDEV)
		CALL CLOSE_WORKSTATION(IDEV)
	ENDIF
	RETURN
	END


	subroutine plot_histogram(output,xy,np
     &	,xlo,ylo,xhi,yhi,xtic,ytic,xlabel,ylabel,report,nlines)
$include:'cdrcom.for'
C
C	Plot histogram on screen, printer, plotter, or file.
C	----------------------------------------------------
C	Enter with "output='S'" for screen display, "output='H' for
C	hard copy. Graph points is array "xy" "np" = No. of points
C	"xlo,ylo,xhi,yhi" are limits of X and Y axes
C	"xtic,ytic" spacing of calibration tics on axes
C	"ylabel" and "xlabel" =  axes labels
c	"report" contains "nlines" of text ro be displayed with plot

	parameter(max_ndc=32767)
	character*(*) output,report(nlines)
	real xy(1)
	integer*2 np,nlines
	real xlo,ylo,xhi,yhi
	INTEGER*2 IXY(2)
	integer*1 ieof
	CHARACTER*(*) YLABEL,xlabel
	CHARACTER device

	REAL work(1)
	EQUIVALENCE (IWORK(301),work)
C
C	CODE
C
	call get_screen_device( iscreen )

	if( output .ne. 'S' ) then
c
c	    Let user select O/P device
c
	    call select_plot_device(3,5,idev,ihandle,device)
	    if( (idev.eq. 0) .and. (ihandle.eq.0) ) return

	    if( (idev.eq.0) .and. (ihandle.ne.0) ) then
c
c		Write X/Y graph to ASCII text file in format
c		X <TAB> Y <CR> <LF>
c		Terminate with ASCII end-of-file marker ctrl-z
c
		call write_ascii_list(ihandle,xy,2,np)
		ieof = 26
		call write_bytes(ihandle,ierr,ieof,1)
		call close_file( ihandle, ierr )
		return
	    endif
	else
	    idev = iscreen
	endif

	call get_text_attributes( idev, i,i,i,i,i,
     &	ichar_width,ichar_height)
C
C	Draw histogram by joining up edges of bins
C
	bin_half = (xy(3) - xy(1))/2.
	work(1) = xy(1) - bin_half
	work(2) = 0.
	J = 2
	DO 10 I = 1,np*2,2
	    J = J + 1
	    work(J) = xy(i) - bin_half
	    J = J + 1
	    work(J) = xy(I+1)
	    J = J + 1
	    work(J) = xy(i) + bin_half
	    J = J + 1
	    work(J) = xy(i+1)
10	CONTINUE
	J = J + 1
	work(J) = work(j-2)
	J = J + 1
	XY(J) = 0.
	NPLOT = J/2
C
	YMIN = 0.
c
c	Set size/position of plot on page
c
	if( idev .eq.  iscreen ) then
	    CALL SET_SIZE(7000,5000,ichar_width*54,20000)
	elseif( device .eq. 'P' ) then
	    CALL SET_SIZE(7000,5000,20000,24000)
	else
	    CALL SET_SIZE(8000,7000,28000,20000)
	endif

	call draw_axes_manual(idev,xlo,ylo,xhi,yhi,xlabel,ylabel
     &	,'N','N','N',xtic,ytic )

	CALL DRAW_LINE(IDEV,work,NPLOT)

C
c	Display report list
c
	if( idev .eq. iscreen ) then
	    do 35 i = 1,nlines
		call move_cursor(2,i+1)
		call display_string( report(i) )
35	    continue
	else
	    IXY(1) = ICHAR_WIDTH
	    IXY(2) = max_ndc - ICHAR_HEIGHT*2
	    do 40 i = 1,nlines
		ixy(2) = ixy(2) - ichar_height
		call graphics_text( idev, ixy, report(i) )
40	    continue
	endif

C
C	Close hard copy workstation
C
	CALL GET_SCREEN_DEVICE(ISCREEN)
	IF( IDEV.NE.ISCREEN ) THEN
		CALL UPDATE_WORKSTATION(IDEV)
		CALL CLEAR_WORKSTATION(IDEV)
		CALL UNLOAD_FONTS(IDEV)
		CALL CLOSE_WORKSTATION(IDEV)
	ENDIF
	RETURN
	END




