	SUBROUTINE FILE_OPTIONS
C
C	External data storage file save/load options
C	--------------------------------------------
C
$INCLUDE: 'CDRCOM.FOR'
	CHARACTER KEY,default_disc
	character*80 string
	logical new_menu

        PARAMETER(Nmenu=10,istatus_left=59,istatus_top=19)
	CHARACTER*20 MENU(nmenu) /
     &	'Save to data file F1',
     &	'Load from file    F2',
     &	'Simulation        F3',
     &	'Delete data file  F4',
     &	'Change directory  F5',
     &	'Export to SCAN    F6',
     &	'Import from SCAN  F7',
     &	'Imp. from PClamp  F8',
     &	'Export to WCP     F9',
     &	'Exit             ESC' /
C
C -- CODE ------------------------------------------------------
C
C
C	Display program status box
C
	new_menu = .true.
	key = ' '
100	call erase_all

c
c	Display title
c
	call display_box(1,1,istatus_left-2,25)
	call move_cursor(5,5)
	call display_string(
     &	'     CDR - Computer Disc Recorder V3.7')
	call move_cursor(5,6)
	call display_string(
     &	' (c) J. Dempster 1989-1996, All Rights Reserved')

	call move_cursor(2,24)
	if( error .ne. ' ' ) then
	    call display_string(error(1:50))
	    error = ' '
	else
	    call display_string(error(1:50))
	endif

c
c	Display program status
c
	call display_box(istatus_left-1,istatus_top-1,79,25)
	call set_margins(istatus_left,istatus_top,79,25)
	call move_cursor(istatus_left,istatus_top)

	CALL GET_DEFAULT_DISC(DEFAULT_DISC)
	CALL GET_DIRECTORY(STRING,NC)
	nc = min(nc,11)
	CALL DISPLAY_STRING('Dir '//DEFAULT_DISC//':\'//STRING(1:nc))
	call new_line

	if( file_name .eq. ' ' ) then
	    call display_string('Recording not saved')
	else
	    write( string, '(''Saved on '',a)') file_name
	    call display_string( string(1:20) )
	endif
	call new_line

	write(string,'(''Record     '',f8.1,''s'')') recording_time
	call display_string( string(1:20) )
	call new_line

	write(string,'(''% work file '',i5,''%'')')
     &	int(100.*FLOAT(N_RECORDS)/FLOAT(MAX_RECORDS))
	call display_string( string(1:20) )
	call new_line

	ifree4 = int( free_disc_space() )
	write(string,'(''Free disc '',I7,''Kb'')' ) ifree4
	call display_string( string(1:20) )
	call new_line

	write(string,'(''Free Memory  '',i4,''Kb'')' ) ifree_memory()
	call display_string( string(1:20) )

	call set_margins(1,1,80,25)

	iop = Iwait_MENU_VERTICAL1(menu,'123456789$',nmenu
     &	,istatus_left-1,1,new_menu,iop,' Files Options ',key)
	IF(IOP.LE.0) GOTO 100

        GOTO(1,2,3,4,5,6,7,8,9,10) iop
	GOTO 200
C
1	CALL SAVE_DATA_FILE
	GOTO 200
2	CALL LOAD_DATA_FILE
	GOTO 200
3	CALL CREATE_TEST_SIGNAL
	GOTO 200
4	CALL DELETE_DATA_FILE
	GOTO 100
5	CALL CHANGE_DATA_DIRECTORY
	GOTO 100
6	CALL EXPORT_TO_SCAN_FILE
	GOTO 200
7	call import_from_scan_file
	goto 100
8       call Import_from_pclamp_file
        goto 100
9       call Export_to_WCP_file
        goto 100
10      goto 200
C
200	CONTINUE
	RETURN
	END

	SUBROUTINE LOAD_DATA_FILE
C
C --	Load .CDR file
C
$INCLUDE: 'CDRCOM.FOR'
C
	CHARACTER*12 NEW_FILE_NAME / ' ' /
	parameter(max_files=500)
	character*12 files(max_files)
	equivalence( files, iwork )
C
C	CODE
C
C
C	Display directory of .CDR files and let user choose
C
	call move_cursor(2,2)
	call display_string(' Load .CDR data file ')
	call files_menu('*.CDR',0,new_file_name,2,3,10,files,max_files)

	IF(NEW_FILE_NAME .EQ. ' ') RETURN
C
	CALL OPEN_FILE(IFILE,IERR,NEW_FILE_NAME)
C
C	Read header block
C
	CALL READ_BYTES(IFILE,IERR,IHEAD,NP_SECTOR*2)
C
	IF(SIGNATURE .NE. 'CDR ') THEN
		CALL CLOSE_FILE(IFILE,IERR)
		CALL READ_FILE(IFILE_1,IERR,IHEAD,1,1)
		ERROR = 'ERROR ... '//NEW_FILE_NAME//
     &	' is not a .CDR file! '
		RETURN
	ENDIF
	FILE_NAME = NEW_FILE_NAME
C
C	Read data blocks
C
	DO 10 IRECORD = 1,N_RECORDS
		CALL READ_BYTES(IFILE,IERR,IBUFFER,NP_RECORD*2)
		CALL PUT_RECORD(IRECORD)
10	CONTINUE
C
C	Read event data list
C
	DO 20 IEVENT = 1,N_EVENTS
		CALL READ_BYTES(IFILE,IERR,IEVENT_BUFFER,NBYTES_EVENT)
		CALL PUT_EVENT(IEVENT)
20	CONTINUE
C
	CALL CLOSE_FILE(IFILE,IERR)
	RETURN
	END

	SUBROUTINE SAVE_DATA_FILE
C
C --	Save data from work files to .CDR file
C
$INCLUDE: 'CDRCOM.FOR'
C
	CHARACTER*12 NEW_FILE_NAME /' '/
	LOGICAL ABORT
	parameter(max_files=500)
	character*12 files(max_files)
	equivalence( files, iwork )
C
C	CODE
C
C
C	Display directory of existing .CDR files
C
	call move_cursor(2,2)
	call display_string(' .CDR data files ')
	call files_menu('*.CDR',0,new_file_name,2,3,10,files,max_files)

	new_file_name = ' '
	call file_box(3,6,new_file_name,'.CDR','NEW'
     &	,' Name of new file ',abort)
	IF( ABORT ) RETURN
C
	CALL OPEN_FILE(IFILE,IERR,NEW_FILE_NAME)
	IF(IERR.NE.0) CALL CREATE_FILE(IFILE,IERR,NEW_FILE_NAME)
	IF(IERR.NE.0) THEN
		ERROR = 'ERROR ... 	Can''t open file '//NEW_FILE_NAME
		RETURN
	ENDIF
C
	FILE_NAME = NEW_FILE_NAME
C
C	Write header block
C
	CALL WRITE_BYTES(IFILE,IERR,IHEAD,NP_SECTOR*2)
C
C	Write data blocks
C
	DO 10 IRECORD = 1,N_RECORDS
		CALL GET_RECORD(IRECORD)
		CALL WRITE_BYTES(IFILE,IERR,IBUFFER,NP_RECORD*2)
10	CONTINUE
C
C	Write event data list
C
	DO 20 IEVENT = 1,N_EVENTS
		CALL GET_EVENT_ANALYSIS(IEVENT)
		CALL WRITE_BYTES(IFILE,IERR,IEVENT_BUFFER,NBYTES_EVENT)
20	CONTINUE
C
	CALL CLOSE_FILE(IFILE,IERR)
	RETURN
	END

	SUBROUTINE DELETE_data_FILE
C
C --	Delete .CDR file
C
$INCLUDE:'cdrcom.FOR'
C
	CHARACTER*12 NEW_FILE_NAME/ ' ' /
	parameter(max_files=500)
	character*12 files(max_files)
	equivalence( files, iwork )
	character key
C
C	CODE
C

	call move_cursor(2,2)
	call display_string(' DELETE .CDR DATA FILE  ')
	call files_menu('*.CDR',0,new_file_name,2,3,10,files,max_files)
	IF(NEW_FILE_NAME .EQ. ' ') RETURN

	call query_box(3,7,' Delete: '//new_file_name//
     &	' Are you sure (Y/N) ? ',key )
	if( key .ne. 'Y' ) return
C
	CALL DELETE_FILE(IERR,NEW_FILE_NAME)

	RETURN
	END

	SUBROUTINE CHANGE_data_DIRECTORY
C
C --	Change directory
C
$INCLUDE:'cdrcom.FOR'
C
	character*40 list /' '/
	character*40 directory /' '/
	character disc_drive
C
C	CODE
C
	call get_default_disc( list )
	call get_directory( directory, nc )
	list(2:40) = ':\'//directory(1:nc)

	call text_window(' ',list,1,2,2
     &	,' Change default disc & directory ')

	ix = ileading_space( list )
	disc_drive = list(ix:ix)
	call upper_case(disc_drive)
	CALL CHANGE_DEFAULT_DISC( disc_drive )
	ix = index(list,':')
	if(ix .gt. 0 ) CALL CHANGE_DIRECTORY(IERR,list(ix+1:40))

	RETURN
	END

	SUBROUTINE CREATE_TEST_SIGNAL
C
C	Create  test signals
C
$INCLUDE: 'CDRCOM.FOR'
C
	CHARACTER*24 STRING
	CHARACTER KEY
	parameter(nrows=5)
	character*36 menu(nrows) /
     &	' Amplitude of exponential (  )',
     &	' Time constant (  )',
     &	' Amplitude variation (  )',
     &	' Time constant variation (  )',
     &	' Background noise (  )' /
	CHARACTER*12 TEXT(NROWS)
	character*44 title

C
C -- CODE ------------------------------------------------------
C
C
C -- Get parameters for exponential decay
C
	i = 1
	ix = index( menu(i), '(') + 1
	menu(i)(ix:ix+1) = y_units
	if( amp .eq. 0. ) amp = float(max_adc)*bit_current/3.
	write(text(i),'(f12.3)') amp

	i = i + 1
	ix = index( menu(i), '(') + 1
	menu(i)(ix:ix+1) = t_units
	if( tau .eq. 0. ) tau = dt*50.
	write(text(i),'(f12.3)') tau

	i = i + 1
	ix = index( menu(i), '(') + 1
	menu(i)(ix:ix+1) = y_units
	write(text(i),'(f12.3)') ampv

	i = i + 1
	ix = index( menu(i), '(') + 1
	menu(i)(ix:ix+1) = t_units
	write(text(i),'(f12.3)') tauv

	i = i + 1
	ix = index( menu(i), '(') + 1
	menu(i)(ix:ix+1) = y_units
	write(text(i),'(f12.3)') rnoise

	title = ' '
10	if( title .eq. ' ' ) then
	    title = ' Create simulated endplate currents '
	endif
	CALL TEXT_WINDOW(MENU,TEXT,NROWS,2,2,title)
c
	amp_max = float(max_adc)*bit_current

	I = 1
	amp = check_limits(text,-amp_max,amp_max,i,title)
	if( title .ne. ' ' ) goto 10

	I = i + 1
	tau = check_limits(text,dt,dt*1000.,i,title)
	if( title .ne. ' ' ) goto 10

	I = i + 1
	ampv = check_limits(text,0.,amp_max,i,title)
	if( title .ne. ' ' ) goto 10

	I = i + 1
	tauv = check_limits(text,0.,dt*1000.,i,title)
	if( title .ne. ' ' ) goto 10

	I = i + 1
	rnoise = check_limits(text,0.,amp_max,i,title)
	if( title .ne. ' ' ) goto 10



	if( file_name .eq. ' ' ) then
	    call query_box(4,6,
     &	    ' Current recording NOT SAVED! Overwrite (Y/N)? ',key)
	    if( key .eq. 'Y' ) return
	endif


	call display_message(4,6,40,' WAIT ... Creating test signals ',1)
	ixc = 6
	iyc = 8
C
C		Set up random number generator with 3 randomly
C		chosen integers
C
	CALL SET_RANDOM(19,25831,1987)
C
	N_RECORDS = MIN0(IFIX( (RECORDING_TIME*1000.)
     &	/(DT*FLOAT(NP_RECORD)) ),MAX_RECORDS)
	RECORDING_TIME = FLOAT(N_RECORDS)*DT*FLOAT(NP_RECORD)/1000.
	DO 100 IREC = 1,N_RECORDS
C
C		Add background noise
C
		DO 110 I = 1,NP_RECORD
			IBUFFER(I) = 500 + IFIX(RNOISE*RANDOM())
110		CONTINUE
C
C		Add exponential with randomly produced amplitude
C		and decay
C
		IS = IFIX(RANDOM()*101.) + 51
		R = -DT/(TAU + TAUV*RANDOM())
		A = (AMP + AMPV*RANDOM())/BIT_CURRENT
		DO 120 I=IS,NP_RECORD
			X = FLOAT(I-IS)
			IY = IFIX(A*EXP(R*X))
			IBUFFER(I) = IBUFFER(I) + IY
120		CONTINUE
C
C		Save in CDR.DAT
C
		CALL PUT_RECORD(IREC)
C
		CALL MOVE_CURSOR(ixc,IYC)
		WRITE(STRING,910) IREC,N_RECORDS
910		FORMAT('Records done: ',I4,'/',I4)
		CALL DISPLAY_STRING(STRING)
C
100	CONTINUE
C
C	Set FILE_NAME to blank to indicate that a new recording
C	is in the data file
C
	FILE_NAME = ' '
C
	RETURN
	END
	REAL FUNCTION RANDOM()
C
C	Algorithm AS183 - Random No. generator
C
	COMMON /RAND/ ix,iy,iz
C
	ix = 171*MOD(ix,177) - 2*(ix/177)
	iy = 172*MOD(iy,176) - 35*(iy/176)
	iz = 170*MOD(iz,178) - 63*(iz/178)
C
	IF(ix.LT.0) ix = ix + 30269
	IF(iy.LT.0) iy = iy + 30307
	IF(iz.LT.0) iz = iz + 30323
C
	RANDOM = AMOD(FLOAT(ix)/30269. + FLOAT(iy)/30307. +
     &		 FLOAT(iz)/30323. ,1.)
	RETURN
	END
	SUBROUTINE SET_RANDOM(ix_in,iy_in,iz_in)
	COMMON /RAND/ ix,iy,iz
	ix = ix_in
	iy = iy_in
	iz = iz_in
	RETURN
	END
