	SUBROUTINE edit_EVENTS(IA_START,IA_END,NPRE_TRIGGER)
C
$INCLUDE: 'CDRCOM.FOR'
C
C -- Display selected ADC records and allow values to be
C	read by cursor.
C
	parameter(nmenu=12,istatus_left=64,istatus_top=19)
	character*15 menu(nmenu) /
     &	'Zoom in       +',
     &	'Prev event PgUp',
     &	'Next event PgDn',
     &	'Goto event Home',
     &	'Reject       F1',
     &	'Set type     F2',
     &	'Save cursor  F3',
     &	'List saved   F4',
     &	'Plot display F5',
     &	'Set limits   F6',
     &	'Set zero     F7',
     &	'Exit        ESC'/

c
c	Display magnification, offsets & colour
c
	integer*2 iy_scale / 6 /
	integer*2 min_y_scale / 6 /
	integer*2 max_y_scale / 32 /
	integer*2 iy_offset / 0 /
	integer*2 icolour / 2 /

	LOGICAL NEW_DISPLAY,NEW_menu,SPECIAL,NEW_ANALYSIS,NEW_EVENT
	INTEGER N_ZOOM(4),IXY(2)
	CHARACTER KEY
	CHARACTER*60 TEXT(2)
	CHARACTER*76 STRING
	CHARACTER*12 LABEL
	CHARACTER*18 STRING18
C
C	Cursor readout data table
C
	PARAMETER( MAX_ROW=1500,MAX_COL=2)
	REAL TABLE(MAX_COL,MAX_ROW)
	EQUIVALENCE (IWORK(1),TABLE)
     &,(IWORK(6000),IXY),(IWORK(6200),TEXT)
C
C -- CODE -------------------------------------------------------
C
C
	call erase_all

	N_TABLE = 0
	ITRIGGER_LEVEL = IFIX(TRIGGER_LEVEL*40.96)
	NP_DEAD = IFIX(DEAD_TIME/DT)
	T_RECORD = FLOAT(NP_RECORD)*DT
	IEVENT = 1
	new_event = .true.
	ILAST_F5 = 0
	new_menu = .true.
	key = ' '
	ievent_offset = 1
	i0 = ievent_offset - npre_trigger
	n_disp = np_record

C
C -- Begin display loop --------------------------------------------
C
100	CONTINUE
C
c
c	Refresh options menu
c
	if( new_menu ) then
	    key = ' '
	    iop = IMENU_VERTICAL1(menu,'+PQH1234567$'
     &	    ,nmenu,istatus_left-1,1,new_menu,iop,' Options ',key)
	endif
C
C
	IF( NEW_EVENT ) THEN
		ievent_offset_old = ievent_offset

		CALL GET_EVENT(IEVENT,IRECORD)
		IEVENT_OFFSET = IEVENT_START+(IEVENT_RECORD-IRECORD)
     &		*NP_RECORD

		ILO_LIMIT = max(IEVENT_OFFSET - NPRE_TRIGGER,1)
		IHI_LIMIT = ILO_LIMIT + NP_RECORD - 1

		i0 = max(i0 - ievent_offset_old + ievent_offset,ilo_limit)
		i1 = min(i0 + n_disp - 1,ihi_limit)
		n_disp = i1 - i0 + 1

		ICURSOR = (i1 + i0)/2

		NEW_EVENT = .FALSE.
		NEW_ANALYSIS = .TRUE.
		NEW_DISPLAY = .TRUE.
	ENDIF
C
	IF( NEW_DISPLAY ) THEN
C
C 	-- Draw display border and help information -------------------
C
	    CALL FILL_RECTANGLE(ISCREEN,IDISPLAY_AREA)
	    CALL DISPLAY_BOX(1,1,62,21)
	    CALL MOVE_CURSOR(2,1)
	    CALL DISPLAY_STRING(' Edit detected events ')
	    write( string, '(f5.0,a)') float(i0-ilo_limit)*dt,t_units
	    call move_cursor(2,21)
	    call display_string( string(1:8) )
	    write( string, '(f5.0,a)') float(i1-ilo_limit)*dt,t_units
	    call move_cursor(50,21)
	    call display_string( string(1:8) )
C
C --	    Display signal on screen
C		
	    call plot_channel( iscreen, idisplay_area, ibuffer,1,
     &	    1,i0, n_disp, iy_scale,iy_offset,icolour)
c
C		Draw zero, trigger level and vertical cursors
c
		CALL SET_WRITING_MODE(ISCREEN,3)
		call set_polyline_type(iscreen,3)

		call display_horizontal_cursor(iscreen,idisplay_area,
     &		ievent_zero,iy_scale,iy_offset )

		call display_horizontal_cursor(iscreen,idisplay_area,
     &		ievent_zero+itrigger_level,iy_scale,iy_offset )

c
c		Indicate analysis area limits
c
		icl = ia_start+ievent_offset
		if( (icl .ge. i0) .and. (icl.le.i1))
     &		call display_vertical_cursor(
     &		iscreen,idisplay_area,icl-i0+1,n_disp)

		icl = ia_end + ievent_offset
		if( (icl.ge.i0) .and. (icl.le.i1))
     &		call display_vertical_cursor(
     &		ISCREEN,idisplay_area,icl-I0+1,N_DISP)
c
c		Put readout cursor on-screen
c
		CALL SET_WRITING_MODE(ISCREEN,3)
		CALL SET_POLYLINE_TYPE(ISCREEN,1)
		icursor = max(min(icursor,i1),i0)
		IOLD_CURSOR = ICURSOR
		call display_vertical_cursor(
     &		ISCREEN,idisplay_area,iold_cursor-I0+1,N_DISP)
C	
		CALL SET_WRITING_MODE(ISCREEN,1)
		NEW_DISPLAY = .FALSE.
	ENDIF
C
	IF( NEW_ANALYSIS ) THEN
		CALL DISPLAY_BOX(1,22,62,25)
		WRITE(STRING,920) TIME_EVENT/1000.,PEAK,Y_UNITS
     &	,DURATION,T_UNITS,RISE_TIME,T_UNITS
920		FORMAT(' Time=',F7.2,'s Peak=',F8.2,A,' Dur=',F7.2,A
     &	,' Trise=',F6.2,A)
		CALL MOVE_CURSOR(2,23)
		CALL DISPLAY_STRING(STRING(1:59))
		WRITE(STRING,921) ZERO_CURRENT,Y_UNITS
     &	,AMP,Y_UNITS,CHAR(231),TAU,T_UNITS,R
921		FORMAT(' Zero=',F8.2,A,' Exp Fit: A=',F7.2,A
     &	,1X,A,'=',F7.2,A,' R=',F5.2)
		CALL MOVE_CURSOR(2,24)
		CALL DISPLAY_STRING(STRING(1:57))
		NEW_ANALYSIS = .FALSE.
	ENDIF
C
C -- Draw vertical readout cursor -------------------------------
C
	CALL SET_WRITING_MODE(ISCREEN,3)
	CALL display_VERTICAL_CURSOR(
     &	ISCREEN,idisplay_area,IOLD_CURSOR-I0+1,N_DISP)
	CALL display_VERTICAL_CURSOR(
     &	ISCREEN,idisplay_area,ICURSOR-I0+1,N_DISP)
	CALL SET_WRITING_MODE(ISCREEN,1)
	IOLD_CURSOR = ICURSOR
C
C	Display read-out values
C
	TIME = FLOAT(ICURSOR-ILO_LIMIT)*DT
	CURRENT = FLOAT(IBUFFER(ICURSOR)-IEVENT_ZERO)*BIT_CURRENT
	CALL DISPLAY_BOX(63,20,80,25)
	CALL SET_MARGINS(64,21,80,25)
	CALL MOVE_CURSOR(64,21)
	WRITE(STRING,905) IEVENT
905	FORMAT('Event ',I4)
	CALL DISPLAY_STRING(STRING(1:10))
	CALL NEW_LINE
	CALL DISPLAY_STRING(TYPE_LIST(IEVENT_TYPE))
	CALL NEW_LINE
	WRITE(STRING,906) 'Y:',CURRENT,Y_UNITS
906	FORMAT(A,F9.3,A)
	CALL DISPLAY_STRING(STRING(1:13))
	CALL NEW_LINE
	WRITE(STRING,906) 'T:',TIME,T_UNITS
	CALL DISPLAY_STRING(STRING(1:13))
	CALL SET_MARGINS(2,1,80,25)

c
c --- Readout cursor movement code --------------------------
c
c
c	Wait for user to press a key
c
	call wait_for_key( key, special )

	if( special .and. (key .eq. 'L') ) then
C	    <- = move cursor left 1 point
	    ICURSOR = max( ICURSOR - 1, ilo_limit )
	    IF(ICURSOR .LT. I0) THEN
		I0 = max(I0 - 40, ilo_limit)
		I1 = I0 + N_DISP - 1
		new_display = .TRUE.
	    ENDIF
	    iop = 0
	elseif( special .and. (key .eq. 'R') ) then
C	    -> = move cursor right 1 point
	    ICURSOR = min(ICURSOR + 1,ihi_limit)
	    IF(ICURSOR .GT. I1) THEN
		I1 = min(I1 + 40,ihi_limit)
		I0 = I1 - N_DISP + 1
		new_display = .TRUE.
	    ENDIF
	    iop = 0
	elseif( special .and. (key .eq. 'B') ) then
C	    CTRL <- = B Move cursor left 20 points
	    ICURSOR = max(ICURSOR - 20,ilo_limit)
	    IF(ICURSOR .LT. I0) THEN
		I0 = max(I0 - 40,ilo_limit)
		I1 = I0 + N_DISP - 1
		new_display = .TRUE.
	    ENDIF
	    iop = 0
	elseif( special .and. (key .eq. 'F') ) then
C	    CTRL -> = Move cursor right 20 points
	    ICURSOR = min( ICURSOR + 20, ihi_limit)
	    IF(ICURSOR .GT. I1) THEN
		I1 = min( I1 + 40, ihi_limit )
		I0 = I1 - N_DISP + 1
		new_display = .TRUE.
	    ENDIF
	    iop = 0
	else
C
c	    Present options menu and return "iop=1..14" if
c	    an option has been selected. "iop=0" if no selection
c
	    iop = IMENU_VERTICAL1(menu,'+PQH1234567$'
     &	    ,nmenu,istatus_left-1,1,new_menu,iop,' Options ',key)

	endif
c
c --- END of readout cursor code --------------------------
C
	IF(IOP .LE. 0) GOTO 100
	GOTO(1,2,3,4,5,6,7,8,9,10,11,12) IOP
C
C -- Expand display ----------------------------------------------
C
1	i00 = i0 - ilo_limit + 1
	call change_display_magnification( ibuffer(ilo_limit),
     &	i00,n_disp,iy_scale,iy_offset,min_y_scale,max_y_scale,
     &	icolour,idisplay_area(1), idisplay_area(2),
     &	idisplay_area(3)-idisplay_area(1),
     &	idisplay_area(4)-idisplay_area(2),np_record )
	i0 = i00 + ilo_limit - 1
	i1 = i0 + n_disp

	new_menu = .true.
	new_display = .true.
	GOTO 100
C
C -- PgUp - Read previous event 
C
2	IEVENT = max(1,IEVENT-1)
	NEW_EVENT = .TRUE.
	GOTO 100
C
C -- PgDn - Read next frame stored ---------------------------------
C
3	IEVENT = min(N_EVENTS,IEVENT+1)
	NEW_EVENT = .TRUE.
	GOTO 100	
C
C -- Home go to record
C
4	write(string,'('' Go to record (1-'',i5,'') ? '')') n_events
	call display_message(2,23,46,string(1:30),1)
	call get_number(r,1.,float(n_events),float(ievent))
	call erase_box(2,23,istatus_left-1,25)
	ievent = int(r)
	NEW_EVENT = .TRUE.
	GOTO 100
C
C -- F1 Reject event
C
5	IEVENT_TYPE = 1
	CALL PUT_EVENT( IEVENT )
	GOTO 100
C
C -- F2 Change event status
C
6	new_menu = .true.
	ievent_type = iwait_menu_vertical1(type_list,'12345',max_types,3,5
     &	,new_menu,iop,' Set Type ',key)
	new_menu = .true.
	new_display = .true.
	CALL PUT_EVENT( IEVENT )
	GOTO 100
C
C -- F3 - Save reading to table --------------------------------
C
7      N_TABLE = N_TABLE + 1
	TABLE(1,N_TABLE) = TIME
	TABLE(2,N_TABLE) = CURRENT
	GOTO 100
C
C -- F4 - View contents of time list ---------------------------------
C
8	CALL MOVE_CURSOR(3,3)
	CALL DISPLAY_STRING(
     &' Saved cursor values ')
	CALL LIST_TABLE(TABLE,MAX_COL,N_TABLE,14,3,3
     &,'Record No.       '//T_UNITS//'       '//C_UNITS)
	call erase_all
	new_menu = .true.
	new_display = .true.
	new_analysis = .true.
	GOTO 100
C
C -- F5 Plot screen -------------------------------------------------
C
9	write( string, '(a,'' Event '',i5,)') file_name,ievent
	call plot_display( ibuffer(i0), n_disp,
     &	iy_scale, min_y_scale, iy_offset, icolour,
     &	dt, 0., string )
	CALL ERASE_ALL
	new_display = .true.
	new_analysis = .true.
	new_menu = .true.
	GOTO 100
C
C -- F6 Set analysis limits
C
10	IF(ILAST_F5.EQ.IA_END) THEN
		IA_START = ICURSOR - IEVENT_OFFSET
		ILAST_F5 = IA_START
	ELSE
		IA_END = ICURSOR - IEVENT_OFFSET
		ILAST_F5 = IA_END
	ENDIF
	IF(IA_START.GT.IA_END) THEN
		IKEEP = IA_START
		IA_START = IA_END
		IA_END = IKEEP
	ENDIF
	NEW_DISPLAY = .TRUE.
	GOTO 100

C -- F7 Set zero level
C
11	IEVENT_ZERO = IBUFFER(ICURSOR)
	CALL PUT_EVENT(IEVENT)
	NEW_DISPLAY = .TRUE.
	GOTO 100

C
C
C -- Esc quit this option -------------------------------------------
C
12	RETURN
	END

